
;+
;NAME: 
; tplot_thm_gui_out
;
;PURPOSE:
; Checks for the presence of status bar and/or history window 
; objects from the THEMIS GUI and ouputs a message.  
;
;INPUT:
;  msg: A single string to send to the history window or status bar 
;  hwin: Object reference to the history window
;  sbar: Object reference to the status bar (message bar)
;
;NOTES:
; The order in which the history window and status bar are passed 
; in should be irrelevant.
;
;-

pro tplot_thm_gui_out, msg, hwin, sbar

    compile_opt idl2, hidden

  
  if size(msg,/type) ne 7 || n_elements(msg) ne 1 then return

  h = arg_present(hwin) && obj_valid(hwin) &&  $
      (obj_isa(hwin,'THM_UI_HISTORY') or obj_isa(hwin,'THM_UI_MESSAGE_BAR')  )
  s = arg_present(sbar) && obj_valid(sbar) &&  $
      (obj_isa(sbar,'THM_UI_HISTORY') or obj_isa(sbar,'THM_UI_MESSAGE_BAR')  )

  if s || h then begin

    tr = scope_traceback(/struct)
    ntr = n_elements(tr)
    pref = ntr lt 2 ? '' : tr[ntr-2].routine + ': '
  
    if h then hwin -> update, pref + msg
    if s then sbar -> update, pref + msg
    
  endif

end
