;+
;PROCEDURE: tsmooth_in_time, varname, dt, newname = newname
;PURPOSE:
; Calls smooth_in_time function on a plot variable
;INPUT:
; varname = variable passed to get_data, example - thg_mag_ccnv
; dt = the averaging time (in seconds)
;KEYWORDS:
; newname: set output variable name
;THEMIS DEVELOPER KEYWORDS:
;  hwin: object reference to the THEMIS GUI history window
;  sbar: object reference to the status bar object

; 
;HISTORY:
; 11-apr-2008, jmm, jimm@ssl.berkeley.edu
;
;$LastChangedBy: aaflores $
;$LastChangedDate: 2011-11-17 14:19:54 -0800 (Thu, 17 Nov 2011) $
;$LastChangedRevision: 9307 $
;$URL: svn+ssh://thmsvn@ambrosia.ssl.berkeley.edu/repos/ssl_general/trunk/misc/tsmooth_in_time.pro $
;-

Pro tsmooth_in_time, varname, dt, newname = newname, _extra = _extra,interactive_warning=interactive_warning,warning_result=warning_result, sbar=sbar, hwin=hwin

  get_data, varname, data = data, dlimits = dlimits, limits = limits
  If(is_struct(data) Eq 0) Then Begin
    msg = 'No data in '+varname
    message, /info, msg
    tplot_thm_gui_out, msg, hwin, sbar
  Endif Else Begin
    y1 = smooth_in_time(data.y, data.x, dt, _extra = _extra,interactive_warning=keyword_set(interactive_warning),warning_result=warning_result, sbar=sbar, hwin=hwin)
    if warning_result eq 0 then return
    str_element, data, 'v', success = ok
    If(ok Eq 0) Then data1 = {x:data.x, y:y1} $
    Else data1 = {x:data.x, y:y1, v:data.v}
    If(keyword_set(newname)) then name2 = newname $
    Else name2 = varname+'_smoothed'
    store_data, name2, data = data1, dlimits = dlimits, limits = limits
  Endelse
End
