;+
;Function: rbsp_config_filedir.pro
;Purpose: Get the applications user directory for RBSP data analysis software
;
;$LastChangedBy: peters $
;$LastChangedDate: 2011-07-01 13:20:16 -0700 (Fri, 01 Jul 2011) $
;$LastChangedRevision: 8770 $
;$URL: svn+ssh://thmsvn@ambrosia.ssl.berkeley.edu/repos/ssl_general/trunk/missions/rbsp/rbsp_config_filedir.pro $
;-

Function rbsp_config_filedir, app_query = app_query, _extra = _extra

  readme_txt = ['Directory for configuration files for use by ', $
                'the RBSP Data Analysis Software']

  If(keyword_set(app_query)) Then Begin
    tdir = app_user_dir_query('rbsp', 'rbsp_config', /restrict_os)
    If(n_elements(tdir) Eq 1) Then tdir = tdir[0] 
    Return, tdir
  Endif Else Begin
    Return, app_user_dir('rbsp', 'RBSP Configuration Process', $
                         'rbsp_config', $
                         'RBSP configuration Directory', $
                         readme_txt, 1, /restrict_os)
  Endelse

End
