;+
; Loads Fast Data
; Usage:
;    fa_k0_load,'ees'
;    fa_k0_load,'ies'
;    fa_k0_load,'dcf'
; Davin Larson
;-
pro fa_k0_load,types,trange=trange,source=source,version=version

subdir = 'misc/'
subdir = ''

if size(/type,source) ne 8 then begin
    source = file_retrieve(/structure_format)
    source.remote_data_dir = 'http://sprg.ssl.berkeley.edu/data/'
    source.local_data_dir = root_data_dir()
    file_open,'d',source.local_data_dir,/test,createable=ct
    source.no_download = ct eq 0
endif


;tb = scope_traceback(/structure)
;lvl = n_elements(tb)-1
;dir = file_dirname(tb[lvl].filename)
;printdat,dir
;odat = read_asc(dir+'/fa_orbit_time.txt',format={time:0d,orbit:0.},/conv_time)
;odat = odat[sort(odat.time)]
;printdat,odat

tr=timerange(trange)
orbits = fa_orbit_time(tr)   ; interp(odat.orbit,odat.time,tr)
orbit_range = long(orbits+[-.5,.5])
n_orbits = orbit_range[1]-orbit_range[0]+1
orbits = string(lindgen(n_orbits) + orbit_range[0],format='(i05)')

if not keyword_set(types) then types = ['ees','ies']

for i=0,n_elements(types)-1 do begin
   type = types[i]
   case type of
       'ees': vxx = 'v03'
       'ies': vxx = 'v03'
       'dcf': vxx = 'v02'
       'acf': vxx = 'v03'
       'tms': vxx = 'v04'
       else : vxx = 'v0?'
   endcase
   if keyword_set(version) then vxx = version
   relpathnames = subdir + 'fast/k0/'+type+'/fa_k0_'+type+'_'+orbits+'_'+vxx+'.cdf'

   files = file_retrieve(relpathnames,_extra=source)
   if keyword_set(downloadonly) then continue
   cdf2tplot,file=files,/all,verbose=verbose,varformat='*' ,prefix = 'fa_'    ; load data into tplot variables
endfor

end
