;+
;NAME:
; tpwrspc
;PURPOSE:
; wapper for pwrspc.pro allowing input of a tplot variable name
;CALLING SEQUENCE:
; tpwrspc, varnames, newname=newname,_extra=_extra
;INPUT:
; varname = one tplot variable name
;KEYWORDS:
; newname = if set,give this name to the new data, the
;           default is to append '_pwrspc' to the input name and
;           pass out the name in the newname variable,
;           Unless /overwrite is set
; overwrite = if set, write the new data back to the old tplot
;             variable, do not set this with newname
;HISTORY:
; 27-mar-2007, jmm, jimm.ssl.berkeley.edu
;
;$LastChangedBy$
;$LastChangedDate$
;$LastChangedRevision$
;$URL$
;-
Pro tpwrspc, varname, newname = newname, $
             trange = trange, _extra = _extra

;First extract the data
  If(keyword_set(newname)) Then begin
    If(keyword_set(overwrite)) Then begin
      message, /info, 'Do not set both the newname and overwrite keywords'
      return
    Endif
    nvn = newname
  Endif Else nvn = varname+'_pwrspc'
;Now do the power spectrum
  get_data, varname, data = d, dlim = dlim, lim = lim
  If(is_struct(d)) Then Begin
    y = d.y
    t = (d.x-d.x[0])
    If(n_elements(trange) Eq 2) Then Begin
      tr = time_double(trange)
      ok = where(d.x Ge tr[0] And d.x Lt tr[1], nok)
      If(nok Eq 0) Then Begin
        message, /info, 'No data in time range'
        print, time_string(tr)
        message, /info, 'No Power spectrum for: '+varname
        Return
      Endif Else Begin
        t = t[ok] & y = y[ok]
      Endelse
    Endif
    t00 = d.x[0]
    pwrspc, t, y, f, p, _extra = _extra
    d = {x:temporary(f), y:temporary(p)}
    If(keyword_set(overwrite)) Then newname = varname $
    Else newname = nvn
    str_element, dlim, 'data_type', 'power_spectrum', /add
    str_element, dlim, 'xtitle', 'Freq (Hz)'
    store_data, newname, data = d, dlim = dlim, lim = lim
    xlim, newname, min(d.x), max(d.x), 0
    options, newname, spec = 0, ylog = 1, ystyle = 1, $
      yrange = [min(d.y), max(d.y)], $
      xrange = [min(d.x), max(d.x)]
   Endif Else Begin
    message, /info, 'No Power spectrum for: '+varname
  Endelse
  newname = nvn
  Return
End

