;+
;Procedure: WI_3DP_LOAD
;
;Purpose:  Loads WIND 3DP data
;
;keywords:
;   TRANGE= (Optional) Time range of interest  (2 element array).
;   /VERBOSE : set to output some useful info
;Example:
;   wi_3dp_load
;Notes:
;  This routine is still in development.
; Author: Davin Larson
;
; $LastChangedBy: davin-win $
; $LastChangedDate: 2008-07-07 14:12:39 -0700 (Mon, 07 Jul 2008) $
; $LastChangedRevision: 3253 $
; $URL $
;-
pro wi_3dp_load,type,files=files,trange=trange,verbose=verbose,downloadonly=downloadonly, $
      varformat=varformat,datatype=datatype, $
      addmaster=addmaster,tplotnames=tn,source=source

if not keyword_set(datatype) then datatype = 'k0'

wind_init
if not keyword_set(source) then source = !wind
    masterfile=''

case datatype of
  'k0':  begin
    pathformat = 'wind/3dp/k0/YYYY/wi_k0_3dp_YYYYMMDD_v??.cdf'
    if not keyword_set(varformat) then  varformat = 'ion_density ion_vel ion_temp'
    if not keyword_set(prefix) then prefix = 'wi_3dp_k0_'
  end

  'pm': begin
    pathformat = 'wind/3dp/pm/YYYY/wi_pm_3dp_YYYYMMDD_v03.cdf'
    if not keyword_set(varformat) then varformat = '?_* TIME'
    if not keyword_set(prefix) then prefix = 'wi_3dp_pm_'
  end

  'elpd': begin
    pathformat = 'wind/3dp/elpd/YYYY/wi_elpd_3dp_YYYYMMDD_v0?.cdf'
    if not keyword_set(varformat) then varformat = 'FLUX EDENS TEMP QP QM QT MAGF TIME'
    if not keyword_set(prefix) then prefix = 'wi_3dp_elpd_'
    addmaster=1
  end

  'sfpd': begin
    pathformat = 'wind/3dp/sfpd/YYYY/wi_sfpd_3dp_YYYYMMDD_v0?.cdf'
    if not keyword_set(varformat) then varformat = '*'  ; 'FLUX EDENS TEMP QP QM QT MAGF TIME'
    if not keyword_set(prefix) then prefix = 'wi_3dp_sfpd_'
;    addmaster=0
  end

  'sfsp': begin
    pathformat = 'wind/3dp/sfsp/YYYY/wi_sfsp_3dp_YYYYMMDD_v0?.cdf'
    if not keyword_set(varformat) then varformat = '*'  ; 'FLUX EDENS TEMP QP QM QT MAGF TIME'
    if not keyword_set(prefix) then prefix = 'wi_3dp_sfsp_'
;    addmaster=0
  end

endcase

relpathnames = file_dailynames(file_format=pathformat,trange=trange,addmaster=addmaster)

files = file_retrieve(relpathnames, _extra=source,/last_version)
if keyword_set(masterfile) then files= [masterfile,files]

if keyword_set(downloadonly) then return

cdf2tplot,file=files,varformat=varformat,verbose=verbose,prefix=prefix ,tplotnames=tn    ; load data into tplot variables

; Set options for specific variables


if datatype eq 'pad' then begin
   reduce_pads,'wi_3dp_elpd_FLUX',1,4,4
   reduce_pads,'wi_3dp_elpd_FLUX',2,0,0
   reduce_pads,'wi_3dp_elpd_FLUX',2,7,7
endif
options,/def,strfilter(tn,'wi_3dp_ion_vel',delim=' ') , colors='bgr', labels=['Vx','Vy','Vz']   ; set colors for the vector quantities
;options,/def,strfilter(tn,'wi_mfi_BGSEc') , ytitle = 'WIND!CB (nT)'

dprint,dlevel=3,'tplotnames: ',tn


end
