pro st_position_load,  source_options=source_options,trange=trange,probe=probes,attitude=attitude

coord='GSE'

if not keyword_set(source_options) then begin
    stereo_init

    source_options = file_retrieve(/struct)
    source_options.local_data_dir = !stereo.local_data_dir  ; root_data_dir()+'stereo/'
    source_options.remote_data_dir = 'http://www.srl.caltech.edu/STEREO2/'  ;  'behind/position_behind_2006_GSE.txt
    source_options.min_age_limit = 24*3600d  ; check no more often than once every 24 hours
endif
mystereo = source_options
;mystereo.remote_data_dir = 'http://www.srl.caltech.edu/STEREO2/Position/'  ;  'behind/position_behind_2006_GSE.txt


if not keyword_set(probes) then probes = ['a','b']
;if not keyword_set(type) then type = 'DIST'
;if not keyword_set(ver) then ver='V02'
;scale = 6400d

res = 3600l*24 *365.25    ; one year resolution in the files
tr = timerange(trange)
n = ceil((tr[1]-tr[0])/res)  > 1
dates = dindgen(n)*res + tr[0]
;tr = time_string(timerange(trange),prec=-5)
;tr = time_struct(timerange(trange))
;years = tr.year
;ny = (year[1]-year[0]) + 1

for p=0,n_elements(probes)-1 do begin
   probe = probes[p]
   pref = 'st'+probe+'_' + (keyword_set(burst) ? '_b' : '')
   case probe of
     'a' :  path = 'Position/ahead/position_ahead_YYYY_GSE.txt'
     'b' :  path = 'Position/behind/position_behind_YYYY_GSE.txt'
   endcase
   nv = 3
   tlabel = '_pos_GSE'
   scale = 6400.
   if keyword_set(attitude) then begin
     case probe of
       'a' :  path = 'Pointing/ahead/pointing_ahead_YYYY_RTN.txt'
       'b' :  path = 'Pointing/behind/pointing_behind_YYYY_RTN.txt'
     endcase

     nv = 9
     tlabel = '_point_RTN'
     scale = 1.
   endif

   relpathnames= time_string(dates,tformat= path)
   relpathnames = relpathnames[uniq(relpathnames)]

   files = file_retrieve(relpathnames,_extra = mystereo)


   fformat = {year:0l, doy:0l,  sod:0l, flag:0,  pos:dblarr(nv)}
   data = 0
   for i=0,n_elements(files)-1 do $
      data = read_asc(files[i],format=fformat,append=data)

   tstr = replicate( time_struct(0d), n_elements(data) )
   tstr.year = data.year  & tstr.date=data.doy & tstr.fsec=data.sod & tstr.month=1

   store_data,'st'+probe+tlabel,data={x:time_double(tstr),y:transpose(data.pos/scale)},dlimit={ystyle:2}

endfor




end