
pro st_part_moments,probe=probe,dopad=dopad,bins=bins,esteps=esteps

   nan = !values.f_nan
   units='eflux'
   times = st_swea_dist(probe=probe,/time)
   nt = n_elements(times)
   moms = replicate(moments_3d(),nt)
   pads = replicate(nan,nt,16,8)
   if keyword_set(bins) then begin
      adist = replicate(nan,nt,16)
      if n_elements(bins) gt 1 then wbins=where(bins) else wbins = indgen(80)
   endif
   pads_ang = pads
   for i=0,nt-1 do begin
      dat = st_swea_dist(probe=probe,index=i)
      dat.sc_pot = 15
      if keyword_set(moms) then   moms[i] = moments_3d( dat )
      udat = conv_units(dat,units)
      if keyword_set(bins) then begin
         adist[i,*] = average(udat.data[*,wbins],2)
      endif
      if  keyword_set(dopad) then begin
         pd = pad(udat)
         pads[i,*,*] = pd.data
         pads_ang[i,*,*] = pd.angles
      endif
   dprint,i,' of ',nt,dwait=5.
   endfor
   tnam = strlowcase(tag_names(moms))
   mindex = strfilter(tnam,'time,valid,mass',delimiter=',',/negate,/index)

   for m = 0,n_elements(mindex)-1 do begin
      mdat = moms.(mindex[m])
      if size(/n_dimen,mdat) eq 2 then mdat = transpose(mdat)
      store_data,'st'+probe+'_mom_'+tnam[mindex[m]],data={x:moms.time,y:mdat}
   endfor
   if keyword_set(dopad) then begin
      energy = average(pd.energy,2)
      angle = average(pads_ang,2)
      store_data,'st'+probe+'_pad',data={x:times,y:pads,v1:energy,v2:angle},dlimit={spec:1}
   endif
   if keyword_set(adist) then begin
      energy = average(udat.energy,2)
      ;angle = average(pads_ang,2)
      store_data,'st'+probe+'_en',data={x:times,y:adist,v:energy},dlimit={spec:1,ylog:1,zlog:1}
   endif

end


