;+
;Procedure: st_mag_load
;
;Purpose:  Loads stereo mag data
;keywords:
;   TRANGE= (Optional) Time range of interest  (2 element array).
;   /VERBOSE : set to output some useful info
;
;Example:
;   st_mag_load,probe='a'
;Notes:
;  This routine is (should be) platform independent.
;
;
; $LastChangedBy:  $
; $LastChangedDate:  $
; $LastChangedRevision: $
; $URL:$
;-
pro st_mag_load,all=all,trange=trange,verbose=verbose,version = ver,probes=probes

if not keyword_set(source_options) then begin
    stereo_init
    source_options = !stereo
endif
mystereo = source_options

vb =mystereo.verbose

if not keyword_set(probes) then probes = ['a','b']
type=''

if not keyword_set(ver) then ver='V03'

res = 3600l*24     ; one day resolution in the files
tr = timerange(trange)
n = ceil((tr[1]-tr[0])/res)  > 1
dates = dindgen(n)*res + tr[0]

for i=0,n_elements(probes)-1  do begin
   probe = probes[i]
   pref = 'st'+probe+'_' + (keyword_set(burst) ? '_b' : '')
   case probe of
   'a' :  path = 'impact/level1/ahead/mag/YYYY/MM/STA_L1_MAG'+type+'_YYYYMMDD_'+ver+'.cdf'
   'b' :  path = 'impact/level1/behind/mag/YYYY/MM/STB_L1_MAG'+type+'_YYYYMMDD_'+ver+'.cdf'
   endcase

   relpathnames= time_string(dates,tformat= path)

   files = file_retrieve(relpathnames,_extra = !stereo)

   cdf2tplot,tplotnames=tn,file=files,all=all,verbose=vb ,prefix=pref ,/get_support   ; load data into tplot variables
   options,/def,strfilter(tn,'*_B_*'),colors='bgr'
   options,/def,strfilter(tn,'*_B_RTN'),labels=['R','T','N']
   options,/def,strfilter(tn,'*_B_SC'),labels=['X','Y','Z']

endfor


end
