;+
;PROCEDURE: thigh_pass_filter, varname, dt, newname = newname
;PURPOSE:
; Calls running averge subroutine
;INPUT:
; varname = variable passed to get_data, example - thg_mag_ccnv
; dt = the averaging time (in seconds)
;KEYWORDS:
; newname: set output variable name
; 
;HISTORY:
; 14-jan-2008, jmm, jimm@ssl.berkeley.edu
; 06-feb-2008, teq, teq@ssl.berkeley.edu
;
;$LastChangedBy$
;$LastChangedDate$
;$LastChangedRevision$
;$URL$
;-

Pro thigh_pass_filter, varname, dt, newname = newname

  get_data, varname, data = data, dlimits = dlimits, limits = limits
  If(is_struct(data) Eq 0) Then Begin
    message, /info, 'No data in '+varname
  Endif Else Begin
    y1 = high_pass_filter(data.y, data.x, dt)
    str_element, data, 'v', success = ok
    If(ok Eq 0) Then data1 = {x:data.x, y:y1} $
    Else data1 = {x:data.x, y:y1, v:data.v}
    If(keyword_set(newname)) then name2 = newname $
    Else name2 = varname+'_hpfilt'
    store_data, name2, data = data1, dlimits = dlimits, limits = limits
  Endelse
End
