;+
;NAME:
; high_pass_filter
;PURPOSE:
; subtracts running average from a data array
;CALLING SEQUENCE:
; y = high_pass_filter(array, time_array, no_time_interp=no_time_interp)
;INPUT:
; array = a data array
; time_array = a time array (in units of seconds)
; dt = the averaging time (in seconds)
; no_time_interp = if set, do *not* interpolate the data to the
;                  minimum time resolution. The default procedure is
;                  to interpolate the data to a regularly spaced grid,
;                  and then use ts_smooth to get the running
;                  average. This alternative can be slow.
;OUTPUT:
; y = the data array where at each point an average of the data for
; the previous dt has been subtracted.
;HISTORY:
; 14-jan-2008, jmm, jimm@ssl.berkeley.edu
; 06-feb-2008, teq, teq@ssl.berkeley.edu
; 13-mar-2008, jmm, added the default behavior using interpolation
; 17-mar-2008, jmm, Gutted and rewritten to use smooth_in_time program
;$LastChangedBy$
;$LastChangedDate$
;$LastChangedRevision$
;$URL$
;-

Function high_pass_filter, array, time_array, dt, _extra = _extra
	;
	;; Declaring variable as -1 for later check
	;
  out_array = -1
	;
	;; determine number of rows in input array
	;; Note: this is a tplot array, reversed from
	;; idl array
	;
  n =  n_elements(array[*, 0])
	;
	;; Make sure time values exist for each entry
	;
  If(n_elements(time_array) Ne n) Then Begin
    message, /info, 'Array mismatch'
    return,  out_array
  Endif
;Call the smooth_in_time routine to get the running average
  av_array = smooth_in_time(array, time_array, dt, /backward, $
                            /true_t_integration, _extra = _extra)
;And subtract, note that NaNs will remain NaN's
  If(n_elements(av_array) Eq n_elements(array)) Then $
    out_array = array-temporary(av_array)
  Return, out_array

End
      
      
