pro stereo_swea_dist3d__define,structdef=dat

nenergy = 16
nbins = 80
dims = [nenergy,nbins]

dat = {stereo_swea_dist3d, inherits dist3d, $
       mode:                 0    , $
       cnfg:                 0   ,$
       nspins:               0    ,  $
       data:    fltarr(dims)      , $
       energy:  fltarr(dims)    , $
       theta:   fltarr(dims)    , $
       phi:     fltarr(dims)    , $
       denergy: fltarr(dims)      , $
       dtheta:  fltarr(dims)    , $
       dphi:    fltarr(dims)    , $
 ;      domega:  fltarr(dims)     ,$
       bins:    intarr(dims)     ,$
       gf:      fltarr(dims)     ,$
       integ_t: fltarr(dims)    , $
       dt:      fltarr(dims)    , $
       deadtime:fltarr(dims)    , $
       eff:     fltarr(dims)    , $
       geomfactor: !values.f_nan  ,  $
       atten:   -1   $
       }
dat.nenergy = nenergy
dat.nbins = nbins

end





function st_swea_dist,probe=probe,time,index=index,times=times,initilize=initilize

common stereo_swea_com, ptrs_a,ptrs_b,lastprobe,foo2,foo3,foo4

ptrs={probe:'',dat3d:{stereo_swea_dist3d} , $
   time:ptr_new(), data:ptr_new(), energy:ptr_new(), mag:ptr_new(), scpot:ptr_new() }
;ptrs = {probe:'',  dist:ptr_new(), mag:ptr_new() }

if not keyword_set(ptrs_a) then ptrs_a = ptrs
if not keyword_set(ptrs_b) then ptrs_b = ptrs
if not keyword_set(lastprobe) then lastprobe='a'

if not keyword_set(probe) then probe =  lastprobe
lastprobe = probe
stx = 'st'+probe

case probe of
  'a':  ptrs = ptrs_a
  'b':  ptrs = ptrs_b
  else: ptrs=0
endcase

if not keyword_set(ptrs) then begin
   dprint,"probe must be set to 'a' or 'b'"
   return,0
endif

if ~ptr_valid(ptrs.data) || keyword_set(initilize) then begin
   dprint, 'Initializing the 3D data'
   get_data,stx+'_Distribution',ptr = swea
   if ~ keyword_set(swea) then begin
      dprint,'No data loaded!'
      return,0
   endif
   ptrs.time = swea.x
   ptrs.data = swea.y
   ptrs.energy = swea.v1
   mag_rtn = data_cut(stx+'_B_SC',*swea.x)
   if keyword_set(mag_rtn) then begin
      rotmat1 = [[0,1d,0],[0,0,1d],[1d,0,0]]

;       p=+90-40.
;       p=0.
;
;      rotmat2 = [[cosd(p),sind(p),0],[-sind(p),cosd(p),0],[0,0,1]]
;      rotmat1 = rotmat2 ## rotmat1
      dprint,'determ=',determ(rotmat1)
      ptrs.mag = ptr_new( mag_rtn # rotmat1 )
      store_data,stx+'_B_inst',data={x:ptrs.time, y:ptrs.mag},dlim={colors:'bgr'}
      xyz_to_polar,stx+'_B_inst'
   endif else ptr_free,ptrs.mag

   nenergy = 16
   phi1 = (findgen(16)+.5)*22.5  + 90.-40.
   phip = (findgen(8)+.5) *45.   + 90.-40.
   if probe eq 'b' then begin
      phi1 += 180
      phip += 180
   endif

   theta1 = (findgen(6)-2.5)*22.5
   dtheta = replicate(22.5,6)
if 0 then begin      ; set to 1 to fill in polar sections
  theta1[0]  = -90+22.5   &  dtheta[0] = 45.
  theta1[5]  =  90-22.5   &  dtheta[5] = 45.
endif else begin
endelse
   dphi1 = [2,1,1,1,1,2] * 22.5
   i8 = intarr(8)
   i16 = intarr(16)
   allphi = [phip,phi1,phi1,phi1,phi1,phip]
   i80 = [replicate(0,8),replicate(1,16),replicate(2,16),replicate(3,16),replicate(4,16),replicate(5,8)]
   alltheta = theta1[i80]
   alldphi = dphi1[i80]
   alldtheta = dtheta[i80]

   nan = !values.f_nan
   dat3d = ptrs.dat3d
   dat3d.project_name = 'STEREO '+strupcase(probe)
   dat3d.data_name = 'SWEA'
   dat3d.units_name = 'counts'
   dat3d.units_procedure = 'st_swea_convert_units' ; 'ste_swea_convert_units'
   dat3d.nbins = 80
   dat3d.nenergy = 16
   dat3d.magf = nan
   dat3d.sc_pot = nan
   dat3d.mass = 511000./299792.^2
   dat3d.data = nan
   dat3d.energy = *(ptrs.energy) # replicate(1,80)
   dat3d.denergy = dat3d.energy *.2  ; should be fixed!
   dat3d.phi   = replicate(1,nenergy) # allphi
   dat3d.dphi  = replicate(1,nenergy) # alldphi
   dat3d.theta = replicate(1,nenergy) # alltheta
   dat3d.dtheta =replicate(1,nenergy) # alldtheta
   dat3d.geomfactor = 0.002 * 22.5 /360.
   dat3d.gf =  replicate(1,nenergy) # ([2,1,1,1,1,2])[i80]
   dat3d.integ_t = 2./16./7.
   dat3d.bins = 1
   ptrs.dat3d=dat3d
   dprint,'dat3d is now defined;'
   case probe of
     'a':  ptrs_a = ptrs
     'b':  ptrs_b = ptrs
   endcase
endif

if keyword_set(times) then return, *ptrs.time

if n_elements(index) eq 0 then begin
   if not keyword_set(time) then ctime,time,npoints=1
   if not keyword_set(time) then return,0
   index =  round(interp( indgen(n_elements(*ptrs.time) ), *ptrs.time, time ,/no_extrapolate))
endif

if n_elements(index) gt 1 then begin
    di = index[1]-index[0]+1
    dprint,'Averaging 3D distributions...'
    for i=0,di-1 do $
        totdat = sum3d(totdat,st_swea_dist(probe=probe,index=index[i]))
    return,dat

endif

dat = ptrs.dat3d
dat.index = index
dat.time = (*ptrs.time)[index]
dat.end_time = dat.time + 2.
dat.data = transpose( reform((*ptrs.data)[index,*,*]))
dat.valid =1
if ptr_valid(ptrs.mag) then dat.magf = (*ptrs.mag)[index,*]

;dat.magf = [1,0,1.]

return,dat
end

