;+
;FUNCTION:  root_data_dir
;PURPOSE:  Returns the root data directory used by numerous file retrieval procedures.
;     By default it returns either:
;          for unix:    '/disks/data/' if it exists,  '~/data/' otherwise
;          for Windows: 'e:/data/' if it exists,   'c:/data/' otherwise
;
;     These data sets can grow to very large size. These defaults are intended to allow multiple
;     users to share a common data directory system.
;
;     It is recommended that PC users create a separate partition (e:/data/) to store files so that
;     file backups do not have to include these large (easily replaced) files.
;
;     On multiple user unix systems it is recommended to setup permissions so that all (or group) users
;     can write into sub-directories and update (overwrite) data files.
;
;CHANGING THE DEFAULT:
;     The default directory can be changed by creating an environment variable: 'ROOT_DATA_DIR'
;     Example 1:
;          setenv,'ROOT_DATA_DIR=/mydata/'
;     Example 2:  A temporary directory:
;          setenv,'ROOT_DATA_DIR=' + getenv('IDL_TMPDIR') + 'data/'     ; trailing '/' IS required.
;
;     Notes:
;     1)  The environment variable should be set prior to running initialization routines (put it in your IDL_STARTUP file)
;     2)  The trailing '/' is required!    PC users should also use '/'   (not backslash: '\')
;     3)  The total size of all files can grow immense and there is no need to back them up.
;            We suggest placing them on a partition that is not backed up
;     4)  File storage space can be shared with other users if a commonly accessible data directory is chosen.
;     5)  Use a temporary directory if you do not want to permanently store these cached files.
;
;This routine is called by:
;    wind_init
;    istp_init
;    stereo_init
;    lanl_spa_load
;    thm_config (through thm_init)
;
;
;$LastChangedBy: davin-win $
;$LastChangedDate: 2008-07-14 14:14:38 -0700 (Mon, 14 Jul 2008) $
;$LastChangedRevision: 3272 $
;$URL: svn+ssh://thmsvn@ambrosia.ssl.berkeley.edu/repos/ssl_general/trunk/missions/root_data_dir.pro $
;-


function root_data_dir

  rootdirs = strsplit(/extract,getenv('ROOT_DATA_DIR'),path_sep(/search_path) ,count=n )
  for i=0,n-1 do begin
      rootdir = rootdirs[i]
      if file_test(/direc,rootdir) then break
  endfor
  if not keyword_set(rootdir) then begin

     case !version.os_family of
      'Windows': begin
          if file_test(/directory,'e:/data/') then  rootdir = 'e:/data/'  $
          else  rootdir = 'c:/data/'
        end

      'unix' : begin
          if file_test(/directory,'/disks/data/') then rootdir = '/disks/data/' $
          else   rootdir = '~/data/'
        end
       else :  rootdir = getenv('IDL_TMPDIR')+'data/'

     endcase

  endif
  return,rootdir
end


