;+
;PROCEDURE:  stereo_init
;PURPOSE:    Initializes various

;-
pro stereo_init,reset=reset

defsysv,'!stereo',exists=exists
if not keyword_set(exists) then begin
   defsysv,'!stereo',file_retrieve(/structure_format)
endif

if keyword_set(reset) then !stereo.init=0

if !stereo.init ne 0 then return

!stereo = file_retrieve(/structure_format)
!stereo.local_data_dir = root_data_dir() + 'stereo/'
!stereo.remote_data_dir = 'http://sprg.ssl.berkeley.edu/data/stereo/'

if file_test(!stereo.local_data_dir+'.htpasswd') then !stereo.no_download=1   ; Detects master directory at SSL

libs,'stereo_config',routine=name
if keyword_set(name) then call_procedure,name

!stereo.init=1

printdat,/values,!stereo,varname='!stereo'

end

