;st_crib.pro




pro rotation_finder,name ,deltat=deltat
names=tnames(name,n)
if not keyword_set(deltat) then deltat=10.
for i=0,n-1 do begin
   get_data,names[i],data=d
   dt = median(d.x-shift(d.x,1))
   n = ceil(deltat/dt)
   b = smooth(d.y,[n,0],/nan)
   b1 = shift(b,-n,0)
   b2 = shift(b,n,0)
   angle = acos(total((b1*b2),2) / sqrt(total(b1^2,2)*total(b2^2,2)) ) *180/!pi
   store_data,names[i]+'_drot',data={x:d.x, y:angle}
endfor

end






if 0 then begin
timespan,'6-12-13'   ; - CME
timespan,'7-3-9'
timespan,'7-3-29'
timespan,'7 4 13',2
timespan,'7-5-1',2   ;- CME
timespan,'7-5-21',2  ; MC
timespan,'7-11-20',1 ; MC
endif



tspan = timerange()
if ~keyword_set(lasttspan) ||  ~array_equal(tspan,lasttspan) then begin
   if n_elements(dopad) eq 0 then dopad=1
   probe = 'b'
   lasttspan = tspan
   st_mag_load
   xyz_to_polar,'st?_B_SC'
   xyz_to_polar,'st?_B_RTN'
   options,'st?_B_inst_th',constant=[-60,60.],yrange=[-90,90],/ystyle
   st_swea_load
   wi_mfi_load
   wi_swe_load
   st_part_moments,probe='a',dopad=dopad
;   reduce_pads,'sta_pad',1,4,4
;   reduce_pads,'sta_pad',2,0,0
;   reduce_pads,'sta_pad',2,7,7

   st_part_moments,probe='b',dopad=dopad
;   reduce_pads,'stb_pad',1,4,4
;   reduce_pads,'stb_pad',2,0,0
;   reduce_pads,'stb_pad',2,7,7

   ;l = tnames(/tplot)

  ; tplot ,'wi_??_mfi_B3GSE st?_B_SC st?_s'
; tplot,'st?_B_inst_* st?_pad-1-4:4'
; tplot,'sta_B_inst_* sta_pad-1-4:4'
; tplot,'stb_B_inst_* stb_pad-1-4:4'

; tplot,'STA_B_inst_theta STA_B_inst_phi sta_B_inst_mag sta_pad-1-4:4'
; tplot,'stb_B_inst_* stb_pad-1-4:4'

; tplot,'sta_B_RTN* sta_pad-1-4:4 sta_mom_density
; tplot,'stb_B_RTN* stb_pad-1-4:4 stb_mom_density
; tplot,'sta_pad-* sta_mom_density sta_B_RTN*
; tplot,'stb_pad-* stb_mom_density stb_B_RTN*


endif
ctime,t,/silent
data = st_swea_dist(probe='a',t,initi=ii)

if not keyword_set(lim) then begin
   xlim,lim,1,2000,1
   ylim,lim,1e5,1e9,1
   units,lim,'eflux'
endif

wi,1,wsize=[500,500]   &  spec3d, data,lim=lim  & wshow
wi,2,wsize=[500,400]   &  plot3d, data,/zero  & wshow
datb = st_swea_dist(probe='b',t,initi=ii)
wi,3,wsize=[500,500]   &  spec3d, datb,lim=lim  & wshow
wi,4,wsize=[500,400]   &  plot3d, datb,/zero  & wshow
timebar,t


;eflux_a = conv_units(data)
pd = pad(conv_units(data))
;  pd = pad2(conv_units(data),vsw=[0,0,500.]);wi,3   &  spec3d, pd


if 0 then begin   ;  .run
split_vec,'st?_mom_velocity'
options,'sta_mom_*',colors='r'
options,'stb_mom_*',colors='b'
store_data,'STA_B_inst_theta',data=tnames('sta_mom_symm_theta sta_B_inst_th',/all)
store_data,'STA_B_inst_phi',data=tnames('sta_mom_symm_phi sta_B_inst_phi',/all)
store_data,'STX_Vx',data=tnames('st?_mom_velocity_x OMNI_HRO_?min_Vx',/all)
store_data,'STX_Vy',data=tnames('st?_mom_velocity_y OMNI_HRO_?min_Vy',/all)
store_data,'STX_Vz',data=tnames('st?_mom_velocity_z OMNI_HRO_?min_Vz',/all)

store_data,'STX_density',data=tnames('st?_mom_density OMNI_HRO_?min_proton_density'),dlim={ylog:1}

store_data,'STB_B_inst_theta',data=tnames('stb_mom_symm_theta stb_B_inst_th',/all)
store_data,'STB_B_inst_phi',data=tnames('stb_mom_symm_phi stb_B_inst_phi')
store_data,'STB_Vx',data=tnames('stb_mom_velocity_x OMNI_HRO_1min_Vx')
store_data,'STB_Vy',data=tnames('stb_mom_velocity_y OMNI_HRO_1min_Vy')
store_data,'STB_Vz',data=tnames('stb_mom_velocity_z OMNI_HRO_1min_Vz')
store_data,'STB_density',data=tnames('stb_mom_density OMNI_HRO_1min_proton_density')

tplot,'ST?_B_inst_theta ST?_B_inst_phi st?_mom_symm_ang'



endif



end





