;+
;Function: spice_body_att
;Purpose:  retrieve the rotation (array or quaternion) to transfer from one frame to another frame
;
;  Note: time is in the last dimension  (not like tplot storage)
; ;
; Author: Davin Larson  
; $LastChangedBy: $
; $LastChangedDate: $
; $LastChangedRevision: $
; $URL: $
;-

function spice_body_att,from,to,utc,quaternion=quaternion,baserot=baserot,fix_qsign=fix_qsign,rel2start=rel2start,check_objects=check_objects,verbose=verbose
ut = time_double(utc)
et = time_ephemeris(ut,/ut2et)

ns = n_elements(et)
if keyword_set(check_objects) then begin
  time_valid = spice_valid_times(et,object=check_objects,tol=tol) 
 ; printdat,check_objects,time_valid
  ind = where(time_valid ne 0,nind)
  dprint,dlevel=2,verbose=verbose,nind,' Valid times from:',check_objects
endif else begin
 ; nind = ns
  ind = lindgen((nind = ns))
endelse

res = replicate(!values.d_nan,3,3,ns)
if nind ne 0 then begin
     cspice_pxform,from,to,et[ind],temp    ; 3 element position? (online documentation is misleading)
 ;    cspice_spkpos,body_name,et[ind],frame,abcorr,obs_name, pos2, ltime2
     res[*,*,ind] = temp
endif else dprint,verbose=verbose,'No Valid CK frame for: ',check_objects


if keyword_set(quaternion) then begin
   dprint,dlevel=3,verbose=verbose,'Calculating Quaternions'
   if keyword_set(rel2start) then baserot = transpose(res[*,*,0])
   res = spice_m2q(res,fix_qsign=fix_qsign,baserot = baserot)
endif
return,res
end


