;+
; Procedure: RBSP_LOAD_SPICE_METAKERNEL
;
; Purpose:  Loads RBSP SPICE metakernels
;
; input:
; metakernel : full path to metakernel file for loading
; 
; keywords:
;	/UNLOAD : unloads all kernels loaded by the four RBSP metakernels
;   mkpath='/path/to/teams/spice/meta' : the full path to the teams/spice/meta
;		directory that contains the up-to-date metakernels from MOC
;
; Examples:
;   rbsp_load_spice_metakernel,/dev ; load development kernels
;	rbsp_load_spice_metakernel,/dev,/unload ; unload development kernels
;   rbsp_load_spice_kernels,/update ; update and load latest MOC kernels
;
;-
;
; History:
;	10/2012, created - Peter Schroeder, peters@ssl.berkeley.edu
;
;-


pro rbsp_load_spice_metakernel, metakernel, unload=unload,update=update

rbsp_spice_init

if(icy_test() eq 0) then return

file_open,'r',metakernel, unit=unit

line = ''
inblock = 0

while not eof(unit) do begin
  readf, unit, line
  if strmatch(line, '*KERNELS_TO_LOAD*') then inblock = 1
  if inblock then begin
    paren1 = strpos(line, "'")
    kerneltoload = strmid(line,paren1+1)
    paren2 = strpos(kerneltoload,"'")
    kerneltoload = strmid(kerneltoload,0,paren2)
    str_replace,kerneltoload,'$ROOT/',''
    str_replace,kerneltoload,'$RBSPA','MOC_data_products/RBSPA'
    str_replace,kerneltoload,'$RBSPB','MOC_data_products/RBSPB'
    str_replace,kerneltoload,'$CKP','attitude_predict'
    str_replace,kerneltoload,'$CKFULL','attitude_history_full'
    str_replace,kerneltoload,'$CKQUICK','attitude_history'
    str_replace,kerneltoload,'$FKG','teams/spice/fk'
    str_replace,kerneltoload,'$FK','frame_kernel'
    str_replace,kerneltoload,'$IK','teams/spice/ik'
    str_replace,kerneltoload,'$LSK','leap_second_kernel'
    str_replace,kerneltoload,'$PCK','teams/spice/pck'
    str_replace,kerneltoload,'$SCLK','operations_sclk_kernel'
    str_replace,kerneltoload,'$SPKPE','planetary_ephemeris'
    str_replace,kerneltoload,'$SPKP','ephemeris_predict'
    str_replace,kerneltoload,'$SPKD','ephemerides'
    if kerneltoload ne '' then begin
      files = file_retrieve(kerneltoload, _extra=!rbsp_spice)
      print,'Processing '+files[0]
      if keyword_set(unload) then cspice_unload,files $
        else cspice_furnsh,files
    endif
    if strmatch(line, '*)*') then inblock = 0
  endif
endwhile

free_lun,unit

end