;+
; Procedure: RBSP_LOAD_SPICE_KERNELS
;
; Purpose:  Loads RBSP SPICE kernels
;
; keywords:
;
; Examples:
;   rbsp_load_spice_kernels ; updates spice kernels based on MOC metakernels
;
; Notes:
;-
;
; History:
;	09/2012, created - Kris Kersten, kris.kersten@gmail.com
;	10/2012, substantially modified - Peter Schroeder, peters@ssl.berkeley.edu
;
;-


pro rbsp_load_spice_kernels, verbose = verbose, unload=unload

rbsp_spice_init

metaprefix = 'teams/spice/mk'

relpathnames = metaprefix + '/rbsp_meta_general.tm'
;relpathnames = file_dailynames(file_format=format,trange=trange,addmaster=addmaster)
dprint,dlevel=3,verbose=verbose,relpathnames,/phelp
files = file_retrieve(relpathnames, _extra=!rbsp_spice)

rbsp_load_spice_metakernel,files[0],unload=unload

relpathnames = metaprefix + '/rbsp_meta_time.tm'
;relpathnames = file_dailynames(file_format=format,trange=trange,addmaster=addmaster)
dprint,dlevel=3,verbose=verbose,relpathnames,/phelp
files = file_retrieve(relpathnames, _extra=!rbsp_spice)

rbsp_load_spice_metakernel,files[0],unload=unload

relpathnames = metaprefix + '/rbsp_meta_definitive.tm'
;relpathnames = file_dailynames(file_format=format,trange=trange,addmaster=addmaster)
dprint,dlevel=3,verbose=verbose,relpathnames,/phelp
files = file_retrieve(relpathnames, _extra=!rbsp_spice)

rbsp_load_spice_metakernel,files[0],unload=unload

end