;+
; NAME: rbsp_efw_cal_fbk
;
; PURPOSE: Calibrate RBSP filterbank data
;
; NOTES: This is meant to be called from rbsp_load_efw_fbk.pro
;
; sort out FBK source labels:
; note: Source selects for the Filter Bank:
;		0=E12DC
;		1=E34DC
;		2=E56DC
;		3=E12AC
;		4=E34AC
;		5=E56AC
;		6=SCMU
;		7=SCMV
;		8=SCMW
;		9=(V1DC+V2DC+V3DC+V4DC)/4
;		(default is 0)
;
;
;
; SEE ALSO:
;
; HISTORY:
;   2012-xx-xx: Created by Aaron W Breneman, University of Minnesota
;
; VERSION:
; $LastChangedBy:  $
; $LastChangedDate:  $
; $LastChangedRevision:  $
; $URL: svn+ssh://thmsvn@ambrosia.ssl.berkeley.edu/repos/ssl_general/trunk/missions/rbsp/efw/rbsp_efw_cal_fbk.pro $
;
;-

pro rbsp_efw_cal_fbk, probe=probe, trange=trange, datatype=datatype



if datatype ne 'fbk' then begin
	print,'NOT FILTERBANK DATA....ABORTING CALIBRATION'
	return
endif


	
compile_opt idl2

;dprint,verbose=verbose,dlevel=4,'$Id: rbsp_efw_cal_filterbank.pro 10920 2012-09-17 17:08:00Z aaron_breneman $'

if ~keyword_set(trange) then trange = timerange()

fbk_sources=['E12DC', 'E34DC', 'E56DC', 'E12AC', 'E34AC', 'E56AC', $
			'SCMU', 'SCMV', 'SCMW','VDC']

;Determine if we have fbk7, fbk13 or both
;	goo = tnames('*fbk_7*',count7)
;	goo = tnames('*fbk_13*',count13)


;Determine if the data are FB1 or FB2
; note: the fbk select variables come back as nX2 arrays, where [*,0] array is
;		the fb1 source as a function of time, and [*,1] is the fb2 source
	

get_data,'rbsp'+probe+'_efw_fbk_7_fbk_7_select',data=data7select
get_data,'rbsp'+probe+'_efw_fbk_13_fbk_13_select',data=data13select


if is_struct(data7select) then $
	source7=[fbk_sources[median(data7select.y[*,0])], fbk_sources[median(data7select.y[*,1])] ] $
	else source7=['','']
if is_struct(data13select) then $
	source13=[fbk_sources[median(data13select.y[*,0])], fbk_sources[median(data13select.y[*,1])] ] $
	else source13=['','']
	

;Determine if we have both fbk7 and fbk13 data or not.
;;;total_sources = is_struct(data7select) + is_struct(data13select)



cp0 = rbsp_efw_get_cal_params(trange[0])


case strlowcase(probe) of
  'a': cp = cp0.a
  'b': cp = cp0.b
  else: dprint, 'Invalid probe name. Calibration aborted.'
endcase

boom_length = cp.boom_length
boom_shorting_factor = cp.boom_shorting_factor

rbspx = 'rbsp' + probe[0]


	if source7[0] ne '' then source = source7 else source = source13

	
	gain = fltarr(2)
	unit = strarr(2)
	offset = fltarr(2)
	boomlength = fltarr(2)



	case source[0] of
	  'E12DC': begin
	  				gain[0] = cp.ADC_gain_EDC[0]
	  				offset[0] = cp.ADC_offset_EDC[0]
	  				unit[0] = 'mV/m'
	  				boomlength[0] = boom_length[0]
	  			end	
	  'E34DC': begin
	  				gain[0] = cp.ADC_gain_EDC[1]
	  				offset[0] = cp.ADC_offset_EDC[1]
	  				unit[0] = 'mV/m'
	  				boomlength[0] = boom_length[1]
			   end
	  'E56DC': begin
	  				gain[0] = cp.ADC_gain_EDC[2]
	  				offset[0] = cp.ADC_offset_EDC[2]
	  				unit[0] = 'mV/m'
	  				boomlength[0] = boom_length[2]
	  		   end
	  'E12AC': begin
	  				gain[0] = cp.ADC_gain_EAC[0]
	  				offset[0] = cp.ADC_offset_EAC[0]
	  				unit[0] = 'mV/m'
	  				boomlength[0] = boom_length[0]		
	  		   end
	  'E34AC': begin
	  				gain[0] = cp.ADC_gain_EAC[1]
	  				offset[0] = cp.ADC_offset_EAC[1]
	  				unit[0] = 'mV/m'
	  				boomlength[0] = boom_length[1]
	  		   end
	  'E56AC': begin
	  				gain[0] = cp.ADC_gain_EAC[2]
	  				offset[0] = cp.ADC_offset_EAC[2]
	  				unit[0] = 'mV/m'
	  				boomlength[0] = boom_length[2]
	  		   end
	  'SCMU':  begin
	  				gain[0] = cp.ADC_gain_MSC[0]
	  				offset[0] = cp.ADC_offset_MSC[0]
	  				unit[0] = 'nT'
	  				boomlength[0] = !values.f_nan
	  		   end
	  'SCMV':  begin
	  				gain[0] = cp.ADC_gain_MSC[1]
	  				offset[0] = cp.ADC_offset_MSC[1]
	  				unit[0] = 'nT'
	  				boomlength[0] = !values.f_nan
	  		   end
	  'SCMW':  begin
	  				gain[0] = cp.ADC_gain_MSC[2]
	  				offset[0] = cp.ADC_offset_MSC[2]
	  				unit[0] = 'nT'
	  				boomlength[0] = !values.f_nan
	  		   end
	  'VDC':   begin
	  				gain[0] = cp.ADC_gain_VDC[0] ;use the first of 6 gain settings
	  		   end
	  else: dprint, 'Invalid filterbank source. Calibration aborted.'
	endcase


	case source[1] of
	  'E12DC': begin
	  				gain[1] = cp.ADC_gain_EDC[0]
	  				offset[1] = cp.ADC_offset_EDC[0]
	  				unit[1] = 'mV/m'
	  				boomlength[1] = boom_length[0]
	  			end	
	  'E34DC': begin
	  				gain[1] = cp.ADC_gain_EDC[1]
	  				offset[1] = cp.ADC_offset_EDC[1]
	  				unit[1] = 'mV/m'
	  				boomlength[1] = boom_length[1]
			   end
	  'E56DC': begin
	  				gain[1] = cp.ADC_gain_EDC[2]
	  				offset[1] = cp.ADC_offset_EDC[2]
	  				unit[1] = 'mV/m'
	  				boomlength[1] = boom_length[2]
	  		   end
	  'E12AC': begin
	  				gain[1] = cp.ADC_gain_EAC[0]
	  				offset[1] = cp.ADC_offset_EAC[0]
	  				unit[1] = 'mV/m'
	  				boomlength[1] = boom_length[0]		
	  		   end
	  'E34AC': begin
	  				gain[1] = cp.ADC_gain_EAC[1]
	  				offset[1] = cp.ADC_offset_EAC[1]
	  				unit[1] = 'mV/m'
	  				boomlength[1] = boom_length[1]
	  		   end
	  'E56AC': begin
	  				gain[1] = cp.ADC_gain_EAC[2]
	  				offset[1] = cp.ADC_offset_EAC[2]
	  				unit[1] = 'mV/m'
	  				boomlength[1] = boom_length[2]
	  		   end
	  'SCMU':  begin
	  				gain[1] = cp.ADC_gain_MSC[0]
	  				offset[1] = cp.ADC_offset_MSC[0]
	  				unit[1] = 'nT'
	  				boomlength[1] = !values.f_nan
	  		   end
	  'SCMV':  begin
	  				gain[1] = cp.ADC_gain_MSC[1]
	  				offset[1] = cp.ADC_offset_MSC[1]
	  				unit[1] = 'nT'
	  				boomlength[1] = !values.f_nan
	  		   end
	  'SCMW':  begin
	  				gain[1] = cp.ADC_gain_MSC[2]
	  				offset[1] = cp.ADC_offset_MSC[2]
	  				unit[1] = 'nT'
	  				boomlength[1] = !values.f_nan
	  		   end
	  'VDC':   begin
	  				gain[1] = cp.ADC_gain_VDC[0] ;use the first of 6 gain settings
	  		   end
	  else: dprint, 'Invalid filterbank source. Calibration aborted.'
	endcase



	
	mVm = 1000./boomlength	

	
	if source7[0] ne '' then begin
		
		tvar = rbspx + ['_efw_fbk_7_fb1_av',$
						 '_efw_fbk_7_fb1_pk',$
						 '_efw_fbk_7_fb2_av',$
						 '_efw_fbk_7_fb2_pk']


		gains = [gain[0],gain[0],gain[1],gain[1]]		 
		offsets = [offset[0],offset[0],offset[1],offset[1]]
		sources = [source7[0],source7[0],source7[1],source7[1]]
		units = [unit[0],unit[0],unit[1],unit[1]]		
		mvms = [mvm[0],mvm[0],mvm[1],mvm[1]]
			
		for j=0,3 do begin
		
			get_data,tvar[j],data=data,dlim=dlim
	
	
			if dlim.data_att.units eq 'ADC' then begin
	
		
				tst = size(data)	
				;make sure there's data
				if tst[0] ne 0 then begin
		
		
					new_y = double(data.y)
					
					new_y =  (data.y - offsets[j]) * gains[j] * mVms[j]
					new_data = {x:data.x,y:new_y,v:data.v}
					dlim.data_att.units = units[j]
					colors = [1]
					
					str_element, dlim, 'cdf', /delete
					str_element, dlim, 'code_id', /delete
					
					newname = tvar[j]
					store_data, newname,data=new_data,dlim=dlim
					options, newname, labels = 'Fbk '+sources[j], colors = colors, $
						ysubtitle = '[' + units[j] + ']',labflag=1		
					options,newname,'ztitle',sources[j] + ' ' + units[j]
		
				endif
			
			endif else print,tvar[j] + ' is already calibrated'
	
		endfor
	endif 
	
	
	
	if source13[0] ne '' then begin
	
	tvar = rbspx + ['_efw_fbk_13_fb1_av',$
					 '_efw_fbk_13_fb1_pk',$
					 '_efw_fbk_13_fb2_av',$
					 '_efw_fbk_13_fb2_pk']

	gains = [gain[0],gain[0],gain[1],gain[1]]		 

	offsets = [offset[0],offset[0],offset[1],offset[1]]
	sources = [source13[0],source13[0],source13[1],source13[1]]
	units = [unit[0],unit[0],unit[1],unit[1]]		
	mvms = [mvm[0],mvm[0],mvm[1],mvm[1]]
	
	for j=0,3 do begin
	
		get_data,tvar[j],data=data,dlim=dlim
	
	
		if dlim.data_att.units eq 'ADC' then begin
	
	
			tst = size(data)
			
			;make sure there's data
			if tst[0] ne 0 then begin
		
	
					new_y = double(data.y)
					
					new_y =  (data.y - offsets[j]) * gains[j] * mVms[j]
					new_data = {x:data.x,y:new_y,v:data.v}
					dlim.data_att.units = units[j]
					colors = [1]
					
					str_element, dlim, 'cdf', /delete
					str_element, dlim, 'code_id', /delete
					
					newname = tvar[j]
					store_data, newname,data=new_data,dlim=dlim
					options, newname, labels = 'Fbk '+sources[j], colors = colors, $
						ysubtitle = '[' + units[j] + ']',labflag=1		
					options,newname,'ztitle',sources[j] + ' ' + units[j]
		 
		
			endif
	
		endif else print,tvar[j] + ' is already calibrated'
	
	
	endfor
	
	endif
	



;---------------------------------------------------
;Define filterbank frequencies and label plot y-axis 
;---------------------------------------------------


;fbk13_bins=['0.8-1.5Hz', '1.5-3Hz', '3-6Hz', '6-12Hz', '12-25Hz', '25-50Hz', $
;			'50-100Hz', '100-200Hz', '200-400Hz', '400-800Hz', $
;			'0.8-1.6kHz', '1.6-3.2kHz', '3.2-6.5kHz']
;fbk7_bins=fbk13_bins[lindgen(7)*2]


fbk13_binsL = [0.8,1.5,3,6,12,25,50,100,200,400,800,1600,3200]
fbk13_binsH = [1.5,3,6,12,25,50,100,200,400,800,1600,3200,6500]
fbk7_binsL = fbk13_binsL[lindgen(7)*2]
fbk7_binsH = fbk13_binsH[lindgen(7)*2]

fbk13_binsC = (fbk13_binsH + fbk13_binsL)/2.
fbk7_binsC = (fbk7_binsH + fbk7_binsL)/2.

tplot_names,'*fbk_7_fb1*',names=tnames1
tplot_names,'*fbk_7_fb2*',names=tnames2
tnames = [tnames1,tnames2]

if tnames[0] ne '' then begin
	for i=0,size(tnames,/n_elements)-1 do begin
		get_data,tnames[i],data=d,limits=l,dlimits=dl
		d.v=fbk7_binsH  
;		l.ysubtitle = '[Hz]'
;		l.ytitle = 'FBK 7'

		options,tnames[i],'ysubtitle','[Hz]'
		options,tnames[i],'ytitle','FBK 7'

		store_data,tnames[i],data=d,limits=l,dlimits=dl
		ylim,tnames[i],1,1d4,1
		zlim,tnames[i],0.01,1,1
	endfor
endif

tplot_names,'*fbk_13_fb1*',names=tnames1
tplot_names,'*fbk_13_fb2*',names=tnames2
tnames = [tnames1,tnames2]

if tnames[0] ne '' then begin
	for i=0,size(tnames,/n_elements)-1 do begin
		get_data,tnames[i],data=d,limits=l,dlimits=dl
		d.v=fbk13_binsH
;		l.ysubtitle = '[Hz]'
;		l.ytitle = 'FBK 13'

		options,tnames[i],'ysubtitle','[Hz]'
		options,tnames[i],'ytitle','FBK 13'
		
		store_data,tnames[i],data=d,limits=l,dlimits=dl
		ylim,tnames[i],1,1d4,1
		zlim,tnames[i],0.01,1,1
	endfor
endif




end

