;Downsample tplot quantities


;tname = name of tplot quantity
;sr = new sample rate (S/sec)
;nochange - set if you'd like to overwrite the original tplot variable name
;			Otherwise newname = oldname + '_DS'

;Created by Aaron Breneman  10-29-2012


pro rbsp_downsample,tnames,sr,nochange


if ~keyword_set(sr) then sr=1


for j=0,n_elements(tnames)-1 do begin
	get_data,tnames[j],data=dat,dlimits=dlim,limits=lim
	
	if is_struct(dat) then begin
		
		;get new times at cadence of "sr"
		
		t0 = min(dat.x)
		t1 = max(dat.x)
		newt = dindgen((t1-t0)*sr) + t0
		
		dat2 = interpol(dat.y,dat.x,newt)
		
		if ~keyword_set(nochange) then store_data,tnames[j]+'_DS',data={x:newt,y:dat2},dlimits=dlim,limits=lim $
		else store_data,tnames[j],data={x:newt,y:dat2},dlimits=dlim,limits=lim

	endif

endfor


end

