; rbsp efw XSPEC crib
;
; Kris Kersten, UMN, June 2012
;			email: kris.kersten@gmail.com

; note: The phase and coherence are calculated in test_rbsp_efw_xspec_phase.pro,
;		which assumes default 64-bin specs.  This routine will need to
;		"smarten up" and test for 32 or 112 bin specs.

; initialize RBSP environment
rbsp_efw_init


; set desired probe
; note: probe can be string 'a' or 'b' for a single probe, or string
;		array ['a', 'b'] or space-delimited list 'a b' for both probes.
probe = 'a b'


; set time of interest to a single day
date = '2013-02-16'	; UTC.
duration = 1	; days.
timespan, date, duration

integration=0 ; for looking at integration data

; load data
; note: rbsp_load_efw_xspec handles only the 'xspec' datatype.
;       
datatype = ['xspec']

; include support data?
get_support_data = 0 ; 0=no, 1=yes

; use raw ADC numbers or physical units?
type='raw' ; use raw for now. for physical units use type='calibrated'


rbsp_load_efw_xspec, probe=probe, datatype=datatype, type=type, $
		get_support_data=get_support_data, integration=integration


; calculate phase, coherence
; CAVEAT: This call assumes we have 64-bin XSPECs.  This will have to be fixed.
;			For now, it *should* just quietly skip the phase and coherence
;			calculation when we have other than 64-bin specs.
test_rbsp_efw_xspec_phase


; see if we have 36, 64, or 112 bins and define abins, bbins to be used
; in the tplot calls
anames=''
nna=''
anames=tnames('rbspa_efw_xspec_*')
if strlen(anames[0]) ne 0 then nna=strmid(anames[0],16,1)
if nna eq '3' then abins='36' $
	else if nna eq '6' then abins='64' $
	else if nna eq '1' then abins='112' $
	else abins='0'

bnames=''
nnb=''
bnames=tnames('rbspb_efw_xspec_*')
if strlen(bnames[0]) ne 0 then nnb=strmid(bnames[0],16,1)
if nnb eq '3' then bbins='36' $
	else if nnb eq '6' then bbins='64' $
	else if nnb eq '1' then bbins='112' $
	else bbins='0'


; note: It would be nice to label the XSPEC sources, bur for now we'll skip it.
;		SPEC and XSPEC input source selection bits are returned in the
;		EFW_CONFIG variable, and a lookup table based on the Instrument
;		Configuration Spreadsheet (ICS) will be used to translate the SPEC and
;		XSPEC source selections into human-readable source values. This is
;		currently under construction.


; set up y-axis range
; key: ylim, 'tplot_quantity', ymin, ymax, log
;	where log=1 scales logarithmically, log=0 scales linearly

; for now the y-axis scaling covers [1,64], so set limits accordingly
ylim, 'rbsp?_efw_xspec*', 1, 64, 1
options,'rbsp?_efw_xspec*','yticks',4

; eventually, SPEC will range from DC to 8192Hz
;ylim, '*', 0.001, 8192., 1

; PLOT

; first format the plot panels
tplot_options, 'xmargin', [ 20., 15.] ; increase margins so we don't lose labels

; add gridlines?
;tplot_options, 'xticklen', 1. ; 100% length for gridlines, set both x,y by using 'ticklen'
;tplot_options, 'xgridstyle', 1
;tplot_options, 'yticklen', 1.
;tplot_options, 'ygridstyle', 1


; RBSPA
tplot_options,'title','RBSPA XSPEC_'+abins+' - '+date
tplot,'rbspa_efw_xspec_'+abins+'_xspec0_*'
tplot,'rbspa_efw_xspec_'+abins+'_xspec1_*'
;tplot,'rbspa_efw_xspec_'+abins+'_xspec2_*'
;tplot,'rbspa_efw_xspec_'+abins+'_xspec3_*'

; RBSPB
tplot_options,'title','RBSPB XSPEC_'+abins+' - '+date
tplot,'rbspb_efw_xspec_'+abins+'_xspec0_*'
tplot,'rbspb_efw_xspec_'+abins+'_xspec1_*'
;tplot,'rbspb_efw_xspec_'+abins+'_xspec2_*'
;tplot,'rbspb_efw_xspec_'+abins+'_xspec3_*'


; dump summary plots to PostScript using popen, pclose

; PostScript needs a different !p.charsize setting
old_pcharsize=!p.charsize
!p.charsize=0.7

; RBSPA
popen,'RBSPA_XSPEC_summary_'+strcompress(date,/remove_all),/port
tplot_options,'title','RBSPA XSPEC_'+abins+' - '+date
tplot,['rbspa_efw_xspec_'+abins+'_xspec0_*', 'rbspa_efw_xspec_'+abins+'_xspec1_*']
;tplot,'rbspa_efw_xspec_'+abins+'_xspec2_*'
;tplot,'rbspa_efw_xspec_'+abins+'_xspec3_*'
pclose

; RBSPB
popen,'RBSPB_SPEC_summary_'+strcompress(date,/remove_all),/port
tplot_options,'title','RBSPB XSPEC_'+abins+' - '+date
tplot,['rbspb_efw_xspec_'+abins+'_xspec0_*', 'rbspb_efw_xspec_'+abins+'_xspec1_*']
;tplot,'rbspb_efw_xspec_'+abins+'_xspec2_*'
;tplot,'rbspb_efw_xspec_'+abins+'_xspec3_*'
pclose

; now reset the charsize
!p.charsize=old_pcharsize


; delete all loaded quantities (this can be useful if you want to look at
; an entirely different day)
;store_data, '*', /delete



end ; rbsp_efw_spec_crib
