; rbsp efw waveform crib
;
; Kris Kersten, UMN, June 2012
;			email: kris.kersten@gmail.com


; initialize RBSP environment
rbsp_efw_init


; set desired probe
; note: probe can be string 'a' or 'b' for a single probe, or string
;		array ['a', 'b'] or space-delimited list 'a b' for both probes.
probe = 'a b'


; set time of interest to a single day
date = '2013-02-16'	; UTC.
duration = 1	; days.
timespan, date, duration

integration=0 ; for looking at integration data

; note:	datatype can be any subset of the valid types listed below. You can
;		omit datatype in the rbsp_load_efw_waveform call to load all
;		available quantities.  The high time-resolution b1 and b2 quantities
;		can be slow to load and consume significant memory when loaded, so it's
;		best to specify just the *svy variables when looking at surveys over
;		long intervals.
;       
datatype = ['esvy', 'vsvy', 'magsvy', 'eb1', 'vb1', 'mscb1', $
			'eb2', 'vb2', 'mscb2']

; include support data?
get_support_data = 0 ; 0=no, 1=yes

; use raw ADC numbers or physical units?
type='raw' ; use raw for now. for physical units use type='calibrated'


; load data
rbsp_load_efw_waveform, probe=probe, datatype=datatype, type=type, $
		get_support_data=get_support_data


; list all loaded quantities
tplot_names
; note: At this point all variables all hold combined multi-component data.

; break the combined variables into individual waveforms
split_vec, 'rbsp?_efw_esvy', suffix='_'+['E12', 'E34', 'E56']
split_vec, 'rbsp?_efw_vsvy', suffix='_V'+['1','2','3','4','5','6']
split_vec, 'rbsp?_efw_magsvy', suffix='_'+['U', 'V', 'W']
split_vec, 'rbsp?_efw_eb1', suffix='_'+['E12', 'E34', 'E56']
split_vec, 'rbsp?_efw_vb1', suffix='_V'+['1','2','3','4','5','6']
split_vec, 'rbsp?_efw_mscb1', suffix='_'+['U', 'V', 'W']
split_vec, 'rbsp?_efw_eb2', suffix='_'+['E12DC', 'E34DC', 'E56DC', 'E12AC', $
				'E34AC', 'E56AC', 'EDCpar', 'EDCprp', 'EACpar', 'EACprp']
split_vec, 'rbsp?_efw_vb2', suffix='_V'+['1','2','3','4','5','6']
split_vec, 'rbsp?_efw_mscb2', suffix='_'+['U', 'V', 'W', 'par', 'perp']


; PLOT

; first format the plot panels
tplot_options, 'xmargin', [ 20., 15.] ; increase margins so we don't lose labels

; add gridlines?
;tplot_options, 'xticklen', 1. ; 100% length for gridlines, set both x,y by using 'ticklen'
;tplot_options, 'xgridstyle', 1
;tplot_options, 'yticklen', 1.
;tplot_options, 'ygridstyle', 1


; note: The 'labflag' option controls the position of labels in the right
;		margin.  Here is the key:
;		0: no labels
;		1: evenly spaced labels
;		2: labels positioned where each trace crosses y-axis
;		-1: evenly spaced, reversed

; spread out the labels and reverse their order
options,'*','labflag',-1


; waveform summary plots for each spacecraft
;-------------------------------------------------------------------------------
tplot_options,'title','RBSPA waveform summary - ' + date
; note: Title is persistent.  Change it when changing plot quantities.
tplot,['rbspa_efw_*svy', 'rbspa_efw_*b1', 'rbspa_efw_*b2'] ; RBSPA

tplot_options,'title','RBSPB waveform summary - ' + date
tplot,['rbspb_efw_*svy', 'rbspb_efw_*b1', 'rbspb_efw_*b2'] ; RBSPB
;-------------------------------------------------------------------------------


; dump summary plots to PostScript using popen, pclose

; PostScript needs a different !p.charsize setting
old_pcharsize=!p.charsize
!p.charsize=0.7

popen,'RBSPA_waveform_summary_'+strcompress(date,/remove_all),/port
tplot_options,'title','RBSPA waveform summary - ' + date
tplot,['rbspa_efw_*svy', 'rbspa_efw_*b1', 'rbspa_efw_*b2'] ; RBSPA
pclose

popen,'RBSPB_waveform_summary_'+strcompress(date,/remove_all),/port
tplot_options,'title','RBSPB waveform summary - ' + date
tplot,['rbspb_efw_*svy', 'rbspb_efw_*b1', 'rbspb_efw_*b2'] ; RBSPB
pclose

; now reset the charsize
!p.charsize=old_pcharsize


; combined RBSPA/B plots for individual quantities
tplot_options,'title','RBSP survey - '+date ; set title (this is persistent)
tplot,'rbsp?_efw_*svy' ; all survey quantities, combined line plots
tplot_options,'title','RBSP B1 - '+date
tplot,'rbsp?_efw_*b1' ; all B1 quantities, combined line plots
tplot_options,'title','RBSP B2 - '+date
tplot,'rbsp?_efw_*b2' ; all B2 quantities, combined line plots


; survey, B1, and B2 split line plots for each spacecraft
tplot_options,'title','' ; turn off plot title

; RBSPA
tplot,'rbspa_efw_esvy_*' ; RBSPA E survey, split line plots
tplot,'rbspa_efw_vsvy_V*' ; RBSPA V survey, split line plots
tplot,'rbspa_efw_magsvy_*' ; RBSPA MAG survey, split line plots

tplot,'rbspa_efw_eb1_*' ; RBSPA E B1, split line plots
tplot,'rbspa_efw_vb1_V*' ; RBSPA V B1, split line plots
tplot,'rbspa_efw_mscb1_*' ; RBSPA MSC B1, split line plots

tplot,'rbspa_efw_eb2_*' ; RBSPA E survey, split line plots
tplot,'rbspa_efw_vb2_V*' ; RBSPA V survey, split line plots
tplot,'rbspa_efw_mscb2_*' ; RBSPA MSC B2, split line plots

; RBSPB
tplot,'rbspb_efw_esvy_*' ; RBSPB E survey, split line plots
tplot,'rbspb_efw_vsvy_V*' ; RBSPB V survey, split line plots
tplot,'rbspb_efw_magsvy_*' ; RBSPB MAG survey, split line plots

tplot,'rbspb_efw_eb1_*' ; RBSPB E B1, split line plots
tplot,'rbspb_efw_vb1_V*' ; RBSPB V B1, split line plots
tplot,'rbspb_efw_mscb1_*' ; RBSPB MSC B1, split line plots

tplot,'rbspb_efw_eb2_*' ; RBSPB E survey, split line plots
tplot,'rbspb_efw_vb2_V*' ; RBSPB V survey, split line plots
tplot,'rbspb_efw_mscb2_*' ; RBSPB MSC B2, split line plots



; delete all loaded quantities (this can be useful if you want to look at
; an entirely different day)
;store_data, '*', /delete



end ; rbsp_efw_waveform_crib