; rbsp efw FBK crib
;
; Kris Kersten, UMN, June 2012
;			email: kris.kersten@gmail.com


; initialize RBSP environment
rbsp_efw_init


; set desired probe
; note: probe can be string 'a' or 'b' for a single probe, or string
;		array ['a', 'b'] or space-delimited list 'a b' for both probes.
probe = 'a b'


; set time of interest to a single day
date = '2013-02-16'	; UTC.
duration = 1 ; days.
timespan, date, duration

integration=0 ; for looking at integration data

; note: rbsp_load_efw_fbk handles only the 'fbk' datatype.
;       
datatype = ['fbk']

; include support data?
; note: *fbk_7_select and *fbk_13_select come with the support data and
;		tell us the selected source channels. so set this equal to 1 here.
get_support_data = 1 ; 0=no, 1=yes

; use raw ADC numbers or physical units?
type='raw' ; use raw for now. for physical units use type='calibrated'


; load data
rbsp_load_efw_fbk, probe=probe, datatype=datatype, type=type, $
		get_support_data=get_support_data, integration=integration


; sort out FBK source labels:
; note: Source selects for the Filter Bank:
;		0=E12DC
;		1=E34DC
;		2=E56DC
;		3=E12AC
;		4=E34AC
;		5=E56AC
;		6=SCMU
;		7=SCMV
;		8=SCMW
;		9=(V1DC+V2DC+V3DC+V4DC)/4
;		(default is 0)
fbk_sources=['E12DC', 'E34DC', 'E56DC', 'E12AC', 'E34AC', 'E56AC', $
			'SCMU', 'SCMV', 'SCMW']

get_data,'rbspa_efw_fbk_7_fbk_7_select',data=a7select
get_data,'rbspa_efw_fbk_13_fbk_13_select',data=a13select
get_data,'rbspb_efw_fbk_7_fbk_7_select',data=b7select
get_data,'rbspb_efw_fbk_13_fbk_13_select',data=b13select

; note: the fbk select variables come bach as nX2 arrays, where [*,0] array is
;		the fb1 source as a function of time, and [*,1] is the fb2 source
if is_struct(a7select) then $
	a7_sources=[fbk_sources[median(a7select.y[*,0])], fbk_sources[median(a7select.y[*,1])] ] $
	else a7_sources=['','']
if is_struct(a13select) then $
	a13_sources=[fbk_sources[median(a13select.y[*,0])], fbk_sources[median(a13select.y[*,1])] ] $
	else a13_sources=['','']
if is_struct(b7select) then $
	b7_sources=[fbk_sources[median(b7select.y[*,0])], fbk_sources[median(b7select.y[*,1])] ] $
	else b7_sources=['','']
if is_struct(b13select) then $
	b13_sources=[fbk_sources[median(b13select.y[*,0])], fbk_sources[median(b13select.y[*,1])] ] $
	else b13_sources=['','']
; note: for simplicity we've taken the median value for each channel over the
;		selected time range.  source changes will likely be rare and can be
;		handled on a case-by-case basis

; now turn the sources into labels
units='raw counts'
options,'rbspa_efw_fbk_7_fb1_av','ztitle',a7_sources[0]+'_avg '+units 
options,'rbspa_efw_fbk_7_fb1_pk','ztitle',a7_sources[0]+'_peak '+units 
options,'rbspa_efw_fbk_7_fb2_av','ztitle',a7_sources[1]+'_avg '+units 
options,'rbspa_efw_fbk_7_fb2_pk','ztitle',a7_sources[1]+'_peak '+units 
options,'rbspa_efw_fbk_13_fb1_av','ztitle',a13_sources[0]+'_avg '+units 
options,'rbspa_efw_fbk_13_fb1_pk','ztitle',a13_sources[0]+'_peak '+units 
options,'rbspa_efw_fbk_13_fb2_av','ztitle',a13_sources[1]+'_avg '+units 
options,'rbspa_efw_fbk_13_fb2_pk','ztitle',a13_sources[1]+'_peak '+units 

options,'rbspb_efw_fbk_7_fb1_av','ztitle',b7_sources[0]+'_avg '+units 
options,'rbspb_efw_fbk_7_fb1_pk','ztitle',b7_sources[0]+'_peak '+units 
options,'rbspb_efw_fbk_7_fb2_av','ztitle',b7_sources[1]+'_avg '+units 
options,'rbspb_efw_fbk_7_fb2_pk','ztitle',b7_sources[1]+'_peak '+units 
options,'rbspb_efw_fbk_13_fb1_av','ztitle',b13_sources[0]+'_avg '+units 
options,'rbspb_efw_fbk_13_fb1_pk','ztitle',b13_sources[0]+'_peak '+units 
options,'rbspb_efw_fbk_13_fb2_av','ztitle',b13_sources[1]+'_avg '+units 
options,'rbspb_efw_fbk_13_fb2_pk','ztitle',b13_sources[1]+'_peak '+units 


; it might also be useful to establish the FBK7/13 bin widths for labeling
; KEY: fbk7 bin width (Hz):
;		0.8-1.5, 3-6, 12-25, 50-100, 200-400, 800-1.6k, 3.2-6.5k
;
; KEY: fbk13 bin width (Hz):
;		0.8-1.5, 1.5-3, 3-6, 6-12, 12-25, 25-50, 50-100, 100-200,
;		200-400, 400-800, 800-1.6k, 1.6k-3.2k, 3.2-6.5k

; set up frequency bin labels for fbk7, fbk13
fbk13_bins=['0.8-1.5Hz', '1.5-3Hz', '3-6Hz', '6-12Hz', '12-25Hz', '25-50Hz', $
			'50-100Hz', '100-200Hz', '200-400Hz', '400-800Hz', $
			'0.8-1.6kHz', '1.6-3.2kHz', '3.2-6.5kHz']
fbk7_bins=fbk13_bins[lindgen(7)*2]


; PLOT

; first format the plot panels
tplot_options, 'xmargin', [ 20., 15.] ; increase margins so we don't lose labels

; add gridlines?
;tplot_options, 'xticklen', 1. ; 100% length for gridlines, set both x,y by using 'ticklen'
;tplot_options, 'xgridstyle', 1
;tplot_options, 'yticklen', 1.
;tplot_options, 'ygridstyle', 1


; set up y-axis range
; key: ylim, 'tplot_quantity', ymin, ymax, log
;	where log=1 scales logarithmically, log=0 scales linearly

; for now the y-axis covers [1,13] (FBK13) and [1,7] (FBK7), so set limits
; accordingly
ylim, '*fbk_7*', 1, 7, 1
ylim, '*fbk_13*', 1, 13, 1

; both FBK7 and FBK13 will eventually range from 0.8 to to 6500Hz
;ylim, '*fbk*', 0.8, 6500., 1


; RBSPA FBK summary
tplot_options,'title','RBSPA FBK - '+date
tplot,['rbspa_efw_fbk_7_fb1*', 'rbspa_efw_fbk_7_fb2*', $
		'rbspa_efw_fbk_13_fb1*', 'rbspa_efw_fbk_13_fb2*']

; RBSPB FBK summary
tplot_options,'title','RBSPB FBK - '+date
tplot,['rbspb_efw_fbk_7_fb1*', 'rbspb_efw_fbk_7_fb2*', $
		'rbspb_efw_fbk_13_fb1*', 'rbspb_efw_fbk_13_fb2*']


; dump summary plots to PostScript using popen, pclose

; PostScript needs a different !p.charsize setting
old_pcharsize=!p.charsize
!p.charsize=0.7

; RBSPA FBK summary
popen,'RBSPA_FBK_summary_'+strcompress(date,/remove_all),/port
tplot_options,'title','RBSPA FBK - '+date
tplot,['rbspa_efw_fbk_7_fb1*', 'rbspa_efw_fbk_7_fb2*', $
		'rbspa_efw_fbk_13_fb1*', 'rbspa_efw_fbk_13_fb2*']
pclose

; RBSPB FBK summary
popen,'RBSPB_FBK_summary_'+strcompress(date,/remove_all),/port
tplot_options,'title','RBSPB FBK - '+date
tplot,['rbspb_efw_fbk_7_fb1*', 'rbspb_efw_fbk_7_fb2*', $
		'rbspb_efw_fbk_13_fb1*', 'rbspb_efw_fbk_13_fb2*']
pclose

; now reset the charsize
!p.charsize=old_pcharsize


; delete all loaded quantities (this can be useful if you want to look at
; an entirely different day)
;store_data, '*', /delete


end ; rbsp_efw_fbk_crib

