;+
;NAME: init_crib_colors
;
;PURPOSE: Sets default plotting colors.
;
;        *This is not a crib sheet*
;        
;        Defaults to black pen on white background, rainbow color scheme.
;
;ARGUMENTS:   
;   COLORTABLE: Index specifying the desired color table to be passed to LOADCT2
;
;-

pro init_crib_colors, colortable

  compile_opt idl2, hidden
  
  ct = size(colortable,/type) ? colortable:43
  
  loadct2, ct
  
  !p.background = !d.table_size-1  ; white background
  !p.color=0                       ; black Pen
  !p.font = -1                     ; default
  
end  