; rbsp efw SPEC crib
;
; Kris Kersten, UMN, June 2012
;			email: kris.kersten@gmail.com


; initialize RBSP environment
rbsp_efw_init


; set desired probe
; note: probe can be string 'a' or 'b' for a single probe, or string
;		array ['a', 'b'] or space-delimited list 'a b' for both probes.
probe = 'a b'


; set time of interest to a single day
date = '2013-02-16'	; UTC.
duration = 1	; days.
timespan, date, duration

integration=0 ; for looking at integration data

; note: rbsp_load_efw_spec handles only the 'spec' datatype.
;       
datatype = ['spec']

; include support data?
get_support_data = 0 ; 0=no, 1=yes

; use raw ADC numbers or physical units?
type='raw' ; use raw for now. for physical units use type='calibrated'


; load data
rbsp_load_efw_spec, probe=probe, datatype=datatype, type=type,$
		get_support_data=get_support_data, integration=integration


; first see if we have 36, 64, or 112 bins and define abins, bbins to be used
; in the tplot calls
anames=''
nna=''
anames=tnames('rbspa*spec?')
if strlen(anames[0]) ne 0 then nna=strmid(anames[0],10,1)
if nna eq '3' then abins='36' $
	else if nna eq '6' then abins='64' $
	else if nna eq '1' then abins='112' $
	else abins='0'

bnames=''
nnb=''
bnames=tnames('rbspb*spec?')
if strlen(bnames[0]) ne 0 then nnb=strmid(bnames[0],10,1)
if nnb eq '3' then bbins='36' $
	else if nnb eq '6' then bbins='64' $
	else if nnb eq '1' then bbins='112' $
	else bbins='0'


; SPEC returns 7 channels, with nominal data selection:
;		SPEC0: E12AC
;		SPEC1: E56AC
;		SPEC2: SCMpar
;		SPEC3: SCMperp
;		SPEC4: SCMW
;		SPEC5: V1AC
;		SPEC6: V2AC

; set up labels assuming we have the nominal channel selection above
; note: SPEC and XSPEC input source selection bits are returned in the
;		EFW_CONFIG variable, and a lookup table based on the Instrument
;		Configuration Spreadsheet (ICS) will be used to translate the SPEC and
;		XSPEC source selections into human-readable source values. This is
;		currently under construction.


spec_sources=['E12AC', 'E56AC', 'SCMpar', 'SCMperp', 'SCMW', 'V1AC', 'V2AC']
units=' raw counts' ; for now, assume raw counts.  this will change.

; dump everything into the z-axis labels until we sort out proper labeling 
options, '*spec0', 'ztitle', spec_sources[0]+units
options, '*spec1', 'ztitle', spec_sources[1]+units
options, '*spec2', 'ztitle', spec_sources[2]+units
options, '*spec3', 'ztitle', spec_sources[3]+units
options, '*spec4', 'ztitle', spec_sources[4]+units
options, '*spec5', 'ztitle', spec_sources[5]+units
options, '*spec6', 'ztitle', spec_sources[6]+units


; set up y-axis range
; key: ylim, 'tplot_quantity', ymin, ymax, log
;	where log=1 scales logarithmically, log=0 scales linearly

; for now the y-axis scaling covers [1,64], so set limits accordingly
ylim, 'rbspa_efw_'+abins+'_spec?', 1, 64, 1
options,'rbspa_efw_'+abins+'_spec?','yticks',4

; SPEC will eventually cover the range from DC to 8192Hz
;ylim, '*spec*', 0.001, 8192., 1

; PLOT

; first format the plot panels
tplot_options, 'xmargin', [ 20., 15.] ; increase margins so we don't lose labels

; add gridlines?
;tplot_options, 'xticklen', 1. ; 100% length for gridlines, set both x,y by using 'ticklen'
;tplot_options, 'xgridstyle', 1
;tplot_options, 'yticklen', 1.
;tplot_options, 'ygridstyle', 1


; RBSPA
tplot_options,'title','RBSPA SPEC_'+abins+' - '+date
tplot,'rbspa_efw_'+abins+'_spec?'

; RBSPB
tplot_options,'title','RBSPB SPEC_'+bbins+' - '+date
tplot,'rbspb_efw_'+bbins+'_spec?'


; dump summary plots to PostScript using popen, pclose

; PostScript needs a different !p.charsize setting
old_pcharsize=!p.charsize
!p.charsize=0.7

; RBSPA
popen,'RBSPA_SPEC_summary_'+strcompress(date,/remove_all),/port
tplot_options,'title','RBSPA SPEC_'+abins+' - '+date
tplot,'rbspa_efw_'+abins+'_spec?'
pclose

; RBSPB
popen,'RBSPB_SPEC_summary_'+strcompress(date,/remove_all),/port
tplot_options,'title','RBSPB SPEC_'+bbins+' - '+date
tplot,'rbspb_efw_'+bbins+'_spec?'
pclose

; now reset the charsize
!p.charsize=old_pcharsize


; delete all loaded quantities (this can be useful if you want to look at
; an entirely different day)
;store_data, '*', /delete



end ; rbsp_efw_spec_crib
