;+
;FUNCTION:	symm3d
;PURPOSE:	Returns [theta,phi]  given a 3d data struct
;INPUT:
;	dat:	A 3d data structure such as those generated by get_el,get_pl,etc
;		e.g. "get_el"
;KEYWORDS:
;	esteps:		energy steps to use
;
;CREATED BY:	Davin Larson
;LAST MODIFICATION:	@(#)symm3d.pro	1.5 95/10/06
;
;-

function symm3d,dat,  $
  ESTEPS= esteps

if keyword_set(esteps) eq 0 then begin
   nrgs = total(dat.energy,2)/dat.nbins
   esteps = (nrgs gt 100.) and (nrgs lt 2000.)
   esteps = where(esteps)
   min = min(esteps,max=max)
   esteps = [min,max]
;dprint, esteps
endif

pt = prestens(dat,estep=esteps)
q = heatflux(dat,estep=esteps)
b = symmetry_dir(pt)
bdotq = total(b*q)
if bdotq lt 0 then b = -b
cart_to_sphere,b(0),b(1),b(2),r,theta,phi

return,[theta,phi]
end
