;+
; Apply time tag corrections to vsvy.
;-

pro rbsp_efw_phasef_read_vsvy_gen_file, time, probe=probe, filename=file, version=version

;---Check inputs.
    if n_elements(file) eq 0 then begin
        errmsg = handle_error('No output file ...')
        return
    endif

    if n_elements(probe) eq 0 then begin
        errmsg = handle_error('No input probe ...')
        return
    endif

    if n_elements(time) eq 0 then begin
        errmsg = handle_error('No input time ...')
        return
    endif


;---Constants and settings.
    secofday = 86400d
    errmsg = ''


;---Load E UVW.
    rbspx = 'rbsp'+probe
    prefix = 'rbsp'+probe+'_'
    date = time[0]-(time[0] mod secofday)
    time_range = date+[0,secofday]
    tr = time_range
    timespan, tr[0], total(tr*[-1,1]), /seconds
    rbsp_load_efw_waveform, probe=probe, datatype='vsvy', noclean=1


;---Manually rule out some times.
    mask_list = list()
    mask_list.add, dictionary($
        'probe', 'a', $
        'time_range', time_double(['2017-04-13/23:00','2017-04-14/00:01']))
    mask_list.add, dictionary($
        'probe', 'b', $
        'time_range', time_double(['2015-06-12/10:00','2015-06-12/10:40']))

    l1_efw_var = prefix+'efw_vsvy'
    get_data, l1_efw_var, times, vsvy
    foreach mask, mask_list do begin
        if mask.probe ne probe then continue
        index = lazy_where(times, '[]', mask.time_range, count=count)
        if count ne 0 then times[index] = !values.f_nan
    endforeach
    index = where(finite(times))
    times = times[index]
    vsvy = vsvy[index,*]
    store_data, l1_efw_var, times, vsvy


;---Implement the time correction.
    rbsp_efw_apply_l1_time_tag_correction, l1_efw_var, probe=probe


;---Get rid of non-monotonic times, which sometimes show up.
    get_data, l1_efw_var, times, vsvy
    index = uniq(times, sort(times))
    times = times[index]
    vsvy = vsvy[index,*]
    store_data, l1_efw_var, times, vsvy


;---Save data.
    save_var = l1_efw_var
    path = fgetpath(file)
    if file_test(path,/directory) eq 0 then file_mkdir, path
    data_file = file
    if file_test(data_file) eq 1 then file_delete, data_file  ; overwrite old files.

    ginfo = dictionary($
        'TITLE', 'RBSP EFW calibrated Vsvy', $
        'TEXT', 'Generated by Sheng Tian at the University of Minnesota',$
        'done_time_tag_nudge', 1 )
    cdf_save_setting, ginfo, filename=file
    get_data, save_var, times, vsvy
    labels = 'V'+string(findgen(6)+1,format='(I0)')
    store_data, save_var, times, float(vsvy), limits={units:'V', notes:strjoin(labels,',')}
    stplot2cdf, save_var, istp=1, filename=file, time_var='epoch'

end

;probe = 'a'
;time = time_double('2013-09-11')
;file = join_path([homedir(),'test.cdf'])
;if file_test(file) eq 1 then file_delete, file
;rbsp_efw_phasef_read_vsvy_gen_file, time, probe=probe, filename=file
;stop





stop
probes = ['a','b']
root_dir = join_path([diskdir('data'),'rbsp','efw_phasef','vsvy'])
foreach probe, probes do begin
    prefix = 'rbsp'+probe+'_'
    rbspx = 'rbsp'+probe
    time_range = rbsp_efw_phasef_get_valid_range('vsvy_l1', probe=probe)
    days = make_bins(time_range, constant('secofday'))
    foreach day, days do begin
        str_year = time_string(day,tformat='YYYY')
        path = join_path([root_dir,rbspx,str_year])
        base = prefix+'efw_vsvy_'+time_string(day,tformat='YYYY_MMDD')+'_v01.cdf'
        file = join_path([path,base])
if file_test(file) then continue
        rbsp_efw_phasef_read_vsvy_gen_file, day, probe=probe, filename=file
    endforeach
endforeach
stop


end
