(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    245728,       4409]
NotebookOptionsPosition[    241481,       4277]
NotebookOutlinePosition[    242674,       4310]
CellTagsIndexPosition[    242382,       4302]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"SetDirectory", "[", 
  RowBox[{"NotebookDirectory", "[", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.6482162358487186`*^9, 3.6482162429075823`*^9}}],

Cell[BoxData["\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-\
Colorbars/make_csv\"\>"], "Output",
 CellChangeTimes->{3.6482162441979027`*^9, 3.649608458536663*^9, 
  3.6551352872803087`*^9, 3.658032091758339*^9, 3.662221872835306*^9, 
  3.662226869122733*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"cmap1", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"\"\<matplotlib_option_d.csv\>\"", ",", "\"\<Data\>\""}], "]"}]}],
   ";"}]], "Input",
 CellChangeTimes->{{3.648061179003487*^9, 3.6480612234502783`*^9}, 
   3.648067618173285*^9, {3.648216249692092*^9, 3.648216260227953*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"crainbow", "=", 
   RowBox[{
    RowBox[{"Import", "[", 
     RowBox[{"\"\<cubehelix_rainbow_256.csv\>\"", ",", "\"\<Data\>\""}], 
     "]"}], "/", "255."}]}], ";"}]], "Input",
 CellChangeTimes->{{3.648068007171833*^9, 3.648068030139607*^9}, {
   3.6480681276019287`*^9, 3.6480681481888113`*^9}, 3.648216264767478*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"mplrainbow", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"\"\<MPL_rainbow_BW.csv\>\"", ",", "\"\<Data\>\""}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.648068160197073*^9, 3.648068183077076*^9}, 
   3.648068218017405*^9, {3.648072146638451*^9, 3.648072147262402*^9}, {
   3.648216269436138*^9, 3.648216306972171*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "@", "crainbow"}]], "Input",
 CellChangeTimes->{{3.648061231849666*^9, 3.648061240557205*^9}, {
  3.6480680336969433`*^9, 3.648068035653761*^9}}],

Cell[BoxData["256"], "Output",
 CellChangeTimes->{3.6480612409513187`*^9, 3.648062768823475*^9, 
  3.648064904322626*^9, 3.648067619761849*^9, 3.6480680361371098`*^9, 
  3.6480681327928457`*^9, 3.6480682246157103`*^9, 3.648216284089087*^9, 
  3.6496084587745523`*^9, 3.655135311185685*^9, 3.658032095250009*^9, 
  3.662221876895067*^9, 3.662226871607984*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "Rectangle"}]], "Input",
 CellChangeTimes->{{3.648062820085143*^9, 3.648062821312356*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox["\<\"\!\(\*RowBox[{\\\"Rectangle\\\", \\\"[\\\", \
RowBox[{RowBox[{\\\"{\\\", RowBox[{SubscriptBox[StyleBox[\\\"x\\\", \
\\\"TI\\\"], StyleBox[\\\"min\\\", \\\"TI\\\"]], \\\",\\\", \
SubscriptBox[StyleBox[\\\"y\\\", \\\"TI\\\"], StyleBox[\\\"min\\\", \
\\\"TI\\\"]]}], \\\"}\\\"}], \\\",\\\", RowBox[{\\\"{\\\", \
RowBox[{SubscriptBox[StyleBox[\\\"x\\\", \\\"TI\\\"], StyleBox[\\\"max\\\", \
\\\"TI\\\"]], \\\",\\\", SubscriptBox[StyleBox[\\\"y\\\", \\\"TI\\\"], \
StyleBox[\\\"max\\\", \\\"TI\\\"]]}], \\\"}\\\"}]}], \\\"]\\\"}]\) represents \
an axis-aligned filled rectangle from \!\(\*RowBox[{\\\"{\\\", \
RowBox[{SubscriptBox[StyleBox[\\\"x\\\", \\\"TI\\\"], StyleBox[\\\"min\\\", \
\\\"TI\\\"]], \\\",\\\", SubscriptBox[StyleBox[\\\"y\\\", \\\"TI\\\"], \
StyleBox[\\\"min\\\", \\\"TI\\\"]]}], \\\"}\\\"}]\) to \
\!\(\*RowBox[{\\\"{\\\", RowBox[{SubscriptBox[StyleBox[\\\"x\\\", \
\\\"TI\\\"], StyleBox[\\\"max\\\", \\\"TI\\\"]], \\\",\\\", \
SubscriptBox[StyleBox[\\\"y\\\", \\\"TI\\\"], StyleBox[\\\"max\\\", \
\\\"TI\\\"]]}], \\\"}\\\"}]\).\\n\!\(\*RowBox[{\\\"Rectangle\\\", \\\"[\\\", \
RowBox[{\\\"{\\\", RowBox[{SubscriptBox[StyleBox[\\\"x\\\", \\\"TI\\\"], \
StyleBox[\\\"min\\\", \\\"TI\\\"]], \\\",\\\", \
SubscriptBox[StyleBox[\\\"y\\\", \\\"TI\\\"], StyleBox[\\\"min\\\", \
\\\"TI\\\"]]}], \\\"}\\\"}], \\\"]\\\"}]\) corresponds to a unit square with \
its bottom-left corner at \!\(\*RowBox[{\\\"{\\\", \
RowBox[{SubscriptBox[StyleBox[\\\"x\\\", \\\"TI\\\"], StyleBox[\\\"min\\\", \
\\\"TI\\\"]], \\\",\\\", SubscriptBox[StyleBox[\\\"y\\\", \\\"TI\\\"], \
StyleBox[\\\"min\\\", \\\"TI\\\"]]}], \\\"}\\\"}]\).\"\>", "MSG"], 
  "\[NonBreakingSpace]", 
  ButtonBox[
   StyleBox["\[RightSkeleton]", "SR"],
   Active->True,
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rectangle"]}]], "Print", "PrintUsage",
 CellChangeTimes->{3.6622268726308737`*^9},
 CellTags->"Info-8e984295-0467-45ca-a34f-0f1dd37fbaf4"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"colorbar", "[", "cmap_", "]"}], ":=", 
  RowBox[{"Graphics", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"RGBColor", "@@", 
         RowBox[{"cmap", "[", 
          RowBox[{"[", "ii", "]"}], "]"}]}], ",", 
        RowBox[{"Rectangle", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            FractionBox[
             RowBox[{"ii", "-", "1"}], 
             RowBox[{"Length", "[", "cmap", "]"}]], ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            FractionBox["ii", 
             RowBox[{"Length", "[", "cmap", "]"}]], ",", "1"}], "}"}]}], 
         "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", 
        RowBox[{"Length", "[", "cmap", "]"}]}], "}"}]}], "]"}], ",", 
    RowBox[{"AspectRatio", "\[Rule]", "0.2"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.648062774709776*^9, 3.648062893415534*^9}, 
   3.6480631027209883`*^9, {3.648071052002184*^9, 3.648071052604917*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"colorbar", "[", "crainbow", "]"}]], "Input",
 CellChangeTimes->{{3.648062880921598*^9, 3.648062883335888*^9}, {
  3.648068134708187*^9, 3.648068137300136*^9}}],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[
    6.636694485562685*^-8, 6.636686583450336*^-8, 6.636681958909097*^-8], 
    RectangleBox[{0, 0}, NCache[{Rational[1, 256], 1}, {0.00390625, 1}]]}, 
   {RGBColor[0.015290469272447996`, 0.003139909004492276, 0.], 
    RectangleBox[NCache[{Rational[1, 256], 0}, {0.00390625, 0}], 
     NCache[{Rational[1, 128], 1}, {0.0078125, 1}]]}, 
   {RGBColor[0.030570723641820022`, 0.006282914675981649, 0.], 
    RectangleBox[NCache[{Rational[1, 128], 0}, {0.0078125, 0}], 
     NCache[{Rational[3, 256], 1}, {0.01171875, 1}]]}, 
   {RGBColor[0.04554839475151619, 0.009432238433047548, 0.], 
    RectangleBox[NCache[{Rational[3, 256], 0}, {0.01171875, 0}], 
     NCache[{Rational[1, 64], 1}, {0.015625, 1}]]}, 
   {RGBColor[0.058316491547638356`, 0.012591028529822888`, 0.], 
    RectangleBox[NCache[{Rational[1, 64], 0}, {0.015625, 0}], 
     NCache[{Rational[5, 256], 1}, {0.01953125, 1}]]}, 
   {RGBColor[0.06930614915540068, 0.015762420290558816`, 0.], 
    RectangleBox[NCache[{Rational[5, 256], 0}, {0.01953125, 0}], 
     NCache[{Rational[3, 128], 1}, {0.0234375, 1}]]}, 
   {RGBColor[0.07904952510206184, 0.018949531827149733`, 0.], 
    RectangleBox[NCache[{Rational[3, 128], 0}, {0.0234375, 0}], 
     NCache[{Rational[7, 256], 1}, {0.02734375, 1}]]}, 
   {RGBColor[0.08785664413006633, 0.022155459780166874`, 0.], 
    RectangleBox[NCache[{Rational[7, 256], 0}, {0.02734375, 0}], 
     NCache[{Rational[1, 32], 1}, {0.03125, 1}]]}, 
   {RGBColor[0.095926203810628, 0.025383275089219837`, 0.], 
    RectangleBox[NCache[{Rational[1, 32], 0}, {0.03125, 0}], 
     NCache[{Rational[9, 256], 1}, {0.03515625, 1}]]}, 
   {RGBColor[0.10339423268924144`, 0.02863601879842304, 0.], 
    RectangleBox[NCache[{Rational[9, 256], 0}, {0.03515625, 0}], 
     NCache[{Rational[5, 128], 1}, {0.0390625, 1}]]}, 
   {RGBColor[0.11035848158181527`, 0.03191669790269438, 0.], 
    RectangleBox[NCache[{Rational[5, 128], 0}, {0.0390625, 0}], 
     NCache[{Rational[11, 256], 1}, {0.04296875, 1}]]}, 
   {RGBColor[0.1168918576276251, 0.03522828124056264, 0.], 
    RectangleBox[NCache[{Rational[11, 256], 0}, {0.04296875, 0}], 
     NCache[{Rational[3, 64], 1}, {0.046875, 1}]]}, 
   {RGBColor[0.12305036645514428`, 0.03857369543909077, 0.], 
    RectangleBox[NCache[{Rational[3, 64], 0}, {0.046875, 0}], 
     NCache[{Rational[13, 256], 1}, {0.05078125, 1}]]}, 
   {RGBColor[0.12887807499981446`, 0.04191474079087144, 0.], 
    RectangleBox[NCache[{Rational[13, 256], 0}, {0.05078125, 0}], 
     NCache[{Rational[7, 128], 1}, {0.0546875, 1}]]}, 
   {RGBColor[0.1344103540607413, 0.045132855189430825`, 0.], 
    RectangleBox[NCache[{Rational[7, 128], 0}, {0.0546875, 0}], 
     NCache[{Rational[15, 256], 1}, {0.05859375, 1}]]}, 
   {RGBColor[0.1397448002278408, 0.04819741619221141, 0.], 
    RectangleBox[NCache[{Rational[15, 256], 0}, {0.05859375, 0}], 
     NCache[{Rational[1, 16], 1}, {0.0625, 1}]]}, 
   {RGBColor[0.1451706843221716, 0.05092043987172872, 0.], 
    RectangleBox[NCache[{Rational[1, 16], 0}, {0.0625, 0}], 
     NCache[{Rational[17, 256], 1}, {0.06640625, 1}]]}, 
   {RGBColor[0.15070109153584635`, 0.053317142427437764`, 0.], 
    RectangleBox[NCache[{Rational[17, 256], 0}, {0.06640625, 0}], 
     NCache[{Rational[9, 128], 1}, {0.0703125, 1}]]}, 
   {RGBColor[0.15631986724245875`, 0.05541833110100829, 0.], 
    RectangleBox[NCache[{Rational[9, 128], 0}, {0.0703125, 0}], 
     NCache[{Rational[19, 256], 1}, {0.07421875, 1}]]}, 
   {RGBColor[0.16201216931289153`, 0.057249105276465616`, 0.], 
    RectangleBox[NCache[{Rational[19, 256], 0}, {0.07421875, 0}], 
     NCache[{Rational[5, 64], 1}, {0.078125, 1}]]}, 
   {RGBColor[0.1677643778601124, 0.0588302700546282, 0.], 
    RectangleBox[NCache[{Rational[5, 64], 0}, {0.078125, 0}], 
     NCache[{Rational[21, 256], 1}, {0.08203125, 1}]]}, 
   {RGBColor[0.17354872373558827`, 0.06022657962176239, 0.], 
    RectangleBox[NCache[{Rational[21, 256], 0}, {0.08203125, 0}], 
     NCache[{Rational[11, 128], 1}, {0.0859375, 1}]]}, 
   {RGBColor[0.17929281342102987`, 0.061647947539741364`, 0.], 
    RectangleBox[NCache[{Rational[11, 128], 0}, {0.0859375, 0}], 
     NCache[{Rational[23, 256], 1}, {0.08984375, 1}]]}, 
   {RGBColor[0.18498630992107412`, 0.06312117153238053, 0.], 
    RectangleBox[NCache[{Rational[23, 256], 0}, {0.08984375, 0}], 
     NCache[{Rational[3, 32], 1}, {0.09375, 1}]]}, 
   {RGBColor[0.19062580219849065`, 0.06465206408996949, 0.], 
    RectangleBox[NCache[{Rational[3, 32], 0}, {0.09375, 0}], 
     NCache[{Rational[25, 256], 1}, {0.09765625, 1}]]}, 
   {RGBColor[0.19620793058997293`, 0.0662462777468971, 0.], 
    RectangleBox[NCache[{Rational[25, 256], 0}, {0.09765625, 0}], 
     NCache[{Rational[13, 128], 1}, {0.1015625, 1}]]}, 
   {RGBColor[0.2017293941592062, 0.06790925428692687, 0.], 
    RectangleBox[NCache[{Rational[13, 128], 0}, {0.1015625, 0}], 
     NCache[{Rational[27, 256], 1}, {0.10546875, 1}]]}, 
   {RGBColor[0.20718695753421984`, 0.06964617550896529, 0.], 
    RectangleBox[NCache[{Rational[27, 256], 0}, {0.10546875, 0}], 
     NCache[{Rational[7, 64], 1}, {0.109375, 1}]]}, 
   {RGBColor[0.21257745728397537`, 0.07146191669535176, 0.], 
    RectangleBox[NCache[{Rational[7, 64], 0}, {0.109375, 0}], 
     NCache[{Rational[29, 256], 1}, {0.11328125, 1}]]}, 
   {RGBColor[0.21789780787895954`, 0.07336100388216882, 0.], 
    RectangleBox[NCache[{Rational[29, 256], 0}, {0.11328125, 0}], 
     NCache[{Rational[15, 128], 1}, {0.1171875, 1}]]}, 
   {RGBColor[0.22287198481776405`, 0.07540131838257061, 0.], 
    RectangleBox[NCache[{Rational[15, 128], 0}, {0.1171875, 0}], 
     NCache[{Rational[31, 256], 1}, {0.12109375, 1}]]}, 
   {RGBColor[0.22761026337344836`, 0.07756459748329611, 0.], 
    RectangleBox[NCache[{Rational[31, 256], 0}, {0.12109375, 0}], 
     NCache[{Rational[1, 8], 1}, {0.125, 1}]]}, 
   {RGBColor[0.23225585709422475`, 0.07982511201637307, 0.], 
    RectangleBox[NCache[{Rational[1, 8], 0}, {0.125, 0}], 
     NCache[{Rational[33, 256], 1}, {0.12890625, 1}]]}, 
   {RGBColor[0.2368066073970894, 0.08218518447484607, 0.], 
    RectangleBox[NCache[{Rational[33, 256], 0}, {0.12890625, 0}], 
     NCache[{Rational[17, 128], 1}, {0.1328125, 1}]]}, 
   {RGBColor[0.24126042918006918`, 0.08464665980743741, 0.004030598825609549],
     RectangleBox[NCache[{Rational[17, 128], 0}, {0.1328125, 0}], 
     NCache[{Rational[35, 256], 1}, {0.13671875, 1}]]}, 
   {RGBColor[
    0.24561531787038188`, 0.08721090688481115, 0.010692261417073827`], 
    RectangleBox[NCache[{Rational[35, 256], 0}, {0.13671875, 0}], 
     NCache[{Rational[9, 64], 1}, {0.140625, 1}]]}, 
   {RGBColor[0.2498693559542212, 0.08987882634742439, 0.01777399258591233], 
    RectangleBox[NCache[{Rational[9, 64], 0}, {0.140625, 0}], 
     NCache[{Rational[37, 256], 1}, {0.14453125, 1}]]}, 
   {RGBColor[0.2540207190337343, 0.09265086424087152, 0.025270229870334348`], 
    RectangleBox[NCache[{Rational[37, 256], 0}, {0.14453125, 0}], 
     NCache[{Rational[19, 128], 1}, {0.1484375, 1}]]}, 
   {RGBColor[0.258067681450556, 0.09552703071486668, 0.03317429547238978], 
    RectangleBox[NCache[{Rational[19, 128], 0}, {0.1484375, 0}], 
     NCache[{Rational[39, 256], 1}, {0.15234375, 1}]]}, 
   {RGBColor[0.2620086215102054, 0.09850692297510841, 0.04145371581805996], 
    RectangleBox[NCache[{Rational[39, 256], 0}, {0.15234375, 0}], 
     NCache[{Rational[5, 32], 1}, {0.15625, 1}]]}, 
   {RGBColor[0.2658420263375514, 0.1015897516331164, 0.04941387421789332], 
    RectangleBox[NCache[{Rational[5, 32], 0}, {0.15625, 0}], 
     NCache[{Rational[41, 256], 1}, {0.16015625, 1}]]}, 
   {RGBColor[0.26956649639021724`, 0.10477436959471817`, 0.05690448521945269],
     RectangleBox[NCache[{Rational[41, 256], 0}, {0.16015625, 0}], 
     NCache[{Rational[21, 128], 1}, {0.1640625, 1}]]}, 
   {RGBColor[0.2731807496540973, 0.10805930265801417`, 0.06401938577937388], 
    RectangleBox[NCache[{Rational[21, 128], 0}, {0.1640625, 0}], 
     NCache[{Rational[43, 256], 1}, {0.16796875, 1}]]}, 
   {RGBColor[0.27668362554298526`, 0.11144278104969103`, 0.07082331776361339],
     RectangleBox[NCache[{Rational[43, 256], 0}, {0.16796875, 0}], 
     NCache[{Rational[11, 64], 1}, {0.171875, 1}]]}, 
   {RGBColor[0.28007408852257426`, 0.11492277120720518`, 0.07736270564768899],
     RectangleBox[NCache[{Rational[11, 64], 0}, {0.171875, 0}], 
     NCache[{Rational[45, 256], 1}, {0.17578125, 1}]]}, 
   {RGBColor[0.283345092805427, 0.11849807350871117`, 0.08373311065763925], 
    RectangleBox[NCache[{Rational[45, 256], 0}, {0.17578125, 0}], 
     NCache[{Rational[23, 128], 1}, {0.1796875, 1}]]}, 
   {RGBColor[0.28646194343205805`, 0.12217196449250889`, 0.09027380111445751],
     RectangleBox[NCache[{Rational[23, 128], 0}, {0.1796875, 0}], 
     NCache[{Rational[47, 256], 1}, {0.18359375, 1}]]}, 
   {RGBColor[0.28941575151547205`, 0.12594283803918913`, 0.0970270712637501], 
    RectangleBox[NCache[{Rational[47, 256], 0}, {0.18359375, 0}], 
     NCache[{Rational[3, 16], 1}, {0.1875, 1}]]}, 
   {RGBColor[0.29220220737624875`, 0.1298080942543026, 0.1039871255969298], 
    RectangleBox[NCache[{Rational[3, 16], 0}, {0.1875, 0}], 
     NCache[{Rational[49, 256], 1}, {0.19140625, 1}]]}, 
   {RGBColor[0.29481705103168165`, 0.13376496712982883`, 0.1111477795146298], 
    RectangleBox[NCache[{Rational[49, 256], 0}, {0.19140625, 0}], 
     NCache[{Rational[25, 128], 1}, {0.1953125, 1}]]}, 
   {RGBColor[0.2972560874298405, 0.13781054894169653`, 0.11850241522660859`], 
    RectangleBox[NCache[{Rational[25, 128], 0}, {0.1953125, 0}], 
     NCache[{Rational[51, 256], 1}, {0.19921875, 1}]]}, 
   {RGBColor[0.2995152029161297, 0.14194181282820575`, 0.12604394680658165`], 
    RectangleBox[NCache[{Rational[51, 256], 0}, {0.19921875, 0}], 
     NCache[{Rational[13, 64], 1}, {0.203125, 1}]]}, 
   {RGBColor[0.3015903829213597, 0.14615563349753863`, 0.13376479385420323`], 
    RectangleBox[NCache[{Rational[13, 64], 0}, {0.203125, 0}], 
     NCache[{Rational[53, 256], 1}, {0.20703125, 1}]]}, 
   {RGBColor[0.3034777308499602, 0.15044880606877145`, 0.14165686316392992`], 
    RectangleBox[NCache[{Rational[53, 256], 0}, {0.20703125, 0}], 
     NCache[{Rational[27, 128], 1}, {0.2109375, 1}]]}, 
   {RGBColor[0.305173488138087, 0.1548180630957206, 0.14971153778685053`], 
    RectangleBox[NCache[{Rational[27, 128], 0}, {0.2109375, 0}], 
     NCache[{Rational[55, 256], 1}, {0.21484375, 1}]]}, 
   {RGBColor[
    0.30667405544421755`, 0.15926008985727258`, 0.15791967288198713`], 
    RectangleBox[NCache[{Rational[55, 256], 0}, {0.21484375, 0}], 
     NCache[{Rational[7, 32], 1}, {0.21875, 1}]]}, 
   {RGBColor[0.3079760149295351, 0.163771538022602, 0.16627159777798284`], 
    RectangleBox[NCache[{Rational[7, 32], 0}, {0.21875, 0}], 
     NCache[{Rational[57, 256], 1}, {0.22265625, 1}]]}, 
   {RGBColor[0.3090761535821226, 0.16834903781607316`, 0.17475712369777247`], 
    RectangleBox[NCache[{Rational[57, 256], 0}, {0.22265625, 0}], 
     NCache[{Rational[29, 128], 1}, {0.2265625, 1}]]}, 
   {RGBColor[0.3099714875378728, 0.17298920881591887`, 0.18336555663342358`], 
    RectangleBox[NCache[{Rational[29, 128], 0}, {0.2265625, 0}], 
     NCache[{Rational[59, 256], 1}, {0.23046875, 1}]]}, 
   {RGBColor[0.3106592873521601, 0.17768866952425638`, 0.19208571489308063`], 
    RectangleBox[NCache[{Rational[59, 256], 0}, {0.23046875, 0}], 
     NCache[{Rational[15, 64], 1}, {0.234375, 1}]]}, 
   {RGBColor[
    0.31113710417982643`, 0.18244404584480578`, 0.20090595087520763`], 
    RectangleBox[NCache[{Rational[15, 64], 0}, {0.234375, 0}], 
     NCache[{Rational[61, 256], 1}, {0.23828125, 1}]]}, 
   {RGBColor[0.3114027968269995, 0.18725197859988538`, 0.2098141766561852], 
    RectangleBox[NCache[{Rational[61, 256], 0}, {0.23828125, 0}], 
     NCache[{Rational[31, 128], 1}, {0.2421875, 1}]]}, 
   {RGBColor[0.3114545596467181, 0.192109130210813, 0.21879789300536168`], 
    RectangleBox[NCache[{Rational[31, 128], 0}, {0.2421875, 0}], 
     NCache[{Rational[63, 256], 1}, {0.24609375, 1}]]}, 
   {RGBColor[0.31129095126135736`, 0.1970121906565412, 0.22784422146676248`], 
    RectangleBox[NCache[{Rational[63, 256], 0}, {0.24609375, 0}], 
     NCache[{Rational[1, 4], 1}, {0.25, 1}]]}, 
   {RGBColor[
    0.31091092410843935`, 0.20195788281485244`, 0.23693993916891348`], 
    RectangleBox[NCache[{Rational[1, 4], 0}, {0.25, 0}], 
     NCache[{Rational[65, 256], 1}, {0.25390625, 1}]]}, 
   {RGBColor[0.310313854822546, 0.20694296727930506`, 0.24607151604381966`], 
    RectangleBox[NCache[{Rational[65, 256], 0}, {0.25390625, 0}], 
     NCache[{Rational[33, 128], 1}, {0.2578125, 1}]]}, 
   {RGBColor[0.309499575484724, 0.21196424673374992`, 0.2552251541533211], 
    RectangleBox[NCache[{Rational[33, 128], 0}, {0.2578125, 0}], 
     NCache[{Rational[67, 256], 1}, {0.26171875, 1}]]}, 
   {RGBColor[0.30846840579181845`, 0.21701856995500962`, 0.2643868288361055], 
    RectangleBox[NCache[{Rational[67, 256], 0}, {0.26171875, 0}], 
     NCache[{Rational[17, 64], 1}, {0.265625, 1}]]}, 
   {RGBColor[0.3072211862214963, 0.22210283550343735`, 0.2735423314018742], 
    RectangleBox[NCache[{Rational[17, 64], 0}, {0.265625, 0}], 
     NCache[{Rational[69, 256], 1}, {0.26953125, 1}]]}, 
   {RGBColor[0.3057593122940032, 0.22721399515077267`, 0.28267731311082933`], 
    RectangleBox[NCache[{Rational[69, 256], 0}, {0.26953125, 0}], 
     NCache[{Rational[35, 128], 1}, {0.2734375, 1}]]}, 
   {RGBColor[0.30408477005858775`, 0.23234905708508835`, 0.2917773301870146], 
    RectangleBox[NCache[{Rational[35, 128], 0}, {0.2734375, 0}], 
     NCache[{Rational[71, 256], 1}, {0.27734375, 1}]]}, 
   {RGBColor[0.3022001729604326, 0.23750508892379102`, 0.3008278896233746], 
    RectangleBox[NCache[{Rational[71, 256], 0}, {0.27734375, 0}], 
     NCache[{Rational[9, 32], 1}, {0.28125, 1}]]}, 
   {RGBColor[0.30010880027207754`, 0.24267922055760793`, 0.309814495544891], 
    RectangleBox[NCache[{Rational[9, 32], 0}, {0.28125, 0}], 
     NCache[{Rational[73, 256], 1}, {0.28515625, 1}]]}, 
   {RGBColor[0.29781463730056323`, 0.2478686468413383, 0.31872269590401675`], 
    RectangleBox[NCache[{Rational[73, 256], 0}, {0.28515625, 0}], 
     NCache[{Rational[37, 128], 1}, {0.2890625, 1}]]}, 
   {RGBColor[0.2953224176063438, 0.25307063014081743`, 0.3275381292900419], 
    RectangleBox[NCache[{Rational[37, 128], 0}, {0.2890625, 0}], 
     NCache[{Rational[75, 256], 1}, {0.29296875, 1}]]}, 
   {RGBColor[0.292637667490308, 0.2582825027400695, 0.33624657164112637`], 
    RectangleBox[NCache[{Rational[75, 256], 0}, {0.29296875, 0}], 
     NCache[{Rational[19, 64], 1}, {0.296875, 1}]]}, 
   {RGBColor[0.2897667530181923, 0.26350166910795464`, 0.34483398265466747`], 
    RectangleBox[NCache[{Rational[19, 64], 0}, {0.296875, 0}], 
     NCache[{Rational[77, 256], 1}, {0.30078125, 1}]]}, 
   {RGBColor[0.28671692985353575`, 0.26872560801973194`, 0.3532865516985503], 
    RectangleBox[NCache[{Rational[77, 256], 0}, {0.30078125, 0}], 
     NCache[{Rational[39, 128], 1}, {0.3046875, 1}]]}, 
   {RGBColor[0.2834963961561572, 0.27395187452581793`, 0.3615907430327369], 
    RectangleBox[NCache[{Rational[39, 128], 0}, {0.3046875, 0}], 
     NCache[{Rational[79, 256], 1}, {0.30859375, 1}]]}, 
   {RGBColor[0.2801143487665763, 0.2791781017575825, 0.36973334015769566`], 
    RectangleBox[NCache[{Rational[79, 256], 0}, {0.30859375, 0}], 
     NCache[{Rational[5, 16], 1}, {0.3125, 1}]]}, 
   {RGBColor[
    0.27658104282960655`, 0.28440200255824605`, 0.37770148911339335`], 
    RectangleBox[NCache[{Rational[5, 16], 0}, {0.3125, 0}], 
     NCache[{Rational[81, 256], 1}, {0.31640625, 1}]]}, 
   {RGBColor[0.2729078549022085, 0.2896213709257755, 0.385482740560044], 
    RectangleBox[NCache[{Rational[81, 256], 0}, {0.31640625, 0}], 
     NCache[{Rational[41, 128], 1}, {0.3203125, 1}]]}, 
   {RGBColor[0.26910734942873765`, 0.2948340832540819, 0.39306509047956767`], 
    RectangleBox[NCache[{Rational[41, 128], 0}, {0.3203125, 0}], 
     NCache[{Rational[83, 256], 1}, {0.32421875, 1}]]}, 
   {RGBColor[
    0.26519334823539664`, 0.30003809935875014`, 0.40043701934479087`], 
    RectangleBox[NCache[{Rational[83, 256], 0}, {0.32421875, 0}], 
     NCache[{Rational[21, 64], 1}, {0.328125, 1}]]}, 
   {RGBColor[0.2611810023765936, 0.30523146327393536`, 0.4075875296118465], 
    RectangleBox[NCache[{Rational[21, 64], 0}, {0.328125, 0}], 
     NCache[{Rational[85, 256], 1}, {0.33203125, 1}]]}, 
   {RGBColor[0.25708686523808666`, 0.31041230380789503`, 0.4145061814000177], 
    RectangleBox[NCache[{Rational[85, 256], 0}, {0.33203125, 0}], 
     NCache[{Rational[43, 128], 1}, {0.3359375, 1}]]}, 
   {RGBColor[0.2529289652426483, 0.3155788348458495, 0.4211831262324292], 
    RectangleBox[NCache[{Rational[43, 128], 0}, {0.3359375, 0}], 
     NCache[{Rational[87, 256], 1}, {0.33984375, 1}]]}, 
   {RGBColor[0.24872687579097486`, 0.3207293553904209, 0.4276091387205178], 
    RectangleBox[NCache[{Rational[87, 256], 0}, {0.33984375, 0}], 
     NCache[{Rational[11, 32], 1}, {0.34375, 1}]]}, 
   {RGBColor[0.2445017791843898, 0.32586224933176194`, 0.4337756460851161], 
    RectangleBox[NCache[{Rational[11, 32], 0}, {0.34375, 0}], 
     NCache[{Rational[89, 256], 1}, {0.34765625, 1}]]}, 
   {RGBColor[0.24027652020548684`, 0.3309759849415891, 0.4396747554172398], 
    RectangleBox[NCache[{Rational[89, 256], 0}, {0.34765625, 0}], 
     NCache[{Rational[45, 128], 1}, {0.3515625, 1}]]}, 
   {RGBColor[0.2360756437827899, 0.33606911408764895`, 0.4452992785922722], 
    RectangleBox[NCache[{Rational[45, 128], 0}, {0.3515625, 0}], 
     NCache[{Rational[91, 256], 1}, {0.35546875, 1}]]}, 
   {RGBColor[
    0.23192540976618348`, 0.34114027116762335`, 0.45064275476216553`], 
    RectangleBox[NCache[{Rational[91, 256], 0}, {0.35546875, 0}], 
     NCache[{Rational[23, 64], 1}, {0.359375, 1}]]}, 
   {RGBColor[
    0.22785377636074378`, 0.34618817176407063`, 0.45569947036151387`], 
    RectangleBox[NCache[{Rational[23, 64], 0}, {0.359375, 0}], 
     NCache[{Rational[93, 256], 1}, {0.36328125, 1}]]}, 
   {RGBColor[0.2238903423310849, 0.35121161102467247`, 0.4604644765748433], 
    RectangleBox[NCache[{Rational[93, 256], 0}, {0.36328125, 0}], 
     NCache[{Rational[47, 128], 1}, {0.3671875, 1}]]}, 
   {RGBColor[
    0.22006623688898763`, 0.35620946177475754`, 0.46493360422422125`], 
    RectangleBox[NCache[{Rational[47, 128], 0}, {0.3671875, 0}], 
     NCache[{Rational[95, 256], 1}, {0.37109375, 1}]]}, 
   {RGBColor[0.21641394548589374`, 0.3611806723717733, 0.46910347604822505`], 
    RectangleBox[NCache[{Rational[95, 256], 0}, {0.37109375, 0}], 
     NCache[{Rational[3, 8], 1}, {0.375, 1}]]}, 
   {RGBColor[0.21296705989977605`, 0.3661242643140272, 0.47297151635542795`], 
    RectangleBox[NCache[{Rational[3, 8], 0}, {0.375, 0}], 
     NCache[{Rational[97, 256], 1}, {0.37890625, 1}]]}, 
   {RGBColor[0.209759942441529, 0.371039329618586, 0.47653595804779497`], 
    RectangleBox[NCache[{Rational[97, 256], 0}, {0.37890625, 0}], 
     NCache[{Rational[49, 128], 1}, {0.3828125, 1}]]}, 
   {RGBColor[0.20682729722425697`, 0.3759250279856666, 0.47979584702168837`], 
    RectangleBox[NCache[{Rational[49, 128], 0}, {0.3828125, 0}], 
     NCache[{Rational[99, 256], 1}, {0.38671875, 1}]]}, 
   {RGBColor[0.2042036465714448, 0.38078058376915075`, 0.4827510439665081], 
    RectangleBox[NCache[{Rational[99, 256], 0}, {0.38671875, 0}], 
     NCache[{Rational[25, 64], 1}, {0.390625, 1}]]}, 
   {RGBColor[0.2019227179099895, 0.38560528277495365`, 0.4854022235932883], 
    RectangleBox[NCache[{Rational[25, 64], 0}, {0.390625, 0}], 
     NCache[{Rational[101, 256], 1}, {0.39453125, 1}]]}, 
   {RGBColor[
    0.20001675567028082`, 0.39039846891087976`, 0.48775087133776146`], 
    RectangleBox[NCache[{Rational[101, 256], 0}, {0.39453125, 0}], 
     NCache[{Rational[51, 128], 1}, {0.3984375, 1}]]}, 
   {RGBColor[0.1985157830857725, 0.39515954071324544`, 0.4897992775944275], 
    RectangleBox[NCache[{Rational[51, 128], 0}, {0.3984375, 0}], 
     NCache[{Rational[103, 256], 1}, {0.40234375, 1}]]}, 
   {RGBColor[0.19744684910434118`, 0.3998879477769447, 0.4915505295499523], 
    RectangleBox[NCache[{Rational[103, 256], 0}, {0.40234375, 0}], 
     NCache[{Rational[13, 32], 1}, {0.40625, 1}]]}, 
   {RGBColor[0.1968333042026944, 0.40458318711674673`, 0.49300850069569396`], 
    RectangleBox[NCache[{Rational[13, 32], 0}, {0.40625, 0}], 
     NCache[{Rational[105, 256], 1}, {0.41015625, 1}]]}, 
   {RGBColor[0.19669415386022865`, 0.4092447994884352, 0.4941778381102105], 
    RectangleBox[NCache[{Rational[105, 256], 0}, {0.41015625, 0}], 
     NCache[{Rational[53, 128], 1}, {0.4140625, 1}]]}, 
   {RGBColor[0.19704353816754916`, 0.413872365698915, 0.495063947613171], 
    RectangleBox[NCache[{Rational[53, 128], 0}, {0.4140625, 0}], 
     NCache[{Rational[107, 256], 1}, {0.41796875, 1}]]}, 
   {RGBColor[0.19789037961345854`, 0.4184655029346248, 0.4956729769020573], 
    RectangleBox[NCache[{Rational[107, 256], 0}, {0.41796875, 0}], 
     NCache[{Rational[27, 64], 1}, {0.421875, 1}]]}, 
   {RGBColor[0.1992382287308598, 0.42302386113748564`, 0.49601179679228674`], 
    RectangleBox[NCache[{Rational[27, 64], 0}, {0.421875, 0}], 
     NCache[{Rational[109, 256], 1}, {0.42578125, 1}]]}, 
   {RGBColor[0.2010853204568291, 0.42754711945721985`, 0.49608798068981425`], 
    RectangleBox[NCache[{Rational[109, 256], 0}, {0.42578125, 0}], 
     NCache[{Rational[55, 128], 1}, {0.4296875, 1}]]}, 
   {RGBColor[0.2034248352656346, 0.43203498280815883`, 0.4959097824327271], 
    RectangleBox[NCache[{Rational[55, 128], 0}, {0.4296875, 0}], 
     NCache[{Rational[111, 256], 1}, {0.43359375, 1}]]}, 
   {RGBColor[
    0.20624534131942612`, 0.43648717855767377`, 0.49548611264470677`], 
    RectangleBox[NCache[{Rational[111, 256], 0}, {0.43359375, 0}], 
     NCache[{Rational[7, 16], 1}, {0.4375, 1}]]}, 
   {RGBColor[0.20953137975607733`, 0.44090345337209885`, 0.4948265137483489], 
    RectangleBox[NCache[{Rational[7, 16], 0}, {0.4375, 0}], 
     NCache[{Rational[113, 256], 1}, {0.44140625, 1}]]}, 
   {RGBColor[0.21326414663244422`, 0.4452835702445032, 0.49394113379004395`], 
    RectangleBox[NCache[{Rational[113, 256], 0}, {0.44140625, 0}], 
     NCache[{Rational[57, 128], 1}, {0.4453125, 1}]]}, 
   {RGBColor[0.2174222225898086, 0.44962730572693005`, 0.49284069923026724`], 
    RectangleBox[NCache[{Rational[57, 128], 0}, {0.4453125, 0}], 
     NCache[{Rational[115, 256], 1}, {0.44921875, 1}]]}, 
   {RGBColor[
    0.22198230444846517`, 0.45393444738777805`, 0.49153648685353785`], 
    RectangleBox[NCache[{Rational[115, 256], 0}, {0.44921875, 0}], 
     NCache[{Rational[29, 64], 1}, {0.453125, 1}]]}, 
   {RGBColor[0.226919900253015, 0.45820479151288523`, 0.49004029495080687`], 
    RectangleBox[NCache[{Rational[29, 64], 0}, {0.453125, 0}], 
     NCache[{Rational[117, 256], 1}, {0.45703125, 1}]]}, 
   {RGBColor[0.23220995897186236`, 0.4624381410666177, 0.4883644139234548], 
    RectangleBox[NCache[{Rational[117, 256], 0}, {0.45703125, 0}], 
     NCache[{Rational[59, 128], 1}, {0.4609375, 1}]]}, 
   {RGBColor[
    0.23782741635416169`, 0.46663430392689803`, 0.48652159645225074`], 
    RectangleBox[NCache[{Rational[59, 128], 0}, {0.4609375, 0}], 
     NCache[{Rational[119, 256], 1}, {0.46484375, 1}]]}, 
   {RGBColor[0.24374764798401996`, 0.47079309140565534`, 0.4845250273663884], 
    RectangleBox[NCache[{Rational[119, 256], 0}, {0.46484375, 0}], 
     NCache[{Rational[15, 32], 1}, {0.46875, 1}]]}, 
   {RGBColor[0.24994682846946703`, 0.47491431706369075`, 0.4823882933369373], 
    RectangleBox[NCache[{Rational[15, 32], 0}, {0.46875, 0}], 
     NCache[{Rational[121, 256], 1}, {0.47265625, 1}]]}, 
   {RGBColor[0.2564022015799132, 0.4789977958264337, 0.4801253525056192], 
    RectangleBox[NCache[{Rational[121, 256], 0}, {0.47265625, 0}], 
     NCache[{Rational[61, 128], 1}, {0.4765625, 1}]]}, 
   {RGBColor[0.2630922700060573, 0.48304334340457983`, 0.47775050414367043`], 
    RectangleBox[NCache[{Rational[61, 128], 0}, {0.4765625, 0}], 
     NCache[{Rational[123, 256], 1}, {0.48046875, 1}]]}, 
   {RGBColor[0.2699969155157998, 0.4870507760211445, 0.47527835841666655`], 
    RectangleBox[NCache[{Rational[123, 256], 0}, {0.48046875, 0}], 
     NCache[{Rational[31, 64], 1}, {0.484375, 1}]]}, 
   {RGBColor[
    0.27709746099401517`, 0.49101991044409316`, 0.47272380630962113`], 
    RectangleBox[NCache[{Rational[31, 64], 0}, {0.484375, 0}], 
     NCache[{Rational[125, 256], 1}, {0.48828125, 1}]]}, 
   {RGBColor[0.2843766855807584, 0.4949505643214345, 0.4701019897425714], 
    RectangleBox[NCache[{Rational[125, 256], 0}, {0.48828125, 0}], 
     NCache[{Rational[63, 128], 1}, {0.4921875, 1}]]}, 
   {RGBColor[0.2918188032197407, 0.4988425568134894, 0.4674282718804635], 
    RectangleBox[NCache[{Rational[63, 128], 0}, {0.4921875, 0}], 
     NCache[{Rational[127, 256], 1}, {0.49609375, 1}]]}, 
   {RGBColor[0.2994094136861262, 0.5026957095150372, 0.4647182076128325], 
    RectangleBox[NCache[{Rational[127, 256], 0}, {0.49609375, 0}], 
     NCache[{Rational[1, 2], 1}, {0.5, 1}]]}, 
   {RGBColor[0.30713543379305785`, 0.5065098476581554, 0.461987514149046], 
    RectangleBox[NCache[{Rational[1, 2], 0}, {0.5, 0}], 
     NCache[{Rational[129, 256], 1}, {0.50390625, 1}]]}, 
   {RGBColor[0.31498501512379884`, 0.510284801584868, 0.4592520416444356], 
    RectangleBox[NCache[{Rational[129, 256], 0}, {0.50390625, 0}], 
     NCache[{Rational[65, 128], 1}, {0.5078125, 1}]]}, 
   {RGBColor[0.32294745338815534`, 0.5140204084771628, 0.4565277437422836], 
    RectangleBox[NCache[{Rational[65, 128], 0}, {0.5078125, 0}], 
     NCache[{Rational[131, 256], 1}, {0.51171875, 1}]]}, 
   {RGBColor[0.3310130934029441, 0.5177165143305835, 0.4538306478874858], 
    RectangleBox[NCache[{Rational[131, 256], 0}, {0.51171875, 0}], 
     NCache[{Rational[33, 64], 1}, {0.515625, 1}]]}, 
   {RGBColor[0.33917323276226136`, 0.521372976156395, 0.45117682524089203`], 
    RectangleBox[NCache[{Rational[33, 64], 0}, {0.515625, 0}], 
     NCache[{Rational[133, 256], 1}, {0.51953125, 1}]]}, 
   {RGBColor[0.34742002649135895`, 0.5249896643963008, 0.44858236000032314`], 
    RectangleBox[NCache[{Rational[133, 256], 0}, {0.51953125, 0}], 
     NCache[{Rational[67, 128], 1}, {0.5234375, 1}]]}, 
   {RGBColor[0.3557463943543129, 0.5285664655328268, 0.44606331791654336`], 
    RectangleBox[NCache[{Rational[67, 128], 0}, {0.5234375, 0}], 
     NCache[{Rational[135, 256], 1}, {0.52734375, 1}]]}, 
   {RGBColor[0.36414593199168405`, 0.5321032848777818, 0.4436357137817325], 
    RectangleBox[NCache[{Rational[135, 256], 0}, {0.52734375, 0}], 
     NCache[{Rational[17, 32], 1}, {0.53125, 1}]]}, 
   {RGBColor[0.37261282667986395`, 0.5356000495206296, 0.44131547766589296`], 
    RectangleBox[NCache[{Rational[17, 32], 0}, {0.53125, 0}], 
     NCache[{Rational[137, 256], 1}, {0.53515625, 1}]]}, 
   {RGBColor[0.3811417782092229, 0.5390567114181851, 0.43911841968479404`], 
    RectangleBox[NCache[{Rational[137, 256], 0}, {0.53515625, 0}], 
     NCache[{Rational[69, 128], 1}, {0.5390625, 1}]]}, 
   {RGBColor[0.3897279251560661, 0.5424732506067097, 0.4370601931029884], 
    RectangleBox[NCache[{Rational[69, 128], 0}, {0.5390625, 0}], 
     NCache[{Rational[139, 256], 1}, {0.54296875, 1}]]}, 
   {RGBColor[0.39836677665848724`, 0.5458496785172593, 0.4351562556082915], 
    RectangleBox[NCache[{Rational[139, 256], 0}, {0.54296875, 0}], 
     NCache[{Rational[35, 64], 1}, {0.546875, 1}]]}, 
   {RGBColor[0.4070541496859188, 0.5491860413749962, 0.4334218286406867], 
    RectangleBox[NCache[{Rational[35, 64], 0}, {0.546875, 0}], 
     NCache[{Rational[141, 256], 1}, {0.55078125, 1}]]}, 
   {RGBColor[0.4157861117060971, 0.5524824236630778, 0.43187185471904527`], 
    RectangleBox[NCache[{Rational[141, 256], 0}, {0.55078125, 0}], 
     NCache[{Rational[71, 128], 1}, {0.5546875, 1}]]}, 
   {RGBColor[0.4245589285931605, 0.5557389516317083, 0.43052095278282676`], 
    RectangleBox[NCache[{Rational[71, 128], 0}, {0.5546875, 0}], 
     NCache[{Rational[143, 256], 1}, {0.55859375, 1}]]}, 
   {RGBColor[0.4333690175800776, 0.5589557968329216, 0.4293833716515864], 
    RectangleBox[NCache[{Rational[143, 256], 0}, {0.55859375, 0}], 
     NCache[{Rational[9, 16], 1}, {0.5625, 1}]]}, 
   {RGBColor[0.4422129050327188, 0.5621331796616653, 0.4284729418003805], 
    RectangleBox[NCache[{Rational[9, 16], 0}, {0.5625, 0}], 
     NCache[{Rational[145, 256], 1}, {0.56640625, 1}]]}, 
   {RGBColor[0.451087188807679, 0.5652713728837657, 0.42780302575067225`], 
    RectangleBox[NCache[{Rational[145, 256], 0}, {0.56640625, 0}], 
     NCache[{Rational[73, 128], 1}, {0.5703125, 1}]]}, 
   {RGBColor[0.45998850494865334`, 0.5683707051313407, 0.4273864674799085], 
    RectangleBox[NCache[{Rational[73, 128], 0}, {0.5703125, 0}], 
     NCache[{Rational[147, 256], 1}, {0.57421875, 1}]]}, 
   {RGBColor[0.4689134984745686, 0.5714315643462079, 0.4272355413535298], 
    RectangleBox[NCache[{Rational[147, 256], 0}, {0.57421875, 0}], 
     NCache[{Rational[37, 64], 1}, {0.578125, 1}]]}, 
   {RGBColor[0.47785879801517755`, 0.574454401151777, 0.4273619011752731], 
    RectangleBox[NCache[{Rational[37, 64], 0}, {0.578125, 0}], 
     NCache[{Rational[149, 256], 1}, {0.58203125, 1}]]}, 
   {RGBColor[0.48682099405528995`, 0.5774397321338388, 0.42777653002942817`], 
    RectangleBox[NCache[{Rational[149, 256], 0}, {0.58203125, 0}], 
     NCache[{Rational[75, 128], 1}, {0.5859375, 1}]]}, 
   {RGBColor[0.49579662055633184`, 0.5803881430105472, 0.4284896916466328], 
    RectangleBox[NCache[{Rational[75, 128], 0}, {0.5859375, 0}], 
     NCache[{Rational[151, 256], 1}, {0.58984375, 1}]]}, 
   {RGBColor[0.5047821397329011, 0.583300291671758, 0.4295108840578834], 
    RectangleBox[NCache[{Rational[151, 256], 0}, {0.58984375, 0}], 
     NCache[{Rational[19, 32], 1}, {0.59375, 1}]]}, 
   {RGBColor[0.5137739297718854, 0.5861769110677157, 0.4308487963057849], 
    RectangleBox[NCache[{Rational[19, 32], 0}, {0.59375, 0}], 
     NCache[{Rational[153, 256], 1}, {0.59765625, 1}]]}, 
   {RGBColor[0.522768275292231, 0.5890188119269117, 0.43251126895529046`], 
    RectangleBox[NCache[{Rational[153, 256], 0}, {0.59765625, 0}], 
     NCache[{Rational[77, 128], 1}, {0.6015625, 1}]]}, 
   {RGBColor[0.5317613603542702, 0.5918268852827537, 0.43450525908772486`], 
    RectangleBox[NCache[{Rational[77, 128], 0}, {0.6015625, 0}], 
     NCache[{Rational[155, 256], 1}, {0.60546875, 1}]]}, 
   {RGBColor[0.5407492638384059, 0.5946021047885187, 0.4368368103731295], 
    RectangleBox[NCache[{Rational[155, 256], 0}, {0.60546875, 0}], 
     NCache[{Rational[39, 64], 1}, {0.609375, 1}]]}, 
   {RGBColor[0.5497279570237593, 0.5973455287999239, 0.43951102870042047`], 
    RectangleBox[NCache[{Rational[39, 64], 0}, {0.609375, 0}], 
     NCache[{Rational[157, 256], 1}, {0.61328125, 1}]]}, 
   {RGBColor[0.5586933032079174, 0.6000583022045516, 0.4425320637077743], 
    RectangleBox[NCache[{Rational[157, 256], 0}, {0.61328125, 0}], 
     NCache[{Rational[79, 128], 1}, {0.6171875, 1}]]}, 
   {RGBColor[0.5676410592190582, 0.6027416579773464, 0.4459030964038789], 
    RectangleBox[NCache[{Rational[79, 128], 0}, {0.6171875, 0}], 
     NCache[{Rational[159, 256], 1}, {0.62109375, 1}]]}, 
   {RGBColor[0.5765668786813342, 0.6053969184414572, 0.4496263329120341], 
    RectangleBox[NCache[{Rational[159, 256], 0}, {0.62109375, 0}], 
     NCache[{Rational[5, 8], 1}, {0.625, 1}]]}, 
   {RGBColor[0.5854663169033912, 0.6080254962138943, 0.45370300421183024`], 
    RectangleBox[NCache[{Rational[5, 8], 0}, {0.625, 0}], 
     NCache[{Rational[161, 256], 1}, {0.62890625, 1}]]}, 
   {RGBColor[0.5943348372681693, 0.6106288948157613, 0.4581333716052534], 
    RectangleBox[NCache[{Rational[161, 256], 0}, {0.62890625, 0}], 
     NCache[{Rational[81, 128], 1}, {0.6328125, 1}]]}, 
   {RGBColor[0.6031678190096111, 0.6132087089273368, 0.4629167375029121], 
    RectangleBox[NCache[{Rational[81, 128], 0}, {0.6328125, 0}], 
     NCache[{Rational[163, 256], 1}, {0.63671875, 1}]]}, 
   {RGBColor[0.6119605662685341, 0.6157666242689159, 0.4680514610174233], 
    RectangleBox[NCache[{Rational[163, 256], 0}, {0.63671875, 0}], 
     NCache[{Rational[41, 64], 1}, {0.640625, 1}]]}, 
   {RGBColor[0.6207083183256614, 0.6183044170892292, 0.47353497776922177`], 
    RectangleBox[NCache[{Rational[41, 64], 0}, {0.640625, 0}], 
     NCache[{Rational[165, 256], 1}, {0.64453125, 1}]]}, 
   {RGBColor[0.6294062609146185, 0.6208239532443401, 0.4793638232573701], 
    RectangleBox[NCache[{Rational[165, 256], 0}, {0.64453125, 0}], 
     NCache[{Rational[83, 128], 1}, {0.6484375, 1}]]}, 
   {RGBColor[0.638049538521607, 0.6233271868513104, 0.4855336591248863], 
    RectangleBox[NCache[{Rational[83, 128], 0}, {0.6484375, 0}], 
     NCache[{Rational[167, 256], 1}, {0.65234375, 1}]]}, 
   {RGBColor[0.6466332675814146, 0.6258161585025295, 0.4920393016532543], 
    RectangleBox[NCache[{Rational[167, 256], 0}, {0.65234375, 0}], 
     NCache[{Rational[21, 32], 1}, {0.65625, 1}]]}, 
   {RGBColor[0.6551525504815179, 0.628292993028529, 0.4988747518513175], 
    RectangleBox[NCache[{Rational[21, 32], 0}, {0.65625, 0}], 
     NCache[{Rational[169, 256], 1}, {0.66015625, 1}]]}, 
   {RGBColor[0.6636024902872283, 0.6307598967993001, 0.5060332265556928], 
    RectangleBox[NCache[{Rational[169, 256], 0}, {0.66015625, 0}], 
     NCache[{Rational[85, 128], 1}, {0.6640625, 1}]]}, 
   {RGBColor[0.6719782061012696, 0.6332191545566189, 0.5135071900283993], 
    RectangleBox[NCache[{Rational[85, 128], 0}, {0.6640625, 0}], 
     NCache[{Rational[171, 256], 1}, {0.66796875, 1}]]}, 
   {RGBColor[0.6802748489708438, 0.6356731257726801, 0.5212883856175639], 
    RectangleBox[NCache[{Rational[171, 256], 0}, {0.66796875, 0}], 
     NCache[{Rational[43, 64], 1}, {0.671875, 1}]]}, 
   {RGBColor[0.6884876182542741, 0.6381242405334038, 0.5293678671337586], 
    RectangleBox[NCache[{Rational[43, 64], 0}, {0.671875, 0}], 
     NCache[{Rational[173, 256], 1}, {0.67578125, 1}]]}, 
   {RGBColor[0.6966117783577783, 0.6405749949481269, 0.5377360296830843], 
    RectangleBox[NCache[{Rational[173, 256], 0}, {0.67578125, 0}], 
     NCache[{Rational[87, 128], 1}, {0.6796875, 1}]]}, 
   {RGBColor[0.7046426757509289, 0.6430279460909876, 0.5463826397844355], 
    RectangleBox[NCache[{Rational[87, 128], 0}, {0.6796875, 0}], 
     NCache[{Rational[175, 256], 1}, {0.68359375, 1}]]}, 
   {RGBColor[0.7125757561669782, 0.645485706483127, 0.5552968646790701], 
    RectangleBox[NCache[{Rational[175, 256], 0}, {0.68359375, 0}], 
     NCache[{Rational[11, 16], 1}, {0.6875, 1}]]}, 
   {RGBColor[0.7204065818916331, 0.6479509381288556, 0.564467300813089], 
    RectangleBox[NCache[{Rational[11, 16], 0}, {0.6875, 0}], 
     NCache[{Rational[177, 256], 1}, {0.69140625, 1}]]}, 
   {RGBColor[0.7281308490410893, 0.6504263461230912, 0.5738820015359358], 
    RectangleBox[NCache[{Rational[177, 256], 0}, {0.69140625, 0}], 
     NCache[{Rational[89, 128], 1}, {0.6953125, 1}]]}, 
   {RGBColor[0.7357444047273731, 0.6529146718516464, 0.5835285041095046], 
    RectangleBox[NCache[{Rational[89, 128], 0}, {0.6953125, 0}], 
     NCache[{Rational[179, 256], 1}, {0.69921875, 1}]]}, 
   {RGBColor[0.7432432640063522, 0.6554186858102766, 0.5933938561625602], 
    RectangleBox[NCache[{Rational[179, 256], 0}, {0.69921875, 0}], 
     NCache[{Rational[45, 64], 1}, {0.703125, 1}]]}, 
   {RGBColor[0.7506236265012847, 0.6579411800727061, 0.6034646417540911], 
    RectangleBox[NCache[{Rational[45, 64], 0}, {0.703125, 0}], 
     NCache[{Rational[181, 256], 1}, {0.70703125, 1}]]}, 
   {RGBColor[0.757881892592645, 0.6604849604421037, 0.6137270072275768], 
    RectangleBox[NCache[{Rational[181, 256], 0}, {0.70703125, 0}], 
     NCache[{Rational[91, 128], 1}, {0.7109375, 1}]]}, 
   {RGBColor[0.765014679063202, 0.6630528383245965, 0.624166687046882], 
    RectangleBox[NCache[{Rational[91, 128], 0}, {0.7109375, 0}], 
     NCache[{Rational[183, 256], 1}, {0.71484375, 1}]]}, 
   {RGBColor[0.7720188340861572, 0.6656476223672991, 0.6347690298047464], 
    RectangleBox[NCache[{Rational[183, 256], 0}, {0.71484375, 0}], 
     NCache[{Rational[23, 32], 1}, {0.71875, 1}]]}, 
   {RGBColor[0.778891451443572, 0.6682721099069843, 0.6455190245878589], 
    RectangleBox[NCache[{Rational[23, 32], 0}, {0.71875, 0}], 
     NCache[{Rational[185, 256], 1}, {0.72265625, 1}]]}, 
   {RGBColor[0.7856298838624869, 0.6709290782787779, 0.6564013278696097], 
    RectangleBox[NCache[{Rational[185, 256], 0}, {0.72265625, 0}], 
     NCache[{Rational[93, 128], 1}, {0.7265625, 1}]]}, 
   {RGBColor[0.7922317553571229, 0.6736212760371393, 0.6674002910840082], 
    RectangleBox[NCache[{Rational[93, 128], 0}, {0.7265625, 0}], 
     NCache[{Rational[187, 256], 1}, {0.73046875, 1}]]}, 
   {RGBColor[0.7986949724674474, 0.6763514141437491, 0.6784999890131805], 
    RectangleBox[NCache[{Rational[187, 256], 0}, {0.73046875, 0}], 
     NCache[{Rational[47, 64], 1}, {0.734375, 1}]]}, 
   {RGBColor[0.8050177342872352, 0.6791221571787622, 0.6896842490973372], 
    RectangleBox[NCache[{Rational[47, 64], 0}, {0.734375, 0}], 
     NCache[{Rational[189, 256], 1}, {0.73828125, 1}]]}, 
   {RGBColor[0.8111985411786794, 0.6819361146331226, 0.700936681751136], 
    RectangleBox[NCache[{Rational[189, 256], 0}, {0.73828125, 0}], 
     NCache[{Rational[95, 128], 1}, {0.7421875, 1}]]}, 
   {RGBColor[0.8172362020755903, 0.6847958323402102, 0.7122407117447287], 
    RectangleBox[NCache[{Rational[95, 128], 0}, {0.7421875, 0}], 
     NCache[{Rational[191, 256], 1}, {0.74609375, 1}]]}, 
   {RGBColor[0.8231298402833719, 0.6877037841050104, 0.7235796106821919], 
    RectangleBox[NCache[{Rational[191, 256], 0}, {0.74609375, 0}], 
     NCache[{Rational[3, 4], 1}, {0.75, 1}]]}, 
   {RGBColor[0.8288788976913017, 0.6906623635881931, 0.7349365305850731], 
    RectangleBox[NCache[{Rational[3, 4], 0}, {0.75, 0}], 
     NCache[{Rational[193, 256], 1}, {0.75390625, 1}]]}, 
   {RGBColor[0.8344831373211414, 0.6936738765009876, 0.746294538564842], 
    RectangleBox[NCache[{Rational[193, 256], 0}, {0.75390625, 0}], 
     NCache[{Rational[97, 128], 1}, {0.7578125, 1}]]}, 
   {RGBColor[0.8399426441458906, 0.6967405331645077, 0.7576366525455175], 
    RectangleBox[NCache[{Rational[97, 128], 0}, {0.7578125, 0}], 
     NCache[{Rational[195, 256], 1}, {0.76171875, 1}]]}, 
   {RGBColor[0.8452578241233965, 0.6998644414842765, 0.7689458779768439], 
    RectangleBox[NCache[{Rational[195, 256], 0}, {0.76171875, 0}], 
     NCache[{Rational[49, 64], 1}, {0.765625, 1}]]}, 
   {RGBColor[0.850429401401725, 0.7030476003871028, 0.7802052454593379], 
    RectangleBox[NCache[{Rational[49, 64], 0}, {0.765625, 0}], 
     NCache[{Rational[197, 256], 1}, {0.76953125, 1}]]}, 
   {RGBColor[0.8554584136664454, 0.70629189376327, 0.791397849185383], 
    RectangleBox[NCache[{Rational[197, 256], 0}, {0.76953125, 0}], 
     NCache[{Rational[99, 128], 1}, {0.7734375, 1}]]}, 
   {RGBColor[0.8603462056143842, 0.7095990849522156, 0.8025068860853917], 
    RectangleBox[NCache[{Rational[99, 128], 0}, {0.7734375, 0}], 
     NCache[{Rational[199, 256], 1}, {0.77734375, 1}]]}, 
   {RGBColor[0.8650944205537978, 0.7129708118046255, 0.813515695554903], 
    RectangleBox[NCache[{Rational[199, 256], 0}, {0.77734375, 0}], 
     NCache[{Rational[25, 32], 1}, {0.78125, 1}]]}, 
   {RGBColor[0.8697049901472033, 0.7164085823481718, 0.8244077996272672], 
    RectangleBox[NCache[{Rational[25, 32], 0}, {0.78125, 0}], 
     NCache[{Rational[201, 256], 1}, {0.78515625, 1}]]}, 
   {RGBColor[0.8741801223302178, 0.7199137710781333, 0.8351669434473096], 
    RectangleBox[NCache[{Rational[201, 256], 0}, {0.78515625, 0}], 
     NCache[{Rational[101, 128], 1}, {0.7890625, 1}]]}, 
   {RGBColor[0.8785222874574837, 0.7234876158878804, 0.8457771358939189], 
    RectangleBox[NCache[{Rational[101, 128], 0}, {0.7890625, 0}], 
     NCache[{Rational[203, 256], 1}, {0.79296875, 1}]]}, 
   {RGBColor[0.8827342027449506, 0.727131215647855, 0.8562226901938538], 
    RectangleBox[NCache[{Rational[203, 256], 0}, {0.79296875, 0}], 
     NCache[{Rational[51, 64], 1}, {0.796875, 1}]]}, 
   {RGBColor[0.8868188150962691, 0.7308455284352732, 0.8664882643650689], 
    RectangleBox[NCache[{Rational[51, 64], 0}, {0.796875, 0}], 
     NCache[{Rational[205, 256], 1}, {0.80078125, 1}]]}, 
   {RGBColor[0.8907792824195595, 0.7346313704104621, 0.8765589013254552], 
    RectangleBox[NCache[{Rational[205, 256], 0}, {0.80078125, 0}], 
     NCache[{Rational[103, 128], 1}, {0.8046875, 1}]]}, 
   {RGBColor[0.8946189535591524, 0.7384894153296175, 0.8864200685019699], 
    RectangleBox[NCache[{Rational[103, 128], 0}, {0.8046875, 0}], 
     NCache[{Rational[207, 256], 1}, {0.80859375, 1}]]}, 
   {RGBColor[0.8983413469847661, 0.7424201946778858, 0.896057696775582], 
    RectangleBox[NCache[{Rational[207, 256], 0}, {0.80859375, 0}], 
     NCache[{Rational[13, 16], 1}, {0.8125, 1}]]}, 
   {RGBColor[0.9019501283977174, 0.7464240984011918, 0.9054582185992166], 
    RectangleBox[NCache[{Rational[13, 16], 0}, {0.8125, 0}], 
     NCache[{Rational[209, 256], 1}, {0.81640625, 1}]]}, 
   {RGBColor[0.9054490874298735, 0.7505013762101761, 0.9146086051288054], 
    RectangleBox[NCache[{Rational[209, 256], 0}, {0.81640625, 0}], 
     NCache[{Rational[105, 128], 1}, {0.8203125, 1}]]}, 
   {RGBColor[0.9088421136258261, 0.7546521394250556, 0.9234964022115921], 
    RectangleBox[NCache[{Rational[105, 128], 0}, {0.8203125, 0}], 
     NCache[{Rational[211, 256], 1}, {0.82421875, 1}]]}, 
   {RGBColor[0.9121331719119183, 0.7588763633262677, 0.9321097650808874], 
    RectangleBox[NCache[{Rational[211, 256], 0}, {0.82421875, 0}], 
     NCache[{Rational[53, 64], 1}, {0.828125, 1}]]}, 
   {RGBColor[0.9153262777669796, 0.7631738899723933, 0.9404374916124372], 
    RectangleBox[NCache[{Rational[53, 64], 0}, {0.828125, 0}], 
     NCache[{Rational[213, 256], 1}, {0.83203125, 1}]]}, 
   {RGBColor[0.918425472318628, 0.7675444314441587, 0.9484690540043755], 
    RectangleBox[NCache[{Rational[213, 256], 0}, {0.83203125, 0}], 
     NCache[{Rational[107, 128], 1}, {0.8359375, 1}]]}, 
   {RGBColor[0.9214347975955534, 0.7719875734712753, 0.9561946287503148], 
    RectangleBox[NCache[{Rational[107, 128], 0}, {0.8359375, 0}], 
     NCache[{Rational[215, 256], 1}, {0.83984375, 1}]]}, 
   {RGBColor[0.9243582721700068, 0.7765027793975091, 0.9636051247833978], 
    RectangleBox[NCache[{Rational[215, 256], 0}, {0.83984375, 0}], 
     NCache[{Rational[27, 32], 1}, {0.84375, 1}]]}, 
   {RGBColor[0.927199867425656, 0.781089394438662, 0.9706922096779939], 
    RectangleBox[NCache[{Rational[27, 32], 0}, {0.84375, 0}], 
     NCache[{Rational[217, 256], 1}, {0.84765625, 1}]]}, 
   {RGBColor[0.9299634846838329, 0.7857466501880835, 0.9774483338051733], 
    RectangleBox[NCache[{Rational[217, 256], 0}, {0.84765625, 0}], 
     NCache[{Rational[109, 128], 1}, {0.8515625, 1}]]}, 
   {RGBColor[0.9326529334158838, 0.7904736693248682, 0.9838667523479676], 
    RectangleBox[NCache[{Rational[109, 128], 0}, {0.8515625, 0}], 
     NCache[{Rational[219, 256], 1}, {0.85546875, 1}]]}, 
   {RGBColor[0.9352719107608463, 0.795269470480992, 0.9899415450927546], 
    RectangleBox[NCache[{Rational[219, 256], 0}, {0.85546875, 0}], 
     NCache[{Rational[55, 64], 1}, {0.859375, 1}]]}, 
   {RGBColor[0.9378239825559634, 0.8001329732252686, 0.9956676339237255], 
    RectangleBox[NCache[{Rational[55, 64], 0}, {0.859375, 0}], 
     NCache[{Rational[221, 256], 1}, {0.86328125, 1}]]}, 
   {RGBColor[0.9403125660727598, 0.8050630031240745, 1.], 
    RectangleBox[NCache[{Rational[221, 256], 0}, {0.86328125, 0}], 
     NCache[{Rational[111, 128], 1}, {0.8671875, 1}]]}, 
   {RGBColor[0.9427409146336475, 0.8100582968412506, 1.], 
    RectangleBox[NCache[{Rational[111, 128], 0}, {0.8671875, 0}], 
     NCache[{Rational[223, 256], 1}, {0.87109375, 1}]]}, 
   {RGBColor[0.9451121042635348, 0.8151175072423954, 1.], 
    RectangleBox[NCache[{Rational[223, 256], 0}, {0.87109375, 0}], 
     NCache[{Rational[7, 8], 1}, {0.875, 1}]]}, 
   {RGBColor[0.9474290225079861, 0.820239208471811, 1.], 
    RectangleBox[NCache[{Rational[7, 8], 0}, {0.875, 0}], 
     NCache[{Rational[225, 256], 1}, {0.87890625, 1}]]}, 
   {RGBColor[0.9496943595244144, 0.825421900973602, 1.], 
    RectangleBox[NCache[{Rational[225, 256], 0}, {0.87890625, 0}], 
     NCache[{Rational[113, 128], 1}, {0.8828125, 1}]]}, 
   {RGBColor[0.951910601526025, 0.8306640164318079, 1.], 
    RectangleBox[NCache[{Rational[113, 128], 0}, {0.8828125, 0}], 
     NCache[{Rational[227, 256], 1}, {0.88671875, 1}]]}, 
   {RGBColor[0.9540800266301613, 0.835963922607861, 1.], 
    RectangleBox[NCache[{Rational[227, 256], 0}, {0.88671875, 0}], 
     NCache[{Rational[57, 64], 1}, {0.890625, 1}]]}, 
   {RGBColor[0.9562047031338351, 0.8413199280571033, 1.], 
    RectangleBox[NCache[{Rational[57, 64], 0}, {0.890625, 0}], 
     NCache[{Rational[229, 256], 1}, {0.89453125, 1}]]}, 
   {RGBColor[0.9582864902100118, 0.8467302867094464, 1.], 
    RectangleBox[NCache[{Rational[229, 256], 0}, {0.89453125, 0}], 
     NCache[{Rational[115, 128], 1}, {0.8984375, 1}]]}, 
   {RGBColor[0.9603270409891808, 0.8521932023025315, 1.], 
    RectangleBox[NCache[{Rational[115, 128], 0}, {0.8984375, 0}], 
     NCache[{Rational[231, 256], 1}, {0.90234375, 1}]]}, 
   {RGBColor[0.9623278079623682, 0.8577068326588367, 1.], 
    RectangleBox[NCache[{Rational[231, 256], 0}, {0.90234375, 0}], 
     NCache[{Rational[29, 32], 1}, {0.90625, 1}]]}, 
   {RGBColor[0.9642900506144807, 0.8632692938011011, 1.], 
    RectangleBox[NCache[{Rational[29, 32], 0}, {0.90625, 0}], 
     NCache[{Rational[233, 256], 1}, {0.91015625, 1}]]}, 
   {RGBColor[0.9662148451712204, 0.8688786639031081, 1.], 
    RectangleBox[NCache[{Rational[233, 256], 0}, {0.91015625, 0}], 
     NCache[{Rational[117, 128], 1}, {0.9140625, 1}]]}, 
   {RGBColor[0.9681030963191041, 0.8745329870753211, 1.], 
    RectangleBox[NCache[{Rational[117, 128], 0}, {0.9140625, 0}], 
     NCache[{Rational[235, 256], 1}, {0.91796875, 1}]]}, 
   {RGBColor[0.9699555507367942, 0.8802302769870136, 1.], 
    RectangleBox[NCache[{Rational[235, 256], 0}, {0.91796875, 0}], 
     NCache[{Rational[59, 64], 1}, {0.921875, 1}]]}, 
   {RGBColor[0.9717728122572156, 0.8859685203284349, 1.], 
    RectangleBox[NCache[{Rational[59, 64], 0}, {0.921875, 0}], 
     NCache[{Rational[237, 256], 1}, {0.92578125, 1}]]}, 
   {RGBColor[0.9735553584641264, 0.8917456801181453, 1.], 
    RectangleBox[NCache[{Rational[237, 256], 0}, {0.92578125, 0}], 
     NCache[{Rational[119, 128], 1}, {0.9296875, 1}]]}, 
   {RGBColor[0.9753035585140043, 0.8975596988619662, 1.], 
    RectangleBox[NCache[{Rational[119, 128], 0}, {0.9296875, 0}], 
     NCache[{Rational[239, 256], 1}, {0.93359375, 1}]]}, 
   {RGBColor[0.9770176919644922, 0.9034085015710185, 1.], 
    RectangleBox[NCache[{Rational[239, 256], 0}, {0.93359375, 0}], 
     NCache[{Rational[15, 16], 1}, {0.9375, 1}]]}, 
   {RGBColor[0.978697968384186, 0.9092899986470824, 1.], 
    RectangleBox[NCache[{Rational[15, 16], 0}, {0.9375, 0}], 
     NCache[{Rational[241, 256], 1}, {0.94140625, 1}]]}, 
   {RGBColor[0.9803445475152625, 0.9152020886440076, 1.], 
    RectangleBox[NCache[{Rational[241, 256], 0}, {0.94140625, 0}], 
     NCache[{Rational[121, 128], 1}, {0.9453125, 1}]]}, 
   {RGBColor[0.9819575597602309, 0.9211426609141606, 1.], 
    RectangleBox[NCache[{Rational[121, 128], 0}, {0.9453125, 0}], 
     NCache[{Rational[243, 256], 1}, {0.94921875, 1}]]}, 
   {RGBColor[0.9835371267668073, 0.9271095981489347, 1.], 
    RectangleBox[NCache[{Rational[243, 256], 0}, {0.94921875, 0}], 
     NCache[{Rational[61, 64], 1}, {0.953125, 1}]]}, 
   {RGBColor[0.9850833818903765, 0.9331007788221813, 1.], 
    RectangleBox[NCache[{Rational[61, 64], 0}, {0.953125, 0}], 
     NCache[{Rational[245, 256], 1}, {0.95703125, 1}]]}, 
   {RGBColor[0.9865964903215029, 0.9391140795450937, 1.], 
    RectangleBox[NCache[{Rational[245, 256], 0}, {0.95703125, 0}], 
     NCache[{Rational[123, 128], 1}, {0.9609375, 1}]]}, 
   {RGBColor[0.9880766686761934, 0.9451473773405822, 1.], 
    RectangleBox[NCache[{Rational[123, 128], 0}, {0.9609375, 0}], 
     NCache[{Rational[247, 256], 1}, {0.96484375, 1}]]}, 
   {RGBColor[0.9895242038588957, 0.9511985518445815, 1.], 
    RectangleBox[NCache[{Rational[247, 256], 0}, {0.96484375, 0}], 
     NCache[{Rational[31, 32], 1}, {0.96875, 1}]]}, 
   {RGBColor[0.990939471022143, 0.957265487441017, 1.], 
    RectangleBox[NCache[{Rational[31, 32], 0}, {0.96875, 0}], 
     NCache[{Rational[249, 256], 1}, {0.97265625, 1}]]}, 
   {RGBColor[0.9923229504621377, 0.9633460753363925, 1.], 
    RectangleBox[NCache[{Rational[249, 256], 0}, {0.97265625, 0}], 
     NCache[{Rational[125, 128], 1}, {0.9765625, 1}]]}, 
   {RGBColor[0.9936752433060454, 0.9694382155791211, 1.], 
    RectangleBox[NCache[{Rational[125, 128], 0}, {0.9765625, 0}], 
     NCache[{Rational[251, 256], 1}, {0.98046875, 1}]]}, 
   {RGBColor[0.9949970858640694, 0.9755398190278924, 1.], 
    RectangleBox[NCache[{Rational[251, 256], 0}, {0.98046875, 0}], 
     NCache[{Rational[63, 64], 1}, {0.984375, 1}]]}, 
   {RGBColor[0.9962893625372552, 0.9816488092724923, 1.], 
    RectangleBox[NCache[{Rational[63, 64], 0}, {0.984375, 0}], 
     NCache[{Rational[253, 256], 1}, {0.98828125, 1}]]}, 
   {RGBColor[0.9975531171901121, 0.9877631245096746, 1.], 
    RectangleBox[NCache[{Rational[253, 256], 0}, {0.98828125, 0}], 
     NCache[{Rational[127, 128], 1}, {0.9921875, 1}]]}, 
   {RGBColor[0.9987895629154125, 0.9938807193758611, 1.], 
    RectangleBox[NCache[{Rational[127, 128], 0}, {0.9921875, 0}], 
     NCache[{Rational[255, 256], 1}, {0.99609375, 1}]]}, 
   {RGBColor[1., 0.9999995667376941, 0.9999992604295981], 
    RectangleBox[NCache[{Rational[255, 256], 0}, {0.99609375, 0}], {1, 1}]}},
  AspectRatio->0.2]], "Output",
 CellChangeTimes->{{3.648062884414217*^9, 3.6480628953909807`*^9}, 
   3.648063105349577*^9, 3.648064907742105*^9, 3.648067624216043*^9, {
   3.648068138573605*^9, 3.64806815115517*^9}, 3.648216287726901*^9, 
   3.649608460321231*^9, {3.655135306026805*^9, 3.655135313126101*^9}, 
   3.658032097480012*^9, 3.6622218789053183`*^9, 3.662226873455821*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"colorbar", "[", "mplrainbow", "]"}]], "Input",
 CellChangeTimes->{{3.648068188048293*^9, 3.648068193352982*^9}}],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0., 0., 0.], 
    RectangleBox[{0, 0}, NCache[{Rational[1, 256], 1}, {0.00390625, 1}]]}, 
   {RGBColor[0.00123208396, 0.00095547309, 0.00139798823], 
    RectangleBox[NCache[{Rational[1, 256], 0}, {0.00390625, 0}], 
     NCache[{Rational[1, 128], 1}, {0.0078125, 1}]]}, 
   {RGBColor[0.00229615544, 0.00178942817, 0.00287482272], 
    RectangleBox[NCache[{Rational[1, 128], 0}, {0.0078125, 0}], 
     NCache[{Rational[3, 256], 1}, {0.01171875, 1}]]}, 
   {RGBColor[0.00365605723, 0.00283344018, 0.00492480921], 
    RectangleBox[NCache[{Rational[3, 256], 0}, {0.01171875, 0}], 
     NCache[{Rational[1, 64], 1}, {0.015625, 1}]]}, 
   {RGBColor[0.00530551794, 0.00406778716, 0.00760691909], 
    RectangleBox[NCache[{Rational[1, 64], 0}, {0.015625, 0}], 
     NCache[{Rational[5, 256], 1}, {0.01953125, 1}]]}, 
   {RGBColor[0.00723736344, 0.00548161371, 0.0109431791], 
    RectangleBox[NCache[{Rational[5, 256], 0}, {0.01953125, 0}], 
     NCache[{Rational[3, 128], 1}, {0.0234375, 1}]]}, 
   {RGBColor[0.00945254296, 0.00705778542, 0.0150171636], 
    RectangleBox[NCache[{Rational[3, 128], 0}, {0.0234375, 0}], 
     NCache[{Rational[7, 256], 1}, {0.02734375, 1}]]}, 
   {RGBColor[0.0119482347, 0.00878720053, 0.0198667312], 
    RectangleBox[NCache[{Rational[7, 256], 0}, {0.02734375, 0}], 
     NCache[{Rational[1, 32], 1}, {0.03125, 1}]]}, 
   {RGBColor[0.0147228881, 0.0106611909, 0.025534909], 
    RectangleBox[NCache[{Rational[1, 32], 0}, {0.03125, 0}], 
     NCache[{Rational[9, 256], 1}, {0.03515625, 1}]]}, 
   {RGBColor[0.0177835018, 0.0126603657, 0.0321519132], 
    RectangleBox[NCache[{Rational[9, 256], 0}, {0.03515625, 0}], 
     NCache[{Rational[5, 128], 1}, {0.0390625, 1}]]}, 
   {RGBColor[0.0211220928, 0.0147877065, 0.039687175], 
    RectangleBox[NCache[{Rational[5, 128], 0}, {0.0390625, 0}], 
     NCache[{Rational[11, 256], 1}, {0.04296875, 1}]]}, 
   {RGBColor[0.0247515394, 0.0170167645, 0.0478036366], 
    RectangleBox[NCache[{Rational[11, 256], 0}, {0.04296875, 0}], 
     NCache[{Rational[3, 64], 1}, {0.046875, 1}]]}, 
   {RGBColor[0.0286638456, 0.0193519218, 0.0559687827], 
    RectangleBox[NCache[{Rational[3, 64], 0}, {0.046875, 0}], 
     NCache[{Rational[13, 256], 1}, {0.05078125, 1}]]}, 
   {RGBColor[0.0328682397, 0.0217723779, 0.0642706842], 
    RectangleBox[NCache[{Rational[13, 256], 0}, {0.05078125, 0}], 
     NCache[{Rational[7, 128], 1}, {0.0546875, 1}]]}, 
   {RGBColor[0.0373641166, 0.0242719221, 0.0726898674], 
    RectangleBox[NCache[{Rational[7, 128], 0}, {0.0546875, 0}], 
     NCache[{Rational[15, 256], 1}, {0.05859375, 1}]]}, 
   {RGBColor[0.0421050647, 0.0268397654, 0.0812355395], 
    RectangleBox[NCache[{Rational[15, 256], 0}, {0.05859375, 0}], 
     NCache[{Rational[1, 16], 1}, {0.0625, 1}]]}, 
   {RGBColor[0.0468284728, 0.0294586559, 0.0899433646], 
    RectangleBox[NCache[{Rational[1, 16], 0}, {0.0625, 0}], 
     NCache[{Rational[17, 256], 1}, {0.06640625, 1}]]}, 
   {RGBColor[0.0515141518, 0.032125641, 0.09878169], 
    RectangleBox[NCache[{Rational[17, 256], 0}, {0.06640625, 0}], 
     NCache[{Rational[9, 128], 1}, {0.0703125, 1}]]}, 
   {RGBColor[0.0561710528, 0.0348169996, 0.107806321], 
    RectangleBox[NCache[{Rational[9, 128], 0}, {0.0703125, 0}], 
     NCache[{Rational[19, 256], 1}, {0.07421875, 1}]]}, 
   {RGBColor[0.0607964611, 0.0375295002, 0.116986953], 
    RectangleBox[NCache[{Rational[19, 256], 0}, {0.07421875, 0}], 
     NCache[{Rational[5, 64], 1}, {0.078125, 1}]]}, 
   {RGBColor[0.0653942936, 0.0402451065, 0.126350147], 
    RectangleBox[NCache[{Rational[5, 64], 0}, {0.078125, 0}], 
     NCache[{Rational[21, 256], 1}, {0.08203125, 1}]]}, 
   {RGBColor[0.0699678963, 0.042858932, 0.135923729], 
    RectangleBox[NCache[{Rational[21, 256], 0}, {0.08203125, 0}], 
     NCache[{Rational[11, 128], 1}, {0.0859375, 1}]]}, 
   {RGBColor[0.0745082197, 0.0453694998, 0.145639655], 
    RectangleBox[NCache[{Rational[11, 128], 0}, {0.0859375, 0}], 
     NCache[{Rational[23, 256], 1}, {0.08984375, 1}]]}, 
   {RGBColor[0.0790330506, 0.0477307435, 0.155656679], 
    RectangleBox[NCache[{Rational[23, 256], 0}, {0.08984375, 0}], 
     NCache[{Rational[3, 32], 1}, {0.09375, 1}]]}, 
   {RGBColor[0.0835202958, 0.0499952955, 0.165809116], 
    RectangleBox[NCache[{Rational[3, 32], 0}, {0.09375, 0}], 
     NCache[{Rational[25, 256], 1}, {0.09765625, 1}]]}, 
   {RGBColor[0.0879834474, 0.0521177479, 0.176237541], 
    RectangleBox[NCache[{Rational[25, 256], 0}, {0.09765625, 0}], 
     NCache[{Rational[13, 128], 1}, {0.1015625, 1}]]}, 
   {RGBColor[0.0924150207, 0.0541059968, 0.186915608], 
    RectangleBox[NCache[{Rational[13, 128], 0}, {0.1015625, 0}], 
     NCache[{Rational[27, 256], 1}, {0.10546875, 1}]]}, 
   {RGBColor[0.0968029626, 0.0559815865, 0.197781923], 
    RectangleBox[NCache[{Rational[27, 256], 0}, {0.10546875, 0}], 
     NCache[{Rational[7, 64], 1}, {0.109375, 1}]]}, 
   {RGBColor[0.101151155, 0.0577100082, 0.208936447], 
    RectangleBox[NCache[{Rational[7, 64], 0}, {0.109375, 0}], 
     NCache[{Rational[29, 256], 1}, {0.11328125, 1}]]}, 
   {RGBColor[0.105451837, 0.0592849001, 0.220396438], 
    RectangleBox[NCache[{Rational[29, 256], 0}, {0.11328125, 0}], 
     NCache[{Rational[15, 128], 1}, {0.1171875, 1}]]}, 
   {RGBColor[0.10968688, 0.0607326502, 0.232095082], 
    RectangleBox[NCache[{Rational[15, 128], 0}, {0.1171875, 0}], 
     NCache[{Rational[31, 256], 1}, {0.12109375, 1}]]}, 
   {RGBColor[0.113843713, 0.0620506875, 0.244050536], 
    RectangleBox[NCache[{Rational[31, 256], 0}, {0.12109375, 0}], 
     NCache[{Rational[1, 8], 1}, {0.125, 1}]]}, 
   {RGBColor[0.117904959, 0.0632397421, 0.256278], 
    RectangleBox[NCache[{Rational[1, 8], 0}, {0.125, 0}], 
     NCache[{Rational[33, 256], 1}, {0.12890625, 1}]]}, 
   {RGBColor[0.121846598, 0.064306871, 0.268785988], 
    RectangleBox[NCache[{Rational[33, 256], 0}, {0.12890625, 0}], 
     NCache[{Rational[17, 128], 1}, {0.1328125, 1}]]}, 
   {RGBColor[0.1256355, 0.0652701612, 0.281570678], 
    RectangleBox[NCache[{Rational[17, 128], 0}, {0.1328125, 0}], 
     NCache[{Rational[35, 256], 1}, {0.13671875, 1}]]}, 
   {RGBColor[0.129226271, 0.0661657005, 0.294607743], 
    RectangleBox[NCache[{Rational[35, 256], 0}, {0.13671875, 0}], 
     NCache[{Rational[9, 64], 1}, {0.140625, 1}]]}, 
   {RGBColor[0.132557443, 0.0670572149, 0.307841226], 
    RectangleBox[NCache[{Rational[9, 64], 0}, {0.140625, 0}], 
     NCache[{Rational[37, 256], 1}, {0.14453125, 1}]]}, 
   {RGBColor[0.135547409, 0.0680479794, 0.321169632], 
    RectangleBox[NCache[{Rational[37, 256], 0}, {0.14453125, 0}], 
     NCache[{Rational[19, 128], 1}, {0.1484375, 1}]]}, 
   {RGBColor[0.138091076, 0.0692926359, 0.334430764], 
    RectangleBox[NCache[{Rational[19, 128], 0}, {0.1484375, 0}], 
     NCache[{Rational[39, 256], 1}, {0.15234375, 1}]]}, 
   {RGBColor[0.140040521, 0.0709626931, 0.34750866], 
    RectangleBox[NCache[{Rational[39, 256], 0}, {0.15234375, 0}], 
     NCache[{Rational[5, 32], 1}, {0.15625, 1}]]}, 
   {RGBColor[0.141240948, 0.0733731827, 0.359972935], 
    RectangleBox[NCache[{Rational[5, 32], 0}, {0.15625, 0}], 
     NCache[{Rational[41, 256], 1}, {0.16015625, 1}]]}, 
   {RGBColor[0.141507741, 0.0768055544, 0.371470975], 
    RectangleBox[NCache[{Rational[41, 256], 0}, {0.16015625, 0}], 
     NCache[{Rational[21, 128], 1}, {0.1640625, 1}]]}, 
   {RGBColor[0.140750085, 0.0815085404, 0.381459968], 
    RectangleBox[NCache[{Rational[21, 128], 0}, {0.1640625, 0}], 
     NCache[{Rational[43, 256], 1}, {0.16796875, 1}]]}, 
   {RGBColor[0.138978078, 0.0875006802, 0.389596616], 
    RectangleBox[NCache[{Rational[43, 256], 0}, {0.16796875, 0}], 
     NCache[{Rational[11, 64], 1}, {0.171875, 1}]]}, 
   {RGBColor[0.136328543, 0.0945637193, 0.395783386], 
    RectangleBox[NCache[{Rational[11, 64], 0}, {0.171875, 0}], 
     NCache[{Rational[45, 256], 1}, {0.17578125, 1}]]}, 
   {RGBColor[0.133020255, 0.102337765, 0.400175258], 
    RectangleBox[NCache[{Rational[45, 256], 0}, {0.17578125, 0}], 
     NCache[{Rational[23, 128], 1}, {0.1796875, 1}]]}, 
   {RGBColor[0.129250417, 0.110478799, 0.403074022], 
    RectangleBox[NCache[{Rational[23, 128], 0}, {0.1796875, 0}], 
     NCache[{Rational[47, 256], 1}, {0.18359375, 1}]]}, 
   {RGBColor[0.125151398, 0.118742158, 0.404788627], 
    RectangleBox[NCache[{Rational[47, 256], 0}, {0.18359375, 0}], 
     NCache[{Rational[3, 16], 1}, {0.1875, 1}]]}, 
   {RGBColor[0.120897791, 0.126928615, 0.405612684], 
    RectangleBox[NCache[{Rational[3, 16], 0}, {0.1875, 0}], 
     NCache[{Rational[49, 256], 1}, {0.19140625, 1}]]}, 
   {RGBColor[0.116503773, 0.134976096, 0.405743218], 
    RectangleBox[NCache[{Rational[49, 256], 0}, {0.19140625, 0}], 
     NCache[{Rational[25, 128], 1}, {0.1953125, 1}]]}, 
   {RGBColor[0.112091791, 0.142800379, 0.405380296], 
    RectangleBox[NCache[{Rational[25, 128], 0}, {0.1953125, 0}], 
     NCache[{Rational[51, 256], 1}, {0.19921875, 1}]]}, 
   {RGBColor[0.10766772, 0.150397779, 0.404637066], 
    RectangleBox[NCache[{Rational[51, 256], 0}, {0.19921875, 0}], 
     NCache[{Rational[13, 64], 1}, {0.203125, 1}]]}, 
   {RGBColor[0.103261075, 0.157763499, 0.403610287], 
    RectangleBox[NCache[{Rational[13, 64], 0}, {0.203125, 0}], 
     NCache[{Rational[53, 256], 1}, {0.20703125, 1}]]}, 
   {RGBColor[0.0989139075, 0.164894349, 0.40238618], 
    RectangleBox[NCache[{Rational[53, 256], 0}, {0.20703125, 0}], 
     NCache[{Rational[27, 128], 1}, {0.2109375, 1}]]}, 
   {RGBColor[0.0946605957, 0.171795271, 0.401032857], 
    RectangleBox[NCache[{Rational[27, 128], 0}, {0.2109375, 0}], 
     NCache[{Rational[55, 256], 1}, {0.21484375, 1}]]}, 
   {RGBColor[0.0904966075, 0.178488051, 0.399581412], 
    RectangleBox[NCache[{Rational[55, 256], 0}, {0.21484375, 0}], 
     NCache[{Rational[7, 32], 1}, {0.21875, 1}]]}, 
   {RGBColor[0.0864400964, 0.184985184, 0.398068674], 
    RectangleBox[NCache[{Rational[7, 32], 0}, {0.21875, 0}], 
     NCache[{Rational[57, 256], 1}, {0.22265625, 1}]]}, 
   {RGBColor[0.0825068783, 0.191299899, 0.396523264], 
    RectangleBox[NCache[{Rational[57, 256], 0}, {0.22265625, 0}], 
     NCache[{Rational[29, 128], 1}, {0.2265625, 1}]]}, 
   {RGBColor[0.0787110863, 0.197445454, 0.394967383], 
    RectangleBox[NCache[{Rational[29, 128], 0}, {0.2265625, 0}], 
     NCache[{Rational[59, 256], 1}, {0.23046875, 1}]]}, 
   {RGBColor[0.075065626, 0.203434722, 0.393418199], 
    RectangleBox[NCache[{Rational[59, 256], 0}, {0.23046875, 0}], 
     NCache[{Rational[15, 64], 1}, {0.234375, 1}]]}, 
   {RGBColor[0.0715824638, 0.209279955, 0.391888928], 
    RectangleBox[NCache[{Rational[15, 64], 0}, {0.234375, 0}], 
     NCache[{Rational[61, 256], 1}, {0.23828125, 1}]]}, 
   {RGBColor[0.0682727786, 0.214992675, 0.390389666], 
    RectangleBox[NCache[{Rational[61, 256], 0}, {0.23828125, 0}], 
     NCache[{Rational[31, 128], 1}, {0.2421875, 1}]]}, 
   {RGBColor[0.0651469969, 0.220583627, 0.388928035], 
    RectangleBox[NCache[{Rational[31, 128], 0}, {0.2421875, 0}], 
     NCache[{Rational[63, 256], 1}, {0.24609375, 1}]]}, 
   {RGBColor[0.0622147318, 0.226062789, 0.387509681], 
    RectangleBox[NCache[{Rational[63, 256], 0}, {0.24609375, 0}], 
     NCache[{Rational[1, 4], 1}, {0.25, 1}]]}, 
   {RGBColor[0.0594846413, 0.2314394, 0.386138652], 
    RectangleBox[NCache[{Rational[1, 4], 0}, {0.25, 0}], 
     NCache[{Rational[65, 256], 1}, {0.25390625, 1}]]}, 
   {RGBColor[0.0569642263, 0.236722005, 0.384817703], 
    RectangleBox[NCache[{Rational[65, 256], 0}, {0.25390625, 0}], 
     NCache[{Rational[33, 128], 1}, {0.2578125, 1}]]}, 
   {RGBColor[0.0546595872, 0.241918503, 0.383548521], 
    RectangleBox[NCache[{Rational[33, 128], 0}, {0.2578125, 0}], 
     NCache[{Rational[67, 256], 1}, {0.26171875, 1}]]}, 
   {RGBColor[0.0525751624, 0.247036203, 0.382331902], 
    RectangleBox[NCache[{Rational[67, 256], 0}, {0.26171875, 0}], 
     NCache[{Rational[17, 64], 1}, {0.265625, 1}]]}, 
   {RGBColor[0.0507134751, 0.25208187, 0.38116789], 
    RectangleBox[NCache[{Rational[17, 64], 0}, {0.265625, 0}], 
     NCache[{Rational[69, 256], 1}, {0.26953125, 1}]]}, 
   {RGBColor[0.0490749156, 0.257061774, 0.380055881], 
    RectangleBox[NCache[{Rational[69, 256], 0}, {0.26953125, 0}], 
     NCache[{Rational[35, 128], 1}, {0.2734375, 1}]]}, 
   {RGBColor[0.0476575847, 0.261981734, 0.378994708], 
    RectangleBox[NCache[{Rational[35, 128], 0}, {0.2734375, 0}], 
     NCache[{Rational[71, 256], 1}, {0.27734375, 1}]]}, 
   {RGBColor[0.0464572218, 0.266847155, 0.377982702], 
    RectangleBox[NCache[{Rational[71, 256], 0}, {0.27734375, 0}], 
     NCache[{Rational[9, 32], 1}, {0.28125, 1}]]}, 
   {RGBColor[0.0454672343, 0.271663063, 0.377017741], 
    RectangleBox[NCache[{Rational[9, 32], 0}, {0.28125, 0}], 
     NCache[{Rational[73, 256], 1}, {0.28515625, 1}]]}, 
   {RGBColor[0.0446840991, 0.276433278, 0.376100669], 
    RectangleBox[NCache[{Rational[73, 256], 0}, {0.28515625, 0}], 
     NCache[{Rational[37, 128], 1}, {0.2890625, 1}]]}, 
   {RGBColor[0.0440912972, 0.281163132, 0.375224852], 
    RectangleBox[NCache[{Rational[37, 128], 0}, {0.2890625, 0}], 
     NCache[{Rational[75, 256], 1}, {0.29296875, 1}]]}, 
   {RGBColor[0.0436760356, 0.285856732, 0.374386744], 
    RectangleBox[NCache[{Rational[75, 256], 0}, {0.29296875, 0}], 
     NCache[{Rational[19, 64], 1}, {0.296875, 1}]]}, 
   {RGBColor[0.0434247319, 0.290517832, 0.373582732], 
    RectangleBox[NCache[{Rational[19, 64], 0}, {0.296875, 0}], 
     NCache[{Rational[77, 256], 1}, {0.30078125, 1}]]}, 
   {RGBColor[0.0433230538, 0.295149919, 0.372808888], 
    RectangleBox[NCache[{Rational[77, 256], 0}, {0.30078125, 0}], 
     NCache[{Rational[39, 128], 1}, {0.3046875, 1}]]}, 
   {RGBColor[0.0433563883, 0.299756226, 0.372060986], 
    RectangleBox[NCache[{Rational[39, 128], 0}, {0.3046875, 0}], 
     NCache[{Rational[79, 256], 1}, {0.30859375, 1}]]}, 
   {RGBColor[0.0435103092, 0.30433974, 0.371334509], 
    RectangleBox[NCache[{Rational[79, 256], 0}, {0.30859375, 0}], 
     NCache[{Rational[5, 16], 1}, {0.3125, 1}]]}, 
   {RGBColor[0.0437710212, 0.308903211, 0.370624672], 
    RectangleBox[NCache[{Rational[5, 16], 0}, {0.3125, 0}], 
     NCache[{Rational[81, 256], 1}, {0.31640625, 1}]]}, 
   {RGBColor[0.0441282904, 0.313448805, 0.369928058], 
    RectangleBox[NCache[{Rational[81, 256], 0}, {0.31640625, 0}], 
     NCache[{Rational[41, 128], 1}, {0.3203125, 1}]]}, 
   {RGBColor[0.0445674054, 0.317979294, 0.369237225], 
    RectangleBox[NCache[{Rational[41, 128], 0}, {0.3203125, 0}], 
     NCache[{Rational[83, 256], 1}, {0.32421875, 1}]]}, 
   {RGBColor[0.0450786065, 0.322496756, 0.368546588], 
    RectangleBox[NCache[{Rational[83, 256], 0}, {0.32421875, 0}], 
     NCache[{Rational[21, 64], 1}, {0.328125, 1}]]}, 
   {RGBColor[0.0456542782, 0.327003032, 0.367850463], 
    RectangleBox[NCache[{Rational[21, 64], 0}, {0.328125, 0}], 
     NCache[{Rational[85, 256], 1}, {0.33203125, 1}]]}, 
   {RGBColor[0.0462889953, 0.331499739, 0.367142985], 
    RectangleBox[NCache[{Rational[85, 256], 0}, {0.33203125, 0}], 
     NCache[{Rational[43, 128], 1}, {0.3359375, 1}]]}, 
   {RGBColor[0.0469796908, 0.335988283, 0.366418129], 
    RectangleBox[NCache[{Rational[43, 128], 0}, {0.3359375, 0}], 
     NCache[{Rational[87, 256], 1}, {0.33984375, 1}]]}, 
   {RGBColor[0.0477257788, 0.340469852, 0.365669737], 
    RectangleBox[NCache[{Rational[87, 256], 0}, {0.33984375, 0}], 
     NCache[{Rational[11, 32], 1}, {0.34375, 1}]]}, 
   {RGBColor[0.0485291489, 0.344945431, 0.364891487], 
    RectangleBox[NCache[{Rational[11, 32], 0}, {0.34375, 0}], 
     NCache[{Rational[89, 256], 1}, {0.34765625, 1}]]}, 
   {RGBColor[0.0493936792, 0.349415875, 0.364076553], 
    RectangleBox[NCache[{Rational[89, 256], 0}, {0.34765625, 0}], 
     NCache[{Rational[45, 128], 1}, {0.3515625, 1}]]}, 
   {RGBColor[0.0503265816, 0.353881729, 0.363218552], 
    RectangleBox[NCache[{Rational[45, 128], 0}, {0.3515625, 0}], 
     NCache[{Rational[91, 256], 1}, {0.35546875, 1}]]}, 
   {RGBColor[0.0513376114, 0.35834333, 0.362311095], 
    RectangleBox[NCache[{Rational[91, 256], 0}, {0.35546875, 0}], 
     NCache[{Rational[23, 64], 1}, {0.359375, 1}]]}, 
   {RGBColor[0.0524389267, 0.362800809, 0.361347801], 
    RectangleBox[NCache[{Rational[23, 64], 0}, {0.359375, 0}], 
     NCache[{Rational[93, 256], 1}, {0.36328125, 1}]]}, 
   {RGBColor[0.0536449018, 0.367254102, 0.360322329], 
    RectangleBox[NCache[{Rational[93, 256], 0}, {0.36328125, 0}], 
     NCache[{Rational[47, 128], 1}, {0.3671875, 1}]]}, 
   {RGBColor[0.0549718276, 0.371702955, 0.359228375], 
    RectangleBox[NCache[{Rational[47, 128], 0}, {0.3671875, 0}], 
     NCache[{Rational[95, 256], 1}, {0.37109375, 1}]]}, 
   {RGBColor[0.0564358645, 0.376147176, 0.358058223], 
    RectangleBox[NCache[{Rational[95, 256], 0}, {0.37109375, 0}], 
     NCache[{Rational[3, 8], 1}, {0.375, 1}]]}, 
   {RGBColor[0.0580577474, 0.380585934, 0.356806935], 
    RectangleBox[NCache[{Rational[3, 8], 0}, {0.375, 0}], 
     NCache[{Rational[97, 256], 1}, {0.37890625, 1}]]}, 
   {RGBColor[0.0598575991, 0.385018417, 0.355468636], 
    RectangleBox[NCache[{Rational[97, 256], 0}, {0.37890625, 0}], 
     NCache[{Rational[49, 128], 1}, {0.3828125, 1}]]}, 
   {RGBColor[0.06185582, 0.389443647, 0.354037625], 
    RectangleBox[NCache[{Rational[49, 128], 0}, {0.3828125, 0}], 
     NCache[{Rational[99, 256], 1}, {0.38671875, 1}]]}, 
   {RGBColor[0.064072551, 0.393860487, 0.352508403], 
    RectangleBox[NCache[{Rational[99, 256], 0}, {0.38671875, 0}], 
     NCache[{Rational[25, 64], 1}, {0.390625, 1}]]}, 
   {RGBColor[0.0665271332, 0.398267655, 0.350875686], 
    RectangleBox[NCache[{Rational[25, 64], 0}, {0.390625, 0}], 
     NCache[{Rational[101, 256], 1}, {0.39453125, 1}]]}, 
   {RGBColor[0.0692375954, 0.402663728, 0.349134426], 
    RectangleBox[NCache[{Rational[101, 256], 0}, {0.39453125, 0}], 
     NCache[{Rational[51, 128], 1}, {0.3984375, 1}]]}, 
   {RGBColor[0.0722190954, 0.407047379, 0.347278053], 
    RectangleBox[NCache[{Rational[51, 128], 0}, {0.3984375, 0}], 
     NCache[{Rational[103, 256], 1}, {0.40234375, 1}]]}, 
   {RGBColor[0.075486454, 0.411416856, 0.345302457], 
    RectangleBox[NCache[{Rational[103, 256], 0}, {0.40234375, 0}], 
     NCache[{Rational[13, 32], 1}, {0.40625, 1}]]}, 
   {RGBColor[0.0790521742, 0.415770242, 0.343204352], 
    RectangleBox[NCache[{Rational[13, 32], 0}, {0.40625, 0}], 
     NCache[{Rational[105, 256], 1}, {0.41015625, 1}]]}, 
   {RGBColor[0.0829254846, 0.420105651, 0.34097977], 
    RectangleBox[NCache[{Rational[105, 256], 0}, {0.41015625, 0}], 
     NCache[{Rational[53, 128], 1}, {0.4140625, 1}]]}, 
   {RGBColor[0.0871129773, 0.42442111, 0.338625025], 
    RectangleBox[NCache[{Rational[53, 128], 0}, {0.4140625, 0}], 
     NCache[{Rational[107, 256], 1}, {0.41796875, 1}]]}, 
   {RGBColor[0.091618667, 0.428714566, 0.336136719], 
    RectangleBox[NCache[{Rational[107, 256], 0}, {0.41796875, 0}], 
     NCache[{Rational[27, 64], 1}, {0.421875, 1}]]}, 
   {RGBColor[0.0964441393, 0.432983895, 0.333511739], 
    RectangleBox[NCache[{Rational[27, 64], 0}, {0.421875, 0}], 
     NCache[{Rational[109, 256], 1}, {0.42578125, 1}]]}, 
   {RGBColor[0.101588767, 0.437226916, 0.330747257], 
    RectangleBox[NCache[{Rational[109, 256], 0}, {0.42578125, 0}], 
     NCache[{Rational[55, 128], 1}, {0.4296875, 1}]]}, 
   {RGBColor[0.107049974, 0.441441396, 0.327840728], 
    RectangleBox[NCache[{Rational[55, 128], 0}, {0.4296875, 0}], 
     NCache[{Rational[111, 256], 1}, {0.43359375, 1}]]}, 
   {RGBColor[0.112823855, 0.445625238, 0.324786969], 
    RectangleBox[NCache[{Rational[111, 256], 0}, {0.43359375, 0}], 
     NCache[{Rational[7, 16], 1}, {0.4375, 1}]]}, 
   {RGBColor[0.118904971, 0.449775948, 0.321586143], 
    RectangleBox[NCache[{Rational[7, 16], 0}, {0.4375, 0}], 
     NCache[{Rational[113, 256], 1}, {0.44140625, 1}]]}, 
   {RGBColor[0.125286565, 0.453891139, 0.318237146], 
    RectangleBox[NCache[{Rational[113, 256], 0}, {0.44140625, 0}], 
     NCache[{Rational[57, 128], 1}, {0.4453125, 1}]]}, 
   {RGBColor[0.131961058, 0.457968449, 0.314738541], 
    RectangleBox[NCache[{Rational[57, 128], 0}, {0.4453125, 0}], 
     NCache[{Rational[115, 256], 1}, {0.44921875, 1}]]}, 
   {RGBColor[0.138920254, 0.462005502, 0.311089142], 
    RectangleBox[NCache[{Rational[115, 256], 0}, {0.44921875, 0}], 
     NCache[{Rational[29, 64], 1}, {0.453125, 1}]]}, 
   {RGBColor[0.14615554, 0.465999917, 0.307288006], 
    RectangleBox[NCache[{Rational[29, 64], 0}, {0.453125, 0}], 
     NCache[{Rational[117, 256], 1}, {0.45703125, 1}]]}, 
   {RGBColor[0.153658052, 0.469949317, 0.303334418], 
    RectangleBox[NCache[{Rational[117, 256], 0}, {0.45703125, 0}], 
     NCache[{Rational[59, 128], 1}, {0.4609375, 1}]]}, 
   {RGBColor[0.16141881, 0.473851329, 0.299227888], 
    RectangleBox[NCache[{Rational[59, 128], 0}, {0.4609375, 0}], 
     NCache[{Rational[119, 256], 1}, {0.46484375, 1}]]}, 
   {RGBColor[0.169428819, 0.477703598, 0.294968134], 
    RectangleBox[NCache[{Rational[119, 256], 0}, {0.46484375, 0}], 
     NCache[{Rational[15, 32], 1}, {0.46875, 1}]]}, 
   {RGBColor[0.177679155, 0.481503786, 0.290555072], 
    RectangleBox[NCache[{Rational[15, 32], 0}, {0.46875, 0}], 
     NCache[{Rational[121, 256], 1}, {0.47265625, 1}]]}, 
   {RGBColor[0.186161019, 0.485249581, 0.285988805], 
    RectangleBox[NCache[{Rational[121, 256], 0}, {0.47265625, 0}], 
     NCache[{Rational[61, 128], 1}, {0.4765625, 1}]]}, 
   {RGBColor[0.194865778, 0.488938703, 0.281269612], 
    RectangleBox[NCache[{Rational[61, 128], 0}, {0.4765625, 0}], 
     NCache[{Rational[123, 256], 1}, {0.48046875, 1}]]}, 
   {RGBColor[0.203784988, 0.492568909, 0.276397933], 
    RectangleBox[NCache[{Rational[123, 256], 0}, {0.48046875, 0}], 
     NCache[{Rational[31, 64], 1}, {0.484375, 1}]]}, 
   {RGBColor[0.212910409, 0.496137998, 0.271374357], 
    RectangleBox[NCache[{Rational[31, 64], 0}, {0.484375, 0}], 
     NCache[{Rational[125, 256], 1}, {0.48828125, 1}]]}, 
   {RGBColor[0.222234002, 0.499643819, 0.266199611], 
    RectangleBox[NCache[{Rational[125, 256], 0}, {0.48828125, 0}], 
     NCache[{Rational[63, 128], 1}, {0.4921875, 1}]]}, 
   {RGBColor[0.231747934, 0.503084276, 0.260874541], 
    RectangleBox[NCache[{Rational[63, 128], 0}, {0.4921875, 0}], 
     NCache[{Rational[127, 256], 1}, {0.49609375, 1}]]}, 
   {RGBColor[0.241444557, 0.506457333, 0.255400105], 
    RectangleBox[NCache[{Rational[127, 256], 0}, {0.49609375, 0}], 
     NCache[{Rational[1, 2], 1}, {0.5, 1}]]}, 
   {RGBColor[0.251316401, 0.509761021, 0.249777354], 
    RectangleBox[NCache[{Rational[1, 2], 0}, {0.5, 0}], 
     NCache[{Rational[129, 256], 1}, {0.50390625, 1}]]}, 
   {RGBColor[0.261356155, 0.512993445, 0.24400742], 
    RectangleBox[NCache[{Rational[129, 256], 0}, {0.50390625, 0}], 
     NCache[{Rational[65, 128], 1}, {0.5078125, 1}]]}, 
   {RGBColor[0.271556645, 0.516152793, 0.238091502], 
    RectangleBox[NCache[{Rational[65, 128], 0}, {0.5078125, 0}], 
     NCache[{Rational[131, 256], 1}, {0.51171875, 1}]]}, 
   {RGBColor[0.281910816, 0.519237338, 0.232030849], 
    RectangleBox[NCache[{Rational[131, 256], 0}, {0.51171875, 0}], 
     NCache[{Rational[33, 64], 1}, {0.515625, 1}]]}, 
   {RGBColor[0.292411709, 0.522245452, 0.22582675], 
    RectangleBox[NCache[{Rational[33, 64], 0}, {0.515625, 0}], 
     NCache[{Rational[133, 256], 1}, {0.51953125, 1}]]}, 
   {RGBColor[0.303052439, 0.525175609, 0.219480519], 
    RectangleBox[NCache[{Rational[133, 256], 0}, {0.51953125, 0}], 
     NCache[{Rational[67, 128], 1}, {0.5234375, 1}]]}, 
   {RGBColor[0.313826172, 0.528026396, 0.212993484], 
    RectangleBox[NCache[{Rational[67, 128], 0}, {0.5234375, 0}], 
     NCache[{Rational[135, 256], 1}, {0.52734375, 1}]]}, 
   {RGBColor[0.324726102, 0.530796524, 0.206366974], 
    RectangleBox[NCache[{Rational[135, 256], 0}, {0.52734375, 0}], 
     NCache[{Rational[17, 32], 1}, {0.53125, 1}]]}, 
   {RGBColor[0.33574543, 0.533484834, 0.199602318], 
    RectangleBox[NCache[{Rational[17, 32], 0}, {0.53125, 0}], 
     NCache[{Rational[137, 256], 1}, {0.53515625, 1}]]}, 
   {RGBColor[0.346877341, 0.536090309, 0.192700836], 
    RectangleBox[NCache[{Rational[137, 256], 0}, {0.53515625, 0}], 
     NCache[{Rational[69, 128], 1}, {0.5390625, 1}]]}, 
   {RGBColor[0.358114982, 0.538612089, 0.185663845], 
    RectangleBox[NCache[{Rational[69, 128], 0}, {0.5390625, 0}], 
     NCache[{Rational[139, 256], 1}, {0.54296875, 1}]]}, 
   {RGBColor[0.369451439, 0.541049476, 0.178492672], 
    RectangleBox[NCache[{Rational[139, 256], 0}, {0.54296875, 0}], 
     NCache[{Rational[35, 64], 1}, {0.546875, 1}]]}, 
   {RGBColor[0.380879719, 0.543401953, 0.171188671], 
    RectangleBox[NCache[{Rational[35, 64], 0}, {0.546875, 0}], 
     NCache[{Rational[141, 256], 1}, {0.55078125, 1}]]}, 
   {RGBColor[0.392392725, 0.545669194, 0.163753271], 
    RectangleBox[NCache[{Rational[141, 256], 0}, {0.55078125, 0}], 
     NCache[{Rational[71, 128], 1}, {0.5546875, 1}]]}, 
   {RGBColor[0.40398324, 0.547851079, 0.156188035], 
    RectangleBox[NCache[{Rational[71, 128], 0}, {0.5546875, 0}], 
     NCache[{Rational[143, 256], 1}, {0.55859375, 1}]]}, 
   {RGBColor[0.415643905, 0.54994771, 0.148494759], 
    RectangleBox[NCache[{Rational[143, 256], 0}, {0.55859375, 0}], 
     NCache[{Rational[9, 16], 1}, {0.5625, 1}]]}, 
   {RGBColor[0.427367201, 0.551959427, 0.140675619], 
    RectangleBox[NCache[{Rational[9, 16], 0}, {0.5625, 0}], 
     NCache[{Rational[145, 256], 1}, {0.56640625, 1}]]}, 
   {RGBColor[0.439145431, 0.553886824, 0.132733383], 
    RectangleBox[NCache[{Rational[145, 256], 0}, {0.56640625, 0}], 
     NCache[{Rational[73, 128], 1}, {0.5703125, 1}]]}, 
   {RGBColor[0.450975035, 0.555729609, 0.124665418], 
    RectangleBox[NCache[{Rational[73, 128], 0}, {0.5703125, 0}], 
     NCache[{Rational[147, 256], 1}, {0.57421875, 1}]]}, 
   {RGBColor[0.46284498, 0.557489617, 0.116480779], 
    RectangleBox[NCache[{Rational[147, 256], 0}, {0.57421875, 0}], 
     NCache[{Rational[37, 64], 1}, {0.578125, 1}]]}, 
   {RGBColor[0.474745559, 0.559168661, 0.108188475], 
    RectangleBox[NCache[{Rational[37, 64], 0}, {0.578125, 0}], 
     NCache[{Rational[149, 256], 1}, {0.58203125, 1}]]}, 
   {RGBColor[0.48666813, 0.560768549, 0.09979869], 
    RectangleBox[NCache[{Rational[149, 256], 0}, {0.58203125, 0}], 
     NCache[{Rational[75, 128], 1}, {0.5859375, 1}]]}, 
   {RGBColor[0.498603802, 0.562291436, 0.0913261437], 
    RectangleBox[NCache[{Rational[75, 128], 0}, {0.5859375, 0}], 
     NCache[{Rational[151, 256], 1}, {0.58984375, 1}]]}, 
   {RGBColor[0.510543429, 0.563739843, 0.0827923167], 
    RectangleBox[NCache[{Rational[151, 256], 0}, {0.58984375, 0}], 
     NCache[{Rational[19, 32], 1}, {0.59375, 1}]]}, 
   {RGBColor[0.522477839, 0.565116597, 0.0742284389], 
    RectangleBox[NCache[{Rational[19, 32], 0}, {0.59375, 0}], 
     NCache[{Rational[153, 256], 1}, {0.59765625, 1}]]}, 
   {RGBColor[0.534402935, 0.566423108, 0.0656717853], 
    RectangleBox[NCache[{Rational[153, 256], 0}, {0.59765625, 0}], 
     NCache[{Rational[77, 128], 1}, {0.6015625, 1}]]}, 
   {RGBColor[0.54630255, 0.567665088, 0.0572025049], 
    RectangleBox[NCache[{Rational[77, 128], 0}, {0.6015625, 0}], 
     NCache[{Rational[155, 256], 1}, {0.60546875, 1}]]}, 
   {RGBColor[0.558166439, 0.568846718, 0.0489257073], 
    RectangleBox[NCache[{Rational[155, 256], 0}, {0.60546875, 0}], 
     NCache[{Rational[39, 64], 1}, {0.609375, 1}]]}, 
   {RGBColor[0.569984146, 0.569972607, 0.0409987564], 
    RectangleBox[NCache[{Rational[39, 64], 0}, {0.609375, 0}], 
     NCache[{Rational[157, 256], 1}, {0.61328125, 1}]]}, 
   {RGBColor[0.581745024, 0.5710478, 0.033879614], 
    RectangleBox[NCache[{Rational[157, 256], 0}, {0.61328125, 0}], 
     NCache[{Rational[79, 128], 1}, {0.6171875, 1}]]}, 
   {RGBColor[0.593441855, 0.572076359, 0.0282747543], 
    RectangleBox[NCache[{Rational[79, 128], 0}, {0.6171875, 0}], 
     NCache[{Rational[159, 256], 1}, {0.62109375, 1}]]}, 
   {RGBColor[0.605060162, 0.573065496, 0.024267021], 
    RectangleBox[NCache[{Rational[159, 256], 0}, {0.62109375, 0}], 
     NCache[{Rational[5, 8], 1}, {0.625, 1}]]}, 
   {RGBColor[0.616587919, 0.574021935, 0.0219268218], 
    RectangleBox[NCache[{Rational[5, 8], 0}, {0.625, 0}], 
     NCache[{Rational[161, 256], 1}, {0.62890625, 1}]]}, 
   {RGBColor[0.62801405, 0.574952422, 0.0213281856], 
    RectangleBox[NCache[{Rational[161, 256], 0}, {0.62890625, 0}], 
     NCache[{Rational[81, 128], 1}, {0.6328125, 1}]]}, 
   {RGBColor[0.639327939, 0.575863873, 0.0225506518], 
    RectangleBox[NCache[{Rational[81, 128], 0}, {0.6328125, 0}], 
     NCache[{Rational[163, 256], 1}, {0.63671875, 1}]]}, 
   {RGBColor[0.650519264, 0.576763426, 0.0256803655], 
    RectangleBox[NCache[{Rational[163, 256], 0}, {0.63671875, 0}], 
     NCache[{Rational[41, 64], 1}, {0.640625, 1}]]}, 
   {RGBColor[0.661575187, 0.577659706, 0.0308113161], 
    RectangleBox[NCache[{Rational[41, 64], 0}, {0.640625, 0}], 
     NCache[{Rational[165, 256], 1}, {0.64453125, 1}]]}, 
   {RGBColor[0.672485257, 0.578560654, 0.0380424961], 
    RectangleBox[NCache[{Rational[165, 256], 0}, {0.64453125, 0}], 
     NCache[{Rational[83, 128], 1}, {0.6484375, 1}]]}, 
   {RGBColor[0.683239371, 0.579474363, 0.047040586], 
    RectangleBox[NCache[{Rational[83, 128], 0}, {0.6484375, 0}], 
     NCache[{Rational[167, 256], 1}, {0.65234375, 1}]]}, 
   {RGBColor[0.693826945, 0.58040947, 0.0568940115], 
    RectangleBox[NCache[{Rational[167, 256], 0}, {0.65234375, 0}], 
     NCache[{Rational[21, 32], 1}, {0.65625, 1}]]}, 
   {RGBColor[0.704238654, 0.581374288, 0.0673716976], 
    RectangleBox[NCache[{Rational[21, 32], 0}, {0.65625, 0}], 
     NCache[{Rational[169, 256], 1}, {0.66015625, 1}]]}, 
   {RGBColor[0.714466086, 0.582376907, 0.0783172031], 
    RectangleBox[NCache[{Rational[169, 256], 0}, {0.66015625, 0}], 
     NCache[{Rational[85, 128], 1}, {0.6640625, 1}]]}, 
   {RGBColor[0.724501348, 0.583425344, 0.0896249873], 
    RectangleBox[NCache[{Rational[85, 128], 0}, {0.6640625, 0}], 
     NCache[{Rational[171, 256], 1}, {0.66796875, 1}]]}, 
   {RGBColor[0.73433617, 0.584528004, 0.101222566], 
    RectangleBox[NCache[{Rational[171, 256], 0}, {0.66796875, 0}], 
     NCache[{Rational[43, 64], 1}, {0.671875, 1}]]}, 
   {RGBColor[0.743962862, 0.585693159, 0.113059557], 
    RectangleBox[NCache[{Rational[43, 64], 0}, {0.671875, 0}], 
     NCache[{Rational[173, 256], 1}, {0.67578125, 1}]]}, 
   {RGBColor[0.753377595, 0.586927042, 0.125105089], 
    RectangleBox[NCache[{Rational[173, 256], 0}, {0.67578125, 0}], 
     NCache[{Rational[87, 128], 1}, {0.6796875, 1}]]}, 
   {RGBColor[0.762575552, 0.588236442, 0.137336358], 
    RectangleBox[NCache[{Rational[87, 128], 0}, {0.6796875, 0}], 
     NCache[{Rational[175, 256], 1}, {0.68359375, 1}]]}, 
   {RGBColor[0.771552684, 0.589627716, 0.149737263], 
    RectangleBox[NCache[{Rational[175, 256], 0}, {0.68359375, 0}], 
     NCache[{Rational[11, 16], 1}, {0.6875, 1}]]}, 
   {RGBColor[0.780304203, 0.591107689, 0.162292912], 
    RectangleBox[NCache[{Rational[11, 16], 0}, {0.6875, 0}], 
     NCache[{Rational[177, 256], 1}, {0.69140625, 1}]]}, 
   {RGBColor[0.788827159, 0.592682093, 0.174992652], 
    RectangleBox[NCache[{Rational[177, 256], 0}, {0.69140625, 0}], 
     NCache[{Rational[89, 128], 1}, {0.6953125, 1}]]}, 
   {RGBColor[0.797121904, 0.594354494, 0.18783365], 
    RectangleBox[NCache[{Rational[89, 128], 0}, {0.6953125, 0}], 
     NCache[{Rational[179, 256], 1}, {0.69921875, 1}]]}, 
   {RGBColor[0.80518742, 0.596129166, 0.200810256], 
    RectangleBox[NCache[{Rational[179, 256], 0}, {0.69921875, 0}], 
     NCache[{Rational[45, 64], 1}, {0.703125, 1}]]}, 
   {RGBColor[0.813023314, 0.598009857, 0.213917489], 
    RectangleBox[NCache[{Rational[45, 64], 0}, {0.703125, 0}], 
     NCache[{Rational[181, 256], 1}, {0.70703125, 1}]]}, 
   {RGBColor[0.820629771, 0.599999799, 0.2271507], 
    RectangleBox[NCache[{Rational[181, 256], 0}, {0.70703125, 0}], 
     NCache[{Rational[91, 128], 1}, {0.7109375, 1}]]}, 
   {RGBColor[0.828007021, 0.602102078, 0.240503564], 
    RectangleBox[NCache[{Rational[91, 128], 0}, {0.7109375, 0}], 
     NCache[{Rational[183, 256], 1}, {0.71484375, 1}]]}, 
   {RGBColor[0.835155259, 0.604319751, 0.253966787], 
    RectangleBox[NCache[{Rational[183, 256], 0}, {0.71484375, 0}], 
     NCache[{Rational[23, 32], 1}, {0.71875, 1}]]}, 
   {RGBColor[0.842077988, 0.606653209, 0.267542263], 
    RectangleBox[NCache[{Rational[23, 32], 0}, {0.71875, 0}], 
     NCache[{Rational[185, 256], 1}, {0.72265625, 1}]]}, 
   {RGBColor[0.848777144, 0.6091038, 0.281225295], 
    RectangleBox[NCache[{Rational[185, 256], 0}, {0.72265625, 0}], 
     NCache[{Rational[93, 128], 1}, {0.7265625, 1}]]}, 
   {RGBColor[0.855254945, 0.611672485, 0.295010966], 
    RectangleBox[NCache[{Rational[93, 128], 0}, {0.7265625, 0}], 
     NCache[{Rational[187, 256], 1}, {0.73046875, 1}]]}, 
   {RGBColor[0.861513837, 0.614359877, 0.308894128], 
    RectangleBox[NCache[{Rational[187, 256], 0}, {0.73046875, 0}], 
     NCache[{Rational[47, 64], 1}, {0.734375, 1}]]}, 
   {RGBColor[0.867556445, 0.617166278, 0.322869395], 
    RectangleBox[NCache[{Rational[47, 64], 0}, {0.734375, 0}], 
     NCache[{Rational[189, 256], 1}, {0.73828125, 1}]]}, 
   {RGBColor[0.873385523, 0.62009171, 0.336931148], 
    RectangleBox[NCache[{Rational[189, 256], 0}, {0.73828125, 0}], 
     NCache[{Rational[95, 128], 1}, {0.7421875, 1}]]}, 
   {RGBColor[0.879003914, 0.623135957, 0.351073543], 
    RectangleBox[NCache[{Rational[95, 128], 0}, {0.7421875, 0}], 
     NCache[{Rational[191, 256], 1}, {0.74609375, 1}]]}, 
   {RGBColor[0.884414511, 0.626298593, 0.365290519], 
    RectangleBox[NCache[{Rational[191, 256], 0}, {0.74609375, 0}], 
     NCache[{Rational[3, 4], 1}, {0.75, 1}]]}, 
   {RGBColor[0.889620221, 0.629579022, 0.379575807], 
    RectangleBox[NCache[{Rational[3, 4], 0}, {0.75, 0}], 
     NCache[{Rational[193, 256], 1}, {0.75390625, 1}]]}, 
   {RGBColor[0.894623936, 0.632976504, 0.393922939], 
    RectangleBox[NCache[{Rational[193, 256], 0}, {0.75390625, 0}], 
     NCache[{Rational[97, 128], 1}, {0.7578125, 1}]]}, 
   {RGBColor[0.899428507, 0.636490186, 0.408325253], 
    RectangleBox[NCache[{Rational[97, 128], 0}, {0.7578125, 0}], 
     NCache[{Rational[195, 256], 1}, {0.76171875, 1}]]}, 
   {RGBColor[0.904036723, 0.640119127, 0.422775895], 
    RectangleBox[NCache[{Rational[195, 256], 0}, {0.76171875, 0}], 
     NCache[{Rational[49, 64], 1}, {0.765625, 1}]]}, 
   {RGBColor[0.908451317, 0.643862346, 0.437267309], 
    RectangleBox[NCache[{Rational[49, 64], 0}, {0.765625, 0}], 
     NCache[{Rational[197, 256], 1}, {0.76953125, 1}]]}, 
   {RGBColor[0.912674913, 0.647718773, 0.451792549], 
    RectangleBox[NCache[{Rational[197, 256], 0}, {0.76953125, 0}], 
     NCache[{Rational[99, 128], 1}, {0.7734375, 1}]]}, 
   {RGBColor[0.916709977, 0.651687316, 0.466344842], 
    RectangleBox[NCache[{Rational[99, 128], 0}, {0.7734375, 0}], 
     NCache[{Rational[199, 256], 1}, {0.77734375, 1}]]}, 
   {RGBColor[0.920558895, 0.655766912, 0.480916487], 
    RectangleBox[NCache[{Rational[199, 256], 0}, {0.77734375, 0}], 
     NCache[{Rational[25, 32], 1}, {0.78125, 1}]]}, 
   {RGBColor[0.924223945, 0.659956497, 0.495499568], 
    RectangleBox[NCache[{Rational[25, 32], 0}, {0.78125, 0}], 
     NCache[{Rational[201, 256], 1}, {0.78515625, 1}]]}, 
   {RGBColor[0.927707304, 0.664255023, 0.510085944], 
    RectangleBox[NCache[{Rational[201, 256], 0}, {0.78515625, 0}], 
     NCache[{Rational[101, 128], 1}, {0.7890625, 1}]]}, 
   {RGBColor[0.931011045, 0.668661459, 0.52466724], 
    RectangleBox[NCache[{Rational[101, 128], 0}, {0.7890625, 0}], 
     NCache[{Rational[203, 256], 1}, {0.79296875, 1}]]}, 
   {RGBColor[0.934137216, 0.673174796, 0.539234468], 
    RectangleBox[NCache[{Rational[203, 256], 0}, {0.79296875, 0}], 
     NCache[{Rational[51, 64], 1}, {0.796875, 1}]]}, 
   {RGBColor[0.937087683, 0.677794059, 0.553778998], 
    RectangleBox[NCache[{Rational[51, 64], 0}, {0.796875, 0}], 
     NCache[{Rational[205, 256], 1}, {0.80078125, 1}]]}, 
   {RGBColor[0.939864212, 0.682518315, 0.568291979], 
    RectangleBox[NCache[{Rational[205, 256], 0}, {0.80078125, 0}], 
     NCache[{Rational[103, 128], 1}, {0.8046875, 1}]]}, 
   {RGBColor[0.942468542, 0.687346665, 0.582764066], 
    RectangleBox[NCache[{Rational[103, 128], 0}, {0.8046875, 0}], 
     NCache[{Rational[207, 256], 1}, {0.80859375, 1}]]}, 
   {RGBColor[0.944902364, 0.692278238, 0.597185613], 
    RectangleBox[NCache[{Rational[207, 256], 0}, {0.80859375, 0}], 
     NCache[{Rational[13, 16], 1}, {0.8125, 1}]]}, 
   {RGBColor[0.947167346, 0.697312194, 0.611546658], 
    RectangleBox[NCache[{Rational[13, 16], 0}, {0.8125, 0}], 
     NCache[{Rational[209, 256], 1}, {0.81640625, 1}]]}, 
   {RGBColor[0.949265154, 0.702447712, 0.625836915], 
    RectangleBox[NCache[{Rational[209, 256], 0}, {0.81640625, 0}], 
     NCache[{Rational[105, 128], 1}, {0.8203125, 1}]]}, 
   {RGBColor[0.951197479, 0.707683987, 0.640045758], 
    RectangleBox[NCache[{Rational[105, 128], 0}, {0.8203125, 0}], 
     NCache[{Rational[211, 256], 1}, {0.82421875, 1}]]}, 
   {RGBColor[0.952966062, 0.713020218, 0.654162211], 
    RectangleBox[NCache[{Rational[211, 256], 0}, {0.82421875, 0}], 
     NCache[{Rational[53, 64], 1}, {0.828125, 1}]]}, 
   {RGBColor[0.954572726, 0.718455599, 0.668174947], 
    RectangleBox[NCache[{Rational[53, 64], 0}, {0.828125, 0}], 
     NCache[{Rational[213, 256], 1}, {0.83203125, 1}]]}, 
   {RGBColor[0.956019406, 0.723989311, 0.682072273], 
    RectangleBox[NCache[{Rational[213, 256], 0}, {0.83203125, 0}], 
     NCache[{Rational[107, 128], 1}, {0.8359375, 1}]]}, 
   {RGBColor[0.95730818, 0.729620507, 0.695842134], 
    RectangleBox[NCache[{Rational[107, 128], 0}, {0.8359375, 0}], 
     NCache[{Rational[215, 256], 1}, {0.83984375, 1}]]}, 
   {RGBColor[0.958441302, 0.735348303, 0.70947211], 
    RectangleBox[NCache[{Rational[215, 256], 0}, {0.83984375, 0}], 
     NCache[{Rational[27, 32], 1}, {0.84375, 1}]]}, 
   {RGBColor[0.959421236, 0.741171767, 0.722949416], 
    RectangleBox[NCache[{Rational[27, 32], 0}, {0.84375, 0}], 
     NCache[{Rational[217, 256], 1}, {0.84765625, 1}]]}, 
   {RGBColor[0.960250683, 0.747089909, 0.736260905], 
    RectangleBox[NCache[{Rational[217, 256], 0}, {0.84765625, 0}], 
     NCache[{Rational[109, 128], 1}, {0.8515625, 1}]]}, 
   {RGBColor[0.960932615, 0.753101675, 0.749393068], 
    RectangleBox[NCache[{Rational[109, 128], 0}, {0.8515625, 0}], 
     NCache[{Rational[219, 256], 1}, {0.85546875, 1}]]}, 
   {RGBColor[0.961470299, 0.759205936, 0.762332032], 
    RectangleBox[NCache[{Rational[219, 256], 0}, {0.85546875, 0}], 
     NCache[{Rational[55, 64], 1}, {0.859375, 1}]]}, 
   {RGBColor[0.961867319, 0.765401491, 0.775063555], 
    RectangleBox[NCache[{Rational[55, 64], 0}, {0.859375, 0}], 
     NCache[{Rational[221, 256], 1}, {0.86328125, 1}]]}, 
   {RGBColor[0.962127596, 0.771687064, 0.787573001], 
    RectangleBox[NCache[{Rational[221, 256], 0}, {0.86328125, 0}], 
     NCache[{Rational[111, 128], 1}, {0.8671875, 1}]]}, 
   {RGBColor[0.962255401, 0.778061314, 0.799845309], 
    RectangleBox[NCache[{Rational[111, 128], 0}, {0.8671875, 0}], 
     NCache[{Rational[223, 256], 1}, {0.87109375, 1}]]}, 
   {RGBColor[0.962255368, 0.784522837, 0.811864934], 
    RectangleBox[NCache[{Rational[223, 256], 0}, {0.87109375, 0}], 
     NCache[{Rational[7, 8], 1}, {0.875, 1}]]}, 
   {RGBColor[0.962132504, 0.791070186, 0.823615749], 
    RectangleBox[NCache[{Rational[7, 8], 0}, {0.875, 0}], 
     NCache[{Rational[225, 256], 1}, {0.87890625, 1}]]}, 
   {RGBColor[0.961892203, 0.797701884, 0.835080911], 
    RectangleBox[NCache[{Rational[225, 256], 0}, {0.87890625, 0}], 
     NCache[{Rational[113, 128], 1}, {0.8828125, 1}]]}, 
   {RGBColor[0.961535931, 0.804418041, 0.846247612], 
    RectangleBox[NCache[{Rational[113, 128], 0}, {0.8828125, 0}], 
     NCache[{Rational[227, 256], 1}, {0.88671875, 1}]]}, 
   {RGBColor[0.961069177, 0.811217509, 0.857096621], 
    RectangleBox[NCache[{Rational[227, 256], 0}, {0.88671875, 0}], 
     NCache[{Rational[57, 64], 1}, {0.890625, 1}]]}, 
   {RGBColor[0.960501198, 0.818097944, 0.867603854], 
    RectangleBox[NCache[{Rational[57, 64], 0}, {0.890625, 0}], 
     NCache[{Rational[229, 256], 1}, {0.89453125, 1}]]}, 
   {RGBColor[0.959839454, 0.825057914, 0.877746324], 
    RectangleBox[NCache[{Rational[229, 256], 0}, {0.89453125, 0}], 
     NCache[{Rational[115, 128], 1}, {0.8984375, 1}]]}, 
   {RGBColor[0.959092622, 0.832095826, 0.887498342], 
    RectangleBox[NCache[{Rational[115, 128], 0}, {0.8984375, 0}], 
     NCache[{Rational[231, 256], 1}, {0.90234375, 1}]]}, 
   {RGBColor[0.958271129, 0.839209776, 0.896830951], 
    RectangleBox[NCache[{Rational[231, 256], 0}, {0.90234375, 0}], 
     NCache[{Rational[29, 32], 1}, {0.90625, 1}]]}, 
   {RGBColor[0.957379148, 0.846400731, 0.905716781], 
    RectangleBox[NCache[{Rational[29, 32], 0}, {0.90625, 0}], 
     NCache[{Rational[233, 256], 1}, {0.91015625, 1}]]}, 
   {RGBColor[0.956426557, 0.853668016, 0.914119954], 
    RectangleBox[NCache[{Rational[233, 256], 0}, {0.91015625, 0}], 
     NCache[{Rational[117, 128], 1}, {0.9140625, 1}]]}, 
   {RGBColor[0.955450902, 0.861000457, 0.9219881], 
    RectangleBox[NCache[{Rational[117, 128], 0}, {0.9140625, 0}], 
     NCache[{Rational[235, 256], 1}, {0.91796875, 1}]]}, 
   {RGBColor[0.954482975, 0.86838976, 0.929276063], 
    RectangleBox[NCache[{Rational[235, 256], 0}, {0.91796875, 0}], 
     NCache[{Rational[59, 64], 1}, {0.921875, 1}]]}, 
   {RGBColor[0.953544413, 0.875831712, 0.935942516], 
    RectangleBox[NCache[{Rational[59, 64], 0}, {0.921875, 0}], 
     NCache[{Rational[237, 256], 1}, {0.92578125, 1}]]}, 
   {RGBColor[0.952715057, 0.883298026, 0.941937385], 
    RectangleBox[NCache[{Rational[237, 256], 0}, {0.92578125, 0}], 
     NCache[{Rational[119, 128], 1}, {0.9296875, 1}]]}, 
   {RGBColor[0.95206017, 0.890765365, 0.947234674], 
    RectangleBox[NCache[{Rational[119, 128], 0}, {0.9296875, 0}], 
     NCache[{Rational[239, 256], 1}, {0.93359375, 1}]]}, 
   {RGBColor[0.951663891, 0.898200733, 0.951831906], 
    RectangleBox[NCache[{Rational[239, 256], 0}, {0.93359375, 0}], 
     NCache[{Rational[15, 16], 1}, {0.9375, 1}]]}, 
   {RGBColor[0.951600045, 0.905573176, 0.955758457], 
    RectangleBox[NCache[{Rational[15, 16], 0}, {0.9375, 0}], 
     NCache[{Rational[241, 256], 1}, {0.94140625, 1}]]}, 
   {RGBColor[0.951948354, 0.912845998, 0.959081968], 
    RectangleBox[NCache[{Rational[241, 256], 0}, {0.94140625, 0}], 
     NCache[{Rational[121, 128], 1}, {0.9453125, 1}]]}, 
   {RGBColor[0.952754314, 0.919994695, 0.961896029], 
    RectangleBox[NCache[{Rational[121, 128], 0}, {0.9453125, 0}], 
     NCache[{Rational[243, 256], 1}, {0.94921875, 1}]]}, 
   {RGBColor[0.954024962, 0.927010498, 0.964296862], 
    RectangleBox[NCache[{Rational[243, 256], 0}, {0.94921875, 0}], 
     NCache[{Rational[61, 64], 1}, {0.953125, 1}]]}, 
   {RGBColor[0.955761682, 0.933885958, 0.966387156], 
    RectangleBox[NCache[{Rational[61, 64], 0}, {0.953125, 0}], 
     NCache[{Rational[245, 256], 1}, {0.95703125, 1}]]}, 
   {RGBColor[0.957951675, 0.940619651, 0.968263946], 
    RectangleBox[NCache[{Rational[245, 256], 0}, {0.95703125, 0}], 
     NCache[{Rational[123, 128], 1}, {0.9609375, 1}]]}, 
   {RGBColor[0.960573473, 0.947214333, 0.970013814], 
    RectangleBox[NCache[{Rational[123, 128], 0}, {0.9609375, 0}], 
     NCache[{Rational[247, 256], 1}, {0.96484375, 1}]]}, 
   {RGBColor[0.963602865, 0.953674551, 0.971712469], 
    RectangleBox[NCache[{Rational[247, 256], 0}, {0.96484375, 0}], 
     NCache[{Rational[31, 32], 1}, {0.96875, 1}]]}, 
   {RGBColor[0.967018286, 0.960004011, 0.973429691], 
    RectangleBox[NCache[{Rational[31, 32], 0}, {0.96875, 0}], 
     NCache[{Rational[249, 256], 1}, {0.97265625, 1}]]}, 
   {RGBColor[0.970802859, 0.966203343, 0.975243531], 
    RectangleBox[NCache[{Rational[249, 256], 0}, {0.97265625, 0}], 
     NCache[{Rational[125, 128], 1}, {0.9765625, 1}]]}, 
   {RGBColor[0.974923592, 0.972274812, 0.977275094], 
    RectangleBox[NCache[{Rational[125, 128], 0}, {0.9765625, 0}], 
     NCache[{Rational[251, 256], 1}, {0.98046875, 1}]]}, 
   {RGBColor[0.9791844, 0.978278064, 0.979710814], 
    RectangleBox[NCache[{Rational[251, 256], 0}, {0.98046875, 0}], 
     NCache[{Rational[63, 64], 1}, {0.984375, 1}]]}, 
   {RGBColor[0.983037174, 0.984450133, 0.982356003], 
    RectangleBox[NCache[{Rational[63, 64], 0}, {0.984375, 0}], 
     NCache[{Rational[253, 256], 1}, {0.98828125, 1}]]}, 
   {RGBColor[0.98648033, 0.990875647, 0.984384974], 
    RectangleBox[NCache[{Rational[253, 256], 0}, {0.98828125, 0}], 
     NCache[{Rational[127, 128], 1}, {0.9921875, 1}]]}, 
   {RGBColor[0.98990622, 0.997424842, 0.985544042], 
    RectangleBox[NCache[{Rational[127, 128], 0}, {0.9921875, 0}], 
     NCache[{Rational[255, 256], 1}, {0.99609375, 1}]]}, 
   {RGBColor[1., 1., 1.], 
    RectangleBox[NCache[{Rational[255, 256], 0}, {0.99609375, 0}], {1, 1}]}},
  AspectRatio->0.2]], "Output",
 CellChangeTimes->{
  3.648068194708489*^9, 3.648068229268454*^9, 3.64807215537418*^9, {
   3.648216290927319*^9, 3.648216310453807*^9}, 3.649608461240103*^9, {
   3.655135306719384*^9, 3.655135313893997*^9}, 3.658032098280773*^9, 
   3.662221879838151*^9, 3.662226874518491*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"idlcolorbardir", "=", 
  "\"\</home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_rgb_\
values\>\""}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"idlcolorbarnames", "=", 
   RowBox[{"FileNames", "[", 
    RowBox[{"idlcolorbardir", "<>", "\"\</*\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SortBy", "[", 
   RowBox[{"idlcolorbarnames", ",", "\"\<\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"idlcolorbars", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Mean", "[", 
         RowBox[{"Mean", "[", "#", "]"}], "]"}], ">", "1"}], ",", 
       RowBox[{"#", "/", "255."}], ",", "#"}], "]"}], "&"}], "/@", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Import", "[", 
        RowBox[{"#", ",", "\"\<CSV\>\""}], "]"}], "&"}], "/@", 
      "idlcolorbarnames"}], ")"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.648062902022546*^9, 3.648062996949477*^9}, {
   3.648063031185025*^9, 3.648063077516027*^9}, {3.648063230093691*^9, 
   3.64806324055767*^9}, {3.6480633314417686`*^9, 3.648063332057694*^9}, 
   3.648216335976091*^9, {3.649608450060532*^9, 3.649608450339407*^9}, {
   3.655135330168837*^9, 3.6551353922465*^9}, 3.6551354974871607`*^9}],

Cell[BoxData["\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-\
Colorbars/IDL_rgb_values\"\>"], "Output",
 CellChangeTimes->{{3.648062945522917*^9, 3.648063078030589*^9}, {
   3.6480633269716063`*^9, 3.6480633324864273`*^9}, 3.648064911428491*^9, 
   3.648069238483214*^9, 3.6482163406467133`*^9, 3.64960846371311*^9, {
   3.655135298968275*^9, 3.655135315979342*^9}, {3.655135386778294*^9, 
   3.655135392640264*^9}, 3.655135498161174*^9, 3.655136512544923*^9, {
   3.655136623229987*^9, 3.655136633649539*^9}, 3.6580321025921907`*^9, 
   3.6622218812923717`*^9, 3.662222032971183*^9, 3.662226876060507*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "ReplacePart"}]], "Input",
 CellChangeTimes->{{3.655136410002647*^9, 3.655136411435321*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox["\<\"\!\(\*RowBox[{\\\"ReplacePart\\\", \\\"[\\\", \
RowBox[{StyleBox[\\\"expr\\\", \\\"TI\\\"], \\\",\\\", RowBox[{StyleBox[\\\"i\
\\\", \\\"TI\\\"], \\\"\[Rule]\\\", StyleBox[\\\"new\\\", \\\"TI\\\"]}]}], \\\
\"]\\\"}]\) yields an expression in which the \
\!\(\*StyleBox[RowBox[{StyleBox[\\\"i\\\", \\\"TI\\\"], \
\\\"\[Null]\\\"}]]\)\!\(\*SuperscriptBox[\\\"\[Null]\\\", \\\"th\\\"]\) part \
of \!\(\*StyleBox[\\\"expr\\\", \\\"TI\\\"]\) is replaced by \
\!\(\*StyleBox[\\\"new\\\", \\\"TI\\\"]\). \\n\!\(\*RowBox[{\\\"ReplacePart\\\
\", \\\"[\\\", RowBox[{StyleBox[\\\"expr\\\", \\\"TI\\\"], \\\",\\\", \
RowBox[{\\\"{\\\", RowBox[{RowBox[{SubscriptBox[StyleBox[\\\"i\\\", \
\\\"TI\\\"], StyleBox[\\\"1\\\", \\\"TR\\\"]], \\\"\[Rule]\\\", \
SubscriptBox[StyleBox[\\\"new\\\", \\\"TI\\\"], StyleBox[\\\"1\\\", \
\\\"TR\\\"]]}], \\\",\\\", RowBox[{SubscriptBox[StyleBox[\\\"i\\\", \
\\\"TI\\\"], StyleBox[\\\"2\\\", \\\"TR\\\"]], \\\"\[Rule]\\\", \
SubscriptBox[StyleBox[\\\"new\\\", \\\"TI\\\"], StyleBox[\\\"2\\\", \
\\\"TR\\\"]]}], \\\",\\\", StyleBox[\\\"\[Ellipsis]\\\", \\\"TR\\\"]}], \\\"}\
\\\"}]}], \\\"]\\\"}]\) replaces parts at positions \
\!\(\*SubscriptBox[StyleBox[\\\"i\\\", \\\"TI\\\"], StyleBox[\\\"n\\\", \
\\\"TI\\\"]]\) by \!\(\*SubscriptBox[StyleBox[\\\"new\\\", \\\"TI\\\"], \
StyleBox[\\\"n\\\", \\\"TI\\\"]]\). \\n\!\(\*RowBox[{\\\"ReplacePart\\\", \
\\\"[\\\", RowBox[{StyleBox[\\\"expr\\\", \\\"TI\\\"], \\\",\\\", \
RowBox[{RowBox[{\\\"{\\\", RowBox[{StyleBox[\\\"i\\\", \\\"TI\\\"], \
\\\",\\\", StyleBox[\\\"j\\\", \\\"TI\\\"], \\\",\\\", StyleBox[\\\"\
\[Ellipsis]\\\", \\\"TR\\\"]}], \\\"}\\\"}], \\\"\[Rule]\\\", \
StyleBox[\\\"new\\\", \\\"TI\\\"]}]}], \\\"]\\\"}]\) replaces the part at \
position \!\(\*RowBox[{\\\"{\\\", RowBox[{StyleBox[\\\"i\\\", \\\"TI\\\"], \\\
\",\\\", StyleBox[\\\"j\\\", \\\"TI\\\"], \\\",\\\", StyleBox[\\\"\[Ellipsis]\
\\\", \\\"TR\\\"]}], \\\"}\\\"}]\). \\n\!\(\*RowBox[{\\\"ReplacePart\\\", \
\\\"[\\\", RowBox[{StyleBox[\\\"expr\\\", \\\"TI\\\"], \\\",\\\", \
RowBox[{\\\"{\\\", RowBox[{RowBox[{RowBox[{\\\"{\\\", \
RowBox[{SubscriptBox[StyleBox[\\\"i\\\", \\\"TI\\\"], StyleBox[\\\"1\\\", \
\\\"TR\\\"]], \\\",\\\", SubscriptBox[StyleBox[\\\"j\\\", \\\"TI\\\"], \
StyleBox[\\\"1\\\", \\\"TR\\\"]], \\\",\\\", StyleBox[\\\"\[Ellipsis]\\\", \\\
\"TR\\\"]}], \\\"}\\\"}], \\\"\[Rule]\\\", SubscriptBox[StyleBox[\\\"new\\\", \
\\\"TI\\\"], StyleBox[\\\"1\\\", \\\"TR\\\"]]}], \\\",\\\", StyleBox[\\\"\
\[Ellipsis]\\\", \\\"TR\\\"]}], \\\"}\\\"}]}], \\\"]\\\"}]\) replaces parts \
at positions \!\(\*RowBox[{\\\"{\\\", \
RowBox[{SubscriptBox[StyleBox[\\\"i\\\", \\\"TI\\\"], StyleBox[\\\"n\\\", \
\\\"TI\\\"]], \\\",\\\", SubscriptBox[StyleBox[\\\"j\\\", \\\"TI\\\"], \
StyleBox[\\\"n\\\", \\\"TI\\\"]], \\\",\\\", StyleBox[\\\"\[Ellipsis]\\\", \\\
\"TR\\\"]}], \\\"}\\\"}]\) by \!\(\*SubscriptBox[StyleBox[\\\"new\\\", \\\"TI\
\\\"], StyleBox[\\\"n\\\", \\\"TI\\\"]]\). \\n\!\(\*RowBox[{\\\"ReplacePart\\\
\", \\\"[\\\", RowBox[{StyleBox[\\\"expr\\\", \\\"TI\\\"], \\\",\\\", \
RowBox[{RowBox[{\\\"{\\\", RowBox[{RowBox[{\\\"{\\\", \
RowBox[{SubscriptBox[StyleBox[\\\"i\\\", \\\"TI\\\"], StyleBox[\\\"1\\\", \
\\\"TR\\\"]], \\\",\\\", SubscriptBox[StyleBox[\\\"j\\\", \\\"TI\\\"], \
StyleBox[\\\"1\\\", \\\"TR\\\"]], \\\",\\\", StyleBox[\\\"\[Ellipsis]\\\", \\\
\"TR\\\"]}], \\\"}\\\"}], \\\",\\\", StyleBox[\\\"\[Ellipsis]\\\", \
\\\"TR\\\"]}], \\\"}\\\"}], \\\"\[Rule]\\\", StyleBox[\\\"new\\\", \
\\\"TI\\\"]}]}], \\\"]\\\"}]\) replaces all parts at positions \!\(\*RowBox[{\
\\\"{\\\", RowBox[{SubscriptBox[StyleBox[\\\"i\\\", \\\"TI\\\"], \
StyleBox[\\\"n\\\", \\\"TI\\\"]], \\\",\\\", SubscriptBox[StyleBox[\\\"j\\\", \
\\\"TI\\\"], StyleBox[\\\"n\\\", \\\"TI\\\"]], \\\",\\\", StyleBox[\\\"\
\[Ellipsis]\\\", \\\"TR\\\"]}], \\\"}\\\"}]\) by \!\(\*StyleBox[\\\"new\\\", \
\\\"TI\\\"]\). \\n\!\(\*RowBox[{\\\"ReplacePart\\\", \\\"[\\\", \
StyleBox[RowBox[{\\\"i\\\", StyleBox[\\\"\[Rule]\\\", FontSlant -> \
\\\"Plain\\\"], \\\"new\\\"}], \\\"TI\\\"], \\\"]\\\"}]\) represents an \
operator form of ReplacePart that can be applied to an expression.\"\>", 
   "MSG"], "\[NonBreakingSpace]", 
  ButtonBox[
   StyleBox["\[RightSkeleton]", "SR"],
   Active->True,
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplacePart"]}]], "Print", "PrintUsage",
 CellChangeTimes->{3.662221884011042*^9},
 CellTags->"Info-3d15986b-7190-4202-ae7f-240d11314da9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Position", "[", 
  RowBox[{"idlcolorbars", ",", 
   RowBox[{"x_", "/;", 
    RowBox[{"x", ">", "1"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"82", ",", "256", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"83", ",", "256", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"84", ",", "256", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"85", ",", "256", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"86", ",", "256", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"87", ",", "256", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"88", ",", "256", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"89", ",", "256", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"90", ",", "256", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"91", ",", "256", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"92", ",", "256", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"93", ",", "256", ",", "1"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.655136632164135*^9, 3.6551366350534077`*^9}, 
   3.65803210598988*^9, 3.662221884973385*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"idlcolorbars", "=", 
  RowBox[{"ReplacePart", "[", 
   RowBox[{"idlcolorbars", ",", 
    RowBox[{"MapThread", "[", 
     RowBox[{"Rule", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Position", "[", 
         RowBox[{"idlcolorbars", ",", 
          RowBox[{"x_", "/;", 
           RowBox[{"x", ">", "1"}]}]}], "]"}], ",", 
        RowBox[{"ConstantArray", "[", 
         RowBox[{"1", ",", 
          RowBox[{"Length", "[", 
           RowBox[{"Position", "[", 
            RowBox[{"idlcolorbars", ",", 
             RowBox[{"x_", "/;", 
              RowBox[{"x", ">", "1"}]}]}], "]"}], "]"}]}], "]"}]}], "}"}]}], 
     "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.655136300657147*^9, 3.6551363284778748`*^9}, {
  3.655136419454368*^9, 3.655136472045877*^9}, {3.6551365375778837`*^9, 
  3.655136538756977*^9}}],

Cell[BoxData[
 InterpretationBox[
  TagBox[
   FrameBox[GridBox[{
      {
       ItemBox[
        TagBox[
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0.`", ",", "0.`", ",", "0.`"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
              "0.00392156862745098`", ",", "0.00392156862745098`", ",", 
               "0.00392156862745098`"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
              "0.00784313725490196`", ",", "0.00784313725490196`", ",", 
               "0.00784313725490196`"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
              "0.011764705882352941`", ",", "0.011764705882352941`", ",", 
               "0.011764705882352941`"}], "}"}], ",", 
             TemplateBox[{"248"},
              "OutputSizeLimit`Skeleton",
              DisplayFunction->(FrameBox[
                
                RowBox[{
                 "\" \[CenterEllipsis]\"", #, "\"\[CenterEllipsis] \""}], 
                Background -> GrayLevel[0.75], 
                BaseStyle -> {
                 "Deploy", FontColor -> GrayLevel[1], FontSize -> Smaller, 
                  ShowStringCharacters -> False}, BaselinePosition -> 
                Baseline, ContentPadding -> False, FrameMargins -> 1, 
                FrameStyle -> GrayLevel[0.75], RoundingRadius -> 7]& )], ",", 
             
             RowBox[{"{", 
              RowBox[{
              "0.9882352941176471`", ",", "0.9882352941176471`", ",", 
               "0.9882352941176471`"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
              "0.9921568627450981`", ",", "0.9921568627450981`", ",", 
               "0.9921568627450981`"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
              "0.996078431372549`", ",", "0.996078431372549`", ",", 
               "0.996078431372549`"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"1.`", ",", "1.`", ",", "1.`"}], "}"}]}], "}"}], ",", 
           TemplateBox[{"117"},
            "OutputSizeLimit`Skeleton",
            DisplayFunction->(FrameBox[
              RowBox[{"\" \[CenterEllipsis]\"", #, "\"\[CenterEllipsis] \""}],
               Background -> GrayLevel[0.75], 
              BaseStyle -> {
               "Deploy", FontColor -> GrayLevel[1], FontSize -> Smaller, 
                ShowStringCharacters -> False}, BaselinePosition -> Baseline, 
              ContentPadding -> False, FrameMargins -> 1, FrameStyle -> 
              GrayLevel[0.75], RoundingRadius -> 7]& )], ",", 
           RowBox[{"{", 
            TemplateBox[{"1"},
             "OutputSizeLimit`Skeleton",
             DisplayFunction->(FrameBox[
               
               RowBox[{
                "\" \[CenterEllipsis]\"", #, "\"\[CenterEllipsis] \""}], 
               Background -> GrayLevel[0.75], 
               BaseStyle -> {
                "Deploy", FontColor -> GrayLevel[1], FontSize -> Smaller, 
                 ShowStringCharacters -> False}, BaselinePosition -> Baseline,
                ContentPadding -> False, FrameMargins -> 1, FrameStyle -> 
               GrayLevel[0.75], RoundingRadius -> 7]& )], "}"}]}], "}"}],
         Short[#, 5]& ],
        BaseStyle->{Deployed -> False},
        StripOnInput->False]},
      {GridBox[{
         {
          TagBox[
           TooltipBox[
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource[
                "FEStrings", "sizeBriefExplanation"], StandardForm],
               ImageSizeCache->{109., {4., 14.}}],
              StripOnInput->False,
              DynamicUpdating->True], "SuggestionsBarCategory",
             StripOnInput->False],
            StyleBox[
             DynamicBox[
              ToBoxes[
               FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"], 
               StandardForm]], DynamicUpdating -> True, StripOnInput -> 
             False]],
           Annotation[#, 
            Style[
             Dynamic[
              FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"]], 
             DynamicUpdating -> True], "Tooltip"]& ], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
                StandardForm],
               ImageSizeCache->{98., {0., 14.}}],
              StripOnInput->False,
              DynamicUpdating->True], "SuggestionsBarControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True], "SuggestionsBarControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, 25}],
           Appearance->None,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            Identity, 14, 30724102357432340418, 5/2],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
                StandardForm],
               ImageSizeCache->{109., {0., 14.}}],
              StripOnInput->False,
              DynamicUpdating->True], "SuggestionsBarControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True], "SuggestionsBarControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, 25}],
           Appearance->None,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            Identity, 14, 30724102357432340418, 5 2],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
                StandardForm],
               ImageSizeCache->{83., {0., 14.}}],
              StripOnInput->False,
              DynamicUpdating->True], "SuggestionsBarControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True], "SuggestionsBarControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, 25}],
           Appearance->None,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            Identity, 14, 30724102357432340418, Infinity],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
                StandardForm],
               ImageSizeCache->{148., {0., 14.}}],
              StripOnInput->False,
              DynamicUpdating->True], "SuggestionsBarControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True], "SuggestionsBarControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, 25}],
           Appearance->None,
           ButtonFunction:>FrontEndExecute[{
              FrontEnd`SetOptions[
              FrontEnd`$FrontEnd, 
               FrontEnd`PreferencesSettings -> {"Page" -> "Evaluation"}], 
              FrontEnd`FrontEndToken["PreferencesDialog"]}],
           Evaluator->None,
           Method->"Preemptive"]}
        },
        AutoDelete->False,
        FrameStyle->GrayLevel[0.85],
        GridBoxDividers->{"Columns" -> {False, {True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}}]}
     },
     DefaultBaseStyle->"Column",
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxDividers->{
      "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
       "RowsIndexed" -> {}},
     GridBoxItemSize->{
      "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], 
         Offset[1.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    Background->RGBColor[0.9657, 0.9753, 0.9802],
    FrameMargins->{{12, 12}, {0, 15}},
    FrameStyle->GrayLevel[0.85],
    RoundingRadius->5,
    StripOnInput->False],
   Deploy,
   DefaultBaseStyle->"Deploy"],
  Out[14]]], "Output",
 CellChangeTimes->{{3.6551363122976217`*^9, 3.655136328959486*^9}, 
   3.65513649844628*^9, 3.655136539956541*^9, 3.655136626284417*^9, 
   3.658032108128953*^9, 3.662221890536922*^9, 3.662226881351592*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"colorbar", "[", 
  RowBox[{"idlcolorbars", "[", 
   RowBox[{"[", 
    RowBox[{"-", "10"}], "]"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.6480630208923492`*^9, 3.648063027971355*^9}, {
   3.648063086944867*^9, 3.648063112376309*^9}, {3.648063146740756*^9, 
   3.648063147028215*^9}, {3.648063185645021*^9, 3.64806319739754*^9}, 
   3.648216346404454*^9}],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[
    0.000019872508023912684`, 0.000019586801788918958`, 
     0.000019529289536969018`], 
    RectangleBox[{0, 0}, NCache[{Rational[1, 256], 1}, {0.00390625, 1}]]}, 
   {RGBColor[
    0.0003821747537140887, 0.00032231847646100757`, 0.0003682289510307921], 
    RectangleBox[NCache[{Rational[1, 256], 0}, {0.00390625, 0}], 
     NCache[{Rational[1, 128], 1}, {0.0078125, 1}]]}, 
   {RGBColor[
    0.0011303579711904603`, 0.0009058613625107553, 0.0010874119005089922`], 
    RectangleBox[NCache[{Rational[1, 128], 0}, {0.0078125, 0}], 
     NCache[{Rational[3, 256], 1}, {0.01171875, 1}]]}, 
   {RGBColor[
    0.0022375102519527888`, 0.0017286942214234824`, 0.00215593951469943], 
    RectangleBox[NCache[{Rational[3, 256], 0}, {0.01171875, 0}], 
     NCache[{Rational[1, 64], 1}, {0.015625, 1}]]}, 
   {RGBColor[0.00369219012503028, 0.002768517028767429, 0.003569762249640236],
     RectangleBox[NCache[{Rational[1, 64], 0}, {0.015625, 0}], 
     NCache[{Rational[5, 256], 1}, {0.01953125, 1}]]}, 
   {RGBColor[
    0.005487807554125586, 0.004010384174826644, 0.0053311000253665735`], 
    RectangleBox[NCache[{Rational[5, 256], 0}, {0.01953125, 0}], 
     NCache[{Rational[3, 128], 1}, {0.0234375, 1}]]}, 
   {RGBColor[
    0.007619941119688378, 0.005443301922390801, 0.007445594893853117], 
    RectangleBox[NCache[{Rational[3, 128], 0}, {0.0234375, 0}], 
     NCache[{Rational[7, 256], 1}, {0.02734375, 1}]]}, 
   {RGBColor[
    0.010085263765298896`, 0.007058756260672507, 0.009921132168307279], 
    RectangleBox[NCache[{Rational[7, 256], 0}, {0.02734375, 0}], 
     NCache[{Rational[1, 32], 1}, {0.03125, 1}]]}, 
   {RGBColor[
    0.012881015320104881`, 0.008849942581789014, 0.012767242695708277`], 
    RectangleBox[NCache[{Rational[1, 32], 0}, {0.03125, 0}], 
     NCache[{Rational[9, 256], 1}, {0.03515625, 1}]]}, 
   {RGBColor[0.016004709078559307`, 0.010811313358364, 0.01599475972877519], 
    RectangleBox[NCache[{Rational[9, 256], 0}, {0.03515625, 0}], 
     NCache[{Rational[5, 128], 1}, {0.0390625, 1}]]}, 
   {RGBColor[
    0.019453953788375025`, 0.012938290929315805`, 0.01961560410729425], 
    RectangleBox[NCache[{Rational[5, 128], 0}, {0.0390625, 0}], 
     NCache[{Rational[11, 256], 1}, {0.04296875, 1}]]}, 
   {RGBColor[
    0.023226338377868305`, 0.015227074491369093`, 0.023642640564091412`], 
    RectangleBox[NCache[{Rational[11, 256], 0}, {0.04296875, 0}], 
     NCache[{Rational[3, 64], 1}, {0.046875, 1}]]}, 
   {RGBColor[
    0.027319353344989097`, 0.017674504729487634`, 0.028089576236787924`], 
    RectangleBox[NCache[{Rational[3, 64], 0}, {0.046875, 0}], 
     NCache[{Rational[13, 256], 1}, {0.05078125, 1}]]}, 
   {RGBColor[0.03173033480581502, 0.02027796567270543, 0.032970885496207546`],
     RectangleBox[NCache[{Rational[13, 256], 0}, {0.05078125, 0}], 
     NCache[{Rational[7, 128], 1}, {0.0546875, 1}]]}, 
   {RGBColor[
    0.03645642319681485, 0.023035311654831907`, 0.038301751772313035`], 
    RectangleBox[NCache[{Rational[7, 128], 0}, {0.0546875, 0}], 
     NCache[{Rational[15, 256], 1}, {0.05859375, 1}]]}, 
   {RGBColor[0.0414693326693522, 0.02594481181838983, 0.04394663647063383], 
    RectangleBox[NCache[{Rational[15, 256], 0}, {0.05859375, 0}], 
     NCache[{Rational[1, 16], 1}, {0.0625, 1}]]}, 
   {RGBColor[
    0.046466315330026674`, 0.02900510724841947, 0.049589203266613584`], 
    RectangleBox[NCache[{Rational[1, 16], 0}, {0.0625, 0}], 
     NCache[{Rational[17, 256], 1}, {0.06640625, 1}]]}, 
   {RGBColor[
    0.051398611854077354`, 0.03221517743284131, 0.055236833009249024`], 
    RectangleBox[NCache[{Rational[17, 256], 0}, {0.06640625, 0}], 
     NCache[{Rational[9, 128], 1}, {0.0703125, 1}]]}, 
   {RGBColor[0.056269189930206555`, 0.03557431376311154, 0.0608938549405721], 
    RectangleBox[NCache[{Rational[9, 128], 0}, {0.0703125, 0}], 
     NCache[{Rational[19, 256], 1}, {0.07421875, 1}]]}, 
   {RGBColor[0.0610805145480724, 0.039082098452642544`, 0.06656403268485919], 
    RectangleBox[NCache[{Rational[19, 256], 0}, {0.07421875, 0}], 
     NCache[{Rational[5, 64], 1}, {0.078125, 1}]]}, 
   {RGBColor[0.06583463262515846, 0.042663878715898086`, 0.07225065178693316],
     RectangleBox[NCache[{Rational[5, 64], 0}, {0.078125, 0}], 
     NCache[{Rational[21, 256], 1}, {0.08203125, 1}]]}, 
   {RGBColor[0.07053323958637395, 0.04619682657778581, 0.07795658858591387], 
    RectangleBox[NCache[{Rational[21, 256], 0}, {0.08203125, 0}], 
     NCache[{Rational[11, 128], 1}, {0.0859375, 1}]]}, 
   {RGBColor[0.07517773240226291, 0.049693834583369144`, 0.08368436504287219],
     RectangleBox[NCache[{Rational[11, 128], 0}, {0.0859375, 0}], 
     NCache[{Rational[23, 256], 1}, {0.08984375, 1}]]}, 
   {RGBColor[0.07976925231734056, 0.05315807945501814, 0.08943619284264687], 
    RectangleBox[NCache[{Rational[23, 256], 0}, {0.08984375, 0}], 
     NCache[{Rational[3, 32], 1}, {0.09375, 1}]]}, 
   {RGBColor[0.08430871962518496, 0.05659249370301777, 0.09521400919726669], 
    RectangleBox[NCache[{Rational[3, 32], 0}, {0.09375, 0}], 
     NCache[{Rational[25, 256], 1}, {0.09765625, 1}]]}, 
   {RGBColor[
    0.08879686223507247, 0.059999799401728844`, 0.10101950615291677`], 
    RectangleBox[NCache[{Rational[25, 256], 0}, {0.09765625, 0}], 
     NCache[{Rational[13, 128], 1}, {0.1015625, 1}]]}, 
   {RGBColor[0.09323423933979194, 0.06338253629717139, 0.10685415475676299`], 
    RectangleBox[NCache[{Rational[13, 128], 0}, {0.1015625, 0}], 
     NCache[{Rational[27, 256], 1}, {0.10546875, 1}]]}, 
   {RGBColor[0.09762126118006856, 0.06674308536626583, 0.11271922511760435`], 
    RectangleBox[NCache[{Rational[27, 256], 0}, {0.10546875, 0}], 
     NCache[{Rational[7, 64], 1}, {0.109375, 1}]]}, 
   {RGBColor[0.1019582056709499, 0.07008368869195847, 0.11861580315789783`], 
    RectangleBox[NCache[{Rational[7, 64], 0}, {0.109375, 0}], 
     NCache[{Rational[29, 256], 1}, {0.11328125, 1}]]}, 
   {RGBColor[0.10624523248489995`, 0.07340646632779849, 0.12454480467906828`],
     RectangleBox[NCache[{Rational[29, 256], 0}, {0.11328125, 0}], 
     NCache[{Rational[15, 128], 1}, {0.1171875, 1}]]}, 
   {RGBColor[0.1104823950583112, 0.07671343068191314, 0.13050698723001347`], 
    RectangleBox[NCache[{Rational[15, 128], 0}, {0.1171875, 0}], 
     NCache[{Rational[31, 256], 1}, {0.12109375, 1}]]}, 
   {RGBColor[0.11466965089105122`, 0.08000649884094369, 0.1365029601684282], 
    RectangleBox[NCache[{Rational[31, 256], 0}, {0.12109375, 0}], 
     NCache[{Rational[1, 8], 1}, {0.125, 1}]]}, 
   {RGBColor[0.1188068704342608, 0.08328750317038133, 0.1425331932276099], 
    RectangleBox[NCache[{Rational[1, 8], 0}, {0.125, 0}], 
     NCache[{Rational[33, 256], 1}, {0.12890625, 1}]]}, 
   {RGBColor[0.12289384480409918`, 0.08655820046244309, 0.14859802384180562`],
     RectangleBox[NCache[{Rational[33, 256], 0}, {0.12890625, 0}], 
     NCache[{Rational[17, 128], 1}, {0.1328125, 1}]]}, 
   {RGBColor[0.12693029251425803`, 0.08982027985150418, 0.15469766343659094`],
     RectangleBox[NCache[{Rational[17, 128], 0}, {0.1328125, 0}], 
     NCache[{Rational[35, 256], 1}, {0.13671875, 1}]]}, 
   {RGBColor[0.1309158653847885, 0.09307536967677146, 0.16083220285410074`], 
    RectangleBox[NCache[{Rational[35, 256], 0}, {0.13671875, 0}], 
     NCache[{Rational[9, 64], 1}, {0.140625, 1}]]}, 
   {RGBColor[0.13485015375684625`, 0.09632504343980991, 0.16700161705382072`],
     RectangleBox[NCache[{Rational[9, 64], 0}, {0.140625, 0}], 
     NCache[{Rational[37, 256], 1}, {0.14453125, 1}]]}, 
   {RGBColor[0.1387326911206436, 0.09957082497888947, 0.17320576920639616`], 
    RectangleBox[NCache[{Rational[37, 256], 0}, {0.14453125, 0}], 
     NCache[{Rational[19, 128], 1}, {0.1484375, 1}]]}, 
   {RGBColor[
    0.14256295824601908`, 0.10281419296144978`, 0.17944441427918437`], 
    RectangleBox[NCache[{Rational[19, 128], 0}, {0.1484375, 0}], 
     NCache[{Rational[39, 256], 1}, {0.15234375, 1}]]}, 
   {RGBColor[0.1463403868905427, 0.10605658477926005`, 0.1857172021971224], 
    RectangleBox[NCache[{Rational[39, 256], 0}, {0.15234375, 0}], 
     NCache[{Rational[5, 32], 1}, {0.15625, 1}]]}, 
   {RGBColor[
    0.15006436314833416`, 0.10929939991723103`, 0.19202368065012101`], 
    RectangleBox[NCache[{Rational[5, 32], 0}, {0.15625, 0}], 
     NCache[{Rational[41, 256], 1}, {0.16015625, 1}]]}, 
   {RGBColor[
    0.15373423049315588`, 0.11254400285571248`, 0.19836329760806037`], 
    RectangleBox[NCache[{Rational[41, 256], 0}, {0.16015625, 0}], 
     NCache[{Rational[21, 128], 1}, {0.1640625, 1}]]}, 
   {RGBColor[
    0.15734929256145097`, 0.11579172555696429`, 0.20473540359610648`], 
    RectangleBox[NCache[{Rational[21, 128], 0}, {0.1640625, 0}], 
     NCache[{Rational[43, 256], 1}, {0.16796875, 1}]]}, 
   {RGBColor[
    0.16090881571448726`, 0.11904386957897534`, 0.21113925377612314`], 
    RectangleBox[NCache[{Rational[43, 256], 0}, {0.16796875, 0}], 
     NCache[{Rational[11, 64], 1}, {0.171875, 1}]]}, 
   {RGBColor[
    0.16441203141336475`, 0.12230170785358704`, 0.21757400987416758`], 
    RectangleBox[NCache[{Rational[11, 64], 0}, {0.171875, 0}], 
     NCache[{Rational[45, 256], 1}, {0.17578125, 1}]]}, 
   {RGBColor[0.16785813843614672`, 0.12556648616074084`, 0.2240387419891805], 
    RectangleBox[NCache[{Rational[45, 256], 0}, {0.17578125, 0}], 
     NCache[{Rational[23, 128], 1}, {0.1796875, 1}]]}, 
   {RGBColor[
    0.17124630496261856`, 0.12883942432641876`, 0.23053243031387294`], 
    RectangleBox[NCache[{Rational[23, 128], 0}, {0.1796875, 0}], 
     NCache[{Rational[47, 256], 1}, {0.18359375, 1}]]}, 
   {RGBColor[0.1745756705490212, 0.13212171716831367`, 0.2370539667952956], 
    RectangleBox[NCache[{Rational[47, 256], 0}, {0.18359375, 0}], 
     NCache[{Rational[3, 16], 1}, {0.1875, 1}]]}, 
   {RGBColor[
    0.17784534801244595`, 0.13541453521035862`, 0.24360215675957886`], 
    RectangleBox[NCache[{Rational[3, 16], 0}, {0.1875, 0}], 
     NCache[{Rational[49, 256], 1}, {0.19140625, 1}]]}, 
   {RGBColor[0.18105442524233822`, 0.13871902518482893`, 0.2501757205227168], 
    RectangleBox[NCache[{Rational[49, 256], 0}, {0.19140625, 0}], 
     NCache[{Rational[25, 128], 1}, {0.1953125, 1}]]}, 
   {RGBColor[0.18420196695464194`, 0.14203631033875339`, 0.2567732950070118], 
    RectangleBox[NCache[{Rational[25, 128], 0}, {0.1953125, 0}], 
     NCache[{Rational[51, 256], 1}, {0.19921875, 1}]]}, 
   {RGBColor[
    0.18728701640250717`, 0.14536749055974293`, 0.26339343538078575`], 
    RectangleBox[NCache[{Rational[51, 256], 0}, {0.19921875, 0}], 
     NCache[{Rational[13, 64], 1}, {0.203125, 1}]]}, 
   {RGBColor[
    0.19030859705609782`, 0.14871364233502668`, 0.27003461673720436`], 
    RectangleBox[NCache[{Rational[13, 64], 0}, {0.203125, 0}], 
     NCache[{Rational[53, 256], 1}, {0.20703125, 1}]]}, 
   {RGBColor[0.193265714262849, 0.1520758185564185, 0.2766952358264513], 
    RectangleBox[NCache[{Rational[53, 256], 0}, {0.20703125, 0}], 
     NCache[{Rational[27, 128], 1}, {0.2109375, 1}]]}, 
   {RGBColor[
    0.19615735689852948`, 0.15545504818308684`, 0.28337361285405294`], 
    RectangleBox[NCache[{Rational[27, 128], 0}, {0.2109375, 0}], 
     NCache[{Rational[55, 256], 1}, {0.21484375, 1}]]}, 
   {RGBColor[0.19898249901857495`, 0.15885233577333552`, 0.2900679933568262], 
    RectangleBox[NCache[{Rational[55, 256], 0}, {0.21484375, 0}], 
     NCache[{Rational[7, 32], 1}, {0.21875, 1}]]}, 
   {RGBColor[0.20174010151843175`, 0.16226866089608824`, 0.2967765501666894], 
    RectangleBox[NCache[{Rational[7, 32], 0}, {0.21875, 0}], 
     NCache[{Rational[57, 256], 1}, {0.22265625, 1}]]}, 
   {RGBColor[
    0.20442911381099482`, 0.16570497743239032`, 0.30349738547142463`], 
    RectangleBox[NCache[{Rational[57, 256], 0}, {0.22265625, 0}], 
     NCache[{Rational[29, 128], 1}, {0.2265625, 1}]]}, 
   {RGBColor[0.20704847552869116`, 0.1691622127769538, 0.31022853298039377`], 
    RectangleBox[NCache[{Rational[29, 128], 0}, {0.2265625, 0}], 
     NCache[{Rational[59, 256], 1}, {0.23046875, 1}]]}, 
   {RGBColor[0.20959711825727473`, 0.1726412669495949, 0.31696796020216483`], 
    RectangleBox[NCache[{Rational[59, 256], 0}, {0.23046875, 0}], 
     NCache[{Rational[15, 64], 1}, {0.234375, 1}]]}, 
   {RGBColor[0.21207396730800387`, 0.17614301162628374`, 0.3237135708400021], 
    RectangleBox[NCache[{Rational[15, 64], 0}, {0.234375, 0}], 
     NCache[{Rational[61, 256], 1}, {0.23828125, 1}]]}, 
   {RGBColor[0.2144779435345452, 0.1796682890994638, 0.3304632073102074], 
    RectangleBox[NCache[{Rational[61, 256], 0}, {0.23828125, 0}], 
     NCache[{Rational[31, 128], 1}, {0.2421875, 1}]]}, 
   {RGBColor[0.21680796520063356`, 0.18321791117728398`, 0.3372146533873398], 
    RectangleBox[NCache[{Rational[31, 128], 0}, {0.2421875, 0}], 
     NCache[{Rational[63, 256], 1}, {0.24609375, 1}]]}, 
   {RGBColor[0.21906294990434255`, 0.18679265803137104`, 0.3439656369794243], 
    RectangleBox[NCache[{Rational[63, 256], 0}, {0.24609375, 0}], 
     NCache[{Rational[1, 4], 1}, {0.25, 1}]]}, 
   {RGBColor[0.22124181656456582`, 0.1903932770028205, 0.3507138330353246], 
    RectangleBox[NCache[{Rational[1, 4], 0}, {0.25, 0}], 
     NCache[{Rational[65, 256], 1}, {0.25390625, 1}]]}, 
   {RGBColor[0.22334348747523836`, 0.1940204813760865, 0.35745686658557074`], 
    RectangleBox[NCache[{Rational[65, 256], 0}, {0.25390625, 0}], 
     NCache[{Rational[33, 128], 1}, {0.2578125, 1}]]}, 
   {RGBColor[0.22536689043269065`, 0.1976749491304962, 0.36419231591701384`], 
    RectangleBox[NCache[{Rational[33, 128], 0}, {0.2578125, 0}], 
     NCache[{Rational[67, 256], 1}, {0.26171875, 1}]]}, 
   {RGBColor[0.2273109609415046, 0.20135732167911813`, 0.3709177158808133], 
    RectangleBox[NCache[{Rational[67, 256], 0}, {0.26171875, 0}], 
     NCache[{Rational[17, 64], 1}, {0.265625, 1}]]}, 
   {RGBColor[0.2291746445042166, 0.20506820260472164`, 0.37763056133236994`], 
    RectangleBox[NCache[{Rational[17, 64], 0}, {0.265625, 0}], 
     NCache[{Rational[69, 256], 1}, {0.26953125, 1}]]}, 
   {RGBColor[0.23095689900027333`, 0.20880815640252448`, 0.3843283107009525], 
    RectangleBox[NCache[{Rational[69, 256], 0}, {0.26953125, 0}], 
     NCache[{Rational[35, 128], 1}, {0.2734375, 1}]]}, 
   {RGBColor[0.23265669715972448`, 0.21257770723937375`, 0.3910083896859115], 
    RectangleBox[NCache[{Rational[35, 128], 0}, {0.2734375, 0}], 
     NCache[{Rational[71, 256], 1}, {0.27734375, 1}]]}, 
   {RGBColor[
    0.23427302913727371`, 0.21637733773890838`, 0.39766819507552215`], 
    RectangleBox[NCache[{Rational[71, 256], 0}, {0.27734375, 0}], 
     NCache[{Rational[9, 32], 1}, {0.28125, 1}]]}, 
   {RGBColor[
    0.23580490519251246`, 0.22020748780211352`, 0.40430509868366993`], 
    RectangleBox[NCache[{Rational[9, 32], 0}, {0.28125, 0}], 
     NCache[{Rational[73, 256], 1}, {0.28515625, 1}]]}, 
   {RGBColor[0.2372513584824011, 0.22406855347249405`, 0.4109164513987803], 
    RectangleBox[NCache[{Rational[73, 256], 0}, {0.28515625, 0}], 
     NCache[{Rational[37, 128], 1}, {0.2890625, 1}]]}, 
   {RGBColor[0.23861144797239164`, 0.22796088585487284`, 0.417499587338596], 
    RectangleBox[NCache[{Rational[37, 128], 0}, {0.2890625, 0}], 
     NCache[{Rational[75, 256], 1}, {0.29296875, 1}]]}, 
   {RGBColor[0.23988426147293523`, 0.23188479009654733`, 0.4240518281036454], 
    RectangleBox[NCache[{Rational[75, 256], 0}, {0.29296875, 0}], 
     NCache[{Rational[19, 64], 1}, {0.296875, 1}]]}, 
   {RGBColor[0.2410689188086121, 0.23584052443920062`, 0.43057048712149165`], 
    RectangleBox[NCache[{Rational[19, 64], 0}, {0.296875, 0}], 
     NCache[{Rational[77, 256], 1}, {0.30078125, 1}]]}, 
   {RGBColor[
    0.24216457512762934`, 0.23982829934960503`, 0.43705287407315796`], 
    RectangleBox[NCache[{Rational[77, 256], 0}, {0.30078125, 0}], 
     NCache[{Rational[39, 128], 1}, {0.3046875, 1}]]}, 
   {RGBColor[0.243170424360048, 0.24384827673673287`, 0.4434962993924308], 
    RectangleBox[NCache[{Rational[39, 128], 0}, {0.3046875, 0}], 
     NCache[{Rational[79, 256], 1}, {0.30859375, 1}]]}, 
   {RGBColor[0.24408570283384573`, 0.24790056926240867`, 0.4498980788281303], 
    RectangleBox[NCache[{Rational[79, 256], 0}, {0.30859375, 0}], 
     NCache[{Rational[5, 16], 1}, {0.3125, 1}]]}, 
   {RGBColor[0.2449096930586976, 0.2519852397521444, 0.4562555380588191], 
    RectangleBox[NCache[{Rational[5, 16], 0}, {0.3125, 0}], 
     NCache[{Rational[81, 256], 1}, {0.31640625, 1}]]}, 
   {RGBColor[0.24564172768832843`, 0.25610230071222195`, 0.4625660173489016], 
    RectangleBox[NCache[{Rational[81, 256], 0}, {0.31640625, 0}], 
     NCache[{Rational[41, 128], 1}, {0.3203125, 1}]]}, 
   {RGBColor[0.2462811936732956, 0.2602517139585175, 0.46882687623454417`], 
    RectangleBox[NCache[{Rational[41, 128], 0}, {0.3203125, 0}], 
     NCache[{Rational[83, 256], 1}, {0.32421875, 1}]]}, 
   {RGBColor[0.24682753661727264`, 0.26443339036190633`, 0.475035498227434], 
    RectangleBox[NCache[{Rational[83, 256], 0}, {0.32421875, 0}], 
     NCache[{Rational[21, 64], 1}, {0.328125, 1}]]}, 
   {RGBColor[0.2472802653511748, 0.26864718971445967`, 0.4811892955239882], 
    RectangleBox[NCache[{Rational[21, 64], 0}, {0.328125, 0}], 
     NCache[{Rational[85, 256], 1}, {0.33203125, 1}]]}, 
   {RGBColor[0.24763895674099135`, 0.2728929207199228, 0.48728571370731794`], 
    RectangleBox[NCache[{Rational[85, 256], 0}, {0.33203125, 0}], 
     NCache[{Rational[43, 128], 1}, {0.3359375, 1}]]}, 
   {RGBColor[0.24790326074671137`, 0.2771703411112956, 0.4933222364289857], 
    RectangleBox[NCache[{Rational[43, 128], 0}, {0.3359375, 0}], 
     NCache[{Rational[87, 256], 1}, {0.33984375, 1}]]}, 
   {RGBColor[0.2480729057515777, 0.28147915789758954`, 0.4992963900574114], 
    RectangleBox[NCache[{Rational[87, 256], 0}, {0.33984375, 0}], 
     NCache[{Rational[11, 32], 1}, {0.34375, 1}]]}, 
   {RGBColor[0.24814770418282822`, 0.28581902774110796`, 0.5052057482796435], 
    RectangleBox[NCache[{Rational[11, 32], 0}, {0.34375, 0}], 
     NCache[{Rational[89, 256], 1}, {0.34765625, 1}]]}, 
   {RGBColor[0.24812755844715684`, 0.29018955746587644`, 0.5110479366431763], 
    RectangleBox[NCache[{Rational[89, 256], 0}, {0.34765625, 0}], 
     NCache[{Rational[45, 128], 1}, {0.3515625, 1}]]}, 
   {RGBColor[0.24801246720647813`, 0.2945903046970949, 0.5168206370244942], 
    RectangleBox[NCache[{Rational[45, 128], 0}, {0.3515625, 0}], 
     NCache[{Rational[91, 256], 1}, {0.35546875, 1}]]}, 
   {RGBColor[0.2478025320219991, 0.2990207786307698, 0.5225215920111225], 
    RectangleBox[NCache[{Rational[91, 256], 0}, {0.35546875, 0}], 
     NCache[{Rational[23, 64], 1}, {0.359375, 1}]]}, 
   {RGBColor[0.24749796439724137`, 0.3034804409319618, 0.5281486091841182], 
    RectangleBox[NCache[{Rational[23, 64], 0}, {0.359375, 0}], 
     NCache[{Rational[93, 256], 1}, {0.36328125, 1}]]}, 
   {RGBColor[0.2470990932534634, 0.30796870675939575`, 0.533699565288171], 
    RectangleBox[NCache[{Rational[93, 256], 0}, {0.36328125, 0}], 
     NCache[{Rational[47, 128], 1}, {0.3671875, 1}]]}, 
   {RGBColor[0.2466063728738287, 0.3124849459134895, 0.5391724102767773], 
    RectangleBox[NCache[{Rational[47, 128], 0}, {0.3671875, 0}], 
     NCache[{Rational[95, 256], 1}, {0.37109375, 1}]]}, 
   {RGBColor[0.24602039135574588`, 0.31702848410422096`, 0.54456517122033], 
    RectangleBox[NCache[{Rational[95, 256], 0}, {0.37109375, 0}], 
     NCache[{Rational[3, 8], 1}, {0.375, 1}]]}, 
   {RGBColor[0.2453418796138238, 0.32159860433464377`, 0.5498759560653981], 
    RectangleBox[NCache[{Rational[3, 8], 0}, {0.375, 0}], 
     NCache[{Rational[97, 256], 1}, {0.37890625, 1}]]}, 
   {RGBColor[0.2445717209791317, 0.32619454839525114`, 0.5551029572339697], 
    RectangleBox[NCache[{Rational[97, 256], 0}, {0.37890625, 0}], 
     NCache[{Rational[49, 128], 1}, {0.3828125, 1}]]}, 
   {RGBColor[0.24371096144333437`, 0.33081551846388524`, 0.5602444550520086], 
    RectangleBox[NCache[{Rational[49, 128], 0}, {0.3828125, 0}], 
     NCache[{Rational[99, 256], 1}, {0.38671875, 1}]]}, 
   {RGBColor[0.24276082059930232`, 0.3354606788053541, 0.5652988209972724], 
    RectangleBox[NCache[{Rational[99, 256], 0}, {0.38671875, 0}], 
     NCache[{Rational[25, 64], 1}, {0.390625, 1}]]}, 
   {RGBColor[0.24172270333222862`, 0.3401291575644945, 0.5702645207570367], 
    RectangleBox[NCache[{Rational[25, 64], 0}, {0.390625, 0}], 
     NCache[{Rational[101, 256], 1}, {0.39453125, 1}]]}, 
   {RGBColor[0.2405982123175171, 0.34482004864598176`, 0.5751401170870909], 
    RectangleBox[NCache[{Rational[101, 256], 0}, {0.39453125, 0}], 
     NCache[{Rational[51, 128], 1}, {0.3984375, 1}]]}, 
   {RGBColor[0.239389161382975, 0.3495324136738584, 0.5799242724641246], 
    RectangleBox[NCache[{Rational[51, 128], 0}, {0.3984375, 0}], 
     NCache[{Rational[103, 256], 1}, {0.40234375, 1}]]}, 
   {RGBColor[0.2380975897933847, 0.3542652840234272, 0.5846157515244547], 
    RectangleBox[NCache[{Rational[103, 256], 0}, {0.40234375, 0}], 
     NCache[{Rational[13, 32], 1}, {0.40625, 1}]]}, 
   {RGBColor[0.23672577751460389`, 0.3590176629179023, 0.5892134232828802], 
    RectangleBox[NCache[{Rational[13, 32], 0}, {0.40625, 0}], 
     NCache[{Rational[105, 256], 1}, {0.41015625, 1}]]}, 
   {RGBColor[0.23527626151173792`, 0.3637885275820175, 0.5937162631263116], 
    RectangleBox[NCache[{Rational[105, 256], 0}, {0.41015625, 0}], 
     NCache[{Rational[53, 128], 1}, {0.4140625, 1}]]}, 
   {RGBColor[0.23375185313113123`, 0.36857683144461684`, 0.5981233545777467], 
    RectangleBox[NCache[{Rational[53, 128], 0}, {0.4140625, 0}], 
     NCache[{Rational[107, 256], 1}, {0.41796875, 1}]]}, 
   {RGBColor[0.2321556566080616, 0.37338150638218004`, 0.6024338908270428], 
    RectangleBox[NCache[{Rational[107, 256], 0}, {0.41796875, 0}], 
     NCache[{Rational[27, 64], 1}, {0.421875, 1}]]}, 
   {RGBColor[0.2304910887307987, 0.37820146499515434`, 0.6066471760258946], 
    RectangleBox[NCache[{Rational[27, 64], 0}, {0.421875, 0}], 
     NCache[{Rational[109, 256], 1}, {0.42578125, 1}]]}, 
   {RGBColor[0.22876189967564137`, 0.3830356029089834, 0.6107626263453322], 
    RectangleBox[NCache[{Rational[109, 256], 0}, {0.42578125, 0}], 
     NCache[{Rational[55, 128], 1}, {0.4296875, 1}]]}, 
   {RGBColor[0.2269721950060763, 0.3878828010917573, 0.6147797707949911], 
    RectangleBox[NCache[{Rational[55, 128], 0}, {0.4296875, 0}], 
     NCache[{Rational[111, 256], 1}, {0.43359375, 1}]]}, 
   {RGBColor[0.22512645880083187`, 0.3927419281805068, 0.6186982518043316], 
    RectangleBox[NCache[{Rational[111, 256], 0}, {0.43359375, 0}], 
     NCache[{Rational[7, 16], 1}, {0.4375, 1}]]}, 
   {RGBColor[0.2232295778390036, 0.39761184280828754`, 0.6225178255668922], 
    RectangleBox[NCache[{Rational[7, 16], 0}, {0.4375, 0}], 
     NCache[{Rational[113, 256], 1}, {0.44140625, 1}]]}, 
   {RGBColor[0.22128686672404357`, 0.4024913959243844, 0.6262383621495465], 
    RectangleBox[NCache[{Rational[113, 256], 0}, {0.44140625, 0}], 
     NCache[{Rational[57, 128], 1}, {0.4453125, 1}]]}, 
   {RGBColor[0.21930409377049642`, 0.4073794331001758, 0.6298598453696113], 
    RectangleBox[NCache[{Rational[57, 128], 0}, {0.4453125, 0}], 
     NCache[{Rational[115, 256], 1}, {0.44921875, 1}]]}, 
   {RGBColor[0.21728750740624397`, 0.4122747968134433, 0.6333823724434873], 
    RectangleBox[NCache[{Rational[115, 256], 0}, {0.44921875, 0}], 
     NCache[{Rational[29, 64], 1}, {0.453125, 1}]]}, 
   {RGBColor[0.21524386275680363`, 0.41717632870419447`, 0.6368061534113179], 
    RectangleBox[NCache[{Rational[29, 64], 0}, {0.453125, 0}], 
     NCache[{Rational[117, 256], 1}, {0.45703125, 1}]]}, 
   {RGBColor[0.21318044797538288`, 0.42208287179537546`, 0.6401315103429205], 
    RectangleBox[NCache[{Rational[117, 256], 0}, {0.45703125, 0}], 
     NCache[{Rational[59, 128], 1}, {0.4609375, 1}]]}, 
   {RGBColor[0.21110510976168212`, 0.426993272672185, 0.6433588763309752], 
    RectangleBox[NCache[{Rational[59, 128], 0}, {0.4609375, 0}], 
     NCache[{Rational[119, 256], 1}, {0.46484375, 1}]]}, 
   {RGBColor[0.20902627737306367`, 0.43190638361406264`, 0.6464887942781288], 
    RectangleBox[NCache[{Rational[119, 256], 0}, {0.46484375, 0}], 
     NCache[{Rational[15, 32], 1}, {0.46875, 1}]]}, 
   {RGBColor[0.2069529842743527, 0.4368210646737907, 0.6495219154853014], 
    RectangleBox[NCache[{Rational[15, 32], 0}, {0.46875, 0}], 
     NCache[{Rational[121, 256], 1}, {0.47265625, 1}]]}, 
   {RGBColor[0.20489488639865922`, 0.4417361856985626, 0.6524589980490826], 
    RectangleBox[NCache[{Rational[121, 256], 0}, {0.47265625, 0}], 
     NCache[{Rational[61, 128], 1}, {0.4765625, 1}]]}, 
   {RGBColor[0.20286227580548089`, 0.4466506282882506, 0.6553009050765991], 
    RectangleBox[NCache[{Rational[61, 128], 0}, {0.4765625, 0}], 
     NCache[{Rational[123, 256], 1}, {0.48046875, 1}]]}, 
   {RGBColor[0.20086608833020003`, 0.45156328768655224`, 0.6580486027267345], 
    RectangleBox[NCache[{Rational[123, 256], 0}, {0.48046875, 0}], 
     NCache[{Rational[31, 64], 1}, {0.484375, 1}]]}, 
   {RGBColor[0.1989179036311805, 0.4564730746010888, 0.6607031580869783], 
    RectangleBox[NCache[{Rational[31, 64], 0}, {0.484375, 0}], 
     NCache[{Rational[125, 256], 1}, {0.48828125, 1}]]}, 
   {RGBColor[0.1970299358705817, 0.4613789169489731, 0.6632657368955485], 
    RectangleBox[NCache[{Rational[125, 256], 0}, {0.48828125, 0}], 
     NCache[{Rational[63, 128], 1}, {0.4921875, 1}]]}, 
   {RGBColor[0.19521501313155976`, 0.4662797615247923, 0.6657376011187208], 
    RectangleBox[NCache[{Rational[63, 128], 0}, {0.4921875, 0}], 
     NCache[{Rational[127, 256], 1}, {0.49609375, 1}]]}, 
   {RGBColor[0.19348654360033457`, 0.4711745755883639, 0.6681201063935427], 
    RectangleBox[NCache[{Rational[127, 256], 0}, {0.49609375, 0}], 
     NCache[{Rational[1, 2], 1}, {0.5, 1}]]}, 
   {RGBColor[0.1918584665542043, 0.47606234837005784`, 0.6704146993462954], 
    RectangleBox[NCache[{Rational[1, 2], 0}, {0.5, 0}], 
     NCache[{Rational[129, 256], 1}, {0.50390625, 1}]]}, 
   {RGBColor[0.19034518632571576`, 0.48094209249188385`, 0.672622914797182], 
    RectangleBox[NCache[{Rational[129, 256], 0}, {0.50390625, 0}], 
     NCache[{Rational[65, 128], 1}, {0.5078125, 1}]]}, 
   {RGBColor[0.18896148768971566`, 0.48581284530295127`, 0.6747463728618022], 
    RectangleBox[NCache[{Rational[65, 128], 0}, {0.5078125, 0}], 
     NCache[{Rational[131, 256], 1}, {0.51171875, 1}]]}, 
   {RGBColor[0.18772243157114823`, 0.4906736701283044, 0.6767867759599829], 
    RectangleBox[NCache[{Rational[131, 256], 0}, {0.51171875, 0}], 
     NCache[{Rational[33, 64], 1}, {0.515625, 1}]]}, 
   {RGBColor[0.18664323061700247`, 0.4955236574305146, 0.6787459057424973], 
    RectangleBox[NCache[{Rational[33, 64], 0}, {0.515625, 0}], 
     NCache[{Rational[133, 256], 1}, {0.51953125, 1}]]}, 
   {RGBColor[0.18573910502128219`, 0.5003619258837817, 0.6806256199461223], 
    RectangleBox[NCache[{Rational[133, 256], 0}, {0.51953125, 0}], 
     NCache[{Rational[67, 128], 1}, {0.5234375, 1}]]}, 
   {RGBColor[0.18502512002322039`, 0.5051876233606377, 0.6824278491873513], 
    RectangleBox[NCache[{Rational[67, 128], 0}, {0.5234375, 0}], 
     NCache[{Rational[135, 256], 1}, {0.52734375, 1}]]}, 
   {RGBColor[0.18451600767597595`, 0.5099999278316991, 0.6841545937048996], 
    RectangleBox[NCache[{Rational[135, 256], 0}, {0.52734375, 0}], 
     NCache[{Rational[17, 32], 1}, {0.53125, 1}]]}, 
   {RGBColor[0.18422597673782073`, 0.5147980481792083, 0.6858079200609183], 
    RectangleBox[NCache[{Rational[17, 32], 0}, {0.53125, 0}], 
     NCache[{Rational[137, 256], 1}, {0.53515625, 1}]]}, 
   {RGBColor[0.18416851577302565`, 0.5195812249254123, 0.6873899578105824], 
    RectangleBox[NCache[{Rational[137, 256], 0}, {0.53515625, 0}], 
     NCache[{Rational[69, 128], 1}, {0.5390625, 1}]]}, 
   {RGBColor[0.18435619564607184`, 0.5243487308771058, 0.6889028961494137], 
    RectangleBox[NCache[{Rational[69, 128], 0}, {0.5390625, 0}], 
     NCache[{Rational[139, 256], 1}, {0.54296875, 1}]]}, 
   {RGBColor[0.18480047842036804`, 0.5290998716879117, 0.6903489805473887], 
    RectangleBox[NCache[{Rational[139, 256], 0}, {0.54296875, 0}], 
     NCache[{Rational[35, 64], 1}, {0.546875, 1}]]}, 
   {RGBColor[0.1855115401061567, 0.5338339863401154, 0.6917305093785089], 
    RectangleBox[NCache[{Rational[35, 64], 0}, {0.546875, 0}], 
     NCache[{Rational[141, 256], 1}, {0.55078125, 1}]]}, 
   {RGBColor[0.18649811464312124`, 0.5385504475480818, 0.6930498305541548], 
    RectangleBox[NCache[{Rational[141, 256], 0}, {0.55078125, 0}], 
     NCache[{Rational[71, 128], 1}, {0.5546875, 1}]]}, 
   {RGBColor[0.18776736589723655`, 0.5432486620854812, 0.694309338168116], 
    RectangleBox[NCache[{Rational[71, 128], 0}, {0.5546875, 0}], 
     NCache[{Rational[143, 256], 1}, {0.55859375, 1}]]}, 
   {RGBColor[0.18932479330507127`, 0.547928071038709, 0.695511469160801], 
    RectangleBox[NCache[{Rational[143, 256], 0}, {0.55859375, 0}], 
     NCache[{Rational[9, 16], 1}, {0.5625, 1}]]}, 
   {RGBColor[0.1911741751841543, 0.5525881499890606, 0.6966587000096661], 
    RectangleBox[NCache[{Rational[9, 16], 0}, {0.5625, 0}], 
     NCache[{Rational[145, 256], 1}, {0.56640625, 1}]]}, 
   {RGBColor[0.19331755177896356`, 0.557228409126328, 0.6977535434524811], 
    RectangleBox[NCache[{Rational[145, 256], 0}, {0.56640625, 0}], 
     NCache[{Rational[73, 128], 1}, {0.5703125, 1}]]}, 
   {RGBColor[0.19575524800630212`, 0.5618483932966262, 0.6987985452495742], 
    RectangleBox[NCache[{Rational[73, 128], 0}, {0.5703125, 0}], 
     NCache[{Rational[147, 256], 1}, {0.57421875, 1}]]}, 
   {RGBColor[0.19848593379962776`, 0.5664476819873158, 0.6997962809907544], 
    RectangleBox[NCache[{Rational[147, 256], 0}, {0.57421875, 0}], 
     NCache[{Rational[37, 64], 1}, {0.578125, 1}]]}, 
   {RGBColor[0.20150671811685578`, 0.5710258892520063, 0.7007493529521374], 
    RectangleBox[NCache[{Rational[37, 64], 0}, {0.578125, 0}], 
     NCache[{Rational[149, 256], 1}, {0.58203125, 1}]]}, 
   {RGBColor[0.20481327122503423`, 0.5755826635786365, 0.701660387007637], 
    RectangleBox[NCache[{Rational[149, 256], 0}, {0.58203125, 0}], 
     NCache[{Rational[75, 128], 1}, {0.5859375, 1}]]}, 
   {RGBColor[0.2083999689052431, 0.5801176877037089, 0.7025320295994351], 
    RectangleBox[NCache[{Rational[75, 128], 0}, {0.5859375, 0}], 
     NCache[{Rational[151, 256], 1}, {0.58984375, 1}]]}, 
   {RGBColor[0.21226005176967538`, 0.5846306783757533, 0.70336694477127], 
    RectangleBox[NCache[{Rational[151, 256], 0}, {0.58984375, 0}], 
     NCache[{Rational[19, 32], 1}, {0.59375, 1}]]}, 
   {RGBColor[0.21638579292524956`, 0.589121386071112, 0.704167811267961], 
    RectangleBox[NCache[{Rational[19, 32], 0}, {0.59375, 0}], 
     NCache[{Rational[153, 256], 1}, {0.59765625, 1}]]}, 
   {RGBColor[0.22076866768221792`, 0.5935895946651422, 0.7049373197041275], 
    RectangleBox[NCache[{Rational[153, 256], 0}, {0.59765625, 0}], 
     NCache[{Rational[77, 128], 1}, {0.6015625, 1}]]}, 
   {RGBColor[0.2253995197887398, 0.5980351210618999, 0.705678169804647], 
    RectangleBox[NCache[{Rational[77, 128], 0}, {0.6015625, 0}], 
     NCache[{Rational[155, 256], 1}, {0.60546875, 1}]]}, 
   {RGBColor[0.23026871965677842`, 0.6024578147853507, 0.7063930677189889], 
    RectangleBox[NCache[{Rational[155, 256], 0}, {0.60546875, 0}], 
     NCache[{Rational[39, 64], 1}, {0.609375, 1}]]}, 
   {RGBColor[0.23536631111821193`, 0.6068575575351022, 0.7070847234111555], 
    RectangleBox[NCache[{Rational[39, 64], 0}, {0.609375, 0}], 
     NCache[{Rational[157, 256], 1}, {0.61328125, 1}]]}, 
   {RGBColor[0.24068214431630547`, 0.6112342627096107, 0.7077558481265889], 
    RectangleBox[NCache[{Rational[157, 256], 0}, {0.61328125, 0}], 
     NCache[{Rational[79, 128], 1}, {0.6171875, 1}]]}, 
   {RGBColor[0.24620599332215354`, 0.6155878748997428, 0.7084091519370431], 
    RectangleBox[NCache[{Rational[79, 128], 0}, {0.6171875, 0}], 
     NCache[{Rational[159, 256], 1}, {0.62109375, 1}]]}, 
   {RGBColor[0.25192765791930966`, 0.6199183693555174, 0.7090473413640678], 
    RectangleBox[NCache[{Rational[159, 256], 0}, {0.62109375, 0}], 
     NCache[{Rational[5, 8], 1}, {0.625, 1}]]}, 
   {RGBColor[0.257837049697055, 0.6242257514287625, 0.7096731170814442], 
    RectangleBox[NCache[{Rational[5, 8], 0}, {0.625, 0}], 
     NCache[{Rational[161, 256], 1}, {0.62890625, 1}]]}, 
   {RGBColor[0.2639242631268481, 0.6285100559943397, 0.7102891716965952], 
    RectangleBox[NCache[{Rational[161, 256], 0}, {0.62890625, 0}], 
     NCache[{Rational[81, 128], 1}, {0.6328125, 1}]]}, 
   {RGBColor[0.27017963267553746`, 0.6327713468525267, 0.7108981876107245], 
    RectangleBox[NCache[{Rational[81, 128], 0}, {0.6328125, 0}], 
     NCache[{Rational[163, 256], 1}, {0.63671875, 1}]]}, 
   {RGBColor[0.27659377725113626`, 0.6370097161149972, 0.7115028349571703], 
    RectangleBox[NCache[{Rational[163, 256], 0}, {0.63671875, 0}], 
     NCache[{Rational[41, 64], 1}, {0.640625, 1}]]}, 
   {RGBColor[0.28315763340328515`, 0.6412252835768132, 0.7121057696172253], 
    RectangleBox[NCache[{Rational[41, 64], 0}, {0.640625, 0}], 
     NCache[{Rational[165, 256], 1}, {0.64453125, 1}]]}, 
   {RGBColor[0.289862478736731, 0.6454181960766808, 0.712709631312459], 
    RectangleBox[NCache[{Rational[165, 256], 0}, {0.64453125, 0}], 
     NCache[{Rational[83, 128], 1}, {0.6484375, 1}]]}, 
   {RGBColor[0.29669994696347657`, 0.6495886268476546, 0.7133170417723873], 
    RectangleBox[NCache[{Rational[83, 128], 0}, {0.6484375, 0}], 
     NCache[{Rational[167, 256], 1}, {0.65234375, 1}]]}, 
   {RGBColor[0.3036620359394461, 0.6537367748603594, 0.713930602976141], 
    RectangleBox[NCache[{Rational[167, 256], 0}, {0.65234375, 0}], 
     NCache[{Rational[21, 32], 1}, {0.65625, 1}]]}, 
   {RGBColor[0.3107411099209959, 0.6578628641606846, 0.7145528954666653], 
    RectangleBox[NCache[{Rational[21, 32], 0}, {0.65625, 0}], 
     NCache[{Rational[169, 256], 1}, {0.66015625, 1}]]}, 
   {RGBColor[0.31792989714950604`, 0.6619671432038239, 0.715186476735821], 
    RectangleBox[NCache[{Rational[169, 256], 0}, {0.66015625, 0}], 
     NCache[{Rational[85, 128], 1}, {0.6640625, 1}]]}, 
   {RGBColor[0.3252214837391488, 0.6660498841863941, 0.7158338796786571], 
    RectangleBox[NCache[{Rational[85, 128], 0}, {0.6640625, 0}], 
     NCache[{Rational[171, 256], 1}, {0.66796875, 1}]]}, 
   {RGBColor[0.33260930471100403`, 0.6701113823782879, 0.7164976111150304], 
    RectangleBox[NCache[{Rational[171, 256], 0}, {0.66796875, 0}], 
     NCache[{Rational[43, 64], 1}, {0.671875, 1}]]}, 
   {RGBColor[0.3400871328915299, 0.6741519554558029, 0.7171801503766768], 
    RectangleBox[NCache[{Rational[43, 64], 0}, {0.671875, 0}], 
     NCache[{Rational[173, 256], 1}, {0.67578125, 1}]]}, 
   {RGBColor[0.34764906627800735`, 0.6781719428374764, 0.7178839479577673], 
    RectangleBox[NCache[{Rational[173, 256], 0}, {0.67578125, 0}], 
     NCache[{Rational[87, 128], 1}, {0.6796875, 1}]]}, 
   {RGBColor[0.3552895143696574, 0.6821717050239697, 0.7186114242269575], 
    RectangleBox[NCache[{Rational[87, 128], 0}, {0.6796875, 0}], 
     NCache[{Rational[175, 256], 1}, {0.68359375, 1}]]}, 
   {RGBColor[0.3630031838714262, 0.6861516229432385, 0.7193649681988992], 
    RectangleBox[NCache[{Rational[175, 256], 0}, {0.68359375, 0}], 
     NCache[{Rational[11, 16], 1}, {0.6875, 1}]]}, 
   {RGBColor[0.3707850640978787, 0.690112097302132, 0.7201469363631814], 
    RectangleBox[NCache[{Rational[11, 16], 0}, {0.6875, 0}], 
     NCache[{Rational[177, 256], 1}, {0.69140625, 1}]]}, 
   {RGBColor[0.37863041233641304`, 0.6940535479454624, 0.720959651568659], 
    RectangleBox[NCache[{Rational[177, 256], 0}, {0.69140625, 0}], 
     NCache[{Rational[89, 128], 1}, {0.6953125, 1}]]}, 
   {RGBColor[0.3865347393713869, 0.6979764132235171, 0.7218054019611523], 
    RectangleBox[NCache[{Rational[89, 128], 0}, {0.6953125, 0}], 
     NCache[{Rational[179, 256], 1}, {0.69921875, 1}]]}, 
   {RGBColor[0.3944937953226482, 0.7018811493688668, 0.7226864399725115], 
    RectangleBox[NCache[{Rational[179, 256], 0}, {0.69921875, 0}], 
     NCache[{Rational[45, 64], 1}, {0.703125, 1}]]}, 
   {RGBColor[0.4025035559120705, 0.7057682298832775, 0.7236049813590882], 
    RectangleBox[NCache[{Rational[45, 64], 0}, {0.703125, 0}], 
     NCache[{Rational[181, 256], 1}, {0.70703125, 1}]]}, 
   {RGBColor[0.4105602092392488, 0.7096381449354205, 0.724563204287681], 
    RectangleBox[NCache[{Rational[181, 256], 0}, {0.70703125, 0}], 
     NCache[{Rational[91, 128], 1}, {0.7109375, 1}]]}, 
   {RGBColor[0.4186601431211373, 0.7134914007700188, 0.7255632484670876], 
    RectangleBox[NCache[{Rational[91, 128], 0}, {0.7109375, 0}], 
     NCache[{Rational[183, 256], 1}, {0.71484375, 1}]]}, 
   {RGBColor[0.42679993302938013`, 0.7173285191289862, 0.7266072143234348], 
    RectangleBox[NCache[{Rational[183, 256], 0}, {0.71484375, 0}], 
     NCache[{Rational[23, 32], 1}, {0.71875, 1}]]}, 
   {RGBColor[0.43497633064238456`, 0.7211500366850623, 0.7276971622175273], 
    RectangleBox[NCache[{Rational[23, 32], 0}, {0.71875, 0}], 
     NCache[{Rational[185, 256], 1}, {0.72265625, 1}]]}, 
   {RGBColor[0.44318625301637105`, 0.7249565044883586, 0.7288351117025098], 
    RectangleBox[NCache[{Rational[185, 256], 0}, {0.72265625, 0}], 
     NCache[{Rational[93, 128], 1}, {0.7265625, 1}]]}, 
   {RGBColor[0.4514267723695294, 0.7287484874261928, 0.7300230408202029], 
    RectangleBox[NCache[{Rational[93, 128], 0}, {0.7265625, 0}], 
     NCache[{Rational[187, 256], 1}, {0.73046875, 1}]]}, 
   {RGBColor[0.45969510646605266`, 0.7325265636965248, 0.7312628854345392], 
    RectangleBox[NCache[{Rational[187, 256], 0}, {0.73046875, 0}], 
     NCache[{Rational[47, 64], 1}, {0.734375, 1}]]}, 
   {RGBColor[0.46798860958136973`, 0.7362913242952503, 0.7325565386005812], 
    RectangleBox[NCache[{Rational[47, 64], 0}, {0.734375, 0}], 
     NCache[{Rational[189, 256], 1}, {0.73828125, 1}]]}, 
   {RGBColor[0.47630476402599237`, 0.7400433725175658, 0.7339058499676717], 
    RectangleBox[NCache[{Rational[189, 256], 0}, {0.73828125, 0}], 
     NCache[{Rational[95, 128], 1}, {0.7421875, 1}]]}, 
   {RGBColor[0.48464117220282227`, 0.7437833234735857, 0.7353126252153197], 
    RectangleBox[NCache[{Rational[95, 128], 0}, {0.7421875, 0}], 
     NCache[{Rational[191, 256], 1}, {0.74609375, 1}]]}, 
   {RGBColor[0.4929955491712907, 0.7475118036183321, 0.7367786255204797], 
    RectangleBox[NCache[{Rational[191, 256], 0}, {0.74609375, 0}], 
     NCache[{Rational[3, 4], 1}, {0.75, 1}]]}, 
   {RGBColor[0.5013657156908191, 0.7512294502961986, 0.7383055670549306], 
    RectangleBox[NCache[{Rational[3, 4], 0}, {0.75, 0}], 
     NCache[{Rational[193, 256], 1}, {0.75390625, 1}]]}, 
   {RGBColor[0.509749591716062, 0.7549369112999448, 0.7398951205115001], 
    RectangleBox[NCache[{Rational[193, 256], 0}, {0.75390625, 0}], 
     NCache[{Rational[97, 128], 1}, {0.7578125, 1}]]}, 
   {RGBColor[0.5181451903164548, 0.7586348444442884, 0.7415489106579237], 
    RectangleBox[NCache[{Rational[97, 128], 0}, {0.7578125, 0}], 
     NCache[{Rational[195, 256], 1}, {0.76171875, 1}]]}, 
   {RGBColor[0.5265506119935297, 0.7623239171540723, 0.7432685159171376], 
    RectangleBox[NCache[{Rational[195, 256], 0}, {0.76171875, 0}], 
     NCache[{Rational[49, 64], 1}, {0.765625, 1}]]}, 
   {RGBColor[0.5349640393700489, 0.7660048060670378, 0.7450554679728446], 
    RectangleBox[NCache[{Rational[49, 64], 0}, {0.765625, 0}], 
     NCache[{Rational[197, 256], 1}, {0.76953125, 1}]]}, 
   {RGBColor[0.5433837322261972, 0.7696781966511774, 0.7469112513991732], 
    RectangleBox[NCache[{Rational[197, 256], 0}, {0.76953125, 0}], 
     NCache[{Rational[99, 128], 1}, {0.7734375, 1}]]}, 
   {RGBColor[0.5518080228591733, 0.7733447828366482, 0.748837303313279], 
    RectangleBox[NCache[{Rational[99, 128], 0}, {0.7734375, 0}], 
     NCache[{Rational[199, 256], 1}, {0.77734375, 1}]]}, 
   {RGBColor[0.5602353117437582, 0.777005266662208, 0.7508350130496859], 
    RectangleBox[NCache[{Rational[199, 256], 0}, {0.77734375, 0}], 
     NCache[{Rational[25, 32], 1}, {0.78125, 1}]]}, 
   {RGBColor[0.5686640634725691, 0.78066035793617, 0.7529057218551758], 
    RectangleBox[NCache[{Rational[25, 32], 0}, {0.78125, 0}], 
     NCache[{Rational[201, 256], 1}, {0.78515625, 1}]]}, 
   {RGBColor[0.5770928029560973, 0.7843107739118282, 0.7550507226029626], 
    RectangleBox[NCache[{Rational[201, 256], 0}, {0.78515625, 0}], 
     NCache[{Rational[101, 128], 1}, {0.7890625, 1}]]}, 
   {RGBColor[0.58552011186363, 0.7879572389773675, 0.7572712595248562], 
    RectangleBox[NCache[{Rational[101, 128], 0}, {0.7890625, 0}], 
     NCache[{Rational[203, 256], 1}, {0.79296875, 1}]]}, 
   {RGBColor[0.5939446252874978, 0.791600484360249, 0.7595685279600347], 
    RectangleBox[NCache[{Rational[203, 256], 0}, {0.79296875, 0}], 
     NCache[{Rational[51, 64], 1}, {0.796875, 1}]]}, 
   {RGBColor[0.602365028614056, 0.7952412478461105, 0.7619436741189778], 
    RectangleBox[NCache[{Rational[51, 64], 0}, {0.796875, 0}], 
     NCache[{Rational[205, 256], 1}, {0.80078125, 1}]]}, 
   {RGBColor[0.6107800545859362, 0.7988802735122352, 0.7643977948609857], 
    RectangleBox[NCache[{Rational[205, 256], 0}, {0.80078125, 0}], 
     NCache[{Rational[103, 128], 1}, {0.8046875, 1}]]}, 
   {RGBColor[0.6191884805410327, 0.8025183114756876, 0.7669319374836132], 
    RectangleBox[NCache[{Rational[103, 128], 0}, {0.8046875, 0}], 
     NCache[{Rational[207, 256], 1}, {0.80859375, 1}]]}, 
   {RGBColor[0.6275891258146497, 0.806156117656261, 0.7695470995221901], 
    RectangleBox[NCache[{Rational[207, 256], 0}, {0.80859375, 0}], 
     NCache[{Rational[13, 16], 1}, {0.8125, 1}]]}, 
   {RGBColor[0.635980849292003, 0.8097944535544251, 0.7722442285574346], 
    RectangleBox[NCache[{Rational[13, 16], 0}, {0.8125, 0}], 
     NCache[{Rational[209, 256], 1}, {0.81640625, 1}]]}, 
   {RGBColor[0.644362547099074, 0.8134340860445408, 0.7750242220289927], 
    RectangleBox[NCache[{Rational[209, 256], 0}, {0.81640625, 0}], 
     NCache[{Rational[105, 128], 1}, {0.8203125, 1}]]}, 
   {RGBColor[0.6527331504204906, 0.8170757871836768, 0.7778879270525004], 
    RectangleBox[NCache[{Rational[105, 128], 0}, {0.8203125, 0}], 
     NCache[{Rational[211, 256], 1}, {0.82421875, 1}]]}, 
   {RGBColor[0.6610916234336827, 0.8207203340364551, 0.7808361402375323], 
    RectangleBox[NCache[{Rational[211, 256], 0}, {0.82421875, 0}], 
     NCache[{Rational[53, 64], 1}, {0.828125, 1}]]}, 
   {RGBColor[0.6694369613491088, 0.8243685085164592, 0.7838696075035061], 
    RectangleBox[NCache[{Rational[53, 64], 0}, {0.828125, 0}], 
     NCache[{Rational[213, 256], 1}, {0.83203125, 1}]]}, 
   {RGBColor[0.6777681885467846, 0.8280210972448633, 0.7869890238903011], 
    RectangleBox[NCache[{Rational[213, 256], 0}, {0.83203125, 0}], 
     NCache[{Rational[107, 128], 1}, {0.8359375, 1}]]}, 
   {RGBColor[0.6860843567996497, 0.8316788914270898, 0.7901950333599589], 
    RectangleBox[NCache[{Rational[107, 128], 0}, {0.8359375, 0}], 
     NCache[{Rational[215, 256], 1}, {0.83984375, 1}]]}, 
   {RGBColor[0.6943845435746523, 0.8353426867484646, 0.7934882285854268], 
    RectangleBox[NCache[{Rational[215, 256], 0}, {0.83984375, 0}], 
     NCache[{Rational[27, 32], 1}, {0.84375, 1}]]}, 
   {RGBColor[0.7026678504024696, 0.8390132832900636, 0.7968691507217935], 
    RectangleBox[NCache[{Rational[27, 32], 0}, {0.84375, 0}], 
     NCache[{Rational[217, 256], 1}, {0.84765625, 1}]]}, 
   {RGBColor[0.7109334013069742, 0.8426914854661544, 0.800338289154905], 
    RectangleBox[NCache[{Rational[217, 256], 0}, {0.84765625, 0}], 
     NCache[{Rational[109, 128], 1}, {0.8515625, 1}]]}, 
   {RGBColor[0.719180341285321, 0.8463781019849568, 0.8038960812215816], 
    RectangleBox[NCache[{Rational[109, 128], 0}, {0.8515625, 0}], 
     NCache[{Rational[219, 256], 1}, {0.85546875, 1}]]}, 
   {RGBColor[0.7274078348294765, 0.8500739458347496, 0.8075429118948743], 
    RectangleBox[NCache[{Rational[219, 256], 0}, {0.85546875, 0}], 
     NCache[{Rational[55, 64], 1}, {0.859375, 1}]]}, 
   {RGBColor[0.7356150644795487, 0.8537798342977824, 0.8112791134268895], 
    RectangleBox[NCache[{Rational[55, 64], 0}, {0.859375, 0}], 
     NCache[{Rational[221, 256], 1}, {0.86328125, 1}]]}, 
   {RGBColor[0.74380122939876, 0.8574965889949284, 0.8151049649406265], 
    RectangleBox[NCache[{Rational[221, 256], 0}, {0.86328125, 0}], 
     NCache[{Rational[111, 128], 1}, {0.8671875, 1}]]}, 
   {RGBColor[0.7519655439591808, 0.8612250359645818, 0.8190206919609704], 
    RectangleBox[NCache[{Rational[111, 128], 0}, {0.8671875, 0}], 
     NCache[{Rational[223, 256], 1}, {0.87109375, 1}]]}, 
   {RGBColor[0.7601072363262202, 0.8649660057800462, 0.82302646587347], 
    RectangleBox[NCache[{Rational[223, 256], 0}, {0.87109375, 0}], 
     NCache[{Rational[7, 8], 1}, {0.875, 1}]]}, 
   {RGBColor[0.7682255470286633, 0.8687203337104905, 0.827122403297637], 
    RectangleBox[NCache[{Rational[7, 8], 0}, {0.875, 0}], 
     NCache[{Rational[225, 256], 1}, {0.87890625, 1}]]}, 
   {RGBColor[0.7763197274991747, 0.8724888599316285, 0.8313085653592764], 
    RectangleBox[NCache[{Rational[225, 256], 0}, {0.87890625, 0}], 
     NCache[{Rational[113, 128], 1}, {0.8828125, 1}]]}, 
   {RGBColor[0.7843890385680716, 0.876272429793561, 0.8355849568435822], 
    RectangleBox[NCache[{Rational[113, 128], 0}, {0.8828125, 0}], 
     NCache[{Rational[227, 256], 1}, {0.88671875, 1}]]}, 
   {RGBColor[0.7924327488902234, 0.8800718941548572, 0.8399515252073757], 
    RectangleBox[NCache[{Rational[227, 256], 0}, {0.88671875, 0}], 
     NCache[{Rational[57, 64], 1}, {0.890625, 1}]]}, 
   {RGBColor[0.8004501332813448, 0.8838881097939533, 0.8444081594246459], 
    RectangleBox[NCache[{Rational[57, 64], 0}, {0.890625, 0}], 
     NCache[{Rational[229, 256], 1}, {0.89453125, 1}]]}, 
   {RGBColor[0.8084404709352808, 0.8877219399114877, 0.8489546886343433], 
    RectangleBox[NCache[{Rational[229, 256], 0}, {0.89453125, 0}], 
     NCache[{Rational[115, 128], 1}, {0.8984375, 1}]]}, 
   {RGBColor[0.8164030434877952, 0.8915742547404176, 0.8535908805527883], 
    RectangleBox[NCache[{Rational[115, 128], 0}, {0.8984375, 0}], 
     NCache[{Rational[231, 256], 1}, {0.90234375, 1}]]}, 
   {RGBColor[0.8243371328846631, 0.8954459322848809, 0.8583164396047162], 
    RectangleBox[NCache[{Rational[231, 256], 0}, {0.90234375, 0}], 
     NCache[{Rational[29, 32], 1}, {0.90625, 1}]]}, 
   {RGBColor[0.8322420190017009, 0.8993378592140667, 0.8631310047162956], 
    RectangleBox[NCache[{Rational[29, 32], 0}, {0.90625, 0}], 
     NCache[{Rational[233, 256], 1}, {0.91015625, 1}]]}, 
   {RGBColor[0.8401169769510389, 0.9032509319442931, 0.8680341466996494], 
    RectangleBox[NCache[{Rational[233, 256], 0}, {0.91015625, 0}], 
     NCache[{Rational[117, 128], 1}, {0.9140625, 1}]]}, 
   {RGBColor[0.847961273990338, 0.9071860579516021, 0.8730253651403731], 
    RectangleBox[NCache[{Rational[117, 128], 0}, {0.9140625, 0}], 
     NCache[{Rational[235, 256], 1}, {0.91796875, 1}]]}, 
   {RGBColor[0.8557741659279987, 0.9111441573693156, 0.878104084675722], 
    RectangleBox[NCache[{Rational[235, 256], 0}, {0.91796875, 0}], 
     NCache[{Rational[59, 64], 1}, {0.921875, 1}]]}, 
   {RGBColor[0.8635548928854364, 0.9151261649413482, 0.8832696505192876], 
    RectangleBox[NCache[{Rational[59, 64], 0}, {0.921875, 0}], 
     NCache[{Rational[237, 256], 1}, {0.92578125, 1}]]}, 
   {RGBColor[0.8713026742336115, 0.9191330324244463, 0.8885213230448306], 
    RectangleBox[NCache[{Rational[237, 256], 0}, {0.92578125, 0}], 
     NCache[{Rational[119, 128], 1}, {0.9296875, 1}]]}, 
   {RGBColor[0.8790167024598484, 0.9231657315634864, 0.8938582711826032], 
    RectangleBox[NCache[{Rational[119, 128], 0}, {0.9296875, 0}], 
     NCache[{Rational[239, 256], 1}, {0.93359375, 1}]]}, 
   {RGBColor[0.8866961356345833, 0.9272252578076632, 0.8992795642985757], 
    RectangleBox[NCache[{Rational[239, 256], 0}, {0.93359375, 0}], 
     NCache[{Rational[15, 16], 1}, {0.9375, 1}]]}, 
   {RGBColor[0.8943400880232072, 0.9313126349980404, 0.9047841621090953], 
    RectangleBox[NCache[{Rational[15, 16], 0}, {0.9375, 0}], 
     NCache[{Rational[241, 256], 1}, {0.94140625, 1}]]}, 
   {RGBColor[0.9019476182054232, 0.9354289213486436, 0.9103709020124091], 
    RectangleBox[NCache[{Rational[241, 256], 0}, {0.94140625, 0}], 
     NCache[{Rational[121, 128], 1}, {0.9453125, 1}]]}, 
   {RGBColor[0.909517713790101, 0.9395752171805147, 0.9160384829647122], 
    RectangleBox[NCache[{Rational[121, 128], 0}, {0.9453125, 0}], 
     NCache[{Rational[243, 256], 1}, {0.94921875, 1}]]}, 
   {RGBColor[0.9170492713909637, 0.943752675078838, 0.921785444642328], 
    RectangleBox[NCache[{Rational[243, 256], 0}, {0.94921875, 0}], 
     NCache[{Rational[61, 64], 1}, {0.953125, 1}]]}, 
   {RGBColor[0.924541069858783, 0.9479625134759943, 0.9276101400273046], 
    RectangleBox[NCache[{Rational[61, 64], 0}, {0.953125, 0}], 
     NCache[{Rational[245, 256], 1}, {0.95703125, 1}]]}, 
   {RGBColor[0.931991733668776, 0.9522060352067258, 0.9335106985760458], 
    RectangleBox[NCache[{Rational[245, 256], 0}, {0.95703125, 0}], 
     NCache[{Rational[123, 128], 1}, {0.9609375, 1}]]}, 
   {RGBColor[0.939399681495191, 0.956484653503246, 0.9394849754874594], 
    RectangleBox[NCache[{Rational[123, 128], 0}, {0.9609375, 0}], 
     NCache[{Rational[247, 256], 1}, {0.96484375, 1}]]}, 
   {RGBColor[0.946763051681787, 0.9607999295337398, 0.9455304796982017], 
    RectangleBox[NCache[{Rational[247, 256], 0}, {0.96484375, 0}], 
     NCache[{Rational[31, 32], 1}, {0.96875, 1}]]}, 
   {RGBColor[0.9540795900719367, 0.965153628651425, 0.9516442678726326], 
    RectangleBox[NCache[{Rational[31, 32], 0}, {0.96875, 0}], 
     NCache[{Rational[249, 256], 1}, {0.97265625, 1}]]}, 
   {RGBColor[0.9613464731286411, 0.9695478086505259, 0.9578227810347458], 
    RectangleBox[NCache[{Rational[249, 256], 0}, {0.97265625, 0}], 
     NCache[{Rational[125, 128], 1}, {0.9765625, 1}]]}, 
   {RGBColor[0.9685600119563237, 0.9739849666417407, 0.9640615776410902], 
    RectangleBox[NCache[{Rational[125, 128], 0}, {0.9765625, 0}], 
     NCache[{Rational[251, 256], 1}, {0.98046875, 1}]]}, 
   {RGBColor[0.9757151165738337, 0.9784683033532354, 0.9703548622074888], 
    RectangleBox[NCache[{Rational[251, 256], 0}, {0.98046875, 0}], 
     NCache[{Rational[63, 64], 1}, {0.984375, 1}]]}, 
   {RGBColor[0.9828042138895224, 0.9830022536787714, 0.9766945572741356], 
    RectangleBox[NCache[{Rational[63, 64], 0}, {0.984375, 0}], 
     NCache[{Rational[253, 256], 1}, {0.98828125, 1}]]}, 
   {RGBColor[0.9898146668063851, 0.987593744017243, 0.9830681481496889], 
    RectangleBox[NCache[{Rational[253, 256], 0}, {0.98828125, 0}], 
     NCache[{Rational[127, 128], 1}, {0.9921875, 1}]]}, 
   {RGBColor[0.9967205061712606, 0.9922561922871783, 0.9894519748281297], 
    RectangleBox[NCache[{Rational[127, 128], 0}, {0.9921875, 0}], 
     NCache[{Rational[255, 256], 1}, {0.99609375, 1}]]}, 
   {RGBColor[1, 0.9970437826621094, 0.9957555575207212], 
    RectangleBox[NCache[{Rational[255, 256], 0}, {0.99609375, 0}], {1, 1}]}},
  AspectRatio->0.2]], "Output",
 CellChangeTimes->{{3.64806302837794*^9, 3.648063113631567*^9}, 
   3.648063148452978*^9, {3.6480631876559896`*^9, 3.648063198511754*^9}, 
   3.648063339100443*^9, 3.648064914228621*^9, 3.648069241876398*^9, {
   3.648216343077951*^9, 3.6482163476077633`*^9}, 3.649608465502303*^9, {
   3.655135301672864*^9, 3.6551353204252777`*^9}, {3.655135388259864*^9, 
   3.655135394077218*^9}, 3.655135500022517*^9, 3.655136542686138*^9, 
   3.658032109609017*^9, 3.6622218909695387`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Export", "[", 
    RowBox[{"#1", ",", "#2", ",", "\"\<CSV\>\""}], "]"}], "&"}], "@@@", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"idlcolorbarnames", ",", "idlcolorbars"}], "}"}], 
    "\[Transpose]"}], ")"}]}]], "Input",
 CellChangeTimes->{{3.6551365483263903`*^9, 3.655136599806135*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/000_B-W_LINEAR.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/001_BLUE-WHITE.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/002_GRN-RED-BLU-WHT.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/003_RED_TEMPERATURE.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/004_BLUE-GREEN-RED-YELLOW.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/005_STD_GAMMA-II.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/006_PRISM.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/007_RED-PURPLE.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/008_GREEN-WHITE_LINEAR.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/009_GRN-WHT_EXPONENTIAL.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/010_GREEN-PINK.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/011_BLUE-RED.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/012_16_LEVEL.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/013_RAINBOW.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/014_STEPS.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/015_STERN_SPECIAL.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/016_Haze.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/017_Blue_-_Pastel_-_Red.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/018_Pastels.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/019_Hue_Sat_Lightness_1.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/020_Hue_Sat_Lightness_2.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/021_Hue_Sat_Value_1.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/022_Hue_Sat_Value_2.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/023_Purple-Red_plus_Stripes.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/024_Beach.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/025_Mac_Style.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/026_Eos_A.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/027_Eos_B.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/028_Hardcandy.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/029_Nature.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/030_Ocean.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/031_Peppermint.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/032_Plasma.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/033_Blue-Red.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/034_Rainbow.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/035_Blue_Waves.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/036_Volcano.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/037_Waves.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/038_Rainbow18.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/039_Rainbow_plus_white.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/040_Rainbow_plus_black.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/041_CB-Accent.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/042_CB-Dark2.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/043_CB-Paired.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/044_CB-Pastel1.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/045_CB-Pastel2.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/046_CB-Set1.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/047_CB-Set2.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/048_CB-Set3.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/049_CB-Blues.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/050_CB-BuGn.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/051_CB-BuPu.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/052_CB-GnBu.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/053_CB-Greens.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/054_CB-Greys.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/055_CB-Oranges.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/056_CB-OrRd.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/057_CB-PuBu.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/058_CB-PuBuGn.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/059_CB-PuRd.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/060_CB-Purples.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/061_CB-RdPu.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/062_CB-Reds.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/063_CB-YlGn.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/064_CB-YlGnBu.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/065_CB-YlOrBr.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/066_CB-BrBG.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/067_CB-PiYG.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/068_CB-PRGn.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/069_CB-PuOr.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/070_CB-RdBu.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/071_CB-RdGy.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/072_CB-RdYlBu.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/073_CB-RdYlGn.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/074_CB-Spectral.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/075_LAB_rainbow.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/076_MPL_rainbow.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/077_MPL_option_A.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/078_MPL_option_B.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/079_MPL_option_C.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/080_MPL_option_D.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/081_Singlehue_Red.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/082_Singlehue_RedOrange.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/083_Singlehue_Orange.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/084_Singlehue_Gold.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/085_Singlehue_YellowGreen.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/086_Singlehue_Green.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/087_Singlehue_GreenBlue.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/088_Singlehue_Teal.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/089_Singlehue_Blue.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/090_Singlehue_DarkBlue.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/091_Singlehue_Purple.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/092_Singlehue_Indigo.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/093_Multihue_Red1.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/094_Multihue_Red2.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/095_Multihue_Red3.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/096_Multihue_Red4.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/097_Multihue_Red5.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/098_Multihue_Red6.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/099_Multihue_Green1.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/100_Multihue_Green2.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/101_Multihue_Green3.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/102_Multihue_Green4.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/103_Multihue_Green5.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/104_Multihue_Green6.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/105_Multihue_Blue1.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/106_Multihue_Blue2.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/107_Multihue_Blue3.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/108_Multihue_Blue4.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/109_Multihue_Blue5.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/110_Multihue_Blue6.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/111_Multihue_Purple1.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/112_Multihue_Purple2.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/113_Multihue_Purple3.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/114_Multihue_Purple4.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/115_Multihue_Purple5.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/116_Multihue_Purple6.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/117_cyclic1.dat\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_rgb_values/118_cyclic2.dat\"\>"}], "}"}]], "Output",
 CellChangeTimes->{{3.655136597397295*^9, 3.6551366012691317`*^9}, 
   3.662226885252623*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "FileBaseName"}]], "Input",
 CellChangeTimes->{{3.655135471947948*^9, 3.655135474880783*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox["\<\"\!\(\*RowBox[{\\\"FileBaseName\\\", \\\"[\\\", \
StyleBox[\\\"\\\\\\\"\\\\!\\\\(\\\\*StyleBox[\\\\\\\"file\\\\\\\",\\\\\\\"TI\\\
\\\\\"]\\\\)\\\\\\\"\\\", ShowStringCharacters->True], \\\"]\\\"}]\) gives \
the base name for a file without its extension.\"\>", "MSG"], 
  "\[NonBreakingSpace]", 
  ButtonBox[
   StyleBox["\[RightSkeleton]", "SR"],
   Active->True,
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FileBaseName"]}]], "Print", "PrintUsage",
 CellChangeTimes->{3.65513550083237*^9},
 CellTags->"Info-112a31dd-a011-4479-9715-5c3d52c0fdb7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FileBaseName", "[", 
  RowBox[{"idlcolorbarnames", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.6551354508262663`*^9, 3.65513546399277*^9}}],

Cell[BoxData["\<\"000_B-W_LINEAR\"\>"], "Output",
 CellChangeTimes->{{3.655135454022148*^9, 3.655135464391326*^9}, 
   3.655135501517086*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Now write the python code for viscm", "Section",
 CellChangeTimes->{{3.648063349167336*^9, 3.648063359505211*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "top", "=", 
   "\"\<from matplotlib.colors import LinearSegmentedColormap\nfrom numpy \
import nan, inf\n\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.6480633718592653`*^9, 3.648063376769589*^9}, 
   3.648063420926564*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "bottom", "=", 
   "\"\<\n\ntest_cm = LinearSegmentedColormap.from_list(__file__, cm_data)\n\n\
\nif __name__ == \\\"__main__\\\":\n    import matplotlib.pyplot as plt\n    \
import numpy as np\n\n    try:\n        from pycam02ucs.cm.viscm import viscm\
\n        viscm(test_cm)\n    except ImportError:\n        \
print(\\\"pycam02ucs not found, falling back on simple display\\\")\n        \
plt.imshow(np.linspace(0, 100, 256)[None, :], aspect='auto',\n                \
   cmap=test_cm)\n    plt.show()\n\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.6480633792080173`*^9, 3.648063423653368*^9}, {
  3.648063846803421*^9, 3.648063846990644*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"midstrings", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"\"\<cm_data = \>\"", "<>", 
      RowBox[{"StringReplace", "[", 
       RowBox[{
        RowBox[{"ToString", "[", "#", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<}, {\>\"", "\[Rule]", "\"\<],\\n[\>\""}], ",", 
          RowBox[{"\"\<{{\>\"", "\[Rule]", "\"\<[[\>\""}], ",", 
          RowBox[{"\"\<}}\>\"", "\[Rule]", "\"\<]]\>\""}]}], "}"}]}], "]"}]}],
      "&"}], "/@", "idlcolorbars"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.648063439231969*^9, 3.6480635731595697`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"pyscripts", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"top", "<>", "#", "<>", "bottom"}], "&"}], "/@", 
    "midstrings"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.648063578747971*^9, 3.648063605935761*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "pytestdir", "=", 
   "\"\</home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_\
test/\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.648063656174835*^9, 3.6480636742956877`*^9}, {
   3.648063713365862*^9, 3.648063714628457*^9}, 3.648216358453638*^9, {
   3.6551354421376753`*^9, 3.655135442670766*^9}, {3.655135568289864*^9, 
   3.655135571495036*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pyscriptname", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"pytestdir", "<>", "#", "<>", "\"\<.py\>\""}], "&"}], "/@", 
   RowBox[{"(", 
    RowBox[{"FileBaseName", "/@", "idlcolorbarnames"}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.648063608457438*^9, 3.6480636314275417`*^9}, {
  3.648063682119842*^9, 3.648063703852894*^9}, {3.655135427147224*^9, 
  3.655135428784752*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/000_B-W_LINEAR.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/001_BLUE-WHITE.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/002_GRN-RED-BLU-WHT.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/003_RED_TEMPERATURE.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/004_BLUE-GREEN-RED-YELLOW.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/005_STD_GAMMA-II.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/006_PRISM.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/007_RED-PURPLE.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/008_GREEN-WHITE_LINEAR.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/009_GRN-WHT_EXPONENTIAL.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/010_GREEN-PINK.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/011_BLUE-RED.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/012_16_LEVEL.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/013_RAINBOW.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/014_STEPS.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/015_STERN_SPECIAL.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/016_Haze.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/017_Blue_-_Pastel_-_Red.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/018_Pastels.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/019_Hue_Sat_Lightness_1.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/020_Hue_Sat_Lightness_2.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/021_Hue_Sat_Value_1.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/022_Hue_Sat_Value_2.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/023_Purple-Red_plus_Stripes.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/024_Beach.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/025_Mac_Style.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/026_Eos_A.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/027_Eos_B.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/028_Hardcandy.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/029_Nature.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/030_Ocean.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/031_Peppermint.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/032_Plasma.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/033_Blue-Red.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/034_Rainbow.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/035_Blue_Waves.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/036_Volcano.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/037_Waves.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/038_Rainbow18.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/039_Rainbow_plus_white.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/040_Rainbow_plus_black.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/041_CB-Accent.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/042_CB-Dark2.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/043_CB-Paired.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/044_CB-Pastel1.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/045_CB-Pastel2.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/046_CB-Set1.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/047_CB-Set2.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/048_CB-Set3.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/049_CB-Blues.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/050_CB-BuGn.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/051_CB-BuPu.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/052_CB-GnBu.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/053_CB-Greens.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/054_CB-Greys.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/055_CB-Oranges.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/056_CB-OrRd.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/057_CB-PuBu.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/058_CB-PuBuGn.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/059_CB-PuRd.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/060_CB-Purples.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/061_CB-RdPu.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/062_CB-Reds.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/063_CB-YlGn.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/064_CB-YlGnBu.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/065_CB-YlOrBr.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/066_CB-BrBG.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/067_CB-PiYG.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/068_CB-PRGn.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/069_CB-PuOr.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/070_CB-RdBu.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/071_CB-RdGy.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/072_CB-RdYlBu.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/073_CB-RdYlGn.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/074_CB-Spectral.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/075_LAB_rainbow.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/076_MPL_rainbow.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/077_MPL_option_A.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/078_MPL_option_B.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/079_MPL_option_C.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/080_MPL_option_D.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/081_Singlehue_Red.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/082_Singlehue_RedOrange.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/083_Singlehue_Orange.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/084_Singlehue_Gold.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/085_Singlehue_YellowGreen.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/086_Singlehue_Green.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/087_Singlehue_GreenBlue.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/088_Singlehue_Teal.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/089_Singlehue_Blue.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/090_Singlehue_DarkBlue.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/091_Singlehue_Purple.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/092_Singlehue_Indigo.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/093_Multihue_Red1.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/094_Multihue_Red2.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/095_Multihue_Red3.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/096_Multihue_Red4.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/097_Multihue_Red5.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/098_Multihue_Red6.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/099_Multihue_Green1.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/100_Multihue_Green2.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/101_Multihue_Green3.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/102_Multihue_Green4.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/103_Multihue_Green5.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/104_Multihue_Green6.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/105_Multihue_Blue1.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/106_Multihue_Blue2.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/107_Multihue_Blue3.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/108_Multihue_Blue4.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/109_Multihue_Blue5.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/110_Multihue_Blue6.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/111_Multihue_Purple1.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/112_Multihue_Purple2.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/113_Multihue_Purple3.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/114_Multihue_Purple4.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/115_Multihue_Purple5.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/116_Multihue_Purple6.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/117_cyclic1.py\"\>", 
   ",", "\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/\
IDL_py_test/118_cyclic2.py\"\>"}], "}"}]], "Output",
 CellChangeTimes->{{3.6480636119466953`*^9, 3.648063631829821*^9}, {
   3.6480637049317513`*^9, 3.6480637163123207`*^9}, 3.6480638552497263`*^9, 
   3.64806492230716*^9, 3.648069250658839*^9, {3.655135411836952*^9, 
   3.655135439592598*^9}, {3.655135509038719*^9, 3.6551355158316727`*^9}, 
   3.65513557275737*^9, 3.655136704426359*^9, 3.658032148746784*^9, 
   3.662221906880452*^9, 3.662226892665203*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"pyscriptname", "[", 
      RowBox[{"[", "ii", "]"}], "]"}], ",", 
     RowBox[{"pyscripts", "[", 
      RowBox[{"[", "ii", "]"}], "]"}], ",", "\"\<Text\>\""}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"ii", ",", "1", ",", 
     RowBox[{"Length", "[", "pyscripts", "]"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6480637202028103`*^9, 3.648063810837858*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Now run the python script to generate pngs for these colormaps\
\>", "Section",
 CellChangeTimes->{{3.648064025481926*^9, 3.648064039375063*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"idlpngdir", "=", 
  "\"\</home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_\
png/\>\""}]], "Input",
 CellChangeTimes->{{3.6480640580288258`*^9, 3.6480640614951973`*^9}, {
   3.648064100430931*^9, 3.64806410163061*^9}, {3.648066002194281*^9, 
   3.648066002758906*^9}, 3.6482163696565313`*^9, {3.655135587477385*^9, 
   3.655135590246307*^9}}],

Cell[BoxData["\<\"/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-\
Colorbars/IDL_py_png/\"\>"], "Output",
 CellChangeTimes->{
  3.648064102957438*^9, 3.648064926258675*^9, 3.648066003427677*^9, 
   3.6480692592871017`*^9, 3.648216372421011*^9, 3.6551355431900053`*^9, {
   3.655135588124723*^9, 3.655135590655924*^9}, 3.6551366541657476`*^9, 
   3.658032158402994*^9, 3.662221914223186*^9, 3.662226895972107*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"pypngcmds", "=", "\[IndentingNewLine]", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"\"\<python -m viscm show \>\"", "<>", 
      RowBox[{"pyscriptname", "[", 
       RowBox[{"[", "ii", "]"}], "]"}], "<>", "\"\< --save \>\"", "<>", 
      "idlpngdir", "<>", 
      RowBox[{"FileBaseName", "[", 
       RowBox[{"idlcolorbarnames", "[", 
        RowBox[{"[", "ii", "]"}], "]"}], "]"}], "<>", "\"\<.png\>\"", "<>", 
      "\"\< --quit\>\""}], ",", 
     RowBox[{"{", 
      RowBox[{"ii", ",", "1", ",", 
       RowBox[{"idlcolorbarnames", "//", "Length"}]}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.648064104899021*^9, 3.648064171643588*^9}, {
  3.6480642291397*^9, 3.64806426334074*^9}, {3.648064370517997*^9, 
  3.648064371072249*^9}, {3.64806464750462*^9, 3.6480646476954813`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "RunProcess"}]], "Input",
 CellChangeTimes->{{3.648064275931439*^9, 3.6480642805371513`*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox["\<\"\!\(\*RowBox[{\\\"RunProcess\\\", \\\"[\\\", \
StyleBox[\\\"\\\\\\\"\\\\!\\\\(\\\\*StyleBox[\\\\\\\"command\\\\\\\",\\\\\\\"\
TI\\\\\\\"]\\\\)\\\\\\\"\\\", ShowStringCharacters->True], \\\"]\\\"}]\) runs \
the specified external command, returning information on the \
outcome.\\n\!\(\*RowBox[{\\\"RunProcess\\\", \\\"[\\\", RowBox[{\\\"{\\\", \
RowBox[{StyleBox[\\\"\\\\\\\"\\\\!\\\\(\\\\*StyleBox[\\\\\\\"command\\\\\\\",\
\\\\\\\"TI\\\\\\\"]\\\\)\\\\\\\"\\\", ShowStringCharacters->True], \\\",\\\", \
SubscriptBox[StyleBox[\\\"arg\\\", \\\"TI\\\"], StyleBox[\\\"1\\\", \
\\\"TR\\\"]], \\\",\\\", SubscriptBox[StyleBox[\\\"arg\\\", \\\"TI\\\"], \
StyleBox[\\\"2\\\", \\\"TR\\\"]], \\\",\\\", StyleBox[\\\"\[Ellipsis]\\\", \\\
\"TR\\\"]}], \\\"}\\\"}], \\\"]\\\"}]\) runs the specified command, with \
command-line arguments \!\(\*SubscriptBox[StyleBox[\\\"arg\\\", \\\"TI\\\"], \
StyleBox[\\\"i\\\", \\\"TI\\\"]]\).\\n\!\(\*RowBox[{\\\"RunProcess\\\", \\\"[\
\\\", RowBox[{StyleBox[\\\"command\\\", \\\"TI\\\"], \\\",\\\", StyleBox[\\\"\
\\\\\\\"\\\\!\\\\(\\\\*StyleBox[\\\\\\\"prop\\\\\\\",\\\\\\\"TI\\\\\\\"]\\\\)\
\\\\\\\"\\\", ShowStringCharacters->True]}], \\\"]\\\"}]\) returns only the \
specified property.\\n\!\(\*RowBox[{\\\"RunProcess\\\", \\\"[\\\", \
RowBox[{StyleBox[\\\"command\\\", \\\"TI\\\"], \\\",\\\", StyleBox[\\\"prop\\\
\", \\\"TI\\\"], \\\",\\\", StyleBox[\\\"input\\\", \\\"TI\\\"]}], \
\\\"]\\\"}]\) feeds the specified initial input to the command.\"\>", "MSG"], 
  "\[NonBreakingSpace]", 
  ButtonBox[
   StyleBox["\[RightSkeleton]", "SR"],
   Active->True,
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RunProcess"]}]], "Print", "PrintUsage",
 CellChangeTimes->{3.66222689726579*^9},
 CellTags->"Info-20ebece6-b7c7-447d-b18c-3ebc1b2290ee"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pypngcmds", "[", 
  RowBox[{"[", "1", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.648064331480205*^9, 3.648064336428062*^9}}],

Cell[BoxData["\<\"python -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
000_B-W_LINEAR.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/000_\
B-W_LINEAR.png --quit\"\>"], "Output",
 CellChangeTimes->{3.648064336786614*^9, 3.6480643731150827`*^9, 
  3.648064650092746*^9, 3.648064929340295*^9, 3.648066007032193*^9, 
  3.64806926171944*^9, 3.655135548689335*^9, 3.6551355934607697`*^9, 
  3.655136656277864*^9, 3.658032160737797*^9, 3.662221917352273*^9, 
  3.662226897902945*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"bashproc", "=", 
  RowBox[{"StartProcess", "[", "\"\</bin/bash\>\"", "]"}]}]], "Input",
 CellChangeTimes->{{3.6480641884958076`*^9, 3.6480642259157953`*^9}, {
  3.648064266871916*^9, 3.6480643045516777`*^9}, {3.6480651496586313`*^9, 
  3.648065177272279*^9}, {3.64806580686567*^9, 3.648065809842325*^9}}],

Cell[BoxData[
 RowBox[{"ProcessObject", "[", "0", "]"}]], "Output",
 CellChangeTimes->{{3.648064210184697*^9, 3.6480642227241707`*^9}, {
   3.648064296064619*^9, 3.648064305556226*^9}, 3.648064375456925*^9, 
   3.6480649325134163`*^9, 3.648065152773514*^9, 3.6480658124208393`*^9, 
   3.648066011586935*^9, 3.6480692626179523`*^9, 3.655135550444927*^9, 
   3.655135598862233*^9, 3.655136656940948*^9, 3.6580321615011063`*^9, 
   3.662221918180135*^9, 3.662226898514406*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pypngcmds", "[", 
  RowBox[{"[", "1", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.648064635053461*^9, 3.648064638394985*^9}}],

Cell[BoxData["\<\"python -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
000_B-W_LINEAR.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/000_\
B-W_LINEAR.png --quit\"\>"], "Output",
 CellChangeTimes->{3.648064639572618*^9, 3.648064934325944*^9, 
  3.648065817397374*^9, 3.6480659455498753`*^9, 3.648066012795014*^9, 
  3.648069263470655*^9, 3.655135600224742*^9, 3.655136657682076*^9, 
  3.658032163944838*^9, 3.662221918917292*^9, 3.662226899160309*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringJoin", "[", 
  RowBox[{"Riffle", "[", 
   RowBox[{"pypngcmds", ",", "\"\<\\n\\n\>\""}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.648066120699483*^9, 3.648066127175836*^9}, {
  3.648066162515628*^9, 3.648066183432466*^9}}],

Cell[BoxData["\<\"python -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
000_B-W_LINEAR.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/000_\
B-W_LINEAR.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
001_BLUE-WHITE.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/001_\
BLUE-WHITE.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
002_GRN-RED-BLU-WHT.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/002_\
GRN-RED-BLU-WHT.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
003_RED_TEMPERATURE.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/003_\
RED_TEMPERATURE.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
004_BLUE-GREEN-RED-YELLOW.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/004_\
BLUE-GREEN-RED-YELLOW.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
005_STD_GAMMA-II.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/005_\
STD_GAMMA-II.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
006_PRISM.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/006_\
PRISM.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
007_RED-PURPLE.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/007_\
RED-PURPLE.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
008_GREEN-WHITE_LINEAR.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/008_\
GREEN-WHITE_LINEAR.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
009_GRN-WHT_EXPONENTIAL.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/009_\
GRN-WHT_EXPONENTIAL.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
010_GREEN-PINK.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/010_\
GREEN-PINK.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
011_BLUE-RED.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/011_\
BLUE-RED.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
012_16_LEVEL.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/012_\
16_LEVEL.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
013_RAINBOW.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/013_\
RAINBOW.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
014_STEPS.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/014_\
STEPS.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
015_STERN_SPECIAL.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/015_\
STERN_SPECIAL.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
016_Haze.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/016_\
Haze.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
017_Blue_-_Pastel_-_Red.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/017_\
Blue_-_Pastel_-_Red.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
018_Pastels.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/018_\
Pastels.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
019_Hue_Sat_Lightness_1.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/019_\
Hue_Sat_Lightness_1.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
020_Hue_Sat_Lightness_2.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/020_\
Hue_Sat_Lightness_2.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
021_Hue_Sat_Value_1.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/021_\
Hue_Sat_Value_1.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
022_Hue_Sat_Value_2.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/022_\
Hue_Sat_Value_2.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
023_Purple-Red_plus_Stripes.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/023_\
Purple-Red_plus_Stripes.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
024_Beach.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/024_\
Beach.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
025_Mac_Style.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/025_\
Mac_Style.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
026_Eos_A.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/026_\
Eos_A.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
027_Eos_B.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/027_\
Eos_B.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
028_Hardcandy.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/028_\
Hardcandy.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
029_Nature.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/029_\
Nature.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
030_Ocean.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/030_\
Ocean.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
031_Peppermint.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/031_\
Peppermint.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
032_Plasma.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/032_\
Plasma.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
033_Blue-Red.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/033_\
Blue-Red.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
034_Rainbow.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/034_\
Rainbow.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
035_Blue_Waves.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/035_\
Blue_Waves.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
036_Volcano.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/036_\
Volcano.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
037_Waves.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/037_\
Waves.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
038_Rainbow18.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/038_\
Rainbow18.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
039_Rainbow_plus_white.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/039_\
Rainbow_plus_white.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
040_Rainbow_plus_black.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/040_\
Rainbow_plus_black.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
041_CB-Accent.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/041_\
CB-Accent.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
042_CB-Dark2.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/042_\
CB-Dark2.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
043_CB-Paired.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/043_\
CB-Paired.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
044_CB-Pastel1.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/044_\
CB-Pastel1.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
045_CB-Pastel2.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/045_\
CB-Pastel2.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
046_CB-Set1.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/046_\
CB-Set1.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
047_CB-Set2.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/047_\
CB-Set2.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
048_CB-Set3.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/048_\
CB-Set3.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
049_CB-Blues.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/049_\
CB-Blues.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
050_CB-BuGn.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/050_\
CB-BuGn.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
051_CB-BuPu.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/051_\
CB-BuPu.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
052_CB-GnBu.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/052_\
CB-GnBu.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
053_CB-Greens.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/053_\
CB-Greens.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
054_CB-Greys.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/054_\
CB-Greys.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
055_CB-Oranges.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/055_\
CB-Oranges.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
056_CB-OrRd.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/056_\
CB-OrRd.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
057_CB-PuBu.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/057_\
CB-PuBu.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
058_CB-PuBuGn.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/058_\
CB-PuBuGn.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
059_CB-PuRd.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/059_\
CB-PuRd.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
060_CB-Purples.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/060_\
CB-Purples.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
061_CB-RdPu.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/061_\
CB-RdPu.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
062_CB-Reds.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/062_\
CB-Reds.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
063_CB-YlGn.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/063_\
CB-YlGn.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
064_CB-YlGnBu.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/064_\
CB-YlGnBu.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
065_CB-YlOrBr.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/065_\
CB-YlOrBr.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
066_CB-BrBG.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/066_\
CB-BrBG.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
067_CB-PiYG.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/067_\
CB-PiYG.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
068_CB-PRGn.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/068_\
CB-PRGn.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
069_CB-PuOr.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/069_\
CB-PuOr.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
070_CB-RdBu.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/070_\
CB-RdBu.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
071_CB-RdGy.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/071_\
CB-RdGy.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
072_CB-RdYlBu.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/072_\
CB-RdYlBu.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
073_CB-RdYlGn.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/073_\
CB-RdYlGn.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
074_CB-Spectral.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/074_\
CB-Spectral.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
075_LAB_rainbow.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/075_\
LAB_rainbow.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
076_MPL_rainbow.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/076_\
MPL_rainbow.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
077_MPL_option_A.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/077_\
MPL_option_A.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
078_MPL_option_B.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/078_\
MPL_option_B.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
079_MPL_option_C.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/079_\
MPL_option_C.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
080_MPL_option_D.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/080_\
MPL_option_D.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
081_Singlehue_Red.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/081_\
Singlehue_Red.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
082_Singlehue_RedOrange.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/082_\
Singlehue_RedOrange.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
083_Singlehue_Orange.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/083_\
Singlehue_Orange.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
084_Singlehue_Gold.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/084_\
Singlehue_Gold.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
085_Singlehue_YellowGreen.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/085_\
Singlehue_YellowGreen.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
086_Singlehue_Green.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/086_\
Singlehue_Green.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
087_Singlehue_GreenBlue.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/087_\
Singlehue_GreenBlue.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
088_Singlehue_Teal.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/088_\
Singlehue_Teal.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
089_Singlehue_Blue.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/089_\
Singlehue_Blue.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
090_Singlehue_DarkBlue.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/090_\
Singlehue_DarkBlue.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
091_Singlehue_Purple.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/091_\
Singlehue_Purple.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
092_Singlehue_Indigo.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/092_\
Singlehue_Indigo.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
093_Multihue_Red1.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/093_\
Multihue_Red1.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
094_Multihue_Red2.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/094_\
Multihue_Red2.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
095_Multihue_Red3.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/095_\
Multihue_Red3.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
096_Multihue_Red4.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/096_\
Multihue_Red4.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
097_Multihue_Red5.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/097_\
Multihue_Red5.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
098_Multihue_Red6.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/098_\
Multihue_Red6.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
099_Multihue_Green1.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/099_\
Multihue_Green1.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
100_Multihue_Green2.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/100_\
Multihue_Green2.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
101_Multihue_Green3.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/101_\
Multihue_Green3.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
102_Multihue_Green4.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/102_\
Multihue_Green4.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
103_Multihue_Green5.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/103_\
Multihue_Green5.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
104_Multihue_Green6.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/104_\
Multihue_Green6.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
105_Multihue_Blue1.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/105_\
Multihue_Blue1.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
106_Multihue_Blue2.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/106_\
Multihue_Blue2.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
107_Multihue_Blue3.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/107_\
Multihue_Blue3.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
108_Multihue_Blue4.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/108_\
Multihue_Blue4.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
109_Multihue_Blue5.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/109_\
Multihue_Blue5.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
110_Multihue_Blue6.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/110_\
Multihue_Blue6.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
111_Multihue_Purple1.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/111_\
Multihue_Purple1.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
112_Multihue_Purple2.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/112_\
Multihue_Purple2.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
113_Multihue_Purple3.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/113_\
Multihue_Purple3.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
114_Multihue_Purple4.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/114_\
Multihue_Purple4.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
115_Multihue_Purple5.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/115_\
Multihue_Purple5.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
116_Multihue_Purple6.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/116_\
Multihue_Purple6.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
117_cyclic1.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/117_\
cyclic1.png --quit\\n\\npython -m viscm show \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_test/\
118_cyclic2.py --save \
/home/mike/Documents/Helpful_Objects/IDL/chaffin/IDL-Colorbars/IDL_py_png/118_\
cyclic2.png --quit\"\>"], "Output",
 CellChangeTimes->{
  3.6480661275751133`*^9, {3.648066163349036*^9, 3.648066183933166*^9}, 
   3.648069264530015*^9, 3.655135606093711*^9, 3.655136660010632*^9, 
   3.658032165121924*^9, 3.6622219201357193`*^9, 3.662226899750678*^9}]
}, Open  ]],

Cell["\<\
I then copied and pasted the above expression into a terminal, which had the \
desired effect.\
\>", "Text",
 CellChangeTimes->{{3.648216388672044*^9, 3.648216415749504*^9}}]
}, Open  ]]
},
WindowSize->{2815, 1776},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"10.3 for Linux x86 (64-bit) (December 10, 2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Info-8e984295-0467-45ca-a34f-0f1dd37fbaf4"->{
  Cell[2799, 84, 1959, 33, 94, "Print",
   CellTags->"Info-8e984295-0467-45ca-a34f-0f1dd37fbaf4"]},
 "Info-3d15986b-7190-4202-ae7f-240d11314da9"->{
  Cell[103870, 1785, 4453, 67, 213, "Print",
   CellTags->"Info-3d15986b-7190-4202-ae7f-240d11314da9"]},
 "Info-112a31dd-a011-4479-9715-5c3d52c0fdb7"->{
  Cell[187815, 3266, 591, 13, 66, "Print",
   CellTags->"Info-112a31dd-a011-4479-9715-5c3d52c0fdb7"]},
 "Info-20ebece6-b7c7-447d-b18c-3ebc1b2290ee"->{
  Cell[208407, 3690, 1814, 29, 150, "Print",
   CellTags->"Info-20ebece6-b7c7-447d-b18c-3ebc1b2290ee"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Info-8e984295-0467-45ca-a34f-0f1dd37fbaf4", 241802, 4287},
 {"Info-3d15986b-7190-4202-ae7f-240d11314da9", 241950, 4290},
 {"Info-112a31dd-a011-4479-9715-5c3d52c0fdb7", 242103, 4293},
 {"Info-20ebece6-b7c7-447d-b18c-3ebc1b2290ee", 242254, 4296}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 174, 3, 47, "Input"],
Cell[757, 27, 270, 4, 47, "Output"]
}, Open  ]],
Cell[1042, 34, 314, 7, 47, "Input"],
Cell[1359, 43, 353, 8, 47, "Input"],
Cell[1715, 53, 362, 8, 47, "Input"],
Cell[CellGroupData[{
Cell[2102, 65, 178, 3, 47, "Input"],
Cell[2283, 70, 358, 5, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2678, 80, 118, 2, 47, "Input"],
Cell[2799, 84, 1959, 33, 94, "Print",
 CellTags->"Info-8e984295-0467-45ca-a34f-0f1dd37fbaf4"]
}, Open  ]],
Cell[4773, 120, 1061, 29, 86, "Input"],
Cell[CellGroupData[{
Cell[5859, 153, 183, 3, 47, "Input"],
Cell[6045, 158, 50163, 788, 131, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[56245, 951, 136, 2, 47, "Input"],
Cell[56384, 955, 45361, 773, 131, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[101782, 1733, 1308, 33, 144, "Input"],
Cell[103093, 1768, 617, 8, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[103747, 1781, 120, 2, 47, "Input"],
Cell[103870, 1785, 4453, 67, 213, "Print",
 CellTags->"Info-3d15986b-7190-4202-ae7f-240d11314da9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[108360, 1857, 146, 4, 47, "Input"],
Cell[108509, 1863, 1032, 28, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[109578, 1896, 852, 22, 47, "Input"],
Cell[110433, 1920, 10401, 258, 171, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[120871, 2183, 384, 8, 47, "Input"],
Cell[121258, 2193, 51540, 806, 131, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[172835, 3004, 353, 10, 47, "Input"],
Cell[173191, 3016, 14463, 241, 2544, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[187691, 3262, 121, 2, 47, "Input"],
Cell[187815, 3266, 591, 13, 66, "Print",
 CellTags->"Info-112a31dd-a011-4479-9715-5c3d52c0fdb7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[188443, 3284, 199, 4, 47, "Input"],
Cell[188645, 3290, 141, 2, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[188823, 3297, 120, 1, 97, "Section"],
Cell[188946, 3300, 262, 7, 112, "Input"],
Cell[189211, 3309, 687, 12, 592, "Input"],
Cell[189901, 3323, 603, 15, 47, "Input"],
Cell[190507, 3340, 245, 7, 47, "Input"],
Cell[190755, 3349, 408, 9, 47, "Input"],
Cell[CellGroupData[{
Cell[191188, 3362, 400, 9, 47, "Input"],
Cell[191591, 3373, 14301, 245, 2032, "Output"]
}, Open  ]],
Cell[205907, 3621, 467, 12, 47, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[206411, 3638, 155, 3, 97, "Section"],
Cell[CellGroupData[{
Cell[206591, 3645, 386, 7, 47, "Input"],
Cell[206980, 3654, 418, 6, 47, "Output"]
}, Open  ]],
Cell[207413, 3663, 845, 19, 80, "Input"],
Cell[CellGroupData[{
Cell[208283, 3686, 121, 2, 47, "Input"],
Cell[208407, 3690, 1814, 29, 150, "Print",
 CellTags->"Info-20ebece6-b7c7-447d-b18c-3ebc1b2290ee"]
}, Open  ]],
Cell[CellGroupData[{
Cell[210258, 3724, 151, 3, 47, "Input"],
Cell[210412, 3729, 562, 9, 80, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[211011, 3743, 328, 5, 47, "Input"],
Cell[211342, 3750, 473, 7, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[211852, 3762, 151, 3, 47, "Input"],
Cell[212006, 3767, 536, 8, 80, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[212579, 3780, 256, 5, 47, "Input"],
Cell[212838, 3787, 28428, 480, 11408, "Output"]
}, Open  ]],
Cell[241281, 4270, 184, 4, 46, "Text"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
