;+

;FUNCTION:	v_2d_new((dat,ENERGY=en,ERANGE=er,EBINS=ebins,ANGLE=an,ARANGE=ar,BINS=bins)

;INPUT:	

;	dat:	structure,	2d data structure filled by get_eesa_surv, get_eesa_burst, etc.

;KEYWORDS

;	ENERGY:	fltarr(2),	optional, min,max energy range for integration

;	ERANGE:	fltarr(2),	optional, min,max energy bin numbers for integration

;	EBINS:	bytarr(na),	optional, energy bins array for integration

;					0,1=exclude,include,  

;					na = dat.nenergy

;	ANGLE:	fltarr(2),	optional, min,max pitch angle range for integration

;	ARANGE:	fltarr(2),	optional, min,max angle bin numbers for integration

;	BINS:	bytarr(nb),	optional, angle bins array for integration

;					0,1=exclude,include,  

;					nb = dat.ntheta

;	BINS:	bytarr(na,nb),	optional, energy/angle bins array for integration

;					0,1=exclude,include

;PURPOSE:

;	Returns the velocity, [Vx,Vy,Vz], km/s

;NOTES:	

;	Function calls j_2d_new.pro and n_2d_new.pro

;	Function normally called by "get_2dt.pro" to generate 

;	time series data for "tplot.pro".

;

;CREATED BY:

;	J.McFadden		05-05-07

;LAST MODIFICATION:

;	05-05-07		J.McFadden

;-

function v_2d_new,dat2,ENERGY=en,ERANGE=er,EBINS=ebins,ANGLE=an,ARANGE=ar,BINS=bins



vel = [0.,0.,0.]



if dat2.valid ne 1 then begin

	print,'Invalid Data'

	return, vel

endif



flux = j_2d_new(dat2,ENERGY=en,ERANGE=er,EBINS=ebins,ANGLE=an,ARANGE=ar,BINS=bins)

density = n_2d_new(dat2,ENERGY=en,ERANGE=er,EBINS=ebins,ANGLE=an,ARANGE=ar,BINS=bins)

vel(2) = 1.e-5*flux/density



; units are km/sec



return, vel



end



