; $LastChangedBy: ali $
; $LastChangedDate: 2025-10-28 11:41:17 -0700 (Tue, 28 Oct 2025) $
; $LastChangedRevision: 33800 $
; $URL: svn+ssh://thmsvn@ambrosia.ssl.berkeley.edu:36867/repos/spdsoft/trunk/projects/SWFO/swfo_sc_100_apdat__define.pro $


function swfo_mag_sci_apdat::decom,ccsds,source_dict=source_dict

  ccsds_data = swfo_ccsds_data(ccsds)

  if ccsds.pkt_size eq 768/8+20 then begin
    rawdat =   swfo_data_select(ccsds_data, 20*8+indgen(8*2*3)*16, 16 ,/signed)
    
  endif else begin
    rawdat =   swfo_data_select(ccsds_data, 20*8+indgen(64*2*3)*16, 16 ,/signed)
    
  endelse

  datastr = {$
    time:ccsds.time,  $
    time_delta:ccsds.time_delta, $
    met:ccsds.met,   $
    grtime: ccsds.grtime,  $
    delaytime: ccsds.delaytime, $
    apid:ccsds.apid,  $
    seqn:ccsds.seqn,$
    seqn_delta:ccsds.seqn_delta,$
    packet_size:ccsds.pkt_size,$
    tod_day:                          swfo_data_select(ccsds_data,  6*8,16),$
    tod_millisec:                     swfo_data_select(ccsds_data,  8*8,32),$
    tod_microsec:                     swfo_data_select(ccsds_data, 12*8,16),$
    mag_data:   rawdat  , $
    gap:ccsds.gap }
    
    if 0 then begin
      dprint,time_string(datastr.time),' ',datastr.seqn, ' ',ccsds.pkt_size
    endif
    
  return,datastr

end


pro swfo_mag_sci_apdat__define
  void = {swfo_mag_sci_apdat, $
    inherits swfo_gen_apdat $    ; superclass
  }
end

