;+
; ts07_test
;
; Purpose: A few tests to verify that the model and the wrapper
; procedures work correctly
;
; $LastChangedBy: jwl $
; $LastChangedDate: 2021-07-28 18:16:15 -0700 (Wed, 28 Jul 2021) $
; $LastChangedRevision: 30156 $
; $URL: svn+ssh://thmsvn@ambrosia.ssl.berkeley.edu/repos/spdsoft/trunk/external/IDL_GEOPACK/ts07/ts07_test.pro $
;-

;takes a matrix whose columns define a plane
;and an Nx3 series of points
;returns an Nx2 series of points generated by projecting x into a
function project_ts07, a, x

  p = a ## invert(transpose(a) ## a) ## transpose(a)

  return, p ## x

end

;constructs a vector field from orbital data, useful for visualization
;of results
pro orbital_vf_ts07, name, param_dir, param_file

  get_data, name, data = d

  tts07,name,pdyn=2.0D,error=e,ts07_param_dir=param_dir,ts07_param_file=param_file,/skip_ts07_load

  get_data, name+'_bts07', data = td

  t_size = n_elements(d.x)

  ;3 points selected to define a plane
  v1 = d.y[0, *]

  v2 = d.y[floor(t_size/3), *]

  v3 = d.y[floor(2*t_size/3), *]

  ;plane vectors are just v2, and v3 shifted by the reference point v1
  vp1 = v2-v1

  vp2 = v3-v1

  proj_pos = project_ts07([vp1, vp2], d.y)

  proj_mag = project_ts07([vp1, vp2], td.y)

  ivector, interpol(proj_mag[*, 0],20),interpol(proj_mag[*, 1],20), interpol(proj_pos[*, 0],20), interpol(proj_pos[*, 1],20),renderer=1

end

timespan, '2008-03-23'

;load state data
thm_load_state, probe = 'b', coord = 'gsm'

; load spedas configuration

spedas_init

param_dir=!spedas.geopack_param_dir
param_file='ts07_sample_dyncoef.par'
;test with single number argument
tts07, 'thb_state_pos',pdyn=2.0D,error=e,ts07_param_dir=param_dir,ts07_param_file=param_file

if e eq 0 then begin
  message,/continue,'error detected, stopping'
  stop
endif

tplot,'thb_state_pos_bts07'

stop

del_data,'thb_state_pos_bts07'

get_data,'thb_state_pos',data=d

n = n_elements(d.x)

;test with an array argument
tts07, 'thb_state_pos',pdyn=replicate(2.0D,n),error=e,ts07_param_dir=param_dir,ts07_param_file=param_file,/skip_ts07_load

if e eq 0 then begin
  message,/continue,'error detected, stopping'
  stop
endif

tplot,'thb_state_pos_bts07'

stop

del_data,'thb_state_pos_bts07'

d2 = {x:d.x[0],y:2.0D}

store_data,'t_pdyn',data=d2


;test with tplot arguments
tts07,'thb_state_pos',pdyn='t_pdyn',error=e,ts07_param_dir=param_dir,ts07_param_file=param_file,/skip_ts07_load

if e eq 0 then begin
  message,/continue,'error detected, stopping'
  stop
endif

tplot,'thb_state_pos_bts07'

stop

del_data,'thb_state_pos_bts07'

;test with newname
tts07, 'thb_state_pos',pdyn=2.0D,newname='test',error=e,ts07_param_dir=param_dir,ts07_param_file=param_file,/skip_ts07_load

if e eq 0 then begin
  message,/continue,'error detected, stopping'
  stop
endif

tplot,'test'

stop

del_data,'test'

;test with a different period

tts07, 'thb_state_pos',pdyn=2.0D,period=30,error=e,ts07_param_dir=param_dir,ts07_param_file=param_file,/skip_ts07_load

if e eq 0 then begin
  message,/continue,'error detected, stopping'
  stop
endif

tplot,'thb_state_pos_bts07'

stop

;test with an incremented tilt
tts07, 'thb_state_pos',pdyn=2.0D,error=e,get_tilt='tilt_vals',get_nperiod=gn,add_tilt=1,ts07_param_dir=param_dir,ts07_param_file=param_file,/skip_ts07_load

if e eq 0 then begin
  message,/continue,'error detected, stopping'
  stop
endif

tplot,'tilt_vals'

stop

;test with a set tilt
tts07, 'thb_state_pos',pdyn=2.0D,error=e,get_tilt='tilt_vals',get_nperiod=gn,set_tilt=1,ts07_param_dir=param_dir,ts07_param_file=param_file,/skip_ts07_load

if e eq 0 then begin
  message,/continue,'error detected, stopping'
  stop
endif

options,'tilt_vals',yrange=[0,2]
tplot,'tilt_vals'
options,'tilt_vals',yrange=[1,1]  ;reset to auto-range
stop

orbital_vf_ts07,'thb_state_pos',param_dir,param_file

print,'The plot produced should look like the plot titled ts07_test.png'

end
