;+  return model coefficients for bin(energy) function
;
; INPUT: flightID is a two-character string to identify
;        which payload through a flight inumber (e.g., '1A')
;
; OUTPUT: [[a1,a2],[b1,b2],[c1,c2]] is a list of 3 sets of
;         linear model coefficients, used by brl_makeedges()
;
; METHOD: linear search; guess if unrecognized input
;
; REVISION HISTORY:
;       16Jan2014 Added constants for payload 2I
;       14Sep2013 first version
;-
function brl_dpucoeffs,flightID
case (flightID) of
  '1A': return,[[0.317400, -0.139300], [0.575800, -0.000313], $
      [-0.021160, 0.000029]]
  '1B': return,[[0.604300, 0.087460], [0.515300, -0.000257], $
      [-0.016780, 0.000025]]
  '1C': return,[[1.330000, -0.094330], [0.474200, -0.000535], $
      [-0.010360, 0.000060]]
  '1D': return,[[1.812000, -0.050540], [0.515400, -0.001294], $
      [-0.013860, 0.000155]]
  '1E': return,[[-8.452000, -0.023890], [0.541500, -0.001481], $
      [-0.015990, 0.000180]]
  '1F': return,[[-10.470000, -0.044950], [0.563600, -0.000826], $
      [-0.019250, 0.000102]]
  '1G': return,[[-10.580000, -0.061540], [0.484700, -0.000709], $
      [-0.008275, 0.000080]]
  '1H': return,[[-9.469000, -0.148700], [0.517600, -0.001257], $
      [-0.012920, 0.000153]]
  '1I': return,[[-12.360000, -0.085400], [0.585600, -0.000948], $
      [-0.021780, 0.000116]]
  '1J': return,[[-12.680000, -0.081900], [0.615600, -0.000632], $
      [-0.026660, 0.000076]]
  '1K': return,[[-3.781000, -0.229400], [0.515200, -0.000766], $
      [-0.012310, 0.000089]]
  '1L': return,[[-14.350000, 0.016730], [0.563900, -0.001210], $
      [-0.018870, 0.000143]]
  '1M': return,[[-10.760000, -0.062830], [0.599600, -0.000408], $
      [-0.024300, 0.000050]]
  '1N': return,[[-17.330000, 0.067700], [0.601900, -0.001076], $
      [-0.024690, 0.000133]]
  '1O': return,[[-7.304000, -0.189100], [0.517400, -0.000520], $
      [-0.012590, 0.000061]]
  '1P': return,[[-9.886000, -0.053040], [0.513600, -0.000794], $
      [-0.013680, 0.000097]]
  '1Q': return,[[-4.143000, -0.039420], [0.477000, -0.001111], $
      [-0.008573, 0.000138]]
  '1R': return,[[-11.350000, -0.107700], [0.526300, -0.000531], $
      [-0.012920, 0.000060]]
  '1S': return,[[-8.105000, -0.230700], [0.555400, -0.001274], $
      [-0.017710, 0.000156]]
  '1T': return,[[-8.434000, -0.151700], [0.595700, -0.001359], $
      [-0.023260, 0.000161]]
  '1U': return,[[-3.757000, -0.034980], [0.477800, -0.000661], $
      [-0.008127, 0.000074]]
  '1V': return,[[0.189100, -0.046100], [0.499800, -0.001214], $
      [-0.012360, 0.000137]]
  '2I': return,[[-7.629, -0.1172], [0.6407,-0.0009381], $
      [-0.02587, 0.0001151]]
  ELSE: return,[[-5, -0.1], [0.5, -0.001], [-0.01, 0.0001]]
endcase
end
