;+
;NAME:
; spd_ui_wavelet
;PURPOSE:
; wavelet transform of the input tplot variables, fist calls split_vec
; to split up any multi-component vectors.
;CALLING SEQUENCE:
; spd_ui_wavelet, vnames, new_names, polar=polar,_extra=_extra
;INPUT:
; vnames = the tplot variable names to transform
;OUTPUT:
; new_names = new variable names generated by the process
;KEYWORDS:
; polar = if set, passes the /polar keyword into the split_vec
;         procedure, new variable names for 3-d data will be polar,
;         and not '_x','_y','_z'
; gui_id = the main GUI widget ID, for messages
; messw_id = the dproc widget id, for messages
; temp_names = the names of temporary variables create by the process
;              so that they can be reliably removed
; maxpoints = the maximum number of time samples in the original data
;             (default = 2^15 if not set)
;HISTORY:
; 12-mar-2007, jmm, jimm@ssl.berkeley.edu
; 5-jun-2007, jmm, no longer handles history
; 7-may-2008, W. Michael Feuerstein, Test for >= 2 finite points.
; 11-may-2009,prc(pcruce@igpp.ucla.edu) added keyword to return the  
;             names of temporary variables created in process
;
;$LastChangedBy: nikos $
;$LastChangedDate: 2016-03-07 10:51:31 -0800 (Mon, 07 Mar 2016) $
;$LastChangedRevision: 20343 $
;$URL: svn+ssh://thmsvn@ambrosia.ssl.berkeley.edu/repos/spdsoft/trunk/spedas_gui/utilities/spd_ui_wavelet.pro $
;-
Pro spd_ui_wavelet, vnames, new_names, trange, polar = polar, prange=prange, $
                    gui_id = gui_id, messw_id = messw_id, $
                    temp_names=vn_j, maxpoints=maxpoints, $
                    display_object=display_object, $
                    _extra = _extra

  If(is_string(vnames) Eq 0) Then Begin
    dprint, 'No Active variable name is set', display_object=display_object
    If(keyword_set(gui_id)) Then $
      spd_ui_update_progress, gui_id, 'SPD_UI_WAVELET: No Active variable name set'
    If(keyword_set(messw_id)) Then $
      widget_control, messw_id, set_val = 'SPD_UI_WAVELET: No Active variable name set'
    new_names = ''
    return
  Endif
  n =  n_elements(vnames)
  tn0 = tnames()                ;we'll need to know this
  new_names = ''
  For j = 0, n-1 Do Begin
    tn1 = tnames() ;and we'll need to keep track of these for each point
    get_data, vnames[j], data = data ;first call split_vec, if necessary
    If(is_struct(data)) Then Begin 
      ndj = n_elements(data.y[0, *])
      If(ndj Eq 3) Then Begin
        split_vec, vnames[j], polar = polar, names_out = vn_j, display_object=display_object
      Endif Else If(ndj Gt 1) Then Begin
        split_vec, vnames[j], names_out = vn_j, display_object=display_object, $
          suffix = '_'+strcompress(string(indgen(ndj)), /remove_all)
      Endif Else vn_j = vnames[j]
    Endif Else vn_j = ''
;Do the transform
    If(is_string(vn_j)) Then Begin
      nvnj = n_elements(vn_j)
      For k = 0, nvnj-1 Do Begin
;test the data first
        get_data, vn_j[k], data = d, dlimits=dl0
        If (is_struct(d)) ? n_elements(where(finite(d.y))) ge 2 : 0 Then Begin
          ok = where(d.x Gt trange[0] And d.x Le trange[1], nok)
          If(nok Gt 500000l) Then Begin
            dprint, 'Warning: '+strcompress(string(nok))+' May be too many data points', display_object=display_object
            If(keyword_set(gui_id)) Then $
              spd_ui_update_progress, gui_id, 'SPD_UI_WAVELET: Warning: '+strcompress(string(nok))+' May be too many data points'
            If(keyword_set(messw_id)) Then $
              widget_control, messw_id, set_val = 'SPD_UI_WAVELET: Warning: '+strcompress(string(nok))+' May be too many data points'
          Endif Else Begin
            If(keyword_set(gui_id)) Then $
              spd_ui_update_progress, gui_id, 'SPD_UI_WAVELET: Processing: '+vn_j[k]
            If(keyword_set(messw_id)) Then $
              widget_control, messw_id, set_val = 'SPD_UI_WAVELET: Processing: '+vn_j[k]
          Endelse
          
          ;create an object to pass to wav_data, which is passed to dprint to do error reporting
;          display_object = obj_new('spd_ui_dprint_display',historyWin=hwin,statusBar=sBar)
          wav_data, vn_j[k], trange = trange, prange=prange, maxpoints=maxpoints, display_object=display_object
          new_names = [new_names, vn_j[k]+'_wv_pow']
          
          ;copy data attributes manually since wav_data does not
          ;this is needed by the GUI to correctly label the data
          if tag_exist(dl0,'data_att', /quiet) then begin
            
            data_att = dl0.data_att
            get_data, vn_j[k]+'_wv_pow', dlimits=dl1
            
            ;remove inappropriate tags and add to new dlimits
            ;if dlimits are invalid then variable may be too, so no else case here
            if is_struct(dl1) then begin 
              str_element, data_att, 'coord_sys', /delete
              str_element, data_att, 'units', /delete
              str_element, dl1, 'data_att', data_att, /add
              store_data, vn_j[k]+'_wv_pow', dlimits = dl1
            endif

          endif

        Endif Else Begin
          If(keyword_set(gui_id)) Then $
            spd_ui_update_progress, gui_id, 'SPD_UI_WAVELET: No data for: '+vn_j[k]
          If(keyword_set(messw_id)) Then $
            widget_control, messw_id, set_val = 'SPD_UI_WAVELET: No Data for: '+vn_j[k]
        Endelse
      Endfor
    Endif
  Endfor
;What are the new names?
  If(n_elements(new_names) Gt 1) Then new_names = new_names[1:*]
  Return
End

      
      
        
