;+ 
;PROCEDURE:   mvn_sta_cio_clear
;PURPOSE:
;  Clears pointers to free the memory used by heap variable(s).
;  If a filter has been defined as part of the data structure,
;  it is cleared too. Pointers from the feature structure and/or the 
;  plot-option structure are also cleared. Each input data is set to zero.
;
;USAGE:
;  mvn_sta_cio_clear, ptr
;INPUTS:
;       ptr    :    A pointer to heap variable(s) to be removed.
;
;KEYWORDS:
;     feature  :    Structure generated by get_mars_features.pro.
;     p_option :    Structure generated by create_iono_p_options.pro.
;     filteronly :  Only remove the filter.
;
; $LastChangedBy: dmitchell $
; $LastChangedDate: 2020-05-01 12:23:32 -0700 (Fri, 01 May 2020) $
; $LastChangedRevision: 28655 $
; $URL: svn+ssh://thmsvn@ambrosia.ssl.berkeley.edu/repos/spdsoft/trunk/projects/maven/swea/mvn_sta_cio_clear.pro $
;
;CREATED BY:	David L. Mitchel
;FILE:  mvn_sta_cio_clear.pro
;-
pro mvn_sta_cio_clear, ptr, feature=feature, p_option=p_option, filteronly=filteronly

 filteronly = keyword_set(filteronly)

 sz= size(ptr)
 if sz[0] eq 1 then  begin
  print,' ptr must be a scalar.'
  return
 endif 
 if n_elements(ptr) eq 1 then begin
  if (ptr_valid(ptr)) then begin
    if (data_type(*ptr) ne 8) then begin
      print,'  Pointer does not point to a structure!'
      yn = ''
      read,yn,format='(a1)',prompt='  Clear it anyway (y|n) ? '
      if (strupcase(yn) eq 'Y') then begin
        ptr_free, ptr
        ptr = 0
        return
      endif
    endif

    data_tags = strlowcase(tag_names(*ptr))
    i = where(data_tags eq 'filter', cnt)
    if (cnt ne 0L) then begin
      if (ptr_valid((*ptr).filter)) then ptr_free, (*ptr).filter
      str_element, *ptr, 'filter', /delete
    endif

    if (not filteronly) then ptr_free, ptr
  endif

  if (not filteronly) then ptr = 0
 endif

 if (size(feature,/type) eq 8) then begin
    if (total(ptr_valid(feature.elon)) ne 0) then ptr_free,feature.elon
    if (total(ptr_valid(feature.lat )) ne 0)   then ptr_free,feature.lat
    feature = 0
  endif
  
  if (size(p_option,/type) eq 8) then begin
    if (total(ptr_valid(p_option.lon0)) ne 0)  then ptr_free,p_option.lon0
    if (total(ptr_valid(p_option.lat0)) ne 0)  then ptr_free,p_option.lat0
    p_option = 0
  endif

  return

end
