;+
;FUNCTION:	mvn_sta_c6_bkg(dat)
;INPUT:	
;	dat:	structure,	generated by mvn_sta_get_c6() 
;KEYWORDS
;	
;PURPOSE:
;	Returns the background for maven static apid c6 structures 
;NOTES:	
;	Function to calculate the straggling backgroud from maven static apid c6 packets
;	Function can be used as "bkg" keyword passed to get_4dt.pro for background subtraction
;
;	This generates a decent, energy independent background subtraction if coincident events can be ignored
;		proton straggling represents about ~2% of the events when coincident events can be ignored
;
;CREATED BY:
;	J.McFadden	14-05-08	
;LAST MODIFICATION:
;-
function mvn_sta_c6_bkg,dat

	bg = fltarr(32,64)
	bb = total(dat.data[*,0:6],2)/total(dat.twt_arr[*,0:6],2)
	maxt = max(bb,ind)
	ind = ind>2									; handles bb[*]=0
	for ii=8,63 do bg[*,ii] = bb * dat.data[ind,ii]/(bb[ind]>1.e-10)
	cc = total(dat.data[*,9:13],2)/total(dat.twt_arr[*,9:13],2)
	for ii=15,63 do bg[*,ii] = bg[*,ii] + cc * dat.data[ind-2,ii]/(cc[ind-2]>1.e-10)

	return,bg

end

