;+
;FUNCTION:	heatflux
;PURPOSE:	Calulates heatlux from a 3dimensional data structure such as
;		those generated by get_el,get_pl,etc. 
;		e.g. "get_el"
;INPUT:		
;	dat:	A 3d data structure.
;KEYWORDS:
;	esteprange:	the energy step range to use, default is full range
;CREATED BY:	Davin Larson
;LAST MODIFICATION:	@(#)heatflux.pro	1.5 95/10/06
;-



function heatflux, dat, $
   ESTEPRANGE = esteprange

if n_elements(esteprange) eq 0 then esteprange = [0 ,dat.nenergy-1]

e1 = esteprange(0)
e2 = esteprange(1)
b1 = 0
b2 = dat.nbins-1


data = dat.data(e1:e2,b1:b2)
theta= dat.theta(e1:e2,b1:b2)
phi  = dat.phi(e1:e2,b1:b2)
energy = dat.energy(e1:e2,b1:b2)

mult = replicate(1.,e2-e1+1)
domega = mult # dat.domega(b1:b2)
geom =  mult # dat.geom(b1:b2)

sphere_to_cart, 1., theta, phi, sx,sy,sz

pp = data * domega * energy * energy / geom  ;must be fixed: incorrect weights!
qx = total(sx*sx*pp,/double)
qy = total(sy*sy*pp,/double)
qz = total(sz*sz*pp,/double)

heatflux = [ qx,qy,qz ]

return ,heatflux
end
