;Ali: June 2020
;+
; $LastChangedBy: ali $
; $LastChangedDate: 2020-12-09 08:27:23 -0800 (Wed, 09 Dec 2020) $
; $LastChangedRevision: 29449 $
; $URL: svn+ssh://thmsvn@ambrosia.ssl.berkeley.edu/repos/spdsoft/trunk/projects/SPP/COMMON/sc/spp_sc_hk_0x256_apdat__define.pro $
;-

function spp_swp_ftemp,C0, C1, C2, Beta, BetaCal, R_Harness, Rcal, ChannelName, CalChannelName
  BETA_CAL=BetaCal
  adc_counts=ChannelName
  adc_counts_CAL=CalChannelName
  Resistance= Rcal * (adc_counts - BETA)/(adc_counts_CAL - BETA_CAL) - R_HARNESS
  R=Resistance
  Temp = C2 * R^2  + C1 * R + C0
  return,Temp
end

;//
;//                      2
;//         Temp = C2 * R  + C1 * R + C0
;//
;//             where 'Temp' is temperature in Degrees C
;//                   'R' is resistance in ohms
;// GSEOS conversion functions for temperatures
;//
;//                                    adc_counts - BETA
;//     Resistance[ohms] = Rcal * ----------------------------- - R_HARNESS
;//                                adc_counts_CAL - BETA_CAL
;//
;//     where
;//         'adc_counts' is the measured A-to-D value for the RIU channel of interest [0-1023]
;//         'BETA' is an emperically predetermined correction factor for the RIU channel of interest
;//         'adc_counts_CAL' is the measured A-to-D value for the RIU calibration channel (with a fixed known resistor value)
;//         'BETA_CAL' is an emperically predetermined correction factor for the RIU calibration channel
;//         'R_HARNESS'is an emperically predetermined harness resistance for the RIU channel of interest
;//         'RCAL'is the calibration resistance in ohms

function spp_SC_HK_0x256_struct,ccsds_data
  if n_elements(ccsds_data) eq 0 then ccsds_data = bytarr(67)

  a0 = -100.
  a1 = 214./1023

  RIU_3A_CH2_COUNTS=spp_swp_data_select(ccsds_data,128*8+7-3,10)
  RIU_3A_CH5_COUNTS=spp_swp_data_select(ccsds_data,132*8+7-5,10)
  RIU_3B_CH7_COUNTS=spp_swp_data_select(ccsds_data,2080*8+7-7,10)
  RIU_4B_CH6_COUNTS=spp_swp_data_select(ccsds_data,2099*8+7-3,10)
  RIU_5A_CH6_COUNTS=spp_swp_data_select(ccsds_data,1963*8+7-0,10) ;SWEAP/SPAN-A+ Electronics Box Temperature (RIU 5A, Chnl 6)
  RIU_5A_CH9_COUNTS=spp_swp_data_select(ccsds_data,1965*8+7-5,10) ;SWEAP/SPC Pre-amp Temperature (RIU 5A, Chnl 9)
  RIU_5B_CH7_COUNTS=spp_swp_data_select(ccsds_data,2115*8+7-7,10)
  RIU_8B_CH3_COUNTS=spp_swp_data_select(ccsds_data,157*8+7-5,10)
  RIU_4B_CH15N_COUNTS=spp_swp_data_select(ccsds_data,2105*8+7-2,10)
  RIU_5A_CH15N_COUNTS=spp_swp_data_select(ccsds_data,1970*8+7-7,10)
  RIU_5B_CH15N_COUNTS=spp_swp_data_select(ccsds_data,2122*8+7-3,10)
  RIU_8B_CH15N_COUNTS=spp_swp_data_select(ccsds_data,2188*8+7-7,10)
  RIU_3A_CH15N_COUNTS=482. ;from apid 0x254 assumed constant
  RIU_3B_CH15N_COUNTS=472. ;from apid 0x254 assumed constant

  str = {time:!values.d_nan ,$
    met:!values.d_nan, $
    seqn: 0u, $
    pkt_size: 0u, $
    SWEAP_SPAN_B_ELECT_BOX_TEMP:        spp_swp_fTemp(-245.5261, 0.2352584, 1.025851E-5,-710.171282841022,-736.077314727045,1.0868, 987.5098,RIU_3A_CH2_COUNTS,RIU_3A_CH15N_COUNTS), $
    SWEAP_SPAN_B_TOP_ANALYZER_TEMP:     spp_swp_fTemp(-245.5261, 0.2352584, 1.025851E-5,-719.961183748493,-736.077314727045,0,      987.5098,RIU_3A_CH5_COUNTS,RIU_3A_CH15N_COUNTS), $
    SWEAP_SPAN_A_POS_TOP_ANALYZER_TEMP: spp_swp_fTemp(-245.5261, 0.2352584, 1.025851E-5,-726.99240788147, -736.35106595069, 0,      988.49,  RIU_3B_CH7_COUNTS,RIU_3B_CH15N_COUNTS), $
    SWEAP_SPAN_B_PEDESTAL_TEMP:         spp_swp_fTemp(-245.5261, 0.2352584, 1.025851E-5,-723.796097558278,-736.34563238395, 0,      988.23,  RIU_4B_CH6_COUNTS,RIU_4B_CH15N_COUNTS), $
    SWEAP_SPAN_A_POS_ELECT_BOX_TEMP:    spp_swp_fTemp(-245.5261, 0.2352584, 1.025851E-5,-723.407520130859,-736.163232591922,0,      988.3285,RIU_5A_CH6_COUNTS,RIU_5A_CH15N_COUNTS), $
    SWEAP_SPC_PRE_AMP_TEMP:             spp_swp_fTemp(-245.5261, 0.2352584, 1.025851E-5,-737.03346223715, -736.163232591922,0,      988.3285,RIU_5A_CH9_COUNTS,RIU_5A_CH15N_COUNTS), $
    SWEAP_SPAN_A_POS_PEDESTAL_TEMP:     spp_swp_fTemp(-245.5261, 0.2352584, 1.025851E-5,-726.648622928623,-736.164567410113,0,      987.7601,RIU_5B_CH7_COUNTS,RIU_5B_CH15N_COUNTS), $
    SWEAP_SWEM_TEMP:                    spp_swp_fTemp(-245.5261, 0.2352584, 1.025851E-5,-714.254283838527,-736.351338540891,0,      988.17,  RIU_8B_CH3_COUNTS,RIU_8B_CH15N_COUNTS), $
    ;RIU_DERIVED_D_SWEAP_SPC_PRE_AMP_TEMP:a0+a1*spp_swp_data_select(ccsds_data,1965*8+7-5,10), $ ;SWEAP/SPC Pre-amp Temperature (RIU 5A, Chnl 9)
    gap:0B}
  return, str
end

;RIU_3A_CH2_COUNTS,                                            128,    3,   10;SWEAP_SPAN_B_ELECT_BOX_TEMP
;RIU_3A_CH5_COUNTS,                                            132,    5,   10;SWEAP_SPAN_B_TOP_ANALYZER_TEMP
;RIU_3B_CH7_COUNTS,                                           2080,    7,   10;SWEAP_SPAN_A_POS_TOP_ANALYZER_TEMP
;RIU_4B_CH6_COUNTS,                                           2099,    3,   10;SWEAP_SPAN_B_PEDESTAL_TEMP
;RIU_5A_CH6_COUNTS,                                           1963,    0,   10;SWEAP_SPAN_A_POS_ELECT_BOX_TEMP
;RIU_5A_CH9_COUNTS,                                           1965,    5,   10;SWEAP_SPC_PRE_AMP_TEMP
;RIU_5B_CH7_COUNTS,                                           2115,    7,   10;SWEAP_SPAN_A_POS_PEDESTAL_TEMP
;RIU_8B_CH3_COUNTS,                                            157,    5,   10;SWEAP_SWEM_TEMP
;RIU_4B_CH15N_COUNTS,                                         2105,    2,   10;SWEAP_SPAN_B_PEDESTAL_TEMP
;RIU_5A_CH15N_COUNTS,                                         1970,    7,   10;SWEAP_SPAN_A_POS_ELECT_BOX_TEMP SWEAP_SPC_PRE_AMP_TEMP
;RIU_5B_CH15N_COUNTS,                                         2122,    3,   10;SWEAP_SPAN_A_POS_PEDESTAL_TEMP
;RIU_8B_CH15N_COUNTS,                                         2188,    7,   10;SWEAP_SWEM_TEMP

;#  SWEAP Temps:  fTemp: C0, C1, C2, Beta, BetaCal, R_Harness, Rcal, ChannelName, CalChannelName
;EU(Raw='SC_HK_0x256.SWEAP_SPAN_B_ELECT_BOX_TEMP') := fTemp([-245.5261, 0.2352584, 1.025851E-5, -710.171282841022, -736.077314727045, 1.0868, 987.5098], 'SC_HK_0x256_RIU_3A_CH2_COUNTS', 'SC_HK_0x254_RIU_3A_CH15N_COUNTS')
;EU(Raw='SC_HK_0x256.SWEAP_SPAN_B_TOP_ANALYZER_TEMP') := fTemp([-245.5261, 0.2352584, 1.025851E-5, -719.961183748493, -736.077314727045, 0, 987.5098], 'SC_HK_0x256_RIU_3A_CH5_COUNTS', 'SC_HK_0x254_RIU_3A_CH15N_COUNTS')
;EU(Raw='SC_HK_0x256.SWEAP_SPAN_A_POS_TOP_ANALYZER_TEMP') := fTemp([-245.5261, 0.2352584, 1.025851E-5, -726.99240788147, -736.35106595069, 0, 988.49], 'SC_HK_0x256_RIU_3B_CH7_COUNTS', 'SC_HK_0x254_RIU_3B_CH15N_COUNTS')
;EU(Raw='SC_HK_0x256.SWEAP_SPAN_B_PEDESTAL_TEMP') := fTemp([-245.5261, 0.2352584, 1.025851E-5, -723.796097558278, -736.34563238395, 0, 988.23], 'SC_HK_0x256_RIU_4B_CH6_COUNTS', 'SC_HK_0x256_RIU_4B_CH15N_COUNTS')
;EU(Raw='SC_HK_0x256.SWEAP_SPAN_A_POS_ELECT_BOX_TEMP') := fTemp([-245.5261, 0.2352584, 1.025851E-5,  -723.407520130859, -736.163232591922, 0, 988.3285], 'SC_HK_0x256_RIU_5A_CH6_COUNTS', 'SC_HK_0x256_RIU_5A_CH15N_COUNTS')
;EU(Raw='SC_HK_0x256.SWEAP_SPC_PRE_AMP_TEMP') := fTemp([-245.5261, 0.2352584, 1.025851E-5,  -737.03346223715, -736.163232591922, 0, 988.3285], 'SC_HK_0x256_RIU_5A_CH9_COUNTS', 'SC_HK_0x256_RIU_5A_CH15N_COUNTS')
;EU(Raw='SC_HK_0x256.SWEAP_SPAN_A_POS_PEDESTAL_TEMP') := fTemp([-245.5261, 0.2352584, 1.025851E-5, -726.648622928623, -736.164567410113, 0, 987.7601], 'SC_HK_0x256_RIU_5B_CH7_COUNTS', 'SC_HK_0x256_RIU_5B_CH15N_COUNTS')
;EU(Raw='SC_HK_0x256.SWEAP_SWEM_TEMP') := fTemp([-245.5261, 0.2352584, 1.025851E-5,  -714.254283838527, -736.351338540891, 0, 988.17], 'SC_HK_0x256_RIU_8B_CH3_COUNTS', 'SC_HK_0x256_RIU_8B_CH15N_COUNTS')

;<lrv id="RIU.D_SWEAP_SPAN_A_POS_ELECT_BOX_RTD_RESISTANCE" name="SWEAP/SPAN-A+ Electronics Box RTD Resistance (RIU 5A, Chnl 6)" source="D" type="F" subsystem="THRM" length="32" timeoutLrv="GSW_TIMEOUT_A" encoding="ieee" revbits="no" units="ohms" dispfmt="%.2f" retain="no" metadata_id="Metadata" plotcolor="pink" comment="RIU:RIU.D_SWEAP_SPAN_A_POS_ELECT_BOX_RTD_RESISTANCE" />
;<lrv id="RIU.D_SWEAP_SPAN_A_POS_ELECT_BOX_TEMP" name="SWEAP/SPAN-A+ Electronics Box Temperature (RIU 5A, Chnl 6)" source="D" type="F" subsystem="THRM" length="32" timeoutLrv="GSW_TIMEOUT_A" encoding="ieee" revbits="no" units="degC" dispfmt="%+6.1f" retain="no" metadata_id="Metadata" plotcolor="pink" comment="RIU:RIU.D_SWEAP_SPAN_A_POS_ELECT_BOX_TEMP" />
;<lrv id="RIU.D_SWEAP_SPAN_A_POS_HIGH_VOLTAGE_COVER_TEMP" name="SWEAP/SPAN-A+ Top Analyzer Temperature (RIU 3B, Chnl 7)" source="D" type="F" subsystem="THRM" length="32" timeoutLrv="GSW_TIMEOUT_A" encoding="ieee" revbits="no" units="degC" dispfmt="%+6.1f" retain="no" metadata_id="Metadata" plotcolor="pink" comment="RIU:RIU.D_SWEAP_SPAN_A_POS_TOP_ANALYZER_TEMP" />
;<lrv id="RIU.D_SWEAP_SPAN_A_POS_PEDESTAL_RTD_RESISTANCE" name="SWEAP/SPAN-A+ Pedestal RTD Resistance (RIU 5B, Chnl 7)" source="D" type="F" subsystem="THRM" length="32" timeoutLrv="GSW_TIMEOUT_A" encoding="ieee" revbits="no" units="ohms" dispfmt="%.2f" retain="no" metadata_id="Metadata" plotcolor="pink" comment="RIU:RIU.D_SWEAP_SPAN_A_POS_PEDESTAL_RTD_RESISTANCE" />
;<lrv id="RIU.D_SWEAP_SPAN_A_POS_PEDESTAL_TEMP" name="SWEAP/SPAN-A+ Pedestal Temperature (RIU 5B, Chnl 7)" source="D" type="F" subsystem="THRM" length="32" timeoutLrv="GSW_TIMEOUT_A" encoding="ieee" revbits="no" units="degC" dispfmt="%+6.1f" retain="no" metadata_id="Metadata" plotcolor="pink" comment="RIU:RIU.D_SWEAP_SPAN_A_POS_PEDESTAL_TEMP" />
;<lrv id="RIU.D_SWEAP_SPAN_A_POS_TOP_ANALYZER_RTD_RESISTANCE" name="SWEAP/SPAN-A+ Top Analyzer RTD Resistance (RIU 3B, Chnl 7)" source="D" type="F" subsystem="THRM" length="32" timeoutLrv="GSW_TIMEOUT_A" encoding="ieee" revbits="no" units="ohms" dispfmt="%.2f" retain="no" metadata_id="Metadata" plotcolor="pink" comment="RIU:RIU.D_SWEAP_SPAN_A_POS_TOP_ANALYZER_RTD_RESISTANCE" />
;<lrv id="RIU.D_SWEAP_SPAN_A_POS_TOP_ANALYZER_TEMP" name="SWEAP/SPAN-A+ Top Analyzer Temperature (RIU 3B, Chnl 7)" source="D" type="F" subsystem="THRM" length="32" timeoutLrv="GSW_TIMEOUT_A" encoding="ieee" revbits="no" units="degC" dispfmt="%+6.1f" retain="no" metadata_id="Metadata" plotcolor="pink" comment="RIU:RIU.D_SWEAP_SPAN_A_POS_TOP_ANALYZER_TEMP" />
;<lrv id="RIU.D_SWEAP_SPAN_B_ELECT_BOX_RTD_RESISTANCE" name="SWEAP/SPAN-B Electronics Box RTD Resistance (RIU 3A, Chnl 2)" source="D" type="F" subsystem="THRM" length="32" timeoutLrv="GSW_TIMEOUT_A" encoding="ieee" revbits="no" units="ohms" dispfmt="%.2f" retain="no" metadata_id="Metadata" plotcolor="pink" comment="RIU:RIU.D_SWEAP_SPAN_B_ELECT_BOX_RTD_RESISTANCE" />
;<lrv id="RIU.D_SWEAP_SPAN_B_ELECT_BOX_TEMP" name="SWEAP/SPAN-B Electronics Box Temperature (RIU 3A, Chnl 2)" source="D" type="F" subsystem="THRM" length="32" timeoutLrv="GSW_TIMEOUT_A" encoding="ieee" revbits="no" units="degC" dispfmt="%+6.1f" retain="no" metadata_id="Metadata" plotcolor="pink" comment="RIU:RIU.D_SWEAP_SPAN_B_ELECT_BOX_TEMP" />
;<lrv id="RIU.D_SWEAP_SPAN_B_HIGH_VOLTAGE_COVER_TEMP" name="SWEAP/SPAN-B Top Analyzer Temperature (RIU 3A, Chnl 5)" source="D" type="F" subsystem="THRM" length="32" timeoutLrv="GSW_TIMEOUT_A" encoding="ieee" revbits="no" units="degC" dispfmt="%+6.1f" retain="no" metadata_id="Metadata" plotcolor="pink" comment="RIU:RIU.D_SWEAP_SPAN_B_TOP_ANALYZER_TEMP" />
;<lrv id="RIU.D_SWEAP_SPAN_B_PEDESTAL_RTD_RESISTANCE" name="SWEAP/SPAN-B Pedestal RTD Resistance (RIU 4B, Chnl 6)" source="D" type="F" subsystem="THRM" length="32" timeoutLrv="GSW_TIMEOUT_A" encoding="ieee" revbits="no" units="ohms" dispfmt="%.2f" retain="no" metadata_id="Metadata" plotcolor="pink" comment="RIU:RIU.D_SWEAP_SPAN_B_PEDESTAL_RTD_RESISTANCE" />
;<lrv id="RIU.D_SWEAP_SPAN_B_PEDESTAL_TEMP" name="SWEAP/SPAN-B Pedestal Temperature (RIU 4B, Chnl 6)" source="D" type="F" subsystem="THRM" length="32" timeoutLrv="GSW_TIMEOUT_A" encoding="ieee" revbits="no" units="degC" dispfmt="%+6.1f" retain="no" metadata_id="Metadata" plotcolor="pink" comment="RIU:RIU.D_SWEAP_SPAN_B_PEDESTAL_TEMP" />
;<lrv id="RIU.D_SWEAP_SPAN_B_TOP_ANALYZER_RTD_RESISTANCE" name="SWEAP/SPAN-B Top Analyzer RTD Resistance (RIU 3A, Chnl 5)" source="D" type="F" subsystem="THRM" length="32" timeoutLrv="GSW_TIMEOUT_A" encoding="ieee" revbits="no" units="ohms" dispfmt="%.2f" retain="no" metadata_id="Metadata" plotcolor="pink" comment="RIU:RIU.D_SWEAP_SPAN_B_TOP_ANALYZER_RTD_RESISTANCE" />
;<lrv id="RIU.D_SWEAP_SPAN_B_TOP_ANALYZER_TEMP" name="SWEAP/SPAN-B Top Analyzer Temperature (RIU 3A, Chnl 5)" source="D" type="F" subsystem="THRM" length="32" timeoutLrv="GSW_TIMEOUT_A" encoding="ieee" revbits="no" units="degC" dispfmt="%+6.1f" retain="no" metadata_id="Metadata" plotcolor="pink" comment="RIU:RIU.D_SWEAP_SPAN_B_TOP_ANALYZER_TEMP" />
;<lrv id="RIU.D_SWEAP_SPC_PRE_AMP_RTD_RESISTANCE" name="SWEAP/SPC Pre-amp RTD Resistance (RIU 5A, Chnl 9)" source="D" type="F" subsystem="THRM" length="32" timeoutLrv="GSW_TIMEOUT_A" encoding="ieee" revbits="no" units="ohms" dispfmt="%.2f" retain="no" metadata_id="Metadata" plotcolor="pink" comment="RIU:RIU.D_SWEAP_SPC_PRE_AMP_RTD_RESISTANCE" />
;<lrv id="RIU.D_SWEAP_SPC_PRE_AMP_TEMP" name="SWEAP/SPC Pre-amp Temperature (RIU 5A, Chnl 9)" source="D" type="F" subsystem="THRM" length="32" timeoutLrv="GSW_TIMEOUT_A" encoding="ieee" revbits="no" units="degC" dispfmt="%+6.1f" retain="no" metadata_id="Metadata" plotcolor="pink" comment="RIU:RIU.D_SWEAP_SPC_PRE_AMP_TEMP" />
;<lrv id="RIU.D_SWEAP_SWEM_RTD_RESISTANCE" name="SWEAP/SWEM (On Panel) RTD Resistance (RIU 8B, Chnl 3)" source="D" type="F" subsystem="THRM" length="32" timeoutLrv="GSW_TIMEOUT_A" encoding="ieee" revbits="no" units="ohms" dispfmt="%.2f" retain="no" metadata_id="Metadata" plotcolor="pink" comment="RIU:RIU.D_SWEAP_SWEM_RTD_RESISTANCE" />
;<lrv id="RIU.D_SWEAP_SWEM_TEMP" name="SWEAP/SWEM (On Panel) Temperature (RIU 8B, Chnl 3)" source="D" type="F" subsystem="THRM" length="32" timeoutLrv="GSW_TIMEOUT_A" encoding="ieee" revbits="no" units="degC" dispfmt="%+6.1f" retain="no" metadata_id="Metadata" plotcolor="pink" comment="RIU:RIU.D_SWEAP_SWEM_TEMP" />

;Line 13125:     RIU_DERIVED_D_SWEAP_SPAN_B_ELECT_BOX_TEMP,                    136,    7,   16;
;Line 13128:     RIU_DERIVED_D_SWEAP_SPAN_B_TOP_ANALYZER_TEMP,                 142,    7,   16;
;Line 13145:     RIU_DERIVED_D_SWEAP_SPAN_A_POS_TOP_ANALYZER_TEMP,             176,    7,   16;
;Line 13174:     RIU_DERIVED_D_SWEAP_SPAN_B_PEDESTAL_TEMP,                     234,    7,   16;
;Line 13189:     RIU_DERIVED_D_SWEAP_SPAN_A_POS_ELECT_BOX_TEMP,                264,    7,   16;
;Line 13192:     RIU_DERIVED_D_SWEAP_SPC_PRE_AMP_TEMP,                         270,    7,   16;
;Line 13205:     RIU_DERIVED_D_SWEAP_SPAN_A_POS_PEDESTAL_TEMP,                 296,    7,   16;
;Line 13265:     RIU_DERIVED_D_SWEAP_SWEM_TEMP,                                416,    7,   16;
;Line 320: EU(Raw='SC_HK_0x1DE.RIU_DERIVED_D_SWEAP_SPAN_B_ELECT_BOX_TEMP') := fCalCurve([0.0, 65535.0], [-200.0, 300.0], Raw)
;Line 323: EU(Raw='SC_HK_0x1DE.RIU_DERIVED_D_SWEAP_SPAN_B_TOP_ANALYZER_TEMP') := fCalCurve([0.0, 65535.0], [-200.0, 300.0], Raw)
;Line 340: EU(Raw='SC_HK_0x1DE.RIU_DERIVED_D_SWEAP_SPAN_A_POS_TOP_ANALYZER_TEMP') := fCalCurve([0.0, 65535.0], [-200.0, 300.0], Raw)
;Line 369: EU(Raw='SC_HK_0x1DE.RIU_DERIVED_D_SWEAP_SPAN_B_PEDESTAL_TEMP') := fCalCurve([0.0, 65535.0], [-200.0, 300.0], Raw)
;Line 384: EU(Raw='SC_HK_0x1DE.RIU_DERIVED_D_SWEAP_SPAN_A_POS_ELECT_BOX_TEMP') := fCalCurve([0.0, 65535.0], [-200.0, 300.0], Raw)
;Line 387: EU(Raw='SC_HK_0x1DE.RIU_DERIVED_D_SWEAP_SPC_PRE_AMP_TEMP') := fCalCurve([0.0, 65535.0], [-200.0, 300.0], Raw)
;Line 400: EU(Raw='SC_HK_0x1DE.RIU_DERIVED_D_SWEAP_SPAN_A_POS_PEDESTAL_TEMP') := fCalCurve([0.0, 65535.0], [-200.0, 300.0], Raw)
;Line 460: EU(Raw='SC_HK_0x1DE.RIU_DERIVED_D_SWEAP_SWEM_TEMP') := fCalCurve([0.0, 65535.0], [-200.0, 300.0], Raw)


function SPP_SC_HK_0x256_apdat::decom,ccsds, source_dict=source_dict   ;,ptp_header=ptp_header

  ccsds_data = spp_swp_ccsds_data(ccsds)
  str2 = spp_SC_HK_0x256_struct(ccsds_data)
  struct_assign,ccsds,str2,/nozero
  return,str2

end


pro spp_SC_HK_0x256_apdat__define

  void = {spp_SC_HK_0x256_apdat, $
    inherits spp_gen_apdat, $    ; superclass
    flag: 0 $
  }
end
;
;#
;# SC_HK_0x256
;#
;SC_HK_0x256
;{
;( Block[2396],                                                     ,     ,    8; )
;HK_LOW_TPPH_VERSION,                                            0,    7,    3;
;HK_LOW_TPPH_TYPE,                                               0,    4,    1;
;HK_LOW_TPPH_SEC_HDR_FLAG,                                       0,    3,    1;
;HK_LOW_TPPH_APID,                                               0,    2,   11;
;SC_D_APID,                                                      0,    2,   11;
;HK_LOW_TPPH_SEQ_FLAGS,                                          2,    7,    2;
;HK_LOW_TPPH_SEQ_CNT,                                            2,    5,   14;
;HK_LOW_TPPH_LENGTH,                                             4,    7,   16;
;HK_LOW_TPSH_MET_SEC,                                            6,    7,   32;
;SC_D_MET_SEC,                                                   6,    7,   32;
;HK_LOW_TPSH_MET_SUBSEC,                                        10,    7,    8;
;HK_LOW_TPSH_SBC_PHYS_ID,                                       11,    7,    2;
;SBC_RIO_TPPH_VERSION,                                           0,    7,    3;
;SBC_RIO_TPPH_TYPE,                                              0,    4,    1;
;SBC_RIO_TPPH_SEC_HDR_FLAG,                                      0,    3,    1;
;SBC_RIO_TPPH_APID,                                              0,    2,   11;
;SC_D_APID_DUP0,                                                 0,    2,   11;
;SBC_RIO_TPPH_SEQ_FLAGS,                                         2,    7,    2;
;SBC_RIO_TPPH_SEQ_CNT,                                           2,    5,   14;
;SBC_RIO_TPPH_LENGTH,                                            4,    7,   16;
;SBC_RIO_TPSH_MET_SEC,                                           6,    7,   32;
;SC_D_MET_SEC_DUP1,                                              6,    7,   32;
;SBC_RIO_TPSH_MET_SUBSEC,                                       10,    7,    8;
;SBC_RIO_TPSH_SBC_PHYS_ID,                                      11,    7,    2;
;FSW_GC_HK_HK_TDT,                                              12,    7,   64;
;FSW_GC_HK_HK_SC_EPH_TIME_TO_EXPIRE,                            20,    7,   32;
;FSW_GC_HK_HK_EARTH_EPH_TIME_TO_EXPIRE,                         24,    7,   32;
;FSW_GC_HK_HK_VENUS_EPH_TIME_TO_EXPIRE,                         28,    7,   32;
;FSW_GC_HK_HK_NUM_SWITCH_PAST_GND_RESET,                        32,    7,   32;
;FSW_GC_HK_HK_SC_X_TO_EARTH1,                                   36,    7,    8;
;FSW_GC_HK_HK_DIST_BODY_TO_SUN,                                 37,    7,   32;
;FSW_GC_HK_HK_DV_INERTIAL0,                                     41,    7,   32;
;FSW_GC_HK_HK_DV_INERTIAL1,                                     45,    7,   32;
;FSW_GC_HK_HK_DV_INERTIAL2,                                     49,    7,   32;
;FSW_GC_HK_HK_THRUSTER_MASK0,                                   53,    7,    8;
;FSW_GC_HK_HK_THRUSTER_MASK1,                                   54,    7,    8;
;FSW_GC_HK_HK_THRUSTER_MASK2,                                   55,    7,    8;
;FSW_GC_HK_HK_THRUSTER_MASK3,                                   56,    7,    8;
;FSW_GC_HK_HK_THRUSTER_MASK4,                                   57,    7,    8;
;FSW_GC_HK_HK_THRUSTER_MASK5,                                   58,    7,    8;
;FSW_GC_HK_HK_THRUSTER_MASK6,                                   59,    7,    8;
;FSW_GC_HK_HK_THRUSTER_MASK7,                                   60,    7,    8;
;FSW_GC_HK_HK_THRUSTER_MASK8,                                   61,    7,    8;
;FSW_GC_HK_HK_THRUSTER_MASK9,                                   62,    7,    8;
;FSW_GC_HK_HK_THRUSTER_MASK10,                                  63,    7,    8;
;FSW_GC_HK_HK_THRUSTER_MASK11,                                  64,    7,    8;
;RIU_1A_TAC_RIU_PP,                                             65,    7,    1;
;PUMP_A_5HZ0_MOTOR_ST,                                          65,    6,    1;
;PUMP_A_MOTOR_ST,                                               65,    6,    1;
;PUMP_A_5HZ0_COMMANDED_MOTOR_SPEED,                             65,    5,   16;
;PUMP_A_COMMANDED_MOTOR_SPEED,                                  65,    5,   16;
;PUMP_A_5HZ0_LAST_BAD_CMD_OPCODE,                               67,    5,    8;
;PUMP_A_LAST_BAD_CMD_OPCODE,                                    67,    5,    8;
;PUMP_A_5HZ0_LAST_BAD_CMD_DATA_BYTE_1,                          68,    5,    8;
;PUMP_A_LAST_BAD_CMD_DATA_BYTE_1,                               68,    5,    8;
;PUMP_A_5HZ0_LAST_BAD_CMD_DATA_BYTE_2,                          69,    5,    8;
;PUMP_A_LAST_BAD_CMD_DATA_BYTE_2,                               69,    5,    8;
;PUMP_A_5HZ0_LAST_BAD_CMD_DATA_BYTE_3,                          70,    5,    8;
;PUMP_A_LAST_BAD_CMD_DATA_BYTE_3,                               70,    5,    8;
;PUMP_A_5HZ0_LAST_BAD_CMD_DATA_BYTE_4,                          71,    5,    8;
;PUMP_A_LAST_BAD_CMD_DATA_BYTE_4,                               71,    5,    8;
;PUMP_A_5HZ0_LAST_BAD_CMD_DATA_BYTE_5,                          72,    5,    8;
;PUMP_A_LAST_BAD_CMD_DATA_BYTE_5,                               72,    5,    8;
;PUMP_A_5HZ0_LAST_BAD_CMD_XOR,                                  73,    5,   16;
;PUMP_A_LAST_BAD_CMD_XOR,                                       73,    5,   16;
;PUMP_A_5HZ0_LAST_GOOD_CMD_OPCODE,                              75,    5,    8;
;PUMP_A_LAST_GOOD_CMD_OPCODE,                                   75,    5,    8;
;PUMP_A_5HZ0_LAST_GOOD_CMD_DATA_BYTE_1,                         76,    5,    8;
;PUMP_A_LAST_GOOD_CMD_DATA_BYTE_1,                              76,    5,    8;
;PUMP_A_5HZ0_LAST_GOOD_CMD_DATA_BYTE_2,                         77,    5,    8;
;PUMP_A_LAST_GOOD_CMD_DATA_BYTE_2,                              77,    5,    8;
;PUMP_A_5HZ0_LAST_GOOD_CMD_DATA_BYTE_3,                         78,    5,    8;
;PUMP_A_LAST_GOOD_CMD_DATA_BYTE_3,                              78,    5,    8;
;PUMP_A_5HZ0_LAST_GOOD_CMD_DATA_BYTE_4,                         79,    5,    8;
;PUMP_A_LAST_GOOD_CMD_DATA_BYTE_4,                              79,    5,    8;
;PUMP_A_5HZ0_LAST_GOOD_CMD_DATA_BYTE_5,                         80,    5,    8;
;PUMP_A_LAST_GOOD_CMD_DATA_BYTE_5,                              80,    5,    8;
;PUMP_A_5HZ0_LAST_GOOD_CMD_XOR,                                 81,    5,   16;
;PUMP_A_LAST_GOOD_CMD_XOR,                                      81,    5,   16;
;PUMP_A_5HZ0_RESET_COMMANDED,                                   83,    5,    1;
;PUMP_A_RESET_COMMANDED,                                        83,    5,    1;
;PUMP_A_5HZ0_SYSTEM_RESET,                                      83,    4,    1;
;PUMP_A_SYSTEM_RESET,                                           83,    4,    1;
;PUMP_B_5HZ0_MOTOR_ST,                                          83,    3,    1;
;PUMP_B_MOTOR_ST,                                               83,    3,    1;
;PUMP_B_5HZ0_COMMANDED_MOTOR_SPEED,                             83,    2,   16;
;PUMP_B_COMMANDED_MOTOR_SPEED,                                  83,    2,   16;
;PUMP_B_5HZ0_LAST_BAD_CMD_OPCODE,                               85,    2,    8;
;PUMP_B_LAST_BAD_CMD_OPCODE,                                    85,    2,    8;
;PUMP_B_5HZ0_LAST_BAD_CMD_DATA_BYTE_1,                          86,    2,    8;
;PUMP_B_LAST_BAD_CMD_DATA_BYTE_1,                               86,    2,    8;
;PUMP_B_5HZ0_LAST_BAD_CMD_DATA_BYTE_2,                          87,    2,    8;
;PUMP_B_LAST_BAD_CMD_DATA_BYTE_2,                               87,    2,    8;
;PUMP_B_5HZ0_LAST_BAD_CMD_DATA_BYTE_3,                          88,    2,    8;
;PUMP_B_LAST_BAD_CMD_DATA_BYTE_3,                               88,    2,    8;
;PUMP_B_5HZ0_LAST_BAD_CMD_DATA_BYTE_4,                          89,    2,    8;
;PUMP_B_LAST_BAD_CMD_DATA_BYTE_4,                               89,    2,    8;
;PUMP_B_5HZ0_LAST_BAD_CMD_DATA_BYTE_5,                          90,    2,    8;
;PUMP_B_LAST_BAD_CMD_DATA_BYTE_5,                               90,    2,    8;
;PUMP_B_5HZ0_LAST_BAD_CMD_XOR,                                  91,    2,   16;
;PUMP_B_LAST_BAD_CMD_XOR,                                       91,    2,   16;
;PUMP_B_5HZ0_LAST_GOOD_CMD_OPCODE,                              93,    2,    8;
;PUMP_B_LAST_GOOD_CMD_OPCODE,                                   93,    2,    8;
;PUMP_B_5HZ0_LAST_GOOD_CMD_DATA_BYTE_1,                         94,    2,    8;
;PUMP_B_LAST_GOOD_CMD_DATA_BYTE_1,                              94,    2,    8;
;PUMP_B_5HZ0_LAST_GOOD_CMD_DATA_BYTE_2,                         95,    2,    8;
;PUMP_B_LAST_GOOD_CMD_DATA_BYTE_2,                              95,    2,    8;
;PUMP_B_5HZ0_LAST_GOOD_CMD_DATA_BYTE_3,                         96,    2,    8;
;PUMP_B_LAST_GOOD_CMD_DATA_BYTE_3,                              96,    2,    8;
;PUMP_B_5HZ0_LAST_GOOD_CMD_DATA_BYTE_4,                         97,    2,    8;
;PUMP_B_LAST_GOOD_CMD_DATA_BYTE_4,                              97,    2,    8;
;PUMP_B_5HZ0_LAST_GOOD_CMD_DATA_BYTE_5,                         98,    2,    8;
;PUMP_B_LAST_GOOD_CMD_DATA_BYTE_5,                              98,    2,    8;
;PUMP_B_5HZ0_LAST_GOOD_CMD_XOR,                                 99,    2,   16;
;PUMP_B_LAST_GOOD_CMD_XOR,                                      99,    2,   16;
;PUMP_B_5HZ0_RESET_COMMANDED,                                  101,    2,    1;
;PUMP_B_RESET_COMMANDED,                                       101,    2,    1;
;PUMP_B_5HZ0_SYSTEM_RESET,                                     101,    1,    1;
;PUMP_B_SYSTEM_RESET,                                          101,    1,    1;
;RIU_C1_SACS_ACCUM_LV,                                         101,    0,    1;
;RIU_C1_CSPR23_UP_LV_ST,                                       102,    7,    1;
;RIU_C1_CSPR23_DOWN_LV_ST,                                     102,    6,    1;
;RIU_1A_CH2_COUNTS,                                            102,    5,   10;
;RIU_1A_CH4_COUNTS,                                            103,    3,   10;
;RIU_1A_CH5_COUNTS,                                            104,    1,   10;
;RIU_1A_CH8_COUNTS,                                            106,    7,   10;
;RIU_1A_CH11_COUNTS,                                           107,    5,   10;
;RIU_1B_CH7_COUNTS,                                            108,    3,   10;
;RIU_1B_CH10_COUNTS,                                           109,    1,   10;
;RIU_1B_CH11_COUNTS,                                           111,    7,   10;
;RIU_2A_CH11_COUNTS,                                           112,    5,   10;
;RIU_2B_CH11_COUNTS,                                           113,    3,   10;
;RIU_2B_CH12_COUNTS,                                           114,    1,   10;
;RIU_2B_CH13_COUNTS,                                           116,    7,   10;
;RIU_6A_CH8_COUNTS,                                            117,    5,   10;
;RIU_6A_CH10_COUNTS,                                           118,    3,   10;
;RIU_6B_CH1_COUNTS,                                            119,    1,   10;
;RIU_6B_CH2_COUNTS,                                            121,    7,   10;
;RIU_6B_CH7_COUNTS,                                            122,    5,   10;
;RIU_2A_CH10_COUNTS,                                           123,    3,   10;
;RIU_2A_CH4_COUNTS,                                            124,    1,   10;
;RIU_2B_CH6_COUNTS,                                            126,    7,   10;
;RIU_3A_CH1_COUNTS,                                            127,    5,   10;
;RIU_3A_CH2_COUNTS,                                            128,    3,   10;
;RIU_3A_CH3_COUNTS,                                            129,    1,   10;
;RIU_3A_CH4_COUNTS,                                            131,    7,   10;
;RIU_3A_CH5_COUNTS,                                            132,    5,   10;
;RIU_3B_CH14_COUNTS,                                           133,    3,   10;
;RIU_4A_CH7_COUNTS,                                            134,    1,   10;
;RIU_4A_CH8_COUNTS,                                            136,    7,   10;
;RIU_4A_CH10_COUNTS,                                           137,    5,   10;
;RIU_4A_CH11_COUNTS,                                           138,    3,   10;
;RIU_4B_CH10_COUNTS,                                           139,    1,   10;
;RIU_4B_CH11_COUNTS,                                           141,    7,   10;
;RIU_6A_CH2_COUNTS,                                            142,    5,   10;
;RIU_6A_CH3_COUNTS,                                            143,    3,   10;
;RIU_7A_CH1_COUNTS,                                            144,    1,   10;
;RIU_7A_CH2_COUNTS,                                            146,    7,   10;
;RIU_7A_CH4_COUNTS,                                            147,    5,   10;
;RIU_7B_CH1_COUNTS,                                            148,    3,   10;
;RIU_7B_CH3_COUNTS,                                            149,    1,   10;
;RIU_7B_CH4_COUNTS,                                            151,    7,   10;
;RIU_8A_CH3_COUNTS,                                            152,    5,   10;
;RIU_8A_CH6_COUNTS,                                            153,    3,   10;
;RIU_8A_CH7_COUNTS,                                            154,    1,   10;
;RIU_8B_CH2_COUNTS,                                            156,    7,   10;
;RIU_8B_CH3_COUNTS,                                            157,    5,   10;
;RIU_8B_CH5_COUNTS,                                            158,    3,   10;
;RIU_8B_CH6_COUNTS,                                            159,    1,   10;
;PDU_CMD_A_PAR_ERR_CNT,                                        161,    7,    6;
;PDU_CMD_A_FRAME_ERR_CNT,                                      161,    1,    6;
;PDU_CMD_A_OVER_ERR_CNT,                                       162,    3,    6;
;PDU_CMD_A_CRC_ERR_CNT,                                        163,    5,    6;
;PDU_CMD_A_CMD_TO_CNT,                                         164,    7,    6;
;PDU_CMD_A_DURING_SEQ_CNT,                                     164,    1,    6;
;PDU_CMD_A_READ_CMD_ERR_CNT,                                   165,    3,    6;
;PDU_CMD_A_I2C_BUS_ERR_CNT,                                    166,    5,    6;
;PDU_CMD_A_VAL_CMD_CNT,                                        167,    7,   16;
;PDU_TLM_RQST_CNT,                                             169,    7,   16;
;PDU_BRDG_VAL_CMD_CNT,                                         171,    7,   16;
;PDU_SEQ_VAL_CMD_CNT,                                          173,    7,   16;
;PDU_FIRST_ERR_STATUS_FLAGS_A1,                                175,    7,    4;
;PDU_PAR_FIRST_ERR_A_FLAG,                                     175,    3,    1;
;PDU_FRAME_FIRST_ERR_A_FLAG,                                   175,    2,    1;
;PDU_OVER_FIRST_ERR_A_FLAG,                                    175,    1,    1;
;PDU_CRC_FIRST_ERR_A_FLAG,                                     175,    0,    1;
;PDU_ALL_ERR_STATUS_FLAGS_A1,                                  176,    7,    4;
;PDU_PAR_ERR_A_FLAG,                                           176,    3,    1;
;PDU_FRAME_ERR_A_FLAG,                                         176,    2,    1;
;PDU_OVER_ERR_A_FLAG,                                          176,    1,    1;
;PDU_CRC_ERR_A_FLAG,                                           176,    0,    1;
;PDU_FIRST_ERR_STATUS_FLAGS_A0,                                177,    7,    4;
;PDU_TO_FIRST_ERR_A_FLAG,                                      177,    3,    1;
;PDU_CMD_SEQ_FIRST_ERR_A_FLAG,                                 177,    2,    1;
;PDU_READ_FIRST_ERR_A_FLAG,                                    177,    1,    1;
;PDU_I2C_FIRST_ERR_A_FLAG,                                     177,    0,    1;
;PDU_ALL_ERR_STATUS_FLAGS_A0,                                  178,    7,    4;
;PDU_TO_ERR_A_FLAG,                                            178,    3,    1;
;PDU_CMD_SEQ_ERR_A_FLAG,                                       178,    2,    1;
;PDU_READ_ERR_A_FLAG,                                          178,    1,    1;
;PDU_I2C_ERR_A_FLAG,                                           178,    0,    1;
;PDU_SEQ_RUNNING_FLAGS,                                        179,    7,    8;
;PDU_POR_SEQ_RUNNING_FLAG,                                     180,    7,    1;
;PDU_SEQ_INH_FLAGS_LOW,                                        180,    6,    4;
;PDU_POR_SEQ_INH_FLAG,                                         180,    2,    1;
;PDU_SEP_3_STATUS,                                             180,    1,    1;
;PDU_SEP_2_STATUS,                                             180,    0,    1;
;PDU_SEP_1_STATUS,                                             181,    7,    1;
;PDU_SEP_0_STATUS,                                             181,    6,    1;
;PDU_BOARD_ID,                                                 181,    5,    3;
;PDU_I2C_ADDR_CRC_ERR_CNT,                                     181,    2,    6;
;PDU_SEQ_CRC_ERR_CNT,                                          182,    4,    4;
;PDU_I2C_ERR_CNT,                                              182,    0,    4;
;PDU_SEQ_FAILS_REG,                                            183,    4,    1;
;PDU_CMD_A_INV_CMD_CNT,                                        183,    3,    8;
;PDU_BRDG_INV_CMD_CNT,                                         184,    3,    8;
;PDU_SEQ_INV_CMD_CNT,                                          185,    3,    8;
;PDU_I2C_LASTCMD_BYT1_VAL,                                     186,    3,    8;
;PDU_I2C_LASTCMD_BYT2_VAL,                                     187,    3,    8;
;PDU_I2C_LASTCMD_BYT3_VAL,                                     188,    3,    8;
;PDU_POR_SEQ_DONE,                                             189,    3,    1;
;RADIOA_PHYSICAL_ID,                                           189,    2,    4;
;RADIOA_LOGICAL_ID,                                            190,    6,    4;
;RADIOA_STATUS_BOOT_STATUS,                                    190,    2,   16;
;RADIOA_STATUS_RADIO_ID,                                       192,    2,   24;
;RADIOA_STATUS_RX_1_SYM_PHASE_INJECT_MET,                      195,    2,   32;
;RADIOA_STATUS_RX_1_SYM_PHASE_INJECT_CNT,                      199,    2,   32;
;RADIOA_STATUS_RX_1_NB_PWR,                                    203,    2,   32;
;RADIOA_STATUS_RX_1_NB_PWR_MET,                                207,    2,   32;
;RADIOA_STATUS_RX_1_SYM_PHASE_INJECT_ARM,                      211,    2,    1;
;RADIOA_STATUS_RX_1_NB_PWR_WEAK_SIG_SWCH_CNT,                  211,    1,   12;
;RADIOA_STATUS_RX_1_NB_PWR_STRONG_SIG_SWCH_CNT,                213,    5,   12;
;RADIOA_STATUS_RX_1_SYM_PHASE_INJECT_SYM_CNT,                  214,    1,    8;
;RADIOA_STATUS_RX_1_NB_PWR_LOW_SIDE_THRSHLD,                   215,    1,   32;
;RADIOA_STATUS_RX_1_NB_PWR_HIGH_SIDE_THRSHLD,                  219,    1,   32;
;RADIOA_STATUS_SCRUB_EXT_SRAM_ENA,                             223,    1,    1;
;RADIOA_STATUS_SCRUB_REG_ENA,                                  223,    0,    1;
;RADIOA_STATUS_RX_1_SYM_PHASE_INJECT_ENA,                      224,    7,    1;
;RADIOA_STATUS_MODC_TLM_BB_ENA,                                224,    6,    1;
;RADIOA_STATUS_RX_1_BB_CMD_ENA_OVERRIDE,                       224,    5,    1;
;RADIOA_STATUS_SPW_NODE_STATUS,                                224,    4,   16;
;RADIOA_STATUS_DSP_SPW_TRANSACTION_3_ID,                       226,    4,   16;
;RADIOA_STATUS_DSP_SPW_TRANSACTION_2_ID,                       228,    4,   16;
;RADIOA_STATUS_DSP_SPW_TRANSACTION_1_ID,                       230,    4,   16;
;RADIOA_STATUS_DSP_SPW_TRANSACTION_0_ID,                       232,    4,   16;
;RADIOA_STATUS_SW_PEAK_POKE_ADDR,                              234,    4,   32;
;RADIOA_STATUS_MODC_CAL_TBL,                                   238,    4,    4;
;RADIOA_STATUS_EX_1_VOLT_POS2P5_REF,                           238,    0,   12;
;RADIOA_STATUS_EX_1_VOLT_POS1P8,                               240,    4,   12;
;RADIOA_STATUS_EX_1_VOLT_POS3P3,                               241,    0,   12;
;RADIOA_STATUS_EX_1_HW_REV,                                    243,    4,   12;
;RADIOA_STATUS_EX_1_VOLT_NEG5,                                 244,    0,   12;
;RADIOA_STATUS_EX_1_VOLT_POS5,                                 246,    4,   12;
;RADIOA_STATUS_EX_1_VOLT_POS4P6,                               247,    0,   12;
;RADIOA_STATUS_EX_2_VOLT_POS2P5_REF,                           249,    4,   12;
;RADIOA_STATUS_EX_2_VOLT_POS1P8,                               250,    0,   12;
;RADIOA_STATUS_EX_2_VOLT_POS3P3,                               252,    4,   12;
;RADIOA_STATUS_EX_2_HW_REV,                                    253,    0,   12;
;RADIOA_STATUS_EX_2_VOLT_NEG5,                                 255,    4,   12;
;RADIOA_STATUS_EX_2_VOLT_POS5,                                 256,    0,   12;
;RADIOA_STATUS_EX_2_VOLT_POS4P6,                               258,    4,   12;
;RADIOA_STATUS_SW_PEAK_POKE_VAL,                               259,    0,   32;
;RADIOA_STATUS_RX_1_HW_REV,                                    263,    0,   12;
;RADIOA_STATUS_RX_1_VOLT_NEG5,                                 265,    4,   12;
;RADIOA_STATUS_RX_1_VOLT_POS1P8,                               266,    0,   12;
;RADIOA_STATUS_RX_1_VOLT_POS2P5_REF,                           268,    4,   12;
;RADIOA_STATUS_RX_1_VOLT_POS3P3,                               269,    0,   12;
;RADIOA_STATUS_RX_1_VOLT_POS5,                                 271,    4,   12;
;RADIOA_STATUS_DSP_BOOT_IMAGE,                                 272,    0,    2;
;RADIOA_STATUS_DSP_HW_REV,                                     273,    6,   12;
;RADIOA_STATUS_DSP_VOLT_POS1P8_DAC,                            274,    2,   12;
;RADIOA_STATUS_DSP_TIME_SYNC,                                  276,    6,    1;
;RADIOA_STATUS_DSP_SPI_STATUS,                                 276,    5,    1;
;RADIOA_STATUS_DSP_VOLT_POS2P5_FPGA,                           276,    4,   12;
;RADIOA_STATUS_DSP_VOLT_POS2P5_REF,                            277,    0,   12;
;RADIOA_STATUS_DSP_VOLT_POS3_PLL,                              279,    4,   12;
;RADIOA_STATUS_DSP_VOLT_SRAM,                                  280,    0,   12;
;RADIOA_STATUS_DSP_TEMP,                                       282,    4,   12;
;RADIOA_STATUS_PWR_CONV_TEMP,                                  283,    0,   12;
;RADIOA_STATUS_DSP_VOLT_POS1P5,                                285,    4,   12;
;RADIOA_STATUS_MODC_MOD_INDEX,                                 286,    0,   16;
;RADIOA_STATUS_MODC_RNG_MOD_INDEX_GAIN,                        288,    0,   32;
;RADIOA_STATUS_MODC_RNG_MOD_INDEX_LIMIT,                       292,    0,   32;
;RADIOA_STATUS_RX_1_MID_PHASE_DIFF_THRSHLD,                    296,    0,   32;
;RADIOA_STATUS_RX_1_SYM_PHASE_INJECT_AMP,                      300,    0,   32;
;RADIOB_PHYSICAL_ID,                                           304,    0,    4;
;RADIOB_LOGICAL_ID,                                            305,    4,    4;
;RADIOB_STATUS_BOOT_STATUS,                                    305,    0,   16;
;RADIOB_STATUS_RADIO_ID,                                       307,    0,   24;
;RADIOB_STATUS_RX_1_SYM_PHASE_INJECT_MET,                      310,    0,   32;
;RADIOB_STATUS_RX_1_SYM_PHASE_INJECT_CNT,                      314,    0,   32;
;RADIOB_STATUS_RX_1_NB_PWR,                                    318,    0,   32;
;RADIOB_STATUS_RX_1_NB_PWR_MET,                                322,    0,   32;
;RADIOB_STATUS_RX_1_SYM_PHASE_INJECT_ARM,                      326,    0,    1;
;RADIOB_STATUS_RX_1_NB_PWR_WEAK_SIG_SWCH_CNT,                  327,    7,   12;
;RADIOB_STATUS_RX_1_NB_PWR_STRONG_SIG_SWCH_CNT,                328,    3,   12;
;RADIOB_STATUS_RX_1_SYM_PHASE_INJECT_SYM_CNT,                  330,    7,    8;
;RADIOB_STATUS_RX_1_NB_PWR_LOW_SIDE_THRSHLD,                   331,    7,   32;
;RADIOB_STATUS_RX_1_NB_PWR_HIGH_SIDE_THRSHLD,                  335,    7,   32;
;RADIOB_STATUS_SCRUB_EXT_SRAM_ENA,                             339,    7,    1;
;RADIOB_STATUS_SCRUB_REG_ENA,                                  339,    6,    1;
;RADIOB_STATUS_RX_1_SYM_PHASE_INJECT_ENA,                      339,    5,    1;
;RADIOB_STATUS_MODC_TLM_BB_ENA,                                339,    4,    1;
;RADIOB_STATUS_RX_1_BB_CMD_ENA_OVERRIDE,                       339,    3,    1;
;RADIOB_STATUS_SPW_NODE_STATUS,                                339,    2,   16;
;RADIOB_STATUS_DSP_SPW_TRANSACTION_3_ID,                       341,    2,   16;
;RADIOB_STATUS_DSP_SPW_TRANSACTION_2_ID,                       343,    2,   16;
;RADIOB_STATUS_DSP_SPW_TRANSACTION_1_ID,                       345,    2,   16;
;RADIOB_STATUS_DSP_SPW_TRANSACTION_0_ID,                       347,    2,   16;
;RADIOB_STATUS_SW_PEAK_POKE_ADDR,                              349,    2,   32;
;RADIOB_STATUS_MODC_CAL_TBL,                                   353,    2,    4;
;RADIOB_STATUS_EX_1_VOLT_POS2P5_REF,                           354,    6,   12;
;RADIOB_STATUS_EX_1_VOLT_POS1P8,                               355,    2,   12;
;RADIOB_STATUS_EX_1_VOLT_POS3P3,                               357,    6,   12;
;RADIOB_STATUS_EX_1_HW_REV,                                    358,    2,   12;
;RADIOB_STATUS_EX_1_VOLT_NEG5,                                 360,    6,   12;
;RADIOB_STATUS_EX_1_VOLT_POS5,                                 361,    2,   12;
;RADIOB_STATUS_EX_1_VOLT_POS4P6,                               363,    6,   12;
;RADIOB_STATUS_EX_2_VOLT_POS2P5_REF,                           364,    2,   12;
;RADIOB_STATUS_EX_2_VOLT_POS1P8,                               366,    6,   12;
;RADIOB_STATUS_EX_2_VOLT_POS3P3,                               367,    2,   12;
;RADIOB_STATUS_EX_2_HW_REV,                                    369,    6,   12;
;RADIOB_STATUS_EX_2_VOLT_NEG5,                                 370,    2,   12;
;RADIOB_STATUS_EX_2_VOLT_POS5,                                 372,    6,   12;
;RADIOB_STATUS_EX_2_VOLT_POS4P6,                               373,    2,   12;
;RADIOB_STATUS_SW_PEAK_POKE_VAL,                               375,    6,   32;
;RADIOB_STATUS_RX_1_HW_REV,                                    379,    6,   12;
;RADIOB_STATUS_RX_1_VOLT_NEG5,                                 380,    2,   12;
;RADIOB_STATUS_RX_1_VOLT_POS1P8,                               382,    6,   12;
;RADIOB_STATUS_RX_1_VOLT_POS2P5_REF,                           383,    2,   12;
;RADIOB_STATUS_RX_1_VOLT_POS3P3,                               385,    6,   12;
;RADIOB_STATUS_RX_1_VOLT_POS5,                                 386,    2,   12;
;RADIOB_STATUS_DSP_BOOT_IMAGE,                                 388,    6,    2;
;RADIOB_STATUS_DSP_HW_REV,                                     388,    4,   12;
;RADIOB_STATUS_DSP_VOLT_POS1P8_DAC,                            389,    0,   12;
;RADIOB_STATUS_DSP_TIME_SYNC,                                  391,    4,    1;
;RADIOB_STATUS_DSP_SPI_STATUS,                                 391,    3,    1;
;RADIOB_STATUS_DSP_VOLT_POS2P5_FPGA,                           391,    2,   12;
;RADIOB_STATUS_DSP_VOLT_POS2P5_REF,                            393,    6,   12;
;RADIOB_STATUS_DSP_VOLT_POS3_PLL,                              394,    2,   12;
;RADIOB_STATUS_DSP_VOLT_SRAM,                                  396,    6,   12;
;RADIOB_STATUS_DSP_TEMP,                                       397,    2,   12;
;RADIOB_STATUS_PWR_CONV_TEMP,                                  399,    6,   12;
;RADIOB_STATUS_DSP_VOLT_POS1P5,                                400,    2,   12;
;RADIOB_STATUS_MODC_MOD_INDEX,                                 402,    6,   16;
;RADIOB_STATUS_MODC_RNG_MOD_INDEX_GAIN,                        404,    6,   32;
;RADIOB_STATUS_MODC_RNG_MOD_INDEX_LIMIT,                       408,    6,   32;
;RADIOB_STATUS_RX_1_MID_PHASE_DIFF_THRSHLD,                    412,    6,   32;
;RADIOB_STATUS_RX_1_SYM_PHASE_INJECT_AMP,                      416,    6,   32;
;RADIOA_STATUS_EX_1_TEMP,                                      420,    6,   12;
;RADIOA_STATUS_EX_2_TEMP,                                      421,    2,   12;
;RADIOB_STATUS_EX_1_TEMP,                                      423,    6,   12;
;RADIOB_STATUS_EX_2_TEMP,                                      424,    2,   12;
;PSE_5HZ_MF1_A_SA_SCE_POSY_1_1_VOC_A,                          426,    6,   16;
;PSE_A_SA_SCE_POSY_1_1_VOC,                                    426,    6,   16;
;PSE_5HZ_MF1_A_SA_SCE_POSY_2_1_VOC_A,                          428,    6,   16;
;PSE_A_SA_SCE_POSY_2_1_VOC,                                    428,    6,   16;
;PSE_5HZ_MF1_A_SA_SCE_NEGY_1_1_VOC_A,                          430,    6,   16;
;PSE_A_SA_SCE_NEGY_1_1_VOC,                                    430,    6,   16;
;PSE_5HZ_MF1_A_SA_SCE_NEGY_2_1_VOC_A,                          432,    6,   16;
;PSE_A_SA_SCE_NEGY_2_1_VOC,                                    432,    6,   16;
;PSE_5HZ_MF1_A_SA_SCE_POSY_1_2_VOC_A,                          434,    6,   16;
;PSE_A_SA_SCE_POSY_1_2_VOC,                                    434,    6,   16;
;PSE_5HZ_MF1_A_SA_SCE_POSY_2_2_VOC_A,                          436,    6,   16;
;PSE_A_SA_SCE_POSY_2_2_VOC,                                    436,    6,   16;
;PSE_5HZ_MF1_A_SA_SCE_NEGY_1_2_VOC_A,                          438,    6,   16;
;PSE_A_SA_SCE_NEGY_1_2_VOC,                                    438,    6,   16;
;PSE_5HZ_MF1_A_SA_SCE_NEGY_2_2_VOC_A,                          440,    6,   16;
;PSE_A_SA_SCE_NEGY_2_2_VOC,                                    440,    6,   16;
;PSE_5HZ_MF1_A_PP,                                             442,    6,   32;
;PSE_A_PP,                                                     442,    6,   32;
;PSE_5HZ_MF1_A_SA_VOLT_SET_PT,                                 446,    6,   32;
;PSE_A_SA_VOLT_SET_PT,                                         446,    6,   32;
;PSE_1HZ_MF5_A_MBJB_BOARD_TEMP_A,                              450,    6,   16;
;PSE_A_MBJB_BOARD_TEMP,                                        450,    6,   16;
;PSE_1HZ_MF5_A_BCB4_RELAY_STATUS,                              452,    6,    1;
;PSE_A_BCB4_RELAY_STATUS,                                      452,    6,    1;
;PSE_1HZ_MF5_A_BCB3_RELAY_STATUS,                              452,    5,    1;
;PSE_A_BCB3_RELAY_STATUS,                                      452,    5,    1;
;PSE_1HZ_MF5_A_BCB2_RELAY_STATUS,                              452,    4,    1;
;PSE_A_BCB2_RELAY_STATUS,                                      452,    4,    1;
;PSE_1HZ_MF5_A_BCB1_RELAY_STATUS,                              452,    3,    1;
;PSE_A_BCB1_RELAY_STATUS,                                      452,    3,    1;
;PSE_1HZ_MF8_A_SAJB_MAIN_BOARD_TEMP_A,                         452,    2,   16;
;PSE_A_SAJB_MAIN_BOARD_TEMP,                                   452,    2,   16;
;PSE_1HZ_MF8_A_SAJB_SCE_BOARD_TEMP_A,                          454,    2,   16;
;PSE_A_SAJB_SCE_BOARD_TEMP,                                    454,    2,   16;
;PSE_1HZ_MF11_A_BCB1_TEMP,                                     456,    2,   16;
;PSE_A_BCB1_TEMP,                                              456,    2,   16;
;PSE_1HZ_MF11_A_BCB2_TEMP,                                     458,    2,   16;
;PSE_A_BCB2_TEMP,                                              458,    2,   16;
;PSE_1HZ_MF11_A_BCB3_TEMP,                                     460,    2,   16;
;PSE_A_BCB3_TEMP,                                              460,    2,   16;
;PSE_1HZ_MF11_A_BCB4_TEMP,                                     462,    2,   16;
;PSE_A_BCB4_TEMP,                                              462,    2,   16;
;PSE_1HZ_MF11_A_ICL_LOCAL_TEMP,                                464,    2,   16;
;PSE_A_ICL_LOCAL_TEMP,                                         464,    2,   16;
;PSE_1HZ_MF11_A_ICL_REMOTE_TEMP,                               466,    2,   16;
;PSE_A_ICL_REMOTE_TEMP,                                        466,    2,   16;
;PSE_1HZ_MF11_A_BATT_CHRG_CURR_LIMIT_SET_PT,                   468,    2,   32;
;PSE_A_BATT_CHRG_CURR_LIMIT_SET_PT,                            468,    2,   32;
;PSE_1HZ_MF11_A_BATT_VOLT_LIMIT_SET_PT,                        472,    2,   32;
;PSE_A_BATT_VOLT_LIMIT_SET_PT,                                 472,    2,   32;
;PSE_1HZ_MF11_A_ACTIVE_MON_IF_STATUS,                          476,    2,    1;
;PSE_A_ACTIVE_MON_IF_STATUS,                                   476,    2,    1;
;PSE_1HZ_MF11_A_CMD_REJ_VAL_CNTR,                              476,    1,    8;
;PSE_A_CMD_REJ_VAL_CNTR,                                       476,    1,    8;
;PSE_1HZ_MF11_A_BAD_CMD_CNTR,                                  477,    1,    8;
;PSE_A_BAD_CMD_CNTR,                                           477,    1,    8;
;PSE_5HZ_MF1_B_SA_SCE_POSY_1_1_VOC_B,                          478,    1,   16;
;PSE_B_SA_SCE_POSY_1_1_VOC,                                    478,    1,   16;
;PSE_5HZ_MF1_B_SA_SCE_POSY_2_1_VOC_B,                          480,    1,   16;
;PSE_B_SA_SCE_POSY_2_1_VOC,                                    480,    1,   16;
;PSE_5HZ_MF1_B_SA_SCE_NEGY_1_1_VOC_B,                          482,    1,   16;
;PSE_B_SA_SCE_NEGY_1_1_VOC,                                    482,    1,   16;
;PSE_5HZ_MF1_B_SA_SCE_NEGY_2_1_VOC_B,                          484,    1,   16;
;PSE_B_SA_SCE_NEGY_2_1_VOC,                                    484,    1,   16;
;PSE_5HZ_MF1_B_SA_SCE_POSY_1_2_VOC_B,                          486,    1,   16;
;PSE_B_SA_SCE_POSY_1_2_VOC,                                    486,    1,   16;
;PSE_5HZ_MF1_B_SA_SCE_POSY_2_2_VOC_B,                          488,    1,   16;
;PSE_B_SA_SCE_POSY_2_2_VOC,                                    488,    1,   16;
;PSE_5HZ_MF1_B_SA_SCE_NEGY_1_2_VOC_B,                          490,    1,   16;
;PSE_B_SA_SCE_NEGY_1_2_VOC,                                    490,    1,   16;
;PSE_5HZ_MF1_B_SA_SCE_NEGY_2_2_VOC_B,                          492,    1,   16;
;PSE_B_SA_SCE_NEGY_2_2_VOC,                                    492,    1,   16;
;PSE_5HZ_MF1_B_PP,                                             494,    1,   32;
;PSE_B_PP,                                                     494,    1,   32;
;PSE_5HZ_MF1_B_SA_VOLT_SET_PT,                                 498,    1,   32;
;PSE_B_SA_VOLT_SET_PT,                                         498,    1,   32;
;PSE_1HZ_MF5_B_MBJB_BOARD_TEMP_B,                              502,    1,   16;
;PSE_B_MBJB_BOARD_TEMP,                                        502,    1,   16;
;PSE_1HZ_MF5_B_BCB4_RELAY_STATUS,                              504,    1,    1;
;PSE_B_BCB4_RELAY_STATUS,                                      504,    1,    1;
;PSE_1HZ_MF5_B_BCB3_RELAY_STATUS,                              504,    0,    1;
;PSE_B_BCB3_RELAY_STATUS,                                      504,    0,    1;
;PSE_1HZ_MF5_B_BCB2_RELAY_STATUS,                              505,    7,    1;
;PSE_B_BCB2_RELAY_STATUS,                                      505,    7,    1;
;PSE_1HZ_MF5_B_BCB1_RELAY_STATUS,                              505,    6,    1;
;PSE_B_BCB1_RELAY_STATUS,                                      505,    6,    1;
;PSE_1HZ_MF8_B_SAJB_MAIN_BOARD_TEMP_B,                         505,    5,   16;
;PSE_B_SAJB_MAIN_BOARD_TEMP,                                   505,    5,   16;
;PSE_1HZ_MF8_B_SAJB_SCE_BOARD_TEMP_B,                          507,    5,   16;
;PSE_B_SAJB_SCE_BOARD_TEMP,                                    507,    5,   16;
;PSE_1HZ_MF11_B_BCB1_TEMP,                                     509,    5,   16;
;PSE_B_BCB1_TEMP,                                              509,    5,   16;
;PSE_1HZ_MF11_B_BCB2_TEMP,                                     511,    5,   16;
;PSE_B_BCB2_TEMP,                                              511,    5,   16;
;PSE_1HZ_MF11_B_BCB3_TEMP,                                     513,    5,   16;
;PSE_B_BCB3_TEMP,                                              513,    5,   16;
;PSE_1HZ_MF11_B_BCB4_TEMP,                                     515,    5,   16;
;PSE_B_BCB4_TEMP,                                              515,    5,   16;
;PSE_1HZ_MF11_B_ICL_LOCAL_TEMP,                                517,    5,   16;
;PSE_B_ICL_LOCAL_TEMP,                                         517,    5,   16;
;PSE_1HZ_MF11_B_ICL_REMOTE_TEMP,                               519,    5,   16;
;PSE_B_ICL_REMOTE_TEMP,                                        519,    5,   16;
;PSE_1HZ_MF11_B_BATT_CHRG_CURR_LIMIT_SET_PT,                   521,    5,   32;
;PSE_B_BATT_CHRG_CURR_LIMIT_SET_PT,                            521,    5,   32;
;PSE_1HZ_MF11_B_BATT_VOLT_LIMIT_SET_PT,                        525,    5,   32;
;PSE_B_BATT_VOLT_LIMIT_SET_PT,                                 525,    5,   32;
;PSE_1HZ_MF11_B_ACTIVE_MON_IF_STATUS,                          529,    5,    1;
;PSE_B_ACTIVE_MON_IF_STATUS,                                   529,    5,    1;
;PSE_1HZ_MF11_B_CMD_REJ_VAL_CNTR,                              529,    4,    8;
;PSE_B_CMD_REJ_VAL_CNTR,                                       529,    4,    8;
;PSE_1HZ_MF11_B_BAD_CMD_CNTR,                                  530,    4,    8;
;PSE_B_BAD_CMD_CNTR,                                           530,    4,    8;
;FSW_GC_HK_HK_CUMM_CMD_STEPS0,                                 531,    4,   32;
;FSW_GC_HK_HK_CUMM_CMD_STEPS1,                                 535,    4,   32;
;FSW_GC_HK_HK_CUMM_CMD_STEPS2,                                 539,    4,   32;
;FSW_GC_HK_HK_CUMM_CMD_STEPS3,                                 543,    4,   32;
;FSW_GC_HK_HK_CUMM_CMD_STEPS4,                                 547,    4,   32;
;FSW_GC_HK_HK_SMSA_ISC_THRESH,                                 551,    4,   16;
;FSW_GC_HK_HK_SMSA_FLAP_ANGLE,                                 553,    4,   16;
;FSW_GC_HK_HK_ECU_POT_ANG_AVG0,                                555,    4,   16;
;FSW_GC_HK_HK_ECU_POT_ANG_AVG1,                                557,    4,   16;
;FSW_GC_HK_HK_ECU_POT_ANG_AVG2,                                559,    4,   16;
;FSW_GC_HK_HK_ECU_POT_ANG_AVG3,                                561,    4,   16;
;FSW_GC_HK_HK_ECU_POT_ANG_AVG4,                                563,    4,   16;
;FSW_GC_HK_HK_BATTERY_SOC_DOT,                                 565,    4,   16;
;FSW_GC_HK_HK_BATT_VOLT_LIMIT_SET_PT_CMD,                      567,    4,   16;
;FSW_GC_HK_HK_SMSA_OVERTEMP_THRESH,                            569,    4,    8;
;FSW_GC_HK_HK_ECU_POT_ANG_AVG_VALID0,                          570,    4,    8;
;FSW_GC_HK_HK_ECU_POT_ANG_AVG_VALID1,                          571,    4,    8;
;FSW_GC_HK_HK_ECU_POT_ANG_AVG_VALID2,                          572,    4,    8;
;FSW_GC_HK_HK_ECU_POT_ANG_AVG_VALID3,                          573,    4,    8;
;FSW_GC_HK_HK_ECU_POT_ANG_AVG_VALID4,                          574,    4,    8;
;FSW_GC_HK_HK_BATT_VOLT_LIMIT_SET_PT_ENABLE,                   575,    4,    8;
;HS_FSW_SPP_HK_ONVM_MET_SEC_OF_RECENT_PROMOTION0,              576,    4,   32;
;FSW_CM_HK_MACRO_LOAD_FAIL_CNT,                                580,    4,   16;
;FSW_CM_HK_MACRO_LD_FAIL_CNT,                                  580,    4,   16;
;FSW_CM_HK_MACRO_LOAD_RAM_CNT,                                 582,    4,   16;
;FSW_CM_HK_MACRO_LD_RAM_CNT,                                   582,    4,   16;
;FSW_AUT_HK_RULE_FIRED_SENT_MSG_CNT,                           584,    4,   16;
;FSW_AUT_HK_RULE_COMPLETE_RCV_MSG_CNT,                         586,    4,   16;
;FSW_AUT_HK_RULE_ABORT_RCV_MSG_CNT,                            588,    4,   16;
;FSW_AUT_HK_RULES_LOAD_NV_MEM_CNT,                             590,    4,   16;
;FSW_AUT_HK_CT_LOAD_NVM_CNT,                                   592,    4,   16;
;FSW_AUT_HK_SV_LOAD_NVM_CNT,                                   594,    4,   16;
;FSW_AUT_SV000_AUT_SYS_VERSION_NUM[4],                         596,    4,    8;
;FSW_AUT_SV001_MISSION_PHASE,                                  600,    4,   32;
;FSW_AUT_SV002_CSPR23_ACTIVATED_FLAG,                          604,    4,   32;
;FSW_AUT_STOR_VAR_VALUE30,                                     608,    4,   32;
;FSW_AUT_SV053_PREFERRED_ST,                                   612,    4,   32;
;FSW_AUT_SV070_RADIOA_RESET_SRC,                               616,    4,    8;
;FSW_AUT_SV071_RADIOB_RESET_SRC,                               617,    4,    8;
;FSW_AUT_SV072_SAVED_SCIF_OSC_FREQ_CNTR,                       618,    4,   32;
;FSW_AUT_SV073_SAVED_EMXO_A_FREQ_CNTR,                         622,    4,   32;
;FSW_AUT_SV074_SAVED_EMXO_B_FREQ_CNTR,                         626,    4,   32;
;FSW_AUT_SV075_SAVED_GC_ECU_ERR_CODE,                          630,    4,   32;
;FSW_AUT_SV076_SAVED_GC_PSE_ERR_CODE,                          634,    4,   32;
;FSW_AUT_SV100_POST_SEP_COMPLETE_FLAG,                         638,    4,   32;
;FSW_AUT_STOR_VAR_VALUE101,                                    642,    4,   32;
;FSW_AUT_SV104_EPIHI_WARMUP_MODE_FLAG,                         646,    4,   32;
;FSW_AUT_SV105_EPILO_WARMUP_MODE_FLAG,                         650,    4,   32;
;FSW_AUT_SV106_WISPR_SEC_CHANCE_EVENT_CNT,                     654,    4,   32;
;FSW_AUT_SV107_FIELDS1_SEC_CHANCE_EVENT_CNT,                   658,    4,   32;
;FSW_AUT_SV108_FIELDS2_SEC_CHANCE_EVENT_CNT,                   662,    4,   32;
;FSW_AUT_SV109_SWEAP_SEC_CHANCE_EVENT_CNT,                     666,    4,   32;
;FSW_AUT_SV110_EPIHI_SEC_CHANCE_EVENT_CNT,                     670,    4,   32;
;FSW_AUT_SV111_EPILO_SEC_CHANCE_EVENT_CNT,                     674,    4,   32;
;FSW_AUT_SV112_WISPR_OPER_HTR_OVER_CONDUCTANCE_FAIL_CNT,       678,    4,   32;
;FSW_AUT_SV113_EPILO_PWR_CYCLE_REQ_CNT,                        682,    4,   32;
;FSW_AUT_SV118_EPIHI_OPER_HTR_OVER_CONDUCTANCE_FAIL_CNT,       686,    4,   32;
;FSW_AUT_SV122_X_BAND_EXCITER_ENA_FLAG,                        690,    4,   32;
;FSW_AUT_SV123_KA_BAND_EXCITER_ENA_FLAG,                       694,    4,   32;
;FSW_AUT_SV124_LAST_SELECTED_EMXO,                             698,    4,   32;
;FSW_AUT_SV125_TRANSMITING_IN_OP_MODE_LEVEL_3_FLAG,            702,    4,   32;
;FSW_AUT_SV126_RF_SIDE_SWCH_REQ_FLAG,                          706,    4,   32;
;FSW_AUT_SV127_PWR_OFF_PRI_RADIO_FLAG,                         710,    4,   32;
;FSW_AUT_SV133_REM_SIDE_SWCH_REQ_FLAG,                         714,    4,   32;
;FSW_AUT_SV134_GLOBAL_SWCH_REQ_FLAG,                           718,    4,   32;
;FSW_AUT_STOR_VAR_VALUE135,                                    722,    4,   32;
;FSW_AUT_SV136_SAFE_STB_EA_STARTING_SC_MODE,                   726,    4,   32;
;FSW_AUT_SV137_SAFE_EA_STARTING_SC_MODE,                       730,    4,   32;
;FSW_AUT_SV138_SAFE_EA_CFG,                                    734,    4,   32;
;FSW_AUT_SV139_SAFE_EA_HOLD_FLAG,                              738,    4,   32;
;FSW_AUT_SV140_SAFE_EA_HOLD_START_MET,                         742,    4,   32;
;FSW_AUT_SV141_SEP_MET,                                        746,    4,   32;
;FSW_AUT_SV142_LIFTOFF_IMMINENT_MET,                           750,    4,   32;
;FSW_AUT_SV144_CSPR14_WARMUP_MET,                              754,    4,   32;
;FSW_AUT_SV146_SAFE_SA_ENTRY_MET,                              758,    4,   32;
;FSW_AUT_SV147_OP_MODE_LEVEL_2_BEACON_TONE,                    762,    4,   32;
;FSW_AUT_SV148_OP_MODE_LEVEL_2_STARTING_SC_MODE,               766,    4,   32;
;FSW_AUT_SV151_PUMP_A_OVERCURR_FAULT_CNT,                      770,    4,   32;
;FSW_AUT_SV152_PUMP_A_BEMF_FAULT_CNT,                          774,    4,   32;
;FSW_AUT_SV153_PUMP_A_HYBRID_ENA_FAULT_CNT,                    778,    4,   32;
;FSW_AUT_SV154_PUMP_B_OVERCURR_FAULT_CNT,                      782,    4,   32;
;FSW_AUT_SV155_PUMP_B_BEMF_FAULT_CNT,                          786,    4,   32;
;FSW_AUT_SV156_PUMP_B_HYBRID_ENA_FAULT_CNT,                    790,    4,   32;
;FSW_AUT_SV157_LAST_PUMP_SPEED_CMD,                            794,    4,   32;
;FSW_AUT_SV158_MET_OF_LAST_PUMP_SPEED_CMD,                     798,    4,   32;
;FSW_AUT_SV159_POSY_SA_DEPLOY_CUTOFF_MET,                      802,    4,   32;
;FSW_AUT_SV160_NEGY_SA_DEPLOY_CUTOFF_MET,                      806,    4,   32;
;FSW_AUT_SV163_POST_SEP_SEQ_ACTIVITY,                          810,    4,   32;
;FSW_AUT_SV164_PREV_POST_SEP_SEQ_ACTIVITY,                     814,    4,   32;
;FSW_AUT_SV166_MONITOR_CSPR14_TEMPS_FLAG,                      818,    4,   32;
;FSW_AUT_SV167_MONITOR_SA_PLATEN_TEMPS_FLAG,                   822,    4,   32;
;FSW_AUT_SV168_SA_PLATEN_LAUNCH_LOCKS_STARTED,                 826,    4,   32;
;FSW_AUT_SV169_SA_BOOM_LAUNCH_LOCKS_STARTED,                   830,    4,   32;
;FSW_AUT_SV170_BYPASS_PUMP_HEALTH_CHECKS_FLAG,                 834,    4,   32;
;FSW_AUT_SV172_RESPONSE_TIER_SCIF_MET_RESYNC,                  838,    4,   32;
;FSW_AUT_SV173_RESPONSE_TIER_RED_RADIO,                        842,    4,   32;
;FSW_AUT_SV174_RESPONSE_TIER_WHEELS,                           846,    4,   32;
;FSW_AUT_SV175_RESPONSE_TIER_IMU,                              850,    4,   32;
;FSW_AUT_SV176_RESPONSE_TIER_ST1_STALE_TLM,                    854,    4,   32;
;FSW_AUT_SV177_RESPONSE_TIER_ST2_STALE_TLM,                    858,    4,   32;
;FSW_AUT_SV178_RESPONSE_TIER_ST_CONCURRENT_STALE_TLM,          862,    4,   32;
;FSW_AUT_SV179_RESPONSE_TIER_ST_STALE_TLM,                     866,    4,   32;
;FSW_AUT_SV180_RESPONSE_TIER_ST1_UNHEALTHY,                    870,    4,   32;
;FSW_AUT_SV181_RESPONSE_TIER_ST2_UNHEALTHY,                    874,    4,   32;
;FSW_AUT_SV182_RESPONSE_TIER_SSE_A_STALE_TLM,                  878,    4,   32;
;FSW_AUT_SV183_RESPONSE_TIER_SSE_B_STALE_TLM,                  882,    4,   32;
;FSW_AUT_SV184_RESPONSE_TIER_SSE_CONCURRENT_STALE_TLM,         886,    4,   32;
;FSW_AUT_SV185_RESPONSE_TIER_SSE_STALE_TLM,                    890,    4,   32;
;FSW_AUT_SV188_RESPONSE_TIER_PRI_RADIO,                        894,    4,   32;
;FSW_AUT_SV190_RESPONSE_TIER_ECU_STALE_TLM,                    898,    4,   32;
;FSW_AUT_SV192_RESPONSE_TIER_PSE,                              902,    4,   32;
;FSW_AUT_SV193_RESPONSE_TIER_PSE_NOT_IN_NORM_MODE,             906,    4,   32;
;FSW_AUT_SV194_RESPONSE_TIER_TWTA_X,                           910,    4,   32;
;FSW_AUT_SV195_RESPONSE_TIER_TWTA_KA,                          914,    4,   32;
;FSW_AUT_SV196_RESPONSE_TIER_REM_STALE_TLM,                    918,    4,   32;
;FSW_AUT_SV197_RESPONSE_TIER_TAC_STALE_TLM,                    922,    4,   32;
;FSW_AUT_SV198_RESPONSE_TIER_RIU_STALE_TLM,                    926,    4,   32;
;FSW_AUT_SV199_RESPONSE_TIER_SCIF_STALE_TLM,                   930,    4,   32;
;FSW_AUT_SV207_SA_DEPLOY_PRI_SEC_FLAG,                         934,    4,   32;
;FSW_AUT_STOR_VAR_LOAD_FAIL_CNT,                               938,    4,   32;
;FSW_AUT_CT017_PSE_SA_PRT_POSY_PRI_ABOVE_WARMUP_LIM_CNT,       942,    4,   32;
;FSW_AUT_CT018_PSE_SA_PRT_POSY_SEC_ABOVE_WARMUP_LIM_CNT,       946,    4,   32;
;FSW_AUT_CT019_PSE_SA_PRT_NEGY_PRI_ABOVE_WARMUP_LIM_CNT,       950,    4,   32;
;FSW_AUT_CT020_PSE_SA_PRT_NEGY_SEC_ABOVE_WARMUP_LIM_CNT,       954,    4,   32;
;FSW_AUT_CT023_PSE_BUS_VOLT_AT_PDU,                            958,    4,   32;
;FSW_AUT_COMP_TLM_VALUE87,                                     962,    4,   32;
;FSW_AUT_CT088_SMSA_CSPR_UNDER_TEMP_CLR_CNT,                   966,    4,   32;
;FSW_AUT_CT089_SMSA_LOW_SA_FLUX_CLR_CNT,                       970,    4,   32;
;FSW_AUT_CT090_SMSA_GC_SKI_ATT_VIOLATION_CLR_CNT,              974,    4,   32;
;FSW_AUT_CT105_PRIME_MET_MINUS_SCIF_MET,                       978,    4,   32;
;FSW_AUT_CT106_HOT_SPARE_MET_MINUS_PRIME_MET,                  982,    4,   32;
;FSW_AUT_CT107_BACKUP_SPARE_MET_MINUS_PRIME_MET,               986,    4,   32;
;FSW_AUT_CT108_HOT_SPARE_MET_MINUS_SCIF_MET,                   990,    4,   32;
;FSW_AUT_CT109_BACKUP_SPARE_MET_MINUS_SCIF_MET,                994,    4,   32;
;FSW_AUT_CT110_WARMEST_CHECK_VALVE_TEMP,                       998,    4,   32;
;FSW_AUT_CT111_BCB1_INPUT_CURR_OUT_OF_SPEC,                   1002,    4,   32;
;FSW_AUT_CT112_BCB2_INPUT_CURR_OUT_OF_SPEC,                   1006,    4,   32;
;FSW_AUT_CT113_BCB3_INPUT_CURR_OUT_OF_SPEC,                   1010,    4,   32;
;FSW_AUT_CT114_BCB4_INPUT_CURR_OUT_OF_SPEC,                   1014,    4,   32;
;FSW_AUT_CT115_BCB1_OUTPUT_CURR_OUT_OF_SPEC,                  1018,    4,   32;
;FSW_AUT_CT116_BCB2_OUTPUT_CURR_OUT_OF_SPEC,                  1022,    4,   32;
;FSW_AUT_CT117_BCB3_OUTPUT_CURR_OUT_OF_SPEC,                  1026,    4,   32;
;FSW_AUT_CT118_BCB4_OUTPUT_CURR_OUT_OF_SPEC,                  1030,    4,   32;
;FSW_AUT_CT119_ALL_BCB_OUTPUT_CURR_NOM,                       1034,    4,   32;
;FSW_AUT_CT120_WARMEST_EPILO_TEMP,                            1038,    4,   32;
;FSW_AUT_CT121_COLDEST_EPIHI_TEMP,                            1042,    4,   32;
;FSW_AUT_CT122_COLDEST_EPILO_TEMP,                            1046,    4,   32;
;FSW_AUT_CT123_WARMEST_EPIHI_TEMP,                            1050,    4,   32;
;FSW_AUT_CT130_NUM_BCB_ONLINE,                                1054,    4,   32;
;FSW_AUT_CT132_BCB1_TLM_STALE,                                1058,    4,   32;
;FSW_AUT_CT133_BCB2_TLM_STALE,                                1062,    4,   32;
;FSW_AUT_CT134_BCB3_TLM_STALE,                                1066,    4,   32;
;FSW_AUT_CT135_BCB4_TLM_STALE,                                1070,    4,   32;
;FSW_AUT_COMP_TLM_VALUE139,                                   1074,    4,   32;
;FSW_AUT_COMP_TLM_VALUE140,                                   1078,    4,   32;
;FSW_AUT_CT141_NUM_ECU_ACTR_IN_MOTION,                        1082,    4,   32;
;FSW_AUT_CT145_LIFTOFF_UMB_ST,                                1086,    4,   32;
;FSW_AUT_CT146_LIFTOFF_BATT_DISCHRG_ST,                       1090,    4,   32;
;FSW_AUT_CT147_LIFTOFF_IMMINENT_RELAY_ST,                     1094,    4,   32;
;FSW_AUT_CT200_PRIMARY_PDU_FPGA_TLM_ACTIVE,                   1098,    4,   32;
;FSW_AUT_CT201_PRIMARY_PDU_PRIO_TLM_ACTIVE,                   1102,    4,   32;
;FSW_AUT_CT202_PRIMARY_PDU_TLM_ACTIVE,                        1106,    4,   32;
;FSW_AUT_CT203_PRIMARY_SCIF_TLM_ACTIVE,                       1110,    4,   32;
;FSW_AUT_CT204_PRIMARY_TAC_TLM_ACTIVE,                        1114,    4,   32;
;FSW_AUT_CT205_PRIMARY_RADIO_TLM_ACTIVE,                      1118,    4,   32;
;FSW_AUT_CT206_REDUNDANT_RADIO_TLM_ACTIVE,                    1122,    4,   32;
;FSW_AUT_CT207_PRIMARY_ECU_TLM_ACTIVE,                        1126,    4,   32;
;FSW_AUT_CT208_PRIMARY_PUMP_TLM_ACTIVE,                       1130,    4,   32;
;FSW_AUT_CT211_PRIMARY_PSE_TLM_ACTIVE,                        1134,    4,   32;
;FSW_AUT_CT215_PRIMARY_REM_TLM_ACTIVE,                        1138,    4,   32;
;FSW_AUT_CT216_BACKUP_SPARE_TLM_ACTIVE,                       1142,    4,   32;
;FSW_AUT_CT219_PRIME_MET_AGREES_WITH_BACKUP_SPARE,            1146,    4,   32;
;FSW_AUT_CT220_BACKUP_SPARE_MET_AGREES_WITH_SCIF,             1150,    4,   32;
;FSW_AUT_CT239_BUS_VOLT,                                      1154,    4,   32;
;FSW_AUT_CT240_SOLAR_DIST,                                    1158,    4,   32;
;FSW_AUT_CT241_SCIF_OSC_FREQ_CNTR,                            1162,    4,   32;
;FSW_AUT_CT242_EMXO_A_FREQ_CNTR,                              1166,    4,   32;
;FSW_AUT_CT243_EMXO_B_FREQ_CNTR,                              1170,    4,   32;
;FSW_AUT_CT244_EMXO_A_MINUS_SCIF_OSC_FREQ_CNTS,               1174,    4,   32;
;FSW_AUT_CT245_EMXO_B_MINUS_SCIF_OSC_FREQ_CNTS,               1178,    4,   32;
;FSW_AUT_CT247_PRIME_MET_AGREES_WITH_SCIF,                    1182,    4,   32;
;FSW_AUT_CT248_PRIME_MET_AGREES_WITH_HOT_SPARE,               1186,    4,   32;
;FSW_AUT_CT249_HOT_SPARE_MET_AGREES_WITH_SCIF,                1190,    4,   32;
;FSW_AUT_CT250_PRIME_UP_TIME,                                 1194,    4,   32;
;FSW_AUT_CT251_TWTA_X_A_OFF_TIME,                             1198,    4,   32;
;FSW_AUT_CT252_TWTA_X_B_OFF_TIME,                             1202,    4,   32;
;FSW_AUT_CT253_TWTA_KA_A_OFF_TIME,                            1206,    4,   32;
;FSW_AUT_CT254_TWTA_KA_B_OFF_TIME,                            1210,    4,   32;
;FSW_AUT_CT255_PROCESSOR_OVERCYCLING_FLAG,                    1214,    4,   32;
;FSW_AUT_CT256_SAFE_EA_TARGET_CFG,                            1218,    4,   32;
;FSW_AUT_CT257_SAFE_EA_HOLD_COUNTDOWN,                        1222,    4,   32;
;FSW_AUT_CT258_PRIMARY_ECU_EXCESS_PWR_LIMIT,                  1226,    4,   32;
;FSW_AUT_CT260_BACKUP_SPARE_ON_TIME,                          1230,    4,   32;
;FSW_AUT_CT287_RIU_1A_HEALTHY,                                1234,    4,   32;
;FSW_AUT_CT288_RIU_2A_HEALTHY,                                1238,    4,   32;
;FSW_AUT_CT289_RIU_3A_HEALTHY,                                1242,    4,   32;
;FSW_AUT_CT290_RIU_4A_HEALTHY,                                1246,    4,   32;
;FSW_AUT_CT291_RIU_5A_HEALTHY,                                1250,    4,   32;
;FSW_AUT_CT292_RIU_6A_HEALTHY,                                1254,    4,   32;
;FSW_AUT_CT293_RIU_7A_HEALTHY,                                1258,    4,   32;
;FSW_AUT_CT294_RIU_8A_HEALTHY,                                1262,    4,   32;
;FSW_AUT_CT295_RIU_1B_HEALTHY,                                1266,    4,   32;
;FSW_AUT_CT296_RIU_2B_HEALTHY,                                1270,    4,   32;
;FSW_AUT_CT297_RIU_3B_HEALTHY,                                1274,    4,   32;
;FSW_AUT_CT298_RIU_4B_HEALTHY,                                1278,    4,   32;
;FSW_AUT_CT299_RIU_5B_HEALTHY,                                1282,    4,   32;
;FSW_AUT_CT300_RIU_6B_HEALTHY,                                1286,    4,   32;
;FSW_AUT_CT301_RIU_7B_HEALTHY,                                1290,    4,   32;
;FSW_AUT_CT302_RIU_8B_HEALTHY,                                1294,    4,   32;
;FSW_AUT_CT305_SCIF_OSC_FREQ_AGREES_WITH_PRI_EMXO,            1298,    4,   32;
;FSW_AUT_CT306_SCIF_OSC_FREQ_AGREES_WITH_RED_EMXO,            1302,    4,   32;
;FSW_AUT_CT331_MCA_VAL_CMD_CNT_HIST,                          1306,    4,   32;
;FSW_AUT_CT332_MCB_VAL_CMD_CNT_HIST,                          1310,    4,   32;
;FSW_AUT_CT333_MCC_VAL_CMD_CNT_HIST,                          1314,    4,   32;
;FSW_AUT_CT334_CSPR14_TEMPS_BELOW_BATT_RECHRG_CSPR_COLD_LIMIT_CNT, 1318,    4,   32;
;FSW_AUT_CT335_CSPR23_TEMPS_BELOW_BATT_RECHRG_CSPR_COLD_LIMIT_CNT, 1322,    4,   32;
;FSW_AUT_CT338_RADIO_A_TLM_ERR_PRESENT,                       1326,    4,   32;
;FSW_AUT_CT339_RADIO_B_TLM_ERR_PRESENT,                       1330,    4,   32;
;FSW_AUT_CT340_ALLOW_SMSA_LSOC,                               1334,    4,   32;
;FSW_AUT_CT341_ALLOW_SMSA_CSPR_UNDER_TEMP,                    1338,    4,   32;
;FSW_AUT_CT342_ALLOW_SMSA_LOW_SA_FLUX,                        1342,    4,   32;
;FSW_AUT_CT343_ALLOW_SMSA_GC_SKI_ATT_VIOLATION,               1346,    4,   32;
;FSW_AUT_CT349_CSPR14_TEMPS_ABOVE_BATT_RECHRG_CSPR_WARM_LIMIT_CNT, 1350,    4,   32;
;FSW_AUT_CT350_CSPR23_TEMPS_ABOVE_BATT_RECHRG_CSPR_WARM_LIMIT_CNT, 1354,    4,   32;
;FSW_AUT_COMP_TLM_LOAD_FAIL_CNT,                              1358,    4,   32;
;FSW_AUT_AUT_RULE_TOTAL_TRIGGER_CNT,                          1362,    4,   16;
;FSW_AUT_AUT_RULE_ENA_MASK0,                                  1364,    4,   32;
;FSW_AUT_AUT_RULE_ENA_MASK1,                                  1368,    4,   32;
;FSW_AUT_AUT_RULE_ENA_MASK2,                                  1372,    4,   32;
;FSW_AUT_AUT_RULE_ENA_MASK3,                                  1376,    4,   32;
;FSW_AUT_AUT_RULE_ENA_MASK4,                                  1380,    4,   32;
;FSW_AUT_AUT_RULE_ENA_MASK5,                                  1384,    4,   32;
;FSW_AUT_AUT_RULE_ENA_MASK6,                                  1388,    4,   32;
;FSW_AUT_AUT_RULE_ENA_MASK7,                                  1392,    4,   32;
;FSW_AUT_AUT_RULE_ENA_MASK8,                                  1396,    4,   32;
;FSW_AUT_AUT_RULE_ENA_MASK9,                                  1400,    4,   32;
;FSW_AUT_AUT_RULE_ENA_MASK10,                                 1404,    4,   32;
;FSW_AUT_AUT_RULE_ENA_MASK11,                                 1408,    4,   32;
;FSW_AUT_AUT_RULE_ENA_MASK12,                                 1412,    4,   32;
;FSW_AUT_AUT_RULE_ENA_MASK13,                                 1416,    4,   32;
;FSW_AUT_AUT_RULE_ENA_MASK14,                                 1420,    4,   32;
;FSW_AUT_AUT_RULE_ENA_MASK15,                                 1424,    4,   32;
;FSW_AUT_AUT_RULE_ENA_MASK16,                                 1428,    4,   32;
;FSW_AUT_AUT_RULE_ENA_MASK17,                                 1432,    4,   32;
;FSW_AUT_AUT_RULE_ENA_MASK18,                                 1436,    4,   32;
;FSW_AUT_AUT_RULE_ENA_MASK19,                                 1440,    4,   32;
;FSW_AUT_AUT_RULE_ENA_MASK20,                                 1444,    4,   32;
;FSW_AUT_AUT_RULE_ENA_MASK21,                                 1448,    4,   32;
;FSW_AUT_AUT_RULE_ENA_MASK22,                                 1452,    4,   32;
;FSW_AUT_AUT_RULE_ENA_MASK23,                                 1456,    4,   32;
;FSW_AUT_AUT_RULE_FIRE_MASK0,                                 1460,    4,   32;
;FSW_AUT_AUT_RULE_FIRE_MASK1,                                 1464,    4,   32;
;FSW_AUT_AUT_RULE_FIRE_MASK2,                                 1468,    4,   32;
;FSW_AUT_AUT_RULE_FIRE_MASK3,                                 1472,    4,   32;
;FSW_AUT_AUT_RULE_FIRE_MASK4,                                 1476,    4,   32;
;FSW_AUT_AUT_RULE_FIRE_MASK5,                                 1480,    4,   32;
;FSW_AUT_AUT_RULE_FIRE_MASK6,                                 1484,    4,   32;
;FSW_AUT_AUT_RULE_FIRE_MASK7,                                 1488,    4,   32;
;FSW_AUT_AUT_RULE_FIRE_MASK8,                                 1492,    4,   32;
;FSW_AUT_AUT_RULE_FIRE_MASK9,                                 1496,    4,   32;
;FSW_AUT_AUT_RULE_FIRE_MASK10,                                1500,    4,   32;
;FSW_AUT_AUT_RULE_FIRE_MASK11,                                1504,    4,   32;
;FSW_AUT_AUT_RULE_FIRE_MASK12,                                1508,    4,   32;
;FSW_AUT_AUT_RULE_FIRE_MASK13,                                1512,    4,   32;
;FSW_AUT_AUT_RULE_FIRE_MASK14,                                1516,    4,   32;
;FSW_AUT_AUT_RULE_FIRE_MASK15,                                1520,    4,   32;
;FSW_AUT_AUT_RULE_FIRE_MASK16,                                1524,    4,   32;
;FSW_AUT_AUT_RULE_FIRE_MASK17,                                1528,    4,   32;
;FSW_AUT_AUT_RULE_FIRE_MASK18,                                1532,    4,   32;
;FSW_AUT_AUT_RULE_FIRE_MASK19,                                1536,    4,   32;
;FSW_AUT_AUT_RULE_FIRE_MASK20,                                1540,    4,   32;
;FSW_AUT_AUT_RULE_FIRE_MASK21,                                1544,    4,   32;
;FSW_AUT_AUT_RULE_FIRE_MASK22,                                1548,    4,   32;
;FSW_AUT_AUT_RULE_FIRE_MASK23,                                1552,    4,   32;
;FSW_AUT_AUT_RULE_LOAD_FAIL_CNT,                              1556,    4,   32;
;FSW_AUT_MAINT_STKY_AUT_RULE_NUM0,                            1560,    4,   16;
;FSW_AUT_MAINT_STKY_AUT_RULE_MET0,                            1562,    4,   32;
;FSW_AUT_MAINT_STKY_AUT_RULE_NUM1,                            1566,    4,   16;
;FSW_AUT_MAINT_STKY_AUT_RULE_MET1,                            1568,    4,   32;
;FSW_AUT_MAINT_STKY_AUT_RULE_NUM2,                            1572,    4,   16;
;FSW_AUT_MAINT_STKY_AUT_RULE_MET2,                            1574,    4,   32;
;FSW_AUT_MAINT_STKY_AUT_RULE_NUM3,                            1578,    4,   16;
;FSW_AUT_MAINT_STKY_AUT_RULE_MET3,                            1580,    4,   32;
;FSW_AUT_MAINT_STKY_AUT_RULE_NUM4,                            1584,    4,   16;
;FSW_AUT_MAINT_STKY_AUT_RULE_MET4,                            1586,    4,   32;
;FSW_AUT_MAINT_STKY_AUT_RULE_NUM5,                            1590,    4,   16;
;FSW_AUT_MAINT_STKY_AUT_RULE_MET5,                            1592,    4,   32;
;FSW_SPP_HK_ONVM_MET_SEC_OF_RECENT_PROMOTION0,                1596,    4,   32;
;FSW_SPP_HK_ONVM_MET_SEC_OF_RECENT_PROMOTION1,                1600,    4,   32;
;BS_FSW_SPP_HK_ONVM_MET_SEC_OF_RECENT_PROMOTION0,             1604,    4,   32;
;RIU_8A_CH8_COUNTS,                                           1608,    4,   10;
;RIU_8B_CH7_COUNTS,                                           1609,    2,   10;
;RIU_8A_CH1_COUNTS,                                           1610,    0,   10;
;RIU_8B_CH1_COUNTS,                                           1612,    6,   10;
;RIU_4A_CH6_COUNTS,                                           1613,    4,   10;
;RIU_4B_CH5_COUNTS,                                           1614,    2,   10;
;RIU_5B_CH8_COUNTS,                                           1615,    0,   10;
;RIU_5A_CH8_COUNTS,                                           1617,    6,   10;
;RIU_4A_CH1_COUNTS,                                           1618,    4,   10;
;RIU_4B_CH1_COUNTS,                                           1619,    2,   10;
;RIU_5A_CH1_COUNTS,                                           1620,    0,   10;
;RIU_5B_CH1_COUNTS,                                           1622,    6,   10;
;RIU_4A_CH2_COUNTS,                                           1623,    4,   10;
;RIU_5B_CH2_COUNTS,                                           1624,    2,   10;
;RIU_8A_CH2_COUNTS,                                           1625,    0,   10;
;RIU_4A_CH3_COUNTS,                                           1627,    6,   10;
;RIU_4B_CH2_COUNTS,                                           1628,    4,   10;
;RIU_5A_CH2_COUNTS,                                           1629,    2,   10;
;RIU_5B_CH3_COUNTS,                                           1630,    0,   10;
;RIU_4A_CH4_COUNTS,                                           1632,    6,   10;
;RIU_4B_CH3_COUNTS,                                           1633,    4,   10;
;RIU_5B_CH4_COUNTS,                                           1634,    2,   10;
;RIU_5A_CH3_COUNTS,                                           1635,    0,   10;
;RIU_4B_CH4_COUNTS,                                           1637,    6,   10;
;RIU_4A_CH5_COUNTS,                                           1638,    4,   10;
;RIU_5A_CH4_COUNTS,                                           1639,    2,   10;
;RIU_5B_CH5_COUNTS,                                           1640,    0,   10;
;SCIF_TEST_MBE,                                               1642,    6,    1;
;SCIF_TEST_SIG_SEL,                                           1642,    5,    5;
;SCIF_TEST_PORT_ENA,                                          1642,    0,    1;
;SCIF_UART_ENA,                                               1643,    7,    1;
;SCIF_IMU_BAUD_RATE_SEL,                                      1643,    6,    1;
;SCIF_MODE_SEL,                                               1643,    5,    1;
;SCIF_IMU_TLM_VERNIER_MET_STAMP0,                             1643,    4,   16;
;SCIF_IMU_TLM_BYTE_CNT_160,                                   1645,    4,   16;
;SCIF_IMU_TLM_VERNIER_MET_STAMP1,                             1647,    4,   16;
;SCIF_IMU_TLM_BYTE_CNT_161,                                   1649,    4,   16;
;SCIF_IMU_TLM_VERNIER_MET_STAMP2,                             1651,    4,   16;
;SCIF_IMU_TLM_BYTE_CNT_162,                                   1653,    4,   16;
;SCIF_IMU_TLM_VERNIER_MET_STAMP3,                             1655,    4,   16;
;SCIF_IMU_TLM_BYTE_CNT_163,                                   1657,    4,   16;
;SCIF_IMU_TLM_VERNIER_MET_STAMP4,                             1659,    4,   16;
;SCIF_IMU_TLM_BYTE_CNT_164,                                   1661,    4,   16;
;SCIF_IMU_TLM_VERNIER_MET_STAMP5,                             1663,    4,   16;
;SCIF_IMU_TLM_BYTE_CNT_165,                                   1665,    4,   16;
;SCIF_PSE_TLM_PAR_ERR,                                        1667,    4,    1;
;SCIF_PSE_TLM_BYTE_CNT_16,                                    1667,    3,   16;
;SCIF_PDU_TLM_PAR_ERR,                                        1669,    3,    1;
;SCIF_PDU_TLM_BYTE_CNT_16,                                    1669,    2,   16;
;SCIF_PCA_TLM_PAR_ERR,                                        1671,    2,    1;
;SCIF_PCA_TLM_BYTE_CNT_16,                                    1671,    1,   16;
;SCIF_PCB_TLM_PAR_ERR,                                        1673,    1,    1;
;SCIF_PCB_TLM_BYTE_CNT_16,                                    1673,    0,   16;
;SCIF_ECUA_TLM_PAR_ERR,                                       1675,    0,    1;
;SCIF_ECUA_TLM_BYTE_CNT_16,                                   1676,    7,   16;
;SCIF_ECUB_TLM_PAR_ERR,                                       1678,    7,    1;
;SCIF_ECUB_TLM_BYTE_CNT_16,                                   1678,    6,   16;
;SCIF_SSEA_TLM_PAR_ERR,                                       1680,    6,    1;
;SCIF_SSEA_TLM_BYTE_CNT_16,                                   1680,    5,   16;
;SCIF_SSEB_TLM_PAR_ERR,                                       1682,    5,    1;
;SCIF_SSEB_TLM_BYTE_CNT_16,                                   1682,    4,   16;
;SCIF_SWEAP_PING_TLM_OVFLW_ERR,                               1684,    4,    1;
;SCIF_SWEAP_PING_TLM_PAR_ERR,                                 1684,    3,    1;
;SCIF_SWEAP_PING_TLM_BYTE_CNT_16,                             1684,    2,   16;
;SCIF_FIELDS1_PING_TLM_OVFLW_ERR,                             1686,    2,    1;
;SCIF_FIELDS1_PING_TLM_PAR_ERR,                               1686,    1,    1;
;SCIF_FIELDS1_PING_TLM_BYTE_CNT_16,                           1686,    0,   16;
;SCIF_FIELDS2_PING_TLM_OVFLW_ERR,                             1688,    0,    1;
;SCIF_FIELDS2_PING_TLM_PAR_ERR,                               1689,    7,    1;
;SCIF_FIELDS2_PING_TLM_BYTE_CNT_16,                           1689,    6,   16;
;SCIF_EPIHI_PING_TLM_OVFLW_ERR,                               1691,    6,    1;
;SCIF_EPIHI_PING_TLM_PAR_ERR,                                 1691,    5,    1;
;SCIF_EPIHI_PING_TLM_BYTE_CNT_16,                             1691,    4,   16;
;SCIF_EPILO_PING_TLM_OVFLW_ERR,                               1693,    4,    1;
;SCIF_EPILO_PING_TLM_PAR_ERR,                                 1693,    3,    1;
;SCIF_EPILO_PING_TLM_BYTE_CNT_16,                             1693,    2,   16;
;SCIF_SWEAP_PONG_TLM_OVFLW_ERR,                               1695,    2,    1;
;SCIF_SWEAP_PONG_TLM_PAR_ERR,                                 1695,    1,    1;
;SCIF_SWEAP_PONG_TLM_BYTE_CNT_16,                             1695,    0,   16;
;SCIF_FIELDS1_PONG_TLM_OVFLW_ERR,                             1697,    0,    1;
;SCIF_FIELDS1_PONG_TLM_PAR_ERR,                               1698,    7,    1;
;SCIF_FIELDS1_PONG_TLM_BYTE_CNT_16,                           1698,    6,   16;
;SCIF_FIELDS2_PONG_TLM_OVFLW_ERR,                             1700,    6,    1;
;SCIF_FIELDS2_PONG_TLM_PAR_ERR,                               1700,    5,    1;
;SCIF_FIELDS2_PONG_TLM_BYTE_CNT_16,                           1700,    4,   16;
;SCIF_EPIHI_PONG_TLM_OVFLW_ERR,                               1702,    4,    1;
;SCIF_EPIHI_PONG_TLM_PAR_ERR,                                 1702,    3,    1;
;SCIF_EPIHI_PONG_TLM_BYTE_CNT_16,                             1702,    2,   16;
;SCIF_EPILO_PONG_TLM_OVFLW_ERR,                               1704,    2,    1;
;SCIF_EPILO_PONG_TLM_PAR_ERR,                                 1704,    1,    1;
;SCIF_EPILO_PONG_TLM_BYTE_CNT_16,                             1704,    0,   16;
;SCIF_READ_MET_SECS,                                          1706,    0,   32;
;SCIF_READ_MET_SUBSECS,                                       1710,    0,   16;
;SCIF_READ_MET_100_HZ_INDEX,                                  1712,    0,    7;
;SCIF_CLOCK_SEL,                                              1713,    1,    2;
;SCIF_CLOCK_CNTR_DONE,                                        1714,    7,    1;
;SCIF_CRYSTAL_CLOCK_CNTR,                                     1714,    6,   27;
;SCIF_EMXO_A_CLOCK_CNTR,                                      1717,    3,   27;
;SCIF_EMXO_B_CLOCK_CNTR,                                      1720,    0,   27;
;SCIF_FPGA_BCD_YEAR,                                          1724,    5,    8;
;SCIF_FPGA_BCD_MONTH,                                         1725,    5,    8;
;SCIF_FPGA_BCD_DAY,                                           1726,    5,    8;
;SCIF_FPGA_VERSION,                                           1727,    5,    8;
;SCIF_FSW_RESET_STATUS,                                       1728,    5,    1;
;SCIF_RED_PSE_TLM_PAR_ERR,                                    1728,    4,    1;
;SCIF_RED_PSE_TLM_BYTE_CNT_16,                                1728,    3,   16;
;SCIF_RED_PDU_TLM_PAR_ERR,                                    1730,    3,    1;
;SCIF_RED_PDU_TLM_BYTE_CNT_16,                                1730,    2,   16;
;SCIF_RED_READ_MET_SECS,                                      1732,    2,   32;
;SCIF_RED_READ_MET_SUBSECS,                                   1736,    2,   16;
;SCIF_RED_READ_MET_100_HZ_INDEX,                              1738,    2,    7;
;SCIF_RED_CLOCK_SEL,                                          1739,    3,    2;
;SCIF_RED_CLOCK_CNTR_DONE,                                    1739,    1,    1;
;SCIF_RED_CRYSTAL_CLOCK_CNTR,                                 1739,    0,   27;
;SCIF_RED_EMXO_A_CLOCK_CNTR,                                  1743,    5,   27;
;SCIF_RED_EMXO_B_CLOCK_CNTR,                                  1746,    2,   27;
;TAC_FPGA_VERSION,                                            1750,    7,   32;
;TAC_FPGA_VERSION_REG_YY,                                     1754,    7,    8;
;TAC_FPGA_VERSION_REG_MM,                                     1755,    7,    8;
;TAC_FPGA_VERSION_REG_DD,                                     1756,    7,    8;
;TAC_FPGA_VERSION_REG_VERSION,                                1757,    7,    8;
;TAC_ST2_NO_VALID_CMD,                                        1758,    7,    1;
;TAC_ST1_NO_VALID_CMD,                                        1758,    6,    1;
;TAC_RIO_IN_RESET,                                            1758,    5,    1;
;TAC_SEQ_CNT,                                                 1758,    4,    6;
;TAC_MEM_INIT_COMPLETE,                                       1759,    6,    1;
;TAC_TAC_SIDE_TT,                                             1759,    5,    1;
;TAC_RIU_A_LDO_REG_STATUS,                                    1759,    4,    1;
;TAC_RW_CHANGE_CODE_UPDATE,                                   1759,    3,    1;
;TAC_RELAY_THRUST_CHANGE_CODE_UPDATE,                         1759,    2,    1;
;TAC_PINGPONG_RIU,                                            1759,    1,    1;
;TAC_PINGPONG_ANLG,                                           1759,    0,    1;
;TAC_PINGPONG_ST,                                             1760,    7,    1;
;TAC_RELAY_PULSE_AND_THRUSTER_EXEC_REG,                       1760,    6,   32;
;TAC_WHEEL1_EXEC_REG,                                         1764,    6,   32;
;TAC_WHEEL2_EXEC_REG,                                         1768,    6,   32;
;TAC_WHEEL3_EXEC_REG,                                         1772,    6,   32;
;TAC_WHEEL4_EXEC_REG,                                         1776,    6,   32;
;TAC_WHEEL1_PULSE_CNT0,                                       1780,    6,    8;
;TAC_WHEEL1_DIR0,                                             1781,    6,    8;
;TAC_WHEEL1_TIME_COUNT0,                                      1782,    6,   16;
;TAC_WHEEL1_PULSE_CNT1,                                       1784,    6,    8;
;TAC_WHEEL1_DIR1,                                             1785,    6,    8;
;TAC_WHEEL1_TIME_COUNT1,                                      1786,    6,   16;
;TAC_WHEEL2_PULSE_CNT0,                                       1788,    6,    8;
;TAC_WHEEL2_DIR0,                                             1789,    6,    8;
;TAC_WHEEL2_TIME_COUNT0,                                      1790,    6,   16;
;TAC_WHEEL2_PULSE_CNT1,                                       1792,    6,    8;
;TAC_WHEEL2_DIR1,                                             1793,    6,    8;
;TAC_WHEEL2_TIME_COUNT1,                                      1794,    6,   16;
;TAC_WHEEL3_PULSE_CNT0,                                       1796,    6,    8;
;TAC_WHEEL3_DIR0,                                             1797,    6,    8;
;TAC_WHEEL3_TIME_COUNT0,                                      1798,    6,   16;
;TAC_WHEEL3_PULSE_CNT1,                                       1800,    6,    8;
;TAC_WHEEL3_DIR1,                                             1801,    6,    8;
;TAC_WHEEL3_TIME_COUNT1,                                      1802,    6,   16;
;TAC_WHEEL4_PULSE_CNT0,                                       1804,    6,    8;
;TAC_WHEEL4_DIR0,                                             1805,    6,    8;
;TAC_WHEEL4_TIME_COUNT0,                                      1806,    6,   16;
;TAC_WHEEL4_PULSE_CNT1,                                       1808,    6,    8;
;TAC_WHEEL4_DIR1,                                             1809,    6,    8;
;TAC_WHEEL4_TIME_COUNT1,                                      1810,    6,   16;
;TAC_WHEEL1_SENSED_DIR0,                                      1812,    6,    1;
;TAC_WHEEL1_MOTOR_CURR0,                                      1812,    5,   12;
;TAC_WHEEL2_SENSED_DIR0,                                      1813,    1,    1;
;TAC_WHEEL2_MOTOR_CURR0,                                      1813,    0,   12;
;TAC_WHEEL3_SENSED_DIR0,                                      1815,    4,    1;
;TAC_WHEEL3_MOTOR_CURR0,                                      1815,    3,   12;
;TAC_WHEEL4_SENSED_DIR0,                                      1817,    7,    1;
;TAC_WHEEL4_MOTOR_CURR0,                                      1817,    6,   12;
;TAC_ADC_VBIAS0,                                              1818,    2,   12;
;TAC_WHEEL1_SENSED_DIR1,                                      1820,    6,    1;
;TAC_WHEEL1_MOTOR_CURR1,                                      1820,    5,   12;
;TAC_WHEEL2_SENSED_DIR1,                                      1821,    1,    1;
;TAC_WHEEL2_MOTOR_CURR1,                                      1821,    0,   12;
;TAC_WHEEL3_SENSED_DIR1,                                      1823,    4,    1;
;TAC_WHEEL3_MOTOR_CURR1,                                      1823,    3,   12;
;TAC_WHEEL4_SENSED_DIR1,                                      1825,    7,    1;
;TAC_WHEEL4_MOTOR_CURR1,                                      1825,    6,   12;
;TAC_DELTA_PRESS_B1,                                          1826,    2,   12;
;TAC_DELTA_PRESS_A1,                                          1828,    6,   12;
;TAC_ADC_VBIAS1,                                              1829,    2,   12;
;TAC_P1_PRESS1,                                               1831,    6,   12;
;TAC_WHEEL1_SENSED_DIR2,                                      1832,    2,    1;
;TAC_WHEEL1_MOTOR_CURR2,                                      1832,    1,   12;
;TAC_WHEEL2_SENSED_DIR2,                                      1834,    5,    1;
;TAC_WHEEL2_MOTOR_CURR2,                                      1834,    4,   12;
;TAC_WHEEL3_SENSED_DIR2,                                      1835,    0,    1;
;TAC_WHEEL3_MOTOR_CURR2,                                      1836,    7,   12;
;TAC_WHEEL4_SENSED_DIR2,                                      1837,    3,    1;
;TAC_WHEEL4_MOTOR_CURR2,                                      1837,    2,   12;
;TAC_DELTA_PRESS_B2,                                          1839,    6,   12;
;TAC_DELTA_PRESS_A2,                                          1840,    2,   12;
;TAC_ADC_VBIAS2,                                              1842,    6,   12;
;TAC_P1_PRESS2,                                               1843,    2,   12;
;TAC_WHEEL1_SENSED_DIR3,                                      1845,    6,    1;
;TAC_WHEEL1_MOTOR_CURR3,                                      1845,    5,   12;
;TAC_WHEEL2_SENSED_DIR3,                                      1846,    1,    1;
;TAC_WHEEL2_MOTOR_CURR3,                                      1846,    0,   12;
;TAC_WHEEL3_SENSED_DIR3,                                      1848,    4,    1;
;TAC_WHEEL3_MOTOR_CURR3,                                      1848,    3,   12;
;TAC_WHEEL4_SENSED_DIR3,                                      1850,    7,    1;
;TAC_WHEEL4_MOTOR_CURR3,                                      1850,    6,   12;
;TAC_DELTA_PRESS_B3,                                          1851,    2,   12;
;TAC_DELTA_PRESS_A3,                                          1853,    6,   12;
;TAC_ADC_VBIAS3,                                              1854,    2,   12;
;TAC_P1_PRESS3,                                               1856,    6,   12;
;TAC_WHEEL1_SENSED_DIR4,                                      1857,    2,    1;
;TAC_WHEEL1_MOTOR_CURR4,                                      1857,    1,   12;
;TAC_WHEEL2_SENSED_DIR4,                                      1859,    5,    1;
;TAC_WHEEL2_MOTOR_CURR4,                                      1859,    4,   12;
;TAC_WHEEL3_SENSED_DIR4,                                      1860,    0,    1;
;TAC_WHEEL3_MOTOR_CURR4,                                      1861,    7,   12;
;TAC_WHEEL4_SENSED_DIR4,                                      1862,    3,    1;
;TAC_WHEEL4_MOTOR_CURR4,                                      1862,    2,   12;
;TAC_DELTA_PRESS_B4,                                          1864,    6,   12;
;TAC_DELTA_PRESS_A4,                                          1865,    2,   12;
;TAC_ADC_VBIAS4,                                              1867,    6,   12;
;TAC_P1_PRESS4,                                               1868,    2,   12;
;TAC_ST1_PING_BYTE_CNT,                                       1870,    6,    9;
;TAC_ST2_PING_BYTE_CNT,                                       1871,    5,    9;
;TAC_ST1_PONG_BYTE_CNT,                                       1872,    4,    9;
;TAC_ST2_PONG_BYTE_CNT,                                       1873,    3,    9;
;TAC_FSW_RESET_STATUS,                                        1874,    2,    1;
;TAC_SCRUB_CMD,                                               1874,    1,   32;
;TAC_TC_ERR_CLEAR,                                            1878,    1,   32;
;TAC_RIU_C_CMD_RESET_REG,                                     1882,    1,   32;
;TAC_THRUSTER_OVERCUR_TEST_REG,                               1886,    1,   32;
;TAC_50HZ_ENA_REG,                                            1890,    1,    3;
;TAC_ST_ENA_REG,                                              1891,    6,    3;
;TAC_RIU_C_RIU_ENA_REG,                                       1891,    3,    3;
;TAC_RIU_B_RIU_ENA_REG,                                       1891,    0,    3;
;TAC_RIU_A_RIU_ENA_REG,                                       1892,    5,    3;
;RIU_SCIF_SIDE,                                               1892,    2,   32;
;RIU_1A_CH1_ADC_VALID,                                        1896,    2,    1;
;RIU_1A_CH0_ADC_VALID,                                        1896,    1,    1;
;RIU_1A_CH3_ADC_VALID,                                        1896,    0,    1;
;RIU_1A_CH2_ADC_VALID,                                        1897,    7,    1;
;RIU_1A_CH5_ADC_VALID,                                        1897,    6,    1;
;RIU_1A_CH4_ADC_VALID,                                        1897,    5,    1;
;RIU_1A_CH7_ADC_VALID,                                        1897,    4,    1;
;RIU_1A_CH6_ADC_VALID,                                        1897,    3,    1;
;RIU_1A_CH9_ADC_VALID,                                        1897,    2,    1;
;RIU_1A_CH8_ADC_VALID,                                        1897,    1,    1;
;RIU_1A_CH11_ADC_VALID,                                       1897,    0,    1;
;RIU_1A_CH10_ADC_VALID,                                       1898,    7,    1;
;RIU_1A_CH13_ADC_VALID,                                       1898,    6,    1;
;RIU_1A_CH12_ADC_VALID,                                       1898,    5,    1;
;RIU_1A_CH14_ADC_VALID,                                       1898,    4,    1;
;RIU_1A_CH15W_ADC_VALID,                                      1898,    3,    1;
;RIU_1A_CH15W_COUNTS,                                         1898,    2,   10;
;RIU_1A_CH15N_ADC_VALID,                                      1899,    0,    1;
;RIU_1A_DEVICE_ID,                                            1900,    7,    4;
;RIU_1A_DEVICE_INDEX,                                         1900,    3,    4;
;RIU_1A_DEVICE_HEALTH_CNT,                                    1901,    7,    8;
;RIU_1A_DEVICE_DO_MASK,                                       1902,    7,    8;
;RIU_1A_DEVICE_DO0,                                           1903,    7,    1;
;RIU_1A_DEVICE_DO1,                                           1903,    6,    1;
;RIU_1A_DEVICE_DO2,                                           1903,    5,    1;
;RIU_1A_DEVICE_DO3,                                           1903,    4,    1;
;RIU_1A_DEVICE_DO4,                                           1903,    3,    1;
;RIU_1A_DEVICE_DO5,                                           1903,    2,    1;
;RIU_1A_DEVICE_DO6,                                           1903,    1,    1;
;RIU_1A_DEVICE_DO7,                                           1903,    0,    1;
;RIU_1A_DEVICE_DI_MASK,                                       1904,    7,    8;
;RIU_1A_DEVICE_DI0,                                           1905,    7,    1;
;RIU_1A_DEVICE_DI1,                                           1905,    6,    1;
;RIU_1A_DEVICE_DI2,                                           1905,    5,    1;
;RIU_1A_DEVICE_DI3,                                           1905,    4,    1;
;RIU_1A_DEVICE_DI4,                                           1905,    3,    1;
;RIU_1A_DEVICE_DI5,                                           1905,    2,    1;
;RIU_1A_DEVICE_DI6,                                           1905,    1,    1;
;RIU_1A_DEVICE_DI7,                                           1905,    0,    1;
;RIU_2A_CH1_ADC_VALID,                                        1906,    7,    1;
;RIU_2A_CH1_COUNTS,                                           1906,    6,   10;
;RIU_2A_CH0_ADC_VALID,                                        1907,    4,    1;
;RIU_2A_CH0_COUNTS,                                           1907,    3,   10;
;RIU_2A_CH3_ADC_VALID,                                        1908,    1,    1;
;RIU_2A_CH3_COUNTS,                                           1908,    0,   10;
;RIU_2A_CH2_ADC_VALID,                                        1910,    6,    1;
;RIU_2A_CH2_COUNTS,                                           1910,    5,   10;
;RIU_2A_CH5_ADC_VALID,                                        1911,    3,    1;
;RIU_2A_CH5_COUNTS,                                           1911,    2,   10;
;RIU_2A_CH4_ADC_VALID,                                        1912,    0,    1;
;RIU_2A_CH7_ADC_VALID,                                        1913,    7,    1;
;RIU_2A_CH7_COUNTS,                                           1913,    6,   10;
;RIU_2A_CH6_ADC_VALID,                                        1914,    4,    1;
;RIU_2A_CH6_COUNTS,                                           1914,    3,   10;
;RIU_2A_CH9_ADC_VALID,                                        1915,    1,    1;
;RIU_2A_CH8_ADC_VALID,                                        1915,    0,    1;
;RIU_2A_CH8_COUNTS,                                           1916,    7,   10;
;RIU_2A_CH11_ADC_VALID,                                       1917,    5,    1;
;RIU_2A_CH10_ADC_VALID,                                       1917,    4,    1;
;RIU_2A_CH13_ADC_VALID,                                       1917,    3,    1;
;RIU_2A_CH13_COUNTS,                                          1917,    2,   10;
;RIU_2A_CH12_ADC_VALID,                                       1918,    0,    1;
;RIU_2A_CH14_ADC_VALID,                                       1919,    7,    1;
;RIU_2A_CH14_COUNTS,                                          1919,    6,   10;
;RIU_2A_CH15W_ADC_VALID,                                      1920,    4,    1;
;RIU_2A_CH15W_COUNTS,                                         1920,    3,   10;
;RIU_2A_CH15N_ADC_VALID,                                      1921,    1,    1;
;RIU_2A_CH15N_COUNTS,                                         1921,    0,   10;
;RIU_2A_DEVICE_ID,                                            1923,    6,    4;
;RIU_2A_DEVICE_INDEX,                                         1923,    2,    4;
;RIU_2A_DEVICE_HEALTH_CNT,                                    1924,    6,    8;
;RIU_2A_DEVICE_DO_MASK,                                       1925,    6,    8;
;RIU_2A_DEVICE_DO0,                                           1926,    6,    1;
;RIU_2A_DEVICE_DO1,                                           1926,    5,    1;
;RIU_2A_DEVICE_DO2,                                           1926,    4,    1;
;RIU_2A_DEVICE_DO3,                                           1926,    3,    1;
;RIU_2A_DEVICE_DO4,                                           1926,    2,    1;
;RIU_2A_DEVICE_DO5,                                           1926,    1,    1;
;RIU_2A_DEVICE_DO6,                                           1926,    0,    1;
;RIU_2A_DEVICE_DO7,                                           1927,    7,    1;
;RIU_2A_DEVICE_DI_MASK,                                       1927,    6,    8;
;RIU_2A_DEVICE_DI0,                                           1928,    6,    1;
;RIU_2A_DEVICE_DI1,                                           1928,    5,    1;
;RIU_2A_DEVICE_DI2,                                           1928,    4,    1;
;RIU_2A_DEVICE_DI3,                                           1928,    3,    1;
;RIU_2A_DEVICE_DI4,                                           1928,    2,    1;
;RIU_2A_DEVICE_DI5,                                           1928,    1,    1;
;RIU_2A_DEVICE_DI6,                                           1928,    0,    1;
;RIU_2A_DEVICE_DI7,                                           1929,    7,    1;
;RIU_3A_CH1_ADC_VALID,                                        1929,    6,    1;
;RIU_3A_CH0_ADC_VALID,                                        1929,    5,    1;
;RIU_3A_CH3_ADC_VALID,                                        1929,    4,    1;
;RIU_3A_CH2_ADC_VALID,                                        1929,    3,    1;
;RIU_3A_CH5_ADC_VALID,                                        1929,    2,    1;
;RIU_3A_CH4_ADC_VALID,                                        1929,    1,    1;
;RIU_3A_CH7_ADC_VALID,                                        1929,    0,    1;
;RIU_3A_CH7_COUNTS,                                           1930,    7,   10;
;RIU_3A_CH6_ADC_VALID,                                        1931,    5,    1;
;RIU_3A_CH6_COUNTS,                                           1931,    4,   10;
;RIU_3A_CH9_ADC_VALID,                                        1932,    2,    1;
;RIU_3A_CH9_COUNTS,                                           1932,    1,   10;
;RIU_3A_CH8_ADC_VALID,                                        1934,    7,    1;
;RIU_3A_CH8_COUNTS,                                           1934,    6,   10;
;RIU_3A_CH11_ADC_VALID,                                       1935,    4,    1;
;RIU_3A_CH10_ADC_VALID,                                       1935,    3,    1;
;RIU_3A_CH10_COUNTS,                                          1935,    2,   10;
;RIU_3A_CH13_ADC_VALID,                                       1936,    0,    1;
;RIU_3A_CH12_ADC_VALID,                                       1937,    7,    1;
;RIU_3A_CH14_ADC_VALID,                                       1937,    6,    1;
;RIU_3A_CH14_COUNTS,                                          1937,    5,   10;
;RIU_3A_CH15W_ADC_VALID,                                      1938,    3,    1;
;RIU_3A_CH15W_COUNTS,                                         1938,    2,   10;
;RIU_3A_CH15N_ADC_VALID,                                      1939,    0,    1;
;RIU_3A_DEVICE_ID,                                            1940,    7,    4;
;RIU_3A_DEVICE_INDEX,                                         1940,    3,    4;
;RIU_3A_DEVICE_HEALTH_CNT,                                    1941,    7,    8;
;RIU_3A_DEVICE_DO_MASK,                                       1942,    7,    8;
;RIU_3A_DEVICE_DO0,                                           1943,    7,    1;
;RIU_3A_DEVICE_DO1,                                           1943,    6,    1;
;RIU_3A_DEVICE_DO2,                                           1943,    5,    1;
;RIU_3A_DEVICE_DO3,                                           1943,    4,    1;
;RIU_3A_DEVICE_DO4,                                           1943,    3,    1;
;RIU_3A_DEVICE_DO5,                                           1943,    2,    1;
;RIU_3A_DEVICE_DO6,                                           1943,    1,    1;
;RIU_3A_DEVICE_DO7,                                           1943,    0,    1;
;RIU_3A_DEVICE_DI_MASK,                                       1944,    7,    8;
;RIU_3A_DEVICE_DI0,                                           1945,    7,    1;
;RIU_3A_DEVICE_DI1,                                           1945,    6,    1;
;RIU_3A_DEVICE_DI2,                                           1945,    5,    1;
;RIU_3A_DEVICE_DI3,                                           1945,    4,    1;
;RIU_3A_DEVICE_DI4,                                           1945,    3,    1;
;RIU_3A_DEVICE_DI5,                                           1945,    2,    1;
;RIU_3A_DEVICE_DI6,                                           1945,    1,    1;
;RIU_3A_DEVICE_DI7,                                           1945,    0,    1;
;RIU_4A_CH1_ADC_VALID,                                        1946,    7,    1;
;RIU_4A_CH0_ADC_VALID,                                        1946,    6,    1;
;RIU_4A_CH0_COUNTS,                                           1946,    5,   10;
;RIU_4A_CH3_ADC_VALID,                                        1947,    3,    1;
;RIU_4A_CH2_ADC_VALID,                                        1947,    2,    1;
;RIU_4A_CH5_ADC_VALID,                                        1947,    1,    1;
;RIU_4A_CH4_ADC_VALID,                                        1947,    0,    1;
;RIU_4A_CH7_ADC_VALID,                                        1948,    7,    1;
;RIU_4A_CH6_ADC_VALID,                                        1948,    6,    1;
;RIU_4A_CH9_ADC_VALID,                                        1948,    5,    1;
;RIU_4A_CH9_COUNTS,                                           1948,    4,   10;
;RIU_4A_CH8_ADC_VALID,                                        1949,    2,    1;
;RIU_4A_CH11_ADC_VALID,                                       1949,    1,    1;
;RIU_4A_CH10_ADC_VALID,                                       1949,    0,    1;
;RIU_4A_CH13_ADC_VALID,                                       1950,    7,    1;
;RIU_4A_CH12_ADC_VALID,                                       1950,    6,    1;
;RIU_4A_CH14_ADC_VALID,                                       1950,    5,    1;
;RIU_4A_CH15F_ADC_VALID,                                      1950,    4,    1;
;RIU_4A_CH15F_COUNTS,                                         1950,    3,   10;
;RIU_4A_CH15N_ADC_VALID,                                      1951,    1,    1;
;RIU_4A_CH15N_COUNTS,                                         1951,    0,   10;
;RIU_4A_DEVICE_ID,                                            1953,    6,    4;
;RIU_4A_DEVICE_INDEX,                                         1953,    2,    4;
;RIU_4A_DEVICE_HEALTH_CNT,                                    1954,    6,    8;
;RIU_4A_DEVICE_DO_MASK,                                       1955,    6,    8;
;RIU_4A_DEVICE_DO0,                                           1956,    6,    1;
;RIU_4A_DEVICE_DO1,                                           1956,    5,    1;
;RIU_4A_DEVICE_DO2,                                           1956,    4,    1;
;RIU_4A_DEVICE_DO3,                                           1956,    3,    1;
;RIU_4A_DEVICE_DO4,                                           1956,    2,    1;
;RIU_4A_DEVICE_DO5,                                           1956,    1,    1;
;RIU_4A_DEVICE_DO6,                                           1956,    0,    1;
;RIU_4A_DEVICE_DO7,                                           1957,    7,    1;
;RIU_4A_DEVICE_DI_MASK,                                       1957,    6,    8;
;RIU_4A_DEVICE_DI0,                                           1958,    6,    1;
;RIU_4A_DEVICE_DI1,                                           1958,    5,    1;
;RIU_4A_DEVICE_DI2,                                           1958,    4,    1;
;RIU_4A_DEVICE_DI3,                                           1958,    3,    1;
;RIU_4A_DEVICE_DI4,                                           1958,    2,    1;
;RIU_4A_DEVICE_DI5,                                           1958,    1,    1;
;RIU_4A_DEVICE_DI6,                                           1958,    0,    1;
;RIU_4A_DEVICE_DI7,                                           1959,    7,    1;
;RIU_5A_CH1_ADC_VALID,                                        1959,    6,    1;
;RIU_5A_CH0_ADC_VALID,                                        1959,    5,    1;
;RIU_5A_CH0_COUNTS,                                           1959,    4,   10;
;RIU_5A_CH3_ADC_VALID,                                        1960,    2,    1;
;RIU_5A_CH2_ADC_VALID,                                        1960,    1,    1;
;RIU_5A_CH5_ADC_VALID,                                        1960,    0,    1;
;RIU_5A_CH5_COUNTS,                                           1961,    7,   10;
;RIU_5A_CH4_ADC_VALID,                                        1962,    5,    1;
;RIU_5A_CH7_ADC_VALID,                                        1962,    4,    1;
;RIU_5A_CH7_COUNTS,                                           1962,    3,   10;
;RIU_5A_CH6_ADC_VALID,                                        1963,    1,    1;
;RIU_5A_CH6_COUNTS,                                           1963,    0,   10;
;RIU_5A_CH9_ADC_VALID,                                        1965,    6,    1;
;RIU_5A_CH9_COUNTS,                                           1965,    5,   10;
;RIU_5A_CH8_ADC_VALID,                                        1966,    3,    1;
;RIU_5A_CH11_ADC_VALID,                                       1966,    2,    1;
;RIU_5A_CH10_ADC_VALID,                                       1966,    1,    1;
;RIU_5A_CH10_COUNTS,                                          1966,    0,   10;
;RIU_5A_CH13_ADC_VALID,                                       1968,    6,    1;
;RIU_5A_CH12_ADC_VALID,                                       1968,    5,    1;
;RIU_5A_CH14_ADC_VALID,                                       1968,    4,    1;
;RIU_5A_CH15F_ADC_VALID,                                      1968,    3,    1;
;RIU_5A_CH15F_COUNTS,                                         1968,    2,   10;
;RIU_5A_CH15N_ADC_VALID,                                      1969,    0,    1;
;RIU_5A_CH15N_COUNTS,                                         1970,    7,   10;
;RIU_5A_DEVICE_ID,                                            1971,    5,    4;
;RIU_5A_DEVICE_INDEX,                                         1971,    1,    4;
;RIU_5A_DEVICE_HEALTH_CNT,                                    1972,    5,    8;
;RIU_5A_DEVICE_DO_MASK,                                       1973,    5,    8;
;RIU_5A_DEVICE_DO0,                                           1974,    5,    1;
;RIU_5A_DEVICE_DO1,                                           1974,    4,    1;
;RIU_5A_DEVICE_DO2,                                           1974,    3,    1;
;RIU_5A_DEVICE_DO3,                                           1974,    2,    1;
;RIU_5A_DEVICE_DO4,                                           1974,    1,    1;
;RIU_5A_DEVICE_DO5,                                           1974,    0,    1;
;RIU_5A_DEVICE_DO6,                                           1975,    7,    1;
;RIU_5A_DEVICE_DO7,                                           1975,    6,    1;
;RIU_5A_DEVICE_DI_MASK,                                       1975,    5,    8;
;RIU_5A_DEVICE_DI0,                                           1976,    5,    1;
;RIU_5A_DEVICE_DI1,                                           1976,    4,    1;
;RIU_5A_DEVICE_DI2,                                           1976,    3,    1;
;RIU_5A_DEVICE_DI3,                                           1976,    2,    1;
;RIU_5A_DEVICE_DI4,                                           1976,    1,    1;
;RIU_5A_DEVICE_DI5,                                           1976,    0,    1;
;RIU_5A_DEVICE_DI6,                                           1977,    7,    1;
;RIU_5A_DEVICE_DI7,                                           1977,    6,    1;
;RIU_6A_CH1_ADC_VALID,                                        1977,    5,    1;
;RIU_6A_CH0_ADC_VALID,                                        1977,    4,    1;
;RIU_6A_CH0_COUNTS,                                           1977,    3,   10;
;RIU_6A_CH3_ADC_VALID,                                        1978,    1,    1;
;RIU_6A_CH2_ADC_VALID,                                        1978,    0,    1;
;RIU_6A_CH5_ADC_VALID,                                        1979,    7,    1;
;RIU_6A_CH5_COUNTS,                                           1979,    6,   10;
;RIU_6A_CH4_ADC_VALID,                                        1980,    4,    1;
;RIU_6A_CH7_ADC_VALID,                                        1980,    3,    1;
;RIU_6A_CH7_COUNTS,                                           1980,    2,   10;
;RIU_6A_CH6_ADC_VALID,                                        1981,    0,    1;
;RIU_6A_CH9_ADC_VALID,                                        1982,    7,    1;
;RIU_6A_CH9_COUNTS,                                           1982,    6,   10;
;RIU_6A_CH8_ADC_VALID,                                        1983,    4,    1;
;RIU_6A_CH11_ADC_VALID,                                       1983,    3,    1;
;RIU_6A_CH11_COUNTS,                                          1983,    2,   10;
;RIU_6A_CH10_ADC_VALID,                                       1984,    0,    1;
;RIU_6A_CH13_ADC_VALID,                                       1985,    7,    1;
;RIU_6A_CH13_COUNTS,                                          1985,    6,   10;
;RIU_6A_CH12_ADC_VALID,                                       1986,    4,    1;
;RIU_6A_CH12_COUNTS,                                          1986,    3,   10;
;RIU_6A_CH14_ADC_VALID,                                       1987,    1,    1;
;RIU_6A_CH14_COUNTS,                                          1987,    0,   10;
;RIU_6A_CH15W_ADC_VALID,                                      1989,    6,    1;
;RIU_6A_CH15W_COUNTS,                                         1989,    5,   10;
;RIU_6A_CH15N_ADC_VALID,                                      1990,    3,    1;
;RIU_6A_CH15N_COUNTS,                                         1990,    2,   10;
;RIU_6A_DEVICE_ID,                                            1991,    0,    4;
;RIU_6A_DEVICE_INDEX,                                         1992,    4,    4;
;RIU_6A_DEVICE_HEALTH_CNT,                                    1992,    0,    8;
;RIU_6A_DEVICE_DO_MASK,                                       1993,    0,    8;
;RIU_6A_DEVICE_DO0,                                           1994,    0,    1;
;RIU_6A_DEVICE_DO1,                                           1995,    7,    1;
;RIU_6A_DEVICE_DO2,                                           1995,    6,    1;
;RIU_6A_DEVICE_DO3,                                           1995,    5,    1;
;RIU_6A_DEVICE_DO4,                                           1995,    4,    1;
;RIU_6A_DEVICE_DO5,                                           1995,    3,    1;
;RIU_6A_DEVICE_DO6,                                           1995,    2,    1;
;RIU_6A_DEVICE_DO7,                                           1995,    1,    1;
;RIU_6A_DEVICE_DI_MASK,                                       1995,    0,    8;
;RIU_6A_DEVICE_DI0,                                           1996,    0,    1;
;RIU_6A_DEVICE_DI1,                                           1997,    7,    1;
;RIU_6A_DEVICE_DI2,                                           1997,    6,    1;
;RIU_6A_DEVICE_DI3,                                           1997,    5,    1;
;RIU_6A_DEVICE_DI4,                                           1997,    4,    1;
;RIU_6A_DEVICE_DI5,                                           1997,    3,    1;
;RIU_6A_DEVICE_DI6,                                           1997,    2,    1;
;RIU_6A_DEVICE_DI7,                                           1997,    1,    1;
;RIU_7A_CH1_ADC_VALID,                                        1997,    0,    1;
;RIU_7A_CH0_ADC_VALID,                                        1998,    7,    1;
;RIU_7A_CH0_COUNTS,                                           1998,    6,   10;
;RIU_7A_CH3_ADC_VALID,                                        1999,    4,    1;
;RIU_7A_CH3_COUNTS,                                           1999,    3,   10;
;RIU_7A_CH2_ADC_VALID,                                        2000,    1,    1;
;RIU_7A_CH5_ADC_VALID,                                        2000,    0,    1;
;RIU_7A_CH4_ADC_VALID,                                        2001,    7,    1;
;RIU_7A_CH7_ADC_VALID,                                        2001,    6,    1;
;RIU_7A_CH6_ADC_VALID,                                        2001,    5,    1;
;RIU_7A_CH9_ADC_VALID,                                        2001,    4,    1;
;RIU_7A_CH9_COUNTS,                                           2001,    3,   10;
;RIU_7A_CH8_ADC_VALID,                                        2002,    1,    1;
;RIU_7A_CH11_ADC_VALID,                                       2002,    0,    1;
;RIU_7A_CH11_COUNTS,                                          2003,    7,   10;
;RIU_7A_CH10_ADC_VALID,                                       2004,    5,    1;
;RIU_7A_CH10_COUNTS,                                          2004,    4,   10;
;RIU_7A_CH13_ADC_VALID,                                       2005,    2,    1;
;RIU_7A_CH13_COUNTS,                                          2005,    1,   10;
;RIU_7A_CH12_ADC_VALID,                                       2007,    7,    1;
;RIU_7A_CH12_COUNTS,                                          2007,    6,   10;
;RIU_7A_CH14_ADC_VALID,                                       2008,    4,    1;
;RIU_7A_CH14_COUNTS,                                          2008,    3,   10;
;RIU_7A_CH15W_ADC_VALID,                                      2009,    1,    1;
;RIU_7A_CH15W_COUNTS,                                         2009,    0,   10;
;RIU_7A_CH15N_ADC_VALID,                                      2011,    6,    1;
;RIU_7A_DEVICE_ID,                                            2011,    5,    4;
;RIU_7A_DEVICE_INDEX,                                         2011,    1,    4;
;RIU_7A_DEVICE_HEALTH_CNT,                                    2012,    5,    8;
;RIU_7A_DEVICE_DO_MASK,                                       2013,    5,    8;
;RIU_7A_DEVICE_DO0,                                           2014,    5,    1;
;RIU_7A_DEVICE_DO1,                                           2014,    4,    1;
;RIU_7A_DEVICE_DO2,                                           2014,    3,    1;
;RIU_7A_DEVICE_DO3,                                           2014,    2,    1;
;RIU_7A_DEVICE_DO4,                                           2014,    1,    1;
;RIU_7A_DEVICE_DO5,                                           2014,    0,    1;
;RIU_7A_DEVICE_DO6,                                           2015,    7,    1;
;RIU_7A_DEVICE_DO7,                                           2015,    6,    1;
;RIU_7A_DEVICE_DI_MASK,                                       2015,    5,    8;
;RIU_7A_DEVICE_DI0,                                           2016,    5,    1;
;RIU_7A_DEVICE_DI1,                                           2016,    4,    1;
;RIU_7A_DEVICE_DI2,                                           2016,    3,    1;
;RIU_7A_DEVICE_DI3,                                           2016,    2,    1;
;RIU_7A_DEVICE_DI4,                                           2016,    1,    1;
;RIU_7A_DEVICE_DI5,                                           2016,    0,    1;
;RIU_7A_DEVICE_DI6,                                           2017,    7,    1;
;RIU_7A_DEVICE_DI7,                                           2017,    6,    1;
;RIU_8A_CH1_ADC_VALID,                                        2017,    5,    1;
;RIU_8A_CH0_ADC_VALID,                                        2017,    4,    1;
;RIU_8A_CH0_COUNTS,                                           2017,    3,   10;
;RIU_8A_CH3_ADC_VALID,                                        2018,    1,    1;
;RIU_8A_CH2_ADC_VALID,                                        2018,    0,    1;
;RIU_8A_CH5_ADC_VALID,                                        2019,    7,    1;
;RIU_8A_CH5_COUNTS,                                           2019,    6,   10;
;RIU_8A_CH4_ADC_VALID,                                        2020,    4,    1;
;RIU_8A_CH4_COUNTS,                                           2020,    3,   10;
;RIU_8A_CH7_ADC_VALID,                                        2021,    1,    1;
;RIU_8A_CH6_ADC_VALID,                                        2021,    0,    1;
;RIU_8A_CH9_ADC_VALID,                                        2022,    7,    1;
;RIU_8A_CH9_COUNTS,                                           2022,    6,   10;
;RIU_8A_CH8_ADC_VALID,                                        2023,    4,    1;
;RIU_8A_CH11_ADC_VALID,                                       2023,    3,    1;
;RIU_8A_CH11_COUNTS,                                          2023,    2,   10;
;RIU_8A_CH10_ADC_VALID,                                       2024,    0,    1;
;RIU_8A_CH10_COUNTS,                                          2025,    7,   10;
;RIU_8A_CH13_ADC_VALID,                                       2026,    5,    1;
;RIU_8A_CH13_COUNTS,                                          2026,    4,   10;
;RIU_8A_CH12_ADC_VALID,                                       2027,    2,    1;
;RIU_8A_CH12_COUNTS,                                          2027,    1,   10;
;RIU_8A_CH14_ADC_VALID,                                       2029,    7,    1;
;RIU_8A_CH14_COUNTS,                                          2029,    6,   10;
;RIU_8A_CH15W_ADC_VALID,                                      2030,    4,    1;
;RIU_8A_CH15W_COUNTS,                                         2030,    3,   10;
;RIU_8A_CH15N_ADC_VALID,                                      2031,    1,    1;
;RIU_8A_CH15N_COUNTS,                                         2031,    0,   10;
;RIU_8A_DEVICE_ID,                                            2033,    6,    4;
;RIU_8A_DEVICE_INDEX,                                         2033,    2,    4;
;RIU_8A_DEVICE_HEALTH_CNT,                                    2034,    6,    8;
;RIU_8A_DEVICE_DO_MASK,                                       2035,    6,    8;
;RIU_8A_DEVICE_DO0,                                           2036,    6,    1;
;RIU_8A_DEVICE_DO1,                                           2036,    5,    1;
;RIU_8A_DEVICE_DO2,                                           2036,    4,    1;
;RIU_8A_DEVICE_DO3,                                           2036,    3,    1;
;RIU_8A_DEVICE_DO4,                                           2036,    2,    1;
;RIU_8A_DEVICE_DO5,                                           2036,    1,    1;
;RIU_8A_DEVICE_DO6,                                           2036,    0,    1;
;RIU_8A_DEVICE_DO7,                                           2037,    7,    1;
;RIU_8A_DEVICE_DI_MASK,                                       2037,    6,    8;
;RIU_8A_DEVICE_DI0,                                           2038,    6,    1;
;RIU_8A_DEVICE_DI1,                                           2038,    5,    1;
;RIU_8A_DEVICE_DI2,                                           2038,    4,    1;
;RIU_8A_DEVICE_DI3,                                           2038,    3,    1;
;RIU_8A_DEVICE_DI4,                                           2038,    2,    1;
;RIU_8A_DEVICE_DI5,                                           2038,    1,    1;
;RIU_8A_DEVICE_DI6,                                           2038,    0,    1;
;RIU_8A_DEVICE_DI7,                                           2039,    7,    1;
;RIU_1B_CH1_ADC_VALID,                                        2039,    6,    1;
;RIU_1B_CH0_ADC_VALID,                                        2039,    5,    1;
;RIU_1B_CH3_ADC_VALID,                                        2039,    4,    1;
;RIU_1B_CH2_ADC_VALID,                                        2039,    3,    1;
;RIU_1B_CH5_ADC_VALID,                                        2039,    2,    1;
;RIU_1B_CH4_ADC_VALID,                                        2039,    1,    1;
;RIU_1B_CH7_ADC_VALID,                                        2039,    0,    1;
;RIU_1B_CH6_ADC_VALID,                                        2040,    7,    1;
;RIU_1B_CH9_ADC_VALID,                                        2040,    6,    1;
;RIU_1B_CH8_ADC_VALID,                                        2040,    5,    1;
;RIU_1B_CH11_ADC_VALID,                                       2040,    4,    1;
;RIU_1B_CH10_ADC_VALID,                                       2040,    3,    1;
;RIU_1B_CH13_ADC_VALID,                                       2040,    2,    1;
;RIU_1B_CH12_ADC_VALID,                                       2040,    1,    1;
;RIU_1B_CH14_ADC_VALID,                                       2040,    0,    1;
;RIU_1B_CH15W_ADC_VALID,                                      2041,    7,    1;
;RIU_1B_CH15W_COUNTS,                                         2041,    6,   10;
;RIU_1B_CH15N_ADC_VALID,                                      2042,    4,    1;
;RIU_1B_DEVICE_ID,                                            2042,    3,    4;
;RIU_1B_DEVICE_INDEX,                                         2043,    7,    4;
;RIU_1B_DEVICE_HEALTH_CNT,                                    2043,    3,    8;
;RIU_1B_DEVICE_DO_MASK,                                       2044,    3,    8;
;RIU_1B_DEVICE_DO0,                                           2045,    3,    1;
;RIU_1B_DEVICE_DO1,                                           2045,    2,    1;
;RIU_1B_DEVICE_DO2,                                           2045,    1,    1;
;RIU_1B_DEVICE_DO3,                                           2045,    0,    1;
;RIU_1B_DEVICE_DO4,                                           2046,    7,    1;
;RIU_1B_DEVICE_DO5,                                           2046,    6,    1;
;RIU_1B_DEVICE_DO6,                                           2046,    5,    1;
;RIU_1B_DEVICE_DO7,                                           2046,    4,    1;
;RIU_1B_DEVICE_DI_MASK,                                       2046,    3,    8;
;RIU_1B_DEVICE_DI0,                                           2047,    3,    1;
;RIU_1B_DEVICE_DI1,                                           2047,    2,    1;
;RIU_1B_DEVICE_DI2,                                           2047,    1,    1;
;RIU_1B_DEVICE_DI3,                                           2047,    0,    1;
;RIU_1B_DEVICE_DI4,                                           2048,    7,    1;
;RIU_1B_DEVICE_DI5,                                           2048,    6,    1;
;RIU_1B_DEVICE_DI6,                                           2048,    5,    1;
;RIU_1B_DEVICE_DI7,                                           2048,    4,    1;
;RIU_2B_CH1_ADC_VALID,                                        2048,    3,    1;
;RIU_2B_CH1_COUNTS,                                           2048,    2,   10;
;RIU_2B_CH0_ADC_VALID,                                        2049,    0,    1;
;RIU_2B_CH0_COUNTS,                                           2050,    7,   10;
;RIU_2B_CH3_ADC_VALID,                                        2051,    5,    1;
;RIU_2B_CH3_COUNTS,                                           2051,    4,   10;
;RIU_2B_CH2_ADC_VALID,                                        2052,    2,    1;
;RIU_2B_CH2_COUNTS,                                           2052,    1,   10;
;RIU_2B_CH5_ADC_VALID,                                        2054,    7,    1;
;RIU_2B_CH5_COUNTS,                                           2054,    6,   10;
;RIU_2B_CH4_ADC_VALID,                                        2055,    4,    1;
;RIU_2B_CH4_COUNTS,                                           2055,    3,   10;
;RIU_2B_CH7_ADC_VALID,                                        2056,    1,    1;
;RIU_2B_CH7_COUNTS,                                           2056,    0,   10;
;RIU_2B_CH6_ADC_VALID,                                        2058,    6,    1;
;RIU_2B_CH9_ADC_VALID,                                        2058,    5,    1;
;RIU_2B_CH9_COUNTS,                                           2058,    4,   10;
;RIU_2B_CH8_ADC_VALID,                                        2059,    2,    1;
;RIU_2B_CH8_COUNTS,                                           2059,    1,   10;
;RIU_2B_CH11_ADC_VALID,                                       2061,    7,    1;
;RIU_2B_CH10_ADC_VALID,                                       2061,    6,    1;
;RIU_2B_CH10_COUNTS,                                          2061,    5,   10;
;RIU_2B_CH13_ADC_VALID,                                       2062,    3,    1;
;RIU_2B_CH12_ADC_VALID,                                       2062,    2,    1;
;RIU_2B_CH14_ADC_VALID,                                       2062,    1,    1;
;RIU_2B_CH14_COUNTS,                                          2062,    0,   10;
;RIU_2B_CH15W_ADC_VALID,                                      2064,    6,    1;
;RIU_2B_CH15W_COUNTS,                                         2064,    5,   10;
;RIU_2B_CH15N_ADC_VALID,                                      2065,    3,    1;
;RIU_2B_CH15N_COUNTS,                                         2065,    2,   10;
;RIU_2B_DEVICE_ID,                                            2066,    0,    4;
;RIU_2B_DEVICE_INDEX,                                         2067,    4,    4;
;RIU_2B_DEVICE_HEALTH_CNT,                                    2067,    0,    8;
;RIU_2B_DEVICE_DO_MASK,                                       2068,    0,    8;
;RIU_2B_DEVICE_DO0,                                           2069,    0,    1;
;RIU_2B_DEVICE_DO1,                                           2070,    7,    1;
;RIU_2B_DEVICE_DO2,                                           2070,    6,    1;
;RIU_2B_DEVICE_DO3,                                           2070,    5,    1;
;RIU_2B_DEVICE_DO4,                                           2070,    4,    1;
;RIU_2B_DEVICE_DO5,                                           2070,    3,    1;
;RIU_2B_DEVICE_DO6,                                           2070,    2,    1;
;RIU_2B_DEVICE_DO7,                                           2070,    1,    1;
;RIU_2B_DEVICE_DI_MASK,                                       2070,    0,    8;
;RIU_2B_DEVICE_DI0,                                           2071,    0,    1;
;RIU_2B_DEVICE_DI1,                                           2072,    7,    1;
;RIU_2B_DEVICE_DI2,                                           2072,    6,    1;
;RIU_2B_DEVICE_DI3,                                           2072,    5,    1;
;RIU_2B_DEVICE_DI4,                                           2072,    4,    1;
;RIU_2B_DEVICE_DI5,                                           2072,    3,    1;
;RIU_2B_DEVICE_DI6,                                           2072,    2,    1;
;RIU_2B_DEVICE_DI7,                                           2072,    1,    1;
;RIU_3B_CH1_ADC_VALID,                                        2072,    0,    1;
;RIU_3B_CH1_COUNTS,                                           2073,    7,   10;
;RIU_3B_CH0_ADC_VALID,                                        2074,    5,    1;
;RIU_3B_CH3_ADC_VALID,                                        2074,    4,    1;
;RIU_3B_CH3_COUNTS,                                           2074,    3,   10;
;RIU_3B_CH2_ADC_VALID,                                        2075,    1,    1;
;RIU_3B_CH2_COUNTS,                                           2075,    0,   10;
;RIU_3B_CH5_ADC_VALID,                                        2077,    6,    1;
;RIU_3B_CH5_COUNTS,                                           2077,    5,   10;
;RIU_3B_CH4_ADC_VALID,                                        2078,    3,    1;
;RIU_3B_CH4_COUNTS,                                           2078,    2,   10;
;RIU_3B_CH7_ADC_VALID,                                        2079,    0,    1;
;RIU_3B_CH7_COUNTS,                                           2080,    7,   10;
;RIU_3B_CH6_ADC_VALID,                                        2081,    5,    1;
;RIU_3B_CH6_COUNTS,                                           2081,    4,   10;
;RIU_3B_CH9_ADC_VALID,                                        2082,    2,    1;
;RIU_3B_CH9_COUNTS,                                           2082,    1,   10;
;RIU_3B_CH8_ADC_VALID,                                        2084,    7,    1;
;RIU_3B_CH8_COUNTS,                                           2084,    6,   10;
;RIU_3B_CH11_ADC_VALID,                                       2085,    4,    1;
;RIU_3B_CH11_COUNTS,                                          2085,    3,   10;
;RIU_3B_CH10_ADC_VALID,                                       2086,    1,    1;
;RIU_3B_CH10_COUNTS,                                          2086,    0,   10;
;RIU_3B_CH13_ADC_VALID,                                       2088,    6,    1;
;RIU_3B_CH12_ADC_VALID,                                       2088,    5,    1;
;RIU_3B_CH14_ADC_VALID,                                       2088,    4,    1;
;RIU_3B_CH15W_ADC_VALID,                                      2088,    3,    1;
;RIU_3B_CH15W_COUNTS,                                         2088,    2,   10;
;RIU_3B_CH15N_ADC_VALID,                                      2089,    0,    1;
;RIU_3B_DEVICE_ID,                                            2090,    7,    4;
;RIU_3B_DEVICE_INDEX,                                         2090,    3,    4;
;RIU_3B_DEVICE_HEALTH_CNT,                                    2091,    7,    8;
;RIU_3B_DEVICE_DO_MASK,                                       2092,    7,    8;
;RIU_3B_DEVICE_DO0,                                           2093,    7,    1;
;RIU_3B_DEVICE_DO1,                                           2093,    6,    1;
;RIU_3B_DEVICE_DO2,                                           2093,    5,    1;
;RIU_3B_DEVICE_DO3,                                           2093,    4,    1;
;RIU_3B_DEVICE_DO4,                                           2093,    3,    1;
;RIU_3B_DEVICE_DO5,                                           2093,    2,    1;
;RIU_3B_DEVICE_DO6,                                           2093,    1,    1;
;RIU_3B_DEVICE_DO7,                                           2093,    0,    1;
;RIU_3B_DEVICE_DI_MASK,                                       2094,    7,    8;
;RIU_3B_DEVICE_DI0,                                           2095,    7,    1;
;RIU_3B_DEVICE_DI1,                                           2095,    6,    1;
;RIU_3B_DEVICE_DI2,                                           2095,    5,    1;
;RIU_3B_DEVICE_DI3,                                           2095,    4,    1;
;RIU_3B_DEVICE_DI4,                                           2095,    3,    1;
;RIU_3B_DEVICE_DI5,                                           2095,    2,    1;
;RIU_3B_DEVICE_DI6,                                           2095,    1,    1;
;RIU_3B_DEVICE_DI7,                                           2095,    0,    1;
;RIU_4B_CH1_ADC_VALID,                                        2096,    7,    1;
;RIU_4B_CH0_ADC_VALID,                                        2096,    6,    1;
;RIU_4B_CH0_COUNTS,                                           2096,    5,   10;
;RIU_4B_CH3_ADC_VALID,                                        2097,    3,    1;
;RIU_4B_CH2_ADC_VALID,                                        2097,    2,    1;
;RIU_4B_CH5_ADC_VALID,                                        2097,    1,    1;
;RIU_4B_CH4_ADC_VALID,                                        2097,    0,    1;
;RIU_4B_CH7_ADC_VALID,                                        2098,    7,    1;
;RIU_4B_CH7_COUNTS,                                           2098,    6,   10;
;RIU_4B_CH6_ADC_VALID,                                        2099,    4,    1;
;RIU_4B_CH6_COUNTS,                                           2099,    3,   10;
;RIU_4B_CH9_ADC_VALID,                                        2100,    1,    1;
;RIU_4B_CH9_COUNTS,                                           2100,    0,   10;
;RIU_4B_CH8_ADC_VALID,                                        2102,    6,    1;
;RIU_4B_CH8_COUNTS,                                           2102,    5,   10;
;RIU_4B_CH11_ADC_VALID,                                       2103,    3,    1;
;RIU_4B_CH10_ADC_VALID,                                       2103,    2,    1;
;RIU_4B_CH13_ADC_VALID,                                       2103,    1,    1;
;RIU_4B_CH12_ADC_VALID,                                       2103,    0,    1;
;RIU_4B_CH14_ADC_VALID,                                       2104,    7,    1;
;RIU_4B_CH15F_ADC_VALID,                                      2104,    6,    1;
;RIU_4B_CH15F_COUNTS,                                         2104,    5,   10;
;RIU_4B_CH15N_ADC_VALID,                                      2105,    3,    1;
;RIU_4B_CH15N_COUNTS,                                         2105,    2,   10;
;RIU_4B_DEVICE_ID,                                            2106,    0,    4;
;RIU_4B_DEVICE_INDEX,                                         2107,    4,    4;
;RIU_4B_DEVICE_HEALTH_CNT,                                    2107,    0,    8;
;RIU_4B_DEVICE_DO_MASK,                                       2108,    0,    8;
;RIU_4B_DEVICE_DO0,                                           2109,    0,    1;
;RIU_4B_DEVICE_DO1,                                           2110,    7,    1;
;RIU_4B_DEVICE_DO2,                                           2110,    6,    1;
;RIU_4B_DEVICE_DO3,                                           2110,    5,    1;
;RIU_4B_DEVICE_DO4,                                           2110,    4,    1;
;RIU_4B_DEVICE_DO5,                                           2110,    3,    1;
;RIU_4B_DEVICE_DO6,                                           2110,    2,    1;
;RIU_4B_DEVICE_DO7,                                           2110,    1,    1;
;RIU_4B_DEVICE_DI_MASK,                                       2110,    0,    8;
;RIU_4B_DEVICE_DI0,                                           2111,    0,    1;
;RIU_4B_DEVICE_DI1,                                           2112,    7,    1;
;RIU_4B_DEVICE_DI2,                                           2112,    6,    1;
;RIU_4B_DEVICE_DI3,                                           2112,    5,    1;
;RIU_4B_DEVICE_DI4,                                           2112,    4,    1;
;RIU_4B_DEVICE_DI5,                                           2112,    3,    1;
;RIU_4B_DEVICE_DI6,                                           2112,    2,    1;
;RIU_4B_DEVICE_DI7,                                           2112,    1,    1;
;RIU_5B_CH1_ADC_VALID,                                        2112,    0,    1;
;RIU_5B_CH0_ADC_VALID,                                        2113,    7,    1;
;RIU_5B_CH0_COUNTS,                                           2113,    6,   10;
;RIU_5B_CH3_ADC_VALID,                                        2114,    4,    1;
;RIU_5B_CH2_ADC_VALID,                                        2114,    3,    1;
;RIU_5B_CH5_ADC_VALID,                                        2114,    2,    1;
;RIU_5B_CH4_ADC_VALID,                                        2114,    1,    1;
;RIU_5B_CH7_ADC_VALID,                                        2114,    0,    1;
;RIU_5B_CH7_COUNTS,                                           2115,    7,   10;
;RIU_5B_CH6_ADC_VALID,                                        2116,    5,    1;
;RIU_5B_CH6_COUNTS,                                           2116,    4,   10;
;RIU_5B_CH9_ADC_VALID,                                        2117,    2,    1;
;RIU_5B_CH9_COUNTS,                                           2117,    1,   10;
;RIU_5B_CH8_ADC_VALID,                                        2119,    7,    1;
;RIU_5B_CH11_ADC_VALID,                                       2119,    6,    1;
;RIU_5B_CH10_ADC_VALID,                                       2119,    5,    1;
;RIU_5B_CH10_COUNTS,                                          2119,    4,   10;
;RIU_5B_CH13_ADC_VALID,                                       2120,    2,    1;
;RIU_5B_CH12_ADC_VALID,                                       2120,    1,    1;
;RIU_5B_CH14_ADC_VALID,                                       2120,    0,    1;
;RIU_5B_CH15F_ADC_VALID,                                      2121,    7,    1;
;RIU_5B_CH15F_COUNTS,                                         2121,    6,   10;
;RIU_5B_CH15N_ADC_VALID,                                      2122,    4,    1;
;RIU_5B_CH15N_COUNTS,                                         2122,    3,   10;
;RIU_5B_DEVICE_ID,                                            2123,    1,    4;
;RIU_5B_DEVICE_INDEX,                                         2124,    5,    4;
;RIU_5B_DEVICE_HEALTH_CNT,                                    2124,    1,    8;
;RIU_5B_DEVICE_DO_MASK,                                       2125,    1,    8;
;RIU_5B_DEVICE_DO0,                                           2126,    1,    1;
;RIU_5B_DEVICE_DO1,                                           2126,    0,    1;
;RIU_5B_DEVICE_DO2,                                           2127,    7,    1;
;RIU_5B_DEVICE_DO3,                                           2127,    6,    1;
;RIU_5B_DEVICE_DO4,                                           2127,    5,    1;
;RIU_5B_DEVICE_DO5,                                           2127,    4,    1;
;RIU_5B_DEVICE_DO6,                                           2127,    3,    1;
;RIU_5B_DEVICE_DO7,                                           2127,    2,    1;
;RIU_5B_DEVICE_DI_MASK,                                       2127,    1,    8;
;RIU_5B_DEVICE_DI0,                                           2128,    1,    1;
;RIU_5B_DEVICE_DI1,                                           2128,    0,    1;
;RIU_5B_DEVICE_DI2,                                           2129,    7,    1;
;RIU_5B_DEVICE_DI3,                                           2129,    6,    1;
;RIU_5B_DEVICE_DI4,                                           2129,    5,    1;
;RIU_5B_DEVICE_DI5,                                           2129,    4,    1;
;RIU_5B_DEVICE_DI6,                                           2129,    3,    1;
;RIU_5B_DEVICE_DI7,                                           2129,    2,    1;
;RIU_6B_CH1_ADC_VALID,                                        2129,    1,    1;
;RIU_6B_CH0_ADC_VALID,                                        2129,    0,    1;
;RIU_6B_CH0_COUNTS,                                           2130,    7,   10;
;RIU_6B_CH3_ADC_VALID,                                        2131,    5,    1;
;RIU_6B_CH3_COUNTS,                                           2131,    4,   10;
;RIU_6B_CH2_ADC_VALID,                                        2132,    2,    1;
;RIU_6B_CH5_ADC_VALID,                                        2132,    1,    1;
;RIU_6B_CH4_ADC_VALID,                                        2132,    0,    1;
;RIU_6B_CH4_COUNTS,                                           2133,    7,   10;
;RIU_6B_CH7_ADC_VALID,                                        2134,    5,    1;
;RIU_6B_CH6_ADC_VALID,                                        2134,    4,    1;
;RIU_6B_CH6_COUNTS,                                           2134,    3,   10;
;RIU_6B_CH9_ADC_VALID,                                        2135,    1,    1;
;RIU_6B_CH9_COUNTS,                                           2135,    0,   10;
;RIU_6B_CH8_ADC_VALID,                                        2137,    6,    1;
;RIU_6B_CH8_COUNTS,                                           2137,    5,   10;
;RIU_6B_CH11_ADC_VALID,                                       2138,    3,    1;
;RIU_6B_CH11_COUNTS,                                          2138,    2,   10;
;RIU_6B_CH10_ADC_VALID,                                       2139,    0,    1;
;RIU_6B_CH10_COUNTS,                                          2140,    7,   10;
;RIU_6B_CH13_ADC_VALID,                                       2141,    5,    1;
;RIU_6B_CH13_COUNTS,                                          2141,    4,   10;
;RIU_6B_CH12_ADC_VALID,                                       2142,    2,    1;
;RIU_6B_CH12_COUNTS,                                          2142,    1,   10;
;RIU_6B_CH14_ADC_VALID,                                       2144,    7,    1;
;RIU_6B_CH14_COUNTS,                                          2144,    6,   10;
;RIU_6B_CH15W_ADC_VALID,                                      2145,    4,    1;
;RIU_6B_CH15W_COUNTS,                                         2145,    3,   10;
;RIU_6B_CH15N_ADC_VALID,                                      2146,    1,    1;
;RIU_6B_CH15N_COUNTS,                                         2146,    0,   10;
;RIU_6B_DEVICE_ID,                                            2148,    6,    4;
;RIU_6B_DEVICE_INDEX,                                         2148,    2,    4;
;RIU_6B_DEVICE_HEALTH_CNT,                                    2149,    6,    8;
;RIU_6B_DEVICE_DO_MASK,                                       2150,    6,    8;
;RIU_6B_DEVICE_DO0,                                           2151,    6,    1;
;RIU_6B_DEVICE_DO1,                                           2151,    5,    1;
;RIU_6B_DEVICE_DO2,                                           2151,    4,    1;
;RIU_6B_DEVICE_DO3,                                           2151,    3,    1;
;RIU_6B_DEVICE_DO4,                                           2151,    2,    1;
;RIU_6B_DEVICE_DO5,                                           2151,    1,    1;
;RIU_6B_DEVICE_DO6,                                           2151,    0,    1;
;RIU_6B_DEVICE_DO7,                                           2152,    7,    1;
;RIU_6B_DEVICE_DI_MASK,                                       2152,    6,    8;
;RIU_6B_DEVICE_DI0,                                           2153,    6,    1;
;RIU_6B_DEVICE_DI1,                                           2153,    5,    1;
;RIU_6B_DEVICE_DI2,                                           2153,    4,    1;
;RIU_6B_DEVICE_DI3,                                           2153,    3,    1;
;RIU_6B_DEVICE_DI4,                                           2153,    2,    1;
;RIU_6B_DEVICE_DI5,                                           2153,    1,    1;
;RIU_6B_DEVICE_DI6,                                           2153,    0,    1;
;RIU_6B_DEVICE_DI7,                                           2154,    7,    1;
;RIU_7B_CH1_ADC_VALID,                                        2154,    6,    1;
;RIU_7B_CH0_ADC_VALID,                                        2154,    5,    1;
;RIU_7B_CH0_COUNTS,                                           2154,    4,   10;
;RIU_7B_CH3_ADC_VALID,                                        2155,    2,    1;
;RIU_7B_CH2_ADC_VALID,                                        2155,    1,    1;
;RIU_7B_CH2_COUNTS,                                           2155,    0,   10;
;RIU_7B_CH5_ADC_VALID,                                        2157,    6,    1;
;RIU_7B_CH4_ADC_VALID,                                        2157,    5,    1;
;RIU_7B_CH7_ADC_VALID,                                        2157,    4,    1;
;RIU_7B_CH6_ADC_VALID,                                        2157,    3,    1;
;RIU_7B_CH9_ADC_VALID,                                        2157,    2,    1;
;RIU_7B_CH8_ADC_VALID,                                        2157,    1,    1;
;RIU_7B_CH8_COUNTS,                                           2157,    0,   10;
;RIU_7B_CH11_ADC_VALID,                                       2159,    6,    1;
;RIU_7B_CH11_COUNTS,                                          2159,    5,   10;
;RIU_7B_CH10_ADC_VALID,                                       2160,    3,    1;
;RIU_7B_CH10_COUNTS,                                          2160,    2,   10;
;RIU_7B_CH13_ADC_VALID,                                       2161,    0,    1;
;RIU_7B_CH13_COUNTS,                                          2162,    7,   10;
;RIU_7B_CH12_ADC_VALID,                                       2163,    5,    1;
;RIU_7B_CH12_COUNTS,                                          2163,    4,   10;
;RIU_7B_CH14_ADC_VALID,                                       2164,    2,    1;
;RIU_7B_CH14_COUNTS,                                          2164,    1,   10;
;RIU_7B_CH15W_ADC_VALID,                                      2166,    7,    1;
;RIU_7B_CH15W_COUNTS,                                         2166,    6,   10;
;RIU_7B_CH15N_ADC_VALID,                                      2167,    4,    1;
;RIU_7B_DEVICE_ID,                                            2167,    3,    4;
;RIU_7B_DEVICE_INDEX,                                         2168,    7,    4;
;RIU_7B_DEVICE_HEALTH_CNT,                                    2168,    3,    8;
;RIU_7B_DEVICE_DO_MASK,                                       2169,    3,    8;
;RIU_7B_DEVICE_DO0,                                           2170,    3,    1;
;RIU_7B_DEVICE_DO1,                                           2170,    2,    1;
;RIU_7B_DEVICE_DO2,                                           2170,    1,    1;
;RIU_7B_DEVICE_DO3,                                           2170,    0,    1;
;RIU_7B_DEVICE_DO4,                                           2171,    7,    1;
;RIU_7B_DEVICE_DO5,                                           2171,    6,    1;
;RIU_7B_DEVICE_DO6,                                           2171,    5,    1;
;RIU_7B_DEVICE_DO7,                                           2171,    4,    1;
;RIU_7B_DEVICE_DI_MASK,                                       2171,    3,    8;
;RIU_7B_DEVICE_DI0,                                           2172,    3,    1;
;RIU_7B_DEVICE_DI1,                                           2172,    2,    1;
;RIU_7B_DEVICE_DI2,                                           2172,    1,    1;
;RIU_7B_DEVICE_DI3,                                           2172,    0,    1;
;RIU_7B_DEVICE_DI4,                                           2173,    7,    1;
;RIU_7B_DEVICE_DI5,                                           2173,    6,    1;
;RIU_7B_DEVICE_DI6,                                           2173,    5,    1;
;RIU_7B_DEVICE_DI7,                                           2173,    4,    1;
;RIU_8B_CH1_ADC_VALID,                                        2173,    3,    1;
;RIU_8B_CH0_COUNTS,                                           2173,    2,   10;
;RIU_8B_CH3_ADC_VALID,                                        2174,    0,    1;
;RIU_8B_CH2_ADC_VALID,                                        2175,    7,    1;
;RIU_8B_CH5_ADC_VALID,                                        2175,    6,    1;
;RIU_8B_CH4_ADC_VALID,                                        2175,    5,    1;
;RIU_8B_CH4_COUNTS,                                           2175,    4,   10;
;RIU_8B_CH7_ADC_VALID,                                        2176,    2,    1;
;RIU_8B_CH6_ADC_VALID,                                        2176,    1,    1;
;RIU_8B_CH9_ADC_VALID,                                        2176,    0,    1;
;RIU_8B_CH9_COUNTS,                                           2177,    7,   10;
;RIU_8B_CH8_ADC_VALID,                                        2178,    5,    1;
;RIU_8B_CH8_COUNTS,                                           2178,    4,   10;
;RIU_8B_CH11_ADC_VALID,                                       2179,    2,    1;
;RIU_8B_CH11_COUNTS,                                          2179,    1,   10;
;RIU_8B_CH10_ADC_VALID,                                       2181,    7,    1;
;RIU_8B_CH10_COUNTS,                                          2181,    6,   10;
;RIU_8B_CH13_ADC_VALID,                                       2182,    4,    1;
;RIU_8B_CH13_COUNTS,                                          2182,    3,   10;
;RIU_8B_CH12_ADC_VALID,                                       2183,    1,    1;
;RIU_8B_CH12_COUNTS,                                          2183,    0,   10;
;RIU_8B_CH14_ADC_VALID,                                       2185,    6,    1;
;RIU_8B_CH14_COUNTS,                                          2185,    5,   10;
;RIU_8B_CH15W_ADC_VALID,                                      2186,    3,    1;
;RIU_8B_CH15W_COUNTS,                                         2186,    2,   10;
;RIU_8B_CH15N_ADC_VALID,                                      2187,    0,    1;
;RIU_8B_CH15N_COUNTS,                                         2188,    7,   10;
;RIU_8B_DEVICE_ID,                                            2189,    5,    4;
;RIU_8B_DEVICE_INDEX,                                         2189,    1,    4;
;RIU_8B_DEVICE_HEALTH_CNT,                                    2190,    5,    8;
;RIU_8B_DEVICE_DO_MASK,                                       2191,    5,    8;
;RIU_8B_DEVICE_DO0,                                           2192,    5,    1;
;RIU_8B_DEVICE_DO1,                                           2192,    4,    1;
;RIU_8B_DEVICE_DO2,                                           2192,    3,    1;
;RIU_8B_DEVICE_DO3,                                           2192,    2,    1;
;RIU_8B_DEVICE_DO4,                                           2192,    1,    1;
;RIU_8B_DEVICE_DO5,                                           2192,    0,    1;
;RIU_8B_DEVICE_DO6,                                           2193,    7,    1;
;RIU_8B_DEVICE_DO7,                                           2193,    6,    1;
;RIU_8B_DEVICE_DI_MASK,                                       2193,    5,    8;
;RIU_8B_DEVICE_DI0,                                           2194,    5,    1;
;RIU_8B_DEVICE_DI1,                                           2194,    4,    1;
;RIU_8B_DEVICE_DI2,                                           2194,    3,    1;
;RIU_8B_DEVICE_DI3,                                           2194,    2,    1;
;RIU_8B_DEVICE_DI4,                                           2194,    1,    1;
;RIU_8B_DEVICE_DI5,                                           2194,    0,    1;
;RIU_8B_DEVICE_DI6,                                           2195,    7,    1;
;RIU_8B_DEVICE_DI7,                                           2195,    6,    1;
;RIU_C1_CH1_ADC_VALID,                                        2195,    5,    1;
;RIU_C1_CH1_COUNTS,                                           2195,    4,   10;
;RIU_C1_CH0_ADC_VALID,                                        2196,    2,    1;
;RIU_C1_CH0_COUNTS,                                           2196,    1,   10;
;RIU_C1_CH3_ADC_VALID,                                        2198,    7,    1;
;RIU_C1_CH3_COUNTS,                                           2198,    6,   10;
;RIU_C1_CH2_ADC_VALID,                                        2199,    4,    1;
;RIU_C1_CH2_COUNTS,                                           2199,    3,   10;
;RIU_C1_CH5_ADC_VALID,                                        2200,    1,    1;
;RIU_C1_CH5_COUNTS,                                           2200,    0,   10;
;RIU_C1_CH4_ADC_VALID,                                        2202,    6,    1;
;RIU_C1_CH4_COUNTS,                                           2202,    5,   10;
;RIU_C1_CH7_ADC_VALID,                                        2203,    3,    1;
;RIU_C1_CH6_ADC_VALID,                                        2203,    2,    1;
;RIU_C1_CH6_COUNTS,                                           2203,    1,   10;
;RIU_C1_CH9_ADC_VALID,                                        2205,    7,    1;
;RIU_C1_CH9_COUNTS,                                           2205,    6,   10;
;RIU_C1_CH8_ADC_VALID,                                        2206,    4,    1;
;RIU_C1_CH8_COUNTS,                                           2206,    3,   10;
;RIU_C1_CH11_ADC_VALID,                                       2207,    1,    1;
;RIU_C1_CH11_COUNTS,                                          2207,    0,   10;
;RIU_C1_CH10_ADC_VALID,                                       2209,    6,    1;
;RIU_C1_CH10_COUNTS,                                          2209,    5,   10;
;RIU_C1_CH13_ADC_VALID,                                       2210,    3,    1;
;RIU_C1_CH13_COUNTS,                                          2210,    2,   10;
;RIU_C1_CH12_ADC_VALID,                                       2211,    0,    1;
;RIU_C1_CH12_COUNTS,                                          2212,    7,   10;
;RIU_C1_CH14_ADC_VALID,                                       2213,    5,    1;
;RIU_C1_CH14_COUNTS,                                          2213,    4,   10;
;RIU_C1_CH15T_ADC_VALID,                                      2214,    2,    1;
;RIU_C1_CH15T_COUNTS,                                         2214,    1,   10;
;RIU_C1_CH15V_ADC_VALID,                                      2216,    7,    1;
;RIU_C1_CH15V_COUNTS,                                         2216,    6,   10;
;RIU_C1_DEVICE_ID,                                            2217,    4,    4;
;RIU_C1_DEVICE_INDEX,                                         2217,    0,    4;
;RIU_C1_DEVICE_HEALTH_CNT,                                    2218,    4,    8;
;RIU_C1_DEVICE_DO_MASK,                                       2219,    4,    8;
;RIU_C1_DEVICE_DO0,                                           2220,    4,    1;
;RIU_C1_DEVICE_DO1,                                           2220,    3,    1;
;RIU_C1_DEVICE_DO2,                                           2220,    2,    1;
;RIU_C1_DEVICE_DO3,                                           2220,    1,    1;
;RIU_C1_DEVICE_DO4,                                           2220,    0,    1;
;RIU_C1_DEVICE_DO5,                                           2221,    7,    1;
;RIU_C1_DEVICE_DO6,                                           2221,    6,    1;
;RIU_C1_DEVICE_DO7,                                           2221,    5,    1;
;RIU_C1_DEVICE_DI_MASK,                                       2221,    4,    8;
;RIU_C1_DEVICE_DI0,                                           2222,    4,    1;
;RIU_C1_DEVICE_DI6,                                           2222,    3,    1;
;RIU_C1_DEVICE_DI7,                                           2222,    2,    1;
;RIU_C2_CH1_ADC_VALID,                                        2222,    1,    1;
;RIU_C2_CH1_COUNTS,                                           2222,    0,   10;
;RIU_C2_CH0_ADC_VALID,                                        2224,    6,    1;
;RIU_C2_CH0_COUNTS,                                           2224,    5,   10;
;RIU_C2_CH3_ADC_VALID,                                        2225,    3,    1;
;RIU_C2_CH3_COUNTS,                                           2225,    2,   10;
;RIU_C2_CH2_ADC_VALID,                                        2226,    0,    1;
;RIU_C2_CH2_COUNTS,                                           2227,    7,   10;
;RIU_C2_CH5_ADC_VALID,                                        2228,    5,    1;
;RIU_C2_CH5_COUNTS,                                           2228,    4,   10;
;RIU_C2_CH4_ADC_VALID,                                        2229,    2,    1;
;RIU_C2_CH4_COUNTS,                                           2229,    1,   10;
;RIU_C2_CH7_ADC_VALID,                                        2231,    7,    1;
;RIU_C2_CH7_COUNTS,                                           2231,    6,   10;
;RIU_C2_CH6_ADC_VALID,                                        2232,    4,    1;
;RIU_C2_CH6_COUNTS,                                           2232,    3,   10;
;RIU_C2_CH9_ADC_VALID,                                        2233,    1,    1;
;RIU_C2_CH9_COUNTS,                                           2233,    0,   10;
;RIU_C2_CH8_ADC_VALID,                                        2235,    6,    1;
;RIU_C2_CH8_COUNTS,                                           2235,    5,   10;
;RIU_C2_CH11_ADC_VALID,                                       2236,    3,    1;
;RIU_C2_CH11_COUNTS,                                          2236,    2,   10;
;RIU_C2_CH10_ADC_VALID,                                       2237,    0,    1;
;RIU_C2_CH10_COUNTS,                                          2238,    7,   10;
;RIU_C2_CH13_ADC_VALID,                                       2239,    5,    1;
;RIU_C2_CH13_COUNTS,                                          2239,    4,   10;
;RIU_C2_CH12_ADC_VALID,                                       2240,    2,    1;
;RIU_C2_CH12_COUNTS,                                          2240,    1,   10;
;RIU_C2_CH14_ADC_VALID,                                       2242,    7,    1;
;RIU_C2_CH14_COUNTS,                                          2242,    6,   10;
;RIU_C2_CH15T_ADC_VALID,                                      2243,    4,    1;
;RIU_C2_CH15T_COUNTS,                                         2243,    3,   10;
;RIU_C2_CH15V_ADC_VALID,                                      2244,    1,    1;
;RIU_C2_CH15V_COUNTS,                                         2244,    0,   10;
;RIU_C2_DEVICE_ID,                                            2246,    6,    4;
;RIU_C2_DEVICE_INDEX,                                         2246,    2,    4;
;RIU_C2_DEVICE_HEALTH_CNT,                                    2247,    6,    8;
;RIU_C2_DEVICE_DO_MASK,                                       2248,    6,    8;
;RIU_C2_DEVICE_DO0,                                           2249,    6,    1;
;RIU_C2_DEVICE_DO1,                                           2249,    5,    1;
;RIU_C2_DEVICE_DO2,                                           2249,    4,    1;
;RIU_C2_DEVICE_DO3,                                           2249,    3,    1;
;RIU_C2_DEVICE_DO4,                                           2249,    2,    1;
;RIU_C2_DEVICE_DO5,                                           2249,    1,    1;
;RIU_C2_DEVICE_DO6,                                           2249,    0,    1;
;RIU_C2_DEVICE_DO7,                                           2250,    7,    1;
;RIU_C2_DEVICE_DI_MASK,                                       2250,    6,    8;
;RIU_C2_DEVICE_DI0,                                           2251,    6,    1;
;RIU_C2_DEVICE_DI5,                                           2251,    5,    1;
;RIU_C2_DEVICE_DI6,                                           2251,    4,    1;
;RIU_C2_DEVICE_DI7,                                           2251,    3,    1;
;PDU_THR_BUS_GRP_1_TAC_A_PWR_STATE_GRP22,                     2251,    2,    2;
;PDU_THR_BUS_GRP_1_TAC_A_BRKR_TRIP_STATE_GRP22,               2251,    0,    1;
;PDU_THR_BUS_GRP_1_TAC_A_PWR_SET_STATE_GRP22,                 2252,    7,    1;
;PDU_THR_BUS_GRP_2_TAC_A_ENA_STATE_GRP22,                     2252,    6,    1;
;PDU_THR_BUS_GRP_1_TAC_A_ENA_STATE_GRP22,                     2252,    5,    1;
;PDU_THR_BUS_GRP_1_TAC_B_BRKR_SET_STATE_GRP22,                2252,    4,    1;
;PDU_THR_BUS_GRP_1_TAC_B_PWR_STATE_GRP22,                     2252,    3,    2;
;PDU_THR_BUS_GRP_1_TAC_B_BRKR_TRIP_STATE_GRP22,               2252,    1,    1;
;PDU_THR_BUS_GRP_1_TAC_B_PWR_SET_STATE_GRP22,                 2252,    0,    1;
;PDU_THR_BUS_GRP_2_TAC_B_ENA_STATE_GRP22,                     2253,    7,    1;
;PDU_THR_BUS_GRP_1_TAC_B_ENA_STATE_GRP22,                     2253,    6,    1;
;PDU_RED_RPM_ARC_A_CURR,                                      2253,    5,    8;
;PDU_RED_RPM_SBCC_CURR,                                       2254,    5,    8;
;PDU_RED_RPM_SBCA_CURR,                                       2255,    5,    8;
;PDU_RED_RPM_ARC_B_CURR,                                      2256,    5,    8;
;PDU_RED_RPM_ARC_C_CURR,                                      2257,    5,    8;
;PDU_RED_RPM_SBCB_CURR,                                       2258,    5,    8;
;MCA_TLM_HK_PREAMBLE,                                         2259,    5,   32;
;MCA_TLM_HK_DATE_CODE,                                        2263,    5,   32;
;MCA_TLM_HK_MC_SEL,                                           2267,    5,    2;
;MCA_TLM_HK_NV_MEM_BANK2_WRITE_PROT_ENA,                      2267,    3,    1;
;MCA_TLM_HK_NV_MEM_BANK1_WRITE_PROT_ENA,                      2267,    2,    1;
;MCA_TLM_HK_ZERO_BIT,                                         2267,    1,    1;
;MCA_TLM_HK_TARGET_SBC_PHYS_ID,                               2267,    0,    3;
;MCA_TLM_HK_SBCA_RESYNC_RCVD_FLAG,                            2268,    5,    1;
;MCA_TLM_HK_SBCA_BOOT_TIMER,                                  2268,    4,    1;
;MCA_TLM_HK_SBCA_OVFLW_CMD_CNT,                               2268,    3,    2;
;MCA_TLM_HK_SBCA_LOGICAL_STATES,                              2268,    1,    4;
;MCA_TLM_HK_SBCA_INVAL_CMD_CNT,                               2269,    5,    4;
;MCA_TLM_HK_SBCA_VAL_CMD_CNT,                                 2269,    1,    4;
;MCA_TLM_HK_SBCB_RESYNC_RCVD_FLAG,                            2270,    5,    1;
;MCA_TLM_HK_SBCB_BOOT_TIMER,                                  2270,    4,    1;
;MCA_TLM_HK_SBCB_OVFLW_CMD_CNT,                               2270,    3,    2;
;MCA_TLM_HK_SBCB_LOGICAL_STATES,                              2270,    1,    4;
;MCA_TLM_HK_SBCB_INVAL_CMD_CNT,                               2271,    5,    4;
;MCA_TLM_HK_SBCB_VAL_CMD_CNT,                                 2271,    1,    4;
;MCA_TLM_HK_SBCC_RESYNC_RCVD_FLAG,                            2272,    5,    1;
;MCA_TLM_HK_SBCC_BOOT_TIMER,                                  2272,    4,    1;
;MCA_TLM_HK_SBCC_OVFLW_CMD_CNT,                               2272,    3,    2;
;MCA_TLM_HK_SBCC_LOGICAL_STATES,                              2272,    1,    4;
;MCA_TLM_HK_SBCC_INVAL_CMD_CNT,                               2273,    5,    4;
;MCA_TLM_HK_SBCC_VAL_CMD_CNT,                                 2273,    1,    4;
;MCA_TLM_HK_CCD_NEW_CMD,                                      2274,    5,    1;
;MCA_TLM_HK_CCD_DENIED_CMD,                                   2274,    4,    1;
;MCA_TLM_HK_CCDA_OVFLW_CMD_CNT,                               2274,    3,    2;
;MCA_TLM_HK_CCDA_VAL_CMD_CNT,                                 2274,    1,    4;
;MCA_TLM_HK_CCDA_INVAL_CMD_CNT,                               2275,    5,    4;
;MCA_TLM_HK_CCDA_DENIED_CMD_CNT,                              2275,    1,    4;
;MCA_TLM_HK_INTER_MC0_STATUS_TIMEOUT,                         2276,    5,    1;
;MCA_TLM_HK_INTER_MC1_STATUS_TIMEOUT,                         2276,    4,    1;
;MCA_TLM_HK_CCDB_OVFLW_CMD_CNT,                               2276,    3,    2;
;MCA_TLM_HK_CCDB_VAL_CMD_CNT,                                 2276,    1,    4;
;MCA_TLM_HK_CCDB_INVAL_CMD_CNT,                               2277,    5,    4;
;MCA_TLM_HK_CCDB_DENIED_CMD_CNT,                              2277,    1,    4;
;MCA_TLM_HK_SW_VOTES_SBCA_PWR_STATE,                          2278,    5,    1;
;MCA_TLM_HK_SW_VOTES_REMA_PWR_STATE,                          2278,    4,    1;
;MCA_TLM_HK_SW_VOTES_PDUA_PWR_STATE,                          2278,    3,    1;
;MCA_TLM_HK_SW_VOTES_SBCB_PWR_STATE,                          2278,    2,    1;
;MCA_TLM_HK_SW_VOTES_REMB_PWR_STATE,                          2278,    1,    1;
;MCA_TLM_HK_SW_VOTES_RADIOA_PWR_STATE,                        2278,    0,    1;
;MCA_TLM_HK_SW_VOTES_SBCC_PWR_STATE,                          2279,    7,    1;
;MCA_TLM_HK_SW_VOTES_RADIOB_PWR_STATE,                        2279,    6,    1;
;MCA_TLM_HK_SW_VOTES_PDUB_PWR_STATE,                          2279,    5,    1;
;MCA_TLM_HK_BACKUP_FAILED_PWR_STATE,                          2279,    4,    1;
;MCA_TLM_HK_HS_ACK_TIMER_EXPIRED,                             2279,    3,    1;
;MCA_TLM_HK_RESYNC_EXEC,                                      2279,    2,    1;
;MCA_TLM_HK_TRANSITION_CNTR,                                  2279,    1,    4;
;MCA_TLM_HK_TRANSITION_N1_PREV_STATE,                         2280,    5,    4;
;MCA_TLM_HK_TRANSITION_N1_CAUSE,                              2280,    1,    4;
;MCA_TLM_HK_TRANSITION_N2_PREV_STATE,                         2281,    5,    4;
;MCA_TLM_HK_TRANSITION_N2_CAUSE,                              2281,    1,    4;
;MCA_TLM_HK_TRANSITION_N3_PREV_STATE,                         2282,    5,    4;
;MCA_TLM_HK_TRANSITION_N3_CAUSE,                              2282,    1,    4;
;MCA_TLM_HK_TRANSITION_N4_PREV_STATE,                         2283,    5,    4;
;MCA_TLM_HK_TRANSITION_N4_CAUSE,                              2283,    1,    4;
;MCA_TLM_HK_REMOTE_MC_0_SBCA_DEBUG_LS,                        2284,    5,    4;
;MCA_TLM_HK_REMOTE_MC_0_SBCB_DEBUG_LS,                        2284,    1,    4;
;MCA_TLM_HK_REMOTE_MC_0_SBCC_DEBUG_LS,                        2285,    5,    4;
;MCA_TLM_HK_REMOTE_MC_1_SBCA_DEBUG_LS,                        2285,    1,    4;
;MCA_TLM_HK_REMOTE_MC_1_SBCB_DEBUG_LS,                        2286,    5,    4;
;MCA_TLM_HK_REMOTE_MC_1_SBCC_DEBUG_LS,                        2286,    1,    4;
;MCA_TLM_HK_NO_VOTE,                                          2287,    5,    1;
;MCA_TLM_HK_RESYNC_NEEDED,                                    2287,    4,    1;
;MCA_TLM_HK_GRP2_JUMPER_A,                                    2287,    3,    1;
;MCA_TLM_HK_GRP2_JUMPER_B,                                    2287,    2,    1;
;MCA_TLM_HK_GRP2_JUMPER_C,                                    2287,    1,    1;
;MCA_TLM_HK_GRP1_JUMPER_A,                                    2287,    0,    1;
;MCA_TLM_HK_GRP1_JUMPER_B,                                    2288,    7,    1;
;MCA_TLM_HK_GRP1_JUMPER_C,                                    2288,    6,    1;
;MCA_TLM_HK_XOR_CKSM,                                         2288,    5,   16;
;MCB_TLM_HK_PREAMBLE,                                         2290,    5,   32;
;MCB_TLM_HK_DATE_CODE,                                        2294,    5,   32;
;MCB_TLM_HK_MC_SEL,                                           2298,    5,    2;
;MCB_TLM_HK_NV_MEM_BANK2_WRITE_PROT_ENA,                      2298,    3,    1;
;MCB_TLM_HK_NV_MEM_BANK1_WRITE_PROT_ENA,                      2298,    2,    1;
;MCB_TLM_HK_ZERO_BIT,                                         2298,    1,    1;
;MCB_TLM_HK_TARGET_SBC_PHYS_ID,                               2298,    0,    3;
;MCB_TLM_HK_SBCA_RESYNC_RCVD_FLAG,                            2299,    5,    1;
;MCB_TLM_HK_SBCA_BOOT_TIMER,                                  2299,    4,    1;
;MCB_TLM_HK_SBCA_OVFLW_CMD_CNT,                               2299,    3,    2;
;MCB_TLM_HK_SBCA_LOGICAL_STATES,                              2299,    1,    4;
;MCB_TLM_HK_SBCA_INVAL_CMD_CNT,                               2300,    5,    4;
;MCB_TLM_HK_SBCA_VAL_CMD_CNT,                                 2300,    1,    4;
;MCB_TLM_HK_SBCB_RESYNC_RCVD_FLAG,                            2301,    5,    1;
;MCB_TLM_HK_SBCB_BOOT_TIMER,                                  2301,    4,    1;
;MCB_TLM_HK_SBCB_OVFLW_CMD_CNT,                               2301,    3,    2;
;MCB_TLM_HK_SBCB_LOGICAL_STATES,                              2301,    1,    4;
;MCB_TLM_HK_SBCB_INVAL_CMD_CNT,                               2302,    5,    4;
;MCB_TLM_HK_SBCB_VAL_CMD_CNT,                                 2302,    1,    4;
;MCB_TLM_HK_SBCC_RESYNC_RCVD_FLAG,                            2303,    5,    1;
;MCB_TLM_HK_SBCC_BOOT_TIMER,                                  2303,    4,    1;
;MCB_TLM_HK_SBCC_OVFLW_CMD_CNT,                               2303,    3,    2;
;MCB_TLM_HK_SBCC_LOGICAL_STATES,                              2303,    1,    4;
;MCB_TLM_HK_SBCC_INVAL_CMD_CNT,                               2304,    5,    4;
;MCB_TLM_HK_SBCC_VAL_CMD_CNT,                                 2304,    1,    4;
;MCB_TLM_HK_CCD_NEW_CMD,                                      2305,    5,    1;
;MCB_TLM_HK_CCD_DENIED_CMD,                                   2305,    4,    1;
;MCB_TLM_HK_CCDA_OVFLW_CMD_CNT,                               2305,    3,    2;
;MCB_TLM_HK_CCDA_VAL_CMD_CNT,                                 2305,    1,    4;
;MCB_TLM_HK_CCDA_INVAL_CMD_CNT,                               2306,    5,    4;
;MCB_TLM_HK_CCDA_DENIED_CMD_CNT,                              2306,    1,    4;
;MCB_TLM_HK_INTER_MC0_STATUS_TIMEOUT,                         2307,    5,    1;
;MCB_TLM_HK_INTER_MC1_STATUS_TIMEOUT,                         2307,    4,    1;
;MCB_TLM_HK_CCDB_OVFLW_CMD_CNT,                               2307,    3,    2;
;MCB_TLM_HK_CCDB_VAL_CMD_CNT,                                 2307,    1,    4;
;MCB_TLM_HK_CCDB_INVAL_CMD_CNT,                               2308,    5,    4;
;MCB_TLM_HK_CCDB_DENIED_CMD_CNT,                              2308,    1,    4;
;MCB_TLM_HK_SW_VOTES_SBCA_PWR_STATE,                          2309,    5,    1;
;MCB_TLM_HK_SW_VOTES_REMA_PWR_STATE,                          2309,    4,    1;
;MCB_TLM_HK_SW_VOTES_PDUA_PWR_STATE,                          2309,    3,    1;
;MCB_TLM_HK_SW_VOTES_SBCB_PWR_STATE,                          2309,    2,    1;
;MCB_TLM_HK_SW_VOTES_REMB_PWR_STATE,                          2309,    1,    1;
;MCB_TLM_HK_SW_VOTES_RADIOA_PWR_STATE,                        2309,    0,    1;
;MCB_TLM_HK_SW_VOTES_SBCC_PWR_STATE,                          2310,    7,    1;
;MCB_TLM_HK_SW_VOTES_RADIOB_PWR_STATE,                        2310,    6,    1;
;MCB_TLM_HK_SW_VOTES_PDUB_PWR_STATE,                          2310,    5,    1;
;MCB_TLM_HK_BACKUP_FAILED_PWR_STATE,                          2310,    4,    1;
;MCB_TLM_HK_HS_ACK_TIMER_EXPIRED,                             2310,    3,    1;
;MCB_TLM_HK_RESYNC_EXEC,                                      2310,    2,    1;
;MCB_TLM_HK_TRANSITION_CNTR,                                  2310,    1,    4;
;MCB_TLM_HK_TRANSITION_N1_PREV_STATE,                         2311,    5,    4;
;MCB_TLM_HK_TRANSITION_N1_CAUSE,                              2311,    1,    4;
;MCB_TLM_HK_TRANSITION_N2_PREV_STATE,                         2312,    5,    4;
;MCB_TLM_HK_TRANSITION_N2_CAUSE,                              2312,    1,    4;
;MCB_TLM_HK_TRANSITION_N3_PREV_STATE,                         2313,    5,    4;
;MCB_TLM_HK_TRANSITION_N3_CAUSE,                              2313,    1,    4;
;MCB_TLM_HK_TRANSITION_N4_PREV_STATE,                         2314,    5,    4;
;MCB_TLM_HK_TRANSITION_N4_CAUSE,                              2314,    1,    4;
;MCB_TLM_HK_REMOTE_MC_0_SBCA_DEBUG_LS,                        2315,    5,    4;
;MCB_TLM_HK_REMOTE_MC_0_SBCB_DEBUG_LS,                        2315,    1,    4;
;MCB_TLM_HK_REMOTE_MC_0_SBCC_DEBUG_LS,                        2316,    5,    4;
;MCB_TLM_HK_REMOTE_MC_1_SBCA_DEBUG_LS,                        2316,    1,    4;
;MCB_TLM_HK_REMOTE_MC_1_SBCB_DEBUG_LS,                        2317,    5,    4;
;MCB_TLM_HK_REMOTE_MC_1_SBCC_DEBUG_LS,                        2317,    1,    4;
;MCB_TLM_HK_NO_VOTE,                                          2318,    5,    1;
;MCB_TLM_HK_RESYNC_NEEDED,                                    2318,    4,    1;
;MCB_TLM_HK_GRP2_JUMPER_A,                                    2318,    3,    1;
;MCB_TLM_HK_GRP2_JUMPER_B,                                    2318,    2,    1;
;MCB_TLM_HK_GRP2_JUMPER_C,                                    2318,    1,    1;
;MCB_TLM_HK_GRP1_JUMPER_A,                                    2318,    0,    1;
;MCB_TLM_HK_GRP1_JUMPER_B,                                    2319,    7,    1;
;MCB_TLM_HK_GRP1_JUMPER_C,                                    2319,    6,    1;
;MCB_TLM_HK_XOR_CKSM,                                         2319,    5,   16;
;MCC_TLM_HK_PREAMBLE,                                         2321,    5,   32;
;MCC_TLM_HK_DATE_CODE,                                        2325,    5,   32;
;MCC_TLM_HK_MC_SEL,                                           2329,    5,    2;
;MCC_TLM_HK_NV_MEM_BANK2_WRITE_PROT_ENA,                      2329,    3,    1;
;MCC_TLM_HK_NV_MEM_BANK1_WRITE_PROT_ENA,                      2329,    2,    1;
;MCC_TLM_HK_ZERO_BIT,                                         2329,    1,    1;
;MCC_TLM_HK_TARGET_SBC_PHYS_ID,                               2329,    0,    3;
;MCC_TLM_HK_SBCA_RESYNC_RCVD_FLAG,                            2330,    5,    1;
;MCC_TLM_HK_SBCA_BOOT_TIMER,                                  2330,    4,    1;
;MCC_TLM_HK_SBCA_OVFLW_CMD_CNT,                               2330,    3,    2;
;MCC_TLM_HK_SBCA_LOGICAL_STATES,                              2330,    1,    4;
;MCC_TLM_HK_SBCA_INVAL_CMD_CNT,                               2331,    5,    4;
;MCC_TLM_HK_SBCA_VAL_CMD_CNT,                                 2331,    1,    4;
;MCC_TLM_HK_SBCB_RESYNC_RCVD_FLAG,                            2332,    5,    1;
;MCC_TLM_HK_SBCB_BOOT_TIMER,                                  2332,    4,    1;
;MCC_TLM_HK_SBCB_OVFLW_CMD_CNT,                               2332,    3,    2;
;MCC_TLM_HK_SBCB_LOGICAL_STATES,                              2332,    1,    4;
;MCC_TLM_HK_SBCB_INVAL_CMD_CNT,                               2333,    5,    4;
;MCC_TLM_HK_SBCB_VAL_CMD_CNT,                                 2333,    1,    4;
;MCC_TLM_HK_SBCC_RESYNC_RCVD_FLAG,                            2334,    5,    1;
;MCC_TLM_HK_SBCC_BOOT_TIMER,                                  2334,    4,    1;
;MCC_TLM_HK_SBCC_OVFLW_CMD_CNT,                               2334,    3,    2;
;MCC_TLM_HK_SBCC_LOGICAL_STATES,                              2334,    1,    4;
;MCC_TLM_HK_SBCC_INVAL_CMD_CNT,                               2335,    5,    4;
;MCC_TLM_HK_SBCC_VAL_CMD_CNT,                                 2335,    1,    4;
;MCC_TLM_HK_CCD_NEW_CMD,                                      2336,    5,    1;
;MCC_TLM_HK_CCD_DENIED_CMD,                                   2336,    4,    1;
;MCC_TLM_HK_CCDA_OVFLW_CMD_CNT,                               2336,    3,    2;
;MCC_TLM_HK_CCDA_VAL_CMD_CNT,                                 2336,    1,    4;
;MCC_TLM_HK_CCDA_INVAL_CMD_CNT,                               2337,    5,    4;
;MCC_TLM_HK_CCDA_DENIED_CMD_CNT,                              2337,    1,    4;
;MCC_TLM_HK_INTER_MC0_STATUS_TIMEOUT,                         2338,    5,    1;
;MCC_TLM_HK_INTER_MC1_STATUS_TIMEOUT,                         2338,    4,    1;
;MCC_TLM_HK_CCDB_OVFLW_CMD_CNT,                               2338,    3,    2;
;MCC_TLM_HK_CCDB_VAL_CMD_CNT,                                 2338,    1,    4;
;MCC_TLM_HK_CCDB_INVAL_CMD_CNT,                               2339,    5,    4;
;MCC_TLM_HK_CCDB_DENIED_CMD_CNT,                              2339,    1,    4;
;MCC_TLM_HK_SW_VOTES_SBCA_PWR_STATE,                          2340,    5,    1;
;MCC_TLM_HK_SW_VOTES_REMA_PWR_STATE,                          2340,    4,    1;
;MCC_TLM_HK_SW_VOTES_PDUA_PWR_STATE,                          2340,    3,    1;
;MCC_TLM_HK_SW_VOTES_SBCB_PWR_STATE,                          2340,    2,    1;
;MCC_TLM_HK_SW_VOTES_REMB_PWR_STATE,                          2340,    1,    1;
;MCC_TLM_HK_SW_VOTES_RADIOA_PWR_STATE,                        2340,    0,    1;
;MCC_TLM_HK_SW_VOTES_SBCC_PWR_STATE,                          2341,    7,    1;
;MCC_TLM_HK_SW_VOTES_RADIOB_PWR_STATE,                        2341,    6,    1;
;MCC_TLM_HK_SW_VOTES_PDUB_PWR_STATE,                          2341,    5,    1;
;MCC_TLM_HK_BACKUP_FAILED_PWR_STATE,                          2341,    4,    1;
;MCC_TLM_HK_HS_ACK_TIMER_EXPIRED,                             2341,    3,    1;
;MCC_TLM_HK_RESYNC_EXEC,                                      2341,    2,    1;
;MCC_TLM_HK_TRANSITION_CNTR,                                  2341,    1,    4;
;MCC_TLM_HK_TRANSITION_N1_PREV_STATE,                         2342,    5,    4;
;MCC_TLM_HK_TRANSITION_N1_CAUSE,                              2342,    1,    4;
;MCC_TLM_HK_TRANSITION_N2_PREV_STATE,                         2343,    5,    4;
;MCC_TLM_HK_TRANSITION_N2_CAUSE,                              2343,    1,    4;
;MCC_TLM_HK_TRANSITION_N3_PREV_STATE,                         2344,    5,    4;
;MCC_TLM_HK_TRANSITION_N3_CAUSE,                              2344,    1,    4;
;MCC_TLM_HK_TRANSITION_N4_PREV_STATE,                         2345,    5,    4;
;MCC_TLM_HK_TRANSITION_N4_CAUSE,                              2345,    1,    4;
;MCC_TLM_HK_REMOTE_MC_0_SBCA_DEBUG_LS,                        2346,    5,    4;
;MCC_TLM_HK_REMOTE_MC_0_SBCB_DEBUG_LS,                        2346,    1,    4;
;MCC_TLM_HK_REMOTE_MC_0_SBCC_DEBUG_LS,                        2347,    5,    4;
;MCC_TLM_HK_REMOTE_MC_1_SBCA_DEBUG_LS,                        2347,    1,    4;
;MCC_TLM_HK_REMOTE_MC_1_SBCB_DEBUG_LS,                        2348,    5,    4;
;MCC_TLM_HK_REMOTE_MC_1_SBCC_DEBUG_LS,                        2348,    1,    4;
;MCC_TLM_HK_NO_VOTE,                                          2349,    5,    1;
;MCC_TLM_HK_RESYNC_NEEDED,                                    2349,    4,    1;
;MCC_TLM_HK_GRP2_JUMPER_A,                                    2349,    3,    1;
;MCC_TLM_HK_GRP2_JUMPER_B,                                    2349,    2,    1;
;MCC_TLM_HK_GRP2_JUMPER_C,                                    2349,    1,    1;
;MCC_TLM_HK_GRP1_JUMPER_A,                                    2349,    0,    1;
;MCC_TLM_HK_GRP1_JUMPER_B,                                    2350,    7,    1;
;MCC_TLM_HK_GRP1_JUMPER_C,                                    2350,    6,    1;
;MCC_TLM_HK_XOR_CKSM,                                         2350,    5,   16;
;RIU_9A_CH0_COUNTS,                                           2352,    5,   10;
;RIU_9A_CH1_COUNTS,                                           2353,    3,   10;
;RIU_9A_CH2_COUNTS,                                           2354,    1,   10;
;RIU_9A_CH3_COUNTS,                                           2356,    7,   10;
;RIU_9A_CH4_COUNTS,                                           2357,    5,   10;
;RIU_9A_CH5_COUNTS,                                           2358,    3,   10;
;RIU_9A_CH6_COUNTS,                                           2359,    1,   10;
;RIU_9A_CH7_COUNTS,                                           2361,    7,   10;
;RIU_9A_CH8_COUNTS,                                           2362,    5,   10;
;RIU_9A_CH9_COUNTS,                                           2363,    3,   10;
;RIU_9A_CH10_COUNTS,                                          2364,    1,   10;
;RIU_9A_CH11_COUNTS,                                          2366,    7,   10;
;RIU_9A_CH12_COUNTS,                                          2367,    5,   10;
;RIU_9A_CH13_COUNTS,                                          2368,    3,   10;
;RIU_9A_CH14_COUNTS,                                          2369,    1,   10;
;RIU_9B_CH0_COUNTS,                                           2371,    7,   10;
;RIU_9B_CH1_COUNTS,                                           2372,    5,   10;
;RIU_9B_CH2_COUNTS,                                           2373,    3,   10;
;RIU_9B_CH3_COUNTS,                                           2374,    1,   10;
;RIU_9B_CH4_COUNTS,                                           2376,    7,   10;
;RIU_9B_CH5_COUNTS,                                           2377,    5,   10;
;RIU_9B_CH6_COUNTS,                                           2378,    3,   10;
;RIU_9B_CH7_COUNTS,                                           2379,    1,   10;
;RIU_9B_CH8_COUNTS,                                           2381,    7,   10;
;RIU_9B_CH9_COUNTS,                                           2382,    5,   10;
;RIU_9B_CH10_COUNTS,                                          2383,    3,   10;
;RIU_9B_CH11_COUNTS,                                          2384,    1,   10;
;RIU_9B_CH12_COUNTS,                                          2386,    7,   10;
;RIU_9B_CH13_COUNTS,                                          2387,    5,   10;
;RIU_9B_CH14_COUNTS,                                          2388,    3,   10;
;RIU_9A_CH0_ADC_VALID,                                        2389,    1,    1;
;RIU_9A_CH15W_ADC_VALID,                                      2389,    0,    1;
;RIU_9A_CH15W_COUNTS,                                         2390,    7,   10;
;RIU_9A_CH15N_ADC_VALID,                                      2391,    5,    1;
;RIU_9A_CH15N_COUNTS,                                         2391,    4,   10;
;RIU_9B_CH0_ADC_VALID,                                        2392,    2,    1;
;RIU_9B_CH15W_ADC_VALID,                                      2392,    1,    1;
;RIU_9B_CH15W_COUNTS,                                         2392,    0,   10;
;RIU_9B_CH15N_ADC_VALID,                                      2394,    6,    1;
;RIU_9B_CH15N_COUNTS,                                         2394,    5,   10;
;SC_HK_LOW_DERIVED_TRIGGER_PT,                                2394,    5,   10;
;}
