;+
;PROCEDURE:	mvn_sta_hkp_cal
;PURPOSE:	
;	Calibrates STATIC tplot housekeeping generated by mav_sta_misg_decom.pro
;INPUT:		
;	time:		dbl		time of data to be returned
;
;KEYWORDS:
;
;
;CREATED BY:	J. McFadden
;VERSION:	1
;LAST MODIFICATION:  2013/05/07
;MOD HISTORY:
;
;NOTES:	  
;	
;-
pro mvn_sta_hkp_cal,def_lim=def_lim


ch=['0','1','2','3','4','5','6','7','8','9','10','11','12','13','14','15','16','17','18','19'$
	,'20','21','22','23','24','25','26','27','28','29','30','31','32','33','34','35','36','37','38','39'$
	,'40','41','42','43','44','45','46','47','48','49','50','51','52','53','54','55','56','57','58','59'$
	,'60','61','62','63','64','65','66','67','68','69','70','71','72','73','74','75','76','77','78','79'$
	,'80','81','82','83','84','85','86','87','88','89','90','91','92','93','94','95','96','97','98'$
	]

name=['Temp_Dig','Imon_ADC5V','+5V_D','+3.3V_D','+5V_A','-5V_A','+12V_A','+28V',$
	'Vmon_Swp','Vmon_Swp_Err','Vmon_Def1','Vmon_Def1_Err','Vmon_Def2','Vmon_Def2_Err','Vmon_Vgrid','Temp_FPGA',$
	'Imon_15kV','Vmon_15kV','Imon_MCP','Vmon_MCP','Imon_Raw','Vmon_Def_Raw','Temp_LVPS','Vmon_Swp_Raw']

name2=['Temp!CDig','Imon!CADC5V','+5VD','+3.3VD','+5VA','-5VA','+12VA','+28V',$
	'Vmon!CSwp','Vmon!CSwpErr','Vmon!CDef1','Vmon!CDef1Err','Vmon!CDef2','Vmon!CDef2Err','Vmon!CVgrid','Temp!CFPGA',$
	'Imon!C15kV','Vmon!C15kV','Imon!CMCP','Vmon!CMCP','Imon!CRaw','Vmon!CDefRaw','Temp!CLVPS','Vmon!CSwpRaw']

A0=[1.6484E+02,0.,0.,0.,0.,0.,0.,0.,$
	0.,0.,0.,0.,0.,0.,0.,1.6484E+02,$
	0.,0.,0.,0.,0.,0.,2.3037E+02,0.]

A1=[3.9360E-02,-0.030518,-0.000191,-0.000153,-0.000191,-0.000191,-0.000458,-0.001097,$
	0.152588,-0.000153,-0.152740,-0.000153,-0.152740,-0.000153,-0.000951,3.9360E-02,$
	-0.001176,0.571490,-0.003101,-0.143006,-0.000763,-0.189468,5.8791E-02,-0.189468]

aa=[0,15]
A2=replicate(0.,24) & A2[aa]=5.6761E-06 & A2[22]=8.8802E-06
A3=replicate(0.,24) & A3[aa]=4.4329E-10 & A3[22]=6.9447E-10
A4=replicate(0.,24) & A4[aa]=1.6701E-14 & A4[22]=2.5920E-14
A5=replicate(0.,24) & A5[aa]=2.4223E-19 & A5[22]=3.6994E-19
A6=replicate(0.,24) 
A7=replicate(0.,24) 

	hkp_par = dblarr(8,99)
	hkp_par[*,*]=1.d
	hkp_par[0,0:23]=A0
	hkp_par[1,0:23]=A1
	hkp_par[2,0:23]=A2
	hkp_par[3,0:23]=A3
	hkp_par[4,0:23]=A4
	hkp_par[5,0:23]=A5
	hkp_par[6,0:23]=A6
	hkp_par[7,0:23]=A7

	get_data,'mvn_STA_2A_CH'+ch[0],data=t
	ind1 = where(t.x gt 0, ndis)
	tdis = t.x[ind1]
	hkp_raw = intarr(ndis,99)
	hkp 	= fltarr(ndis,99)

for i=0,23 do begin
	get_data,'mvn_STA_2A_CH'+ch[i],data=t
	if size(/type,t) eq 8 then begin
		ind1 = where(t.x gt 0, nn)
		tt=t.x[ind1]
		tc=t.y[ind1]*1.d
		yc=A0[i]+A1[i]*tc+A2[i]*tc^2+A3[i]*tc^3+A4[i]*tc^4+A5[i]*tc^5+A6[i]*tc^6+A7[i]*tc^7
		store_data,'mvn_sta_2A_hkp_ch'+ch[i]+'_'+name[i],data={x:tt,y:yc}
		options,'mvn_sta_2A_hkp_ch'+ch[i]+'_'+name[i],'ytitle','STA!C'+name2[i]
		if nn eq ndis then begin
			hkp_raw[*,i] = t.y[ind1]
			hkp[*,i] = yc
		endif else print,'Error in storing housekeeping: ndis is not equal nn  CH=',ch[i]
	endif
endfor

if keyword_set(def_lim) then begin

		ylim,'mvn_sta_2A_hkp_ch0_Temp_Dig',0,60,0
		ylim,'mvn_sta_2A_hkp_ch1_Imon_ADC5V',30,36,0
		ylim,'mvn_sta_2A_hkp_ch2_+5V_D',4.9,5.2,0
		ylim,'mvn_sta_2A_hkp_ch3_+3.3V_D',3.2,3.4,0
		ylim,'mvn_sta_2A_hkp_ch4_+5V_A',4.9,5.2,0
		ylim,'mvn_sta_2A_hkp_ch5_-5V_A',-5.3,-5.0,0
		ylim,'mvn_sta_2A_hkp_ch6_+12V_A',11.9,12.3,0
		ylim,'mvn_sta_2A_hkp_ch15_Temp_FPGA',0,60,0
		ylim,'mvn_sta_2A_hkp_ch22_Temp_LVPS',0,60,0

		get_data,'mvn_sta_2A_hkp_ch8_Vmon_Swp',data=tmp
		store_data,'mvn_sta_2A_hkp_ch8_Vmon_Swp_minus',data={x:tmp.x,y:-tmp.y}
		ylim,'mvn_sta_2A_hkp_ch8_Vmon_Swp_minus',.1,10000.,1
		ylim,'mvn_sta_2A_hkp_ch10_Vmon_Def1',.1,10000.,1
		ylim,'mvn_sta_2A_hkp_ch12_Vmon_Def2',.1,10000.,1

endif

; Misc HKP values

name3=['modeID','Opts'$
	,'P1ASVY','P1BSVY','P1CSVY','P1DSVY','P2SVY','P3SVY','P4SVY','P4ARC'$
	,'P4ESVY','spare','PEVTSVY','PFSKSVY','PR1SVY','PR2SVY','PR3SVY','PMHSVY'$
	,'LUTADR0','LUTADR1','LUTADR2','LUTADR3','LUTADR4','LUTADR5','LUTADR6','LUTADR7','LUTADR8','LUTADR9','LUTADR10','LUTADR11'$
	,'CSNLMT','CSMCTR','RSTLMT','RSTCTR','FHSKMux0','FHSKMux1','FHSKMux2','FHSKMux3','ODACStepSize','R3Rate','AttenPeriod'$
	,'Config0','Config1','Config2','Config3','Config4','Config5','Config6','Config7'$
	,'SSCTL','STACCTL','MCPDAC','CNTLDAC','ACCDAC','EVPCTL','ANALDAC','DEF1DAC','DEF2DAC'$
	,'ChkSumLUT0','ChkSumLUT1','ChkSumLUT2','ChkSumLUT3','ChkSumLUT4','ChkSumLUT5','ChkSumLUT6','ChkSumLUT7','ChkSumLUT8','ChkSumLUT9','ChkSumLUT10','ChkSumLUT11'$
	,'CmdCount','RegData','MemMode','Fixed_Diag_Feedback','DigHsk'$
	]

	hkp_lab = [name,name3]

for i=24,98 do begin
	get_data,'mvn_STA_2A_CH'+ch[i],data=t
	if size(/type,t) eq 8 then begin
		ind1 = where(t.x gt 0, nn)
		tt=t.x[ind1]
		tc=t.y[ind1]
		store_data,'mvn_STA_2A_hkp_ch'+ch[i]+'_'+name3[i-24],data={x:tt,y:tc}
		options,'mvn_STA_2A_hkp_ch'+ch[i]+'_'+name3[i-24],'ytitle','STA!C'+name3[i-24]
		if nn eq ndis then begin
			hkp_raw[*,i] = t.y[ind1]
			hkp[*,i] = tc
		endif else print,'Error in storing housekeeping: ndis is not equal nn  CH=',ch[i]
	endif
endfor

get_data,'mvn_STA_2A_hkp_ch74_STACCTL',data=t
	store_data,'mvn_STA_2A_hkp_ch74_STACCTL_ENBSWEEP',data={x:t.x,y:(t.y and 128*256)/256}	
	store_data,'mvn_STA_2A_hkp_ch74_STACCTL_SDDIAG',data={x:t.x,y:(t.y and 15*256)/256} 	& ylim,'mvn_STA_2A_hkp_ch74_STACCTL_SDDIAG',-1,16,0
	store_data,'mvn_STA_2A_hkp_ch74_STACCTL_FLOPEN',data={x:t.x,y:(t.y and 128)}
	store_data,'mvn_STA_2A_hkp_ch74_STACCTL_FLREVAYADDR',data={x:t.x,y:(t.y and 96)}
	store_data,'mvn_STA_2A_hkp_ch74_STACCTL_SETIOJ1P34',data={x:t.x,y:(t.y and 8)}
	store_data,'mvn_STA_2A_hkp_ch74_STACCTL_HVENBALLOW',data={x:t.x,y:(t.y and 1)}



ylim,'mvn_STA_2A_hkp_ch63_R3Rate',-1,12,0

; 'Fixed_Diag_Feedback'
;	When HV is off, SweepDiagMode = 0xF
; 	When HV is off in pickup mode 'Fixed_Diag_Feedback' is 16154 = 0x3F1A 
;	1 sparebit, 3=EvtProTimeOut, F=SweepDiagMode, 2 sparebits, 1=MLUTBufferSel(2bits), 1=SweepEnable(1bit), 2=SLUTBufSel(3bits)



;******************************************************************************************

; Make 2A common block

common mvn_2a,mvn_2a_ind,mvn_2a_dat & mvn_2a_dat=0 & mvn_2a_ind=-1l

if ndis ge 1 then begin

	mvn_2a_dat= {	project_name:		'MAVEN',				$
			spacecraft:		'0', 					$
			data_name:		'Housekeeping', 			$
			apid:			'2a',					$
			quality_flag: 		replicate(0,ndis), 			$

			time:			tdis,					$

			nhkp:			99,					$
			calib_constants:	hkp_par,				$
			hkp_labels:		hkp_lab,				$

			hkp_raw:		hkp_raw,				$
			hkp:			hkp}

	mvn_2a_ind=0l

endif

end

