;+
; tt89_test
;
; Purpose: A few tests to verify that the model and the wrapper
; procedures work correctly
;
; $LastChangedBy: lphilpott $
; $LastChangedDate: 2012-06-14 11:15:50 -0700 (Thu, 14 Jun 2012) $
; $LastChangedRevision: 10561 $
; $URL: svn+ssh://thmsvn@ambrosia.ssl.berkeley.edu/repos/spdsoft/trunk/external/IDL_GEOPACK/t89/t89_test.pro $
;-

;takes a matrix whose columns define a plane
;and an Nx3 series of points
;returns an Nx2 series of points generated by projecting x into a
function project_t89, a, x

p = a ## invert(transpose(a) ## a) ## transpose(a)

return, p ## x

end

pro orbital_vf_t89, name

  get_data, name, data = d

  tt89, name,kp=2.0D

  get_data, name+'_bt89', data = td

  t_size = n_elements(d.x)

  ;3 points selected to define a plane
  v1 = d.y[0, *]

  v2 = d.y[floor(t_size/3), *]

  v3 = d.y[floor(2*t_size/3), *]

  ;plane vectors are just v2, and v3 shifted by the reference point v1
  vp1 = v2-v1

  vp2 = v3-v1

  proj_pos = project_t89([vp1, vp2], d.y)
  
  proj_mag = project_t89([vp1, vp2], td.y)

  ivector, interpol(proj_mag[*, 0],20),interpol(proj_mag[*, 1],20), interpol(proj_pos[*, 0],20), interpol(proj_pos[*, 1],20),renderer=1

end

timespan, '2007-03-23'

;load state data
thm_load_state, probe = 'b', coord = 'gsm'

;no argument test
tt89, 'thb_state_pos',error=e

if e eq 0 then begin
    message,/continue,'error detected, stopping'
    stop
endif

tplot,'thb_state_pos_bt89'

stop

del_data,'thb_state_pos_bt89'

;test with single number argument
tt89, 'thb_state_pos',kp=2.0D,error=e

if e eq 0 then begin
    message,/continue,'error detected, stopping'
    stop
endif

tplot,'thb_state_pos_bt89'

stop

del_data,'thb_state_pos_bt89'

get_data,'thb_state_pos',data=d

n = n_elements(d.x)

;test with an array argument
tt89, 'thb_state_pos',kp=replicate(2.0D,n),error=e

if e eq 0 then begin
    message,/continue,'error detected, stopping'
    stop
endif

tplot,'thb_state_pos_bt89'

stop

del_data,'thb_state_pos_bt89'

d2 = {x:d.x[0],y:2.0D}

store_data,'t_kp',data=d2

;test with a tplot argument
tt89,'thb_state_pos',kp='t_kp',error=e

if e eq 0 then begin
    message,/continue,'error detected, stopping'
    stop
endif

tplot,'thb_state_pos_bt89'

stop

del_data,'thb_state_pos_bt89'

;test with newname
tt89, 'thb_state_pos',kp=2.0D,newname='test',error=e

if e eq 0 then begin
    message,/continue,'error detected, stopping'
    stop
endif

tplot,'test'

stop

del_data,'test'

;test with a different period
tt89, 'thb_state_pos',kp=2.0D,period=30,error=e

if e eq 0 then begin
    message,/continue,'error detected, stopping'
    stop
endif

tplot,'thb_state_pos_bt89'

stop

;test with an incremented tilt
tt89, 'thb_state_pos',kp=2.0,period=30,error=e,get_tilt='tilt_vals',get_nperiod=gn,add_tilt=1

if e eq 0 then begin
    message,/continue,'error detected, stopping'
    stop
endif

tplot,'tilt_vals'

stop

;test with a set tilt
tt89, 'thb_state_pos',kp=2.0,period=30,error=e,get_tilt='tilt_vals',get_nperiod=gn,set_tilt=1

if e eq 0 then begin
    message,/continue,'error detected, stopping'
    stop
endif

options,'tilt_vals',yrange=[0,2]
tplot,'tilt_vals'
options,'tilt_vals',yrange=[1,1]  ;reset to auto-range
stop

orbital_vf_t89,'thb_state_pos'

print,'The plot produced should look like the plot titled t89_test.png'

end
