;+
; Based on e_spinfit and e_diagonal_spinfit, we calculate edotb_spinfit
;
; This is adopted from rbsp_efw_read_l4_gen_file. We deside to save edotb to make generating L3 and L4 data more quickly.
;-

pro rbsp_efw_phasef_read_e_spinfit_edotb_gen_file, time, probe=probe, filename=file

    compile_opt idl2
    on_error, 0
    errmsg = ''

;---Check inputs.
    if n_elements(file) eq 0 then begin
        errmsg = handle_error('No output file ...')
        return
    endif

    if n_elements(probe) eq 0 then begin
        errmsg = handle_error('No input probe ...')
        return
    endif

    if n_elements(time) eq 0 then begin
        errmsg = handle_error('No input time ...')
        return
    endif


;---Settings.
    secofday = constant('secofday')
    date = time[0]-(time[0] mod secofday)
    time_range = date+[0,1]*secofday
    ndim = 3
    prefix = 'rbsp'+probe+'_'
    fillval = !values.f_nan


;---Load e_spinfit and e_diagonal_spinfit and magnetic field.
    rbsp_efw_phasef_read_spinfit_efield, time_range, probe=probe
    smooth_window = 1800.   ; sec.
    rbsp_efw_phasef_read_wobble_free_var, time_range+[-1,1]*smooth_window, probe=probe, id='b_mgse'
    b_var = prefix+'b_mgse'
    rbsp_detrend, b_var, smooth_window
    b_smoothed_var = prefix+'b_mgse_smoothed'


;---Do edotb.
    bps = ['12','34','13','14','23','24']
    nbp = n_elements(bps)
    old_vars = prefix+'e_spinfit_mgse_v'+bps
    get_data, old_vars[0], common_times
    ncommon_time = n_elements(common_times)
    foreach var, [b_var,b_smoothed_var] do begin
        interp_time, var, common_times
    endforeach

    ; Calc E dot B = 0.
    foreach e_var, old_vars do begin
        pos = strlen(e_var)-3
        new_var = strmid(e_var,0,pos)+'edotb_'+strmid(e_var,pos)
        rbsp_efw_calc_edotb_to_zero, e_var, b_smoothed_var, newname=new_var, no_preprocess=1
    endforeach


;;---Other magnetic field related data.
;    var = 'diagBratio'
;    b_mgse_smoothed = get_var_data(prefix+'b_mgse_smoothed')
;    byz2bx = abs(b_mgse_smoothed[*,1:2]/b_mgse_smoothed[*,[0,0]])
;    store_data, var, common_times, byz2bx
;
;    var = 'angle_spinplane_Bo'
;    bmag = snorm(b_mgse_smoothed)
;    deg = 1d/!dtor
;    angles = acos(b_mgse_smoothed[*,1:2]/bmag[*,[0,0]])*deg
;    store_data, var, common_times, angles


;---Save data.
    path = fgetpath(file)
    if file_test(path,/directory) eq 0 then file_mkdir, path
    data_file = file
    if file_test(data_file) eq 1 then file_delete, data_file  ; overwrite old files.

    ginfo = dictionary($
        'TITLE', 'RBSP EFW E dot0 for all boom combos', $
        'TEXT', 'Generated by Sheng Tian at the University of Minnesota, adopted from rbsp_efw_edotb_to_zero_crib' )
    cdf_save_setting, ginfo, filename=file
    e_vars = prefix+['e_spinfit_mgse_edotb_v'+bps]
    foreach save_var, e_vars do begin
        get_data, save_var, times, vec
        if n_elements(times) ne ncommon_time then stop
        store_data, save_var, times, float(vec), limits={units:'mV/m', coord:'mgse'}
    endforeach
    b_var = prefix+'b_mgse_smoothed'
    store_data, b_var, limits={units:'nT', coord:'mgse'}

    save_vars = [e_vars,b_var]
    stplot2cdf, save_vars, istp=1, filename=file, time_var='epoch'


end

probes = ['a','b']
root_dir = join_path([homedir(),'data','rbsp'])
foreach probe, probes do begin
    prefix = 'rbsp'+probe+'_'
    rbspx = 'rbsp'+probe
    time_range = rbsp_efw_phasef_get_valid_range('e_spinfit', probe=probe)
    days = make_bins(time_range+[0,-1], constant('secofday'))
    foreach day, days do begin
        str_year = time_string(day,tformat='YYYY')
        path = join_path([root_dir,rbspx,'e_spinfit_edotb',str_year])
        base = prefix+'efw_e_spinfit_edotb_mgse_'+time_string(day,tformat='YYYY_MMDD')+'_v01.cdf'
        file = join_path([path,base])
        if file_test(file) eq 1 then continue
        rbsp_efw_phasef_read_e_spinfit_edotb_gen_file, day, probe=probe, filename=file
    endforeach
endforeach


stop

time = time_double('2012-11-29')
probe = 'a'
file = join_path([homedir(),'test.cdf'])
if file_test(file) eq 1 then file_delete, file
tic
rbsp_efw_phasef_read_e_spinfit_edotb_gen_file, time, probe=probe, filename=file
toc
end
