;+
;PROCEDURE:	convert_sst_units
;PURPOSE:	to convert units of data from the sst instruments
;INPUT:		
;	data:	A 3d structure such as those generated by get_sf,get_so
;	units:	A string telling the procedure which units to convert to, such
;		as ncounts,rate,nrate,eflux,flux,df
;
;KEYWORDS:
;	scale:	A named variable in which the scale factor is returned.
;SEE ALSO:
;       "conv_units",
;       "get_sf","get_so"
;WARNING:
;	This procedure is NOT tested!
;       
;CREATED BY:	Davin Larson, 1995
;LAST MODIFICATION:	@(#)convert_sst_units.pro	1.10 96/08/22
;-

pro convert_sst_units, data, units, $
  SCALE = scale

scale = 1

if data.units_name eq units then return

if data.units_name ne 'Counts' then begin
   print,'Unable to convert from '+data.units_name+' to any other units'
   return
endif

units_names = ['Counts','Ncounts','Rate','Nrate','Eflux','Flux','DF']

energy = data.energy           ; in eV                (ne,nbins)
geom   = data.geom             ; number of bins summed (nbins)
n_e = data.nenergy               ; number of energies   
nbins=data.nbins               ; number of bins       
dt = data.eff * data.integ_t; effective duty cycle x integration time (ne)
gf = data.geomfactor           ; geometric factor of smallest bin
mass = data.mass               ; scaler
denergy = data.denergy
feff = data.feff	       ; foil electron efficiency,
				;for background 	  subtracted data only	

if ndimen(geom) eq 0 then geom = [geom]

case strupcase(units) of 
'COUNTS' :  return
'NCOUNTS':  scale =  replicate(1.,n_e) # geom
'RATE'   :  scale =  dt # replicate(1.,nbins)
'NRATE'  :  scale =  dt # geom
'EFLUX'  :  scale = (dt # (gf * geom)) * denergy / energy
'FLUX'   :  scale = (dt # (gf * geom)) * denergy
'FLUXE'  :  scale = (dt # (gf * geom)) * denergy * feff
'DF'     :  scale = (2./mass/mass*dt*1e5 # (gf * geom)) * denergy * energy
else: begin
        print,'Undefined units'
	return
      end
endcase

;print,'SST units are invalid!  Please edit the procedure: ', data.units_procedure


data.units_name = units

if find_str_element(data,'ddata') ge 0 then data.ddata = data.ddata/scale
data.data = data.data / scale 

return
end



