;Ali: June 2020
;+
; $LastChangedBy: ali $
; $LastChangedDate: 2021-05-30 19:24:43 -0700 (Sun, 30 May 2021) $
; $LastChangedRevision: 29999 $
; $URL: svn+ssh://thmsvn@ambrosia.ssl.berkeley.edu/repos/spdsoft/trunk/projects/SPP/COMMON/sc/spp_sc_hk_0x257_apdat__define.pro $
;-

function spp_SC_HK_0x257_struct,ccsds_data
  if n_elements(ccsds_data) eq 0 then ccsds_data = bytarr(67)

  a1 = 100./255
  str = {time:!values.d_nan ,$
    met:!values.d_nan, $
    seqn: 0u, $
    pkt_size: 0u, $
    FSW_SPP_EPI_LO_SSR_ALLOC_STATUS:a1*spp_swp_data_select(ccsds_data,2805*8+7-1,8), $
    FSW_SPP_EPI_HI_SSR_ALLOC_STATUS:a1*spp_swp_data_select(ccsds_data,2806*8+7-1,8), $
    FSW_SPP_WISPR_SSR_ALLOC_STATUS:a1*spp_swp_data_select(ccsds_data,2807*8+7-1,8), $
    FSW_SPP_FIELDS_SSR_ALLOC_STATUS:a1*spp_swp_data_select(ccsds_data,2808*8+7-1,8), $
    FSW_SPP_SWEAP_SSR_ALLOC_STATUS:a1*spp_swp_data_select(ccsds_data,2809*8+7-1,8), $
    FSW_REC_HK_ALLOC_ERR_SSR_SWEAP_FIELDS_WISPR_EPIHI_LO:spp_swp_data_select(ccsds_data,2767*8+7-7,6), $
    gap:0B}
  return, str
end

;FSW_SPP_EPI_LO_SSR_ALLOC_STATUS,                             2805,    1,    8;
;FSW_SPP_EPI_HI_SSR_ALLOC_STATUS,                             2806,    1,    8;
;FSW_SPP_WISPR_SSR_ALLOC_STATUS,                              2807,    1,    8;
;FSW_SPP_FIELDS_SSR_ALLOC_STATUS,                             2808,    1,    8;
;FSW_SPP_SWEAP_SSR_ALLOC_STATUS,                              2809,    1,    8;
;EU(Raw='SC_HK_0x257.FSW_SPP_EPI_LO_SSR_ALLOC_STATUS') := fCalCurve([1.0, 255.0], [0.392156862745098, 100.0], Raw)
;EU(Raw='SC_HK_0x257.FSW_SPP_EPI_HI_SSR_ALLOC_STATUS') := fCalCurve([1.0, 255.0], [0.392156862745098, 100.0], Raw)
;EU(Raw='SC_HK_0x257.FSW_SPP_WISPR_SSR_ALLOC_STATUS') := fCalCurve([1.0, 255.0], [0.392156862745098, 100.0], Raw)
;EU(Raw='SC_HK_0x257.FSW_SPP_FIELDS_SSR_ALLOC_STATUS') := fCalCurve([1.0, 255.0], [0.392156862745098, 100.0], Raw)
;EU(Raw='SC_HK_0x257.FSW_SPP_SWEAP_SSR_ALLOC_STATUS') := fCalCurve([1.0, 255.0], [0.392156862745098, 100.0], Raw)
;FSW_REC_HK_ALLOC_ERR_05_CDH_SSR_HK_TT,                       2767,    7,    1;
;FSW_REC_HK_ALLOC_ERR_04_SWEAP_TT,                            2767,    6,    1;
;FSW_REC_HK_ALLOC_ERR_03_FIELDS_TT,                           2767,    5,    1;
;FSW_REC_HK_ALLOC_ERR_02_WISPR_TT,                            2767,    4,    1;
;FSW_REC_HK_ALLOC_ERR_01_EPIHI_TT,                            2767,    3,    1;
;FSW_REC_HK_ALLOC_ERR_00_EPILO_TT,                            2767,    2,    1;


function SPP_SC_HK_0x257_apdat::decom,ccsds, source_dict=source_dict   ;,ptp_header=ptp_header

  ccsds_data = spp_swp_ccsds_data(ccsds)
  str2 = spp_SC_HK_0x257_struct(ccsds_data)
  struct_assign,ccsds,str2,/nozero
  return,str2

end


pro spp_SC_HK_0x257_apdat__define

  void = {spp_SC_HK_0x257_apdat, $
    inherits spp_gen_apdat, $    ; superclass
    flag: 0 $
  }
end
;
;#
;# SC_HK_0x257
;#
;SC_HK_0x257
;{
;( Block[4091],                                                     ,     ,    8; )
;HK_FSWL_TPPH_VERSION,                                           0,    7,    3;
;HK_FSWL_TPPH_TYPE,                                              0,    4,    1;
;HK_FSWL_TPPH_SEC_HDR_FLAG,                                      0,    3,    1;
;HK_FSWL_TPPH_APID,                                              0,    2,   11;
;SC_D_APID,                                                      0,    2,   11;
;HK_FSWL_TPPH_SEQ_FLAGS,                                         2,    7,    2;
;HK_FSWL_TPPH_SEQ_CNT,                                           2,    5,   14;
;HK_FSWL_TPPH_LENGTH,                                            4,    7,   16;
;HK_FSWL_TPSH_MET_SEC,                                           6,    7,   32;
;SC_D_MET_SEC,                                                   6,    7,   32;
;HK_FSWL_TPSH_MET_SUBSEC,                                       10,    7,    8;
;HK_FSWL_TPSH_SBC_PHYS_ID,                                      11,    7,    2;
;SBC_RIO_TPPH_VERSION,                                           0,    7,    3;
;SBC_RIO_TPPH_TYPE,                                              0,    4,    1;
;SBC_RIO_TPPH_SEC_HDR_FLAG,                                      0,    3,    1;
;SBC_RIO_TPPH_APID,                                              0,    2,   11;
;SC_D_APID_DUP0,                                                 0,    2,   11;
;SBC_RIO_TPPH_SEQ_FLAGS,                                         2,    7,    2;
;SBC_RIO_TPPH_SEQ_CNT,                                           2,    5,   14;
;SBC_RIO_TPPH_LENGTH,                                            4,    7,   16;
;SBC_RIO_TPSH_MET_SEC,                                           6,    7,   32;
;SC_D_MET_SEC_DUP1,                                              6,    7,   32;
;SBC_RIO_TPSH_MET_SUBSEC,                                       10,    7,    8;
;SBC_RIO_TPSH_SBC_PHYS_ID,                                      11,    7,    2;
;FSW_CPU_HK_CDS_FAILED_APP_NAME_STRING[48],                     12,    7,    8;
;FSW_CPU_HK_CDS_FAILED_APP_NAME_STR[48],                        12,    7,    8;
;FSW_CPU_HK_CDS_FAILED_TASK_NAME_STRING[48],                    60,    7,    8;
;FSW_CPU_HK_CDS_FAILED_TASK_NAME_STR[48],                       60,    7,    8;
;HS_FSW_CPU_HK_CDS_FAILED_APP_NAME_STRING[48],                 108,    7,    8;
;HS_FSW_CPU_HK_CDS_FAILED_APP_NAME_STR[48],                    108,    7,    8;
;HS_FSW_CPU_HK_CDS_FAILED_TASK_NAME_STRING[48],                156,    7,    8;
;HS_FSW_CPU_HK_CDS_FAILED_TASK_NAME_STR[48],                   156,    7,    8;
;BS_FSW_CPU_HK_CDS_FAILED_APP_NAME_STRING[48],                 204,    7,    8;
;BS_FSW_CPU_HK_CDS_FAILED_APP_NAME_STR[48],                    204,    7,    8;
;BS_FSW_CPU_HK_CDS_FAILED_TASK_NAME_STRING[48],                252,    7,    8;
;BS_FSW_CPU_HK_CDS_FAILED_TASK_NAME_STR[48],                   252,    7,    8;
;FSW_SPP_HK_FSW_VERSION[32],                                   300,    7,    8;
;FSW_SPP_HK_COMPILED_ON_DATE[32],                              332,    7,    8;
;HS_FSW_SPP_HK_FSW_VERSION[32],                                364,    7,    8;
;BS_FSW_SPP_HK_FSW_VERSION[32],                                396,    7,    8;
;FSW_SCH_HK_UP_TIME,                                           428,    7,   32;
;FSW_SCH_HK_MAJOR_FRAME_OVERRUN_CNT,                           432,    7,   16;
;FSW_SCH_HK_SCH_OUT_OF_SYNC_CURRENT_TT,                        434,    7,    1;
;FSW_SCH_HK_SCH_OVERRUN_STICKY_TT,                             434,    6,    1;
;FSW_SCH_HK_SCH_MET_DISCONTINUITY_TT,                          434,    5,    1;
;FSW_CI_HK_CLTU_TIMEOUT_CNT,                                   434,    4,   16;
;FSW_CI_HK_XFR_LAYER_FAIL_CNT,                                 436,    4,   16;
;FSW_CI_HK_XFR_LYR_FAIL_CNT,                                   436,    4,   16;
;FSW_CI_HK_LAST_XLYR_FAIL,                                     438,    4,   16;
;FSW_CI_HK_BD_TCTF_CNT,                                        440,    4,   16;
;FSW_CI_HK_SEG_LAYER_FAIL_CNT,                                 442,    4,   16;
;FSW_CI_HK_SEG_LYR_FAIL_CNT,                                   442,    4,   16;
;FSW_CI_HK_PKT_DELIVERED_CNT,                                  444,    4,   16;
;FSW_CI_HK_PKT_DELV_CNT,                                       444,    4,   16;
;FSW_CI_HK_PKT_FAIL_CNT_LSB,                                   446,    4,    8;
;FSW_CI_HK_LAST_UL_CMD_MET_SEC,                                447,    4,   32;
;FSW_CI_HK_LAST_UPLNK_CMD_MET_SEC,                             447,    4,   32;
;FSW_CM_HK_DLYD_NAK_PKT_FAIL_CNT,                              451,    4,   16;
;FSW_CM_HK_NUM_AUT_ROUTE_MSG_CNT,                              453,    4,   16;
;FSW_CM_HK_NUM_AUT_ROUT_MSG_CNT,                               453,    4,   16;
;FSW_CM_HK_NUM_TT_ROUTE_MSG_CNT,                               455,    4,   16;
;FSW_CM_HK_NUM_TT_ROUT_MSG_CNT,                                455,    4,   16;
;FSW_CM_HK_NUM_FI_ROUTE_MSG_CNT,                               457,    4,   16;
;FSW_CM_HK_NUM_FI_ROUT_MSG_CNT,                                457,    4,   16;
;FSW_CM_HK_FI_MACRO_EMBED_CMD_CNT,                             459,    4,   16;
;FSW_CM_HK_RT_CMD_EXEC_SUCCESS_CNT,                            461,    4,   16;
;FSW_CM_HK_RT_MACRO_CMD_EXEC_SUCCESS_CNT,                      463,    4,   16;
;FSW_CM_HK_RT_CMD_FAIL_CNT,                                    465,    4,   16;
;FSW_CM_HK_RT_MACRO_CMD_FAIL_CNT,                              467,    4,   16;
;FSW_CM_HK_AUT_CMD_PKT_FAIL_CNT,                               469,    4,   16;
;FSW_CM_HK_TT_CMD_PKT_FAIL_CNT,                                471,    4,   16;
;FSW_CM_HK_FI_CMD_PKT_FAIL_CNT,                                473,    4,   16;
;FSW_CM_HK_FI_MACRO_CMD_PKT_FAIL_CNT,                          475,    4,   16;
;FSW_CM_HK_AUT_CMD_CHECK_FAIL_CNT,                             477,    4,   16;
;FSW_CM_HK_TT_CMD_CHECK_FAIL_CNT,                              479,    4,   16;
;FSW_CM_HK_FI_CMD_CHECK_FAIL_CNT,                              481,    4,   16;
;FSW_CM_HK_FI_MACRO_CMD_CHECK_FAIL_CNT,                        483,    4,   16;
;FSW_CM_HK_AUT_CMD_EXEC_FAIL_CNT,                              485,    4,   16;
;FSW_CM_HK_TT_CMD_EXEC_FAIL_CNT,                               487,    4,   16;
;FSW_CM_HK_FI_CMD_EXEC_FAIL_CNT,                               489,    4,   16;
;FSW_CM_HK_FI_MACRO_CMD_EXEC_FAIL_CNT,                         491,    4,   16;
;FSW_CM_HK_AUT_EMBED_MACRO_CRIT_FAIL_CNT,                      493,    4,   16;
;FSW_CM_HK_AUT_EMBED_MAC_CRIT_FAIL_CNT,                        493,    4,   16;
;FSW_CM_HK_TT_EMBED_MACRO_CRIT_FAIL_CNT,                       495,    4,   16;
;FSW_CM_HK_TT_EMBED_MAC_CRIT_FAIL_CNT,                         495,    4,   16;
;FSW_CM_HK_FI_EMBED_MACRO_CRIT_FAIL_CNT,                       497,    4,   16;
;FSW_CM_HK_FI_EMBED_MAC_CRIT_FAIL_CNT,                         497,    4,   16;
;FSW_CM_HK_AUT_EMBED_MACRO_NON_CRIT_FAIL_CNT,                  499,    4,   16;
;FSW_CM_HK_AUT_EMBED_MAC_NON_CRIT_FAIL_CNT,                    499,    4,   16;
;FSW_CM_HK_AUT_EMBED_MACRO_NON_CRIT_FAIL_CNT_LSB,              501,    4,    8;
;FSW_CM_HK_AUT_EMBED_MAC_NON_CRIT_FAIL_CNT_LSB,                501,    4,    8;
;FSW_CM_HK_TT_EMBED_MACRO_NON_CRIT_FAIL_CNT,                   502,    4,   16;
;FSW_CM_HK_TT_EMBED_MAC_NON_CRIT_FAIL_CNT,                     502,    4,   16;
;FSW_CM_HK_FI_EMBED_MACRO_NON_CRIT_FAIL_CNT,                   504,    4,   16;
;FSW_CM_HK_FI_EMBED_MAC_NON_CRIT_FAIL_CNT,                     504,    4,   16;
;FSW_CM_HK_DELAYED_ACK_CNT,                                    506,    4,   16;
;FSW_CM_HK_DELAYED_NAK_CHECK_FAIL_CNT,                         508,    4,   16;
;FSW_CM_HK_DELAYED_NAK_EXEC_FAIL_CNT,                          510,    4,   16;
;FSW_CM_HK_TT_MACROS_TRIGGERED_CNT,                            512,    4,   16;
;FSW_CM_HK_FI_MACROS_TRIGGERED_CNT,                            514,    4,   16;
;FSW_CM_HK_AUT_MACROS_EXEC_SUCCESS_CNT,                        516,    4,   16;
;FSW_CM_HK_TT_MACROS_EXEC_SUCCESS_CNT,                         518,    4,   16;
;FSW_CM_HK_FI_MACROS_EXEC_SUCCESS_CNT,                         520,    4,   16;
;FSW_CM_HK_AUT_MACROS_EXEC_FAIL_CNT,                           522,    4,   16;
;FSW_CM_HK_TT_MACROS_EXEC_FAIL_CNT,                            524,    4,   16;
;FSW_CM_HK_FI_MACROS_EXEC_FAIL_CNT,                            526,    4,   16;
;FSW_CM_HK_MACRO_LOAD_FAIL_CNT,                                528,    4,   16;
;FSW_CM_HK_MACRO_LD_FAIL_CNT,                                  528,    4,   16;
;FSW_CM_HK_CMD_AUT_TT_BUF_ERR_CNT,                             530,    4,   16;
;FSW_CM_HK_CMD_AUT_TT_BUFF_ERR_CNT,                            530,    4,   16;
;FSW_CM_HK_CMD_BUF_COPY_ERR_CNT,                               532,    4,   16;
;FSW_CM_HK_CMD_BUFF_COPY_ERR_CNT,                              532,    4,   16;
;FSW_CM_HK_MACRO_LD_NV_MEM_CNT,                                534,    4,   16;
;FSW_CM_HK_MACRO_LD_RAM_CNT,                                   536,    4,   16;
;FSW_CM_HK_MACRO_ENA_WORD_MASK0,                               538,    4,   32;
;FSW_CM_HK_MACRO_ENA_WORD_MASK1,                               542,    4,   32;
;FSW_CM_HK_MACRO_ENA_WORD_MASK2,                               546,    4,   32;
;FSW_CM_HK_MACRO_ENA_WORD_MASK3,                               550,    4,   32;
;FSW_CM_HK_MACRO_ENA_WORD_MASK4,                               554,    4,   32;
;FSW_CM_HK_MACRO_ENA_WORD_MASK5,                               558,    4,   32;
;FSW_CM_HK_MACRO_ENA_WORD_MASK6,                               562,    4,   32;
;FSW_CM_HK_MACRO_ENA_WORD_MASK7,                               566,    4,   32;
;FSW_CM_HK_MACRO_ENA_WORD_MASK8,                               570,    4,   32;
;FSW_CM_HK_MACRO_ENA_WORD_MASK9,                               574,    4,   32;
;FSW_CM_HK_MACRO_ENA_WORD_MASK10,                              578,    4,   32;
;FSW_CM_HK_MACRO_ENA_WORD_MASK11,                              582,    4,   32;
;FSW_CM_HK_MACRO_ENA_WORD_MASK12,                              586,    4,   32;
;FSW_CM_HK_MACRO_ENA_WORD_MASK13,                              590,    4,   32;
;FSW_CM_HK_MACRO_ENA_WORD_MASK14,                              594,    4,   32;
;FSW_CM_HK_MACRO_ENA_WORD_MASK15,                              598,    4,   32;
;FSW_CM_HK_MACRO_ENA_WORD_MASK16,                              602,    4,   32;
;FSW_CM_HK_MACRO_ENA_WORD_MASK17,                              606,    4,   32;
;FSW_CM_HK_MACRO_ENA_WORD_MASK18,                              610,    4,   32;
;FSW_CM_HK_MACRO_ENA_WORD_MASK19,                              614,    4,   32;
;FSW_CM_HK_MACRO_ENA_WORD_MASK20,                              618,    4,   32;
;FSW_CM_HK_MACRO_ENA_WORD_MASK21,                              622,    4,   32;
;FSW_CM_HK_MACRO_ENA_WORD_MASK22,                              626,    4,   32;
;FSW_CM_HK_MACRO_ENA_WORD_MASK23,                              630,    4,   32;
;FSW_CM_HK_MACRO_ENA_WORD_MASK24,                              634,    4,   32;
;FSW_CM_HK_MACRO_ENA_WORD_MASK25,                              638,    4,   32;
;FSW_CM_HK_MACRO_ENA_WORD_MASK26,                              642,    4,   32;
;FSW_CM_HK_MACRO_ENA_WORD_MASK27,                              646,    4,   32;
;FSW_CM_HK_MACRO_ENA_WORD_MASK28,                              650,    4,   32;
;FSW_CM_HK_MACRO_ENA_WORD_MASK29,                              654,    4,   32;
;FSW_CM_HK_MACRO_ENA_WORD_MASK30,                              658,    4,   32;
;FSW_CM_HK_MACRO_ENA_WORD_MASK31,                              662,    4,   32;
;FSW_CM_HK_MACRO_ACTIVE_WORD_MASK0,                            666,    4,   32;
;FSW_CM_HK_MACRO_ACTIVE_WORD_MASK1,                            670,    4,   32;
;FSW_CM_HK_MACRO_ACTIVE_WORD_MASK2,                            674,    4,   32;
;FSW_CM_HK_MACRO_ACTIVE_WORD_MASK3,                            678,    4,   32;
;FSW_CM_HK_MACRO_ACTIVE_WORD_MASK4,                            682,    4,   32;
;FSW_CM_HK_MACRO_ACTIVE_WORD_MASK6,                            686,    4,   32;
;FSW_CM_HK_MACRO_ACTIVE_WORD_MASK7,                            690,    4,   32;
;FSW_CM_HK_MACRO_ACTIVE_WORD_MASK8,                            694,    4,   32;
;FSW_CM_HK_MACRO_ACTIVE_WORD_MASK10,                           698,    4,   32;
;FSW_CM_HK_MACRO_ACTIVE_WORD_MASK11,                           702,    4,   32;
;FSW_CM_HK_MACRO_ACTIVE_WORD_MASK12,                           706,    4,   32;
;FSW_CM_HK_MACRO_ACTIVE_WORD_MASK13,                           710,    4,   32;
;FSW_CM_HK_MACRO_ACTIVE_WORD_MASK14,                           714,    4,   32;
;FSW_CM_HK_MACRO_ACTIVE_WORD_MASK15,                           718,    4,   32;
;FSW_CM_HK_MACRO_ACTIVE_WORD_MASK16,                           722,    4,   32;
;FSW_CM_HK_MACRO_ACTIVE_WORD_MASK17,                           726,    4,   32;
;FSW_CM_HK_MACRO_ACTIVE_WORD_MASK18,                           730,    4,   32;
;FSW_CM_HK_MACRO_ACTIVE_WORD_MASK19,                           734,    4,   32;
;FSW_CM_HK_MACRO_ACTIVE_WORD_MASK20,                           738,    4,   32;
;FSW_CM_HK_MACRO_ACTIVE_WORD_MASK21,                           742,    4,   32;
;FSW_CM_HK_MACRO_ACTIVE_WORD_MASK22,                           746,    4,   32;
;FSW_CM_HK_MACRO_ACTIVE_WORD_MASK23,                           750,    4,   32;
;FSW_CM_HK_MACRO_ACTIVE_WORD_MASK24,                           754,    4,   32;
;FSW_CM_HK_MACRO_ACTIVE_WORD_MASK25,                           758,    4,   32;
;FSW_CM_HK_MACRO_ACTIVE_WORD_MASK26,                           762,    4,   32;
;FSW_CM_HK_MACRO_ACTIVE_WORD_MASK27,                           766,    4,   32;
;FSW_CM_HK_MACRO_ACTIVE_WORD_MASK28,                           770,    4,   32;
;FSW_CM_HK_MACRO_ACTIVE_WORD_MASK29,                           774,    4,   32;
;FSW_CM_HK_MACRO_ACTIVE_WORD_MASK30,                           778,    4,   32;
;FSW_CM_HK_MACRO_ACTIVE_WORD_MASK31,                           782,    4,   32;
;FSW_CM_HK_LAST_FAILED_CMD_STATUS_TPPH_VERSION,                786,    4,    3;
;FSW_CM_HK_LAST_FAILED_CMD_STATUS_TPPH_TYPE,                   786,    1,    1;
;FSW_CM_HK_LAST_FAILED_CMD_STATUS_TPPH_SEC_HDR_FLAG,           786,    0,    1;
;FSW_CM_HK_LAST_FAILED_CMD_STATUS_TPPH_APID,                   787,    7,   11;
;FSW_CM_HK_LAST_FAILED_CMD_STATUS_TPPH_SEQ_FLAGS,              788,    4,    2;
;FSW_CM_HK_LAST_FAILED_CMD_STATUS_TPPH_SEQ_CNT,                788,    2,   14;
;FSW_CM_HK_LAST_FAILED_CMD_STATUS_TPPH_LENGTH,                 790,    4,   16;
;FSW_CM_HK_LAST_FAILED_CMD_STATUS_TPSH_MET_SEC,                792,    4,   32;
;FSW_CM_HK_LAST_FAILED_CMD_STATUS_TPSH_MET_SUBSEC,             796,    4,    8;
;FSW_CM_HK_LAST_FAILED_CMD_STATUS_TPSH_SBC_PHYS_ID_NO_ALARM,   797,    4,    2;
;FSW_CM_HK_LAST_FAILED_CMD_STATUS_CMD_STATUS_CODE,             797,    2,    4;
;FSW_CM_HK_LAST_FAILED_CMD_STATUS_RULE_BIN_NUM,                798,    6,   12;
;FSW_CM_HK_LAST_FAILED_CMD_STATUS_CMD_PRIORITY,                799,    2,    5;
;FSW_CM_HK_LAST_FAILED_CMD_STATUS_CMD_TYPE,                    800,    5,    4;
;FSW_CM_HK_LAST_FAILED_CMD_STATUS_CMD_RETURN_CODE,             800,    1,   32;
;FSW_CM_HK_LAST_FAILED_CMD_STATUS_CMD_DATA0,                   804,    1,    8;
;FSW_CM_HK_LAST_FAILED_CMD_STATUS_CMD_APID,                    805,    1,   11;
;FSW_CM_HK_LAST_FAILED_CMD_STATUS_CMD_DATA1,                   807,    6,    8;
;FSW_CM_HK_LAST_FAILED_CMD_STATUS_CMD_DATA2,                   808,    6,    8;
;FSW_CM_HK_LAST_FAILED_CMD_STATUS_CMD_DATA3,                   809,    6,    8;
;FSW_CPU_HK_FLASH_STATUS,                                      810,    6,    1;
;FSW_CPU_HK_SOFTWARE_TIMER_STATUS,                             810,    5,    1;
;FSW_CPU_HK_FLASH_PWR_STATUS,                                  810,    4,    1;
;FSW_CPU_HK_SMF,                                               810,    3,    1;
;FSW_CPU_HK_IMAGE_2_WRITE_ENA,                                 810,    2,    1;
;FSW_CPU_HK_IMAGE_2_WRITE_ENABLE,                              810,    2,    1;
;FSW_CPU_HK_IMAGE_1_WRITE_ENA,                                 810,    1,    1;
;FSW_CPU_HK_IMAGE_1_WRITE_ENABLE,                              810,    1,    1;
;FSW_CPU_HK_MC_C_IMAGE_SEL,                                    810,    0,    1;
;FSW_CPU_HK_MC_C_RESET_DCRT,                                   811,    7,    1;
;FSW_CPU_HK_MC_C_RESET_DISCRT,                                 811,    7,    1;
;FSW_CPU_HK_MC_B_IMAGE_SEL,                                    811,    6,    1;
;FSW_CPU_HK_MC_B_RESET_DCRT,                                   811,    5,    1;
;FSW_CPU_HK_MC_B_RESET_DISCRT,                                 811,    5,    1;
;FSW_CPU_HK_MC_A_IMAGE_SEL,                                    811,    4,    1;
;FSW_CPU_HK_MC_A_RESET_DCRT,                                   811,    3,    1;
;FSW_CPU_HK_MC_A_RESET_DISCRT,                                 811,    3,    1;
;FSW_CPU_HK_SBC_APP_IMAGE_BOOTED,                              811,    2,    2;
;FSW_CPU_HK_SECONDARY_CHECKSUM_FAIL,                           811,    0,    1;
;FSW_CPU_HK_PRIMARY_CHECKSUM_FAIL,                             812,    7,    1;
;FSW_CPU_HK_SBC_APP_IMAGE_VOTED,                               812,    6,    2;
;FSW_CPU_HK_BRKWIRE0,                                          812,    4,    1;
;FSW_CPU_HK_BRKWIRE1,                                          812,    3,    1;
;FSW_CPU_HK_WATCHDOG_EN_DIS,                                   812,    2,    1;
;FSW_CPU_HK_RESET_MODE,                                        812,    1,   32;
;FSW_CPU_HK_CDS_POR_RESET,                                     816,    1,    1;
;FSW_CPU_HK_CDS_MC_RESET,                                      816,    0,    1;
;FSW_CPU_HK_CDS_SW_RESET,                                      817,    7,    1;
;FSW_CPU_HK_CDS_WDOG_RESET,                                    817,    6,    1;
;FSW_CPU_HK_CDS_FLASH_STATUS,                                  817,    5,    1;
;FSW_CPU_HK_CDS_SW_TIMER_STATUS,                               817,    4,    1;
;FSW_CPU_HK_CDS_FLASH_PWR_STATUS,                              817,    3,    1;
;FSW_CPU_HK_CDS_SMF,                                           817,    2,    1;
;FSW_CPU_HK_CDS_IMAGE_2_WRITE_ENA,                             817,    1,    1;
;FSW_CPU_HK_CDS_IMAGE_1_WRITE_ENA,                             817,    0,    1;
;FSW_CPU_HK_CDS_MC_C_IMAGE_SEL,                                818,    7,    1;
;FSW_CPU_HK_CDS_MC_C_RESET_DCRT,                               818,    6,    1;
;FSW_CPU_HK_CDS_MC_B_IMAGE_SEL,                                818,    5,    1;
;FSW_CPU_HK_CDS_MC_B_RESET_DCRT,                               818,    4,    1;
;FSW_CPU_HK_CDS_MC_A_IMAGE_SEL,                                818,    3,    1;
;FSW_CPU_HK_CDS_MC_A_RESET_DCRT,                               818,    2,    1;
;FSW_CPU_HK_CDS_SBC_APP_IMAGE_BOOTED,                          818,    1,    2;
;FSW_CPU_HK_CDS_SEC_CKSM_FAIL,                                 819,    7,    1;
;FSW_CPU_HK_CDS_PRIMARY_CKSM_FAIL,                             819,    6,    1;
;FSW_CPU_HK_CDS_SBC_APP_IMAGE_VOTED,                           819,    5,    2;
;FSW_CPU_HK_CDS_BRKWIRE0,                                      819,    3,    1;
;FSW_CPU_HK_CDS_BRKWIRE1,                                      819,    2,    1;
;FSW_CPU_HK_CDS_WDOG_ENA_DIS,                                  819,    1,    1;
;FSW_CPU_HK_CDS_RESET_INFO_VALID_BOOL,                         819,    0,   32;
;FSW_CPU_HK_CDS_CPU_APP_INIT_CNT,                              823,    0,   32;
;FSW_CPU_HK_CDS_CPU_APP_INIT_COUNT,                            823,    0,   32;
;FSW_CPU_HK_CDS_HEALTH_MON_RESET_BOOL,                         827,    0,   32;
;FSW_CPU_HK_CDS_RESET_MODE,                                    831,    0,   32;
;FSW_CPU_HK_CDS_MET_SECS,                                      835,    0,   32;
;FSW_CPU_HK_CDS_MET_SECONDS,                                   835,    0,   32;
;FSW_CPU_HK_CDS_MET_SUBSECS,                                   839,    0,   32;
;FSW_CPU_HK_CDS_MET_SUBSECONDS,                                839,    0,   32;
;FSW_CPU_HK_CDS_HM_RESET_CODE,                                 843,    0,   32;
;FSW_CPU_HK_CDS_TASK_INFO_VAL_BOOL,                            847,    0,   32;
;FSW_CPU_HK_CDS_TASK_INFO_VALID_BOOL,                          847,    0,   32;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT0,                             851,    0,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT1,                             852,    7,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT2,                             852,    6,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT3,                             852,    5,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT4,                             852,    4,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT5,                             852,    3,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT6,                             852,    2,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT7,                             852,    1,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT8,                             852,    0,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT9,                             853,    7,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT10,                            853,    6,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT11,                            853,    5,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT12,                            853,    4,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT13,                            853,    3,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT14,                            853,    2,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT15,                            853,    1,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT16,                            853,    0,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT17,                            854,    7,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT18,                            854,    6,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT19,                            854,    5,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT20,                            854,    4,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT21,                            854,    3,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT22,                            854,    2,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT23,                            854,    1,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT24,                            854,    0,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT25,                            855,    7,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT26,                            855,    6,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT27,                            855,    5,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT28,                            855,    4,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT29,                            855,    3,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT30,                            855,    2,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT31,                            855,    1,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT32,                            855,    0,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT33,                            856,    7,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT34,                            856,    6,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT35,                            856,    5,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT36,                            856,    4,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT37,                            856,    3,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT38,                            856,    2,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT39,                            856,    1,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT40,                            856,    0,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT41,                            857,    7,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT42,                            857,    6,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT43,                            857,    5,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT44,                            857,    4,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT45,                            857,    3,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT46,                            857,    2,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT47,                            857,    1,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT48,                            857,    0,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT49,                            858,    7,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT50,                            858,    6,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT51,                            858,    5,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT52,                            858,    4,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT53,                            858,    3,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT54,                            858,    2,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT55,                            858,    1,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT56,                            858,    0,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT57,                            859,    7,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT58,                            859,    6,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT59,                            859,    5,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT60,                            859,    4,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT61,                            859,    3,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT62,                            859,    2,    1;
;FSW_CPU_HK_MISS_ERR_STKY_TT_BIT63,                            859,    1,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT0,                         859,    0,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT1,                         860,    7,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT2,                         860,    6,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT3,                         860,    5,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT4,                         860,    4,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT5,                         860,    3,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT6,                         860,    2,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT7,                         860,    1,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT8,                         860,    0,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT9,                         861,    7,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT10,                        861,    6,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT11,                        861,    5,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT12,                        861,    4,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT13,                        861,    3,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT14,                        861,    2,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT15,                        861,    1,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT16,                        861,    0,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT17,                        862,    7,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT18,                        862,    6,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT19,                        862,    5,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT20,                        862,    4,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT21,                        862,    3,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT22,                        862,    2,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT23,                        862,    1,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT24,                        862,    0,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT25,                        863,    7,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT26,                        863,    6,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT27,                        863,    5,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT28,                        863,    4,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT29,                        863,    3,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT30,                        863,    2,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT31,                        863,    1,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT32,                        863,    0,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT33,                        864,    7,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT34,                        864,    6,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT35,                        864,    5,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT36,                        864,    4,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT37,                        864,    3,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT38,                        864,    2,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT39,                        864,    1,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT40,                        864,    0,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT41,                        865,    7,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT42,                        865,    6,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT43,                        865,    5,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT44,                        865,    4,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT45,                        865,    3,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT46,                        865,    2,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT47,                        865,    1,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT48,                        865,    0,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT49,                        866,    7,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT50,                        866,    6,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT51,                        866,    5,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT52,                        866,    4,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT53,                        866,    3,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT54,                        866,    2,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT55,                        866,    1,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT56,                        866,    0,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT57,                        867,    7,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT58,                        867,    6,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT59,                        867,    5,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT60,                        867,    4,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT61,                        867,    3,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT62,                        867,    2,    1;
;FSW_CPU_HK_MISS_FAILURE_STKY_TT_BIT63,                        867,    1,    1;
;FSW_AUT_HK_CMD_RCVD_CNT,                                      867,    0,   16;
;FSW_AUT_HK_CMD_EXEC_CNT,                                      869,    0,   16;
;FSW_AUT_HK_CMD_FAIL_CNT,                                      871,    0,   16;
;FSW_AUT_HK_CMD_PKT_FAIL_CNT,                                  873,    0,   16;
;FSW_AUT_HK_CMD_CHECK_FAIL_CNT,                                875,    0,   16;
;FSW_AUT_HK_CMD_EXEC_FAIL_CNT,                                 877,    0,   16;
;FSW_AUT_HK_RULE_FIRED_SENT_MSG_CNT,                           879,    0,   16;
;FSW_AUT_HK_RULE_COMPLETE_RCV_MSG_CNT,                         881,    0,   16;
;FSW_AUT_HK_RULE_ABORT_RCV_MSG_CNT,                            883,    0,   16;
;FSW_AUT_HK_RULES_LOAD_NV_MEM_CNT,                             885,    0,   16;
;FSW_AUT_HK_CT_LOAD_NV_MEM_CNT_LSB,                            887,    0,    8;
;FSW_AUT_HK_SV_LOAD_NVM_CNT_LSB,                               888,    0,    8;
;FSW_AUT_HK_RULES_LOAD_RAM_CNT_LSB,                            889,    0,    8;
;FSW_AUT_HK_CT_LOAD_RAM_CNT_LSB,                               890,    0,    8;
;FSW_AUT_HK_SV_LOAD_RAM_CNT_LSB,                               891,    0,    8;
;FSW_AUT_AUT_RULE_TOTAL_TRIGGER_CNT_LSB,                       892,    0,    8;
;FSW_FI_HK_CMD_RCVD_CNT,                                       893,    0,   16;
;FSW_FI_HK_CMD_EXEC_CNT,                                       895,    0,   16;
;FSW_FI_HK_CMD_FAIL_CNT,                                       897,    0,   16;
;FSW_FI_HK_CMD_PKT_FAIL_CNT,                                   899,    0,   16;
;FSW_FI_HK_CMD_CHECK_FAIL_CNT,                                 901,    0,   16;
;FSW_FI_HK_CMD_EXEC_FAIL_CNT,                                  903,    0,   16;
;FSW_FI_HK_EPIHI_FILE_CNT,                                     905,    0,   16;
;FSW_FI_HK_EPILO_FILE_CNT,                                     907,    0,   16;
;FSW_FI_HK_FIELDS1_FILE_CNT,                                   909,    0,   16;
;FSW_FI_HK_FIELDS2_FILE_CNT,                                   911,    0,   16;
;FSW_FI_HK_SWEAP_FILE_CNT,                                     913,    0,   16;
;FSW_FI_HK_WISPR_FILE_CNT,                                     915,    0,   16;
;FSW_FI_HK_EPIHI_EXEC_CMDS,                                    917,    0,   16;
;FSW_FI_HK_EPILO_EXEC_CMDS,                                    919,    0,   16;
;FSW_FI_HK_FIELDS1_EXEC_CMDS,                                  921,    0,   16;
;FSW_FI_HK_FIELDS2_EXEC_CMDS,                                  923,    0,   16;
;FSW_FI_HK_SWEAP_EXEC_CMDS,                                    925,    0,   16;
;FSW_FI_HK_WISPR_EXEC_CMDS,                                    927,    0,   16;
;FSW_FI_HK_EPIHI_FAILED_CMDS,                                  929,    0,   16;
;FSW_FI_HK_EPILO_FAILED_CMDS,                                  931,    0,   16;
;FSW_FI_HK_FIELDS1_FAILED_CMDS,                                933,    0,   16;
;FSW_FI_HK_FIELDS2_FAILED_CMDS,                                935,    0,   16;
;FSW_FI_HK_SWEAP_FAILED_CMDS,                                  937,    0,   16;
;FSW_FI_HK_WISPR_FAILED_CMDS,                                  939,    0,   16;
;FSW_FI_HK_EPIHI_PROCESSING_FILE,                              941,    0,   16;
;FSW_FI_HK_EPILO_PROCESSING_FILE,                              943,    0,   16;
;FSW_FI_HK_FIELDS1_PROCESSING_FILE,                            945,    0,   16;
;FSW_FI_HK_FIELDS2_PROCESSING_FILE,                            947,    0,   16;
;FSW_FI_HK_SWEAP_PROCESSING_FILE,                              949,    0,   16;
;FSW_FI_HK_WISPR_PROCESSING_FILE,                              951,    0,   16;
;FSW_FI_HK_EPIHI_DELAY,                                        953,    0,   32;
;FSW_FI_HK_EPILO_DELAY,                                        957,    0,   32;
;FSW_FI_HK_FIELDS1_DELAY,                                      961,    0,   32;
;FSW_FI_HK_FIELDS2_DELAY,                                      965,    0,   32;
;FSW_FI_HK_SWEAP_DELAY,                                        969,    0,   32;
;FSW_FI_HK_WISPR_DELAY,                                        973,    0,   32;
;FSW_FI_HK_EPIHI_DELAY_CNT,                                    977,    0,   32;
;FSW_FI_HK_EPILO_DELAY_CNT,                                    981,    0,   32;
;FSW_FI_HK_FIELDS1_DELAY_CNT,                                  985,    0,   32;
;FSW_FI_HK_FIELDS2_DELAY_CNT,                                  989,    0,   32;
;FSW_FI_HK_SWEAP_DELAY_CNT,                                    993,    0,   32;
;FSW_FI_HK_WISPR_DELAY_CNT,                                    997,    0,   32;
;FSW_FM_HK_LONG_DURATION_CMD_ACTIVE,                          1001,    0,    1;
;FSW_FM_HK_SHORT_DURATION_CMD_ACTIVE,                         1002,    7,    1;
;FSW_FM_HK_LOW_PRIORITY_CMD_ACTIVE,                           1002,    6,    1;
;FSW_FM_HK_FS_ACCESS_RAM,                                     1002,    5,    1;
;FSW_FM_HK_LP_CMD_PUT_FAIL_CNT,                               1002,    4,   16;
;FSW_FM_HK_LP_CMDS_RCVD_CNT,                                  1004,    4,   16;
;FSW_FM_HK_LP_CMDS_FAIL_CNT,                                  1006,    4,   16;
;FSW_FM_HK_LP_CMDS_SUCCESS_CNT,                               1008,    4,   16;
;FSW_FM_HK_CMD_FS_CREATE_ATTEMPT_TT,                          1010,    4,    1;
;FSW_FM_HK_CMD_REJ_LP_FS_FILE_SYS_OPER_TT,                    1010,    3,    1;
;FSW_FM_HK_CMD_REJ_LP_SSR_BBT_POKE_TT,                        1010,    2,    1;
;FSW_FM_HK_CMD_REJ_LP_SSR_BBT_COPY_TT,                        1010,    1,    1;
;FSW_FM_HK_CMD_REJ_LP_FS_DISMOUNT_TT,                         1010,    0,    1;
;FSW_FM_HK_CMD_REJ_LP_FS_GARBAGE_COLLECT_TT,                  1011,    7,    1;
;FSW_FM_HK_CMD_REJ_LP_FS_CREATE_NEW_TT,                       1011,    6,    1;
;FSW_FM_HK_CMD_REJ_LP_FS_DIR_LIST_TT,                         1011,    5,    1;
;FSW_FM_HK_CMD_REJ_LP_SSR_DESTR_DIAG_TT,                      1011,    4,    1;
;FSW_FM_HK_CMD_REJ_LP_SSR_READ_MFGR_BAD_BLOCK_MKR_TT,         1011,    3,    1;
;FSW_FM_HK_CMD_REJ_LP_SSR_FLASH_ERASE_TT,                     1011,    2,    1;
;FSW_FM_HK_CMD_REJ_LP_FS_MOUNT_TT,                            1011,    1,    1;
;FSW_FM_HK_CMD_REJ_LP_TT,                                     1011,    0,    1;
;FSW_FM_HK_FLASH_PWR,                                         1012,    7,    1;
;FSW_FM_HK_DIAG_ACTIVE,                                       1012,    6,    1;
;FSW_FM_HK_DIAG_RSLT,                                         1012,    5,    1;
;FSW_FM_HK_FS_NUM_USED_OBJECTS,                               1012,    4,   32;
;FSW_FM_HK_FS_NUM_UNRECOVERED_WRITE_FAILURES,                 1016,    4,   32;
;FSW_FM_HK_FS_CLUSTERS_FREE_SSR,                              1020,    4,   32;
;FSW_FM_HK_FS_CLUSTERS_FREE_RAM,                              1024,    4,   32;
;FSW_FM_HK_FS_ALMOST_FULL_SSR,                                1028,    4,    1;
;FSW_FM_HK_FS_ALMOST_FULL_RAM,                                1028,    3,    1;
;FSW_FM_HK_FS_MOUNT_PT_CREATED,                               1028,    2,    1;
;FSW_FM_HK_FS_DEV_INITIALIZED,                                1028,    1,    1;
;FSW_FM_HK_FOUND_EXISTING_DIR,                                1028,    0,    1;
;FSW_FM_HK_FS_CREATE_SUCCESS,                                 1029,    7,    1;
;FSW_FM_HK_FS_SSR_VOLUME_MOUNTED,                             1029,    6,    1;
;FSW_FM_HK_FS_RAM_VOLUME_MOUNTED,                             1029,    5,    1;
;FSW_FM_HK_RAM_FOUND_EXISTING_DIR,                            1029,    4,    1;
;FSW_FM_HK_FS_DIAG_TYPE,                                      1029,    3,    4;
;FSW_FM_HK_FS_DIAG_ACTIVE,                                    1030,    7,    1;
;FSW_FM_HK_FS_DIAG_RSLT,                                      1030,    6,    1;
;FSW_FM_HK_FS_DIAG_ERR_CNT,                                   1030,    5,   16;
;FSW_FM_HK_FS_DIAG_START_BLOCK,                               1032,    5,   16;
;FSW_FM_HK_FS_DIAG_STOP_BLOCK,                                1034,    5,   16;
;FSW_FM_HK_FS_DIAG_CURR_LOC,                                  1036,    5,   32;
;FSW_FM_HK_GARB_CLXN_BLOCK_COLLECTED_CNT,                     1040,    5,   32;
;FSW_FM_HK_FS_NUM_ERASED_BLOCKS,                              1044,    5,   32;
;FSW_FM_HK_FS_CUR_ALLOCATION_BLOCK,                           1048,    5,   32;
;FSW_FM_HK_FS_NUM_FREE_TNODES,                                1052,    5,   32;
;FSW_FM_HK_FS_NUM_FREE_OBJECTS,                               1056,    5,   32;
;FSW_FM_HK_FS_NUM_FREE_CHUNKS,                                1060,    5,   32;
;FSW_FM_HK_FS_NUM_BLOCK_ERASURES,                             1064,    5,   32;
;FSW_FM_HK_FS_NUM_GARBAGE_COLLECTIONS,                        1068,    5,   32;
;FSW_FM_HK_FS_NUM_DELETIONS,                                  1072,    5,   32;
;FSW_FM_HK_FS_NUM_RETIRED_BLOCKS,                             1076,    5,   32;
;FSW_FM_HK_SSR_REG_STATE,                                     1080,    5,    1;
;FSW_FM_HK_SSR_SDRAM_STATE,                                   1080,    4,    1;
;FSW_FM_HK_SSR_FS_FS_STATE,                                   1080,    3,    1;
;FSW_FM_HK_SSR_FLASH_RDY_STATUS,                              1080,    2,   16;
;FSW_FM_HK_SSR_LAST_READ_PAGE,                                1082,    2,   32;
;FSW_FM_HK_SSR_LAST_WRITE_PAGE,                               1086,    2,   32;
;FSW_FM_HK_SSR_READ_ERR_CNT,                                  1090,    2,   32;
;FSW_FM_HK_SSR_WRITE_ERR_CNT,                                 1094,    2,   32;
;FSW_FM_HK_SSR_READ_SUCCESS_CNT,                              1098,    2,   32;
;FSW_FM_HK_SSR_WRITE_SUCCESS_CNT,                             1102,    2,   32;
;FSW_FM_HK_SSR_FLASH_ISR_FAIL_CNT,                            1106,    2,   32;
;FSW_FM_HK_SSR_FLASH_FAIL_INT_P0_CNT,                         1110,    2,   32;
;FSW_FM_HK_SSR_FLASH_FAIL_INT_P1_CNT,                         1114,    2,   32;
;FSW_FM_HK_SSR_COMPLETE_SEM_TIMEOUT_CNT,                      1118,    2,   32;
;FSW_FM_HK_SSR_COMPLETE_SEM_FAIL_CNT,                         1122,    2,   32;
;FSW_FM_HK_SSR_LAST_ECC_UNCORRECTED_ERR_PAGE,                 1126,    2,   32;
;FSW_FM_HK_SSR_ECC_UNCORRECTED_CNT,                           1130,    2,   32;
;FSW_FM_HK_SSR_ECC_CORRECT_CNT,                               1134,    2,   32;
;FSW_FM_HK_SSR_SSR_ERR_LOG_UNCORRECTED_CNT,                   1138,    2,   32;
;FSW_FM_HK_SSR_SSR_ERR_LOG_IDX,                               1142,    2,   32;
;FSW_FM_HK_SSR_SSR_LAST_ERASE_BLK,                            1146,    2,   32;
;FSW_GC_HK_CMD_RCVD_CNT,                                      1150,    2,   16;
;FSW_GC_HK_CMD_EXEC_CNT,                                      1152,    2,   16;
;FSW_GC_HK_CMD_FAIL_CNT,                                      1154,    2,   16;
;FSW_GC_HK_CMD_PKT_FAIL_CNT,                                  1156,    2,   16;
;FSW_GC_HK_CMD_CHECK_FAIL_CNT,                                1158,    2,   16;
;FSW_GC_HK_CMD_EXEC_FAIL_CNT,                                 1160,    2,   16;
;FSW_HTM_HK_PKTS_REC_CNT_LSB,                                 1162,    2,    8;
;FSW_HTM_HK_PKTS_DUMP_CNT,                                    1163,    2,   32;
;FSW_HTM_HK_BB_DUMP_PROGRESS_TT,                              1167,    2,    1;
;FSW_HTM_HK_BB_DUMP_TT,                                       1167,    1,    1;
;FSW_HTM_HK_BB_RECORD_TT,                                     1167,    0,    1;
;FSW_ITF_HK_CMD_RCVD_CNT,                                     1168,    7,   16;
;FSW_ITF_HK_CMD_EXEC_CNT,                                     1170,    7,   16;
;FSW_ITF_HK_CMD_FAIL_CNT,                                     1172,    7,   16;
;FSW_ITF_HK_CMD_PKT_FAIL_CNT,                                 1174,    7,   16;
;FSW_ITF_HK_CMD_CHECK_FAIL_CNT,                               1176,    7,   16;
;FSW_ITF_HK_CMD_EXEC_FAIL_CNT,                                1178,    7,   16;
;FSW_ITF_TT_BLD_STAT_PKT_Q_PUT_ERR_TT,                        1180,    7,    1;
;FSW_ITF_BLD_INVALID_MID_TT,                                  1180,    6,    1;
;FSW_ITF_BLD_TASK_PIPE_ERR_TT,                                1180,    5,    1;
;FSW_ITF_BUILD_INIT_ITF_ERR_TT,                               1180,    4,    1;
;FSW_ITF_BLD_STAT_PKT_Q_GET_ERR_TT,                           1180,    3,    1;
;FSW_ITF_BLD_PKT_Q_PUT_ERR_TT,                                1180,    2,    1;
;FSW_ITF_RCV_TASK_MSG_RCV_ERR_TT,                             1180,    1,    1;
;FSW_ITF_FIELDS1_CT_VC_BLD_ITFS_SENT_CNT,                     1180,    0,   32;
;FSW_ITF_FIELDS1_CT_VC_BLD_PAYLOAD_PKTS_SENT_CNT,             1184,    0,   32;
;FSW_ITF_FIELDS1_CT_VC_BLD_ERR_CNT,                           1188,    0,   16;
;FSW_ITF_FIELDS1_CT_VC_BLD_STATUS_PKT_RECV_ERR_CNT,           1190,    0,   16;
;FSW_ITF_FIELDS1_CT_VC_BLD_PKTS_DROPPED_CNT,                  1192,    0,   16;
;FSW_ITF_FIELDS2_CT_VC_BLD_ITFS_SENT_CNT,                     1194,    0,   32;
;FSW_ITF_FIELDS2_CT_VC_BLD_PAYLOAD_PKTS_SENT_CNT,             1198,    0,   32;
;FSW_ITF_FIELDS2_CT_VC_BLD_ERR_CNT,                           1202,    0,   16;
;FSW_ITF_FIELDS2_CT_VC_BLD_STATUS_PKT_RECV_ERR_CNT,           1204,    0,   16;
;FSW_ITF_FIELDS2_CT_VC_BLD_PKTS_DROPPED_CNT,                  1206,    0,   16;
;FSW_ITF_SWEAP_CT_VC_BLD_ITFS_SENT_CNT,                       1208,    0,   32;
;FSW_ITF_SWEAP_CT_VC_BLD_PAYLOAD_PKTS_SENT_CNT,               1212,    0,   32;
;FSW_ITF_SWEAP_CT_VC_BLD_ERR_CNT,                             1216,    0,   16;
;FSW_ITF_SWEAP_CT_VC_BLD_STATUS_PKT_RECV_ERR_CNT,             1218,    0,   16;
;FSW_ITF_SWEAP_CT_VC_BLD_PKTS_DROPPED_CNT,                    1220,    0,   16;
;FSW_ITF_ISIS_EPI_HI_CT_VC_BLD_ITFS_SENT_CNT,                 1222,    0,   32;
;FSW_ITF_ISIS_EPI_HI_CT_VC_BLD_PAYLOAD_PKTS_SENT_CNT,         1226,    0,   32;
;FSW_ITF_ISIS_EPI_HI_CT_VC_BLD_ERR_CNT,                       1230,    0,   16;
;FSW_ITF_ISIS_EPI_HI_CT_VC_BLD_STATUS_PKT_RECV_ERR_CNT,       1232,    0,   16;
;FSW_ITF_ISIS_EPI_HI_CT_VC_BLD_PKTS_DROPPED_CNT,              1234,    0,   16;
;FSW_ITF_ISIS_EPI_LO_CT_VC_BLD_ITFS_SENT_CNT,                 1236,    0,   32;
;FSW_ITF_ISIS_EPI_LO_CT_VC_BLD_PAYLOAD_PKTS_SENT_CNT,         1240,    0,   32;
;FSW_ITF_ISIS_EPI_LO_CT_VC_BLD_ERR_CNT,                       1244,    0,   16;
;FSW_ITF_ISIS_EPI_LO_CT_VC_BLD_STATUS_PKT_RECV_ERR_CNT,       1246,    0,   16;
;FSW_ITF_ISIS_EPI_LO_CT_VC_BLD_PKTS_DROPPED_CNT,              1248,    0,   16;
;FSW_ITF_WISPR_CT_VC_BLD_ITFS_SENT_CNT,                       1250,    0,   32;
;FSW_ITF_WISPR_CT_VC_BLD_PAYLOAD_PKTS_SENT_CNT,               1254,    0,   32;
;FSW_ITF_WISPR_CT_VC_BLD_ERR_CNT,                             1258,    0,   16;
;FSW_ITF_WISPR_CT_VC_BLD_STATUS_PKT_RECV_ERR_CNT,             1260,    0,   16;
;FSW_ITF_WISPR_CT_VC_BLD_PKTS_DROPPED_CNT,                    1262,    0,   16;
;FSW_ITF_HTM_VC_BLD_ITFS_SENT_CNT,                            1264,    0,   32;
;FSW_ITF_HTM_VC_BLD_PAYLOAD_PKTS_SENT_CNT,                    1268,    0,   32;
;FSW_ITF_HTM_VC_BLD_ERR_CNT,                                  1272,    0,   16;
;FSW_ITF_HTM_VC_BLD_STATUS_PKT_RECV_ERR_CNT,                  1274,    0,   16;
;FSW_ITF_HTM_VC_BLD_PKTS_DROPPED_CNT,                         1276,    0,   16;
;FSW_ITF_SBC_P_HS_CT_VC_BLD_ITFS_SENT_CNT,                    1278,    0,   32;
;FSW_ITF_SBC_P_HS_CT_VC_BLD_PAYLOAD_PKTS_SENT_CNT,            1282,    0,   32;
;FSW_ITF_SBC_P_HS_CT_VC_BLD_ERR_CNT,                          1286,    0,   16;
;FSW_ITF_SBC_P_HS_CT_VC_BLD_STATUS_PKT_RECV_ERR_CNT,          1288,    0,   16;
;FSW_ITF_SBC_P_HS_CT_VC_BLD_PKTS_DROPPED_CNT,                 1290,    0,   16;
;FSW_ITF_SBC_P_BS_CT_VC_BLD_ITFS_SENT_CNT,                    1292,    0,   32;
;FSW_ITF_SBC_P_BS_CT_VC_BLD_PAYLOAD_PKTS_SENT_CNT,            1296,    0,   32;
;FSW_ITF_SBC_P_BS_CT_VC_BLD_ERR_CNT,                          1300,    0,   16;
;FSW_ITF_SBC_P_BS_CT_VC_BLD_STATUS_PKT_RECV_ERR_CNT,          1302,    0,   16;
;FSW_ITF_SBC_P_BS_CT_VC_BLD_PKTS_DROPPED_CNT,                 1304,    0,   16;
;FSW_ITF_SBC_P_A_CT_VC_BLD_ITFS_SENT_CNT,                     1306,    0,   32;
;FSW_ITF_SBC_P_A_CT_VC_BLD_PAYLOAD_PKTS_SENT_CNT,             1310,    0,   32;
;FSW_ITF_SBC_P_A_CT_VC_BLD_ERR_CNT,                           1314,    0,   16;
;FSW_ITF_SBC_P_A_CT_VC_BLD_PKTS_DROPPED_CNT,                  1316,    0,   16;
;FSW_ITF_SBC_P_B_CT_VC_BLD_ITFS_SENT_CNT,                     1318,    0,   32;
;FSW_ITF_SBC_P_B_CT_VC_BLD_PAYLOAD_PKTS_SENT_CNT,             1322,    0,   32;
;FSW_ITF_SBC_P_B_CT_VC_BLD_ERR_CNT,                           1326,    0,   16;
;FSW_ITF_SBC_P_B_CT_VC_BLD_PKTS_DROPPED_CNT,                  1328,    0,   16;
;FSW_ITF_SBC_P_C_CT_VC_BLD_ITFS_SENT_CNT,                     1330,    0,   32;
;FSW_ITF_SBC_P_C_CT_VC_BLD_PAYLOAD_PKTS_SENT_CNT,             1334,    0,   32;
;FSW_ITF_SBC_P_C_CT_VC_BLD_ERR_CNT,                           1338,    0,   16;
;FSW_ITF_SBC_P_C_CT_VC_BLD_PKTS_DROPPED_CNT,                  1340,    0,   16;
;FSW_ITF_SBC_P_HS_XSBC_VC_BLD_ITFS_SENT_CNT,                  1342,    0,   32;
;FSW_ITF_SBC_P_HS_XSBC_VC_BLD_PAYLOAD_PKTS_SENT_CNT,          1346,    0,   32;
;FSW_ITF_SBC_P_HS_XSBC_VC_BLD_ERR_CNT,                        1350,    0,   16;
;FSW_ITF_SBC_P_HS_XSBC_VC_BLD_PKTS_DROPPED_CNT,               1352,    0,   16;
;FSW_ITF_SBC_P_BS_XSBC_VC_BLD_ITFS_SENT_CNT,                  1354,    0,   32;
;FSW_ITF_SBC_P_BS_XSBC_VC_BLD_PAYLOAD_PKTS_SENT_CNT,          1358,    0,   32;
;FSW_ITF_SBC_P_BS_XSBC_VC_BLD_ERR_CNT,                        1362,    0,   16;
;FSW_ITF_SBC_P_BS_XSBC_VC_BLD_PKTS_DROPPED_CNT,               1364,    0,   16;
;FSW_ITF_SBC_P_A_XSBC_VC_BLD_ITFS_SENT_CNT,                   1366,    0,   32;
;FSW_ITF_SBC_P_A_XSBC_VC_BLD_PAYLOAD_PKTS_SENT_CNT,           1370,    0,   32;
;FSW_ITF_SBC_P_A_XSBC_VC_BLD_ERR_CNT,                         1374,    0,   16;
;FSW_ITF_SBC_P_A_XSBC_VC_BLD_PKTS_DROPPED_CNT,                1376,    0,   16;
;FSW_ITF_SBC_P_B_XSBC_VC_BLD_ITFS_SENT_CNT,                   1378,    0,   32;
;FSW_ITF_SBC_P_B_XSBC_VC_BLD_PAYLOAD_PKTS_SENT_CNT,           1382,    0,   32;
;FSW_ITF_SBC_P_B_XSBC_VC_BLD_ERR_CNT,                         1386,    0,   16;
;FSW_ITF_SBC_P_B_XSBC_VC_BLD_PKTS_DROPPED_CNT,                1388,    0,   16;
;FSW_ITF_SBC_P_C_XSBC_VC_BLD_ITFS_SENT_CNT,                   1390,    0,   32;
;FSW_ITF_SBC_P_C_XSBC_VC_BLD_PAYLOAD_PKTS_SENT_CNT,           1394,    0,   32;
;FSW_ITF_SBC_P_C_XSBC_VC_BLD_ERR_CNT,                         1398,    0,   16;
;FSW_ITF_SBC_P_C_XSBC_VC_BLD_PKTS_DROPPED_CNT,                1400,    0,   16;
;FSW_ITF_PA_SCIF_ACT_VC_BLD_ITFS_SENT_CNT,                    1402,    0,   32;
;FSW_ITF_PA_SCIF_ACT_VC_BLD_PAYLOAD_PKTS_SENT_CNT,            1406,    0,   32;
;FSW_ITF_PA_SCIF_ACT_VC_BLD_ERR_CNT,                          1410,    0,   16;
;FSW_ITF_PA_SCIF_ACT_VC_BLD_PKTS_DROPPED_CNT,                 1412,    0,   16;
;FSW_ITF_PB_SCIF_ACT_VC_BLD_ITFS_SENT_CNT,                    1414,    0,   32;
;FSW_ITF_PB_SCIF_ACT_VC_BLD_PAYLOAD_PKTS_SENT_CNT,            1418,    0,   32;
;FSW_ITF_PB_SCIF_ACT_VC_BLD_ERR_CNT,                          1422,    0,   16;
;FSW_ITF_PB_SCIF_ACT_VC_BLD_PKTS_DROPPED_CNT,                 1424,    0,   16;
;FSW_ITF_PC_SCIF_ACT_VC_BLD_ITFS_SENT_CNT,                    1426,    0,   32;
;FSW_ITF_PC_SCIF_ACT_VC_BLD_PAYLOAD_PKTS_SENT_CNT,            1430,    0,   32;
;FSW_ITF_PC_SCIF_ACT_VC_BLD_ERR_CNT,                          1434,    0,   16;
;FSW_ITF_PC_SCIF_ACT_VC_BLD_PKTS_DROPPED_CNT,                 1436,    0,   16;
;FSW_ITF_PCOM_SCIF_ACT_VC_BLD_ITFS_SENT_CNT,                  1438,    0,   32;
;FSW_ITF_PCOM_SCIF_ACT_VC_BLD_PAYLOAD_PKTS_SENT_CNT,          1442,    0,   32;
;FSW_ITF_PCOM_SCIF_ACT_VC_BLD_ERR_CNT,                        1446,    0,   16;
;FSW_ITF_PCOM_SCIF_ACT_VC_BLD_PKTS_DROPPED_CNT,               1448,    0,   16;
;FSW_ITF_PA_SCIF_BACKUP_VC_BLD_ITFS_SENT_CNT,                 1450,    0,   32;
;FSW_ITF_PA_SCIF_BACKUP_VC_BLD_PAYLOAD_PKTS_SENT_CNT,         1454,    0,   32;
;FSW_ITF_PA_SCIF_BACKUP_VC_BLD_ERR_CNT,                       1458,    0,   16;
;FSW_ITF_PA_SCIF_BACKUP_VC_BLD_PKTS_DROPPED_CNT,              1460,    0,   16;
;FSW_ITF_PB_SCIF_BACKUP_VC_BLD_ITFS_SENT_CNT,                 1462,    0,   32;
;FSW_ITF_PB_SCIF_BACKUP_VC_BLD_PAYLOAD_PKTS_SENT_CNT,         1466,    0,   32;
;FSW_ITF_PB_SCIF_BACKUP_VC_BLD_ERR_CNT,                       1470,    0,   16;
;FSW_ITF_PB_SCIF_BACKUP_VC_BLD_PKTS_DROPPED_CNT,              1472,    0,   16;
;FSW_ITF_PC_SCIF_BACKUP_VC_BLD_ITFS_SENT_CNT,                 1474,    0,   32;
;FSW_ITF_PC_SCIF_BACKUP_VC_BLD_PAYLOAD_PKTS_SENT_CNT,         1478,    0,   32;
;FSW_ITF_PC_SCIF_BACKUP_VC_BLD_ERR_CNT,                       1482,    0,   16;
;FSW_ITF_PC_SCIF_BACKUP_VC_BLD_PKTS_DROPPED_CNT,              1484,    0,   16;
;FSW_ITF_PCOM_SCIF_BACKUP_VC_BLD_ITFS_SENT_CNT,               1486,    0,   32;
;FSW_ITF_PCOM_SCIF_BACKUP_VC_BLD_PAYLOAD_PKTS_SENT_CNT,       1490,    0,   32;
;FSW_ITF_PCOM_SCIF_BACKUP_VC_BLD_ERR_CNT,                     1494,    0,   16;
;FSW_ITF_PCOM_SCIF_BACKUP_VC_BLD_STATUS_PKT_RECV_ERR_CNT,     1496,    0,   16;
;FSW_ITF_PCOM_SCIF_BACKUP_VC_BLD_PKTS_DROPPED_CNT,            1498,    0,   16;
;FSW_ITF_RCV_LATEST_RCV_SDU_ERR_ID,                           1500,    0,   32;
;FSW_ITF_FIELDS1_RCV_TOTAL_NUM_SYNC_PATTERNS,                 1504,    0,   32;
;FSW_ITF_FIELDS1_RCV_TOTAL_NUM_INVAL_ITFS,                    1508,    0,   32;
;FSW_ITF_FIELDS1_RCV_TOTAL_NUM_VAL_ITFS,                      1512,    0,   32;
;FSW_ITF_FIELDS2_RCV_TOTAL_NUM_SYNC_PATTERNS,                 1516,    0,   32;
;FSW_ITF_FIELDS2_RCV_TOTAL_NUM_INVAL_ITFS,                    1520,    0,   32;
;FSW_ITF_FIELDS2_RCV_TOTAL_NUM_VAL_ITFS,                      1524,    0,   32;
;FSW_ITF_SWEAP_RCV_TOTAL_NUM_SYNC_PATTERNS,                   1528,    0,   32;
;FSW_ITF_SWEAP_RCV_TOTAL_NUM_INVAL_ITFS,                      1532,    0,   32;
;FSW_ITF_SWEAP_RCV_TOTAL_NUM_VAL_ITFS,                        1536,    0,   32;
;FSW_ITF_ISIS_EPI_HI_RCV_TOTAL_NUM_SYNC_PATTERNS,             1540,    0,   32;
;FSW_ITF_ISIS_EPI_HI_RCV_TOTAL_NUM_INVAL_ITFS,                1544,    0,   32;
;FSW_ITF_ISIS_EPI_HI_RCV_TOTAL_NUM_VAL_ITFS,                  1548,    0,   32;
;FSW_ITF_ISIS_EPI_LO_RCV_TOTAL_NUM_SYNC_PATTERNS,             1552,    0,   32;
;FSW_ITF_ISIS_EPI_LO_RCV_TOTAL_NUM_INVAL_ITFS,                1556,    0,   32;
;FSW_ITF_ISIS_EPI_LO_RCV_TOTAL_NUM_VAL_ITFS,                  1560,    0,   32;
;FSW_ITF_WISPR_CT_RCV_TOTAL_NUM_SYNC_PATTERNS,                1564,    0,   32;
;FSW_ITF_WISPR_CT_RCV_TOTAL_NUM_INVAL_ITFS,                   1568,    0,   32;
;FSW_ITF_WISPR_CT_RCV_TOTAL_NUM_VAL_ITFS,                     1572,    0,   32;
;FSW_ITF_WISPR_IMG_RCV_TOTAL_NUM_SYNC_PATTERNS,               1576,    0,   32;
;FSW_ITF_WISPR_IMG_RCV_TOTAL_NUM_INVAL_ITFS,                  1580,    0,   32;
;FSW_ITF_WISPR_IMG_RCV_TOTAL_NUM_VAL_ITFS,                    1584,    0,   32;
;FSW_ITF_SBCA_CT_RCV_TOTAL_NUM_SYNC_PATTERNS,                 1588,    0,   32;
;FSW_ITF_SBCA_CT_RCV_TOTAL_NUM_INVAL_ITFS,                    1592,    0,   32;
;FSW_ITF_SBCA_CT_RCV_TOTAL_NUM_VAL_ITFS,                      1596,    0,   32;
;FSW_ITF_SBCB_CT_RCV_TOTAL_NUM_SYNC_PATTERNS,                 1600,    0,   32;
;FSW_ITF_SBCB_CT_RCV_TOTAL_NUM_INVAL_ITFS,                    1604,    0,   32;
;FSW_ITF_SBCB_CT_RCV_TOTAL_NUM_VAL_ITFS,                      1608,    0,   32;
;FSW_ITF_SBCC_CT_RCV_TOTAL_NUM_SYNC_PATTERNS,                 1612,    0,   32;
;FSW_ITF_SBCC_CT_RCV_TOTAL_NUM_INVAL_ITFS,                    1616,    0,   32;
;FSW_ITF_SBCC_CT_RCV_TOTAL_NUM_VAL_ITFS,                      1620,    0,   32;
;FSW_ITF_XSBC_A_RCV_TOTAL_NUM_SYNC_PATTERNS,                  1624,    0,   32;
;FSW_ITF_XSBC_A_RCV_TOTAL_NUM_INVAL_ITFS,                     1628,    0,   32;
;FSW_ITF_XSBC_A_RCV_TOTAL_NUM_VAL_ITFS,                       1632,    0,   32;
;FSW_ITF_XSBC_B_RCV_TOTAL_NUM_SYNC_PATTERNS,                  1636,    0,   32;
;FSW_ITF_XSBC_B_RCV_TOTAL_NUM_INVAL_ITFS,                     1640,    0,   32;
;FSW_ITF_XSBC_B_RCV_TOTAL_NUM_VAL_ITFS,                       1644,    0,   32;
;FSW_ITF_XSBC_C_RCV_TOTAL_NUM_SYNC_PATTERNS,                  1648,    0,   32;
;FSW_ITF_XSBC_C_RCV_TOTAL_NUM_INVAL_ITFS,                     1652,    0,   32;
;FSW_ITF_XSBC_C_RCV_TOTAL_NUM_VAL_ITFS,                       1656,    0,   32;
;FSW_ITF_AUT_A_SCIF_RCV_TOTAL_NUM_SYNC_PATTERNS,              1660,    0,   32;
;FSW_ITF_AUT_A_SCIF_RCV_TOTAL_NUM_INVAL_ITFS,                 1664,    0,   32;
;FSW_ITF_AUT_A_SCIF_RCV_TOTAL_NUM_VAL_ITFS,                   1668,    0,   32;
;FSW_ITF_AUT_B_SCIF_RCV_TOTAL_NUM_SYNC_PATTERNS,              1672,    0,   32;
;FSW_ITF_AUT_B_SCIF_RCV_TOTAL_NUM_INVAL_ITFS,                 1676,    0,   32;
;FSW_ITF_AUT_B_SCIF_RCV_TOTAL_NUM_VAL_ITFS,                   1680,    0,   32;
;FSW_ITF_AUT_C_SCIF_RCV_TOTAL_NUM_SYNC_PATTERNS,              1684,    0,   32;
;FSW_ITF_AUT_C_SCIF_RCV_TOTAL_NUM_INVAL_ITFS,                 1688,    0,   32;
;FSW_ITF_AUT_C_SCIF_RCV_TOTAL_NUM_VAL_ITFS,                   1692,    0,   32;
;FSW_ITF_AUT_COM_SCIF_RCV_TOTAL_NUM_SYNC_PATTERNS,            1696,    0,   32;
;FSW_ITF_AUT_COM_SCIF_RCV_TOTAL_NUM_INVAL_ITFS,               1700,    0,   32;
;FSW_ITF_AUT_COM_SCIF_RCV_TOTAL_NUM_VAL_ITFS,                 1704,    0,   32;
;FSW_ITF_ECUA_RCV_TOTAL_NUM_SYNC_PATTERNS,                    1708,    0,   32;
;FSW_ITF_ECUA_RCV_TOTAL_NUM_INVAL_ITFS,                       1712,    0,   32;
;FSW_ITF_ECUA_RCV_TOTAL_NUM_VAL_ITFS,                         1716,    0,   32;
;FSW_ITF_ECUB_RCV_TOTAL_NUM_SYNC_PATTERNS,                    1720,    0,   32;
;FSW_ITF_ECUB_RCV_TOTAL_NUM_INVAL_ITFS,                       1724,    0,   32;
;FSW_ITF_ECUB_RCV_TOTAL_NUM_VAL_ITFS,                         1728,    0,   32;
;FSW_ITF_RADIOA_RCV_TOTAL_NUM_SYNC_PATTERNS,                  1732,    0,   32;
;FSW_ITF_RADIOA_RCV_TOTAL_NUM_INVAL_ITFS,                     1736,    0,   32;
;FSW_ITF_RADIOA_RCV_TOTAL_NUM_VAL_ITFS,                       1740,    0,   32;
;FSW_ITF_RADIOB_RCV_TOTAL_NUM_SYNC_PATTERNS,                  1744,    0,   32;
;FSW_ITF_RADIOB_RCV_TOTAL_NUM_INVAL_ITFS,                     1748,    0,   32;
;FSW_ITF_RADIOB_RCV_TOTAL_NUM_VAL_ITFS,                       1752,    0,   32;
;FSW_ITF_PSEA_RCV_TOTAL_NUM_SYNC_PATTERNS,                    1756,    0,   32;
;FSW_ITF_PSEA_RCV_TOTAL_NUM_INVAL_ITFS,                       1760,    0,   32;
;FSW_ITF_PSEA_RCV_TOTAL_NUM_VAL_ITFS,                         1764,    0,   32;
;FSW_ITF_PSEB_RCV_TOTAL_NUM_SYNC_PATTERNS,                    1768,    0,   32;
;FSW_ITF_PSEB_RCV_TOTAL_NUM_INVAL_ITFS,                       1772,    0,   32;
;FSW_ITF_PSEB_RCV_TOTAL_NUM_VAL_ITFS,                         1776,    0,   32;
;FSW_ITF_PUMP_ELECA_RCV_TOTAL_NUM_SYNC_PATTERNS,              1780,    0,   32;
;FSW_ITF_PUMP_ELECA_RCV_TOTAL_NUM_INVAL_ITFS,                 1784,    0,   32;
;FSW_ITF_PUMP_ELECA_RCV_TOTAL_NUM_VAL_ITFS,                   1788,    0,   32;
;FSW_ITF_PUMP_ELECB_RCV_TOTAL_NUM_SYNC_PATTERNS,              1792,    0,   32;
;FSW_ITF_PUMP_ELECB_RCV_TOTAL_NUM_INVAL_ITFS,                 1796,    0,   32;
;FSW_ITF_PUMP_ELECB_RCV_TOTAL_NUM_VAL_ITFS,                   1800,    0,   32;
;FSW_ITF_SLSA_RCV_TOTAL_NUM_SYNC_PATTERNS,                    1804,    0,   32;
;FSW_ITF_SLSA_RCV_TOTAL_NUM_INVAL_ITFS,                       1808,    0,   32;
;FSW_ITF_SLSA_RCV_TOTAL_NUM_VAL_ITFS,                         1812,    0,   32;
;FSW_ITF_SLSB_RCV_TOTAL_NUM_SYNC_PATTERNS,                    1816,    0,   32;
;FSW_ITF_SLSB_RCV_TOTAL_NUM_INVAL_ITFS,                       1820,    0,   32;
;FSW_ITF_SLSB_RCV_TOTAL_NUM_VAL_ITFS,                         1824,    0,   32;
;FSW_ITF_PDUA_RCV_TOTAL_NUM_SYNC_PATTERNS,                    1828,    0,   32;
;FSW_ITF_PDUA_RCV_TOTAL_NUM_INVAL_ITFS,                       1832,    0,   32;
;FSW_ITF_PDUA_RCV_TOTAL_NUM_VAL_ITFS,                         1836,    0,   32;
;FSW_ITF_PDUB_RCV_TOTAL_NUM_SYNC_PATTERNS,                    1840,    0,   32;
;FSW_ITF_PDUB_RCV_TOTAL_NUM_INVAL_ITFS,                       1844,    0,   32;
;FSW_ITF_PDUB_RCV_TOTAL_NUM_VAL_ITFS,                         1848,    0,   32;
;FSW_ITF_FIELDS1_CT_VC_RCV_CONSEQ_ITF_SEC_CNT,                1852,    0,   32;
;FSW_ITF_FIELDS1_CT_VC_RCV_NUM_VAL_ITFS,                      1856,    0,   32;
;FSW_ITF_FIELDS1_CT_VC_RCV_NUM_PKTS_RCVD,                     1860,    0,   32;
;FSW_ITF_FIELDS1_CT_VC_RCV_NUM_STALE_SEQ_CNT,                 1864,    0,   16;
;FSW_ITF_FIELDS1_CT_VC_RCV_DISCONTIN_SEQ_CNT,                 1866,    0,   16;
;FSW_ITF_FIELDS1_CT_VC_RCV_NUM_ITFS_DISCARDED,                1868,    0,   16;
;FSW_ITF_FIELDS1_CT_VC_RCV_NUM_ITF_PKT_ERRS,                  1870,    0,   16;
;FSW_ITF_FIELDS1_CT_VC_RCV_NUM_ITF_DATA_ID_ERRS,              1872,    0,   16;
;FSW_ITF_FIELDS2_CT_VC_RCV_CONSEQ_ITF_SEC_CNT,                1874,    0,   32;
;FSW_ITF_FIELDS2_CT_VC_RCV_NUM_VAL_ITFS,                      1878,    0,   32;
;FSW_ITF_FIELDS2_CT_VC_RCV_NUM_PKTS_RCVD,                     1882,    0,   32;
;FSW_ITF_FIELDS2_CT_VC_RCV_NUM_STALE_SEQ_CNT,                 1886,    0,   16;
;FSW_ITF_FIELDS2_CT_VC_RCV_DISCONTIN_SEQ_CNT,                 1888,    0,   16;
;FSW_ITF_FIELDS2_CT_VC_RCV_NUM_ITFS_DISCARDED,                1890,    0,   16;
;FSW_ITF_FIELDS2_CT_VC_RCV_NUM_ITF_PKT_ERRS,                  1892,    0,   16;
;FSW_ITF_FIELDS2_CT_VC_RCV_NUM_ITF_DATA_ID_ERRS,              1894,    0,   16;
;FSW_ITF_SWEAP_CT_VC_RCV_CONSEQ_ITF_SEC_CNT,                  1896,    0,   32;
;FSW_ITF_SWEAP_CT_VC_RCV_NUM_VAL_ITFS,                        1900,    0,   32;
;FSW_ITF_SWEAP_CT_VC_RCV_NUM_PKTS_RCVD,                       1904,    0,   32;
;FSW_ITF_SWEAP_CT_VC_RCV_NUM_STALE_SEQ_CNT,                   1908,    0,   16;
;FSW_ITF_SWEAP_CT_VC_RCV_DISCONTIN_SEQ_CNT,                   1910,    0,   16;
;FSW_ITF_SWEAP_CT_VC_RCV_NUM_ITFS_DISCARDED,                  1912,    0,   16;
;FSW_ITF_SWEAP_CT_VC_RCV_NUM_ITF_PKT_ERRS,                    1914,    0,   16;
;FSW_ITF_SWEAP_CT_VC_RCV_NUM_ITF_DATA_ID_ERRS,                1916,    0,   16;
;FSW_ITF_ISIS_EPI_HI_CT_VC_RCV_CONSEQ_ITF_SEC_CNT,            1918,    0,   32;
;FSW_ITF_ISIS_EPI_HI_CT_VC_RCV_NUM_VAL_ITFS,                  1922,    0,   32;
;FSW_ITF_ISIS_EPI_HI_CT_VC_RCV_NUM_PKTS_RCVD,                 1926,    0,   32;
;FSW_ITF_ISIS_EPI_HI_CT_VC_RCV_NUM_STALE_SEQ_CNT,             1930,    0,   16;
;FSW_ITF_ISIS_EPI_HI_CT_VC_RCV_DISCONTIN_SEQ_CNT,             1932,    0,   16;
;FSW_ITF_ISIS_EPI_HI_CT_VC_RCV_NUM_ITFS_DISCARDED,            1934,    0,   16;
;FSW_ITF_ISIS_EPI_HI_CT_VC_RCV_NUM_ITF_PKT_ERRS,              1936,    0,   16;
;FSW_ITF_ISIS_EPI_HI_CT_VC_RCV_NUM_ITF_DATA_ID_ERRS,          1938,    0,   16;
;FSW_ITF_ISIS_EPI_LO_CT_VC_RCV_CONSEQ_ITF_SEC_CNT,            1940,    0,   32;
;FSW_ITF_ISIS_EPI_LO_CT_VC_RCV_NUM_VAL_ITFS,                  1944,    0,   32;
;FSW_ITF_ISIS_EPI_LO_CT_VC_RCV_NUM_PKTS_RCVD,                 1948,    0,   32;
;FSW_ITF_ISIS_EPI_LO_CT_VC_RCV_NUM_STALE_SEQ_CNT,             1952,    0,   16;
;FSW_ITF_ISIS_EPI_LO_CT_VC_RCV_DISCONTIN_SEQ_CNT,             1954,    0,   16;
;FSW_ITF_ISIS_EPI_LO_CT_VC_RCV_NUM_ITFS_DISCARDED,            1956,    0,   16;
;FSW_ITF_ISIS_EPI_LO_CT_VC_RCV_NUM_ITF_PKT_ERRS,              1958,    0,   16;
;FSW_ITF_ISIS_EPI_LO_CT_VC_RCV_NUM_ITF_DATA_ID_ERRS,          1960,    0,   16;
;FSW_ITF_WISPR_CT_VC_RCV_CONSEQ_ITF_SEC_CNT,                  1962,    0,   32;
;FSW_ITF_WISPR_CT_VC_RCV_NUM_VAL_ITFS,                        1966,    0,   32;
;FSW_ITF_WISPR_CT_VC_RCV_NUM_PKTS_RCVD,                       1970,    0,   32;
;FSW_ITF_WISPR_CT_VC_RCV_NUM_STALE_SEQ_CNT,                   1974,    0,   16;
;FSW_ITF_WISPR_CT_VC_RCV_DISCONTIN_SEQ_CNT,                   1976,    0,   16;
;FSW_ITF_WISPR_CT_VC_RCV_NUM_ITFS_DISCARDED,                  1978,    0,   16;
;FSW_ITF_WISPR_CT_VC_RCV_NUM_ITF_PKT_ERRS,                    1980,    0,   16;
;FSW_ITF_WISPR_CT_VC_RCV_NUM_ITF_DATA_ID_ERRS,                1982,    0,   16;
;FSW_ITF_WISPR_IMAGE_VC_RCV_CONSEQ_ITF_SEC_CNT,               1984,    0,   32;
;FSW_ITF_WISPR_IMAGE_VC_RCV_NUM_VAL_ITFS,                     1988,    0,   32;
;FSW_ITF_WISPR_IMAGE_VC_RCV_NUM_PKTS_RCVD,                    1992,    0,   32;
;FSW_ITF_WISPR_IMAGE_VC_RCV_NUM_STALE_SEQ_CNT,                1996,    0,   16;
;FSW_ITF_WISPR_IMAGE_VC_RCV_DISCONTIN_SEQ_CNT,                1998,    0,   16;
;FSW_ITF_WISPR_IMAGE_VC_RCV_NUM_ITFS_DISCARDED,               2000,    0,   16;
;FSW_ITF_WISPR_IMAGE_VC_RCV_NUM_ITF_PKT_ERRS,                 2002,    0,   16;
;FSW_ITF_WISPR_IMAGE_VC_RCV_NUM_ITF_DATA_ID_ERRS,             2004,    0,   16;
;FSW_ITF_SBC_P_HS_CT_VC_RCV_CONSEQ_ITF_SEC_CNT,               2006,    0,   32;
;FSW_ITF_SBC_P_HS_CT_VC_RCV_NUM_VAL_ITFS,                     2010,    0,   32;
;FSW_ITF_SBC_P_HS_CT_VC_RCV_NUM_PKTS_RCVD,                    2014,    0,   32;
;FSW_ITF_SBC_P_HS_CT_VC_RCV_NUM_STALE_SEQ_CNT,                2018,    0,   16;
;FSW_ITF_SBC_P_HS_CT_VC_RCV_DISCONTIN_SEQ_CNT,                2020,    0,   16;
;FSW_ITF_SBC_P_HS_CT_VC_RCV_NUM_ITFS_DISCARDED,               2022,    0,   16;
;FSW_ITF_SBC_P_HS_CT_VC_RCV_NUM_ITF_PKT_ERRS,                 2024,    0,   16;
;FSW_ITF_SBC_P_HS_CT_VC_RCV_NUM_ITF_DATA_ID_ERRS,             2026,    0,   16;
;FSW_ITF_SBC_P_BS_CT_VC_RCV_CONSEQ_ITF_SEC_CNT,               2028,    0,   32;
;FSW_ITF_SBC_P_BS_CT_VC_RCV_NUM_VAL_ITFS,                     2032,    0,   32;
;FSW_ITF_SBC_P_BS_CT_VC_RCV_NUM_PKTS_RCVD,                    2036,    0,   32;
;FSW_ITF_SBC_P_BS_CT_VC_RCV_NUM_STALE_SEQ_CNT,                2040,    0,   16;
;FSW_ITF_SBC_P_BS_CT_VC_RCV_DISCONTIN_SEQ_CNT,                2042,    0,   16;
;FSW_ITF_SBC_P_BS_CT_VC_RCV_NUM_ITFS_DISCARDED,               2044,    0,   16;
;FSW_ITF_SBC_P_BS_CT_VC_RCV_NUM_ITF_PKT_ERRS,                 2046,    0,   16;
;FSW_ITF_SBC_P_BS_CT_VC_RCV_NUM_ITF_DATA_ID_ERRS,             2048,    0,   16;
;FSW_ITF_SBC_P_A_CT_VC_RCV_CONSEQ_ITF_SEC_CNT,                2050,    0,   32;
;FSW_ITF_SBC_P_A_CT_VC_RCV_NUM_VAL_ITFS,                      2054,    0,   32;
;FSW_ITF_SBC_P_A_CT_VC_RCV_NUM_PKTS_RCVD,                     2058,    0,   32;
;FSW_ITF_SBC_P_A_CT_VC_RCV_NUM_STALE_SEQ_CNT,                 2062,    0,   16;
;FSW_ITF_SBC_P_A_CT_VC_RCV_DISCONTIN_SEQ_CNT,                 2064,    0,   16;
;FSW_ITF_SBC_P_A_CT_VC_RCV_NUM_ITFS_DISCARDED,                2066,    0,   16;
;FSW_ITF_SBC_P_A_CT_VC_RCV_NUM_ITF_PKT_ERRS,                  2068,    0,   16;
;FSW_ITF_SBC_P_A_CT_VC_RCV_NUM_ITF_DATA_ID_ERRS,              2070,    0,   16;
;FSW_ITF_SBC_P_B_CT_VC_RCV_CONSEQ_ITF_SEC_CNT,                2072,    0,   32;
;FSW_ITF_SBC_P_B_CT_VC_RCV_NUM_VAL_ITFS,                      2076,    0,   32;
;FSW_ITF_SBC_P_B_CT_VC_RCV_NUM_PKTS_RCVD,                     2080,    0,   32;
;FSW_ITF_SBC_P_B_CT_VC_RCV_NUM_STALE_SEQ_CNT,                 2084,    0,   16;
;FSW_ITF_SBC_P_B_CT_VC_RCV_DISCONTIN_SEQ_CNT,                 2086,    0,   16;
;FSW_ITF_SBC_P_B_CT_VC_RCV_NUM_ITFS_DISCARDED,                2088,    0,   16;
;FSW_ITF_SBC_P_B_CT_VC_RCV_NUM_ITF_PKT_ERRS,                  2090,    0,   16;
;FSW_ITF_SBC_P_B_CT_VC_RCV_NUM_ITF_DATA_ID_ERRS,              2092,    0,   16;
;FSW_ITF_SBC_P_C_CT_VC_RCV_CONSEQ_ITF_SEC_CNT,                2094,    0,   32;
;FSW_ITF_SBC_P_C_CT_VC_RCV_NUM_VAL_ITFS,                      2098,    0,   32;
;FSW_ITF_SBC_P_C_CT_VC_RCV_NUM_PKTS_RCVD,                     2102,    0,   32;
;FSW_ITF_SBC_P_C_CT_VC_RCV_NUM_STALE_SEQ_CNT,                 2106,    0,   16;
;FSW_ITF_SBC_P_C_CT_VC_RCV_DISCONTIN_SEQ_CNT,                 2108,    0,   16;
;FSW_ITF_SBC_P_C_CT_VC_RCV_NUM_ITFS_DISCARDED,                2110,    0,   16;
;FSW_ITF_SBC_P_C_CT_VC_RCV_NUM_ITF_PKT_ERRS,                  2112,    0,   16;
;FSW_ITF_SBC_P_C_CT_VC_RCV_NUM_ITF_DATA_ID_ERRS,              2114,    0,   16;
;FSW_ITF_SBC_P_HS_XSBC_VC_RCV_CONSEQ_ITF_SEC_CNT,             2116,    0,   32;
;FSW_ITF_SBC_P_HS_XSBC_VC_RCV_NUM_VAL_ITFS,                   2120,    0,   32;
;FSW_ITF_SBC_P_HS_XSBC_VC_RCV_NUM_PKTS_RCVD,                  2124,    0,   32;
;FSW_ITF_SBC_P_HS_XSBC_VC_RCV_NUM_STALE_SEQ_CNT,              2128,    0,   16;
;FSW_ITF_SBC_P_HS_XSBC_VC_RCV_DISCONTIN_SEQ_CNT,              2130,    0,   16;
;FSW_ITF_SBC_P_HS_XSBC_VC_RCV_NUM_ITFS_DISCARDED,             2132,    0,   16;
;FSW_ITF_SBC_P_HS_XSBC_VC_RCV_NUM_ITF_PKT_ERRS,               2134,    0,   16;
;FSW_ITF_SBC_P_HS_XSBC_VC_RCV_NUM_ITF_DATA_ID_ERRS,           2136,    0,   16;
;FSW_ITF_SBC_P_BS_XSBC_VC_RCV_CONSEQ_ITF_SEC_CNT,             2138,    0,   32;
;FSW_ITF_SBC_P_BS_XSBC_VC_RCV_NUM_VAL_ITFS,                   2142,    0,   32;
;FSW_ITF_SBC_P_BS_XSBC_VC_RCV_NUM_PKTS_RCVD,                  2146,    0,   32;
;FSW_ITF_SBC_P_BS_XSBC_VC_RCV_NUM_STALE_SEQ_CNT,              2150,    0,   16;
;FSW_ITF_SBC_P_BS_XSBC_VC_RCV_DISCONTIN_SEQ_CNT,              2152,    0,   16;
;FSW_ITF_SBC_P_BS_XSBC_VC_RCV_NUM_ITFS_DISCARDED,             2154,    0,   16;
;FSW_ITF_SBC_P_BS_XSBC_VC_RCV_NUM_ITF_PKT_ERRS,               2156,    0,   16;
;FSW_ITF_SBC_P_BS_XSBC_VC_RCV_NUM_ITF_DATA_ID_ERRS,           2158,    0,   16;
;FSW_ITF_SBC_P_A_XSBC_VC_RCV_CONSEQ_ITF_SEC_CNT,              2160,    0,   32;
;FSW_ITF_SBC_P_A_XSBC_VC_RCV_NUM_VAL_ITFS,                    2164,    0,   32;
;FSW_ITF_SBC_P_A_XSBC_VC_RCV_NUM_PKTS_RCVD,                   2168,    0,   32;
;FSW_ITF_SBC_P_A_XSBC_VC_RCV_NUM_STALE_SEQ_CNT,               2172,    0,   16;
;FSW_ITF_SBC_P_A_XSBC_VC_RCV_DISCONTIN_SEQ_CNT,               2174,    0,   16;
;FSW_ITF_SBC_P_A_XSBC_VC_RCV_NUM_ITFS_DISCARDED,              2176,    0,   16;
;FSW_ITF_SBC_P_A_XSBC_VC_RCV_NUM_ITF_PKT_ERRS,                2178,    0,   16;
;FSW_ITF_SBC_P_A_XSBC_VC_RCV_NUM_ITF_DATA_ID_ERRS,            2180,    0,   16;
;FSW_ITF_SBC_P_B_XSBC_VC_RCV_CONSEQ_ITF_SEC_CNT,              2182,    0,   32;
;FSW_ITF_SBC_P_B_XSBC_VC_RCV_NUM_VAL_ITFS,                    2186,    0,   32;
;FSW_ITF_SBC_P_B_XSBC_VC_RCV_NUM_PKTS_RCVD,                   2190,    0,   32;
;FSW_ITF_SBC_P_B_XSBC_VC_RCV_NUM_STALE_SEQ_CNT,               2194,    0,   16;
;FSW_ITF_SBC_P_B_XSBC_VC_RCV_DISCONTIN_SEQ_CNT,               2196,    0,   16;
;FSW_ITF_SBC_P_B_XSBC_VC_RCV_NUM_ITFS_DISCARDED,              2198,    0,   16;
;FSW_ITF_SBC_P_B_XSBC_VC_RCV_NUM_ITF_PKT_ERRS,                2200,    0,   16;
;FSW_ITF_SBC_P_B_XSBC_VC_RCV_NUM_ITF_DATA_ID_ERRS,            2202,    0,   16;
;FSW_ITF_SBC_P_C_XSBC_VC_RCV_CONSEQ_ITF_SEC_CNT,              2204,    0,   32;
;FSW_ITF_SBC_P_C_XSBC_VC_RCV_NUM_VAL_ITFS,                    2208,    0,   32;
;FSW_ITF_SBC_P_C_XSBC_VC_RCV_NUM_PKTS_RCVD,                   2212,    0,   32;
;FSW_ITF_SBC_P_C_XSBC_VC_RCV_NUM_STALE_SEQ_CNT,               2216,    0,   16;
;FSW_ITF_SBC_P_C_XSBC_VC_RCV_DISCONTIN_SEQ_CNT,               2218,    0,   16;
;FSW_ITF_SBC_P_C_XSBC_VC_RCV_NUM_ITFS_DISCARDED,              2220,    0,   16;
;FSW_ITF_SBC_P_C_XSBC_VC_RCV_NUM_ITF_PKT_ERRS,                2222,    0,   16;
;FSW_ITF_SBC_P_C_XSBC_VC_RCV_NUM_ITF_DATA_ID_ERRS,            2224,    0,   16;
;FSW_ITF_PCOM_SCIF_ACT_VC_RCV_CONSEQ_ITF_SEC_CNT,             2226,    0,   32;
;FSW_ITF_PCOM_SCIF_ACT_VC_RCV_NUM_VAL_ITFS,                   2230,    0,   32;
;FSW_ITF_PCOM_SCIF_ACT_VC_RCV_NUM_PKTS_RCVD,                  2234,    0,   32;
;FSW_ITF_PCOM_SCIF_ACT_VC_RCV_NUM_STALE_SEQ_CNT,              2238,    0,   16;
;FSW_ITF_PCOM_SCIF_ACT_VC_RCV_DISCONTIN_SEQ_CNT,              2240,    0,   16;
;FSW_ITF_PCOM_SCIF_ACT_VC_RCV_NUM_ITFS_DISCARDED,             2242,    0,   16;
;FSW_ITF_PCOM_SCIF_ACT_VC_RCV_NUM_ITF_PKT_ERRS,               2244,    0,   16;
;FSW_ITF_PCOM_SCIF_ACT_VC_RCV_NUM_ITF_DATA_ID_ERRS,           2246,    0,   16;
;FSW_ITF_PCOM_SCIF_BACKUP_VC_RCV_CONSEQ_ITF_SEC_CNT,          2248,    0,   32;
;FSW_ITF_PCOM_SCIF_BACKUP_VC_RCV_NUM_VAL_ITFS,                2252,    0,   32;
;FSW_ITF_PCOM_SCIF_BACKUP_VC_RCV_NUM_PKTS_RCVD,               2256,    0,   32;
;FSW_ITF_PCOM_SCIF_BACKUP_VC_RCV_NUM_STALE_SEQ_CNT,           2260,    0,   16;
;FSW_ITF_PCOM_SCIF_BACKUP_VC_RCV_DISCONTIN_SEQ_CNT,           2262,    0,   16;
;FSW_ITF_PCOM_SCIF_BACKUP_VC_RCV_NUM_ITFS_DISCARDED,          2264,    0,   16;
;FSW_ITF_PCOM_SCIF_BACKUP_VC_RCV_NUM_ITF_PKT_ERRS,            2266,    0,   16;
;FSW_ITF_PCOM_SCIF_BACKUP_VC_RCV_NUM_ITF_DATA_ID_ERRS,        2268,    0,   16;
;FSW_ITF_ECUA_TLM_VC_RCV_CONSEQ_ITF_SEC_CNT,                  2270,    0,   32;
;FSW_ITF_ECUA_TLM_VC_RCV_NUM_VAL_ITFS,                        2274,    0,   32;
;FSW_ITF_ECUA_TLM_VC_RCV_NUM_PKTS_RCVD,                       2278,    0,   32;
;FSW_ITF_ECUA_TLM_VC_RCV_NUM_STALE_SEQ_CNT,                   2282,    0,   16;
;FSW_ITF_ECUA_TLM_VC_RCV_DISCONTIN_SEQ_CNT,                   2284,    0,   16;
;FSW_ITF_ECUA_TLM_VC_RCV_NUM_ITFS_DISCARDED,                  2286,    0,   16;
;FSW_ITF_ECUA_TLM_VC_RCV_NUM_ITF_PKT_ERRS,                    2288,    0,   16;
;FSW_ITF_ECUA_TLM_VC_RCV_NUM_ITF_DATA_ID_ERRS,                2290,    0,   16;
;FSW_ITF_ECUB_TLM_VC_RCV_CONSEQ_ITF_SEC_CNT,                  2292,    0,   32;
;FSW_ITF_ECUB_TLM_VC_RCV_NUM_VAL_ITFS,                        2296,    0,   32;
;FSW_ITF_ECUB_TLM_VC_RCV_NUM_PKTS_RCVD,                       2300,    0,   32;
;FSW_ITF_ECUB_TLM_VC_RCV_NUM_STALE_SEQ_CNT,                   2304,    0,   16;
;FSW_ITF_ECUB_TLM_VC_RCV_DISCONTIN_SEQ_CNT,                   2306,    0,   16;
;FSW_ITF_ECUB_TLM_VC_RCV_NUM_ITFS_DISCARDED,                  2308,    0,   16;
;FSW_ITF_ECUB_TLM_VC_RCV_NUM_ITF_PKT_ERRS,                    2310,    0,   16;
;FSW_ITF_ECUB_TLM_VC_RCV_NUM_ITF_DATA_ID_ERRS,                2312,    0,   16;
;FSW_ITF_RADIOA_TLM_VC_RCV_CONSEQ_ITF_SEC_CNT,                2314,    0,   32;
;FSW_ITF_RADIOA_TLM_VC_RCV_NUM_VAL_ITFS,                      2318,    0,   32;
;FSW_ITF_RADIOA_TLM_VC_RCV_NUM_PKTS_RCVD,                     2322,    0,   32;
;FSW_ITF_RADIOA_TLM_VC_RCV_NUM_STALE_SEQ_CNT,                 2326,    0,   16;
;FSW_ITF_RADIOA_TLM_VC_RCV_DISCONTIN_SEQ_CNT,                 2328,    0,   16;
;FSW_ITF_RADIOA_TLM_VC_RCV_NUM_ITFS_DISCARDED,                2330,    0,   16;
;FSW_ITF_RADIOA_TLM_VC_RCV_NUM_ITF_PKT_ERRS,                  2332,    0,   16;
;FSW_ITF_RADIOA_TLM_VC_RCV_NUM_ITF_DATA_ID_ERRS,              2334,    0,   16;
;FSW_ITF_RADIOB_TLM_VC_RCV_CONSEQ_ITF_SEC_CNT,                2336,    0,   32;
;FSW_ITF_RADIOB_TLM_VC_RCV_NUM_VAL_ITFS,                      2340,    0,   32;
;FSW_ITF_RADIOB_TLM_VC_RCV_NUM_PKTS_RCVD,                     2344,    0,   32;
;FSW_ITF_RADIOB_TLM_VC_RCV_NUM_STALE_SEQ_CNT,                 2348,    0,   16;
;FSW_ITF_RADIOB_TLM_VC_RCV_DISCONTIN_SEQ_CNT,                 2350,    0,   16;
;FSW_ITF_RADIOB_TLM_VC_RCV_NUM_ITFS_DISCARDED,                2352,    0,   16;
;FSW_ITF_RADIOB_TLM_VC_RCV_NUM_ITF_PKT_ERRS,                  2354,    0,   16;
;FSW_ITF_RADIOB_TLM_VC_RCV_NUM_ITF_DATA_ID_ERRS,              2356,    0,   16;
;FSW_ITF_PSEA_TLM_VC_RCV_CONSEQ_ITF_SEC_CNT,                  2358,    0,   32;
;FSW_ITF_PSEA_TLM_VC_RCV_NUM_VAL_ITFS,                        2362,    0,   32;
;FSW_ITF_PSEA_TLM_VC_RCV_NUM_PKTS_RCVD,                       2366,    0,   32;
;FSW_ITF_PSEA_TLM_VC_RCV_NUM_STALE_SEQ_CNT,                   2370,    0,   16;
;FSW_ITF_PSEA_TLM_VC_RCV_DISCONTIN_SEQ_CNT,                   2372,    0,   16;
;FSW_ITF_PSEA_TLM_VC_RCV_NUM_ITFS_DISCARDED,                  2374,    0,   16;
;FSW_ITF_PSEA_TLM_VC_RCV_NUM_ITF_PKT_ERRS,                    2376,    0,   16;
;FSW_ITF_PSEA_TLM_VC_RCV_NUM_ITF_DATA_ID_ERRS,                2378,    0,   16;
;FSW_ITF_PSEB_TLM_VC_RCV_CONSEQ_ITF_SEC_CNT,                  2380,    0,   32;
;FSW_ITF_PSEB_TLM_VC_RCV_NUM_VAL_ITFS,                        2384,    0,   32;
;FSW_ITF_PSEB_TLM_VC_RCV_NUM_PKTS_RCVD,                       2388,    0,   32;
;FSW_ITF_PSEB_TLM_VC_RCV_NUM_STALE_SEQ_CNT,                   2392,    0,   16;
;FSW_ITF_PSEB_TLM_VC_RCV_DISCONTIN_SEQ_CNT,                   2394,    0,   16;
;FSW_ITF_PSEB_TLM_VC_RCV_NUM_ITFS_DISCARDED,                  2396,    0,   16;
;FSW_ITF_PSEB_TLM_VC_RCV_NUM_ITF_PKT_ERRS,                    2398,    0,   16;
;FSW_ITF_PSEB_TLM_VC_RCV_NUM_ITF_DATA_ID_ERRS,                2400,    0,   16;
;FSW_ITF_PUMP_ELECA_TLM_VC_RCV_CONSEQ_ITF_SEC_CNT,            2402,    0,   32;
;FSW_ITF_PUMP_ELECA_TLM_VC_RCV_NUM_VAL_ITFS,                  2406,    0,   32;
;FSW_ITF_PUMP_ELECA_TLM_VC_RCV_NUM_PKTS_RCVD,                 2410,    0,   32;
;FSW_ITF_PUMP_ELECA_TLM_VC_RCV_NUM_STALE_SEQ_CNT,             2414,    0,   16;
;FSW_ITF_PUMP_ELECA_TLM_VC_RCV_DISCONTIN_SEQ_CNT,             2416,    0,   16;
;FSW_ITF_PUMP_ELECA_TLM_VC_RCV_NUM_ITFS_DISCARDED,            2418,    0,   16;
;FSW_ITF_PUMP_ELECA_TLM_VC_RCV_NUM_ITF_PKT_ERRS,              2420,    0,   16;
;FSW_ITF_PUMP_ELECA_TLM_VC_RCV_NUM_ITF_DATA_ID_ERRS,          2422,    0,   16;
;FSW_ITF_PUMP_ELECB_TLM_VC_RCV_CONSEQ_ITF_SEC_CNT,            2424,    0,   32;
;FSW_ITF_PUMP_ELECB_TLM_VC_RCV_NUM_VAL_ITFS,                  2428,    0,   32;
;FSW_ITF_PUMP_ELECB_TLM_VC_RCV_NUM_PKTS_RCVD,                 2432,    0,   32;
;FSW_ITF_PUMP_ELECB_TLM_VC_RCV_NUM_STALE_SEQ_CNT,             2436,    0,   16;
;FSW_ITF_PUMP_ELECB_TLM_VC_RCV_DISCONTIN_SEQ_CNT,             2438,    0,   16;
;FSW_ITF_PUMP_ELECB_TLM_VC_RCV_NUM_ITFS_DISCARDED,            2440,    0,   16;
;FSW_ITF_PUMP_ELECB_TLM_VC_RCV_NUM_ITF_PKT_ERRS,              2442,    0,   16;
;FSW_ITF_PUMP_ELECB_TLM_VC_RCV_NUM_ITF_DATA_ID_ERRS,          2444,    0,   16;
;FSW_ITF_SSEA_TLM_VC_RCV_CONSEQ_ITF_SEC_CNT,                  2446,    0,   32;
;FSW_ITF_SSEA_TLM_VC_RCV_NUM_VAL_ITFS,                        2450,    0,   32;
;FSW_ITF_SSEA_TLM_VC_RCV_NUM_PKTS_RCVD,                       2454,    0,   32;
;FSW_ITF_SSEA_TLM_VC_RCV_NUM_STALE_SEQ_CNT,                   2458,    0,   16;
;FSW_ITF_SSEA_TLM_VC_RCV_DISCONTIN_SEQ_CNT,                   2460,    0,   16;
;FSW_ITF_SSEA_TLM_VC_RCV_NUM_ITFS_DISCARDED,                  2462,    0,   16;
;FSW_ITF_SSEA_TLM_VC_RCV_NUM_ITF_PKT_ERRS,                    2464,    0,   16;
;FSW_ITF_SSEA_TLM_VC_RCV_NUM_ITF_DATA_ID_ERRS,                2466,    0,   16;
;FSW_ITF_SSEB_TLM_VC_RCV_CONSEQ_ITF_SEC_CNT,                  2468,    0,   32;
;FSW_ITF_SSEB_TLM_VC_RCV_NUM_VAL_ITFS,                        2472,    0,   32;
;FSW_ITF_SSEB_TLM_VC_RCV_NUM_PKTS_RCVD,                       2476,    0,   32;
;FSW_ITF_SSEB_TLM_VC_RCV_NUM_STALE_SEQ_CNT,                   2480,    0,   16;
;FSW_ITF_SSEB_TLM_VC_RCV_DISCONTIN_SEQ_CNT,                   2482,    0,   16;
;FSW_ITF_SSEB_TLM_VC_RCV_NUM_ITFS_DISCARDED,                  2484,    0,   16;
;FSW_ITF_SSEB_TLM_VC_RCV_NUM_ITF_PKT_ERRS,                    2486,    0,   16;
;FSW_ITF_SSEB_TLM_VC_RCV_NUM_ITF_DATA_ID_ERRS,                2488,    0,   16;
;FSW_ITF_PDUA_TLM_VC_RCV_CONSEQ_ITF_SEC_CNT,                  2490,    0,   32;
;FSW_ITF_PDUA_TLM_VC_RCV_NUM_VAL_ITFS,                        2494,    0,   32;
;FSW_ITF_PDUA_TLM_VC_RCV_NUM_PKTS_RCVD,                       2498,    0,   32;
;FSW_ITF_PDUA_TLM_VC_RCV_NUM_STALE_SEQ_CNT,                   2502,    0,   16;
;FSW_ITF_PDUA_TLM_VC_RCV_DISCONTIN_SEQ_CNT,                   2504,    0,   16;
;FSW_ITF_PDUA_TLM_VC_RCV_NUM_ITFS_DISCARDED,                  2506,    0,   16;
;FSW_ITF_PDUA_TLM_VC_RCV_NUM_ITF_PKT_ERRS,                    2508,    0,   16;
;FSW_ITF_PDUA_TLM_VC_RCV_NUM_ITF_DATA_ID_ERRS,                2510,    0,   16;
;FSW_ITF_PDUB_TLM_VC_RCV_CONSEQ_ITF_SEC_CNT,                  2512,    0,   32;
;FSW_ITF_PDUB_TLM_VC_RCV_NUM_VAL_ITFS,                        2516,    0,   32;
;FSW_ITF_PDUB_TLM_VC_RCV_NUM_PKTS_RCVD,                       2520,    0,   32;
;FSW_ITF_PDUB_TLM_VC_RCV_NUM_STALE_SEQ_CNT,                   2524,    0,   16;
;FSW_ITF_PDUB_TLM_VC_RCV_DISCONTIN_SEQ_CNT,                   2526,    0,   16;
;FSW_ITF_PDUB_TLM_VC_RCV_NUM_ITFS_DISCARDED,                  2528,    0,   16;
;FSW_ITF_PDUB_TLM_VC_RCV_NUM_ITF_PKT_ERRS,                    2530,    0,   16;
;FSW_ITF_PDUB_TLM_VC_RCV_NUM_ITF_DATA_ID_ERRS,                2532,    0,   16;
;FSW_MM_HK_DWELL_PKT_ENA_BOOL,                                2534,    0,    8;
;FSW_MM_HK_NV_MEM_HK_DEV1_WRITE_ENA_DIS,                      2535,    0,    1;
;FSW_MM_HK_NV_MEM_HK_DEV2_WRITE_ENA_DIS,                      2536,    7,    1;
;FSW_MM_HK_NV_MEM_HK_BANK_1_WRITE_ENA_DIS,                    2536,    6,    1;
;FSW_MM_HK_NV_MEM_HK_BANK_2_WRITE_ENA_DIS,                    2536,    5,    1;
;FSW_MM_HK_NV_MEM_HK_RECENT_WRITE_ERR_CNT_TRANSIENT,          2536,    4,   32;
;FSW_MM_HK_NV_MEM_HK_LAST_WRITE_ERR_ADDR_TRANSIENT,           2540,    4,   32;
;FSW_MM_HK_NV_MEM_HK_NVM_SLEEP_ENA_DIS,                       2544,    4,    1;
;FSW_MM_HK_NV_MEM_RECENT_WRITE_ERR_CNT,                       2544,    3,   32;
;FSW_MM_HK_NV_MEM_LAST_WRITE_ERR_ADDR,                        2548,    3,   32;
;FSW_MM_HK_EDAC_RESET_CNTRL,                                  2552,    3,   32;
;FSW_MOH_HK_OBJ_SRC_DURING_INIT,                              2556,    3,    8;
;FSW_MOH_HK_NV_MEM_COPY_BOOTED_FROM,                          2557,    3,    8;
;FSW_MOH_HK_NVM_COPY_BOOTED_FROM,                             2557,    3,    8;
;FSW_MOH_HK_NUM_REGISTERED_OBJ_TYPES,                         2558,    3,   32;
;FSW_MOH_HK_NUM_OBJ_REGISTRATIONS,                            2562,    3,   32;
;FSW_MOH_HK_COPY_DUMP_OPER_CMD_CODE,                          2566,    3,   32;
;FSW_MOH_HK_COPY_DUMP_OBJ_TYPE,                               2570,    3,   32;
;FSW_MOH_HK_COPY_DUMP_FIRST_OBJ_ID,                           2574,    3,   32;
;FSW_MOH_HK_COPY_DUMP_CURR_OBJ_ID,                            2578,    3,   32;
;FSW_MOH_HK_COPY_DUMP_LAST_OBJ_ID,                            2582,    3,   32;
;FSW_MOH_HK_COPY_DUMP_SRC_PHYS_LOC,                           2586,    3,   32;
;FSW_MOH_HK_COPY_DUMP_DEST_PHYS_LOC,                          2590,    3,   32;
;FSW_MOH_HK_COPY_DUMP_DELAY_SECS,                             2594,    3,   32;
;FSW_MOH_HK_COPY_DUMP_DELAY_MINOR_FRAMES,                     2598,    3,   32;
;FSW_MOH_HK_COPY_DUMP_OPER_OWNER,                             2602,    3,   32;
;FSW_MOH_HK_UB_OBJ_TYPE,                                      2606,    3,   32;
;FSW_MOH_HK_UB_NUM_OBJS,                                      2610,    3,   32;
;FSW_MOH_HK_UB_UNALLOCATED_SIZE,                              2614,    3,   32;
;FSW_MOH_HK_UB_NEWEST_OBJ_ID,                                 2618,    3,   32;
;FSW_MOH_HK_UB_NEWEST_WRITE_MET,                              2622,    3,   32;
;FSW_MOH_HK_LOAD_BUFF_TOTAL_PKTS,                             2626,    3,   32;
;FSW_MOH_HK_LOAD_BUFF_PKTS_SO_FAR,                            2630,    3,   32;
;FSW_MOH_HK_LOAD_BUFF_BYTES_SO_FAR,                           2634,    3,   32;
;FSW_MOH_HK_LOAD_BUFF_OBJ_ID,                                 2638,    3,   32;
;FSW_MOH_HK_LOAD_BUFF_PHYS_LOC,                               2642,    3,   32;
;FSW_MOH_HK_LOAD_BUFF_OBJ_TYPE,                               2646,    3,   32;
;FSW_MOH_HK_TOTAL_NUM_ERRS,                                   2650,    3,   32;
;FSW_SPP_HK_ONVM_MET_SEC_OF_RECENT_PROMOTION0,                2654,    3,   32;
;FSW_SPP_HK_ONVM_MET_SEC_OF_RECENT_PROMOTION1,                2658,    3,   32;
;FSW_SPP_HK_ONVM_MET_SEC_OF_RECENT_PROMOTION2,                2662,    3,   32;
;FSW_SPP_HK_LOGICAL_ID0,                                      2666,    3,   32;
;FSW_SPP_HK_ENTER_MET0,                                       2670,    3,   32;
;FSW_SPP_HK_SECS_IN_MODE0,                                    2674,    3,   32;
;FSW_SPP_HK_EXIT_MET0,                                        2678,    3,   32;
;FSW_SPP_HK_LOGICAL_ID1,                                      2682,    3,   32;
;FSW_SPP_HK_ENTER_MET1,                                       2686,    3,   32;
;FSW_SPP_HK_SECS_IN_MODE1,                                    2690,    3,   32;
;FSW_SPP_HK_EXIT_MET1,                                        2694,    3,   32;
;FSW_SPP_HK_LOGICAL_ID2,                                      2698,    3,   32;
;FSW_SPP_HK_SCIF_BUF_RCVD_STKY_TT,                            2702,    3,    1;
;FSW_SPP_HK_PPSVP_SENT_STKY_TT,                               2702,    2,    1;
;FSW_SPP_HK_MNA_COUNT,                                        2702,    1,   32;
;FSW_SPP_HK_MNA_READ_WRITE0,                                  2706,    1,   32;
;FSW_SPP_HK_MNA_ADDRESS0,                                     2710,    1,   32;
;FSW_SPP_HK_MNA_READ_WRITE1,                                  2714,    1,   32;
;FSW_SPP_HK_MNA_ADDRESS1,                                     2718,    1,   32;
;FSW_PB_HK_AUTO_PB_LIST_LAST_BUILT,                           2722,    1,   32;
;FSW_PB_HK_AUTO_PB_LIST_NEXT_BUILD,                           2726,    1,   32;
;FSW_PB_HK_PLAYBACK_STATE,                                    2730,    1,    1;
;FSW_PB_HK_AUTO_PB_STATE,                                     2730,    0,    1;
;FSW_PB_HK_AUTO_DELETE,                                       2731,    7,    1;
;FSW_PB_HK_FILES_AVAIL,                                       2731,    6,    1;
;FSW_PB_HK_FILES_AVAILABLE,                                   2731,    6,    1;
;FSW_PB_HK_NEW_HP_FILE_AVAIL,                                 2731,    5,    1;
;FSW_PB_HK_NEW_HP_FILE_AVAILABLE,                             2731,    5,    1;
;FSW_PB_HK_LOW_PRIORITY_CMD_ACTIVE,                           2731,    4,    1;
;FSW_PB_HK_LOW_PRI_CMD_ACTIVE,                                2731,    4,    1;
;FSW_PB_HK_AUTO_PB_BUILD_IN_PROGRESS,                         2731,    3,    1;
;FSW_PB_HK_AUTO_PB_FS_ID,                                     2731,    2,    1;
;FSW_PB_HK_PB_LIST_LOAD_INDEX,                                2731,    1,   16;
;FSW_PB_HK_PB_LIST_REMAINING_CNT,                             2733,    1,   16;
;FSW_PB_HK_PB_LIST_REBUILD_INTERVAL,                          2735,    1,   16;
;FSW_PB_HK_AUTO_PB_MOVE_FAIL_CNT,                             2737,    1,   16;
;FSW_PB_HK_AUTO_PB_MOVE_CNT,                                  2739,    1,   16;
;FSW_PB_HK_AUTO_PB_CFDP_SUCCESS_CNT,                          2741,    1,   16;
;FSW_PB_HK_AUTO_PB_CFDP_FAIL_CNT,                             2743,    1,   16;
;FSW_PB_HK_CMD_REJ_LP_CFDP_MODE_SET_TT,                       2745,    1,    1;
;FSW_PB_HK_CMD_REJ_LP_CFDP_UNACK_CANCEL_TT,                   2745,    0,    1;
;FSW_PB_HK_CMD_REJ_LP_CFDP_XACTN_CANCEL_TT,                   2746,    7,    1;
;FSW_PB_HK_CMD_REJ_LP_FILE_START_TT,                          2746,    6,    1;
;FSW_PB_HK_CMD_REJ_LP_TT,                                     2746,    5,    1;
;FSW_PB_HK_LP_CMD_PUT_FAIL_CNT,                               2746,    4,   16;
;FSW_PB_HK_LP_CMDS_RCVD_CNT,                                  2748,    4,   16;
;FSW_PB_HK_LP_CMDS_UNKNOWN_CNT,                               2750,    4,   16;
;FSW_PB_HK_LP_CMDS_FAIL_CNT,                                  2752,    4,   16;
;FSW_PB_HK_LP_CMDS_SUCCESS_CNT,                               2754,    4,   16;
;FSW_REC_HK_LOW_PRIORITY_TASK_HTB,                            2756,    4,    1;
;FSW_REC_HK_CLOSE_ALL_IN_PROGRESS,                            2756,    3,    1;
;FSW_REC_HK_CLOSE_ALL_SUCCESS,                                2756,    2,    1;
;FSW_REC_HK_RECORD_ENA_RAM,                                   2756,    1,    1;
;FSW_REC_HK_RECORD_ENA_SSR,                                   2756,    0,    1;
;FSW_REC_HK_PKT_RCVD_CNT,                                     2757,    7,   16;
;FSW_REC_HK_PKT_ACCEPTED_CNT,                                 2759,    7,   16;
;FSW_REC_HK_PKT_RECORDED_CNT,                                 2761,    7,   16;
;FSW_REC_HK_PKT_RECORDED_TOTAL,                               2763,    7,   32;
;FSW_REC_HK_ALLOC_ERR_05_CDH_SSR_HK_TT,                       2767,    7,    1;
;FSW_REC_HK_ALLOC_ERR_04_SWEAP_TT,                            2767,    6,    1;
;FSW_REC_HK_ALLOC_ERR_03_FIELDS_TT,                           2767,    5,    1;
;FSW_REC_HK_ALLOC_ERR_02_WISPR_TT,                            2767,    4,    1;
;FSW_REC_HK_ALLOC_ERR_01_EPIHI_TT,                            2767,    3,    1;
;FSW_REC_HK_ALLOC_ERR_00_EPILO_TT,                            2767,    2,    1;
;FSW_REC_HK_CMD_REJ_LP_SET_ALLOC_CURR_USAGE_TT,               2767,    1,    1;
;FSW_REC_HK_CMD_REJ_LP_PFT_APID_MOD_MULTIPLE_TT,              2767,    0,    1;
;FSW_REC_HK_CMD_REJ_LP_PFT_APID_MOD_SINGLE_TT,                2768,    7,    1;
;FSW_REC_HK_CMD_REJ_LP_FILE_CLOSE_ALL_TT,                     2768,    6,    1;
;FSW_REC_HK_CMD_REJ_LP_FILE_CLOSE_TT,                         2768,    5,    1;
;FSW_REC_HK_CMD_REJ_LP_FILE_OPEN_TT,                          2768,    4,    1;
;FSW_REC_HK_CMD_REJ_LP_RECORD_ENA_SEL_TT,                     2768,    3,    1;
;FSW_REC_HK_CMD_REJ_LP_TT,                                    2768,    2,    1;
;FSW_REC_HK_CMD_FIND_FILE_FAIL_TT,                            2768,    1,    1;
;FSW_REC_HK_CMD_MOVE_FILE_FAIL_TT,                            2768,    0,    1;
;FSW_REC_HK_CMD_CLOSE_FILE_FAIL_TT,                           2769,    7,    1;
;FSW_REC_HK_CMD_OPEN_FILE_FAIL_TT,                            2769,    6,    1;
;FSW_REC_HK_AUTO_FIND_FILE_FAIL_TT,                           2769,    5,    1;
;FSW_REC_HK_AUTO_MOVE_FILE_FAIL_TT,                           2769,    4,    1;
;FSW_REC_HK_AUTO_CLOSE_FILE_FAIL_TT,                          2769,    3,    1;
;FSW_REC_HK_AUTO_OPEN_FILE_FAIL_TT,                           2769,    2,    1;
;FSW_REC_HK_LP_CMDS_FAIL_CNT_LSB,                             2769,    1,    8;
;FSW_REC_HK_SSR_FILES_OPEN_CNT,                               2770,    1,    8;
;FSW_REC_HK_BYTES_RECORDED_THIS_SEC,                          2771,    1,   32;
;FSW_REC_HK_BYTES_RECORDED_TOTAL,                             2775,    1,   32;
;FSW_REC_HK_FILE_CMD_OPEN_FAIL_CNT,                           2779,    1,    8;
;FSW_REC_HK_FILE_CMD_CLOSE_FAIL_CNT,                          2780,    1,    8;
;FSW_REC_HK_FILE_CMD_MOVE_FAIL_CNT,                           2781,    1,    8;
;FSW_REC_HK_FILE_CMD_OPEN_SUCCESS_CNT,                        2782,    1,   16;
;FSW_REC_HK_FILE_CMD_CLOSE_SUCCESS_CNT,                       2784,    1,   16;
;FSW_REC_HK_FILE_CMD_MOVE_SUCCESS_CNT,                        2786,    1,   16;
;FSW_REC_HK_FILE_AUTO_OPEN_FAIL_CNT,                          2788,    1,    8;
;FSW_REC_HK_FILE_AUTO_CLOSE_FAIL_CNT,                         2789,    1,    8;
;FSW_REC_HK_FILE_AUTO_MOVE_FAIL_CNT,                          2790,    1,    8;
;FSW_REC_HK_FILE_AUTO_OPEN_SUCCESS_CNT,                       2791,    1,   16;
;FSW_REC_HK_FILE_AUTO_CLOSE_SUCCESS_CNT,                      2793,    1,   16;
;FSW_REC_HK_FILE_AUTO_MOVE_SUCCESS_CNT,                       2795,    1,   16;
;FSW_REC_HK_LP_CMDS_SUCCESS_CNT_LSB,                          2797,    1,    8;
;FSW_REC_HK_PFT_TOTAL_SUBSCRIPTIONS,                          2798,    1,   16;
;FSW_REC_HK_FS_FULL_SSR_PKT_DISCARD_CNT,                      2800,    1,   32;
;FSW_REC_HK_ALLOC_MGMT_ENA_SSR,                               2804,    1,    8;
;FSW_SPP_EPI_LO_SSR_ALLOC_STATUS,                             2805,    1,    8;
;FSW_SPP_EPI_HI_SSR_ALLOC_STATUS,                             2806,    1,    8;
;FSW_SPP_WISPR_SSR_ALLOC_STATUS,                              2807,    1,    8;
;FSW_SPP_FIELDS_SSR_ALLOC_STATUS,                             2808,    1,    8;
;FSW_SPP_SWEAP_SSR_ALLOC_STATUS,                              2809,    1,    8;
;FSW_TO_HK_DEFAULT_TBL_SEL_FRAME_INTERFACE,                   2810,    1,    8;
;FSW_TO_HK_DEFAULT_TBL_SEL_FRM_INTF,                          2810,    1,    8;
;FSW_TO_HK_TBL_SEL_FRAME_INTERFACE,                           2811,    1,    8;
;FSW_TO_HK_TBL_SEL_FRM_INTF,                                  2811,    1,    8;
;FSW_TO_HK_FRAMER_PKT_QUEUE_OVFLW_ERR_TT,                     2812,    1,    1;
;FSW_TO_HK_FRAMER_PKT_Q_OVRFLOW_ERROR_TELLTALE,               2812,    1,    1;
;FSW_TO_HK_FRAMER_HIGH_PRIORITY_PKT_QUEUE_OVFLW_ERR_TT,       2812,    0,    1;
;FSW_TO_HK_FRAMER_HI_PRI_PKT_Q_OVRFLOW_ERROR_TELLTALE,        2812,    0,    1;
;FSW_TO_HK_FRAMER_SHORT_TLM_QUEUE_ERR_TT,                     2813,    7,    1;
;FSW_TO_HK_FRAMER_SHORT_TLM_Q_ERROR_TELLTALE,                 2813,    7,    1;
;FSW_TO_HK_FRAMER_CFDP_FRAME_QUEUE_ERR_TT,                    2813,    6,    1;
;FSW_TO_HK_FRAMER_CFDP_FRAME_Q_ERROR_TELLTALE,                2813,    6,    1;
;FSW_TO_HK_FRAMER_LONG_RT_FRAME_QUEUE_ERROR_TELLTALE,         2813,    5,    1;
;FSW_TO_HK_VC0_FRAME_CNT,                                     2813,    4,   32;
;FSW_TO_HK_VC0_FRM_CNT,                                       2813,    4,   32;
;FSW_TO_HK_VC1_FRAME_CNT,                                     2817,    4,   32;
;FSW_TO_HK_VC1_FRM_CNT,                                       2817,    4,   32;
;FSW_TO_HK_VC2_FRAME_CNT,                                     2821,    4,   32;
;FSW_TO_HK_VC2_FRM_CNT,                                       2821,    4,   32;
;FSW_TO_HK_VC3_FRAME_CNT,                                     2825,    4,   32;
;FSW_TO_HK_VC3_FRM_CNT,                                       2825,    4,   32;
;FSW_TO_HK_VC4_FRAME_CNT,                                     2829,    4,   32;
;FSW_TO_HK_VC4_FRM_CNT,                                       2829,    4,   32;
;FSW_TO_HK_VC5_FRAME_CNT,                                     2833,    4,   32;
;FSW_TO_HK_VC5_FRM_CNT,                                       2833,    4,   32;
;FSW_TO_HK_VC6_FRAME_CNT,                                     2837,    4,   32;
;FSW_TO_HK_VC6_FRM_CNT,                                       2837,    4,   32;
;FSW_TO_HK_VC7_FRAME_CNT,                                     2841,    4,   32;
;FSW_TO_HK_VC7_FRM_CNT,                                       2841,    4,   32;
;FSW_TO_HK_DROPPED_NORM_PKT_CNT,                              2845,    4,   32;
;FSW_TO_HK_DROPPED_HP_PKT_CNT,                                2849,    4,   32;
;FSW_TO_HK_FLUSHED_PKT_CNT,                                   2853,    4,   32;
;FSW_TO_HK_DROPPED_LONG_FRAME_CNT,                            2857,    4,   32;
;FSW_TO_HK_DROPPED_LONG_FRM_CNT,                              2857,    4,   32;
;FSW_TO_HK_DROPPED_SHORT_FRAME_CNT,                           2861,    4,   32;
;FSW_TO_HK_DROPPED_SHORT_FRM_CNT,                             2861,    4,   32;
;FSW_TO_HK_TODRV_SPARE_WORD_1,                                2865,    4,   32;
;FSW_TO_HK_TODRV_DROPPED_FRAME_CNT,                           2869,    4,   32;
;FSW_TO_HK_TODRV_DROPPED_FRM_CNT,                             2869,    4,   32;
;FSW_TTAG_HK_RULE_LOAD_FAIL_CNT,                              2873,    4,   16;
;FSW_TTAG_HK_NUM_RULES_LOADED_CNT,                            2875,    4,   16;
;FSW_TTAG_HK_RULE_SUSPEND_LEVEL_LSB,                          2877,    4,    8;
;FSW_TTAG_HK_TTAG_ENA_MASK0,                                  2878,    4,   32;
;FSW_TTAG_HK_TTAG_ENA_MASK1,                                  2882,    4,   32;
;FSW_TTAG_HK_TTAG_ENA_MASK2,                                  2886,    4,   32;
;FSW_TTAG_HK_TTAG_ENA_MASK3,                                  2890,    4,   32;
;FSW_TTAG_HK_TTAG_ENA_MASK4,                                  2894,    4,   32;
;FSW_TTAG_HK_TTAG_ENA_MASK5,                                  2898,    4,   32;
;FSW_TTAG_HK_TTAG_ENA_MASK6,                                  2902,    4,   32;
;FSW_TTAG_HK_TTAG_ENA_MASK7,                                  2906,    4,   32;
;FSW_TTAG_HK_TTAG_ENA_MASK8,                                  2910,    4,   32;
;FSW_TTAG_HK_TTAG_ENA_MASK9,                                  2914,    4,   32;
;FSW_TTAG_HK_TTAG_ENA_MASK10,                                 2918,    4,   32;
;FSW_TTAG_HK_TTAG_ENA_MASK11,                                 2922,    4,   32;
;FSW_TTAG_HK_TTAG_ENA_MASK12,                                 2926,    4,   32;
;FSW_TTAG_HK_TTAG_ENA_MASK13,                                 2930,    4,   32;
;FSW_TTAG_HK_TTAG_ENA_MASK14,                                 2934,    4,   32;
;FSW_TTAG_HK_TTAG_ENA_MASK15,                                 2938,    4,   32;
;FSW_TTAG_HK_TTAG_ENA_MASK16,                                 2942,    4,   32;
;FSW_TTAG_HK_TTAG_ENA_MASK17,                                 2946,    4,   32;
;FSW_TTAG_HK_TTAG_ENA_MASK18,                                 2950,    4,   32;
;FSW_TTAG_HK_TTAG_ENA_MASK19,                                 2954,    4,   32;
;FSW_TTAG_HK_TTAG_ENA_MASK20,                                 2958,    4,   32;
;FSW_TTAG_HK_TTAG_ENA_MASK21,                                 2962,    4,   32;
;FSW_TTAG_HK_TTAG_ENA_MASK22,                                 2966,    4,   32;
;FSW_TTAG_HK_TTAG_ENA_MASK23,                                 2970,    4,   32;
;FSW_TTAG_HK_TTAG_ENA_MASK24,                                 2974,    4,   32;
;FSW_TTAG_HK_TTAG_ENA_MASK25,                                 2978,    4,   32;
;FSW_TTAG_HK_TTAG_ENA_MASK26,                                 2982,    4,   32;
;FSW_TTAG_HK_TTAG_ENA_MASK27,                                 2986,    4,   32;
;FSW_TTAG_HK_TTAG_ENA_MASK28,                                 2990,    4,   32;
;FSW_TTAG_HK_TTAG_ENA_MASK29,                                 2994,    4,   32;
;FSW_TTAG_HK_TTAG_ENA_MASK30,                                 2998,    4,   32;
;FSW_TTAG_HK_TTAG_ENA_MASK31,                                 3002,    4,   32;
;FSW_XSBC_HK_SYNC_MODE,                                       3006,    4,   32;
;FSW_XSBC_HK_FSP_LOCAL_IGNORED_CNT,                           3010,    4,   32;
;FSW_XSBC_HK_FSP_LOCAL_QUEUED_CNT,                            3014,    4,   32;
;FSW_XSBC_HK_FSP_LOCAL_FWD_CNT,                               3018,    4,   32;
;FSW_XSBC_HK_FSP_REMOTE_IGNORED_CNT,                          3022,    4,   32;
;FSW_XSBC_HK_FSP_REMOTE_MV_CNT,                               3026,    4,   32;
;FSW_XSBC_HK_FSP_REMOTE_RM_CNT,                               3030,    4,   32;
;FSW_XSBC_HK_XFRS_STARTED_CNT,                                3034,    4,   32;
;FSW_XSBC_HK_XFRS_COMPLETED_CNT,                              3038,    4,   32;
;FSW_XSBC_HK_XFRS_FAILED_CNT,                                 3042,    4,   32;
;FSW_SI_HK_REM_MINOR_FRAME_SKIP_CNT0,                         3046,    4,   16;
;FSW_SI_HK_REM_MINOR_FRAME_SKIP_CNT1,                         3048,    4,   16;
;FSW_SI_HK_REM_MINOR_FRAME_SKIP_CNT2,                         3050,    4,   16;
;FSW_SI_HK_REM_MINOR_FRAME_SKIP_CNT3,                         3052,    4,   16;
;FSW_SI_HK_REM_MINOR_FRAME_SKIP_CNT4,                         3054,    4,   16;
;FSW_SI_HK_REM_MINOR_FRAME_SKIP_CNT5,                         3056,    4,   16;
;FSW_SI_HK_REM_MINOR_FRAME_SKIP_CNT6,                         3058,    4,   16;
;FSW_SI_HK_REM_MINOR_FRAME_SKIP_CNT7,                         3060,    4,   16;
;FSW_SI_HK_REM_MINOR_FRAME_SKIP_CNT8,                         3062,    4,   16;
;FSW_SI_HK_REM_MINOR_FRAME_SKIP_CNT9,                         3064,    4,   16;
;FSW_SI_HK_REM_MINOR_FRAME_SKIP_CNT10,                        3066,    4,   16;
;FSW_SI_HK_REM_MINOR_FRAME_SKIP_CNT11,                        3068,    4,   16;
;FSW_SI_HK_REM_MINOR_FRAME_SKIP_CNT12,                        3070,    4,   16;
;FSW_SI_HK_REM_MINOR_FRAME_SKIP_CNT13,                        3072,    4,   16;
;FSW_SI_HK_REM_MINOR_FRAME_SKIP_CNT14,                        3074,    4,   16;
;FSW_SI_HK_REM_MINOR_FRAME_SKIP_CNT15,                        3076,    4,   16;
;FSW_SI_HK_REM_MINOR_FRAME_SKIP_CNT16,                        3078,    4,   16;
;FSW_SI_HK_REM_MINOR_FRAME_SKIP_CNT17,                        3080,    4,   16;
;FSW_SI_HK_REM_MINOR_FRAME_SKIP_CNT18,                        3082,    4,   16;
;FSW_SI_HK_REM_MINOR_FRAME_SKIP_CNT19,                        3084,    4,   16;
;FSW_SI_HK_REM_MINOR_FRAME_SKIP_CNT20,                        3086,    4,   16;
;FSW_SI_HK_REM_MINOR_FRAME_SKIP_CNT21,                        3088,    4,   16;
;FSW_SI_HK_REM_MINOR_FRAME_SKIP_CNT22,                        3090,    4,   16;
;FSW_SI_HK_REM_MINOR_FRAME_SKIP_CNT23,                        3092,    4,   16;
;FSW_SI_HK_REM_MINOR_FRAME_SKIP_CNT24,                        3094,    4,   16;
;FSW_SI_HK_REM_MINOR_FRAME_SKIP_CNT25,                        3096,    4,   16;
;FSW_SI_HK_REM_MINOR_FRAME_SKIP_CNT26,                        3098,    4,   16;
;FSW_SI_HK_REM_MINOR_FRAME_SKIP_CNT27,                        3100,    4,   16;
;FSW_SI_HK_REM_MINOR_FRAME_SKIP_CNT28,                        3102,    4,   16;
;FSW_SI_HK_REM_MINOR_FRAME_SKIP_CNT29,                        3104,    4,   16;
;FSW_SI_HK_REM_MINOR_FRAME_SKIP_CNT30,                        3106,    4,   16;
;FSW_SI_HK_REM_MINOR_FRAME_SKIP_CNT31,                        3108,    4,   16;
;FSW_SI_HK_REM_MINOR_FRAME_SKIP_CNT32,                        3110,    4,   16;
;FSW_SI_HK_REM_MINOR_FRAME_SKIP_CNT33,                        3112,    4,   16;
;FSW_SI_HK_REM_MINOR_FRAME_SKIP_CNT34,                        3114,    4,   16;
;FSW_SI_HK_REM_MINOR_FRAME_SKIP_CNT35,                        3116,    4,   16;
;FSW_SI_HK_REM_MINOR_FRAME_SKIP_CNT36,                        3118,    4,   16;
;FSW_SI_HK_REM_MINOR_FRAME_SKIP_CNT37,                        3120,    4,   16;
;FSW_SI_HK_REM_MINOR_FRAME_SKIP_CNT38,                        3122,    4,   16;
;FSW_SI_HK_REM_MINOR_FRAME_SKIP_CNT39,                        3124,    4,   16;
;FSW_SI_HK_REM_MINOR_FRAME_SKIP_CNT40,                        3126,    4,   16;
;FSW_SI_HK_REM_MINOR_FRAME_SKIP_CNT41,                        3128,    4,   16;
;FSW_SI_HK_REM_MINOR_FRAME_SKIP_CNT42,                        3130,    4,   16;
;FSW_SI_HK_REM_MINOR_FRAME_SKIP_CNT43,                        3132,    4,   16;
;FSW_SI_HK_REM_MINOR_FRAME_SKIP_CNT44,                        3134,    4,   16;
;FSW_SI_HK_REM_MINOR_FRAME_SKIP_CNT45,                        3136,    4,   16;
;FSW_SI_HK_REM_MINOR_FRAME_SKIP_CNT46,                        3138,    4,   16;
;FSW_SI_HK_REM_MINOR_FRAME_SKIP_CNT47,                        3140,    4,   16;
;FSW_SI_HK_REM_MINOR_FRAME_SKIP_CNT48,                        3142,    4,   16;
;FSW_SI_HK_REM_MINOR_FRAME_SKIP_CNT49,                        3144,    4,   16;
;FSW_SI_HK_REM_ARC_RESYNC_REQ_CNT,                            3146,    4,   32;
;FSW_SI_HK_IMU_ATT_MSGS_CNTR,                                 3150,    4,   32;
;FSW_SI_SPW_SPW_PORT_STATUS0,                                 3154,    4,   32;
;FSW_SI_SPW_SPW_PORT_STATUS1,                                 3158,    4,   32;
;FSW_SI_SPW_SPW_PORT_STATUS2,                                 3162,    4,   32;
;FSW_SI_SPW_SPW_PORT_STATUS3,                                 3166,    4,   32;
;FSW_SI_SPW_GRSPW_LINK_STATE0,                                3170,    4,   32;
;FSW_SI_SPW_GRSPW_LINK_STATE1,                                3174,    4,   32;
;FSW_SI_SPW_GRSPW_LINK_STATE2,                                3178,    4,   32;
;FSW_SI_SPW_GRSPW_LINK_STATE3,                                3182,    4,   32;
;FSW_SI_SPW_TOTAL_RX0,                                        3186,    4,   32;
;FSW_SI_SPW_TOTAL_RX1,                                        3190,    4,   32;
;FSW_SI_SPW_TOTAL_RX2,                                        3194,    4,   32;
;FSW_SI_SPW_TOTAL_RX3,                                        3198,    4,   32;
;FSW_SI_SPW_TOTAL_XMT0,                                       3202,    4,   32;
;FSW_SI_SPW_TOTAL_XMT1,                                       3206,    4,   32;
;FSW_SI_SPW_TOTAL_XMT2,                                       3210,    4,   32;
;FSW_SI_SPW_TOTAL_XMT3,                                       3214,    4,   32;
;FSW_SI_SPW_ERR_RX_TRUNC0,                                    3218,    4,   32;
;FSW_SI_SPW_ERR_RX_TRUNC1,                                    3222,    4,   32;
;FSW_SI_SPW_ERR_RX_TRUNC2,                                    3226,    4,   32;
;FSW_SI_SPW_ERR_RX_TRUNC3,                                    3230,    4,   32;
;FSW_SI_SPW_ERR_RX_EEP0,                                      3234,    4,   32;
;FSW_SI_SPW_ERR_RX_EEP1,                                      3238,    4,   32;
;FSW_SI_SPW_ERR_RX_EEP2,                                      3242,    4,   32;
;FSW_SI_SPW_ERR_RX_EEP3,                                      3246,    4,   32;
;FSW_SI_SPW_RMAP_CANCELS0,                                    3250,    4,   32;
;FSW_SI_SPW_RMAP_CANCELS1,                                    3254,    4,   32;
;FSW_SI_SPW_RMAP_CANCELS2,                                    3258,    4,   32;
;FSW_SI_SPW_RMAP_CANCELS3,                                    3262,    4,   32;
;FSW_SI_SPW_RMAP_RX_HEAD_CRC_ERR0,                            3266,    4,   32;
;FSW_SI_SPW_RMAP_RX_DATA_CRC_ERR0,                            3270,    4,   32;
;FSW_SI_SPW_RMAP_RX_HEAD_CRC_ERR1,                            3274,    4,   32;
;FSW_SI_SPW_RMAP_RX_DATA_CRC_ERR1,                            3278,    4,   32;
;FSW_SI_SPW_RMAP_RX_HEAD_CRC_ERR2,                            3282,    4,   32;
;FSW_SI_SPW_RMAP_RX_DATA_CRC_ERR2,                            3286,    4,   32;
;FSW_SI_SPW_RMAP_RX_HEAD_CRC_ERR3,                            3290,    4,   32;
;FSW_SI_SPW_RMAP_RX_DATA_CRC_ERR3,                            3294,    4,   32;
;FSW_CFDP_HK_CMD_EXEC_CNT,                                    3298,    4,   16;
;FSW_CFDP_HK_CMD_FAIL_CNT,                                    3300,    4,   16;
;FSW_CFDP_HK_RX_OPEN_TRANSACTIONS,                            3302,    4,   16;
;FSW_CFDP_HK_RX_CLOSED_TRANSACTIONS,                          3304,    4,   16;
;FSW_CFDP_HK_RX_FAILED_TRANSACTIONS,                          3306,    4,   16;
;FSW_CFDP_HK_TX_OPEN_TRANSACTIONS_0,                          3308,    4,   16;
;FSW_CFDP_HK_TX_OPEN_TRANSACTIONS_1,                          3310,    4,   16;
;FSW_CFDP_HK_TX_CLOSED_TRANSACTIONS,                          3312,    4,   16;
;FSW_CFDP_HK_TX_FAILED_TRANSACTIONS,                          3314,    4,   16;
;FSW_CFE_ES_ES_HK_CMD_CNTR,                                   3316,    4,    8;
;SC_FSW_CFE_ES_ES_HK_CMD_CNTR,                                3316,    4,    8;
;FSW_CFE_ES_ES_HK_ERR_CNTR,                                   3317,    4,    8;
;SC_FSW_CFE_ES_ES_HK_ERR_CNTR,                                3317,    4,    8;
;FSW_CFE_ES_ES_HK_SYS_LOG_MODE,                               3318,    4,    1;
;FSW_CFE_ES_ES_HK_MAX_CPU_RESETS,                             3318,    3,    8;
;SC_FSW_CFE_ES_ES_HK_MAX_CPU_RESETS,                          3318,    3,    8;
;FSW_CFE_EVS_EVS_HK_CMD_CNTR,                                 3319,    3,    8;
;SC_FSW_CFE_EVS_EVS_HK_CMD_CNTR,                              3319,    3,    8;
;FSW_CFE_EVS_EVS_HK_ERR_CNTR,                                 3320,    3,    8;
;SC_FSW_CFE_EVS_EVS_HK_ERR_CNTR,                              3320,    3,    8;
;FSW_CFE_EVS_EVS_HK_MSG_FMT_MODE,                             3321,    3,    8;
;SC_FSW_CFE_EVS_EVS_HK_MSG_FMT_MODE,                          3321,    3,    8;
;FSW_CFE_EVS_EVS_HK_MSG_TRUNC_CNTR,                           3322,    3,    8;
;FSW_CFE_EVS_EVS_HK_UNREG_APP_CNTR,                           3323,    3,    8;
;FSW_CFE_EVS_EVS_HK_OUTPUT_PORT,                              3324,    3,    8;
;SC_FSW_CFE_EVS_EVS_HK_OUTPUT_PORT,                           3324,    3,    8;
;FSW_CFE_EVS_EVS_HK_LOG_FULL_FLAG,                            3325,    3,    8;
;SC_FSW_CFE_EVS_EVS_HK_LOG_FULL_FLAG,                         3325,    3,    8;
;FSW_CFE_EVS_EVS_HK_LOG_MODE,                                 3326,    3,    8;
;SC_FSW_CFE_EVS_EVS_HK_LOG_MODE,                              3326,    3,    8;
;FSW_CFE_EVS_EVS_HK_MSG_SEND_CNTR,                            3327,    3,   16;
;SC_FSW_CFE_EVS_EVS_HK_MSG_SEND_CNTR,                         3327,    3,   16;
;FSW_CFE_EVS_EVS_HK_LOG_OVFLW_CNTR,                           3329,    3,   16;
;SC_FSW_CFE_EVS_EVS_HK_LOG_OVFLW_CNTR,                        3329,    3,   16;
;FSW_CFE_SB_SB_HK_CMD_CNTR,                                   3331,    3,    8;
;SC_FSW_CFE_SB_SB_HK_CMD_CNTR,                                3331,    3,    8;
;FSW_CFE_SB_SB_HK_ERR_CNTR,                                   3332,    3,    8;
;SC_FSW_CFE_SB_SB_HK_ERR_CNTR,                                3332,    3,    8;
;FSW_CFE_SB_SB_HK_NO_SUBSCRIBERS_CNT,                         3333,    3,    8;
;SC_FSW_CFE_SB_SB_HK_NO_SUBSCRIBERS_CNT,                      3333,    3,    8;
;FSW_CFE_SB_SB_HK_MSG_SEND_ERR_CNT,                           3334,    3,    8;
;FSW_CFE_SB_SB_HK_MSG_SND_ERR_CNT,                            3334,    3,    8;
;FSW_CFE_SB_SB_HK_MSG_RCV_ERR_CNT,                            3335,    3,    8;
;SC_FSW_CFE_SB_SB_HK_MSG_RCV_ERR_CNT,                         3335,    3,    8;
;FSW_CFE_SB_SB_HK_INT_ERR_CNT,                                3336,    3,    8;
;SC_FSW_CFE_SB_SB_HK_INT_ERR_CNT,                             3336,    3,    8;
;FSW_CFE_SB_SB_HK_CREATE_PIPE_ERR_CNT,                        3337,    3,    8;
;SC_FSW_CFE_SB_SB_HK_CREATE_PIPE_ERR_CNT,                     3337,    3,    8;
;FSW_CFE_SB_SB_HK_SUBSCRIBE_ERR_CNT,                          3338,    3,    8;
;SC_FSW_CFE_SB_SB_HK_SUBSCRIBE_ERR_CNT,                       3338,    3,    8;
;FSW_CFE_SB_SB_HK_DUPLICATE_SUBSCRIPTIONS_CNT,                3339,    3,    8;
;SC_FSW_CFE_SB_SB_HK_DUPLICATE_SUBSCRIPTIONS_CNT,             3339,    3,    8;
;FSW_CFE_SB_SB_HK_PIPE_OVFLW_ERR_CNT,                         3340,    3,   16;
;SC_FSW_CFE_SB_SB_HK_PIPE_OVFLW_ERR_CNT,                      3340,    3,   16;
;FSW_CFE_SB_SB_HK_MSG_ID_TO_PIPE_ERR_CNT,                     3342,    3,   16;
;SC_FSW_CFE_SB_SB_HK_MSG_ID_TO_PIPE_ERR_CNT,                  3342,    3,   16;
;FSW_CFE_TIME_TIME_HK_CMD_CNTR,                               3344,    3,    8;
;FSW_CFE_TIME_TIME_HK_ERR_CNTR,                               3345,    3,    8;
;FSW_CFE_TIME_TIME_HK_CLOCK_STATE_FLAGS,                      3346,    3,   16;
;FSW_CFE_TIME_TIME_HK_CLOCK_STATE_API,                        3348,    3,   16;
;HS_FSW_SCH_HK_UP_TIME,                                       3350,    3,   32;
;HS_FSW_SCH_HK_SCH_MET_DISCONTINUITY_TT,                      3354,    3,    1;
;HS_FSW_CPU_HK_IDLER_TASK_CYCLES,                             3354,    2,   32;
;HS_FSW_CPU_HK_DURATION_OF_IDLER_TASK_SAMPLE,                 3358,    2,   32;
;HS_FSW_CPU_HK_CPU_METRIC_COLLECTION_MODE,                    3362,    2,   32;
;HS_FSW_CPU_HK_POR_RESET,                                     3366,    2,    1;
;HS_FSW_CPU_HK_MC_RESET,                                      3366,    1,    1;
;HS_FSW_CPU_HK_SW_RESET,                                      3366,    0,    1;
;HS_FSW_CPU_HK_WDOG_RESET,                                    3367,    7,    1;
;HS_FSW_CPU_HK_WDT_RESET,                                     3367,    7,    1;
;HS_FSW_CPU_HK_FLASH_STATUS,                                  3367,    6,    1;
;HS_FSW_CPU_HK_SOFTWARE_TIMER_STATUS,                         3367,    5,    1;
;HS_FSW_CPU_HK_FLASH_PWR_STATUS,                              3367,    4,    1;
;HS_FSW_CPU_HK_SMF,                                           3367,    3,    1;
;HS_FSW_CPU_HK_IMAGE_2_WRITE_ENA,                             3367,    2,    1;
;HS_FSW_CPU_HK_IMAGE_2_WRITE_ENABLE,                          3367,    2,    1;
;HS_FSW_CPU_HK_IMAGE_1_WRITE_ENA,                             3367,    1,    1;
;HS_FSW_CPU_HK_IMAGE_1_WRITE_ENABLE,                          3367,    1,    1;
;HS_FSW_CPU_HK_MC_C_IMAGE_SEL,                                3367,    0,    1;
;HS_FSW_CPU_HK_MC_C_RESET_DCRT,                               3368,    7,    1;
;HS_FSW_CPU_HK_MC_C_RESET_DISCRT,                             3368,    7,    1;
;HS_FSW_CPU_HK_MC_B_IMAGE_SEL,                                3368,    6,    1;
;HS_FSW_CPU_HK_MC_B_RESET_DCRT,                               3368,    5,    1;
;HS_FSW_CPU_HK_MC_B_RESET_DISCRT,                             3368,    5,    1;
;HS_FSW_CPU_HK_MC_A_IMAGE_SEL,                                3368,    4,    1;
;HS_FSW_CPU_HK_MC_A_RESET_DCRT,                               3368,    3,    1;
;HS_FSW_CPU_HK_MC_A_RESET_DISCRT,                             3368,    3,    1;
;HS_FSW_CPU_HK_SBC_APP_IMAGE_BOOTED,                          3368,    2,    2;
;HS_FSW_CPU_HK_SECONDARY_CHECKSUM_FAIL,                       3368,    0,    1;
;HS_FSW_CPU_HK_PRIMARY_CHECKSUM_FAIL,                         3369,    7,    1;
;HS_FSW_CPU_HK_SBC_APP_IMAGE_VOTED,                           3369,    6,    2;
;HS_FSW_CPU_HK_BRKWIRE0,                                      3369,    4,    1;
;HS_FSW_CPU_HK_BRKWIRE1,                                      3369,    3,    1;
;HS_FSW_CPU_HK_WATCHDOG_EN_DIS,                               3369,    2,    1;
;HS_FSW_CPU_HK_CDS_POR_RESET,                                 3369,    1,    1;
;HS_FSW_CPU_HK_CDS_MC_RESET,                                  3369,    0,    1;
;HS_FSW_CPU_HK_CDS_SW_RESET,                                  3370,    7,    1;
;HS_FSW_CPU_HK_CDS_WDOG_RESET,                                3370,    6,    1;
;HS_FSW_CPU_HK_CDS_FLASH_STATUS,                              3370,    5,    1;
;HS_FSW_CPU_HK_CDS_SW_TIMER_STATUS,                           3370,    4,    1;
;HS_FSW_CPU_HK_CDS_FLASH_PWR_STATUS,                          3370,    3,    1;
;HS_FSW_CPU_HK_CDS_SMF,                                       3370,    2,    1;
;HS_FSW_CPU_HK_CDS_IMAGE_2_WRITE_ENA,                         3370,    1,    1;
;HS_FSW_CPU_HK_CDS_IMAGE_1_WRITE_ENA,                         3370,    0,    1;
;HS_FSW_CPU_HK_CDS_MC_C_IMAGE_SEL,                            3371,    7,    1;
;HS_FSW_CPU_HK_CDS_MC_C_RESET_DCRT,                           3371,    6,    1;
;HS_FSW_CPU_HK_CDS_MC_B_IMAGE_SEL,                            3371,    5,    1;
;HS_FSW_CPU_HK_CDS_MC_B_RESET_DCRT,                           3371,    4,    1;
;HS_FSW_CPU_HK_CDS_MC_A_IMAGE_SEL,                            3371,    3,    1;
;HS_FSW_CPU_HK_CDS_MC_A_RESET_DCRT,                           3371,    2,    1;
;HS_FSW_CPU_HK_CDS_SBC_APP_IMAGE_BOOTED,                      3371,    1,    2;
;HS_FSW_CPU_HK_CDS_SEC_CKSM_FAIL,                             3372,    7,    1;
;HS_FSW_CPU_HK_CDS_PRIMARY_CKSM_FAIL,                         3372,    6,    1;
;HS_FSW_CPU_HK_CDS_SBC_APP_IMAGE_VOTED,                       3372,    5,    2;
;HS_FSW_CPU_HK_CDS_BRKWIRE0,                                  3372,    3,    1;
;HS_FSW_CPU_HK_CDS_BRKWIRE1,                                  3372,    2,    1;
;HS_FSW_CPU_HK_CDS_WDOG_ENA_DIS,                              3372,    1,    1;
;HS_FSW_CPU_HK_CDS_CPU_APP_INIT_CNT,                          3372,    0,   32;
;HS_FSW_CPU_HK_CDS_CPU_APP_INIT_COUNT,                        3372,    0,   32;
;HS_FSW_CPU_HK_CDS_HEALTH_MON_RESET_BOOL,                     3376,    0,   32;
;HS_FSW_CPU_HK_CDS_RESET_MODE,                                3380,    0,   32;
;HS_FSW_CPU_HK_CDS_MET_SECS,                                  3384,    0,   32;
;HS_FSW_CPU_HK_CDS_MET_SECONDS,                               3384,    0,   32;
;HS_FSW_CPU_HK_CDS_HM_RESET_CODE,                             3388,    0,   32;
;HS_FSW_CPU_HK_CDS_TASK_INFO_VAL_BOOL,                        3392,    0,   32;
;HS_FSW_CPU_HK_CDS_TASK_INFO_VALID_BOOL,                      3392,    0,   32;
;HS_FSW_AUT_HK_RULES_LOAD_NV_MEM_CNT,                         3396,    0,   16;
;HS_FSW_AUT_HK_CT_LOAD_NVM_CNT,                               3398,    0,   16;
;HS_FSW_AUT_HK_SV_LOAD_NVM_CNT,                               3400,    0,   16;
;HS_FSW_AUT_HK_RULES_LOAD_RAM_CNT,                            3402,    0,   16;
;HS_FSW_AUT_HK_CT_LOAD_RAM_CNT,                               3404,    0,   16;
;HS_FSW_AUT_HK_SV_LOAD_RAM_CNT,                               3406,    0,   16;
;HS_FSW_FI_HK_CDH_FILE_CNT,                                   3408,    0,   16;
;HS_FSW_FI_HK_CDH_STATE,                                      3410,    0,   16;
;HS_FSW_FI_HK_CDH_EXEC_CMDS,                                  3412,    0,   16;
;HS_FSW_FI_HK_CDH_FAILED_CMDS,                                3414,    0,   16;
;HS_FSW_FI_HK_CDH_PROCESSING_FILE,                            3416,    0,   16;
;HS_FSW_FI_HK_CDH_DELAY,                                      3418,    0,   32;
;HS_FSW_FI_HK_CDH_DELAY_CNT,                                  3422,    0,   32;
;HS_FSW_FI_HK_AUTO_DELETE_STATE,                              3426,    0,    8;
;HS_FSW_FM_HK_LONG_DURATION_CMD_ACTIVE,                       3427,    0,    1;
;HS_FSW_FM_HK_SHORT_DURATION_CMD_ACTIVE,                      3428,    7,    1;
;HS_FSW_FM_HK_LOW_PRIORITY_CMD_ACTIVE,                        3428,    6,    1;
;HS_FSW_FM_HK_FS_ACCESS_RAM,                                  3428,    5,    1;
;HS_FSW_FM_HK_LP_CMD_PUT_FAIL_CNT,                            3428,    4,   16;
;HS_FSW_FM_HK_LP_CMDS_RCVD_CNT,                               3430,    4,   16;
;HS_FSW_FM_HK_LP_CMDS_FAIL_CNT,                               3432,    4,   16;
;HS_FSW_FM_HK_LP_CMDS_SUCCESS_CNT,                            3434,    4,   16;
;HS_FSW_FM_HK_CMD_FS_CREATE_ATTEMPT_TT,                       3436,    4,    1;
;HS_FSW_FM_HK_CMD_REJ_LP_FS_FILE_SYS_OPER_TT,                 3436,    3,    1;
;HS_FSW_FM_HK_CMD_REJ_LP_SSR_BBT_POKE_TT,                     3436,    2,    1;
;HS_FSW_FM_HK_CMD_REJ_LP_SSR_BBT_COPY_TT,                     3436,    1,    1;
;HS_FSW_FM_HK_CMD_REJ_LP_FS_DISMOUNT_TT,                      3436,    0,    1;
;HS_FSW_FM_HK_CMD_REJ_LP_FS_GARBAGE_COLLECT_TT,               3437,    7,    1;
;HS_FSW_FM_HK_CMD_REJ_LP_FS_CREATE_NEW_TT,                    3437,    6,    1;
;HS_FSW_FM_HK_CMD_REJ_LP_FS_DIR_LIST_TT,                      3437,    5,    1;
;HS_FSW_FM_HK_CMD_REJ_LP_SSR_DESTR_DIAG_TT,                   3437,    4,    1;
;HS_FSW_FM_HK_CMD_REJ_LP_SSR_READ_MFGR_BAD_BLOCK_MKR_TT,      3437,    3,    1;
;HS_FSW_FM_HK_CMD_REJ_LP_SSR_FLASH_ERASE_TT,                  3437,    2,    1;
;HS_FSW_FM_HK_CMD_REJ_LP_FS_MOUNT_TT,                         3437,    1,    1;
;HS_FSW_FM_HK_CMD_REJ_LP_TT,                                  3437,    0,    1;
;HS_FSW_FM_HK_FLASH_PWR,                                      3438,    7,    1;
;HS_FSW_FM_HK_DIAG_ACTIVE,                                    3438,    6,    1;
;HS_FSW_FM_HK_DIAG_RSLT,                                      3438,    5,    1;
;HS_FSW_FM_HK_FS_NUM_USED_OBJECTS,                            3438,    4,   32;
;HS_FSW_FM_HK_FS_NUM_UNRECOVERED_WRITE_FAILURES,              3442,    4,   32;
;HS_FSW_FM_HK_FS_CLUSTERS_FREE_SSR,                           3446,    4,   32;
;HS_FSW_FM_HK_FS_CLUSTERS_FREE_RAM,                           3450,    4,   32;
;HS_FSW_FM_HK_FS_ALMOST_FULL_SSR,                             3454,    4,    1;
;HS_FSW_FM_HK_FS_ALMOST_FULL_RAM,                             3454,    3,    1;
;HS_FSW_FM_HK_FS_REG_WITH_OPER_SYS,                           3454,    2,    1;
;HS_FSW_FM_HK_FS_MOUNT_PT_CREATED,                            3454,    1,    1;
;HS_FSW_FM_HK_FS_DEV_INITIALIZED,                             3454,    0,    1;
;HS_FSW_FM_HK_BBT_LOADED,                                     3455,    7,    1;
;HS_FSW_FM_HK_FOUND_EXISTING_DIR,                             3455,    6,    1;
;HS_FSW_FM_HK_SETUP_DIRS_SUCCESS,                             3455,    5,    1;
;HS_FSW_FM_HK_FS_CREATE_SUCCESS,                              3455,    4,    1;
;HS_FSW_FM_HK_DIR_CREATE_STATUS,                              3455,    3,    5;
;HS_FSW_FM_HK_FS_SSR_VOLUME_MOUNTED,                          3456,    6,    1;
;HS_FSW_FM_HK_FS_RAM_VOLUME_MOUNTED,                          3456,    5,    1;
;HS_FSW_FM_HK_RAM_FOUND_EXISTING_DIR,                         3456,    4,    1;
;HS_FSW_FM_HK_RAM_DIR_CREATE_STATUS,                          3456,    3,    5;
;HS_FSW_FM_HK_FS_DIAG_RSLT,                                   3457,    6,    1;
;HS_FSW_FM_HK_GARB_CLXN_BLOCK_COLLECTED_CNT,                  3457,    5,   32;
;HS_FSW_FM_HK_FS_NUM_ERASED_BLOCKS,                           3461,    5,   32;
;HS_FSW_FM_HK_FS_CUR_ALLOCATION_BLOCK,                        3465,    5,   32;
;HS_FSW_FM_HK_FS_NUM_FREE_TNODES,                             3469,    5,   32;
;HS_FSW_FM_HK_FS_NUM_FREE_OBJECTS,                            3473,    5,   32;
;HS_FSW_FM_HK_FS_NUM_FREE_CHUNKS,                             3477,    5,   32;
;HS_FSW_FM_HK_FS_NUM_BLOCK_ERASURES,                          3481,    5,   32;
;HS_FSW_FM_HK_FS_NUM_GC_COPIES,                               3485,    5,   32;
;HS_FSW_FM_HK_FS_NUM_GARBAGE_COLLECTIONS,                     3489,    5,   32;
;HS_FSW_FM_HK_FS_NUM_DELETIONS,                               3493,    5,   32;
;HS_FSW_FM_HK_SSR_REG_STATE,                                  3497,    5,    1;
;HS_FSW_FM_HK_SSR_SDRAM_STATE,                                3497,    4,    1;
;HS_FSW_FM_HK_SSR_FS_FS_STATE,                                3497,    3,    1;
;HS_FSW_FM_HK_SSR_FLASH_RDY_STATUS,                           3497,    2,   16;
;HS_FSW_FM_HK_SSR_LAST_READ_PAGE,                             3499,    2,   32;
;HS_FSW_FM_HK_SSR_LAST_WRITE_PAGE,                            3503,    2,   32;
;HS_FSW_FM_HK_SSR_READ_ERR_CNT,                               3507,    2,   32;
;HS_FSW_FM_HK_SSR_WRITE_ERR_CNT,                              3511,    2,   32;
;HS_FSW_FM_HK_SSR_READ_SUCCESS_CNT,                           3515,    2,   32;
;HS_FSW_FM_HK_SSR_WRITE_SUCCESS_CNT,                          3519,    2,   32;
;HS_FSW_FM_HK_SSR_FLASH_ISR_FAIL_CNT,                         3523,    2,   32;
;HS_FSW_FM_HK_SSR_LAST_ECC_UNCORRECTED_ERR_PAGE,              3527,    2,   32;
;HS_FSW_FM_HK_SSR_LAST_ECC_UNCORRECTED_NUM_ERRS,              3531,    2,   32;
;HS_FSW_FM_HK_SSR_LAST_ECC_CORRECT_ERR_PAGE,                  3535,    2,   32;
;HS_FSW_FM_HK_SSR_LAST_ECC_CORRECT_NUM_ERRS,                  3539,    2,   32;
;HS_FSW_FM_HK_SSR_ECC_UNCORRECTED_CNT,                        3543,    2,   32;
;HS_FSW_FM_HK_SSR_ECC_CORRECT_CNT,                            3547,    2,   32;
;HS_FSW_FM_HK_SSR_SSR_ERR_LOG_UNCORRECTED_CNT,                3551,    2,   32;
;HS_FSW_FM_HK_SSR_SSR_ERR_LOG_IDX,                            3555,    2,   32;
;HS_FSW_FM_HK_SSR_SSR_LAST_ERASE_BLK,                         3559,    2,   32;
;HS_FSW_GC_HK_CMD_RCVD_CNT,                                   3563,    2,   16;
;HS_FSW_GC_HK_CMD_EXEC_CNT,                                   3565,    2,   16;
;HS_FSW_GC_HK_CMD_FAIL_CNT,                                   3567,    2,   16;
;HS_FSW_GC_HK_CMD_PKT_FAIL_CNT,                               3569,    2,   16;
;HS_FSW_GC_HK_CMD_CHECK_FAIL_CNT,                             3571,    2,   16;
;HS_FSW_GC_HK_CMD_EXEC_FAIL_CNT,                              3573,    2,   16;
;HS_FSW_HTM_HK_BB_TBL_ROW_CNT,                                3575,    2,    8;
;HS_FSW_HTM_HK_PKTS_DUMP_CNT,                                 3576,    2,   32;
;HS_FSW_HTM_HK_BB_DUMP_PROGRESS_TT,                           3580,    2,    1;
;HS_FSW_HTM_HK_BB_DUMP_TT,                                    3580,    1,    1;
;HS_FSW_HTM_HK_BB_RECORD_TT,                                  3580,    0,    1;
;HS_FSW_MM_HK_DWELL_PKT_ENA_BOOL,                             3581,    7,    8;
;HS_FSW_MM_HK_NV_MEM_HK_DEV1_WRITE_ENA_DIS,                   3582,    7,    1;
;HS_FSW_MM_HK_NV_MEM_HK_DEV2_WRITE_ENA_DIS,                   3582,    6,    1;
;HS_FSW_MM_HK_NV_MEM_HK_BANK_1_WRITE_ENA_DIS,                 3582,    5,    1;
;HS_FSW_MM_HK_NV_MEM_HK_BANK_2_WRITE_ENA_DIS,                 3582,    4,    1;
;HS_FSW_MM_HK_NV_MEM_HK_RECENT_WRITE_ERR_CNT_TRANSIENT,       3582,    3,   32;
;HS_FSW_MM_HK_NV_MEM_HK_LAST_WRITE_ERR_ADDR_TRANSIENT,        3586,    3,   32;
;HS_FSW_MM_HK_NV_MEM_HK_NVM_SLEEP_ENA_DIS,                    3590,    3,    1;
;HS_FSW_MM_HK_EDAC_RESET_CNTRL,                               3590,    2,   32;
;HS_FSW_MOH_HK_OBJ_SRC_DURING_INIT,                           3594,    2,    8;
;HS_FSW_MOH_HK_TOTAL_NUM_ERRS,                                3595,    2,   32;
;HS_FSW_SPP_HK_ONVM_MET_SEC_OF_RECENT_PROMOTION0,             3599,    2,   32;
;HS_FSW_SPP_HK_ONVM_MET_SEC_OF_RECENT_PROMOTION1,             3603,    2,   32;
;HS_FSW_SPP_HK_ONVM_MET_SEC_OF_RECENT_PROMOTION2,             3607,    2,   32;
;HS_FSW_SPP_HK_LOGICAL_ID0,                                   3611,    2,   32;
;HS_FSW_SPP_HK_ENTER_MET0,                                    3615,    2,   32;
;HS_FSW_SPP_HK_SECS_IN_MODE0,                                 3619,    2,   32;
;HS_FSW_SPP_HK_EXIT_MET0,                                     3623,    2,   32;
;HS_FSW_SPP_HK_LOGICAL_ID1,                                   3627,    2,   32;
;HS_FSW_SPP_HK_ENTER_MET1,                                    3631,    2,   32;
;HS_FSW_SPP_HK_SECS_IN_MODE1,                                 3635,    2,   32;
;HS_FSW_SPP_HK_MNA_COUNT,                                     3639,    2,   32;
;HS_FSW_SPP_HK_EXIT_MET1,                                     3643,    2,   32;
;HS_FSW_REC_HK_RECORD_ENA_SSR,                                3647,    2,    1;
;HS_FSW_REC_HK_LP_CMDS_FAIL_CNT_LSB,                          3647,    1,    8;
;HS_FSW_REC_HK_SSR_FILES_OPEN_CNT,                            3648,    1,    8;
;HS_FSW_REC_HK_LP_CMDS_SUCCESS_CNT_LSB,                       3649,    1,    8;
;HS_FSW_REC_HK_PFT_TOTAL_SUBSCRIPTIONS,                       3650,    1,   16;
;HS_FSW_REC_HK_ALLOC_MGMT_ENA_SSR,                            3652,    1,    8;
;HS_FSW_TO_HK_TBL_SEL_PKT_INTERFACE,                          3653,    1,    8;
;HS_FSW_TO_HK_TBL_SEL_PKT_INTF,                               3653,    1,    8;
;HS_FSW_TO_HK_TBL_SEL,                                        3654,    1,    8;
;HS_FSW_TTAG_HK_RULE_LOAD_FAIL_CNT,                           3655,    1,   16;
;HS_FSW_TTAG_HK_NUM_RULES_LOADED_CNT,                         3657,    1,   16;
;HS_FSW_XSBC_HK_FSP_LOCAL_IGNORED_CNT,                        3659,    1,   32;
;HS_FSW_XSBC_HK_FSP_LOCAL_QUEUED_CNT,                         3663,    1,   32;
;HS_FSW_XSBC_HK_FSP_LOCAL_FWD_CNT,                            3667,    1,   32;
;HS_FSW_XSBC_HK_FSP_REMOTE_IGNORED_CNT,                       3671,    1,   32;
;HS_FSW_XSBC_HK_FSP_REMOTE_MV_CNT,                            3675,    1,   32;
;HS_FSW_XSBC_HK_FSP_REMOTE_RM_CNT,                            3679,    1,   32;
;HS_FSW_XSBC_HK_XFRS_STARTED_CNT,                             3683,    1,   32;
;HS_FSW_XSBC_HK_XFRS_COMPLETED_CNT,                           3687,    1,   32;
;HS_FSW_XSBC_HK_XFRS_FAILED_CNT,                              3691,    1,   32;
;HS_FSW_SI_HK_NUM_TIME_CODES0,                                3695,    1,   16;
;HS_FSW_SI_HK_NUM_TIME_CODES1,                                3697,    1,   16;
;HS_FSW_SI_HK_REM_ARC_RESYNC_REQ_CNT,                         3699,    1,   32;
;HS_FSW_CFDP_HK_RX_OPEN_TRANSACTIONS,                         3703,    1,   16;
;HS_FSW_CFDP_HK_RX_CLOSED_TRANSACTIONS,                       3705,    1,   16;
;HS_FSW_CFDP_HK_RX_FAILED_TRANSACTIONS,                       3707,    1,   16;
;HS_FSW_CFDP_HK_RX_FS_ERRORS,                                 3709,    1,   16;
;HS_FSW_CFE_ES_ES_HK_MAX_CPU_RESETS,                          3711,    1,    8;
;HS_FSW_CFE_SB_SB_HK_PIPE_OVFLW_ERR_CNT,                      3712,    1,   16;
;HS_FSW_CFE_SB_SB_HK_MSG_ID_TO_PIPE_ERR_CNT,                  3714,    1,   16;
;HS_FSW_CFE_TIME_TIME_HK_CLOCK_STATE_FLAGS,                   3716,    1,   16;
;HS_FSW_CFE_TIME_TIME_HK_CLOCK_STATE_API,                     3718,    1,   16;
;BS_FSW_SCH_HK_UP_TIME,                                       3720,    1,   32;
;BS_FSW_SCH_HK_SCH_MET_DISCONTINUITY_TT,                      3724,    1,    1;
;BS_FSW_CPU_HK_IDLER_TASK_CYCLES,                             3724,    0,   32;
;BS_FSW_CPU_HK_DURATION_OF_IDLER_TASK_SAMPLE,                 3728,    0,   32;
;BS_FSW_CPU_HK_CPU_METRIC_COLLECTION_MODE,                    3732,    0,   32;
;BS_FSW_CPU_HK_POR_RESET,                                     3736,    0,    1;
;BS_FSW_CPU_HK_MC_RESET,                                      3737,    7,    1;
;BS_FSW_CPU_HK_SW_RESET,                                      3737,    6,    1;
;BS_FSW_CPU_HK_WDOG_RESET,                                    3737,    5,    1;
;BS_FSW_CPU_HK_WDT_RESET,                                     3737,    5,    1;
;BS_FSW_CPU_HK_FLASH_STATUS,                                  3737,    4,    1;
;BS_FSW_CPU_HK_SOFTWARE_TIMER_STATUS,                         3737,    3,    1;
;BS_FSW_CPU_HK_FLASH_PWR_STATUS,                              3737,    2,    1;
;BS_FSW_CPU_HK_SMF,                                           3737,    1,    1;
;BS_FSW_CPU_HK_IMAGE_2_WRITE_ENA,                             3737,    0,    1;
;BS_FSW_CPU_HK_IMAGE_2_WRITE_ENABLE,                          3737,    0,    1;
;BS_FSW_CPU_HK_IMAGE_1_WRITE_ENA,                             3738,    7,    1;
;BS_FSW_CPU_HK_IMAGE_1_WRITE_ENABLE,                          3738,    7,    1;
;BS_FSW_CPU_HK_MC_C_IMAGE_SEL,                                3738,    6,    1;
;BS_FSW_CPU_HK_MC_C_RESET_DCRT,                               3738,    5,    1;
;BS_FSW_CPU_HK_MC_C_RESET_DISCRT,                             3738,    5,    1;
;BS_FSW_CPU_HK_MC_B_IMAGE_SEL,                                3738,    4,    1;
;BS_FSW_CPU_HK_MC_B_RESET_DCRT,                               3738,    3,    1;
;BS_FSW_CPU_HK_MC_B_RESET_DISCRT,                             3738,    3,    1;
;BS_FSW_CPU_HK_MC_A_IMAGE_SEL,                                3738,    2,    1;
;BS_FSW_CPU_HK_MC_A_RESET_DCRT,                               3738,    1,    1;
;BS_FSW_CPU_HK_MC_A_RESET_DISCRT,                             3738,    1,    1;
;BS_FSW_CPU_HK_SBC_APP_IMAGE_BOOTED,                          3738,    0,    2;
;BS_FSW_CPU_HK_SECONDARY_CHECKSUM_FAIL,                       3739,    6,    1;
;BS_FSW_CPU_HK_PRIMARY_CHECKSUM_FAIL,                         3739,    5,    1;
;BS_FSW_CPU_HK_SBC_APP_IMAGE_VOTED,                           3739,    4,    2;
;BS_FSW_CPU_HK_BRKWIRE0,                                      3739,    2,    1;
;BS_FSW_CPU_HK_BRKWIRE1,                                      3739,    1,    1;
;BS_FSW_CPU_HK_WATCHDOG_EN_DIS,                               3739,    0,    1;
;BS_FSW_CPU_HK_CDS_POR_RESET,                                 3740,    7,    1;
;BS_FSW_CPU_HK_CDS_MC_RESET,                                  3740,    6,    1;
;BS_FSW_CPU_HK_CDS_SW_RESET,                                  3740,    5,    1;
;BS_FSW_CPU_HK_CDS_WDOG_RESET,                                3740,    4,    1;
;BS_FSW_CPU_HK_CDS_FLASH_STATUS,                              3740,    3,    1;
;BS_FSW_CPU_HK_CDS_SW_TIMER_STATUS,                           3740,    2,    1;
;BS_FSW_CPU_HK_CDS_FLASH_PWR_STATUS,                          3740,    1,    1;
;BS_FSW_CPU_HK_CDS_SMF,                                       3740,    0,    1;
;BS_FSW_CPU_HK_CDS_IMAGE_2_WRITE_ENA,                         3741,    7,    1;
;BS_FSW_CPU_HK_CDS_IMAGE_1_WRITE_ENA,                         3741,    6,    1;
;BS_FSW_CPU_HK_CDS_MC_C_IMAGE_SEL,                            3741,    5,    1;
;BS_FSW_CPU_HK_CDS_MC_C_RESET_DCRT,                           3741,    4,    1;
;BS_FSW_CPU_HK_CDS_MC_B_IMAGE_SEL,                            3741,    3,    1;
;BS_FSW_CPU_HK_CDS_MC_B_RESET_DCRT,                           3741,    2,    1;
;BS_FSW_CPU_HK_CDS_MC_A_IMAGE_SEL,                            3741,    1,    1;
;BS_FSW_CPU_HK_CDS_MC_A_RESET_DCRT,                           3741,    0,    1;
;BS_FSW_CPU_HK_CDS_SBC_APP_IMAGE_BOOTED,                      3742,    7,    2;
;BS_FSW_CPU_HK_CDS_SEC_CKSM_FAIL,                             3742,    5,    1;
;BS_FSW_CPU_HK_CDS_PRIMARY_CKSM_FAIL,                         3742,    4,    1;
;BS_FSW_CPU_HK_CDS_SBC_APP_IMAGE_VOTED,                       3742,    3,    2;
;BS_FSW_CPU_HK_CDS_BRKWIRE0,                                  3742,    1,    1;
;BS_FSW_CPU_HK_CDS_BRKWIRE1,                                  3742,    0,    1;
;BS_FSW_CPU_HK_CDS_WDOG_ENA_DIS,                              3743,    7,    1;
;BS_FSW_CPU_HK_CDS_CPU_APP_INIT_CNT,                          3743,    6,   32;
;BS_FSW_CPU_HK_CDS_CPU_APP_INIT_COUNT,                        3743,    6,   32;
;BS_FSW_CPU_HK_CDS_HEALTH_MON_RESET_BOOL,                     3747,    6,   32;
;BS_FSW_CPU_HK_CDS_RESET_MODE,                                3751,    6,   32;
;BS_FSW_CPU_HK_CDS_MET_SECS,                                  3755,    6,   32;
;BS_FSW_CPU_HK_CDS_MET_SECONDS,                               3755,    6,   32;
;BS_FSW_CPU_HK_CDS_HM_RESET_CODE,                             3759,    6,   32;
;BS_FSW_CPU_HK_CDS_TASK_INFO_VAL_BOOL,                        3763,    6,   32;
;BS_FSW_CPU_HK_CDS_TASK_INFO_VALID_BOOL,                      3763,    6,   32;
;BS_FSW_AUT_HK_RULES_LOAD_NV_MEM_CNT,                         3767,    6,   16;
;BS_FSW_AUT_HK_CT_LOAD_NVM_CNT,                               3769,    6,   16;
;BS_FSW_AUT_HK_SV_LOAD_NVM_CNT,                               3771,    6,   16;
;BS_FSW_AUT_HK_RULES_LOAD_RAM_CNT,                            3773,    6,   16;
;BS_FSW_AUT_HK_CT_LOAD_RAM_CNT,                               3775,    6,   16;
;BS_FSW_AUT_HK_SV_LOAD_RAM_CNT,                               3777,    6,   16;
;BS_FSW_FI_HK_CDH_FILE_CNT,                                   3779,    6,   16;
;BS_FSW_FI_HK_CDH_STATE,                                      3781,    6,   16;
;BS_FSW_FI_HK_CDH_EXEC_CMDS,                                  3783,    6,   16;
;BS_FSW_FI_HK_CDH_FAILED_CMDS,                                3785,    6,   16;
;BS_FSW_FI_HK_CDH_PROCESSING_FILE,                            3787,    6,   16;
;BS_FSW_FI_HK_CDH_DELAY,                                      3789,    6,   32;
;BS_FSW_FI_HK_CDH_DELAY_CNT,                                  3793,    6,   32;
;BS_FSW_FI_HK_AUTO_DELETE_STATE,                              3797,    6,    8;
;BS_FSW_FM_HK_LONG_DURATION_CMD_ACTIVE,                       3798,    6,    1;
;BS_FSW_FM_HK_SHORT_DURATION_CMD_ACTIVE,                      3798,    5,    1;
;BS_FSW_FM_HK_LOW_PRIORITY_CMD_ACTIVE,                        3798,    4,    1;
;BS_FSW_FM_HK_FS_ACCESS_RAM,                                  3798,    3,    1;
;BS_FSW_FM_HK_LP_CMD_PUT_FAIL_CNT,                            3798,    2,   16;
;BS_FSW_FM_HK_LP_CMDS_RCVD_CNT,                               3800,    2,   16;
;BS_FSW_FM_HK_LP_CMDS_FAIL_CNT,                               3802,    2,   16;
;BS_FSW_FM_HK_LP_CMDS_SUCCESS_CNT,                            3804,    2,   16;
;BS_FSW_FM_HK_CMD_FS_CREATE_ATTEMPT_TT,                       3806,    2,    1;
;BS_FSW_FM_HK_CMD_REJ_LP_FS_FILE_SYS_OPER_TT,                 3806,    1,    1;
;BS_FSW_FM_HK_CMD_REJ_LP_SSR_BBT_POKE_TT,                     3806,    0,    1;
;BS_FSW_FM_HK_CMD_REJ_LP_SSR_BBT_COPY_TT,                     3807,    7,    1;
;BS_FSW_FM_HK_CMD_REJ_LP_FS_DISMOUNT_TT,                      3807,    6,    1;
;BS_FSW_FM_HK_CMD_REJ_LP_FS_GARBAGE_COLLECT_TT,               3807,    5,    1;
;BS_FSW_FM_HK_CMD_REJ_LP_FS_CREATE_NEW_TT,                    3807,    4,    1;
;BS_FSW_FM_HK_CMD_REJ_LP_FS_DIR_LIST_TT,                      3807,    3,    1;
;BS_FSW_FM_HK_CMD_REJ_LP_SSR_DESTR_DIAG_TT,                   3807,    2,    1;
;BS_FSW_FM_HK_CMD_REJ_LP_SSR_READ_MFGR_BAD_BLOCK_MKR_TT,      3807,    1,    1;
;BS_FSW_FM_HK_CMD_REJ_LP_SSR_FLASH_ERASE_TT,                  3807,    0,    1;
;BS_FSW_FM_HK_CMD_REJ_LP_FS_MOUNT_TT,                         3808,    7,    1;
;BS_FSW_FM_HK_CMD_REJ_LP_TT,                                  3808,    6,    1;
;BS_FSW_FM_HK_FLASH_PWR,                                      3808,    5,    1;
;BS_FSW_FM_HK_DIAG_ACTIVE,                                    3808,    4,    1;
;BS_FSW_FM_HK_DIAG_RSLT,                                      3808,    3,    1;
;BS_FSW_FM_HK_FS_NUM_USED_OBJECTS,                            3808,    2,   32;
;BS_FSW_FM_HK_FS_NUM_UNRECOVERED_WRITE_FAILURES,              3812,    2,   32;
;BS_FSW_FM_HK_FS_CLUSTERS_FREE_SSR,                           3816,    2,   32;
;BS_FSW_FM_HK_FS_CLUSTERS_FREE_RAM,                           3820,    2,   32;
;BS_FSW_FM_HK_FS_ALMOST_FULL_SSR,                             3824,    2,    1;
;BS_FSW_FM_HK_FS_ALMOST_FULL_RAM,                             3824,    1,    1;
;BS_FSW_FM_HK_FS_REG_WITH_OPER_SYS,                           3824,    0,    1;
;BS_FSW_FM_HK_FS_MOUNT_PT_CREATED,                            3825,    7,    1;
;BS_FSW_FM_HK_FS_DEV_INITIALIZED,                             3825,    6,    1;
;BS_FSW_FM_HK_BBT_LOADED,                                     3825,    5,    1;
;BS_FSW_FM_HK_FOUND_EXISTING_DIR,                             3825,    4,    1;
;BS_FSW_FM_HK_SETUP_DIRS_SUCCESS,                             3825,    3,    1;
;BS_FSW_FM_HK_FS_CREATE_SUCCESS,                              3825,    2,    1;
;BS_FSW_FM_HK_DIR_CREATE_STATUS,                              3825,    1,    5;
;BS_FSW_FM_HK_FS_SSR_VOLUME_MOUNTED,                          3826,    4,    1;
;BS_FSW_FM_HK_FS_RAM_VOLUME_MOUNTED,                          3826,    3,    1;
;BS_FSW_FM_HK_RAM_FOUND_EXISTING_DIR,                         3826,    2,    1;
;BS_FSW_FM_HK_RAM_DIR_CREATE_STATUS,                          3826,    1,    5;
;BS_FSW_FM_HK_FS_DIAG_RSLT,                                   3827,    4,    1;
;BS_FSW_FM_HK_GARB_CLXN_BLOCK_COLLECTED_CNT,                  3827,    3,   32;
;BS_FSW_FM_HK_FS_NUM_ERASED_BLOCKS,                           3831,    3,   32;
;BS_FSW_FM_HK_FS_CUR_ALLOCATION_BLOCK,                        3835,    3,   32;
;BS_FSW_FM_HK_FS_NUM_FREE_TNODES,                             3839,    3,   32;
;BS_FSW_FM_HK_FS_NUM_FREE_OBJECTS,                            3843,    3,   32;
;BS_FSW_FM_HK_FS_NUM_FREE_CHUNKS,                             3847,    3,   32;
;BS_FSW_FM_HK_FS_NUM_BLOCK_ERASURES,                          3851,    3,   32;
;BS_FSW_FM_HK_FS_NUM_GC_COPIES,                               3855,    3,   32;
;BS_FSW_FM_HK_FS_NUM_GARBAGE_COLLECTIONS,                     3859,    3,   32;
;BS_FSW_FM_HK_FS_NUM_DELETIONS,                               3863,    3,   32;
;BS_FSW_FM_HK_SSR_REG_STATE,                                  3867,    3,    1;
;BS_FSW_FM_HK_SSR_SDRAM_STATE,                                3867,    2,    1;
;BS_FSW_FM_HK_SSR_FS_FS_STATE,                                3867,    1,    1;
;BS_FSW_FM_HK_SSR_FLASH_RDY_STATUS,                           3867,    0,   16;
;BS_FSW_FM_HK_SSR_LAST_READ_PAGE,                             3869,    0,   32;
;BS_FSW_FM_HK_SSR_LAST_WRITE_PAGE,                            3873,    0,   32;
;BS_FSW_FM_HK_SSR_READ_ERR_CNT,                               3877,    0,   32;
;BS_FSW_FM_HK_SSR_WRITE_ERR_CNT,                              3881,    0,   32;
;BS_FSW_FM_HK_SSR_READ_SUCCESS_CNT,                           3885,    0,   32;
;BS_FSW_FM_HK_SSR_WRITE_SUCCESS_CNT,                          3889,    0,   32;
;BS_FSW_FM_HK_SSR_FLASH_ISR_FAIL_CNT,                         3893,    0,   32;
;BS_FSW_FM_HK_SSR_LAST_ECC_UNCORRECTED_ERR_PAGE,              3897,    0,   32;
;BS_FSW_FM_HK_SSR_LAST_ECC_UNCORRECTED_NUM_ERRS,              3901,    0,   32;
;BS_FSW_FM_HK_SSR_LAST_ECC_CORRECT_ERR_PAGE,                  3905,    0,   32;
;BS_FSW_FM_HK_SSR_LAST_ECC_CORRECT_NUM_ERRS,                  3909,    0,   32;
;BS_FSW_FM_HK_SSR_ECC_UNCORRECTED_CNT,                        3913,    0,   32;
;BS_FSW_FM_HK_SSR_ECC_CORRECT_CNT,                            3917,    0,   32;
;BS_FSW_FM_HK_SSR_SSR_ERR_LOG_UNCORRECTED_CNT,                3921,    0,   32;
;BS_FSW_FM_HK_SSR_SSR_ERR_LOG_IDX,                            3925,    0,   32;
;BS_FSW_FM_HK_SSR_SSR_LAST_ERASE_BLK,                         3929,    0,   32;
;BS_FSW_GC_HK_CMD_RCVD_CNT,                                   3933,    0,   16;
;BS_FSW_GC_HK_CMD_EXEC_CNT,                                   3935,    0,   16;
;BS_FSW_GC_HK_CMD_FAIL_CNT,                                   3937,    0,   16;
;BS_FSW_GC_HK_CMD_PKT_FAIL_CNT,                               3939,    0,   16;
;BS_FSW_GC_HK_CMD_CHECK_FAIL_CNT,                             3941,    0,   16;
;BS_FSW_GC_HK_CMD_EXEC_FAIL_CNT,                              3943,    0,   16;
;BS_FSW_HTM_HK_BB_TBL_ROW_CNT,                                3945,    0,    8;
;BS_FSW_HTM_HK_PKTS_DUMP_CNT,                                 3946,    0,   32;
;BS_FSW_HTM_HK_BB_DUMP_PROGRESS_TT,                           3950,    0,    1;
;BS_FSW_HTM_HK_BB_DUMP_TT,                                    3951,    7,    1;
;BS_FSW_HTM_HK_BB_RECORD_TT,                                  3951,    6,    1;
;BS_FSW_MM_HK_DWELL_PKT_ENA_BOOL,                             3951,    5,    8;
;BS_FSW_MM_HK_NV_MEM_HK_DEV1_WRITE_ENA_DIS,                   3952,    5,    1;
;BS_FSW_MM_HK_NV_MEM_HK_DEV2_WRITE_ENA_DIS,                   3952,    4,    1;
;BS_FSW_MM_HK_NV_MEM_HK_BANK_1_WRITE_ENA_DIS,                 3952,    3,    1;
;BS_FSW_MM_HK_NV_MEM_HK_BANK_2_WRITE_ENA_DIS,                 3952,    2,    1;
;BS_FSW_MM_HK_NV_MEM_HK_RECENT_WRITE_ERR_CNT_TRANSIENT,       3952,    1,   32;
;BS_FSW_MM_HK_NV_MEM_HK_LAST_WRITE_ERR_ADDR_TRANSIENT,        3956,    1,   32;
;BS_FSW_MM_HK_NV_MEM_HK_NVM_SLEEP_ENA_DIS,                    3960,    1,    1;
;BS_FSW_MM_HK_EDAC_RESET_CNTRL,                               3960,    0,   32;
;BS_FSW_MOH_HK_OBJ_SRC_DURING_INIT,                           3964,    0,    8;
;BS_FSW_MOH_HK_TOTAL_NUM_ERRS,                                3965,    0,   32;
;BS_FSW_SPP_HK_ONVM_MET_SEC_OF_RECENT_PROMOTION0,             3969,    0,   32;
;BS_FSW_SPP_HK_ONVM_MET_SEC_OF_RECENT_PROMOTION1,             3973,    0,   32;
;BS_FSW_SPP_HK_ONVM_MET_SEC_OF_RECENT_PROMOTION2,             3977,    0,   32;
;BS_FSW_SPP_HK_LOGICAL_ID0,                                   3981,    0,   32;
;BS_FSW_SPP_HK_ENTER_MET0,                                    3985,    0,   32;
;BS_FSW_SPP_HK_SECS_IN_MODE0,                                 3989,    0,   32;
;BS_FSW_SPP_HK_EXIT_MET0,                                     3993,    0,   32;
;BS_FSW_SPP_HK_LOGICAL_ID1,                                   3997,    0,   32;
;BS_FSW_SPP_HK_ENTER_MET1,                                    4001,    0,   32;
;BS_FSW_SPP_HK_SECS_IN_MODE1,                                 4005,    0,   32;
;BS_FSW_SPP_HK_MNA_COUNT,                                     4009,    0,   32;
;BS_FSW_SPP_HK_EXIT_MET1,                                     4013,    0,   32;
;BS_FSW_REC_HK_RECORD_ENA_SSR,                                4017,    0,    1;
;BS_FSW_REC_HK_LP_CMDS_FAIL_CNT_LSB,                          4018,    7,    8;
;BS_FSW_REC_HK_SSR_FILES_OPEN_CNT,                            4019,    7,    8;
;BS_FSW_REC_HK_LP_CMDS_SUCCESS_CNT_LSB,                       4020,    7,    8;
;BS_FSW_REC_HK_PFT_TOTAL_SUBSCRIPTIONS,                       4021,    7,   16;
;BS_FSW_REC_HK_ALLOC_MGMT_ENA_SSR,                            4023,    7,    8;
;BS_FSW_TO_HK_TBL_SEL_PKT_INTERFACE,                          4024,    7,    8;
;BS_FSW_TO_HK_TBL_SEL_PKT_INTF,                               4024,    7,    8;
;BS_FSW_TO_HK_TBL_SEL,                                        4025,    7,    8;
;BS_FSW_TTAG_HK_RULE_LOAD_FAIL_CNT,                           4026,    7,   16;
;BS_FSW_TTAG_HK_NUM_RULES_LOADED_CNT,                         4028,    7,   16;
;BS_FSW_XSBC_HK_FSP_LOCAL_IGNORED_CNT,                        4030,    7,   32;
;BS_FSW_XSBC_HK_FSP_LOCAL_QUEUED_CNT,                         4034,    7,   32;
;BS_FSW_XSBC_HK_FSP_LOCAL_FWD_CNT,                            4038,    7,   32;
;BS_FSW_XSBC_HK_FSP_REMOTE_IGNORED_CNT,                       4042,    7,   32;
;BS_FSW_XSBC_HK_FSP_REMOTE_MV_CNT,                            4046,    7,   32;
;BS_FSW_XSBC_HK_FSP_REMOTE_RM_CNT,                            4050,    7,   32;
;BS_FSW_XSBC_HK_XFRS_STARTED_CNT,                             4054,    7,   32;
;BS_FSW_XSBC_HK_XFRS_COMPLETED_CNT,                           4058,    7,   32;
;BS_FSW_XSBC_HK_XFRS_FAILED_CNT,                              4062,    7,   32;
;BS_FSW_SI_HK_NUM_TIME_CODES0,                                4066,    7,   16;
;BS_FSW_SI_HK_NUM_TIME_CODES1,                                4068,    7,   16;
;BS_FSW_SI_HK_REM_ARC_RESYNC_REQ_CNT,                         4070,    7,   32;
;BS_FSW_CFDP_HK_RX_OPEN_TRANSACTIONS,                         4074,    7,   16;
;BS_FSW_CFDP_HK_RX_CLOSED_TRANSACTIONS,                       4076,    7,   16;
;BS_FSW_CFDP_HK_RX_FAILED_TRANSACTIONS,                       4078,    7,   16;
;BS_FSW_CFDP_HK_RX_FS_ERRORS,                                 4080,    7,   16;
;BS_FSW_CFE_ES_ES_HK_MAX_CPU_RESETS,                          4082,    7,    8;
;BS_FSW_CFE_SB_SB_HK_PIPE_OVFLW_ERR_CNT,                      4083,    7,   16;
;BS_FSW_CFE_SB_SB_HK_MSG_ID_TO_PIPE_ERR_CNT,                  4085,    7,   16;
;BS_FSW_CFE_TIME_TIME_HK_CLOCK_STATE_FLAGS,                   4087,    7,   16;
;BS_FSW_CFE_TIME_TIME_HK_CLOCK_STATE_API,                     4089,    7,   16;
;SC_HK_FSWL_DERIVED_TRIGGER_PT,                               4089,    7,   16;
;}

