;+
;PROCEDURE:	mvn_sta_get_d6
;PURPOSE:	
;	Returns APID d6 data structure at a single time from common generated by mvn_sta_prod_cal.pro
;INPUT:		
;	time:		dbl		time of data to be returned
;
;KEYWORDS:
;	start:		0,1		if set, gets first time in common block
;	en:		0,1		if set, gets last time in common block
;	advance		0,1		if set, gets next time in common block
;	retreat		0,1		if set, gets previous time in common block
;	index		long		gets data at the index value "ind" in common block
;	calib:		0,1		not working yet, allows alternate calibration
;	times		0,1		returns an array of times for all the data, returns 0 if no data
;
;
;CREATED BY:	J. McFadden
;VERSION:	1
;LAST MODIFICATION:  14/08/27
;MOD HISTORY:
;
;NOTES:	  
;	Data structures can be used as inputs to functions such as n_4d.pro, v_4d.pro
;	Or used in conjunction with iterative programs such as get_2dt.pro, get_en_spec.pro
;-
FUNCTION mvn_sta_get_d6,time,START=st,EN=en,ADVANCE=adv,RETREAT=ret,index=ind,calib=calib,times=times

common mvn_d6,get_ind,all_dat

if n_elements(get_ind) eq 0 then begin
	if keyword_set(times) then return,0
	dat = 	{project_name:'MAVEN',valid:0}
	print,' ERROR - mvn d6 data not loaded'
	return,dat
endif else if get_ind eq -1 then begin
	dat = 	{project_name:'MAVEN',valid:0}
	print,' ERROR - mvn d6 data not loaded'
	return,dat
endif else if keyword_set(times) then begin
	dat=(all_dat.time+all_dat.end_time)/2.
endif else begin

if (n_elements(time) eq 0) and (not keyword_set(st)) and (not keyword_set(en)) $
        and (not keyword_set(adv)) and (not keyword_set(ret)) and (n_elements(ind) eq 0) $
	then ctime,time,npoints=1

if keyword_set(st) then ind=0l 						$
	else if keyword_set(en) then ind=n_elements(all_dat.time)-1 	$
	else if keyword_set(adv) then ind=get_ind+1 			$
	else if keyword_set(ret) then ind=get_ind-1 			$
	else if n_elements(ind) ne 0 then ind=ind 			$
	else tmpmin = min(abs(all_dat.time-time),ind)

if ind lt 0 or ind ge n_elements(all_dat.time) then begin

dat = 		{project_name:		all_dat.project_name,		$
		spacecraft:		all_dat.spacecraft, 		$
		data_name:		all_dat.data_name, 		$
		apid:			all_dat.apid,			$
		valid: 			0}

endif else begin

	while (all_dat.valid[ind] eq 0 and ind+1 lt n_elements(all_dat.time)) do ind=ind+1

dat = 		{project_name:		all_dat.project_name,				$
		spacecraft:		all_dat.spacecraft, 				$
		data_name:		all_dat.data_name, 				$
		apid:			all_dat.apid,					$

		valid: 			all_dat.valid[ind], 				$
		quality_flag: 		all_dat.quality_flag[ind], 			$

		time: 			all_dat.time[ind], 				$

;		mode:			all_dat.mode[ind],				$
;		rate:			all_dat.rate[ind],				$
;		swp_ind:		all_dat.swp_ind[ind],				$

		tdc_1: 			all_dat.tdc_1[ind],				$
		tdc_2: 			all_dat.tdc_2[ind],				$
		tdc_3: 			all_dat.tdc_3[ind],				$
		tdc_4: 			all_dat.tdc_4[ind],				$
		event_code: 		all_dat.event_code[ind],			$
		cyclestep: 		all_dat.cyclestep[ind],				$
		energy: 		all_dat.energy[ind], 				$

		tdc1_conv: 		all_dat.tdc1_conv,				$
		tdc2_conv: 		all_dat.tdc2_conv,				$
		tdc3_conv: 		all_dat.tdc3_conv,				$
		tdc4_conv: 		all_dat.tdc4_conv,				$
		tdc1_offset: 		all_dat.tdc1_offset,				$
		tdc2_offset: 		all_dat.tdc2_offset,				$
		tdc3_offset: 		all_dat.tdc3_offset,				$
		tdc4_offset: 		all_dat.tdc4_offset,				$
		an_bin_tdc3: 		all_dat.an_bin_tdc3,				$
		an_bin_tdc4: 		all_dat.an_bin_tdc4,				$
		ms_bias_offset: 	all_dat.ms_bias_offset,				$
		evconvlut:		all_dat.evconvlut,				$
		timerst:		all_dat.timerst}

get_ind=ind

endelse
endelse

return,dat

end
