;+
; FUNCTION:
;       kgy_pace_16x64to4x16
; PURPOSE:
;       rebin a data structure w/ 16x64 angles into 4x16 angles
; CALLING SEQUENCE:
;       d2 = kgy_pace_16x64to4x16(dat)
; INPUTS:
;       3d data structure generated by kgy_*_get3d
; KEYWORDS:
;       
; CREATED BY:
;       Yuki Harada on 2016-10-26
;
; $LastChangedBy: haraday $
; $LastChangedDate: 2016-10-26 10:34:33 -0700 (Wed, 26 Oct 2016) $
; $LastChangedRevision: 22200 $
; $URL: svn+ssh://thmsvn@ambrosia.ssl.berkeley.edu/repos/spdsoft/trunk/projects/kaguya/map/pace/kgy_pace_16x64to4x16.pro $
;-


function kgy_pace_16x64to4x16, dat, sabin=sabin, INFOangle=INFOangle

  if size(dat.data,/n_dim) ne 3 then begin
     dprint,'The input data dimension does not match 16x64 or 4x16 angles'
     dprint,'Returning...'
     return,dat
  endif

  @kgy_pace_com
  if dat.sensor eq 0 then begin
     fov_str = esa1_fov_str
     info_str = esa1_info_str
  endif
  if dat.sensor eq 1 then begin
     fov_str = esa2_fov_str
     info_str = esa2_info_str
  endif
  if dat.sensor eq 2 then begin
     fov_str = ima_fov_str
     info_str = ima_info_str
  endif
  if dat.sensor eq 3 then begin
     fov_str = iea_fov_str
     info_str = iea_info_str
  endif
  ram = dat.svs

  d = conv_units(dat,'counts')

  data = replicate(!values.f_nan,32,4,16)
  gfactor = replicate(!values.f_nan,32,4,16)
  energy = replicate(!values.f_nan,32,4,16)
  theta = replicate(!values.f_nan,32,4,16)
  phi = replicate(!values.f_nan,32,4,16)
  dtheta = replicate(90./4.,32,4,16)
  dphi = replicate(360./16.,32,4,16)
  domega = 2.*(dphi/!radeg)*cos(theta/!radeg)*sin(.5*dtheta/!radeg)
  eff = replicate(0.6, 32,4,16)
  bins = replicate(1, 32,4,16)

  if dat.ntheta eq 16 and dat.nphi eq 64 then begin
     for ip=0,3 do begin
        for ia=0,15 do begin
           data[*,ip,ia] = total(total(d.data[*,ip*4:ip*4+3,ia*4:ia*4+3],3),2)
        endfor
     endfor 
  endif else data = d.data

  enesq = reform(info_str.ene_sqno_4x16[ram,*,0,0])
  polsq = reform(info_str.pol_sqno_4x16[ram,0,*,0])
  gfactor[enesq[*],polsq[*],*] = info_str.gfactor_4x16[ram,*,*,*]

  if not keyword_set(INFOangle) then begin
     energy[enesq[*],*,*] = $   ;- keV -> eV
        rebin(reform(fov_str.ene[ram,*]),32,4,16) * 1000.
     theta[enesq[*],polsq[*],*] $
        = -rebin(reform(fov_str.pol4[ram,*,*]),32,4,16)
     phi[*,*,*] = transpose(rebin(fov_str.az16[*],16,4,32))
  endif else begin
     energy[enesq[*],polsq[*],*] = $
        info_str.ene_4x16[ram,*,*,*] * 1000. ;- keV -> eV
     theta[enesq[*],polsq[*],*] = info_str.pol_4x16[ram,*,*,*]
     phi[enesq[*],polsq[*],*] = info_str.az_4x16[ram,*,*,*]
     idx_0 = where( gfactor eq 0 , idx_0_cnt )
     if idx_0_cnt gt 0 then bins[idx_0] = 0
  endelse

  denergy = replicate(0., 32,4,16)
  denergy[0,*,*] = energy[1,*,*] - energy[0,*,*]
  denergy[31,*,*] = energy[31,*,*] - energy[30,*,*]
  denergy[indgen(30)+1,*,*] $
     = (energy[indgen(30)+2,*,*]-energy[indgen(30),*,*])/2.


if keyword_set(sabin) then begin
   olddata = data
   data = replicate(0., 32,64)
   oldenergy = energy
   energy = replicate(0., 32,64)
   oldtheta = theta
   theta = replicate(0., 32,64)
   oldphi = phi
   phi = replicate(0., 32,64)
   oldgfactor = gfactor
   gfactor = replicate(0.d, 32,64)
   oldeff = eff
   eff = replicate(0., 32,64)
   oldbins = bins
   bins = replicate(1, 32,64)
   olddenergy = denergy
   denergy = replicate(0., 32,64)
   olddtheta= dtheta
   dtheta = replicate(0.,32,64)
   olddphi = dphi
   dphi = replicate(0.,32,64)
   for i_pol=0,3 do begin
      data[*,i_pol+indgen(16)*4] = olddata[*,i_pol,indgen(16)]
      energy[*,i_pol+indgen(16)*4] = oldenergy[*,i_pol,indgen(16)]
      theta[*,i_pol+indgen(16)*4] = oldtheta[*,i_pol,indgen(16)]
      phi[*,i_pol+indgen(16)*4] = oldphi[*,i_pol,indgen(16)]
      gfactor[*,i_pol+indgen(16)*4] = oldgfactor[*,i_pol,indgen(16)]
      eff[*,i_pol+indgen(16)*4] = oldeff[*,i_pol,indgen(16)]
      bins[*,i_pol+indgen(16)*4] = oldbins[*,i_pol,indgen(16)]
      denergy[*,i_pol+indgen(16)*4] = olddenergy[*,i_pol,indgen(16)]
      dtheta[*,i_pol+indgen(16)*4] = olddtheta[*,i_pol,indgen(16)]
      dphi[*,i_pol+indgen(16)*4] = olddphi[*,i_pol,indgen(16)]
   endfor
   domega = 2.*(dphi/!radeg)*cos(theta/!radeg)*sin(.5*dtheta/!radeg)
endif

str_element,/add,d,'nbins',64l
str_element,/add,d,'ntheta',4l
str_element,/add,d,'nphi',16l
str_element,/add,d,'energy',energy
str_element,/add,d,'theta',theta
str_element,/add,d,'phi',phi
str_element,/add,d,'gfactor',gfactor
str_element,/add,d,'eff',eff
str_element,/add,d,'bins',bins
str_element,/add,d,'denergy',denergy
str_element,/add,d,'dtheta',dtheta
str_element,/add,d,'dphi',dphi
str_element,/add,d,'domega',domega
str_element,/add,d,'data',data

return,d

end
